//do a single PCI read
task pci_rds;//single data phase
input [31:0] Address, ExpData;
input [3:0] Cmd, BytEn;
reg [31:0] DataReg;
reg ParReg;
reg [3:0] CbeReg;
begin
$display("Reading Data = %h", ExpData,
           "	From Address = %h", Address,
	   "	at Time = %0t", $time);
@(posedge CLK) begin
	AD_OE = 1'b1;
	CBE_OE = 1'b1;
    	FRAMEn = 1'b0;
    	AD_REG = Address;
    	PCI_CBE_REG = Cmd;
    end //first clock
@(posedge CLK) begin
	AD_OE = 1'b0;
	PAR_OE = 1'b1;
	PAR_REG = (^Address) ^ (^Cmd);
	IRDYn = 1'b0;
	FRAMEn = 1'b1;
	PCI_CBE_REG = BytEn;
    end //2nd clock
@(posedge CLK) PAR_OE = 1'b0;
wait(~TRDYn);
@(posedge CLK) begin
	IRDYn = 1'b1;
	DataReg = PCI_AD;
	ParReg = PCI_PAR;
	FRAMEn = 1'b1;
	if (ExpData != DataReg) $display("ERROR: Expected Data %h", ExpData,
                                         "	Actual Data %h", DataReg,
                                         "	at time = %t", $time);
	if(ParReg != (^DataReg ^ ^PCI_CBE)) $display("Parity Error at %t", $time);
   end
@(posedge CLK) CBE_OE = 1'b0; 
end
endtask