module pci_top(CLK, FRAMEn, IRDYn, IDSEL, TRDYn, STOPn, 
               DEVSELn, PCI_AD, PCI_CBE, PCI_PAR, 
               SR_ADDR, SR_DATA, SRCSn, SROEn, SRWEn, 
	       LOC_REQn, LOC_GNTn, RSTn);	

// this module is a shell instantiating the I/O buffers and the pci_tar design    
   
input  CLK, FRAMEn, IRDYn, IDSEL, RSTn, LOC_REQn; //PCI Bus Declarations   
output TRDYn, STOPn, DEVSELn, PCI_PAR;
inout  [31:0] PCI_AD; //PCI address/data
input  [3:0] PCI_CBE; //PCI command/byte enable    
output [23:2] SR_ADDR;  //SRAM interface Declarations
inout  [31:0] SR_DATA;
output [3:0]  SRWEn;
output SRCSn, SROEn, LOC_GNTn;

//inverting in/output buffers for LOC_GNTn, REQn
wire LOC_REQ = ~LOC_REQn;
outfft1 LGT (CLK, ~LOC_GNT_D, 1'b1, LOC_GNTn);
              
// direct and registered inputs for PCI controls
//inff(d,c,q,o) input flipflop plus non-clocked output
inff1 FRin (FRAMEn, CLK, FRAME_REGn, FRAME_INTn);
inff1 IRin (IRDYn,  CLK, IRDY_REGn, IRDY_INTn);
inff1 IDin (IDSEL,  CLK, IDSEL_REG, NotUsed);
wire [3:0] CBE_REG;   
inff4 CBin (PCI_CBE, CLK, CBE_REG);

// PCI & SRAM registered inputs and outputs
wire [31:0] SR_REG, AD_REG;
outfft32 PCIO (CLK, SR_REG, AD_OE, PCI_AD);
outfft32 SRDO (CLK, AD_REG, SRD_OE, SR_DATA);
inff32 PCIOIN (PCI_AD, CLK, AD_REG);// ad_reg is input reg Qoutput
inff32 SRDOIN (SR_DATA, CLK, SR_REG);// sr_reg is input reg Qoutput

// registered output buffers for the acks
outfft1 stop1 (CLK, STOP_Dn, ACKOE, STOPn);
outfft1 trdy1 (CLK, TRDY_Dn, ACKOE, TRDYn);
outfft1 devs1 (CLK, DEVSEL_Dn, ACKOE, DEVSELn);
outfft1 par1  (CLK, PAR_D, PAROE, PCI_PAR);

//SR_ADDR outputs
wire [3:0]  ADDR_CNT_D;
wire [23:2] SR_ADDR;
wire [23:6] ADDR_REG;
outfft4 ACNT (CLK, ADDR_CNT_D, PCI_GNT, SR_ADDR[5:2]);
assign  SR_ADDR[23:6] = PCI_GNT? ADDR_REG[23:6]: 18'hz_zzzz; 

wire [3:0] SRWE_INTn;
assign SRWEn = PCI_GNT? SRWE_INTn: 4'hz;
assign SRCSn = PCI_GNT? SRCS_INTn: 1'bz;
assign SROEn = PCI_GNT? SROE_INTn: 1'bz;

//ibuf1 BCK (CLK, BCLK); 
wire BCLK = CLK;
// instantiate ibuf for clock input to gates
// CLK will be on GCLK per control file

//instantiate the logic module
pci_tar PCIT (CLK, BCLK, FRAME_REGn, FRAME_INTn, IRDY_REGn,
	       IRDY_INTn, IDSEL_REG, TRDY_Dn, STOP_Dn, 
               DEVSEL_Dn, AD_REG, CBE_REG, PAR_D, 
               ADDR_REG, SR_REG, SRCS_INTn, SROE_INTn, SRWE_INTn, 
	       LOC_REQ, LOC_GNT_D, RSTn, ACKOE, PAROE, ADDR_CNT_D,
	       SRD_OE, AD_OE, PCI_GNT);

endmodule
`include "d:\xilapp\pci\verilog\ibuf1.v"
`include "d:\xilapp\pci\verilog\inff1.v"
`include "d:\xilapp\pci\verilog\inff4.v"
`include "d:\xilapp\pci\verilog\inff32.v"
`include "d:\xilapp\pci\verilog\outfft1.v" 
`include "d:\xilapp\pci\verilog\outfft4.v"  
`include "d:\xilapp\pci\verilog\outfft32.v"
`include "d:\xilapp\pci\verilog\pci_tar.v"