//do a write burst without initiator wait states
task pci_wrm;//Nbeats data phases
input [31:0] Address, DataInit;
input [3:0] Cmd, BytEn;
input [7:0] Nbeats;
integer i;
reg [31:0] Data;
begin
  Data = DataInit;
  $display("Writing Data = %h", Data,
           "	To Address = %h", Address,
           "	at Time = %0t", $time);
  @(posedge CLK) begin
	AD_OE = 1'b1;
	CBE_OE = 1'b1;
    	FRAMEn = 1'b0;
    	AD_REG = Address;
    	PCI_CBE_REG = Cmd;
    end //first clock
  @(posedge CLK) begin
	PAR_OE = 1'b1;
    	AD_REG = Data;
	PAR_REG = (^Address) ^ (^Cmd);
	IRDYn = 1'b0;
	PCI_CBE_REG = BytEn;
    end //2nd clock

  for (i=0; i<Nbeats; i=i+1) begin
    fork
	begin //parity for the previous data
    	    @(posedge CLK) PAR_REG = (^Data) ^ (^BytEn);
        end
        begin //wait TRDY and do next data on every clock until done
 	    wait(~TRDYn);
	    @(posedge CLK);  //next data
	    Data = Data + 1'b1;
	    AD_REG = Data;
	    if(i==(Nbeats-2))FRAMEn = 1'b1;  //last beat has frame high
        end
    join
  end//for
    IRDYn = 1'b1;
    AD_OE = 1'b0;
    PAR_OE = 1'b0;	
    CBE_OE = 1'b0; 
end
endtask