module pipcon(CLK, RSTn, PCI_REQ, PCI_GNT, WRrd, ENDEDn,
		TRDY_SM, INC_ADDR, WRGATE, FRSTWR);

input CLK, RSTn, PCI_REQ, PCI_GNT, WRrd, ENDEDn;
output TRDY_SM, INC_ADDR, WRGATE, FRSTWR;
reg INC_ADDR, INC_ADDR_D, TRDY_SM_D, TRDY_SM, WRGATE, WRGATE_D;
reg [8:0] currstate, nextstate;
assign FRSTWR = currstate[3];
parameter [8:0]	//used to name the state machine's states
	Idle	= 9'b0_0000_0000,
	WaitGt	= 9'b1_1000_0000,
	RdyPip  = 9'b1_0100_0000,
	FstRdy 	= 9'b1_0010_0000,
	FstWrt  = 9'b1_0001_0000,
	RdPip1  = 9'b1_0000_1000,
	RdPip2  = 9'b1_0000_0100,
	WrBurst = 9'b1_0000_0010,
	RdBurst = 9'b1_0000_0001;

parameter [8:0]	//used to implement one-hot state decodes
	T_Idle	  = 9'b0_xxxx_xxxx,
	T_WaitGt  = 9'bx_1xxx_xxxx,
	T_RdyPip  = 9'bx_x1xx_xxxx,
	T_FstRdy  = 9'bx_xx1x_xxxx,
	T_FstWrt  = 9'bx_xxx1_xxxx,
	T_RdPip1  = 9'bx_xxxx_1xxx,
	T_RdPip2  = 9'bx_xxxx_x1xx,
	T_WrBurst = 9'bx_xxxx_xx1x,
	T_RdBurst = 9'bx_xxxx_xxx1;


always @(currstate or PCI_REQ or WRrd or PCI_GNT or ENDEDn)
begin
//transition equations
    nextstate = Idle;
    INC_ADDR_D = 1'b0;
    TRDY_SM_D  = 1'b0;
    WRGATE_D   = 1'b0;
    casex (currstate)
	T_Idle: begin
	    if (~PCI_REQ | ~ENDEDn) nextstate = currstate;
	    else if (~PCI_GNT) begin 
		nextstate = WaitGt;
	    end
	    else if (WRrd) begin 
		nextstate = RdyPip;
		TRDY_SM_D = 1'b1;
	    end
	    else nextstate = RdPip1;
	end

	T_WaitGt: begin	//wait here until sram granted to PCI
	    if(~PCI_GNT) nextstate = currstate;
	    else if (WRrd) begin
		nextstate = RdyPip;
		TRDY_SM_D = 1'b1;
	    end
	    else if (~WRrd) begin
		nextstate = RdPip1;
		INC_ADDR_D = 1'b1;	
	    end
	end

	T_RdyPip: begin		//start TRDY# assertion pipe 
		nextstate = FstRdy;
		TRDY_SM_D = 1'b1;
	end
		
        T_FstRdy: begin       //TRDY_Dn asserts
		nextstate = FstWrt;
		TRDY_SM_D = 1'b1;
	    end	

	T_FstWrt: begin		//TRDY# asserts
		if(~ENDEDn) nextstate = Idle;
		else begin
		    nextstate = WrBurst;
		    WRGATE_D = 1'b1;
		    INC_ADDR_D = 1'b1;
		    TRDY_SM_D = 1'b1;
		end
	    end

	T_WrBurst: begin
	//one word written every cycle in this state
	//unless IRDYn=H in which case WRGATE & INCADDR are inhibited in pci_tar
	    if (~ENDEDn) nextstate = Idle;
	    else begin
		    nextstate = currstate;	
		    INC_ADDR_D = 1'b1;
		    WRGATE_D = 1'b1;
		    TRDY_SM_D = 1'b1;
		end
	end 

	T_RdPip1: begin		//delay for addr oe
		nextstate = RdPip2;
		INC_ADDR_D = 1'b1;	
		TRDY_SM_D = 1'b1;
	    end	

	T_RdPip2: begin		// delay for pipe
		nextstate = RdBurst;
		INC_ADDR_D = 1'b1;	
		TRDY_SM_D = 1'b1;
	    end	

	T_RdBurst: begin
	// transfer one word each cycle in this state
	// unless ENDEDn or STOPn asserts
	    if (~ENDEDn) nextstate = Idle;
	    else begin
		nextstate = currstate;	
		INC_ADDR_D = 1'b1;
		TRDY_SM_D  = 1'b1;
	    end
	end
    endcase
end

//instantiate the state register 
always @(posedge CLK or negedge RSTn)
begin
    if(~RSTn)begin
	currstate <= Idle;
	INC_ADDR  <= 1'b0;
    	WRGATE    <= 1'b0;
	TRDY_SM   <= 1'b0;
    end
    else begin
	currstate <= nextstate;
	INC_ADDR  <= INC_ADDR_D;
    	WRGATE    <= WRGATE_D;
	TRDY_SM   <= TRDY_SM_D;
    end
end
endmodule