// this module models a 4K byte,8 bit wide static ram 
// 15 ns access time, 5 ns OE time is modelled
// puts out inverted data from selection until access time
module sram(Address, Data, SROEl, SRCSl, SRWEl);
input [11:0] Address;
inout [7:0] Data;
input SROEl, SRCSl, SRWEl;
wire [11:0] Addr = Address;
reg  [7:0] RdData;
reg [7:0] SramMem [0:4095];  
reg RdSramDly;
wire [7:0] FlpData, Data;
assign FlpData = (RdFlip) ? ~RdData: RdData;
assign Data  = (RdSramDly) ? FlpData: 8'hzz;
wire RdSram = ~SROEl & ~SRCSl;
wire WrSram = ~SRWEl & ~SRCSl;
always @(RdSram) begin #5; RdSramDly = RdSram; end
always @(Addr) begin  //source inverted data from addr to access time
    RdFlip = 1;
    #15;	//address access time
    RdFlip = 0;
end
always @(Addr or negedge WrSram or RdSram) RdData = SramMem[Addr]; 
always @(posedge WrSram) begin		//needed to work arnd invisible edges
	#9;                            //this filters out simulator artifacts 
	if(WrSram) SramMem[Addr] = Data; 
end
initial RdSramDly = 0;    
endmodule