//test shell for the PCI Target
module t_pcitar;
reg CLK, FRAMEn, IRDYn, IDSEL, RSTn;   //PCI Bus Input Signal Declarations   
reg [3:0] PCI_CBE_REG; //PCI command/byte enable    
wire [31:0] PCI_AD; //PCI address/data
wire TRDYn, STOPn, DEVSELn, PCI_PAR;
wire [3:0] PCI_CBE;
reg [31:0] AD_REG;
reg AD_OE, PAR_OE, PAR_REG, CBE_OE, LOC_REQn;
reg [3:0]  PCI_CBE_REG;
wire [23:2] SR_ADDR;
wire [31:0] SR_DATA;
wire [3:0] SRWEn;

pullup  (PCI_CBE[3]), (PCI_CBE[2]), (PCI_CBE[1]), (PCI_CBE[0]);
pullup (STOPn), (DEVSELn), (PCI_PAR), (TRDYn);

pullup (SR_DATA[31]), (SR_DATA[30]), (SR_DATA[29]), (SR_DATA[28]);
pullup (SR_DATA[27]), (SR_DATA[26]), (SR_DATA[25]), (SR_DATA[24]);
pullup (SR_DATA[23]), (SR_DATA[22]), (SR_DATA[21]), (SR_DATA[20]), (SR_DATA[19]);
pullup (SR_DATA[18]), (SR_DATA[17]), (SR_DATA[16]), (SR_DATA[15]), (SR_DATA[14]);
pullup (SR_DATA[13]), (SR_DATA[12]), (SR_DATA[11]), (SR_DATA[10]);
pullup (SR_DATA[9]),  (SR_DATA[8]),  (SR_DATA[7]), (SR_DATA[6]), (SR_DATA[5]);
pullup (SR_DATA[4]),  (SR_DATA[3]),  (SR_DATA[2]), (SR_DATA[1]), (SR_DATA[0]);

pullup (PCI_AD[31]), (PCI_AD[30]), (PCI_AD[29]), (PCI_AD[28]);
pullup (PCI_AD[27]), (PCI_AD[26]), (PCI_AD[25]), (PCI_AD[24]);
pullup (PCI_AD[23]), (PCI_AD[22]), (PCI_AD[21]), (PCI_AD[20]), (PCI_AD[19]);
pullup (PCI_AD[18]), (PCI_AD[17]), (PCI_AD[16]), (PCI_AD[15]), (PCI_AD[14]);
pullup (PCI_AD[13]), (PCI_AD[12]), (PCI_AD[11]), (PCI_AD[10]);
pullup (PCI_AD[9]),  (PCI_AD[8]),  (PCI_AD[7]), (PCI_AD[6]), (PCI_AD[5]);
pullup (PCI_AD[4]),  (PCI_AD[3]),  (PCI_AD[2]), (PCI_AD[1]), (PCI_AD[0]);
pullup (SRCSn), (SROEn), (SRWEn[3]), (SRWEn[2]), (SRWEn[1]), (SRWEn[0]);

assign PCI_AD = AD_OE? AD_REG: 32'hzzzz_zzzz;
assign PCI_PAR = PAR_OE? PAR_REG: 1'bz;
assign PCI_CBE = CBE_OE? PCI_CBE_REG: 4'hz;

// define pci command codes for rd, wr tasks
`define IACK	4'b0000
`define SPCL	4'b0001
`define IORD	4'b0010
`define IOWR	4'b0011
`define MEMRD	4'b0110
`define MEMWR	4'b0111
`define CFGRD	4'b1010
`define CFGWR	4'b1011
`define LINRD	4'b1110
`define MULRD	4'b1100
`define WRINV	4'b1111

//************ PCI TARGET MODULE ************************************* 
pci_top PTOP (CLK, FRAMEn, IRDYn, IDSEL, TRDYn, STOPn, 
               DEVSELn, PCI_AD, PCI_CBE, PCI_PAR,
               SR_ADDR, SR_DATA, SRCSn, SROEn, SRWEn, 
	       LOC_REQn, LOC_GNTn, RSTn);	

//************ Shared SRAM *****************************************
sram SR0(SR_ADDR[13:2], SR_DATA[31:24], SROEn, SRCSn, SRWEn[0]);
sram SR1(SR_ADDR[13:2], SR_DATA[23:16], SROEn, SRCSn, SRWEn[1]);
sram SR2(SR_ADDR[13:2], SR_DATA[15:8],  SROEn, SRCSn, SRWEn[2]);
sram SR3(SR_ADDR[13:2], SR_DATA[7:0],   SROEn, SRCSn, SRWEn[3]);

always @(CLK) CLK <= #15 ~CLK;

//************** STIMULUS **************
initial
begin
    RSTn = 1'b0;
    AD_OE = 1'b0;
    PAR_OE = 1'b0;
    PAR_REG = 1'b0;
    AD_REG = 32'b0;
    PCI_CBE_REG = 4'b0;
    CBE_OE = 1'b1;
    CLK = 1'b0;
    FRAMEn = 1'b1;
    IRDYn = 1'b1;
    IDSEL = 1'b0;
    LOC_REQn = 1'b1;
    #15 CLK = 1'b1;
    #315 RSTn = 1'b1;
    @(posedge CLK);
    @(posedge CLK);
    @(posedge CLK);
    // do a config space cycle to write base address register
    IDSEL = 1'b1;
        	//Address, Data Cmd, BytEn;
    //pci_wrs task performs a single write cycle to
    //        address          data       cycle    byte enables
    pci_wrs(32'h0000_0010, 32'hf000_0000, `CFGWR, 4'h0);

    @(posedge CLK);
    IDSEL = 1'b0;
    pci_wrs(32'hf000_006c, 32'h5555_aaaa, `MEMWR, 4'h0);
    @(posedge CLK);
    @(posedge CLK);

    // single read cycle
    //        address     expected  data   cycle   byte enables
    pci_rds(32'hf000_006c, 32'h5555_aaaa, `MEMRD, 4'h0);
    @(posedge CLK);
    //burst write with an initiator wait state
    pci_wrwt(32'hf000_0040, 32'h5555_aa00, `MEMWR, 4'h0, 8'h0c);

    pci_rds(32'hf000_005c, 32'h5555_aa07, `MEMRD, 4'h0);

    //burst read
    pci_rdm(32'hf000_0040, 32'h5555_aa00, `MEMRD, 4'h0, 8'h0c);
    LOC_REQn = 1'b0;
    @(posedge CLK);
    @(posedge CLK);
    fork	// cause contention for sram
	begin     @(posedge CLK);    @(posedge CLK);     LOC_REQn = 1'b1; end
    	pci_wrs(32'hf000_0044, 32'haaaa_5555, `MEMWR, 4'h0);
    join
    LOC_REQn = 1'b0;
    @(posedge CLK);
    @(posedge CLK);
    fork	// cause contention for sram
	begin    
		@(posedge CLK);
	    	@(posedge CLK);  
		@(posedge CLK);
	    	@(posedge CLK); 
		LOC_REQn = 1'b1;
	end
    	pci_rds(32'hf000_0044, 32'haaaa_5555, `MEMRD, 4'h0);
    join
    LOC_REQn = 1'b0;
    @(posedge CLK);
    @(posedge CLK);
    fork	// cause contention for sram
	begin     
		@(posedge CLK);    
		@(posedge CLK);     
		LOC_REQn = 1'b1; 
		@(posedge CLK);    
		@(posedge CLK);     
		LOC_REQn = 1'b0;
		@(posedge CLK);    
		wait(~LOC_GNTn); 
		@(posedge CLK);    
		@(posedge CLK);    
		LOC_REQn = 1'b1;
	end
	begin
    		pci_wrm(32'hf000_0140, 32'h5555_aa00, `MEMWR, 4'h0, 8'h08);
    		pci_rdm(32'hf000_0140, 32'h5555_aa00, `MEMRD, 4'h0, 8'h08);
	end
    join
    // do a write burst terminated by assertion of STOP#
    writstop(32'hf000_014c, 32'h5555_100c, `MEMWR, 4'h0);
    #300 $stop;
end //initial
// include the test tasks
`include "pci_wrs.v"
`include "pci_rds.v"
`include "pci_wrm.v"
`include "pci_wrwt.v"
`include "pci_rdm.v"
`include "writstop.v"
endmodule
// include the logic modules and sram models
`include "pci_top.v"
`include "sram.v"
