/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC2000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-FLIP-FLOP
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Nasir Junejo
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
       
`delay_mode_path
 
`timescale  1 ns / 100 ps 
`celldefine     
module ifd (q, c, d, prld);

    parameter size = 1;
    
    output   q;

    input    c, d, prld;

`protect

    tri0 prld;

    reg  NOTIFY_REG;
    
         // use a FF UDP that is set to 1 on simulation time 0
	// This model sets to 1 when prld is high.
         U_FD_P_R_S_NO_I1 INST1 (q, d, c, 1'b0, prld, NOTIFY_REG);
            
    
    specify

    // Specify path delays

	// d->q delay on posedge of clock
	if (!prld)
	    (posedge c => (q +: d)) = (1, 1);

	// reset FF,  q->0 delay
	(posedge prld => (q +: 1'b0)) = (1, 1);
      
      
    // Timing Checks
     
	// setup and hold checks between d and the rising edge of clock when gr=1
	$setuphold(posedge c &&& ~prld, d, 1, 1, NOTIFY_REG);
 
	// setup and hold checks between the rising edge of gr and the rising edge of clock
	$setuphold(posedge c &&& ~prld, prld, 1, 1, NOTIFY_REG);
 
    // pulse width checks

	// clock high time when prld=0
	$width(posedge c &&& ~prld, 1, 1, NOTIFY_REG);

	// clock low time when prld=0
	$width(negedge c &&& ~prld, 1, 1, NOTIFY_REG); 

	// prld high time
	$width(posedge prld, 1, 1, NOTIFY_REG);

    endspecify

`endprotect

endmodule
`endcelldefine


