/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993 and 1994 by      *
* Cadence Design Systems .                                                    *
*  All Rights Reserved.                                                       *
*******************************************************************************/

/*

LIBRARY        : Xilinx XC7000 Library  - Rev 2.0 - Mar 1994.
FUNCTION       : D-LATCH WITH GLOBAL RESET (GR)
REFERENCE      : The XNF Simulation Guide Dated Ver. 5.00 08/13/93.
                 
DESIGNER       : Udi Landen
DATE GENERATED : 1st Mar 1994 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/


`delay_mode_path

`timescale  1 ns / 100 ps
`celldefine 
module ild (q, d, g, prld);

    parameter size = 1;
    
    output   q;
    
    input    d, g, prld;

`protect

    // if not connected, default to 1
    tri0     prld;

    reg  NOTIFY_REG;
  
        // use a LATCH UDP that is preset to 1 on simulation time 0
        U_LD_P_S_I1 INST1 (q, d, g, prld, NOTIFY_REG);
            
    specify
    
    // Specify path delays
     
	if (!prld && g)
	    (d +=> q) = (1, 1);

	if (!prld)
	    (posedge g  => (q +: d))    = (1, 1);
  
	(negedge prld => (q +: 1'b0)) = (1, 1);

//	if (g)
//	    (posedge prld => (q +: d))    = (1, 1);
       
      
     // Timing Checks
     
	// setup and hold checks between d and the falling edge of g 
	// when prld=1 clr=0 pre=0
	$setuphold(negedge g &&& prld, d, 1, 1, NOTIFY_REG);
     
	// setup and hold checks between the rising edge of prld and the falling edge of g
	$setuphold(negedge g &&& prld, prld, 1, 1, NOTIFY_REG);

	// g high time when prld=1
	$width(posedge g &&& prld, 1, 1, NOTIFY_REG);

	// prld low time
	$width(negedge prld, 1, 1, NOTIFY_REG);
   
    endspecify

`endprotect

endmodule
`endcelldefine
    


