BEGIN {
  read_mba_file();
  write_mba_file();
}

function read_mba_file() {
  i = 1;
  num_mba_props = 0;
  while (getline < mbafile > 0) {
    if( $1 != "#!header" ) {
      mba_path[i] = $1;
      mba_type[i] = $2;
      mba_prop[i] = $3;
      mba_val[i] = $4;
      # convert $37$ -> %, modified for Solution 618;
      converted = 1;
      while ( converted == 1 )
        converted = sub("[$]37[$]", "%", mba_path[i]);
      # end modified portion
      if ( num_mba_props == 0 ) {
        mba_props_name[++num_mba_props] = mba_prop[i];
        if ( mba_prop[i] == "RISE" || mba_prop[i] == "FALL" )
          mba_props_obj[num_mba_props] = "PIN";
	else
          mba_props_obj[num_mba_props] = "INSTANCE";
        mba_props_type[num_mba_props] = mba_type[i];
      }
      else {
	for ( j = 1; j <= num_mba_props; j++ ) {
          found = 0;
	  if ( mba_prop[i] == mba_props_name[j] ) {
	    # it's already in mba_props - don't add it.
	    found = 1;
	    break;
	  }
	}
	if ( found == 0 ) {
          mba_props_name[++num_mba_props] = mba_prop[i];
          if ( mba_prop[i] == "RISE" || mba_prop[i] == "FALL" )
            mba_props_obj[num_mba_props] = "PIN";
	  else
            mba_props_obj[num_mba_props] = "INSTANCE";
          mba_props_type[num_mba_props] = mba_type[i];
	}
      }
      i++
    }
  }
  num_mba_recs = i - 1
}
 
function find_prop_num(type,prop) {
  for ( k = 1; k <= num_mba_props; k++ ) {
    if ( mba_props_type[k] == type && mba_props_name[k] == prop )
      return k
  }
  exit 1
}

function write_mba_file() {
  printf ( "#!header 1.0\n");
  for ( i = 1; i <= num_mba_props; i++ ) {
    printf ( "#!property %s \t %s \t %s \t %d\n", mba_props_name[i], mba_props_obj[i], mba_props_type[i], i );
  }
  for ( i = 1; i <= num_mba_recs; i++ ) {
    j = find_prop_num(mba_type[i],mba_prop[i]);
    printf ( "%s \t %d \t %s\n", mba_path[i], j, mba_val[i] );
  }
}