library synth;
use synth.stdsynth.ALL;

entity bcd_count is
  port (
    signal reset, up_enable, clk        :  in           vlbit;
    signal cout                         :  out          vlbit;
    signal bcd                          :  inout        vlbit_1d(3 downto 0)
  );
end bcd_count;

architecture first of bcd_count is
    constant trans_tbl : vlbit_2d(0 to 11, 7 downto 0 ) := (
--
--            in   out
-----------------+----------------------
           B"0000_0001",
           B"0001_0010",
           B"0010_0011",
           B"0011_0100",
           B"0100_0101",
           B"0101_0110",
           B"0110_0111",
           B"0111_1000",
           B"1000_1001",
           B"1001_0000",
           B"101X_XXXX",  -- Error
           B"11XX_XXXX"
					);
   signal incz, muxz    : vlbit_1d (3 downto 0);

begin
    pla_table (bcd, incz, trans_tbl);
    muxz <= incz WHEN ('1' = up_enable) ELSE
            bcd ;
    cout <= '1' WHEN (('1' = up_enable) AND (incz = B"0000")) ELSE
            '0';
    dffc_v (muxz, reset, clk, bcd);

end first;
