library synth;          -- Used for simulation
use synth.stdsynth.all;

-- Entity: Input and Output Declarations.
-------------------------------------------------

entity fsm_case is
   port (
     signal reset, clk, data_in      : in vlbit;
     signal pmatch                   : out vlbit
   );
end fsm_case;
-------------------------------------------------
-- The architectural body - behavioral description.

architecture first of fsm_case is
  constant S0: vlbit_1d(2 downto 0) := 0;
  constant S1: vlbit_1d(2 downto 0) := 1;
  constant S2: vlbit_1d(2 downto 0) := 2;
  constant S3: vlbit_1d(2 downto 0) := 3;
  constant S4: vlbit_1d(2 downto 0) := 4;
  constant S5: vlbit_1d(2 downto 0) := 5;

  signal next_state :vlbit_1d(2 downto 0);
  signal state      :vlbit_1d(2 downto 0);

begin
  cntl: process(data_in, state)
  begin
    pmatch <= '0';
    next_state <= S0;
-------------------------------------------------
-- Begin CASE statement

   case state is

        when S0 => 
          if ((not data_in) = '1') then
            next_state <= S0;
          else
            next_state <= S1;
          end if;

        when S1 => 
          if ((not data_in) = '1') then
            next_state <= S0;
          else
            next_state <= S2;
          end if;
  
        when S2 =>
          if ((not data_in) = '1') then
            next_state <= S0;
          else
            next_state <= S3;
          end if;
  
        when S3 =>
          if ((not data_in) = '1') then
            next_state <= S4;
          else
            next_state <= S3;
          end if;
  
        when S4 =>
          if ((not data_in) = '1') then
            next_state <= S5;
          else
            next_state <= S1;
          end if;
  
        when S5 => 
          pmatch <= '1';
          if ((not data_in) = '1') then
            next_state <= S0;
          else
            next_state <= S1;
          end if;

        when others => next_state <= S0;
--      when others => null;
      end case;
  end process cntl;

-- Seperate clocked process
-------------------------------------------------
--state<=next_state
  cntl_clk: process
  begin
	wait until (prising(clk) or (reset = '1'));
	if (reset = '1') then
          state <= S0;
        else
          state <= next_state;
        end if;
        end process cntl_clk;

end first;
