Library synth;
Use synth.stdsynth.all;

-- Entity Declaration --- Declare Ports 
--------------------------------------- 
entity	 fsm_enc_pla is 	port (
		signal reset, clk, data_in	: in vlbit;
		signal pmatch			: out vlbit
	);
end fsm_enc_pla;
----------------------------------------------------
-- Architectural behavioral description

architecture first of fsm_enc_pla is
signal S, NXT_S	: vlbit_1d (2 downto 0);
signal tmp	 : vlbit_1d (3 downto 0);

constant tbl : vlbit_2d (0 to 11, 6 downto 0) := (

--S  |d| NXT_S
--210| | 210 
-----+-+---------------------------
B"000_1_001", 	-- S0 & 1 => S1
B"000_0_000", 	-- S0 & 0 => S0
B"001_1_010", 	-- S1 & 1 => S2
B"001_0_000",   -- S1 & 0 => S0
B"010_1_011", 	-- S2 & 1 => S3
B"010_0_000", 	-- S2 & 0 => S0
B"011_1_011",	-- S3 & 1 => S3
B"011_0_1X0", 	-- S3 & 0 => S4
B"1X0_1_001", 	-- S4 & 1 => S1
B"1X0_0_1X1", 	-- S4 & 0 => S5
B"1X1_1_001", 	-- S5 & 1 => S1
B"1X1_0_000" );	-- S5 & 0 => S0
begin
	pmatch <= S(0) AND S(2);        -- (S= "1X1"); 
	tmp <= S&data_in;
	pla_table (tmp, NXT_S, tbl);

------------------------------------------------------------
-- Seperate Clocked Process --
cntl: process
	begin
	wait until (prising(clk) or (reset = '1'));
	if (reset = '1') then
		S <= "000"; -- reset => S0
	else
 		S <= NXT_S;
	end if;
end process cntl;

end first;

