library synth;
use synth.stdsynth.ALL;

entity seven0 is
  port (
    signal bcd     :  in vlbit_1d(3 downto 0);
    signal seg     : out vlbit_1d(6 downto 0)
  );
end seven0;

architecture first of seven0 is
    constant tbl : vlbit_2d(0 to 9, 10 downto 0 ) := (
--
--         2
--       1   3
--         6
--       0   4
--         5
--      bcd(3:0) |  seg(6:0)
-----------------+----------------------
           B"0000_0111111", --  (digit 0)
           B"0001_0011000", --  (digit 1)
           B"0010_1101101", --  (digit 2)
           B"0011_1111100", --  (digit 3)
           B"0100_1011010", --  (digit 4)
           B"0101_1110110", --  (digit 5)
           B"0110_1110111", --  (digit 6)
           B"0111_0011100", --  (digit 7)
           B"1000_1111111", --  (digit 8)
           B"1001_1111110"  --  (digit 9)
					);
begin
    pla_table( bcd, seg, tbl );
end first;
