------------------------------------------------------------------------
entity top is
  port(rst    : in vlbit;
       clock  : in vlbit;
       data   : in vlbit;
--     control: in vlbit;
       seg1   : out vlbit_1d(6 downto 0));  -- seven segment display
end top;

------------------------------------------------------------------------
architecture struct of top is
  component sevenx
    port (
      signal bcd   :    in vlbit_1d(3 downto 0);
      signal seg   :   out vlbit_1d(6 downto 0)
    );
  end component;
    
  component fsm_enc_pla
    port (
      signal reset, clk, data_in  : in vlbit;
      signal pmatch               : out vlbit
    );
  end component;
    
  component bcd_count
    port (
      signal reset, up_enable, clk :  in           vlbit;
      signal cout                  :  out          vlbit;
      signal bcd                   :  inout        vlbit_1d(3 downto 0)
    );
  end component;

  signal n1_net :vlbit;
  signal n2_net :vlbit_1d(3 downto 0);

begin
  c1: fsm_enc_pla
    port map (
      reset   => rst,
      clk     => clock,
      data_in => data,
      pmatch  => n1_net);

  c2: bcd_count
    port map (
      reset     => rst,
      up_enable => n1_net,
      clk       => clock,
      bcd       => n2_net,
      cout      => OPEN);
      
  c3: sevenx
    port map (
      bcd        => n2_net,
      seg        => seg1);
end struct;
------------------------------------------------------------------------
------------------------------------------------------------------------
