# ppr.ml created 1994/05/13 21:51:06
# 
# DO NOT EDIT THIS FILE!  It is derived from other files.
#
# ------------------ alert.m ------------------ 
#
#@(#)alert.m	6.1  12/2/92


B ALERT
: Error condition alert system

#
# These messages are used as alert pre/postfixes
#
M CANNOT_CONTINUE
: Execution cannot continue until this error is fixed
M TERMINATE
> theProgram s
> theStatus s
: [theProgram] was terminated with a [theStatus] status

E ALERT
#
# ------------------ feature.m ------------------ 
#
# @(#)feature.m	6.3 9/3/93


B FEATURE -start1051 -end1100 -current1082
: Feature License Manager

#
# Nasty Low-Level Error Messages
#
M UNKNOWN_ERROR -e1051
> feature s
: License checkout for feature "[feature]" failed[.br]
: because of some, unknown error condition.  
: Please contact your system administrator for help.
M OS_ERROR -e1052
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level or operating system error ([errtext]).
: Please contact your system administrator for help.
M BAD_SERVER_DATA_ERROR -e1053
> feature s
: License checkout for feature "[feature]" failed[.br]
: because invalid data was returned from the license server .
: Please contact your system administrator for help.
M READ_SERVER_ERROR -e1054
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot read from the servers listed in the license data 
: file.  Please contact your system adminstrator for help.
M WRITE_SERVER_ERROR -e1055
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot write to the servers listed in the license data 
: file.  Please contact your system adminsitrator for help.
M SELECT_ROUTINE_ERROR -e1056
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] a call to an internal select routine failed.
: Please contact your system adminsitrator for help.
M BUSY_SERVER_ERROR -e1057
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] failed to connect to a majority of the servers listed in the
: license data file.  Please contact your system adminsitrator for help.
M CHECKIN_FEATURE_ERROR -e1058
> feature s
: License checkin for feature "[feature]" failed[.br]
: Don't worry, be happy.

#
# Possible User Errors
#
M NO_LICENSE_FILE_ERROR -e1059
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the license data file.
: The default location for this file is usually
: /usr/local/data/license.dat.  It may be placed elsewhere at your site, in 
: which case you must define the environmental variable LM_LICENSE_FILE to
: point to it.  Make sure you can access the file from the same shell you are
: trying to run the program.
M NO_FEATURE_ERROR -e1060
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the feature in the license data
: file.  If you have not yet called customer
: service to obtain the authorization codes for this feature please do so.  If
: you have obtained the codes, please make sure that you have added the codes
: to the license data file.
M LICENSES_EXHAUSTED_ERROR -e1061
> feature s
: License checkout for feature "[feature]" failed[.br]
: because all the valid licenses for the feature are currently in use.  
: Try again later.
M EXPIRED_AUTHCODE_ERROR -e1062
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the required license has expired.  
: Please call customer service to obtain a new license.
M UNSUPPORTED_VERSION_ERROR -e1063
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the license data file does not contain a feature of the required
: version number.  Please call custommer service to obtain a license for 
: the new version of the feature.
M NO_KEY_ERROR -e1064
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program could not find a valid Xilinx protection key
: on the parallel port of your computer.  
: Please make sure that the key is attached securely to the parallel port.
M TAMPERED_KEY_ERROR -e1065
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program detected an invalid Xilinx protection key
: on the parallel port of your computer.  
: The key's memory has been corrupted.  Please call customer service to
: obtain a new key.
M DEMO_EXPIRED_ERROR -e1066
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because your demo version of the [program] program has expired.
: Please contact customer service
: or your sales representative to purchase the software you have been
: using.
M TAMPERED_DATE_ERROR -e1067
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the current date on your computer is set to a time which is
: before the date when you last ran this program.   
: Please reset your computer's date to the current
: date and rerun the program.
M XACT_VARIABLE_ERROR -e1068
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the XACT environmental variable has not been defined.
: Use the SET XACT=value dos command 
: to define the location of the XACT software.
M INVALID_DATE_ERROR -e1069
> feature s
: License checkout for feature "[feature]" failed[.br]
: because line in the license data file line which describes the feature
: contains an invalid date.  See the file XACT\data\license.dat.  
: All dates must be of the form 
: DD-MMM-YYYY, where DD is an integer 0-31; MMM is the first three 
: letters of the (English) month name: JAN, FEB, MAR, APR, MAY, JUN, JUL,
: AUG, SEP, OCT, NOV, or DEC; and YYYY is an integer 1990-2118.
M LOLEVEL_ERROR -e1070
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level error ([errtext]).

#
# Possible Installation Errors
#
M MULT_FEATURE_ERROR -e1071
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected multiple occurences of FEATURE lines for the 
: feature in the license file.  A feature
: may appear only once in the license file for it to be valid.  Please remove
: one of the feature lines from the license file.
M LICENSE_FILE_SYNTAX_ERROR -e1072
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected a syntax error in the license date
: file.  Please make sure that you have 
: correctly entered the authorization codes which you obtained from customer 
: service.
M NO_SERVER_ERROR -e1073
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect to the network license server.  
: Please make sure that the lmgrd program is 
: currently running on the computers described as servers in the license data 
: file.
M NO_SERVICE_ERROR -e1074
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the program [program] could not find the TCP "license" service. 
: Make sure that the /etc/services file has
: the license service number defined in it, or add a socket number to the the
: SERVER line of the license data file.
M BAD_AUTHCODE_ERROR -e1075
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected an inconsistency in the authorization code on the
: feature line of the license data file.  
: Please make sure that you have correctly entered the authorization codes
: which you obtained from customer service.
M WRONG_HOST_ERROR -e1076
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the host listed in one of the
: server lines of the license data file.  
: Please make sure that the server information in the license data file is 
: correct.
M BAD_DATE_ERROR -e1077
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] found an invalid date in the license data file.  
: Please make sure that the date information in the
: license data file is correct.  The correct date format is DD-MMM-YY (for
: example 30-JUN-91).  In previous versions of the program, dates of the form
: DD-MMM-YYYY were acceptable, but they are no longer.  To make the correction,
: stop the license server, edit the license.dat file to remove the '19' from
: the year number of all features, restart the license server and rerun the 
: program.
M NO_SERVER_LINES_ERROR -e1078
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find and server lines in the license data file.  
: Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M BAD_SERVER_NAME_ERROR -e1079
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] encountered an illegal server name in the license 
: data file.  Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M CONNECT_SERVER_ERROR -e1080
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect over the network to the license server
: program.  Please make sure that the lmgrd 
: program is currently running on the computers described as servers in the
: license data file.

#
# Error due to PC key
#
M PC_KEY_ERROR -e1081
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: [errtext]

E FEATURE
#
# ------------------ msg.m ------------------ 
#
#@(#)msg.m	6.3 9/3/93


B MSG -start1011 -end1030 -current1016
: The Message System Messages

#
# Message fragments for the MSGFILE error
M MSGIO_EOLJUNK
: Extra characters at the end of a valid line
M MSGIO_UNKNOWN_LINE
: Unknown message file line type
M MSGIO_MSGSET_NAME
: Message set name is required
M MSGIO_MSGDEF_NAME
: Message definition name is required
M MSGIO_MSGARG_NAME
: Message definition argument name is required
M MSGIO_MSGARG_TYPE
: Message definition argument type is required
M MSGIO_UNKNOWN
: Unknown error number

#
# These messages are used by the message system when something goes
# wrong while reading a message file, or instantiating a message
#

M MSGFILE_ERROR -e1011
> theErrorName  m
> theLineNumber d
> theFileName   s
> theLine       s
> thePosition   z
: [theErrorName][.br]
: The error is on Line [theLineNumber] of "[theFileName]"[.br]
: The line is "[theLine]"[.br]
: -------------[thePosition]
M MSGSET_MISSING -e1012
> theCompName s
: The message set for "[theCompName]" does not exist [.br]
: in any of the standard message files.
M MSGSET_NULL
> theCompNumber d
> theCompName s
: The message set pointer for component [theCompNumber], "[theCompName]"[.br]
: does not point to a valid message set.
M MSGSET_NDEFS -e1013
> theMsgnum d
> theMsgname s
> theNumberOfDefs d
> theCompName s
: An attempt was made to invoke message "[theMsgname]",[.br]
: with a message number of [theMsgnum].  However, the message set for[.br]
: component "[theCompName]" has only [theNumberOfDefs] messages.
M MSGSET_MSGNAMES -e1014
> theMsgnum d
> theMsgname s
> theRealMsgname s
> theCompName s
: Message #[theMsgnum] of the message set for component "[theCompName]"[.br]
: was invoked with a name of "[theMsgname]".  Its name in the message[.br]
: file is "[theRealMsgname]".
M MSGSET_NPARAMS -e1015
> theMsgname s
> theNparams d
> theRealNum d
> theCompName s
: Message "[theMsgname]" of the message set for component "[theCompName]"[.br]
: was invoked with [theNparams] parameters.  It is defined with [theRealNum]
: in the message file.

#
# Message id severity names
# These are used in the creation of errors to describe how severe the
# error really is.  THE ORDER OF THESE NAMES IS VERY, VERY IMPORTANT.
# SEE MSGINST_SEVERITY IN MSGINST.C IF YOU DON'T BELIEVE ME.
#

M MSGSEV_INFO
: Information
M MSGSEV_WARNING
: WARNING
M MSGSEV_ERROR
: ERROR
M MSGSEV_FATAL
: Fatal Error
M MSGSEV_INTERNAL
: Internal Error

E MSG
#
# ------------------ mxcomm.m ------------------ 
#
# @(#)mxcomm.m	6.2  9/3/93


B MXCOMM -start1001 -end1010 -current1003
: Mx Program Communications

# Boolean values
M TRUE_VALUES
: Y YES T TRUE ON
M FALSE_VALUES
: N NO F FALSE OFF

# These two messages are used in rwdict error messages
M STARTUP_NAME
: startup file

# These error messages are used by mxaccs directly
M STARTUP_OPEN_FAILED -e1001
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: exists, but could not be opened for some reason

M NO_STARTUP_FILE -e1002
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: does not exist, so it could not be opened

E MXCOMM
#
# ------------------ report.m ------------------ 
#
#@(#)report.m	6.1  12/2/92
 
 
B REPORT
: Report Generator Messages
 
M PAGE
: Page
M CONTINUED
: (continued)
M XILINX
: Xilinx, Inc.
M COPYRIGHT
> year d
: (c) Copyright [year].  All Rights Reserved.
M TABLE_OF_CONTENTS
: Table of Contents[.br]
: -----------------[.br]
M TOC_ENTRY
> entry s
: [entry]
E REPORT
#
# ------------------ rwdict.m ------------------ 
#
#TMF 1.0
# @(#)rwdict.m	6.2  9/3/93


B RWDICT -start1031 -end1050 -current1035
: Dictionary File Reader/Writer

M MISSING_EQUALSIGN -e1031 -w1032
> linenumber d
> filename   s
> dicttype   s
> line       s
: Missing equal sign in the name-value assignment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[line]"

M ILLEGAL_NAME -e1033 -w1034
> linenumber d
> filename   s
> dicttype   s
> name       s
: Illegal name used in the name-value assigment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[name]"


E RWDICT
#
# ------------------ ppr.m ------------------ 
#
#@(#)ppr.m	6.54  4/20/94


B PPR -start11201 -end12200 -current11223
: XC4000 and 3KA/L Partition, Place, and Route

# Tool description (for program help)
M DESCRIPTION
: For an XC4000 design, PPR partitions, places and routes an input [.br]
: XTF netlist. For an XC3000A, XC3000L or XC3100A design, PPR places [.br]
: and routes an input MAP netlist (created by XNFMAP). [.br]
: USAGE:  PPR <design> [[<parameter>=<value> ...]

# External Parameter Names and Help Messages

M MCELL
: Name of the design to partition, place, and route.

M HCELL
: An XTF extension is assumed.

M MPARTTYPE
: Target LCA device and package.

M HPARTTYPE
: If no part type is specified in the design file, this option must be used
: to specify the part type. If there is a parttype specified in the design
: file, this option may be used to override it.

M MJUSTFLATTEN
: Merge in hard macros without doing place and route.

M HJUSTFLATTEN
: If TRUE, PPR creates an unrouted LCA file for unit-delay simulation.

M MESTIMATE
: Evaluate the fitness of a part; don't place+route.

M HESTIMATE
: If the user selects a parttype, PPR evaluates how well it fits the given
: design, and generates a report (without doing place and route).

M MPATH_TIMING
: Use path analysis to guide implementation.

M HPATH_TIMING
: If path_timing is set to True, PPR uses path analysis routines to
: produce a high-performance implementation of the design.

M MSTOP_ON_MISS
: Stop if a timing specification will not be met.

M HSTOP_ON_MISS
: Normally, if PPR finds that it cannot honor a timespec, it will continue
: to process the design, doing the best it can.  In such cases you may prefer
: not to wait for PPR to finish.  If this variable has been set to
: True, then when a missed requirement is inevitable, PPR will immediately
: give up; it will also write details to the log file
: about all path endpoints that are certain to miss their specs.

M MOUTFILE
: Base name for the output files.

M HOUTFILE
: PPR assigns this name to its output files.  The name should have no leading
: path or file extension.

M MSEED
: Random number seed used during placement improvement.

M HSEED
: PPR generates a random seed by default.

M MSAVE_FILES
: Save intermediate files?

M HSAVE_FILES
: Normally, internal data files created by PPR are deleted.  If you want
: to be able to re-use intermediate results (e.g., of initial placement
: or routing) in later runs, set this parameter to True.

M MXNF
: Use XTF netlist as input design file. 

M HXNF
: If TRUE, PPR uses the XNF file as the initial input.  If FALSE, PPR
: uses the MXN netlist.

M MOPEN_GUIDE_BLKS
: Allows extra logic into guided blocks.

M HOPEN_GUIDE_BLKS
: If TRUE, it allows new logic to be placed into guided blocks even if
: lock_routing=(whole_sigs || all).

M MPREP
: Run logic reduction and cleanup operations on design.

M HPREP
: If TRUE, PPR prepares the design by simplifying logic and removing 
: sourceless or loadless signals.  If FALSE, these routines are not run.

M MMAP_FGS
: Do logic mapping.

M HMAP_FGS
: If TRUE, PPR maps the 220zBoolean logic into function generators.

M MPLACE
: Do initial placement.

M HPLACE
: If TRUE, PPR groups the basic elements into blocks (CLBs and IOBs), and
: assigns initial locations to these blocks.

M MIMPROVE
: Do placement improvement.

M HIMPROVE
: If TRUE, PPR improves upon the original MINCUT placement.  If FALSE,
: no improvement is performed.

M MROUTE
: Route partitioned and placed design.

M HROUTE
: If TRUE, PPR uses the maze router to route the design.  If FALSE, the
: design will not be routed.

M MLCA
: Create an LCA file for the design.

M HLCA
: If TRUE, PPR creates an LCA file as output.  If FALSE, no LCA file is
: created.

M MREPORT
: Create a report (RPT) file for the design.

M HREPORT
: If TRUE, PPR generates a report file, which uses the extension RPT.  If
: FALSE, no report file is created.

M MIGNORE_TIMESPEC
: Ignore design file timing specs?

M HIGNORE_TIMESPEC
: If ALL, PPR ignores timing specifications in the design file.
: If NONE, PPR uses timing specifications in the design file.

M MIGNORE_TIMESPEC_ALL
: Ignore design file timing specs.
M HIGNORE_TIMESPEC_ALL
: PPR ignores timing specifications in the design file.  These
: specifications occur on 'timespec' symbols, normally entered in your
: schematic.

M MIGNORE_TIMESPEC_NONE
: Using timing specs.
M HIGNORE_TIMESPEC_NONE
: Timing specs will be taken into account.

M MUSE_FASTER_C2S
: use the faster C2S

M HUSE_FASTER_C2S
: USE_FASTER_C2S controls whether or not PPR applies a path delay
: target to a path between two flip-flops that have different C2S 
: specifications.

M MDC2S
: Default clock-to-setup time

M HDC2S
: C2S path delay target in ns (0.1 to 3000.0), "auto"
: for individual automatic setting, or "ignore" to request that of
: C2S paths, only those with explicit specifications be controlled.

M MDP2S
: Default pad-to-setup time

M HDP2S
: P2S path delay target in ns (0.1 to 3000.0), or "auto"
: for individual automatic setting, or "ignore" to request that of
: P2S paths, only those with explicit specifications be controlled.

M MDC2P
: Default clock-to-pad time

M HDC2P
: C2P path delay target in ns (0.1 to 3000.0), or "auto"
: for individual automatic setting, or "ignore" to request that of
: C2P paths, only those with explicit specifications be controlled.

M MDP2P
: Default pad-to-pad time

M HDP2P
: P2P path delay target in ns (0.1 to 3000.0), or "auto"
: for individual automatic setting, or "ignore" to request that of
: P2P paths, only those with explicit specifications be controlled.

M MTIMING
: Should delay information be used to guide the router?

M HTIMING
: Should the maze router ignore delay data, use delay data, or try both?

M MMAX_TRIES
: number of iterations tried

M HMAX_TRIES
: number of iterations tried

M MPLACE_WITH_TIMING
: Using path analysis during placement

M HPLACE_WITH_TIMING
: This option controls whether or not PPR will use path analysis
: during the placement phase.  By default, this option is set to
: TRUE for XC4000 designs and set to FALSE for XC3000A/L designs. [.br]
: If you want PPR to use path analysis during the placement
: phase for XC3000A/L designs, set this option to TRUE.

M MT_WHEN_ROUTABLE
: If 0 unroutes,try delays.

M HT_WHEN_ROUTABLE
: Routes the design twice.  First performs a quick routing that ignores delay
: data.  If this yields no unroutes, saves the result in a .lca file
: and restarts the router, using delay information. [.br]
: If the quick approach leaves unrouted connections, the approach that uses
: delay information is not tried.

M MT_ON
: Always use delay data.

M HT_ON
: Optimize routing delays.  Skip the approach that ignores delay data.

M MT_OFF
: Always ignore delay data.

M HT_OFF
: Ignore routing delays.  This can reduce run time, but it usually causes
: performance degradation in the design that results.  It is
: strongly recommended that delay information be used.

M MMINCUT_TRIES
: Max initial configurations per partitioning step.

M HMINCUT_TRIES
: This parameter sets the number of initial partitions constructed for each
: region.  At each partitioning step, at most this many attempts are made,
: constructing a good initial partition and improving it; the best result
: from these attempts is used.  (Zero means use arbitrary initial partitions.)
: [.br]Using a larger value may yield a higher-quality placement,
: but will require increased run time.

M MMINCUT_PASSES
: Max improvement passes per partitioning attempt.

M HMINCUT_PASSES
: Each partitioning attempt performs this many passes, but stops sooner
: if any pass shows no improvement.  Using smaller values may speed up
: initial placement, but values less than 5 are likely
: to impact the quality of results.

M INITIAL_MAX_DLY
: First upper limit on net delay.

M HINITIAL_MAX_DLY
:      Up to three values can be specified as upper limits on net delay, in
: nanoseconds.  When more than one limit is specified,
: the router tries them in increasing order,
: until all nets are routed or the last limit has been tried.  Extensive ripup
: and reroute are used to complete as many connections as possible within each
: delay limit, before proceeding to a new one.[.br]
:      By default, three limits are tried: [.br]
: initial_max_dly=20 [.br]
: second_max_dly=25 [.br]
: worst_dly=50 [.br]
:      However, if you provide values for any of these three parameters, then
: ONLY values that you specify will be tried.  If you specify just one of the
: limits, then only that limit is tried.  If you specify exactly two limits,
: only those two are tried.

M SECOND_MAX_DLY
: Second upper limit on net delay.

M HSECOND_MAX_DLY
: 

M MDFLT_SIG_DLY
: Signal delay for uncompleted paths only.

M HDFLT_SIG_DLY
: Default signal delay for incomplete paths not
: controlled by XACT-Performance. Specify the maximum 
: acceptable signal delay in nanoseconds.

M DLY_STEP
: Delay increment, in nanoseconds.

M HDLY_STEP
: Whenever more than one of the above three net delay limits are used,
: and you supply the dly_step parameter,
: additional values between the second largest and largest of these limits are
: also tried.  That range is covered in steps of dly_step nanoseconds.

M MROUTE_MORE
: Continue routing, starting with routes done previously.

M HROUTE_MORE
: To go directly to routing, set this parameter TRUE.  This is allowed only
: if an earlier run
: of PPR did some routing and used "save_files=TRUE".  Setting
: route_more to True lets
: PPR work to complete just those connections that the earlier run did not
: route.  With this option, the timing mode must be either 'forced_on'
: (the default) or 'ignored'.

M MSEEDS_TO_TRY
: Seeds to try before iterating placement improvement.

M HSEEDS_TO_TRY
: This option defines how many different seeds PPR uses in the placement
: improvement phase.  PPR runs one improvement iteration on the initial
: placement for each of seeds_to_try different seeds.  The placement
: algorithm then continues for (improvecount-1) iterations starting with
: the result that had the best score.

M MIMPROVE_ROUTING
: Improve routing of already completed nets?

M HIMPROVE_ROUTING
: When this option is set to True, an attempt is made to improve already
: completed nets, i.e., find routes that use fewer resources, without
: violating current timing requirements.  If it is set to False, the routing
: of a finished net is modified only to help complete other, unrouted nets.

M MALLOW_RIPUP
: Allow ripup and retry in router?

M HALLOW_RIPUP
: Set this to False if you want the router to do no ripup and retry at all.

M MRPT_NET_LOC
: Create "Net Locations" chapter?

M HRPT_NET_LOC
: If True, add section on net locations to report file.

M MRPT_SYM_LOC
: Create "Symbol Locations" chapter?

M HRPT_SYM_LOC
: If True, add section on symbol locations to report file.

M MGUIDELCA
: The LCA file to use as a guide for the design.

M HGUIDELCA
: The named LCA file will be guide partitioning, placement and routing
: through PPR. The default assumes that the design process is not going
: to be guided by a previous run of PPR.

# new
M MCSTFILE
: The CST file that contains the user constraints.

M HCSTFILE
: PPR automatically reads in design.cst, if it exists,
: unless it is overriden by this option.

M MIGNORE_MAPS
: Ignore FMAP/HMAP symbols.

M HIGNORE_MAPS
: XC4000 designs only. PPR will ignore the user created function
: generators, if this is TRUE.

M MIGNORE_LOCS
: Ignore the LOC parameters from the design file.

M HIGNORE_LOCS
: The design file LOC parameters of the specified type will be ignored
: by PPR.

M MIGNORE_LOCS_NONE
: Ignore none of the LOCs.

M HIGNORE_LOCS_NONE
: All LOCs will be used as specified.

M MIGNORE_LOCS_ALL
: Ignore all LOCs.

M HIGNORE_LOCS_ALL
: No LOCs will be used in PPR.

M MIGNORE_LOCS_IO
: Ignore LOCs on I/Os.

M HIGNORE_LOCS_IO
: All I/O LOCs will be ignored by PPR.

M MIGNORE_LOCS_INTERIOR
: Ignore LOCs on interior(i.e. core) logic.

M HIGNORE_LOCS_INTERIOR
: Only LOCs on I/Os will be used by PPR.

M MIGNORE_RLOCS
: Ignore the RLOC parameters from the design file.

M HIGNORE_RLOCS
: If ignore_rlocs is set to TRUE, then all the design file RLOC parameters
: will be ignored by PPR. This includes RLOC, RLOC_RANGE, and RLOC_ORIGIN.

M MPLACER_EFFORT
: Sets the level of placer effort.

M HPLACER_EFFORT
: This parameter controls the balance of run-time speed and
: quality of the resulting PPR placer run. 1: is the least effort
: and 5: is the highest effort.

M MROUTER_EFFORT
: Sets the level of router effort.

M HROUTER_EFFORT
: This parameter controls the balance of run-time speed and
: quality of the resulting PPR router run. 1: is the least effort
: and 4: is the highest effort.

M MROUTE_EFFORT_NA
: Option not in use

M HROUTE_EFFORT_NA
: Ignored by router

M MROUTE_EFFORT_LOW
: least effort

M HROUTE_EFFORT_LOW
: 1 produces a quick route

M MROUTE_EFFORT_MED
: medium effort

M HROUTE_EFFORT_MED
: router works to optimize performance and run time

M MROUTE_EFFORT_MEDHI
: medium high effort

M HROUTE_EFFORT_MEDHI
: router works harder to optimize performance and run time

M MROUTE_EFFORT_HIGH
: highest effort

M HROUTE_EFFORT_HIGH
: router keeps working until it meets the timing requirements

M MROUTE_THRU_BLKS
: Ability to route through blocks.

M HROUTE_THRU_BLKS
: The PPR router will increase the routability of the design by
: using unused logic resources as routing feed-throughs.

M MROUTE_THRU_BLKS_OK
: OK to route through any available block.

M HROUTE_THRU_BLKS_OK
: Any available(not used by design logic) for a routing resource.

M MROUTE_THRU_BLKS_LIMIT
: Limit the use of unused logic resources.

M HROUTE_THRU_BLKS_LIMIT
: Use only unused resources in partially used blocks.

M MROUTE_THRU_BLKS_NEVER
: Never use blocks.

M HROUTE_THRU_BLKS_NEVER
: Unused block resource cannot be used for routing.

M MROUTE_THRU_BUFG
: Ability to route through unused clock buffers

M HROUTE_THRU_BUFG
: Using unused BUFGS, GCLK and ACLK as routing feed-throughs.

M MROUTE_THRU_BUFG_OK
: OK to route through available clock buffers.

M HROUTE_THRU_BUFG_OK
: Any available(not used by design logic) clock buffer(BUFGS,GCLK,ACLK)
: for a routing resource.

M MROUTE_THRU_BUFG_NEVER
: Will not use any available clock buffer

M HROUTE_THRU_BUFG_NEVER
: Will not use any available(not used by design logic) clock buffer
: BUFGS,GCLK,ACLK for a routing resource.

M MGUIDE
: The LCA file to use a guide for PPR.

M HGUIDE
: The name LCA file will be used to guide partition, place, and
: route of the current design.

M MGUIDE_ONLY
: Performs guide placement and routing only.

M HGUIDE_ONLY
: The Guide_only option guides placement and routing and completes
: all placement but does not complete routing that is not guided.

M MGUIDE_BLKS
: Criteria for guiding block partitioning.

M HGUIDE_BLKS
: This parameter controls the amount of guiding that will be 
: applied from the guide file to the current design.

M MGUIDE_THRU_ROUTES
: Keep through-block routing.

M HGUIDE_THRU_ROUTES
: Keep through-block routing from the guide file.

M MGUIDE_THRU_ROUTES_ALL
: all guided signals.

M HGUIDE_THRU_ROUTES_ALL
: Keep through-block routing for all guided signals.

M MGUIDE_THRU_ROUTES_WHOLE_SIGS
: completely matched pin signals.

M HGUIDE_THRU_ROUTES_WHOLE_SIGS
: Keep through-block routing only signals 
: with completely matched pin

M MGUIDE_THRU_ROUTES_NONE
: Do not keep through-block routing.

M HGUIDE_THRU_ROUTES_NONE
: allow rip-up improvement on all guided routing to
: improve placement of new logic.

M MGUIDE_BLKS_ALL
: Guide all matching blocks. 

M HGUIDE_BLKS_ALL
: Guide all blocks that one or more matching signals.

M MGUIDE_BLKS_ROUTED_ONLY
: Guide blocks with matching signals.

M HGUIDE_BLKS_ROUTED_ONLY
: Blocks that are guided must have at least some routed connections.

M MGUIDE_ROUTING
: Restore routing for signals from the guide file.

M HGUIDE_ROUTING
: The Guide_routing option determines which routing to copy from
: the guide file.

M MGUIDE_ROUTING_ALL
: Restore routing for any matching.

M HGUIDE_ROUTING_ALL
: Restore the pin-to-pin routing of signals with matching pin-to-pin
: connections. 

M MGUIDE_ROUTING_WHOLE_SIGS
: Restore routing for complete signals.

M HGUIDE_ROUTING_WHOLE_SIGS
: Restore routing for whole signals that completely match all pin connections.

M MLOCK_ROUTING
: Lock the routing from the guide file.

M HLOCK_ROUTING
: Controls whether routing improvement will be able to
: change results taken from the guide file.

M MLOCK_ROUTING_ALL
: Lock routing for all guided signals.

M HLOCK_ROUTING_ALL
: Lock routing of all signals that have been selected for
: guiding by the 'guide_routing' parameter.

M MLOCK_ROUTING_WHOLE_SIGS
: Lock routing for completely guided nets

M HLOCK_ROUTING_WHOLE_SIGS
: Lock routing only for signals that have all pins matched in guide file.

M MLOCK_ROUTING_NONE
: Do not lock guided routing.

M HLOCK_ROUTING_NONE
: None allows guided routing to be discarded and re-routed to
: improve the timing.

M MGUIDE_XNF
: Use partitioning guide from the XTF file.

M HGUIDE_XNF
: (XFT Only)

M MMAP_FILE
: Output named map file after partitioning.

M HMAP_FILE
: (XFT Only)

M MANNEAL
: Parameters the annealing placer.

M HANNEAL
: Sets parameters for simulated annealing placement.

# Following parameters are "inhouse" - (not documented).
M MCOMPLETE
: Indicates whether or not the design is incomplete.

M HCOMPLETE
: If FALSE then the design is not complete and is a partial design. It may
: have sourceless and/or loadless nets and other such issues that would 
: normally stop the design from being completely processed through PPR.

M MRUN_MESSAGE
: Explicitly control a program's execution.

M HRUN_MESSAGE
: A value of FALSE will shut off this stage.

M MREPORT_PATHS
: When a timespec is missed, should PPR report details on paths?

M HREPORT_PATHS
: If when PPR misses a timespec, you want it to report the endpoints of paths
: that miss and delays along the worst paths to these endpoints,
: then set this True.

M MALLOW_MORE_AREA
: Percentage extra FGs allowed, to improve performance.

M HALLOW_MORE_AREA
:     Technology mapping produces several alternative solutions.  PPR will use
: the one that has the best estimated path timing, among those that need at most
: this percentage more area than the minimal area solution.

M MRESTRICT_BUFG
: Restrict timing=path routes from global buffers?

M HRESTRICT_BUFG
: By default, when PPR is routing with path timing controlled, it requires
: that routes from global buffers to clock pins or write enable pins be
: accomplished with minimal skew (global routing lines only - no feedthroughs).
: The router prefers to leave such connections unrouted, rather than
: violate this rule.  When restrict_bufg is set to False, this rule is
: abandoned, so that routing can be completed, at the possible expense of skew.
: When this setting is used, timespecs should be supplied to preserve
: some control of the delays to these pins.

M MMAX_ENDPINS
: Maximum endpoints to report when a timespec is missed.

M HMAX_ENDPINS
: max_endpins is used to set an upper limit on the number of endpoints
: for which detailed paths will be displayed, when the report_paths
: parameter is True.

M MSQUEEZE
: Squeeze elements along edge?

M HSQUEEZE
: If the design is small and does not have pads locked down to different sides,
: PPR will try to fit it all into a reasonably small region on
: some edge or edges of the LCA.

# Error and Warning Messages
M ERROR_TERMINATE -e11201
: PPR Terminating due to error status from subtool.

M TO_SKIP_PLACEMENT__NEED_FILES
: To run any of the later stages of PPR (improve, route, lca, or report)
: without running the placement stage, you must have saved data files from
: a previous run - but these files are not available.
: To save files, put [.br]
: ppr_save_files = TRUE [.br]
: into your xactinit.dat file.

M MXN_DATA_PROBLEM -e11202
> filename s
: PPR had trouble checking design data -
: file [filename] may have been corrupted.

M ESTIMATE_MODE_LEFTOVERS
: PPR has found leftover data produced by an old run in "-estimate" mode.
: Such data is suitable only in that mode.  Delete old files and try again.

M USER_SELECTION_DOES_NOT_FIT
> parttype z
: The design does not fit in the [parttype].

M TIMING_IS_OFF -w11204
: You selected "timing=FALSE" -- delay-insensitive routing.
: Ignoring routing delays can reduce run time, but it usually causes
: performance degradation in the design that results.

M OUTFILE_NOT_SIMPLE -e11205
> base s
: The outfile specified must be a simple name with no leading path
: or file extension, for example, "[base]".

M CANT_ROUTE_MORE -e11206
> pm_file z
: Cannot go directly to routing.  To route more, PPR needs a file named
: [pm_file].  Either no earlier run of PPR did routing and used
: "save_files=True", or the file was created but later deleted.

M TROUBLE_CHANGING_CELL_NAME
> cellname s
> datatype s
: Unable to give name [cellname] to [datatype] cell.

# Informational and Other Messages
M NO_SAVES_DURING_ESTIMATE
> nil s
: [nil]  In estimate mode, no data files are saved.

M PARAMETER_ERROR -e11220
: The route_thru_blks value "never" is not allowed in the 4k design.

M XNFMXN2
: [.br]ppr:  Reading input design data...[.br]
M LCA2PIC
: ppr:  Reading guide design data...[.br]
M PARTITION
: [.br]ppr:  Mapping function generators...[.br]
M PLACEMENT
: [.br]ppr:  Placing logic...[.br]
M MAZEROUTE
: [.br]ppr:  Routing signals...[.br]
M PIC2LCA
: [.br]ppr:  Generating .LCA File...[.br]
M MAKEREPORT
: [.br]ppr:  Making Report File...[.br]
M GUIDE_PARTITION
: [.br]ppr:  Guide mapping function generators...[.br]
M GUIDE_PLACEMENT
: [.br]ppr:  Guide placing logic...[.br]
M GUIDE_MAZEROUTE
: [.br]ppr:  Guide routing signals...[.br]

M BLKMAKE_CLB_FFS
> used_clb_ffs d21
: 2*number of clb's blkmake actually used = [used_clb_ffs].

M WILL_USE_OLD_PICFLAT
> pf_filename z
: Will use file [pf_filename] left over from a previous run to generate .lca
: file and/or report.  If you DON'T want to use this file, please delete it.

M DOWNCASE_DESIGN_NAME
> original z
> downed z
: To enforce case-insensitive data, design names are represented
: in lower case.  Your name "[original]" is being changed
: to "[downed]".  On some operating systems,
: output file names will change in the same way.

M ANNOUNCE_FIRST_LCA
: The design has been fully routed without optimizing connection delays
: and the result has been saved in an LCA file.  PPR will now work to
: produce a routing that optimizes the delays.  If this succeeds, the first
: LCA file will be replaced with the optimized one (after saving the original
: with a .lcb file extension).

M TIMING_OFF_REPORT
> report_name z
: Wrote report on the result without delay optimization to [report_name].

M BAD_DELAY_LIMIT_ORDERING -e11208
> init s
> second s
> worst s
: The sequence of net delay limits specified ([init] [second] [worst]) has a
: decreasing step.  This sequence must be increasing.

M CANT_SKIP_PLACEMENT -e11209
: PPR cannot run both a pre-placement stage (xnf, prep, or map_fgs) and a
: post-placement stage (improve, route, lca, or report) without running
: the 'place' stage.

M SPEC_OUT_OF_RANGE -e11211
> name s
> fdelay f.1
> smallest_ok f4.1
> biggest_ok f6.1
: Value of [fdelay] ns for [name] is out of range.  Specification must be
: between [smallest_ok] and [biggest_ok] ns.

M BAD_DELAY_SPEC -e11212
> name s
> string s
> flexi s
> igno s
: [name] specification ("[string]") is illegal.  Specification must be in
: ns (a floating point number), or "[flexi]" for individual automatic setting,
: or "[igno]" to ignore paths not explicitly controlled.

M BAD_DEFAULT_PATH_TIME -e11213
: One or more default path timing specifications were invalid.

M PATH_TIMING_SHUT_OFF -w11214
: Since you have requested delay-insensitive routing, it does not make sense
: for earlier stages to be performance-driven.  The path_timing variable is
: therefore being turned off.

M SPEEDFILE_REVISION
> version s
> revision s
: Speedfile version [version], revision [revision].[.br]

M PROBLEM_WITH_SPEEDFILE
: No speed data are available.  This indicates either that your installation
: was not properly completed (e.g., speeds.xct missing, corrupted, or left
: over from a previous install), or that a bad value of the
: datafile_search_path is being used in an xactinit.dat file.

M PATH_TIMING_IGNORES_DLY_PARAMS -w11216
: Path_timing is set to True.  PPR will IGNORE the parameters that
: give uniform delay limits to all nets
: (initial_max_dly, second_max_dly, worst_dly, and dly_step).

M BLANK_LINE
: 

M MISSING_DESIGN_FILE -e11219
: Missing the design file. [.br]

M LCA_WILL_LOSE -e11222
: The specified guide file has the same name as the output LCA file for
: this run of PPR. To avoid overwriting the guide design, you must
: either specify a different output file name using the outfile option,
: or rename the guide file. [.br]

M NO_LCA_SO_SAVING_FILES -w11217
: PPR will save its intermediate files even though you did not set
: "save_files=true", because you set "lca=false".  The work that ppr
: does would be lost if the intermediate files were not saved.

M ILLEGAL_DESIGN_NAME -e11221
> illegal_char s 
> cellname s
: Design name [cellname] is illegal. [.br]
: "[illegal_char]" is illegal character in design [cellname] name. [.br]
: Please refer to the appropriate reference guide for valid design
: name syntax.

M MTSI_PATH_LIMIT
: The number of uncontrolled or multiply controlled paths in the
: <design>.tsi file.

M HTSI_PATH_LIMIT
: The number of paths specifies the uppper limit for each type of path.

M MTSI_SHOW_ALL
: Print uncontrolled paths in all categories?

M HTSI_SHOW_ALL
: When TRUE, prints all uncontrolled paths.  If FALSE, suppresses
: printing of uncontrolled paths in the .tsi file when there are no
: timing specifications to control paths of that category.

E PPR
#
# ------------------ fgmap.m ------------------ 
#
#@(#)fgmap.m	6.15  4/26/94
 
 
B FGMAP -start6101 -end6400 -current6108
: fg mapping
 
# Tool description (for program help)
M DESCRIPTION
: <<put a detailed description of your tool here>>
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Input Mxn Cell
M IGNORE_MAPS
: ignored FMAP/HMAP symbols
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: Controls the name of the mxn cell which is read and operated on
M HIGNORE_MAPS
: Ignored the user maps
 
# Error and Warning Messages
M NO_INSTANCES -e6101
> cellname z
: The Mxn Cell "[cellname]" does not contain any instances.  Check your
: design for sourceless and/or loadless nets. [.br]
M MAP_FAILTURE -e6102
> instname s
> outname s
: The MAP symbol '[instname]' (output signal=[outname]) can not be obeyed,[.br]
: since it would enclose signals that are needed outside of the MAP. [.br]
: Correct this MAP symbol or remove it from the design. You might
: consider duplicating one or more gates so that the necessary logic
: can be isolated within the MAP symbol. [.br]
M MAP_FAILTURE_INPUT -e6105
> instname s
> outname s
> map_inputs s
> actual_inputs s
: The MAP symbol '[instname]' (output signal=[outname]) can not be obeyed.[.br]
: The following input signals are specifiled on the MAP symbol:[.br]
: [map_inputs] [.br]
: However, the gates that generate the signal [outname] have the following
: input signals: [.br]
: [actual_inputs] [.br]
: Check that the input and output signals assigned to the MAP 
: completely enclose the intended logic. [.br]
M MAP_FAILTURE_INPUT_NUMS -e6106
> instname s
> outname s
> map_inputs s
> actual_inputs s
> required_inputs_num d
: The FMAP symbol '[instname]' (output signal=[outname]) can not be obeyed.[.br]
: The following input signals are specifiled on the FMAP symbol:[.br]
: [map_inputs] [.br]
: However, the gates that generate the signal [outname] have the following
: input signals: [.br]
: [actual_inputs] [.br]
: Since the total number of inputs is greater than [required_inputs_num], 
: this logic cannot be mapped into a single function generator. 
: Check that the input and output signals assigned to the FMAP enclose
: the intended logic. For functions of 5 inputs or more, consider using one
: or two FMAPs in combination with an HMAP. [.br]
M MAP_TRIM_MSG -w6107
> nam s
: The following MAP symbols "[nam]" were not successfully used, either because [.br]
: (1) an error was made when assigning signals to the MAP pins; or [.br]
: (2) the underlying logic was changed by the trimming process, invalidating
: the MAP definition. Because of the second possibility, the MAPs listed
: below will not be considered errors. You may wish to check the MAP 
: definitions and/or the Logic Trimming section of the XNFPREP report file 
: to determine why these MAPs could not be used. [.br]
M ADD_FG_PIN_ERROR -e6103
> pinname s
: Error in copying EQN pin "[pinname]" to function generator instance pin. [.br]
M EQN_MAP_FAIL -e6104
> eqn_instname s
> map_instname s
: Failed to make the map instance [map_instname] for EQN instance [eqn_instname].
: Pins do not match. [.br]
 
# Informational and Other Messages
M READING_MXN
: Mx Netlist Acquisition
 
E FGMAP
#
# ------------------ fgmake.m ------------------ 
#
#@(#)fgmake.m	6.8  2/1/94


B FGMAKE -start6401 -end6500 -current6406
: Function Generator Maker

# Tool description (for program help)
M DESCRIPTION
: This tool examines the boolean gates of a net list and assembles them
: into function generators.  It then replaces the boolean gate primitives
: with function generator primitives.

# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Input Mxn Cell
M GUIDE_CELL
: Input Guide Cell
M FANOUT
: Duplicated Gate Fanout Limit
M MFGWIDTH
: Width of Primary Function Generator
M MHFGWIDTH
: Width of Secondary Function Generator
M MTIMING
: Deadline timing
M MNO_H
: No H function generator will be created.
M MAREACOST_TOLERATE
: Percentage of best area tolerance rate
M MDUPALLLEVEL
: Duplicated all level logic 
M MLAST_TOOL
: Last tool being run?

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: Controls the name of the mxn cell which is read and operated on
M HGUIDE_CELL
: Controls the name of the guide cell which is read and operated on
M HFANOUT
: Controls the gates which are duplicated to reduce the number of function
: generators made.  Only two-input boolean gates with a fanout less than
: this parameter will be duplicated.  Therefore a value of zero will inhibit
: gate duplication.  The default value for this parameter is six.
M HFGWIDTH
: Sets the maximum number of inputs to the primary (F or G) function generator.
: This is an expert parameter.  Don't mess with it unless you know what
: you are doing.
M HHFGWIDTH
: Sets the maximum number of inputs to the secondary (H) function generator.
: This is an expert parameter.  Don't mess with it unless you know what
: you are doing.
M HTIMING
: The flag to do the deadline timing, default is TRUE
M HNO_H
: No H function generator will be created, default is FALSE.
M HAREACOST_TOLERATE
: The percentage of best area tolerance rate for timing , default is 10
M HDUPALLLEVEL
: Duplicate all tree logic, default is FALSE 
M HGUIDE
: Incremental/Iterative Guide
M HLAST_TOOL
: True if no layout tools will be executed after fgmake in this run.

# Error and Warning Messages
M NET_NOSOURCE -w6401
> netname s
: Net [netname] has no source pin.
M NET_NOLOAD -w6402
> netname s
: Net [netname] has no load pin.
M NO_INSTANCES -e6403
> cellname z
: The Mxn Cell "[cellname]" does not contain any instances.  Check your
: design for sourceless and/or loadless nets.
M NOTHING_TO_MAP -w6404
> cellname z
: Your design "[cellname]" does not contain any logic to be mapped into function
: generators. This is typically an indication that logic has been unexpectedly
: removed by XNFPREP. If the design should contain combinational gates or
: memories, check the XNFPREP report file to  see  what logic has  been deleted
: and why. If there are no such symbols in the design, this message may be ignored.
M BETTER_SLACK_AVL
> slack_diff f4.1
> area1      f5.1
> area2      f5.1 
> set_toler  d
: A mapping to function generators is available that has [slack_diff] ns
: more estimated slack, but [area1]% more area cost than the chosen solution;
: and [area2]% more than the minimum area cost, which is more than the maximum
: acceptable excess of 10%. If you want to allow this solution,
: you can rerun ppr with "allow_more_area=[set_toler]" in the command line.[.br]
: Because "allow_more_area" is rarely useful, it is not documented - but
: it may be worth trying for this design.
M NO_H_INCONSISTENCY -e6405
: The parameter value "no_h" in the guide file is inconsistent with
: the user input.[.br]
: The guide file data may not be covered.
# Informational and Other Messages
M READING_MXN
: Mx Netlist Acquisition
M MXN_SIZE
> nwands d3
> nmems  d3
> ninsts d3
> nbools d3
> nffs   d3
: Design contains
: [.br]   [nbools] boolean gates
: [.br]   [nffs] flip flops
: [.br]   [nmems] rams/roms
: [.br]   [nwands] wand primitives
: [.br]   [ninsts] instances
M MAPLOGIC_SECTION
: Boolean Gate Mapping
M MAPLOGIC_HEADER
:      ---------------------------------------------------------------------
: [.br]Fanout  Fanin  Ndups Ntrees  Dtl    nfs   nfhs   nfghs   wsk    cost
: [.br]------ ------ ------ ------ ----- ------ ----- -------- ------ ------
M MAPLOGIC_ENTRY
> fanout  d6
> fanin   d6
> ndgate  d6
> ntrees  d6
> dtl      s
> nfs     d6
> nfhs    d6
> nfghs   d6
> wsk     s8 
> cost    d5
: [fanout] [fanin] [ndgate] [ntrees] [dtl] [nfs] [nfhs] [nfghs] [wsk] [cost]
M MAPLOGIC_FOOTER
:      ---------------------------------------------------------------------
M GATEDIST_SECTION
: Boolean Gate Distributions
M GATEDIST_HEADER
:       ------------------------------------
: [.br]   Ngates   Ntrees   Nfgs-F   Nfgs-H
: [.br]--------- -------- -------- --------
M GATEDIST_ENTRY
> ngates d8
> ntrees d8
> nfgs_f d8
> nfgs_h d8
: [ngates] [ntrees] [nfgs_f] [nfgs_h]
M GATEDIST_FOOTER
: ------------------------------------
M REPLACE_GATES
: Replacing Boolean Primitives
M FGCOUNTS
> bool_fgcount d-3
: [bool_fgcount] boolean-gate function generators[.br]
E FGMAKE
#
# ------------------ mdmake.m ------------------ 
#
#@(#)mdmake.m	6.10  2/1/94


B MDMAKE -start6601 -end6700 -current6609
: MEMORY and DECODER Maker

# Tool description (for program help)
M DESCRIPTION
: This tool examines the memeory and wand gates of a net list and assembles them
: into function generators, memory write control, decoders, tbuf.

# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Input PIC Cell
M GUIDE_CELL
: Input Guide Cell

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: Controls the name of the mxn cell which is read and operated on
M HGUIDE_CELL
: The name of the guide file to which the guide information is readed or written 
: If no file name is specified the name of the file will be the name of the 
: input cell.

# Error and Warning Messages
M NET_NOSOURCE -w6601
> netnum d
: Net [netnum] has no source pin.
M NET_NOLOAD -w6602
> netnum d
: Net [netnum] has no load pin.
M NO_INSTANCES -e6603
> cellname z
: The Mxn Cell "[cellname]" does not contain any instances.  Check your
: design for sourceless and/or loadless nets.
M ROM_NO_INIT_VALUE -w6604
> instname s
: No initialization value for rom instance "[instname]" has been given.[.br]
: a value of "0" will be used.
M ROM_INIT_VALUE_TOO_BIG -w6605
> instname s
> initvalue s
: The initialization value ([initvalue]) for rom instance "[instname]"[.br]
: is too big.  The value will be truncated and only the lower 16 bits used.
M ROM_BAD_INIT_VALUE -w6606
> instname s
> initvalue s
: The initialization value ([initvalue]) for rom instance "[instname]"[.br]
: does not represent a valid hexadecimal number.  A value of "0" will be used.
M RAM_INIT_VALUE_NOT_ALLOWED -w6607
> instname s
> initvalue s
: Initialization values on ram instances are not allowed.  The initialization
: value ([initvalue]) on the instance "[instname]" will be ignored.
M ILLEGAL_CONSTRAINT -w6608
> inst_name s
: Multiple side constraints of the instance [inst_name] is illegal.
: Constraint value will be ignored.
# Informational and Other Messages
M READING_MXN
: Pic Acquisition
M MXN_SIZE
> nwands d3
> nmems  d3
> ninsts d3
: Design contains
: [.br]   [nmems] rams/roms
: [.br]   [nwands] wand primitives
: [.br]   [ninsts] instances
M REPLACE_GATES
: Replacing Memory and Wand Primitives
M FGCOUNTS
> memr_fgcount d-3
> ntbuf__wands d-3
> ndecodewands d-3
> ndecoders    d
: [memr_fgcount] ram/rom-gate function generators[.br]
: [ntbuf__wands] tbuf-wand primitives[.br]
: [ndecodewands] decode-wand primitives with [ndecoders] decoders
E MDMAKE
#
# ------------------ partest.m ------------------ 
#
#@(#)partest.m	6.5  4/27/94
 
 
B PARTEST -start5501 -end5600 -current5529
: Part estimator for a given design
 
# Tool description (for program help)
M DESCRIPTION
: Part estimator for a design. 
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
 
# Error and Warning Messages
 
# Informational and Other Messages

M MJUST_CHECK_AVAILABILITY
: Just check the availability of the parttype.

M HJUST_CHECK_AVAILABILITY
: If TRUE then the parttype(from the netlist or runtime specified)
: will just be checked for availability. NO design statistics or suggested
: best fitting parttype will be reported.

M MUSE_BEST_FIT
: Use the estimated best fitting parttype.

M HUSE_BEST_FIT
: If FALSE then PARTEST evaluates the given design and
: suggests a best fitting part if different from the specified.
: If TRUE then the estimated best fitting
: parttype will also be inserted into the design file for use of programs
: that will follow later in the design flow.
: A report of the design statistics is always generated.

M MCELL
: Name of the design to base the parttype estimate.

M HCELL
: An PIC_FGS extension is assumed.

M MPARTTYPE
: Target LCA device and package(e.g. 4005PG156-5).

M HPARTTYPE
: If no part type is specified and none is found in the input design,
: PARTEST finds the smallest part that will work and uses it.

M MESTIMATE
: Evaluate the fitness of a part.

M HESTIMATE
: If the user selects a parttype, PARTEST evaluates how well it fits the given
: design, and generates a report of design statistics.
: Otherwise, it suggests and evaluates a part.

#**************************************************************************
# Program error messages
#**************************************************************************

M BAD_SYNTAX -e5501
> line_num d
> statement_name s
> index d
> text s
: Line [line_num]: bad [statement_name] .. stopped at index [index].
: [.br][text]
: [.br]

M NOPARTS -e5502
> file s
: Parts file "[file]" is missing.  A part recommendation cannot be made.

M MISSING_DESIGN_DATA -e5503
> cell z
: Data for design [cell] is not available in the appropriate form for part
: estimation.

M BAD_PARTS_FILE -e5504
> file s
: Parts file "[file]" has invalid data.  A part recommendation cannot be made.

M MISSING_CLB_DATA -e5505
> partname z
> partlist_file s
: Part list file is missing data on numbers of CLBs for part [partname].  All
: current versions of [partlist_file] (revision 3 and later) include this data.

M INVALID_SPEED_GRADE -e5506
> given_grade s
> device s
: Specified speed grade ([given_grade]) is not valid for device [device].
: Please select one of the following speed grades:

M CANT_EVALUATE_PARTS -e5507
> partlist s
: File with data on parts, [partlist], is missing or empty.  Cannot proceed.

M USER_SELECTION_DOES_NOT_FIT -e5508
> parttype z
: The design does not fit in the [parttype].

M REJECT_PART_FGS -e5509
> pfgs d
> dfgs d
: The specified part has [pfgs] function generators.  The design uses [dfgs].

M REJECT_PART_CLB_FFS -e5510
> pclb_ffs d
> dclb_ffs d
: The specified part has [pclb_ffs] CLB flip-flops.  Design needs at least [dclb_ffs].

M ODD_CLB_FF_WASTE -e5511
> num_design_flip_flops d
> odd_c_nets d
> flip_flops m
> nets m
: Although the design only contains [num_design_flip_flops] CLB
: [flip_flops] it will not fit in the specified device.
: This is because there are [odd_c_nets] CLBs with only one
: flip-flop being used where the second flip-flop cannot
: be used.  This occurs because the two flip-flops in each CLB
: have a common clock pin and your design contains [odd_c_nets]
: clock [nets], each driving an odd number of flip-flops.

M REJECT_PART_BONDED_IOBS -e5512
> pbios d
> dbios d
: The specified part has [pbios] bonded IOBs.  The design needs [dbios].

M REJECT_PART_UNBONDED_IOBS -e5513
> punbios d
> dunbios d
: The specified part has [punbios] unbonded IOBs.  The design needs [dunbios]. Select
: a part with more unbonded pads or remove the UPADs from the design or
: change the UPADs to PADs.

M REJECT_PART_TOTAL_IOBS -e5514
> ptios d
> dtios d
: The specified part has [ptios] total IOBs.  The design needs [dtios].

M REJECT_PART_WIDE_BUS -e5515
> widest_allowed d
> toowides d
> max_tbufs d
> nets m
: The specified part allows at most [widest_allowed] TBUFs to drive a single net.  
: The design uses [toowides] [nets] with too many TBUFs.
: The biggest net has [max_tbufs] TBUFs in the design.

M REJECT_PART_BUS_RESOURCES -e5516
> pbusses d
> phalflen d
> dtotal d
> half_busses m
: The specidied part has [pbusses] half-busses of capacity [phalflen].
: The design needs [dtotal] [half_busses]:

M REJECT_PART_HFGS -e5517
> phfgs d
> dhfgs d
: The specified part has [phfgs] H function generators.  The design uses [dhfgs].

M REJECT_PART_BUFGPS -e5518
> pbufgps d
> dbufgps d
: The specified part has [pbufgps] primary global buffers.  The design uses [dbufgps].

M REJECT_PART_BUFGSS -e5519
> pbufgss d
> dbufgss d
: The specified part has [pbufgss] secondary global buffers.  The design uses [dbufgss].

M REJECT_PART_DECODE_NETS -e5520
> p_max_dec_nets d
> d_decode_nets d
: The specified part allows [p_max_dec_nets] edge decoder nets.  Design has [d_decode_nets].

M REJECT_PART_DECODE_TOT_INS -e5521
> p_max_width d
> d_max_inputs d
: PPR allows up to [p_max_width] inputs to edge decoders.  Design
: has one with [d_max_inputs].

M REJECT_PART_DECODE_CORE_INS -e5522
> p_max_width d
> d_max_inputs d
: PPR allows up to [p_max_width] inputs from non-pads to edge
: decoders.  Design has one with [d_max_inputs].

M REJECT_PART_IO_FLIP_FLOPS -e5523
> d_in_ffs d
> d_out_ffs d
: The specified part does not support storage elements in the IO area, e.g., INFF, INLAT,
: INREG, or OUTFF symbols.  The design has [d_in_ffs] input storage elements
: and [d_out_ffs] output storage elements.

M PARTTYPE_NOT_FOUND -e5524
> parttype s
> partlist_file s
: Your recommended parttype "[parttype]" does not appear in [partlist_file],
: so it cannot be evaluated.

M DESIGN_TOO_BIG -e5525
: Your design appears not to fit in any part.

#**************************************************************************
# Program warning messages
#**************************************************************************

M USE_DEFAULT_SPEED_GRADE -w5526
> grade s
: Speed grade was not specified.  The speedgrade [grade] will be used.

M NOT_USING_GLOBAL_BUFFERS -w5527
: The design uses no global buffers (BUFGS or BUFGP).
: Their use can improve performance for clocks or widely distributed signals.

M MORE_THAN_TWO_PULLUPS -w5528
> netname s
: Net [netname] has more than two pullups.

#**************************************************************************
# Program informational messages
#**************************************************************************
M YOU_PICKED_BIGGEST
: No part bigger than your selection is currently available.

M GENERIC_INTRO
> intro_msg m
> parttype z
: [intro_msg] [parttype]:

M INTRO_USER_CHOICE
: Preliminary estimate of device utilization for part 

M INTRO_COMPARISON
: Device utilization comparison shown for part 

M PROCEED_WITH_USER_PART
: This comparison does not consider packages for which the supporting data
: files have not been installed. 

M INTRO_AUTO_SHOULD_FIT
: The design apparently would fit (as follows) in a

M INTRO_BIGGEST_NOT_ENOUGH
: Results if you used the biggest part, 

M INTRO_BEST_PART
: Initial evaluation of automatically selected part,

M PAD_UTILIZATION
> pad_use d5
> dpad d3
> ppad d3
:         [pad_use]% utilization of total pads.              ([dpad] of [ppad])

M BLANK_LINE
: 

M HALF_BUSSES
> dbushalf d10
> phalflen d
> nets m
: [dbushalf] for [nets] with [phalflen] TBUFs or fewer;

M WHOLE_BUSSES
> nil s
> dbusfull d
> nets m
: [nil]         2 each for [dbusfull] [nets] that will not fit on a half-bus.

M TWO_PULL_BUSSES
> nil s
> dnets2pull d
> nets m
: [nil]         2 each for [dnets2pull] [nets] with 2 pullups.

M REPORT_LINE_DIVIDER
: -------------------------------------------------------------------------

M HALF_BUS_PLURAL
: half-busses

M HALF_BUS
: half-bus

M FLIP_FLOPS
: flip-flops

M FLIP_FLOP
: flip-flop

M NETS
: nets

M NET
: net

M A_NET
: a net

M CONSULT_FINAL_REPORT
: Consult the PPR report file for final device utilization statistics.

M UTILIZATION
> pin_use d5
> dpin d3
> ppin d3
> fg_use d5
> dfg d3
> pfg d3
> clb_ff_use d5
> dff d3
> pff d3
:         [pin_use]% utilization of I/O pins.                ([dpin] of [ppin])
:     [.br][fg_use]% utilization of CLB function generators. ([dfg] of [pfg])
: [.br][clb_ff_use]% utilization of CLB flip-flops.          ([dff] of [pff])

M BUS_UTILIZATION
> bus_use d5
> dbus d3
> pbus d3
:         [bus_use]% utilization of bus resources.           ([dbus] of [pbus])

M A_VALID_SPEED
> speed s15
: [speed]

M AVAILABLE_PART_HEADING
: The following are valid parttypes:

M AN_AVAILABLE_PART
> part z-20
: [part]

M TAKING_NETLIST_PARTTYPE
> parttype s
: Taking parttype "[parttype]" from the netlist.

M TAKING_DATA_FILE_PART
> parttype z
> file s
: Taking parttype "[parttype]" from data file [file].

E PARTEST
#
# ------------------ lca2pic.m ------------------ 
#
#@(#)lca2pic.m	6.29  4/4/94
 
 
B LCA2PIC -start12201 -end12500 -current12236
: Converts .LCA files to PIC files
 
# Tool description (for program help)
M DESCRIPTION
: LCA2PIC translates an .LCA file to a PIC file.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Input File Name
M FILE
: Output File Name
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: This required field specifies the name of the input .LCA file
: to be translated to PIC.

M HFILE
: This optional field specifies the name of the output PIC file.  If
: no file name is specified here, the name of the output PIC file will
: be the same as the input .LCA file base name.
 
# Error and Warning Messages
#------------------------------------------------------------
# 4K Pip Errors
M UNRECOGNIZED_PIP -e12201
> part1 s
> part2 s
> net s
: In the guide .LCA file, the connection between segments [part1]
: and [part2] on net [net] could not be recognized.  The .LCA file may be
: corrupted; try loading and then saving the file in XDE.
 
M NO_ORIENTATION -e12203
> part s
: In the guide .LCA file, the connection segment [part] has unknown
: orientation; "row" or "col" must be the first component of the Pip
: name.  The .LCA file may be corrupted; try loading and then saving
: the file in XDE.
 
M PIN_NOT_ADDED -e12204
> pin s
> blk s
: Pin [pin] could not be added to [blk] during the guide .LCA file
: translation.  The .LCA file may be corrupted; try loading and then
: saving the file in XDE.

M NOT_TRANSLATED -e12205
> blk s
: In the guide .LCA file, block [blk] could not be translated.
: Please contact Xilinx support personnel.

M UNPROCESSED_PIP -e12206
> pip s
> net s
: In the guide .LCA file, pip [pip] found in NProgram statement for
: signal '[net]' was not processed. Please contact Xilinx support personnel.

M CIN_COUT_SAME_TILE -e12208
> pip s
: In the guide .LCA file, the COUT->CIN connection specified in the pip '[pip]'
: is illegal.  COUT to CIN pin connections cannot be made within a single
: CLB; this connection must involve adjacent CLBs.  The .LCA file may be
: corrupted; try loading and then saving the file in XDE.

M CIN_COUT_ERROR -e12209
> pip s
: In the guide .LCA file, the COUT->CIN connection specified in the pip
: '[pip]' is illegal.  COUT to CIN pin connections must involve adjacent
: CLBs.  The .LCA file may be corrupted; try loading and then saving the
: file in XDE.

M MAGIC_BOX_MISMATCH -e12210
> blk1 s
> blk2 s
: In the guide .LCA file, segments from different switch matrixes [blk1]
: and [blk2] were associated together in a NProgram statement.  The LCA
: file may be corrupted; try loading and then saving the file in XDE.
 
M ILLEGAL_MBOX_PIN -e12211
> pin s
: In the guide .LCA file, switch matrix pin [pin] contains an
: illegal pin number.  The .LCA file may be corrupted; try loading and
: then saving the file in XDE.
 
M CONVERSION_ERROR -e12212
> name s 
: In the guide .LCA file, [name] contains an illegal number.  The
: .LCA file may be corrupted; try loading and then saving the file in XDE.
 
M H_FEEDTHRU_NOT_MADE -e12213
> blk s
> type s
: Couldn't process the H feedthru from [type] for block [blk] found in
: the guide .LCA file.  The .LCA file may be corrupted; try loading and
: then saving the file in XDE.
 
M CFG_NOT_PROCESSED -e12214
> blk s
> cfg s
: Couldn't process Config statement [cfg] tag data for block [blk] found
: in the guide .LCA file.  The .LCA file may be corrupted; try loading
: and then saving the file in XDE.
 
M PIN_NOT_RECOGNIZED -e12215
> blk s
> pin s
: Couldn't identify the [pin] pin for block [blk] found in the guide
: .LCA file. Please contact Xilinx support personnel.

M PIN_NET_NOT_FOUND -e12216
> loc s
> pin s
: In the guide LCA file, no net was defined on the pin [loc].[pin], which is
: used inside that block. This LCA file cannot be used as a guide file. 
: When editing a guide file in EditLCA, do not delete nets or pins via
: the DeleteNet or DeletePin command. To remove routing, use the Unroute
: command (which preserves the definition of the net). To remove logic,
: use the DeleteBlk command, which eliminates both the logic inside the 
: block and the pins that connect to it.

 
M GLOBAL_BUF_MISMATCH -e12217
> buf1 s
> buf2 s
: In the guide .LCA file, segments from different global buffers [buf1]
: and [buf2] were associated together in a NProgram statement.  The LCA
: file may be corrupted; try loading and then saving the file in XDE.
 
M GLOBAL_BUF_PAD_ERROR -e12218
> blkname s
: Could not find pad for [blkname] global buffer input in the guide LCA
: file.  The partlist.xct file may be corrupted; try reinstalling PACKAGE.

M LCA_CONVERSION_ERROR -e12219
> coord s
: Could not translate IOB coordinates for [coord] found in the guide
: .LCA file.  This is an internal error; please contact Xilinx support personnel.

M MULT_SPCL_CORNER -e12220
> type s
: More than one [type] symbol is used in the guide .LCA file; only one
: [type] symbol is allowed.  The .LCA file may be corrupted; try loading
: and then saving the file in XDE.

M PART_ERROR -e12221
> part s
: The part [part], specified in the guide .LCA file, is not supported by PPR.

M NET_NOT_TRANSLATED -e12224
> net s
: In the guide .LCA file, signal '[net]' could not be translated.  This is an
: internal error; please contact Xilinx support personnel.

M NETEQ_PARSE_ERROR -e12225
> errstr s
: Error in reading NETEQ System statements from guide .LCA file:
: [.br] [errstr]  [.br]The .LCA file may be
: corrupted; try loading and then saving the file in XDE.

M NO_CARRY4KXCT -e12226
: The carry4k.xct data file could not be read in to process the carry logic
: found in the guide .LCA file.  Try reinstalling PACKAGE.

M UNKNOWN_BASE -e12227
> blk s
> base s
: The BASE [base] for block [blk], found in the guide .LCA file, is not
: legal.  The .LCA file may be corrupted; try loading and then saving the
: file in XDE.

M TOO_MANY_INPUTS -e12228
> blk s
: The block [blk] has too many function generator inputs specified in the
: guide .LCA file.  The .LCA file may be corrupted; try loading and then
: saving the file in XDE.

M NO_DATA_FILE -e12229
> filename s
: The [filename].dat data file could not be read in to process the guide
: .LCA file.  Try reinstalling PACKAGE.

M DICT_READ_ERROR -e12230
> file s
> reason s
: Error found in parsing the [file].dat data file[reason] when trying to
: process the guide .LCA file.  Try reinstalling PACKAGE.

M NO_PARTLISTXCT -e12231
: The partlist.xct data file could not be read in when trying to process
: the guide .LCA file.  Try reinstalling PACKAGE.

M ILLEGAL_LCA_FILE -e12233
: The .LCA file is not legal when trying to process the guide .LCA file.
: The .LCA file may be corrupted; try loading and then saving the file
: in XDE.

M OLDSTYLE_LCA_FILE -e12234
: This is an older version .LCA file which does not support the guide 
: facility. This .LCA file does not contain complete guide information. 
: Rerun the design with the current software to get up-to-date .LCA file.
 
M NOGUIDE_LCA_FILE -w12235
: This .LCA file does not contain complete guide information. Use at
: your own risk. If any problem arises, please rerun the design with 
: the current software to get up-to-date .LCA file. 

# Internal or debugging errors 
#------------------------------------------------------------
M NO_BLK_TRANSLATION
> blk s
> type s
: No TIF translation was found for [type] [blk].
 
M NO_TIF_TRANSLATION
> line1 s
> line2 s
: No TIF translation was found for [line1]:[line2].
 
M BEL_NOT_FOUND
> loc s
> bel s
> tifblk s
: For block [loc], could not find bel [bel] bel at [tifblk].

M BEL_NOT_SET
> loc s
> bel s
> tifblk s
: For block [loc], could not set bel [bel] bel at [tifblk].

M BELARC_NOT_FOUND
> loc s
> tbuf s
> seg s
: Could not find belarc at [loc] between [tbuf] and [seg].
 
M BELARC_NOT_SET
> loc s
> tbuf s
> seg s
: Failed to set belarc at [loc] between [tbuf] and [seg].
 
M NET_NOT_FOUND
> net s
: Couldn't find MXN net for LCA net [net].
 
M TIF_BLK_NOT_FOUND
> blkname s
: Could find no TIF block for [blkname].
 
M SET_PIP_ERROR
> blk s
> seg1 s
> seg2 s
: Could not find pip connecting [seg1] and [seg2] at [blk].
 
M TIF_BLOCK_ERROR
> blk s
: No TIF block found for blockname [blk].

M PIP_LOCKED
> blk s
> seg1 s
> seg2 s
: Could not set pip connecting [seg1] and [seg2] at [blk] because it was
: already set.

# Informational and Other Messages
M HEADER
: LCA2PIC starts...

E LCA2PIC
#
# ------------------ pic2lca.m ------------------ 
#
#@(#)pic2lca.m	6.8  5/2/94
 
 
B PIC2LCA -start10601 -end10900 -current10611
: PIC to LCA translator
 
# Tool description (for program help)
M DESCRIPTION
: Translates a pic cell to an lca file.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Name of input pic cell

M LCAFILE
: Name of output lca file
 
M JUSTFLATTEN
: Routes all the nets to clb pins.
 
M TIMEGROUPS
: Should timegroups and timespecs be written to lca file?

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: The name of the pic cell that is to be translated into a lca file.  This 
: name must either exist in the current working directory or at the location 
: specified in the file's pathname.

M HLCAFILE
: The name of the lca file to which the pic information is written.  If no file 
: name is specified the name of the file will be the name of the input pic
: cell with a .lca extension.

M HJUSTFLATTEN
: Routes all the nets to clb pins.
: Used to generate an unrouted LCA file for unit-delay simulation.  Pic2lca 
: generates an lca file with all the instances placed in clbs and the nets
: routed to CLB pins.

M HTIMEGROUPS
: If timegroups is TRUE, pic2lca will call the path analyzer to get
: information on the user's timing constraints, and write timegroup and
: timespec records for these into the lca file.

M UNROUTED_CONNECTIONS -w10610
> value s
: [.br]Number of unrouted connections: [value] [.br]

# Error and Warning Messages
M BLKNM_EXISTS -w10601
> instname s
> blkname s
> newblkname s
: The block name '[blkname]' associated with the instance '[instname]'
: has already been used to name another block.  The new block name 
: '[newblkname]' is created for this block.'
 
M ILLEGAL_BLKNM -w10602
> instname s
: The names associated with the following blocks are not legal in XACT.  Block
: names can contain only the characters:[.br]
: A-Z a-z 0-9 $ _ - < > /[.br]
: and must contain at least one non-digit character.
: New block names will be created for these blocks.
: [.br]                     block name                     instance name 
: [.br]                     ----------                     ------------- 
: [.br][instname]

M PKG_PIN_NAME -w10603
> instname s
> blkname s
> newblkname s
: The block name '[blkname]' associated with the instance '[instname]' could
: not be used because it is a reserved name for the package pins in XACT.  
: The new block name '[newblkname]' is created for this block.

M EXISTING_LCA_FILE -w10604
> fname s 
: A .LCA file already exists.  The old .LCA file will be saved as '[fname]'.

M BAD_OPEN_FILE -e10605
> fname s
: The file [fname] could not be opened.

M BAD_INIT_FILE -e10606
> fname s
: The LCA2HM initialization file, [fname], is in the wrong format.

M NO_LCA_FILE -e10607
> fname s
: Unable to open the file '[fname]' for writing. 
 
# Informational and Other Messages
M READING_PIC
: Loading the PIC netlist

M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ILLEGAL_PAD_ATTR -w10608
> attr s
> partname s
: The pad attr '[attr]' is not defined for the '[partname]' part.

M NEW_BLKNM -w10609
> instname s
> blkname s
: The new block name '[blkname]' is assigned to the instance '[instname]'.

E PIC2LCA
#
# ------------------ pic2map.m ------------------ 
#
#@(#)pic2map.m	6.3  7/23/93
 
 
B PIC2MAP -start6501 -end6600 -current6506
: PIC to MAP file translator
 
# Tool description (for program help)
M DESCRIPTION
: The PIC2MAP tool translates a PIC file to a MAP file.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M PICFILE
: Input PIC file name

M MAPFILE
: Output MAP file name

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HPICFILE
: The name of the PIC file to be translated.  This name must either exist in
: the current working directory or at the location specified in the file's
: pathname.

M HMAPFILE
: The name of the output file. If no output file name is specified,
: the translated file will be written to a file with the same name as the
: input file with extension "map".

# Error and Warning Messages

M SYM_ADD_PARAM_ERROR -e6501
> name s
> param s
: An error occurred while adding "[param]" parameter to symbol "[name]".

M SYM_NOT_FOUND -e6502
> name s
: Symbol "[name]" is not found in the output map file.

M XNF_ADD_SYM_ERROR -e6503
> symname s
: Unable to copy XNF symbol "[symname]" to MAP file.

M XNF_ADD_PIN_ERROR -e6504
> symname s
: Unable to add XNF pin record for symbol "[symname]".

M XNF_ADD_SIG_ERROR -e6505
> signame s
: Unable to create XNF record for signal "[signame]".

# Informational and Other Messages
 
E PIC2MAP
#
# ------------------ placer.m ------------------ 
#
#@(#)placer.m	6.19  4/21/94
 
 
B PLACER -start8901 -end9000 -current8903
: Placement tools
 
# Tool description (for program help)
M DESCRIPTION
: <<put a detailed description of your tool here>>
 
#---------------------------------------------------------------
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
#---------------------------------------------------------------
M MCELL
: Input PIC Cell name

M MGUIDE_CELL
: Input guide PIC Cell name

M MPLACER_EFFORT
: Placement effort

M MSEED
: Seed for random number generator

M MPARTIAL
: Partial design flag

M MDEBUG
: Debug flag

M MUNMATCH
: Flag for print out the unmatch with guide

M MIGNORE_RLOCS
: Ignore the RLOC parameters from the design file.

M MTIMING
: Path timing flag

#---------------------------------------------------------------
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
#---------------------------------------------------------------
M HCELL
: Input PIC Cell name

M HGUIDE_CELL
: Input guide PIC Cell name

M HPLACER_EFFORT
: Placement effort 

M HSEED
: Seed for random number generator

M HPARTIAL
: Partial design flag

M HDEBUG
: Debug flag

M HUNMATCH
: Flag for print out the unmatch with guide

M HIGNORE_RLOCS
: All the design file RLOC parameters will be ignored
: by the placer. This includes RLOC and RLOC_RANGE.

M HTIMING
: Using path timing during placer.

M MGUIDE_BLKS
: Criteria for guiding block partitioning.

M HGUIDE_BLKS
: This parameter controls the amount of guiding that will be 
: applied from the guide file to the current design.

M MGUIDE_BLKS_ALL
: Guide all matching blocks. 

M HGUIDE_BLKS_ALL
: Guide all blocks that one or more matching signals.

M MGUIDE_BLKS_ROUTED_ONLY
: Guide blocks with matching signals and some connected routing.

M HGUIDE_BLKS_ROUTED_ONLY
: Blocks that are guided must have at least some routed connections.

M MGUIDE_THRU_ROUTES
: Criteria for using blocks as routing resource.

M HGUIDE_THRU_ROUTES
: This parameter controls which through-routes are preserved during 
: guided placement.

M MGUIDE_THRU_ROUTES_ALL
: Guide all through-routes.

M HGUIDE_THRU_ROUTES_ALL
: Locks the through-routes for all guided signals, preventing 
: placement from using those blocks resouces to implement user logic.

M MGUIDE_THRU_ROUTES_WHOLE_SIGS
: Guide through-routes with matching signals.

M HGUIDE_THRU_ROUTES_WHOLE_SIGS
: Locks through-routes only on signals with completely matched pins.
: PPR can use the block resources used for through-routes on 
: incompletely matched signals to implement user logic.

M MGUIDE_THRU_ROUTES_NONE
: Through-routes are ignored.

M HGUIDE_THRU_ROUTES_NONE
: Allows any through-routes to be discarded, so PPR can use
: these block resources to implement user logic.

M MROUTE
: Route flag for PPR

M HROUTE
: This parameter determines if routing is to be performed during
: PPR.

M MOPEN_GUIDE_BLKS
: Allows extra logic into guided blocks.

M HOPEN_GUIDE_BLKS
: If TRUE, it allows new logic to be placed into guided blocks even if
: lock_routing=(whole_sigs || all).

M MLOCK_ROUTING
: Lock the routing from the guide file.

M HLOCK_ROUTING
: Controls whether routing improvement will be able to
: change results taken from the guide file.

M MLOCK_ROUTING_ALL
: Lock routing for all guided signals.

M HLOCK_ROUTING_ALL
: Lock routing of all signals that have been selected for
: guiding by the 'guide_routing' parameter.

M MLOCK_ROUTING_WHOLE_SIGS
: Lock routing for completely guided nets

M HLOCK_ROUTING_WHOLE_SIGS
: Lock routing only for signals that have all pins matched in guide file.

M MLOCK_ROUTING_NONE
: Do not lock guided routing.

M HLOCK_ROUTING_NONE
: None allows guided routing to be discarded and re-routed to
: improve the timing.

#---------------------------------------------------------------
# Error and Warning Messages
#---------------------------------------------------------------
M BAD_FILE_OPEN
> fname s
> type s
: Could not open file '[fname]' for [type]

M E_DIFFERENT_MODELS -e8901
> gmodel s
> dmodel s
: The part type of guide data ([gmodel]) does not match 
: with the part type of the design data ([dmodel]). [.br]

M INTERNAL_ERROR -e8902
> message s
: INTERNAL_ERROR: Contact Xilinx Technical Support.[.br]
: [message]

#---------------------------------------------------------------
# Informational and Other Messages
#--------------------------------------------------------------- 
M BOX_COST
> cost d
: Cost of box = [cost]

M IMPROVE
: * Improve initial placement:

M OPTIMIZE
: * Optimize the improved placement:

M HYDRA_UNSUPPORT
: Note: simulated annealing does not support Hydra parts at the moment.

E PLACER
#
# ------------------ router.m ------------------ 
#
#@(#)router.m	6.55  5/2/94
 
 
B ROUTER -start9901 -end10500 -current9927
: Detailed FPGA router
 
# Tool description (for program help)
M DESCRIPTION
: Detailed FPGA router for 3K, 4K XILINX chips
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

M CELL
: The input cellname containing a design to be routed.

M GUIDE_CELL
: The input cellname containing a design to be used as guide.

M DEBUG_NUM
: Debug all or a specific route number.

M DEBUG_NETNAME
: Debug a specific netname as being routed.

M DEBUG_LEVEL
: Debug level information.

M TIMING
: Do you want delay information to guide the router?

M MATCH_TYPE
: How do you want the net matching between the guide and design cell
: to be performed.

M LOCK_ROUTING
: Do you want routing taken from the guide cell locked?

M FEED_MODE
: Feedthru mode you want the router to use.

M BUFG_FEED
: Can the router use free BUFGP/BUFGS/GCLK/ACLK as feedthrus ?

M EFFORT
: Router effort.

M SWAP_MODE
: ?

M LOOP_ENABLE
: Is the the router loop enabled ?

M COMPLETE
: Is the design is complete or incomplete ?

M SWAP_PIN
: Do you allow pin swapping during routing?

M REROUTE_ALL
: Do you want to reroute every net from scratch?

M ROUTE_VCC_GND
: Do you want VCC and GND nets to be routed?

M DLYMAP
: ?

M PRINT_DLYMAP
: ?

M GOOD_NEWS
: ?

M RIPUP_ALLOWANCE
: Maximum # of ripup phases with regression allowed.

M INITIAL_MAX_DLY
: Initial maximum net delay.

M SECOND_MAX_DLY
: Second maximum net delay.

M WORST_DLY
: Worst case net delay.

M DLY_STEP
: Delay increment to use.

M IMPROVE
: Do you want to improve the net routing?

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M HCELL
: Expected is a cellname to be a PIC MAP file with BELs that have positions.
: The result is a file with routing information, that is a series of PIP and
: BELARC names.

M HGUIDE_CELL
: Expected is a cellname to be a PIC MAP file with BELs that have positions.
: It can also have routing. When this cell is missing no guide is used during
: routing.

M HDEBUG_NUM
: Specify  -1  if you want to debug every route. [.br]
: Specify a route number, 1 thru N, to be debugged. You must know this number
: from a previous run.

M HDEBUG_NETNAME
: Specify the netname you wish to debug.

M HDEBUG_LEVEL
: Specify  1  to produce informative level of debugging information. [.br]
: Specify  2  to produce detailed level of debugging. [.br] 
: Specify  3  to produce the most detailed debugging information which
: could be very large, therefore do not use this option for every net!

M HTIMING
: Specify  0  if you do not want delay information to be taken into
: account during routing. This is the fastest mode to run the router. 
: Specify  1  if you want net delay driven routing which does not use
: any path delay related information.
: Specify  2  if you want path delay information to guide the router.
: The default is  1, net delay driven routing.

M HMATCH_TYPE
: Specify  1  to direct the net matching to use STRONG matching criteria.
: That is, a given net in the guide must be fully routed and exportable
: to the design without any change.
: Specify  0  if you want WEAK matching to be used.
: That is, if any pin of a net in the guide is routed and exportable to
: the design that portion of the routing will be copied to the design.[.br]
: The default is  1, therefore STRONGE match will be used. 

M HLOCK_ROUTING
: Specify  0  if routing taken from the guide is not to be locked.[.br]
: Specify  1  if routing for STRONG matched nets to be locked only.[.br]
: Specify  2  if all routing taken from the guide is to be locked.[.br]

M HFEED_MODE
: Specify  0  to forbid the router to use any feedthrus. (For 3K only).
: Specify  1  to forbid the router to use feedthrus thru empty clb/iob blocks.
: The effect is that completely empty clb/iob blocks remain empty during 
: routing. Consequently we may see more unroutes and/or worse timing.
: When doing incremental design this feature could be very useful.
: Specify  2  if no restrictions apply to feedthru usage. When the design is
: said to be complete this is a suggested option.

M HEFFORT
: Specify -1  if you want to disable this parameter; back to the old days.
: Specify  0  if you do not want the router to do any routing.
: Otherwise the higher the number the higher the router effort.
: The largest effort number may result in excessive run time.

M HSWAP_MODE
: Feature for ppr internal use only...

M HBUFG_FEED
: Specify  0  if you want to preserv all the free BUFFERS.
: Specify  1  if you let the router use all the free BUFFERS.

M HLOOP_ENABLE
: Specify  NO or FALSE or 0 or OFF to turn off the router loop.
: The default is  YES,  we allow the router execute in a loop.

M HCOMPLETE
: Specify  NO or FALSE or 0 or OFF  to tell the router that the design
: is incomplete, therefore special error conditions may be allowed.
: The default is  TRUE, the design is assumed to be complete.

M HSWAP_PIN
: Specify  NO or FALSE or 0 or OFF if you do not want pin swapping.
: The default is  YES,  we allow the router to swap pins.

M HREROUTE_ALL
: Specify YES or TRUE or ON or 1 if you want the router to delete all the
: routing information which is not locked and reroute every net. [.br]
: The default value is NO, so we keep existing routing information. [.br]
: This option is not available on a net basis yet!

M HROUTE_VCC_GND
: Specify NO or FALSE or OFF or 0 if you do not want any VCC/GND sourced net
: to be routed.[.br]
: The default is that VCC/GND nets will be routed as non-timing critical nets.

M HDLYMAP
: Feature not supported...

M HPRINT_DLYMAP
: Feature not supported...

M HGOOD_NEWS
: Feature for ppr internal use only...

M HRIPUP_ALLOWANCE
: Specify 0 if you want no ripup and retry at all. [.br]
: Specify -1 if you want the router to keep doing ripup & retry until it gets
: stuck and no more progress can be made. Use it when you do not care what
: time it takes to finish routing.

M HINITIAL_MAX_DLY
: Specify the best net delay the router should use as a target value in
: nanoseconds. Upon exhaustive ripup and retry it will use the second_max_dly
: parameter as the next maximum delay value.
: Upon exhaustive ripup and retry it will increment this value
: by the dly_step parameter and continue routing using that value as a
: new net delay limit. Upon demand it can increment this value until it
: reaches the absolute limit specified by worst_dly.

M HSECOND_MAX_DLY
: Specify the second net delay the router should use as a target value in
: nanoseconds. Upon exhaustive ripup and retry it will increment this value
: by the dly_step parameter and continue routing using that value as a
: new net delay limit. Upon demand it can increment this value until it
: reaches the absolute limit specified by worst_dly.

M HWORST_DLY
: Specify the maximum acceptable net delay in nanoseconds. [.br]
: Be careful to specify a reasonable delay value, otherwise we may end up
: with lots of unrouted connections.

M HDLY_STEP
: The initial_max_dly is incremented by this value to be used as a
: new net delay limit for the next set of iterations.

M HIMPROVE
: Specify 1 or Y or TRUE or ON if you wish to improve every net routing
: even if the net is completely routed.
: The default is FALSE; no improvement takes place.

# Error and Warning Messages
M E_NO_NAME -e9901
: Cell name is required.

M E_BAD_ARCH -e9902
> arch s
: Netlist includes unroutable instance of "[arch]".

M E_INST_NOT_FOUND -e9903
> inst s
> net  s
: For net "[net]" instance "[inst]" not placed.[.br]
: The router cannot continue until this functional error is corrected.

M W_LOADLESS_NET -w9904
> net s
: Net "[net]" has no load.

M E_SOURCELESS_NET -e9905
> net s
: Net "[net]" has no source.[.br]
: The router cannot continue until this functional error is corrected.

M W_SOURCELESS_NET -w9906
> net s
: Net "[net]" has no source.[.br]

M E_MULTISOURCE_NET -e9907
> net s
: Net "[net]" has more than 1 source.[.br]
: For a multi-source net every source should be tristatable.[.br]
: The router cannot continue until this functional error is corrected.

M E_MISALIGNED_TBUFS -e9908
> net s
: Net:[net] has misaligned TBUFs.[.br]
: These TBUFs should be in the same row and use the same output pin.[.br]
: The router cannot continue until this functional error is corrected.

M E_MISALIGNED_DECS -e9909
> net s
: Net:[net] has misaligned DECODERs.[.br]
: These DECODERs should be along the same edge.[.br]
: The router cannot continue until this functional error is corrected.
 
# Informational and Other Messages

M NET_IGNORED
> source  s
> net  s
: [source] net "[net]" ignored as requested.

M ROUTING_SKIPPED
: [.br]No detailed routing is performed; as requested.[.br][.br]

M E_RESERV_CONFLICT -e9910
> belnode_name  s
> net1  s
> net2  s
: Warning: trying to reserv belnode "[belnode_name]" for net:[net1][.br]
: Belnode is already reserved for net:[net2][.br]
: Ignore this message if the nets involved completely route.[.br]

M E_TBUF_RESERV_CONFLICT -e9911
> seg_name  s
> net1  s
> net2  s
: Warning: trying to reserv longline:"[seg_name]" for net:[net1][.br]
: Longline is already reserved for net:[net2][.br]

M E_PREROUTED_SIGNAL_SHORT -e9912
> net1   s
> net2   s
> resource  s
: Pathological case encountered.[.br]
: Pre-routed net:[net1] is shorted with net:[net2][.br]
: Both are trying to use resource:"[resource]"[.br]
: This is a catastrophic error...no routing is performed.[.br]

M DESIGN_INFO
> nets d
> subnets d
> largest d
> int d
> ext d
> vcc d
: # of nets: [nets],  # of loadpins: [subnets].[.br]
: Largest net has a fanout of [largest].[.br]
: # of internal connections to route: [int].[.br]
: # of external connections to route: [ext], ([vcc] VCC/GND).[.br]

M LAST_UPDATE
> date s
: [.br] Last update to router: [date].[.br]

M TECHNOLOGY_INFO
> blocks d
> nodes  d
> arcs   d
: # of tifblocks: [blocks].[.br]
: # of mazenodes: [nodes].[.br]
: # of  mazearcs: [arcs].[.br]

M MAZE_STATUS_REPORT
> time     s
> percent  d
: [time] ....  [percent]%  routed.

M MAZE_STATUS_MSG
> time  s
> msg   s
: [time] ....  [msg].

M MAZE_START_SPECIAL_T0
> type s
> s d
: Begin pre-routing, [type], TIMING=OFF; [s] connections.

M MAZE_START_SPECIAL_T1
> type s
> s    d
> dly  d
: Begin pre-routing, [type], max_dly=[dly] ns; [s] connections.

M MAZE_START_SPECIAL_T2
> type s
> s d
: Begin pre-routing, [type], TIMING=PATH; [s] connections.

M MAZE_START_ROUTE_T0
> s d
: Begin routing, NO_RIP, TIMING=OFF; [s] connections.

M MAZE_START_ROUTE_T1
> s d
> dly  d
: Begin routing, NO_RIP, max_dly=[dly] ns; [s] connections.

M MAZE_START_ROUTE_T2
> s d
: Begin routing, NO_RIP, TIMING=PATH; [s] connections.

M MAZE_START_RIPUP_T0
> s d
> n d
> vcc d
> news s
: Begin fixing [s] unroutes on [n] nets, ([vcc] VCC/GND), TIMING=OFF; [news]

M MAZE_START_RIPUP_T1
> s d
> n d
> dly  d
> vcc d
> news s
: Begin fixing [s] unroutes on [n] nets, ([vcc] VCC/GND), max_dly=[dly] ns; [news]

M MAZE_START_RIPUP_T2
> s d
> n d
> vcc d
> news s
: Begin fixing [s] unroutes on [n] nets, ([vcc] VCC/GND), TIMING=PATH; [news]

M MAZE_START_PULLUP
> s d
: Begin routing [s] pullups, TIMING=OFF

M MAZE_NUM_UNROUTES
> unroutes  d
: [.br]Design has  [unroutes]  unroutes.[.br]

M MAZE_START_IMPROVE_PATH
> pin d
: Begin improving path delay for [pin] pins.

M MAZE_START_IMPROVE_PATH_BEST
> dly  f6.1
> pin  d
: Begin improving a [dly]ns  path with [pin] pins.

M MAZE_START_IMPROVE_PATH_RIGID
> dly   f6.1
> pin   d
> slack f5.1
: Improving a [dly]ns  path with [pin] pins. (slack [slack]ns).

M IGNORE_PA_REPORT
: [.br] No path delay report is produced because there are unroutes.

M E_PATHOLOGICAL_NET -e9913
> net  s
> pin  s
> inst s
: The signal "[net]" cannot be routed to pin "[pin]" on symbol "[inst]",
: given the current design placement and guided routing (if any).[.br][.br]
: An LCA file will be generated to permit analysis of this problem.
: Possible resolutions are discussed below.[.br]
: If a guide design is being used, guided routing may obstruct the
: routing of new (or unmatched) design logic. To allow PPR to rip up
: guided routing where necessary to route another signal, change the
: lock_routing option to NONE. Alternatively, edit the guide file in
: EditLCA to unroute signals for which preservation of routing is less
: critical: this will free up routing resources while preserving the
: routing on the most important paths.[.br][.br]
: If there is no guide design, there may be a problem with the
: placement of the related logic. Examine the LCA file in EditLCA
: to determine the nature of the placement problem: the addition of
: placement constraints may allow this signal to be routed.[.br]

M E_PATHOLOGICAL_FINAL -e9926
> net  s
> inst s
: The signal "[net]" cannot be routed to symbol "[inst]",
: given the current design placement and guided routing (if any).[.br][.br]
: An LCA file will be generated to permit analysis of this problem.
: Possible resolutions are discussed below.[.br]
: If a guide design is being used, guided routing may obstruct the
: routing of new (or unmatched) design logic. To allow PPR to rip up
: guided routing where necessary to route another signal, change the
: lock_routing option to NONE. Alternatively, edit the guide file in
: EditLCA to unroute signals for which preservation of routing is less
: critical: this will free up routing resources while preserving the
: routing on the most important paths.[.br][.br]
: If there is no guide design, there may be a problem with the
: placement of the related logic. Examine the LCA file in EditLCA
: to determine the nature of the placement problem: the addition of
: placement constraints may allow this signal to be routed.[.br]

M E_INTERNAL_DATA_PROBLEM -e9914
: [.br]Internal PPR datastructure problem detected[.br]
: This is a catastrophic error...no routing is performed. [.br]

M MAZE_SUMMARY
> unrout  d
> pip     d
> feed    d
> loc     d
> dbl     d
> lng     d
> glb     d
> trx     d
: [.br]
: Resource_usage: Pips [pip], Feeds [feed], Locals [loc], Doubles [dbl]
: [.br]                Longs [lng], Globals [glb], Dec_lines [trx]
: [.br] [.br]# of unrouted connections: [unrout]. [.br]

M E_SIGNAL_COLLISION -e9915
> net1 s
> net2 s
: Collision between net:[net1] and net:[net2]. [.br]
: Resource assumed by net:[net1] already taken by net:[net2].

M E_BAD_DLY_PARAM -e9916
> idly  d
> sdly  d
> wdly  d
: Improper delay parameters:[.br]
: initial_max_dly:[idly][.br]
: second_max_dly:[sdly][.br]
: worst_dly: [wdly][.br]

M E_UNKNOWN_LCATYPE -e9917
> type  d
: Unknown lcatype:[type][.br]
: The router cannot continue until this error is corrected.[.br]

M E_PAD_3K_CLK_INV_ERROR -e9918
> netname  s
> pinname  s
: Pad clock inversion error encountered. [.br]
: Pin:[pinname]  of  net:[netname] will cause DRC error.[.br]

M E_SPEC_PIN_ROUTING
> msg  s
> count d
: Pre-route Failure: [msg]:[count]. Router cannot continue.[.br]

M PAD_CLK_EXT_3K -e9921
: The IOB clock pins in the design cannot be completely routed. An
: LCA file will be generated to permit analysis of this problem.
: Possible resolutions are discussed below.
: [.br][.br]
: The XC3000 architecture includes two clock lines on each edge of
: the device. Therefore, the IOBs on a given device edge can be
: clocked by two different signals at most. For clock signals which
: control both rising-edge and falling-edge I/O flip-flops (or both
: transparent High and transparent Low input latches) on the same
: edge of the device, both clock lines on that edge are needed; only
: the ACLK buffer can route to both clock lines in this manner.
: [.br][.br]
: If dual-phase IOB clocks are being used, ensure that they are
: either (1) sourced by the ACLK buffer, or (2) constrained to
: different edges of the device. If the design contains more than
: two different IOB clocks (with dual-phase clocks counting as two),
: constrain the I/Os such that there are no more than two per edge.[.br]

M TBUF_CLK_EXT_3K -e9922
: TBUF input pins and/or clock pins not sourced by GCLK or ACLK cannot
: be completely routed. An LCA file will be generated to permit analysis
: of this problem. Possible resolutions are discussed below.
: [.br][.br]
: For clock signals NOT sourced by GCLK or ACLK, there are a limited
: number of routing resources to CLB clock pins. In addition, some of
: these limited routing resources are shared by the I pins of TBUFs.
: Depending on the placement of the clock loads and TBUFs, some of these
: connections may not be routable.
: [.br][.br] 
: The best solution to this problem is to use GCLK or ACLK for clock
: signals, if either is available. If possible, reduce the number of
: clocks by using clock-enable signals to control loading of flip-flops.
: [.br][.br]
: Alternatively, floorplan the design so that TBUFs are placed adjacent
: to the CLBs that source their I pins: this will allow the TBUF inputs
: to connect directly to the CLB outputs, without using the limited clock
: routing resources.[.br]

M BUFGP_EXT_4K -e9923
: The primary global buffer(s) in the design cannot be completely
: routed. An LCA file will be generated to permit analysis of this
: problem. Possible resolutions are discussed below by load pin type.
: [.br][.br]
: For details on global buffer usage in your design, see the "Clock
: Signals Report" chapter of the XNFPREP report file. This report also
: describes the connectivity of XC4000 global buffers and explains how
: to choose and floorplan them.
: [.br][.br]
: RAM WRITE-ENABLE PINS -- PPR will not route a write-enable sourced
: by a BUFGP unless it can be connected directly to the global buffer
: network. To allow this direct connection to be made, lock the BUFGP
: to the top-right or bottom-right corner of the device: both of these
: BUFGPs can connect to write-enables directly. Alternatively, the
: direct connection requirement can be lifted by specifying the 
: following on the PPR command line: restrict_bufg=FALSE. If you use
: this option, you should apply XACT-Performance requirements to these
: paths so that they are not left uncontrolled.
: [.br][.br]
: NON-CLOCK PINS -- If the selected BUFGP cannot connect directly to
: a non-clock pin (other than a write-enable), PPR will attempt to make
: the connections indirectly by routing through empty function
: generators or other blocks. However, it can do so only IF those block
: resources are available, and IF through-routes are enabled. Given
: these limitations, possible resolutions are as follows:
: [.br][.br]
: (1) Change the option route_thru_blks to OK (if complete=FALSE,
:     route_thru_blks defaults to LIMIT).[.br]
: (2) Source non-clock pins from the input side of the BUFGP, so that
:     they are not routed through the global buffer network.[.br]
: (3) Use a secondary global buffer rather than a primary.[.br]
: (4) Floorplan the BUFGP (and its loads) so that all required pins
:     can connect directly from the global buffer network.[.br]

M BUFGS_EXT_4K -e9924
: The secondary global buffer(s) in the design cannot be completely
: routed. An LCA file will be generated to permit analysis of this
: problem. Possible resolutions are discussed below by load pin type.
: [.br][.br]
: For details on global buffer usage in your design, see the "Clock
: Signals Report" chapter of the XNFPREP report file. This report also
: describes the connectivity of XC4000 global buffers and explains how
: to choose and floorplan them.
: [.br][.br]
: CLOCK PINS -- PPR will not route a clock pin sourced by a global
: buffer unless it can be connected directly to the global buffer
: network. If the design contains more than four global buffers total,
: they may compete for the four global buffer longlines in any given
: column. If one column contains load pins for more than four global
: buffer outputs, some of these will not be directly connectable. 
: Possible resolutions to this problem are:
: [.br][.br]
: (1) Floorplan the loads of the global buffers so that no more than
:     four global buffer outputs are required in any given column.[.br]
: (2) Reduce the number of global buffers in the design to four or
:     fewer; if possible, reduce the number of clocks by using clock-
:     enable signals to control loading of flip-flops.[.br]
: (3) Lift the direct connection requirement by specifying the 
:     following on the PPR command line: restrict_bufg=FALSE. If you
:     use this option, you should apply XACT-Performance requirements
:     to these paths so that they are not left uncontrolled.
: [.br][.br]
: RAM WRITE-ENABLE PINS -- PPR will not route a write-enable sourced
: by a global buffer unless it can be connected directly to the global
: buffer network. Although two of the four global buffer longlines in
: any given column can connect directly to write-enable pins, signals
: on other global buffers may compete for these resources. Possible
: resolutions to this problem are:
: [.br][.br]
: (1) If possible, use primary global buffers for write-enable(s),
:     and lock these BUFGPs to either the top-right or bottom-right
:     corner of the device: these can always connect directly.[.br]
: (2) Floorplan the loads of the global buffers so that no more than
:     two write-enable signals are required in any given column. You
:     may also need to floorplan clock loads so that other global
:     buffers do not compete for these resources.[.br]
: (3) Lift the direct connection requirement by specifying the 
:     following on the PPR command line: restrict_bufg=FALSE. If you
:     use this option, you should apply XACT-Performance requirements
:     to these paths so that they are not left uncontrolled.
: [.br][.br]
: NON-CLOCK PINS -- If the selected global buffer cannot connect directly
: to a non-clock pin (other than a write-enable), PPR will attempt to
: make the connections indirectly by routing through empty function
: generators or other blocks. However, it can do so only IF those block
: resources are available, and IF through-routes are enabled. Given
: these limitations, possible resolutions are as follows:
: [.br][.br]
: (1) Change the option route_thru_blks to OK (if complete=FALSE,
:     route_thru_blks defaults to LIMIT).[.br]
: (2) Source non-clock pins from the input side of the global buffer,
:     so that they are not routed through the global buffer network.[.br]
: (3) Floorplan the global buffer (and its loads) so that all required
:     pins can connect directly from the global buffer network.[.br]

M TBUF_CLK_WE_EXT_4K -e9925
: Clock pins not sourced by global buffers, TBUF input pins and/or T pins,
: and/or RAM write-enable pins cannot be completely routed.[.br]
: An LCA file will be generated to permit analysis of this problem.
: Possible resolutions are discussed below by load pin type.
: [.br][.br] 
: CLOCK PINS AND TBUF I PINS -- For clock signals NOT sourced by global
: buffers, there are a limited number of routing resources to CLB clock
: pins. In addition, some of these limited routing resources are shared
: by the I pins of TBUFs. If a given column contains several different
: clock loads and/or TBUF input signals, some of these connections may
: not be routable. 
: [.br][.br] 
: The best solution to this problem is to use global buffers for clock
: signals, if this can be done without overutilizing the global buffer
: resources. For guidelines to follow when assigning global buffers, see
: the "Clock Signals Report" chapter of the XNFPREP report file. If global
: buffers cannot be effectively added to the design, the alternative is to
: floorplan the design so that TBUFs are placed adjacent to the CLBs that
: source their I pins: this will allow the TBUF inputs to connect directly
: to the CLB outputs, without using the limited clock routing resources.
: [.br][.br] 
: TBUF T PINS -- If TBUFs in a single column require more than three
: different enable signals, there may be insufficient routing resources
: to connect all of the TBUF T pins. The resolution to this problem is
: to floorplan the design so that TBUFs with different enable signals
: are placed in different columns.
: [.br][.br] 
: RAM WRITE-ENABLE PINS -- If a high-fanout RAM write-enable signal is
: not sourced by a global buffer, it has a limited number of longline
: resource available for distribution. If many different write-enable
: signals control RAMs in a single column, these connections may not be
: possible to make.
: [.br][.br] 
: The best solution to this problem is to use global buffers to source
: some write-enable pins, if this can be done without overutilizing the
: global buffer resources. For guidelines to follow when assigning global
: buffers, see the "Clock Signals Report" chapter of the XNFPREP report
: file. If global buffers cannot be effectively added to the design, the
: alternative is to floorplan the design so that RAMs with different
: write-enables are placed in different columns.[.br]

M E_INTERNAL_PATH_ANALYZER_ERROR -e9920
> netname  s
> pinname  s
> delay    d
: For net:[netname][.br]
:     pin:[pinname][.br]
: Router received bad delay value:[delay]   (0.1 ns)

M ASSERT_FAIL
> msg  s
: [.br]INTERNAL ROUTER PROBLEM; ASSERTION FAILED:[.br]
: ASSERT([msg]).[.br]

M ROUTER_SUSP_ENABLE
: + Suspension enabled: cntl-C/cntl-Break to save current routing.

M ROUTER_SUSP_DISABLE
: + Suspension disabled: cntl-C/cntl-Break will stop program.

E ROUTER
#
# ------------------ cstmerge.m ------------------ 
#
#@(#)cstmerge.m	6.20  4/26/94
 
 
B CSTMERGE -start5801 -end6100 -current5837
: constraints merger program
 
# Tool description (for program help)
M DESCRIPTION
: This program merges the XNF format constraints in the PIC file with
: the cell's cst constraints file.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

M MCELL
: This is the name of the cell.

M MCSTFILE
: This is the name of the constraints file, if any.

M MAUTO
: This signals part has been autoselected.

# Expert Parameter Names
M MCONTINUE_ON_ERROR
: Whether to continue normally on error or not.

M MIGNORE_XNF_LOCS
: Whether to use locs from the .xnf file or not.

M MIGNORE_RLOCS
: Whether to use RLOCs from the .xnf file or not.

M MMIN_REUSE_LOCLIST
: Minimum size of a location list to reuse.

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M HCELL
: This is the name of the cell.

M HCSTFILE
: This is the name of the input/output constraints file.
: Default name will be the same as the cell's.

M HAUTO
: If the LCA part has been autoselected, a special warning message 
: will be issued about the possibility of many warning messages
: about invalid constraints due to location constraints
: assigned assuming a different part.

# Expert Help Messages
M HCONTINUE_ON_ERROR
: If TRUE ppr will continue even if there are location constraint errors. This
: should never be used and is really only available for testing.
# also to circumvent a REAL bug.

M HIGNORE_XNF_LOCS
: If TRUE the location constraints from the .xnf file will be ignored. Only 
: the constraints from the .cst file will be used, if any.

M HIGNORE_RLOCS
: If TRUE the RLOC location constraints from the .xnf file will be ignored.
: This includes RLOC, RLOC_RANGE, and RLOC_ORGIN.

M HMIN_REUSE_LOCLIST
: This value is set to minimize the amount of memory cstmerge and other
: tools will use. The default number should be fine. The number indicates
: the minimum size a location list must exceed before being reused.

M MIGNORE_LOCS
: Ignore the LOC parameters from the design file.

M HIGNORE_LOCS
: The design file LOC parameters of the specified type will be ignored
: by PPR.

M MIGNORE_LOCS_NONE
: Ignore none of the LOCs.

M HIGNORE_LOCS_NONE
: All LOCs will be used as specified.

M MIGNORE_LOCS_ALL
: Ignore all LOCs.

M HIGNORE_LOCS_ALL
: No LOCs will be used in PPR.

M MIGNORE_LOCS_IO
: Ignore LOCs on I/Os.

M HIGNORE_LOCS_IO
: All I/O LOCs will be ignored by PPR.

M MIGNORE_LOCS_INTERIOR
: Ignore LOCs on interior(i.e. core) logic.

M HIGNORE_LOCS_INTERIOR
: Only LOCs on I/Os will be used by PPR.

M PICTYPE
: Type of the input PIC cell. 

M HPICTYPE
: Type of the input PIC cell. If nothing is specified, PIC type is used. 
:[.br]When CSTMERGE is called from PPR the second time, the input PIC cell type
:[.br]will be set to PIC_MAP for 4k.

#M MUSE_FG_CONSTRAINTS
#: Use function generator constraints from the .cst file.

#M HUSE_FG_CONSTRAINTS
#: 4k option ONLY. Typically used during floor planning.
#: The constraint from the .cst file for a function generator will
#: override the constraint that was transferred from the F/HMAP
#: symbol(i.e. it existed) when the function generator was created.

# ********************************
# Error and Warning Messages; These are the core messages
# ********************************

M PADU_ON_A_BONDED_PAD -e5801
> pin s
> inst s
: The [inst] is using a bonded location '[pin]'.
: UPADs and the associated iob logic of a UPAD can only go in unbonded locations.
#: Package pin '[pin]' for instance(specified as an unbonded pad) '[inst]' is
#: is using a location that is bonded to an external pin.
#R
#:Changing the UPAD to a PAD symbol would eleminate this message. No
#:harm in not doing anything. Note that the pin on the packge will be
#:driven.

M PAD_ON_AN_UNBONDED_PAD -e5802
> pin s
> inst s
: The [inst] is using an unbonded location '[pin]'. 
: PADs and the associated iob logic of a PAD can only go in bonded locations.
#: Die pad '[pin]' for instance(specified as an bonded pad) '[inst]' is 
#: using an unbonded pad with no external connection.
#R
#:Changing the PAD to a UPAD symbol would eleminate this message. No
#:harm in not doing anything. Note that there is no pin on the packge that
#:will be connected to this pad on the device.

M NO_UNBONDED_PADS_FOR_PKG -e5803
> inst s
: There are no unbonded pads for this package. Change [inst]
: from a UPAD to a PAD.

M CST_CONFLICTING_INST_NAMES -e5804
> inst s
> belname s
> name s
: Conflicting instance .extension '[belname]' and '[name]' locations were assigned to
: instance '[inst]'. 
#R
#: All the belnames used in location constraints for an instance must match.
#: Use a wildcard belname constraint or no belname constraint at all.

M CST_CONFLICT_INST_CONST -e5805
> name s
: Constraints assigned to [name] are in conflict. 
#R
#: Resolve surrounding messages to correct the problem. 

M UNKNOWN_CONSTRAINT_CODE -e5806
> code d
> instance s
: Unknown constraint code '[code]' found for [instance].
#R
#: Take the offending constraint out of the design. The 'code' is most likely
#: not currently implemented. Usually means the parser/data-handler can
#: read the data, but the application (i.e. cstmerge) doesn't recognize it.

M ILLEGAL_PIN_LOCATION -e5807
> part s
> names z
: The following I/O signals were constrained to invalid IOB locations
: for the part [part]. Check that the specified locations are valid
: I/O package pins for this device. (To place an I/O signal on one of
: the dual-purpose pins TDO, MD0, MD1 or MD2, use the corresponding
: special pad symbol in your design. No constraints are required on
: special pad symbols.)[.br][names]
#R
#: ?? should mention that locs are ignored on special pins.
#:Could be one of many things:
#:  - The pin is not acutally connected to the die.
#:	- The loc is illegal syntax for this type of pin.
#:  - The pin name is not a real pin name at all(see XACT-EDITLCA).
#:  - trying to loc a special pin

M INVALID_CST_BEL_FOR_INST -e5808
> inst s
> belname s
: Invalid .extension location '[belname]' assigned to [inst] from the .cst file.  
#R
#: Use only legal belnames for each type of instance as stated in the
#: location constraints section of the reference manual.

M INVALID_XNF_BEL_FOR_INST -e5809
> inst s
> belname s
: Invalid .extension location '[belname]' assigned to [inst] from the .xnf file.  
#R
#: Use only legal belnames for each type of instance as stated in the
#: location constraints section of the reference manual.

M ILLEGAL_CST_LOC -e5810
> names z
: Illegal constraint locations in constraints file for the following instances: 
: [.br][names]
#R
#: Wrong type of location constraint for this type of instance. There are
#: five types of locations constraints: IOB | CLB | TBUF | CLOCK | DECODER.
#: Match the location type to the instance type.

M ILLEGAL_XNF_LOC -e5811
> name s
: Illegal constraint location for [name] in .xnf file.  

M NO_SUCH_INST -e5812
> name s
: Constraint file instance '[name]' could not be matched to a constrainable instance 
: in net list.
#R
#: Check the spelling of the instance name or BLKNAM attribute value.

M NO_SUCH_NET -e5813
> name s
: Constraint file net '[name]' could not be found in net list.
#R
#: Check the spelling of the net name.

M NO_SUCH_BLOCK -e5814
> name s
: Constraint file block name '[name]' could not be found in net list.
#R
#: Check the spelling of the block name.

M NET_CONSTRAINT_EXISTS_IN_XNF -e5815
> name s
: The .cst file net constraint for net '[name]' already has a constraint
: from the .xnf file.
#R
#: Delete or correct one of the constraints and continue.

M MULTIPLE_NET_CONSTRAINTS_CST -e5816
> name s
: There are multiple net constraints for the net '[name]' defined in the 
: .cst file.
#R
#: Delete or correct one of the constraints and continue.

M WRONG_LOC_TYPE_FOR_ELEMENT -e5817
> loctype s
> element s
> inst s
: Wrong '[loctype]' location type for [inst] referenced by '[element]' in .cst file.
#R
#:Use the correct location type for the type of element being constrained.

M ILLEGAL_DECODER_LOC -e5818 -w5819
> inst s
: Illegal location constraint for the edge decoder '[inst]'. A single full-edge
: (i.e. T, L, B, R) or a single half-edge(i.e. LT, LB, RT, RB, BR, BL, TR, TL)
: location is the only allowable constraint. Prohibit and multiple 
: constraints canot be applied to edge decoders. 
#R
#:Use the correct location type for the decoder. May either be in the .xnf
#:file or the .cst file.
 
M NO_VALID_CONSTRAINTS -e5820
> instname s
: No valid PLACE or NOT_PLACE constraints for [instname].
#E
#: Due to errors in the specification of all the location constraints for
#: this instance, no legal or illegal locations will be added to the 
#: constraints list.

M WILD_RANGE -e5821
> instname s
: Constraint for instance '[instname]' includes a 'range' composed of
: wild cards.  This syntax is currently not supported.
#R
#: Check(then modify if theres a problem) that the location constraints
#: are in the range for this part (e.g. if there are 10 rows on a part and
#: a instance is constrainted to row 11). A range must include an explict
#: lower-left and upper-right location specification.

M CLB_LOC_COLLISION -e5822
> inst1 z
> inst2 z
> inst3 z
: The following three instances [.br]
: '[inst1]' and [.br]
: '[inst2]' and [.br]
: '[inst3]' [.br]
: are all constrained to be placed into a single CLB. It is impossible to 
: place more than 2 of these instances into a single CLB.

M COLLISION -e5823
> inst1 s
> inst2 s
: You have constrained the two instances [.br]
: '[inst1]' and [.br]
: '[inst2]' [.br] to be placed in a single, identical slot.  It is impossible
: to satisfy both these constraints. Please correct the problem.

M INST_DID_NOT_MEET_CONSTRAINT -e5824
> inst s
: The [inst] did not meet the specified location constraint.
#R
#: This could be due to :
#:     - impossible conditions(i.e. incorrect) described by the constraints.
#:     - extreamly difficult conditions detailed by the constraints(i.e. only
#:       one solution out of millions of possiblities).

M PLACE_INSTANCE_NOT_ALLOWED -e5825
: The 'place instance' or 'notplace instance' constraints are not allowed 
: for 3ka designs in the .cst file.

M GLOBAL_BUFFER_SOURCED_BY_NONDEDICATED_PAD -e5826
> s1 s
: The global buffers have dedicated pads that are used for directly driving
: the global buffer from an external source. If the dedicated pad is not used
: then an IBUF must be inserted between the pad and the buffer.[.br]
: The [s1] is being sourced from a pad other than the dedicated pad. Either
: remove the constraint (or change it to the dedicated pad location) or add
: an IBUF.

M LOC_ON_RLOC_NOT_ALLOWED -e5827
> type s
> symbol s 
: The [type][symbol] has both an RLOC constraint and an absolute
: location constraint in the .CST file. RLOC sets cannot be constrained
: via the .CST file. To lock an RLOC set to an absolute location on the
: device, use an RLOC_ORIGIN parameter on the schematic. 

M SYNTAX_ERROR -e5828
> token s
> appendage m
: error on "[token]" [appendage]

#M GIVE_UP
#: Giving up - too many errors.

M BAD_LOC -e5829
: Illegal location name.

M NO_WILD_CARD -e5830
: Improper use of wild card.

M WILDCARD_LOC_MATCHING -w5832
: Check all schematic and/or .CST file constraints that apply. Note that
: .CST file statements of the form 'notplace block * : <locations>;' or
: 'notplace instance * : <locations>;' will apply to every symbol of
: the appropriate type.

M DEDICATED_PAD_MUST_BE_USED -e5831
> inst s
: The dedicated pad for the global buffer must be used by the pad driving the
: global buffer. Remove the location constraint on [inst] which is in
: the dedicated pad location.

M LOC_ON_PULLUP_SOURCED_BY_DECODER -w5833
> inst s
> signal s
: The [inst] (connected to decoder output '[signal]') 
: is constrained to a specific location. Location constraints on decoder
: pullup resistors are not supported and will be ignored.[.br]
: To constrain a decoder signal to a specific edge or half-edge of the
: device, place a constraint on the DECODER symbols
: and/or WAND symbols (with the :DECODE attribute) which make up the decoder.

M SPECIAL_PAD_LOCS_ARE_IGNORED -w5834
> inst s
: The [inst] can only be placed in one location. The constraint(s) on this
: symbol will be ignored.

M NO_2_EXTENSION_ON_ROW_1 -e5835
: Row number 1 for TBUFs and PULLUPs does not have a location that may be specified
: with the extension of 2 (i.e. TBUF.AB.2).

M TOOL_PLOG_ERROR -e5836
> message s
: [message]
# this is just a general purpose error that can be used to report errors until
# they are well enough defined and/or it is decided that it will actually be 
# an error

# ********************************
# Informational and Other Messages
# ********************************

M LOC_LIST_TITLE
: The list of instances and their actual x, y, and element values which
: had location constraints from the .xnf and/or the .cst files.[.br]
: [.br]
:    INSTANCE                        X      Y      ELEMENT[.br]
:--------------------------------------------------------------------------

M LOC_LIST_INSTS
> line s
: [line]

M CHIP_SIZE
> x d
> y d
: The size of the chip is [x] by [y].

M READING_PIC
: Loading the PIC net list

M READING_CST
: Loading the constraints file

M CSTMERGE_MAIN
: CSTMerge main routines

M OUTPUT
: Writing PIC net list

M PART_AUTO_SELECTED_WARNING
: The above warning messages may be the result of constraints specific
: to another LCA part type 
: since you opted for the part auto-selection feature of PPR.
#R
#: Force the selection of the part by using the xactinit.dat or XACT at run
#: time.

M HIT_BUT_RUNNING
: (.. Continuing despite apparent collision, due to xactinit.dat 
: ppr_continue_on_collision directive.)

E CSTMERGE

#
# ------------------ xnfmxn2.m ------------------ 
#
#@(#)xnfmxn2.m	6.25  4/14/94
 
 
B XNFMXN2 -start5601 -end5675 -current5630
: XNF to MXN file translator, v. 2
 
# Tool description (for program help)
M DESCRIPTION
: The XNFMXN2 tool translates a trimmed flattened XNF file to a MXN or
: PIC file.
: It does all the necessary conversions within the XNF file to make it
: a legal MXN file with the following limitations:
: [.br]   Only 4K, 3KA, 3KL, and 3100A part families are supported.
: [.br]   Only one network per design is supported.
: [.br]   Macros are not supported.
: [.br]   The following XNF record types are not supported:
: [.br]       CFG, MODEL, ENDMODEL.

 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M INFILE
: Input XNF File

M OUTFILE
: Output MXN or PIC File

M PARTTYPE
: Number of the part to use

M PICTRANS
: Activates generation of PIC file instead of MXN file.

M DEBUGMODE
: Activates output of information on the progress of translation


# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HINFILE
: This parameter is used to specify the XNF file to be translated.
: If an input file extension is specified, an attempt is made to read
: a file with that extension.
: If no file extension is specified, a default extension of ".xtf" is
: used.  If no file is found with this extension, or if the part is
: a 3K family part, then a default extension of ".map" is used.

M HOUTFILE
: You can use this parameter to specify the name of the MXN (or PIC) file
: to which the translated input file is written.  The output file extension
: is ignored.
: If no output file name is specified, the translated file will be written
: to a file with the same base name as the input file.
: In either case, the output file extension is ".n" for a MXN file or ".p"
: for a PIC file.

M HPARTTYPE
: You can use this parameter to specify the number of the part to use for
: the translation.
: If no part type is specified on the command line, then the part type
: specified in the input file, if any, will be used.
: If no part type is specified on the command line or in the input XNF file,
: then the translation will fail.

M HPICTRANS
: This boolean parameter causes the output file generated by this program
: to be in the PIC format instead of the MXN format.

M HDEBUGMODE
: This boolean parameter causes additional information on the progress of
: the translation to be output to the display and the log file.  It is
: intended for debugging purposes.

 
# Error and Warning Messages
M INPUT
: input

M OUTPUT
: output

M WRITING
: writing

M FILE_EXTENSION_ERROR -e5601
: Unable to set file extension.[.br]

M XNF_CELL_ERROR -e5602
> name s
> extension s
: Unable to open file "[name].[extension]".  Check to make sure this
: file has been created, and that it is in the current directory.[.br]

M XNF_CELL_ERROR2 -e5603
> name s
: Unable to open "[name].xtf" (for 4K family designs) or "[name].map"
: (for 3K-A/L and 3100A family designs).  Check to make sure this file
: has been created, and that it is in the current directory.[.br]
		
M EXPANSION_ERROR -e5604
: An error occurred in expanding an XNF symbol to multiple symbols.[.br]

M NOT_TRIMMED_ERROR -e5605
> symname s
> symtype s
> signame s
: The symbol `[symname]' (type=[symtype], output signal=[signame])
: should have been trimmed and cannot be processed:
: [.br]    An OUTFFT symbol must have both T and O pins connected.
: [.br]    AN INFF or INLAT symbol must have a connection to the D pin.[.br]

M CELL_CREATION_ERROR -e5606
: Unable to create output MXN or PIC cell.[.br]

M NOT_FLAT_ERROR -e5607
: Design has not been flattened.[.br]

M NO_PARTTYPE -e5608
: No part type was specified on the command line or in the input file.
: A part type must be specified.[.br]

M PARTTYPE_ERROR -e5609
> parttype s
: Unable to set part type to [parttype].[.br]

M FAMILY_ERROR -e5610
: Specified part family is not supported or is not consistent with the
: type of the input file.[.br]

M COPY_HISTORY_ERROR -e5611
> data s
: Unable to copy history data [data].[.br]

M MXN_NET_ERROR -e5612
> signame s
: Unable to create MXN net for signal with name "[signame]".[.br]

M TRANS_USER_ERROR -e5613
> name s
> value s
: Error translating XNF USER record to MXN USER record:
: [.br]  Type=[name]
: [.br]  Data=[value][.br]

M INVERSION_ERROR -e5614
> pinname s
> symname s
> symtype s
> signame s
: Noninvertible pin `[pinname]' on symbol `[symname]'
: (type=[symtype], output signal=[signame])
: is inverted.[.br]

M SYMBOL_ERROR -e5615
> symbol s
> type s
: Symbol [symbol] of type [type] is not allowed.[.br]

M SYMBOL_LIST -e5616
> parttype s
> list z
: The following symbols are not valid primitives in the part
: `[parttype]'. [.br][.br]
: [list]Please consult the design flow diagrams in the PPR chapter of the
: XACT Reference Guide to determine the correct design flow for the
: part `[parttype]'. All hierarchical modules must be expanded and
: flattened into the top-level design before running PPR. [.br][.br]
: Specific non-primitive symbols are resolved as follows: [.br][.br]
: * All soft macros and RPMs (both Xilinx- and user-created) are
: [.br]  flattened by the XNFMERGE program. [.br][.br]
: * Old-style hard macros are translated to RPMs by the HM2RPM
: [.br]  program and are then flattened by XNFMERGE. [.br][.br]
: * X-BLOX symbols are expanded and flattened into the top-level
: [.br]  design by the XBLOX program. [.br]

M CELLLIB_FIND_ERROR -e5617
> name s
> type s
: Unable to find symbol in cell library:
: [.br] Name=[name] Type=[type][.br]

M MXN_ARCH_ERROR -e5618
> xnfname s
> xnftype s
> mxnname s
> mxntype s
: Error in creating MXN archetype for XNF symbol:
: [.br]   XNF symbol name=[xnfname], type=[xnftype]
: [.br]   MXN instance name=[mxnname], type=[mxntype][.br]

M MXN_INST_ERROR -e5619
> xnfname s
> xnftype s
> mxnname s
> mxntype s
: Error in creating MXN instance for XNF symbol:
: [.br]   XNF symbol name=[xnfname], type=[xnftype]
: [.br]   MXN instance name=[mxnname], type=[mxntype][.br]

M EQ_CONVERT_ERROR -e5620
> symname s
> symtype s
> signame s
> pname s
> pvalue s
: The value of the equation parameter `[pname]=[pvalue]'
: on the symbol `[symname]' (type=[symtype], output signal=[signame])
: is not a valid equation.[.br]

M NO_SYMBOL_ERROR -e5628
: This design has no symbol.[.br]

M UNKNOWN_SP_PAD -e5621
> padname s
> padtype s
: Special pad `[padname]' (type=[padtype]) is an unknown type of special pad.[.br]

M BAD_SP_PAD -e5622
> padname s
> padtype s
: Special pad `[padname]' (type=[padtype]) has no associated EXT record.[.br]

M UNCONNECTED_SP_PAD -e5623
> padname s
> padtype s
: Special pad `[padname]' (type=[padtype]) is not connected to a signal.[.br]

M UNSUPPORTED_PART -e5624
> parttype s
: The `[parttype]' device is not supported by this product.[.br]

M INPUT_NOT_FOUND -e5625
> name s
> ext s
: The input file `[name].[ext]' could not be opened for input.[.br]

M XG_FILE -e5626
> name s
: The input file `[name]' has extension `xg', which is not allowed.[.br]
: XG files are not allowed as input to PPR; PPR accepts XTF or MAP files as
: input.  Each XG file must be processed by XNFPREP to produce an XTF file.  In
: addition, 3KA/L designs must also be processed by XNFMAP to produce a
: MAP file.[.br]

M XNFMAP_NOT_RUN -e5627
> name s
: The design '[name]' has not been processed by XNFMAP.
: For XC3000A, XC3000L and XC3100A designs, mapping into CLBs
: is peformed by the XNFMAP program.
: Run XNFMAP on '[name]' to map the design and use the .map file as
: the input to PPR.[.br]

M XNFPREP_NOT_RUN -e5629
: The input design file has not been processed by the XNFPREP program.
: Before PPR is run on the design, it must be run through XNFPREP, which
: performs design rule checks, checks XACT-Performance specifications and
: trims unnecessary and redundant logic. Run XNFPREP and check the XNFPREP
: report file before continuing. (Note that XBLOX designs are run through
: XNFPREP twice, once before XBLOX and once after.)[.br]


# Informational and Other Messages
M SYMBOL_ELEMENT
> name s
> type s
: Symbol Type = [type] [.br]
: Symbol Name = [name] [.br]
 
E XNFMXN2
#
# ------------------ picprep.m ------------------ 
#
#@(#)picprep.m	6.8  2/2/94
 
 
B PICPREP -start5701 -end5800 -current5711
: Prepare pic file for processing
 
# Tool description (for program help)
M DESCRIPTION
: Picprep prepares a pic file for further processing by algorithmic tools.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Input pic cell

M ESTIMATE
: Tells if program should be run in estimate mode.
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: Input pic cell that is to be prepared for processing
 
M HESTIMATE
: This parameter is TRUE if the program is in estimate mode and FALSE if
: the program is not in estimate mode.  If the program is in estimate mode,
: any loadless or sourceless signals will have hooks attached to the nets so
: that no signals will be sourceless or loadless when this tool has completed.
: The default for this parameter is FALSE.

# Error and Warning Messages
M MISSING_PAD -e5701
> archname s
> instname s
> netname s
: The [archname] symbol [instname]'s external net, '[netname]', must be 
: connected to a EXT symbol.


M ATTRIBUTE_COLLISION -e5702
> attribute s
> pad s
: The parameter [attribute] was specified multiple times on the symbols 
: associated with pad [pad].

M SRCLESS_OR_LDLESS_NET -e5703
> netname s
> type s
: The net '[netname]' is [type].  A net can only be [type] if it has a
: savesig parameter, 's', or if PPR is running in estimate mode.

M NO_ASSIGN_ATTRIB -e5704
> instname s
> value s
: The symbol [instname] has an ASSIGN parameter with the value [value], but
: there is no symbol [value] to which this symbol [instname] can be assigned.

M NO_ASSIGN_SYMBOL -e5705
> instname s
> type s
: The symbol [instname] is a [type] symbol and must have an ASSIGN parameter
: assigning it to a function generator.

M ILLEGAL_TS_ATTRIB -e5706
> instname s
> value s
: The TIMESPEC TS parameter [value] appears on the source pin of symbol 
: [instname].  A TIMESPEC TS parameter can only appear on symbol load pins.

M ADD_FG4_PIN_ERROR -e5709
> pinname s
> eqnname s
> fgname s
: Error in copying pin "[pinname]" of EQN instance '[eqnname]' to FG4 
: instance '[fgname]' pin.

M MEMSYM_4000D_ERROR -e5710
: Memory symbols were found in the design. The XC4000D family does not
: support the use of RAM or ROM elements. If your design requires these
: features, use a device from one of the other XC4000 families.

# Informational and Other Messages
 
E PICPREP
#
# ------------------ pic2xnf.m ------------------ 
#
#@(#)pic2xnf.m	6.10  7/23/93
 
 
B PIC2XNF -start12501 -end12600 -current12523
: PIC to XNF file translator
 
# Tool description (for program help)
M DESCRIPTION
: The PIC2XNF tool translates a PIC file to a flattened XNF file.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M INFILE
: Input PIC file name

M OUTFILE
: Output XNF file name

M MXNTRANS
: Activates translation of MXN file instead of PIC file.

M PICTYPE
: Type of the input PIC cell. 

M XNFTYPE
: Type of the output XNF cell. 

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HINFILE
: The name of the PIC file to be translated.  This name must either exist in
: the current working directory or at the location specified in the file's
: pathname.

M HOUTFILE
: The name of the output flattened XNF file. If no output file name is specified,
: the translated file will be written to a file with the same name as the
: input file with extension "xnf".

M HMXNTRANS
: This boolean parameter causes the input file translated by this program
: to be in the MXN format instead of the PIC format.

M HPICTYPE
: Type of the input PIC cell. If nothing is specified, PIC type is used. 
:[.br]When PIC2XNF is called from PIC2MAP tool, the input PIC cell type
:[.br]will be set to PIC_FGS.

M HXNFTYPE
: Type of the output XNF cell. If nothing is specified, XNF type is used.
:[.br]When PIC2XNF is called from PIC2MAP tool, the output XNF cell type
:[.br]will be set to XNF_MAP.

# Error and Warning Messages

M BADTYPE -e12501
: Type of cell is illegal type.

M XNF_CELL_ERROR -e12502
> name s
: Unable to create  XNF cell "[name]".

M NO_PARTTYPE_ERROR -e12503
> xnfcell s
: Unable to set part type for XNF cell "[xnfcell]".

M PARTTYPE_ERROR -e12504
> parttype s
> xnfcell s
: Unable to set part type to "[parttype]" for XNF cell "[xnfcell]".

M CELLLIB_ERROR -e12505
: Error in initializing the cell library.

M CELLLIB_FIND_ERROR -e12506
> name s
> type s
: Unable to find symbol "[name]" of type "[type]" in cell library.

M UPARAM_ERROR -e12507
: Error in loading user parameter exception table.

M NOT_TRIMMED_ERROR -e12508
> symbol s
: The input file is not trimmed - see symbol [symbol].

M DM_HIST_ERROR -e12509
> modifier s
> date s
> comment s
: Unable to translate the following MXN DM history data to XNF PROG record:
:[.br]"[modifier] [date] [comment]".

M INVALID_SIG_USER_ATTR -e12510
> uattr s
> name s
: Invalid user attribute "[uattr]" for signal "[name]".        

M INVALID_SYM_USER_ATTR -e12511
> uattr s
> name s
: Invalid user attribute "[uattr]" for symbol "[name]".        

M INVALID_PIN_USER_ATTR -e12512
> uattr s
> name s
: Invalid user attribute "[uattr]" for pin which belong to symbol "[name]".        

M INVALID_EXT_USER_ATTR -e12513
> uattr s
> name s
: Invalid user attribute "[uattr]" for ext associated with pad "[name]".

M TRANS_USER_ERROR -e12514
> record s
> data s
: Error translating the following MXN "U" record to XNF USER record:
:[.br]"[record]" "[data]".

M NAME_NOT_FOUND -e12515
> net s
: Name is not found for MXN net "[net]".

M XNF_ADD_SIG_ERROR -e12516
> netname s
: Unable to create XNF signal record for MXN net "[netname]".

M XNF_ADD_EXT_ERROR -e12517
> instname s
: Unable to create XNF EXT record for MXN PAD instance "[instname]". 

M XNF_ADD_SYM_ERROR -e12518
> instname s
: Unable to create XNF symbol record for MXN instance "[instname]". 

M PIN_NOT_USED -e12519
> pinname s
> instname s
: MXN pin name "[pinname]" is not valid for instance "[instname]".

M XNF_ADD_PIN_ERROR -e12520
> symname s
: Unable to add pins to XNF symbol "[symname]". 

M TRANSLATION_ERROR -e12521
: An error occurred in the translation from PIC or MXN to XNF format.

M CONSTRUCT_SYMBOLS_ERROR -e12522
: An error occurred in constructing an XNF symbol from multiple symbols.

# Informational and Other Messages
 
E PIC2XNF
#
# ------------------ celllib.m ------------------ 
#
#@(#)celllib.m	6.2  10/1/93

 
B CELLLIB -start5676 -end5700 -current5679
: Cell Library                      
 
# Tool description (for program help)
M DESCRIPTION
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

# Help Messages
 
# Messages for substitution

M READING
: reading

M BAD_CELLLIB_FORMAT
: Format error in cell library file

M BAD_UPARAM_FORMAT
: Format error in user parameter section of cell library file

# Error and Warning Messages

M BAD_FILE_OPEN -e5676
> file s
> action m
: Unable to open file [file] for [action]

M BAD_VALUE -e5677
> errormessage z
> filename s
> linenum d
> value s
: [errormessage][.br]
: In file '[filename]' on line [linenum] at or near word '[value]'

M BAD_NULL_VALUE -e5678
> errormessage z
> filename s
> linenum d
: The file, '[filename]', has an error on line [linenum]: [errormessage]

# Informational and Other Messages
 
E CELLIB
#
# ------------------ pic2lca.m ------------------ 
#
#@(#)pic2lca.m	6.8  5/2/94
 
 
B PIC2LCA -start10601 -end10900 -current10611
: PIC to LCA translator
 
# Tool description (for program help)
M DESCRIPTION
: Translates a pic cell to an lca file.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Name of input pic cell

M LCAFILE
: Name of output lca file
 
M JUSTFLATTEN
: Routes all the nets to clb pins.
 
M TIMEGROUPS
: Should timegroups and timespecs be written to lca file?

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: The name of the pic cell that is to be translated into a lca file.  This 
: name must either exist in the current working directory or at the location 
: specified in the file's pathname.

M HLCAFILE
: The name of the lca file to which the pic information is written.  If no file 
: name is specified the name of the file will be the name of the input pic
: cell with a .lca extension.

M HJUSTFLATTEN
: Routes all the nets to clb pins.
: Used to generate an unrouted LCA file for unit-delay simulation.  Pic2lca 
: generates an lca file with all the instances placed in clbs and the nets
: routed to CLB pins.

M HTIMEGROUPS
: If timegroups is TRUE, pic2lca will call the path analyzer to get
: information on the user's timing constraints, and write timegroup and
: timespec records for these into the lca file.

M UNROUTED_CONNECTIONS -w10610
> value s
: [.br]Number of unrouted connections: [value] [.br]

# Error and Warning Messages
M BLKNM_EXISTS -w10601
> instname s
> blkname s
> newblkname s
: The block name '[blkname]' associated with the instance '[instname]'
: has already been used to name another block.  The new block name 
: '[newblkname]' is created for this block.'
 
M ILLEGAL_BLKNM -w10602
> instname s
: The names associated with the following blocks are not legal in XACT.  Block
: names can contain only the characters:[.br]
: A-Z a-z 0-9 $ _ - < > /[.br]
: and must contain at least one non-digit character.
: New block names will be created for these blocks.
: [.br]                     block name                     instance name 
: [.br]                     ----------                     ------------- 
: [.br][instname]

M PKG_PIN_NAME -w10603
> instname s
> blkname s
> newblkname s
: The block name '[blkname]' associated with the instance '[instname]' could
: not be used because it is a reserved name for the package pins in XACT.  
: The new block name '[newblkname]' is created for this block.

M EXISTING_LCA_FILE -w10604
> fname s 
: A .LCA file already exists.  The old .LCA file will be saved as '[fname]'.

M BAD_OPEN_FILE -e10605
> fname s
: The file [fname] could not be opened.

M BAD_INIT_FILE -e10606
> fname s
: The LCA2HM initialization file, [fname], is in the wrong format.

M NO_LCA_FILE -e10607
> fname s
: Unable to open the file '[fname]' for writing. 
 
# Informational and Other Messages
M READING_PIC
: Loading the PIC netlist

M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ILLEGAL_PAD_ATTR -w10608
> attr s
> partname s
: The pad attr '[attr]' is not defined for the '[partname]' part.

M NEW_BLKNM -w10609
> instname s
> blkname s
: The new block name '[blkname]' is assigned to the instance '[instname]'.

E PIC2LCA
#
# ------------------ pprsum.m ------------------ 
#
#@(#)pprsum.m	6.21  4/29/94
 
 
B PPRSUM
: PPR Summary Report Generator
 
# Tool description (for program help)
M DESCRIPTION
: This tool creates a summary report file of the partition, place and
: route of a Xilinx XC4000/XC3000A type of design.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
M CELL
: Input Cell Name
M GUIDE_CELL
: Input Cell Name containing a design to be used as guide
M REPORT_FILE
: Output Report File Name
M UNROUTED
: Create Unrouted Net Chapter
M PINOUT
: Create Pinout Chapter
M CRITNET
: Create Critical Net Chapter	
M SPLITNET
: Create Split Net Chapter	
M DELTRACE
: Create Deletion Traceback Chapter
M HMOUTPUT
: Create Unused HM Outputs Chapter
M LOCNET
: Create Net Location Chapter
M LOCGATE
: Create Symbol Location Chapter
M DELNET
: Create Deleted Nets Chapter
M DELGATE
: Create Deleted Symbols Chapter
M CONCLB
: Create Clb Contents Chapter
M ALL
: Create All Chapters
M ESTIMATE
: Create Only Summary Chapter

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: Controls the cell from which information for the summary report is
: taken.
M HGUIDE_CELL
: Expected is a cellname to be a PIC MAP file with BELs that have positions.
: It can also have routing. When this cell is missing no guide is used during
: routing.
M HREPORT_FILE
: Controls the name of the report file which is generated.  If no value
: is given to the parameter, it defaults to cellname.rep, where cellname
: is the value of the cell parameter
M HUNROUTED
: Create the "Unrouted Net" chapter.
M HPINOUT
: Create the "Pinout" chapter.
M HCRITNET
: Create the "Critical Net" chapter.
M HSPLITNET
: Create the "Split Net" chapter.
M HDELTRACE
: Create the "Deletion Traceback" chapter.
M HHMOUTPUT
: Create the "Unused HM Outputs" chapter.
M HLOCNET
: Create the "Net Locations" chapter.
M HLOCGATE
: Create the "Symbol Locations" chapter.
M HDELNET
: Create the "Deleted Nets" chapter.
M HDELGATE
: Create the "Deleted Symbols" chapter.
M HCONCLB
: Create the "Clb Contents" chapter.  This chapter can be quite long.
M HALL
: Create all chapters, regardless of the settings of the other "creation" 
: flags, excluding the estimate flag.
M HESTIMATE
: Create only the summary chapter.  If this flag is set, all other "creation"
: flags will be forced to false.

# Error and Warning Messages
M REPORT_OPENFAILED
> filename s
: Report File Open Failed[.br]
: The report file "[filename]" could not be opened for some reason.

M W_INST_NOT_FOUND
> net  s
> pic s
> inst s
: For net "[net]" in "[pic]" instance "[inst]" not placed.[.br]
: This net will be ignored from the comparison.

M W_LOADLESS_NET
> net s
> pic s
: Net "[net]" in "[pic]" has no load.[.br]
: This net will be ignored from the comparison.

M W_SOURCELESS_NET
> net s
> pic s
: Net "[net]" in "[pic]" has no source.[.br]
: This net will be ignored from the comparison.

M W_MULTISOURCE_NET
> net s
> pic s
: Net "[net]" in "[pic]" has more than 1 source.[.br]
: For a multi-source net every source should be tristatable.[.br]
: This net will be ignored from the comparison.
 


 
# Informational and Other Messages
M READING_DATA
: Cell Data Acquisition
M WRITING_REPORT
: Summary Report Generation
M WRITING_SUMMARY
: Summary Chapter...
M WRITING_PA_SUMMARY
: Xact Performance Summary Chapter...
M WRITING_CLBCONT
: Clb Contents Chapter...
M WRITING_UNROUTE
: Unrouted Net Chapter...
M WRITING_PINOUT
: Pinout Chapter...
M WRITING_CRITNETS
: Critical Nets Chapter...
M WRITING_SPLITNETS
: Split Nets Chapter...
M WRITING_DELTRACE
: Deletion Traceback Chapter...
M WRITING_HMOUTPUT
: Unused HM Outputs Chapter...
M WRITING_DELNETS
: Deleted Nets Chapter...
M WRITING_DELGATES
: Deleted Symbols Chapter...
M WRITING_NETLOC
: Net Location Chapter...
M WRITING_GATELOC
: Symbol Location Chapter...
M WRITING_GUIDE_SUMMARY
: Guide Summary Chapter...
M WRITING_UNGUIDED_BLOCKS
: Unguided Blocks Chapter...
M WRITING_UNGUIDED_SIGNALS
: Unguided Signals Chapter...
M WRITING_OTHER_REPORTS
: Other Reports Chapter...

# Report Entities
M BLANK
:
M RESULTS
: RESULTS
M ESTIMATES
: ESTIMATES
M TITLE
> designname z
> version s
> mode m  # RESULTS or ESTIMATES
: PPR [mode] FOR DESIGN [designname][.br]
: From PPR Version [version]

# -----------------------------------------------------------------------
# These messages are used to write the summary chapter of the report
#
M SUMMARY_CHAPTER
: Design Statistics and Device Utilization[.br]
: ----------------------------------------[.br]
M PA_SUMMARY_CHAPTER
: Xact Performance Summary[.br]
: ----------------------------------------[.br]
M SUMMARY_USERDESIGN
: Design Summary from XNF File
M SUMMARY_BOOLCOUNT
> count d
: Number of Logic Symbols:        [count]
M SUMMARY_FFCOUNT
> count d
: Number of Flip Flops:           [count]
M SUMMARY_TBUFCOUNT
> count d
: Number of 3-State Buffers:      [count]
M SUMMARY_PADCOUNT
> count d
: Number of IO Pads:              [count]
M SUMMARY_HMCOUNT
> count d
: Number of Hard Macros:          [count]
M SUMMARY_EQUIVGATE_COUNT
> count d-4
: [.br]Equivalent "Gate Array" Gates:  [count]  
M SUMMARY_LOGICGATE_COUNT
> count d-4
: - From Logic:                   [count]
M SUMMARY_RAMGATE_COUNT
> count d-4
: - From Random Access Memories:  [count]
M SUMMARY_ROMGATE_COUNT
> count d-4
: - From Read Only Memories:      [count]


M SUMMARY_TOTALNET_COUNT
> count d-4
: Number of Signals:              [count]
M SUMMARY_TOTALPIN_COUNT
> count d-4
: Number of Pins:                 [count]
M SUMMARY_UTIL
> partname s
: Partitioned Design Utilization Using Part [partname] [.br]
: [.br]
: [.br]                                 No. Used   Max Available   % Used
M SUMMARY_PCLB_UTIL
> count d-4
> max   d-4
> util  d
: Packed CLBs                         [count]        [max]         [util]% [.br]
: ----------------------------    -------   -------------   ------ 
M SUMMARY_ULINE
: ----------------------------    -------   -------------   ------ 
M SUMMARY_OCLB_UTIL
> count d-4
> max   d-4
> util  d
: ----------------------------    -------   -------------   ------  [.br]
: Occupied CLBs                       [count]        [max]         [util]%
M SUMMARY_FG_UTIL
> count d-4
> max   d-4
> util  d
: F and G Function Generators:        [count]        [max]         [util]%
M SUMMARY_HFG_UTIL 
> count d-4
> max   d-4
> util  d
: H  Function Generators:             [count]        [max]         [util]%
M SUMMARY_FG_UTIL_3K
> count d-4
> max   d-4
> util  d
: CLB Function Generators: (*)        [count]        [max]         [util]%
M SUMMARY_F5_UTIL_3K
> count d-4
> max   d-4
> util  d
: CLB Base F Function:                [count]        [max]         [util]%
M SUMMARY_FF_UTIL
> count d-4
> max   d-4
> util  d
: CLB Flip Flops:                     [count]        [max]         [util]%
M SUMMARY_IFF_UTIL
> count d-4
> max   d-4
> util  d
: IOB Input Flip Flops:               [count]        [max]         [util]%
M SUMMARY_OFF_UTIL
> count d-4
> max   d-4
> util  d
: IOB Output Flip Flops:              [count]        [max]         [util]%
M SUMMARY_WC_UTIL 
> count d-4
> max   d-4
> util  d
: Memory Write Controls:              [count]        [max]         [util]%
M SUMMARY_TBUF_UTIL
> count d-4
> max   d-4
> util  d
: 3-State Buffers:                    [count]        [max]         [util]%
M SUMMARY_TOR_UTIL_3K
> count d-4
> max   d-4
> util  d
: 3-State Longlines:                  [count]        [max]         [util]%
M SUMMARY_TOR_UTIL
> count d-4
> max   d-4
> util  d
: 3-State Half Longlines:             [count]        [max]         [util]%
M SUMMARY_PKGPINS_UTIL
> count d-4
> max   d-4
> util  d
: Bonded I/O Pins:                    [count]        [max]         [util]%
M SUMMARY_DEC_UTIL
> count d-4
> max   d-4
> util  d
: Edge Decode Inputs:                 [count]        [max]         [util]%
M SUMMARY_DOR_UTIL
> count d-4
> max   d-4
> util  d
: Edge Decode Half Longlines:         [count]        [max]         [util]%
M SUMMARY_FG_UTIL_NOTE_3K
: ----------------------------    -------   -------------   ------  [.br]
: (*) Each base F or FGM function counts as two
M SUMMARY_ROUTE
: Routing Summary[.br]
M SUMMARY_UNROUTED_CONNECTIONS
> value s
: Number of unrouted connections: [value]
M SUMMARY_NPIPS
> value s-6
: Number of pips used:            [value]
M SUMMARY_NFEEDS
> value s-6
: Number of feedthrus used:       [value]
M SUMMARY_NLOCALS
> value s-6
: Number of local lines used:     [value]
M SUMMARY_NDOUBLES
> value s-6
: Number of double lines used:    [value]
M SUMMARY_NLONGS
> value s-6
: Number of long lines used:      [value]
M SUMMARY_NGLOBALS
> value s-6
: Number of global lines used:    [value]
M SUMMARY_NTRIXIES
> value s-6
: Number of decoder lines used:   [value]


M SUMMARY_TIMES
: CPU Times[.br]
M SUMMARY_PREPARATION_TIME
> cputime s
: Reading Input:                  [cputime]
M SUMMARY_PARTITION_TIME
> cputime s
: Partition:                      [cputime]
M SUMMARY_PLACEMENT_TIME
> cputime s
: Placement:                      [cputime]
M SUMMARY_ROUTE_TIME
> cputime s
: Routing:                        [cputime]
M SUMMARY_TOTAL_TIME
> cputime s
: Total:                          [cputime]
M SUMMARY_TIME_UNKNOWN
: Unknown
M SUMMARY_NA
: Not Available
M SUMMARY_PARAMS
: PPR Parameters[.br]
M SUMMARY_PARAM_VALUE
> name s-15
> value s
: [name] = [value]

M SUMMARY_EXPLAIN
: PPR Summary Explanatory Notes[.br]
: ----------------------------
M SUMMARY_EXPLAIN_INTRO
: This section of the report contains the explanatory notes for the entries 
: and values which we presented on the previous page.
: [.br][.br]
M SUMMARY_NOTE_HEADER
> number d
: Note [number][.br]
: ------
M SUMMARY_NOTE1
: The first section gives statistics about your design which served as
: input to PPR.  The data file used to compute these statistics is 
: PPR's internal net list file which is derived from (and closely related to)
: your input XNF file.  There is one case where the internal file may be
: very different from your input XNF file: if your XNF file contains 
: references to other XNF files, PPR will automatically merge the lower
: level net list into the top level net list.  The internal net list file
: therefore represents a FLAT version of your design.
: [.br][.br]
M SUMMARY_NOTE2
: The value listed for the number of "gate array" gates is an estimate
: which we provide for your reference.  It is based on the symbols 
: (AND, OR, FDRD, etc) in the internal net list file.  The value is computed
: by adding the equivalent gate counts of each symbol.  The symbol gate
: counts are derived from gate array data books.
: [.br][.br]
: Since the number of "gate array" gates is based on the internal
: net list file, it includes the contents of any lower level sub-designs 
: which are referenced in your top level XNF file.  It also includes the
: contents of any hard macros which you have used in your design.
: [.br][.br]
: We also show a break down of the total number of gates into three categories:
: those which are due to combinatorial and sequential logic, those which are
: due to random access memories, and those which are due to read only memories.
: If you are using MEMGEN to generate a memory structure, you can also refer
: to its output files to determine how the gate count for the structure was
: computed.
: [.br][.br]
#: If you are using any of the RAM hard macros, the gate count may be somewhat
#: high. The reason for this is that we decompose memory structures
#: into CLBs before we count gates.  Each memory-based CLB has an
#: equivalent gate count based on the number of bits stored and the address
#: decode logic.  Unfortunately, the address decode logic gets counted for
#: every memory-based CLB instead of once for the entire memory structure.
#: This over-counting will be fixed in a future release.
#: [.br][.br]
M SUMMARY_NOTE3
: The second section gives statistics about your design after it has been
: partitioned for the selected part.  Most often, you want to know the
: percent utilization of the LCA by your design.  There are many ways to
: compute the utilization for a design -- it depends on what LCA
: resource you are interested in.  In this section, we present several
: statistics which we have found to be of interest.
: [.br][.br]
M SUMMARY_NOTE4
: The most general utilization statistic is the CLB utilization.  We give
: two values here.  The "Occupied CLB" utilization is computed by counting
: the CLBs that are not empty.  This utilization value includes feedthrus
: which have been inserted into the implementation of your design by the 
: router.  The "Packed CLB" utilization is
: computed by counting the number of function generators and flip flops in
: your design, dividing each by 2, and taking the maximum of the two results.
: The packed CLB value represents the LCA utilization if we were to pack
: your design into as small an area as possible.  In order to improve
: PPR execution time and LCA routability, PPR does not pack CLBs as tightly
: as possible.  Instead, it spreads your design over all available CLBs
: with the result that the elements (function generators, flip flops, 3-state
: buffers) of any one CLB may not fully utilized.  
: [.br][.br]
: The packed CLB utilization is a measure of how much more logic you may
: be able to put in your design and still have it fit on the LCA.
: [.br][.br]
M SUMMARY_NOTE5
: You may sometimes notice differences between the number of package pins
: and flip flops given in this section, and the number of IO pads and
: flip flops given in the previous section.  These differences, if they
: appear, are due to logic trimming which occurs before the partioning
: process.  Pads are removed if they connect to a loadless or sourceless net.
: Flip flops are removed if one of the following conditions is true:
: [.br]  1. The output pin (Q) has no load.
: [.br]  2. The data pin (D) has no source.
: [.br]  3. The data pin is attached to GND and the init attribute value
: [.br]     is "rd" (the output in such a case is always low, so the
: [.br]     symbol is replaced by a GND net).
: [.br]  4. The data pin is attached to VCC and the init attribute value
: [.br]     is "sd" (the output in such a case is always high, so the
: [.br]     symbol is replaced by a VCC net).
: [.br]  5. The clk pin has no source, or is attached to GND or VCC.
: [.br]     (the output in such a case depends on the value of the init
: [.br]     attribute, so the symbol is replaced by a GND or VCC net).
: [.br]  6. The reset pin (RD) is attached to VCC (the output in such 
: [.br]     a case is always low, so the symbol is replaced by a GND net).
: [.br]  7. The set pin (SD) is attached to VCC (the output is this case 
: [.br]     is always high, so the symbol is replaced by a VCC net).
: [.br]
: Flip flops may also be deleted if they are part of a sequential logic
: loop which feeds itself and no other symbols.
: [.br][.br]


# -----------------------------------------------------------------------
# These messages are used to write the clb contents chapter of the report
#
M CLBCONT_CHAPTER
: Clb/Iob Contents[.br]
: ----------------
M CLBCONT_CLBNAME
> blktype s
> blkname s
: [blktype] [blkname]
M CLBCONT_INSTNAME
> belname s-6
> instname s
: [belname]: [instname]
M CLBCONT_CLB_INPUT
: INPUT :
M CLBCONT_CLB_OUTPUT
: OUTPUT:
M CLBCONT_CLB_INTERNAL_NETS
: NETS  :
M CLBCONT_BEL_INPUT
: Input  =
M CLBCONT_BEL_OUTPUT
: Output =
M CLBCONT_BEL_INTERNAL_NETS
: Nets   =
M CLBCONT_BEL_INTERNAL_GATES
: Gates  =
M CLBCONT_BEL_EQUATION
: EQ     =
M CLBCONT_ITEM_VALUE
> value s
: [value]

# -----------------------------------------------------------------------
# These messages are used to write the unrouted nets chapter of the report
#
M UNROUTE_CHAPTER
: Unrouted Net Names[.br]
M UNROUTE_CHAPTER_INTRO
: [.br]
: Your design contains nets which were not completely routed.  This
: chapter contains a listing of the net names which could not be
: completely routed, and the number of unrouted load pins
: [.br]
M UNROUTE_HEADER
: # Pins  Net name[.br]
: ------  ------------------------------
M UNROUTE_ENTRY
> netname s
> npins   s6
: [npins]  [netname]

M UNROUTE_VCC_GND_ENTRY
> unroutes d
: [.br] Note: [unroutes] VCC/GND pins are also unrouted

# -------------------------------------------------------------------------
# These messages are used to write the pinout chapter of the report
#
M PINOUT_CHAPTER
: Chip Pinout Description[.br]
: -----------------------
M PINOUT_CHAPTER_INTRO1
: [.br]
: This chapter describes where your design's pins were placed in terms of
: the package pins.  This first list is sorted by package pin location.  
: The second list presents the same data sorted by your design's pin
: names.
: [.br]
M PINOUT_CHAPTER_INTRO2
: [.br]
: This list describes where your design's pins are in terms of the package
: pins; it is sorted by your design's pin name.  The list presented above
: has the same data sorted by package pin location.
: [.br]
M PINOUT_CHAPTER_INTRO3
: [.br]
: The following pads are the special I/O pads used in your design.
: [.br]
M PINOUT_HEADER
: Package Pin Location   Pin Name[.br]
: --------------------   -----------------
M PINOUT_SPECIAL_HEADER
: Special Pad            Pin Name[.br]
: --------------------   -----------------
M PINOUT_ENTRY
> package_pin_name s-20
> instance_name    s
: [package_pin_name] : [instance_name]

# -------------------------------------------------------------------------
# These messages are used to write the critical nets chapter of the report
#
M CRITNETS_CHAPTER
: Critical Nets[.br]
: -------------
M CRITNETS_CHAPTER_INTRO
: [.br]
: These nets were labeled as critical in your design.  The value of "C"
: is used to indicate nets with the critical net attribute.  The value of
: "Wnn" is used to indicate nets with the net weight attribute.  The value
: of "SC" is used to indicate nets with the skew critical attribute.
: [.br]
M CRITNETS_NONE
: (No nets were marked as critical).
M CRITNETS_HEADER
: Value  Net Name[.br]
: -----  -----------------------------------
M CRITNETS_ENTRY
> crittype  s2
> critvalue s-3
> netname   s
: [crittype][critvalue]  [netname]

# -------------------------------------------------------------------------
# These messages are used to write the split net chapter
#
M SPLITNET_CHAPTER
: Split Nets[.br]
: -------------------
M SPLITNET_NOTES
: The list below identifies those signals which were routed through CLBs 
: or other blocks. In XDE and XDelay reports, these signals will have two
: or more segments. An underscore (_) and a number will be added to the
: end of the original signal name to identify the different segments. To
: analyze all segments of a signal in XDelay or QueryNet reports, append
: the original name with "_*" when prompted for a signal name.
: [.br][.br]
: PPR may route signals through CLBs or other blocks in any of the
: following situations:
: [.br][.br]
: * The delay on a signal might be reduced by routing it through a CLB,
:   given the extra flexibility in routing resources and the reduced
:   capacitive loading on the signal. PPR takes this into consideration.
: [.br][.br]
: * The delay on a signal might be reduced by sourcing it from two block
:   outputs instead of one, which is possible in some block configurations.
:   PPR will do this where possible.
: [.br][.br]
: * A signal on a global buffer may not be able to connect directly to 
:   a load pin, given the placement of that load pin and the other global
:   resources which are used. PPR will pass the signal through another 
:   CLB and route the load pin using general-purpose interconnect.
: [.br][.br]
: * In an XC4000 design, A BUFGP can be sourced only from an IOB. If
:   the design indicates that a BUFGP is driven from an internal source,
:   PPR will route the signal through the output path of the IOB in 
:   order to access the BUFGP input.[.br]
M SPLITNET_HEADER
: Segments   Original Signal Name [.br]
: --------   -------------------------------------------------------
M SPLITNET_NONE
: [.br]
: The implementation of your design did not require any splitnets.  Therefore
: no nets were split into multiple nets.
M SPLITNET_SOME
> nnets d
: [.br]
: The implementation of your design contains [nnets] nets that have been 
: routed using CLB feedthrus.  The original net will not appear in your LCA
: file; it is replaced by two or more new nets that have names based on
: the original name, but with a "_N" suffix, where N is a small, positive
: integer. The original net name, and the names of the new nets which will
: appear in the LCA file are shown below.
M SPLITNET_ENTRY
> nfeeds d
> netname s
: [.br]  [nfeeds]           [netname]

# -------------------------------------------------------------------------
# These messages are used to write the deletion traceback chapter
#
M DELTRACE_CHAPTER
: Deletion Traceback[.br]
: ------------------
M DELTRACE_CHAPTER_INTRO
: [.br]
: This chapter contains an indented list of actions which were taken when
: unused symbols, or sourceless or loadless nets where deleted from your
: design.  You can use this information to find the problem in your design
: if an inordinate amount of logic was removed.
: [.br]
M DELTRACE_NONE
: (No symbols or nets were deleted.)
M DELTRACE_UNUSED
> indent z
> type s-6
> name s
: [indent]Unused [type]: [name]
M DELTRACE_LOADLESS
> indent z
> name s
: [indent]Loadless Net: [name]
M DELTRACE_SOURCELESS
> indent z
> name s
: [indent]Sourceless Net: [name]

# -------------------------------------------------------------------------
# These messages are used to write the deleted nets chapter of the report
#
M HMOUTPUT_CHAPTER
: Hard Macros With Unused Outputs[.br]
: -------------------------------
M HMOUTPUT_CHAPTER_INTRO
: [.br]
: This chapter contains a list of the hard macros which you have used which
: have unconnected output pins.  If the hard macro output pin is not used 
: internally by the hard macro itself, such usage may
: cause one or both of the following warning messages to be issued when you 
: use XDE's drc command:
: [.br]
: [.br]  Warning 604: net (netname): 0 loads
: [.br]  Warning 301: Output (pin) used in CLB '(clbname)', but 
: [.br]               0 output pips are on
: [.br][.br]
: This list desribes the hard macro instance name, the hard macro name and
: the list of hard macro output pins which are not connected externally.
: [.br][.br]
M HMOUTPUT_NOHMS
: (Your design does not contain any hard macros.)
M HMOUTPUT_NOOUTS
: (Your design does not contain any hard macros with unconnected output pins.)
M HMOUTPUT_ENTRY
> name z
> arch z-10
> pins z
: [name] 
: [.br]    Instance of Hard Macro  [arch] 
: [.br]    Unconnected Output Pins [pins]
: [.br]

# -------------------------------------------------------------------------
# These messages are used to write the deleted nets chapter of the report
#
M DELNETS_CHAPTER
: Deleted Nets[.br]
: ------------
M DELNETS_CHAPTER_INTRO
: [.br]
: These nets were deleted from your net list.  Nets are deleted for one
: of the following reasons:
: [.br]No Source: The net did not connect to the output pin of a symbol
: [.br]No Load:   The net did not connect to the input pin of a symbol
: [.br]Trimmed:   The net was part of a path which was removed using logic
: [.br]           trimming techniques.
: [.br]Absorbed:  The net was absorbed into another entity which was
: [.br]           placed on the LCA.  For instance, the output of inverter
: [.br]           symbols which connect only to other boolean symbols can
: [.br]           be absorbed into the function generators which contain
: [.br]           the boolean symbols.
: [.br]
M DELNET_HEADER
: Reason      Net Name[.br]
: ----------  -----------------------------------
M DELNET_NONE
: (No nets were deleted).
M DELNET_NOSOURCE
> netname s
: No Source : [netname]
M DELNET_NOLOAD
> netname s
: No Load   : [netname]
M DELNET_TRIMMED
> netname s
: Trimmed   : [netname]
M DELNET_ABSORBED
> netname s
: Absorbed  : [netname]

# -------------------------------------------------------------------------
# These messages are used to write the deleted symbols chapter of the report
#
M DELGATES_CHAPTER
: Deleted Symbols[.br]
: ---------------
M DELGATES_CHAPTER_INTRO
: [.br]
: These symbols were deleted from your net list.  Symbols are deleted for one
: of the following reasons:
: [.br]Trimmed:   The symbol was part of a path which was removed because
: [.br]           of logic trimming.
: [.br]Absorbed:  The symbol was absorbed into another entity which was
: [.br]           placed on the LCA.  For instance, input buffers are 
: [.br]           an inherent part of the LCA's IOB.  Consequently, IBUF
: [.br]           symbols are always shown as "absorbed".
: [.br]
M DELGATES_HEADER
: Reason     Symbol     Symbol Instance Name[.br]
: ---------  ---------  ---------------------------  
M DELGATES_NONE
: (No symbols were deleted).
M DELGATES_ABSORBED
> archname z-10
> gatename z
: Absorbed : [archname] [gatename]
M DELGATES_TRIMMED
> archname z-10
> gatename z
: Trimmed  : [archname] [gatename]


# -------------------------------------------------------------------------
# These messages are used to write the net location chapter of the report
#
M NETLOC_CHAPTER
: Net Locations[.br]
:--------------
M NETLOC_CHAPTER_INTRO
: [.br]
: The following listing shows the final locations of the source (SRC) of all
: nets in your original net list.  Some nets are completely subsumed 
: within a single block; these nets are shown as internal (INT) to the block
: which contains them.
: [.br]
M NETLOC_HEADER
: Location                Net Name[.br]
: ----------------------  --------------------------------
M NETLOC_INTERNAL
> netname s
> locname s-18
> auxinfo s
: INT [locname]: [netname][auxinfo]
M NETLOC_SOURCE
> netname s
> locname s-18
> auxinfo s
: SRC [locname]: [netname][auxinfo]
M NETLOC_FEEDTHRU
> netname s
> segname z
> locname z-18
: SRC [locname]: [segname] -- Segment of [netname]
M NETLOC_DELETED
> netname s
: Deleted from netlist  : [netname]
M NETLOC_DUPLICATE
: Duplicate
M NETLOC_MULTISOURCE
: Multiple Source

# -------------------------------------------------------------------------
# These messages are used to write the symbol location chapter of the report
#
M GATELOC_CHAPTER
: Symbol Locations[.br]
:-----------------
M GATELOC_CHAPTER_INTRO
: [.br]
: The following listing shows the final locations of all the symbol instances
: in your original netlist.
: [.br]
M GATELOC_HEADER
: Location             Symbol     Symbol Instance Name[.br]
: ------------------   ---------  --------------------------
M GATELOC_ENTRY
> location s-18
> archname z-10
> gatename z
: [location] : [archname] [gatename]
M GATELOC_DUPLICATE
: Duplicate
M GATELOC_HMPART
: Hard Macro Part
M GATELOC_PARTITION
: Partitioned
M DELETED
: DELETED
M INTERNAL
: INTERNAL
# -------------------------------------------------------------------------
# These messages are used to write the guide summary chapter of the report
#
M GUIDE_SUMMARY_CHAPTER
: Guide Summary[.br]
: ------------- [.br] [.br]
M GUIDE_PLACE_SUMMARY
: Summary of Guided Placement[.br]
: ---------------------------[.br]
M GUIDE_PLACE_NOTE1
: The following table summarizes the guided placement process. For each
: type of LCA block, this table shows (1) how many blocks of that type
: exist in the input design file; (2) how many of these blocks were
: matched to blocks in the guide file; and (3) how many of the matched
: blocks were used to guide the placement of the input design.
: [.br]
M GUIDE_PLACE_NOTE2
: A matched block will not be used to guide placement if any one
: of the following is true:[.br]
: * The guide_blks option is set to ROUTED_ONLY and the matched block
: does not have any routing connected to it in the guide LCA file.[.br]
: * The matched block is placed elsewhere by a constraint in the input
: design or the CST file.[.br]
: * A different block is placed in the matched block's guide location
: by a constraint in the input design or the CST file.[.br]
: * The matched block is part of an RLOC set and other blocks in that
: set were not matched. A partially-matched RLOC set will be guided
: only if there is space available for the unmatched blocks AND if 
: the structure of the RLOC set can be respected.[.br]
: * A pin on a matched block does not have any routing connected to it
: in the guide LCA file, so the pin was swapped with another pin on that
: CLB to improve the routing of the associated signal(s). For example, the
: X and Y flip-flops may be swapped if their output pins are not routed.[.br]
: [.br]
M GUIDE_PLACE_NOTE3
: [.br]All blocks in the input design which could not be matched in the 
: guide file are listed in the "Unguided Block" chapter below.
: [.br][.br]
M GUIDE_PLACE_HEADER
:
: Block Type             In Design   Matched in Guide   Placement Guided[.br]
: ----------------       ---------   ----------------   ---------------
M GUIDE_PLACE_FFENTRY
> tot_ff d15
> ff_matched d14
> ff_guided d18
: CLB flip-flop [tot_ff] [ff_matched] [ff_guided]
M GUIDE_PLACE_FGENTRY
> tot_fg d8
> fg_matched d14
> fg_guided d18
: CLB base FG function [tot_fg] [fg_matched] [fg_guided]
M GUIDE_PLACE_F5ENTRY
> tot_f5 d9
> f5_matched d14
> f5_guided d18
: CLB base F function [tot_f5] [f5_matched] [f5_guided]
M GUIDE_PLACE_FUNCENTRY
> tot_fg d7
> fg_matched d14
> fg_guided d18
: CLB function generator[tot_fg] [fg_matched] [fg_guided]
M GUIDE_PLACE_MUXENTRY
> tot_mux d7
> mux_matched d14
> mux_guided d18
: CLB base FGM function [tot_mux] [mux_matched] [mux_guided]
M GUIDE_PLACE_CYENTRY
> tot_cy d13
> cy_matched d14
> cy_guided d18
: CLB carry logic [tot_cy] [cy_matched] [cy_guided]
M GUIDE_PLACE_TBUFENTRY
> tot_tbuf d14
> tbuf_matched d14
> tbuf_guided d18
: 3-state buffer [tot_tbuf] [tbuf_matched] [tbuf_guided]
M GUIDE_PLACE_DECENTRY
> tot_dec d10
> dec_matched d14
> dec_guided d18
: Edge decoder input [tot_dec] [dec_matched] [dec_guided]
M GUIDE_PLACE_PADENTRY
> tot_pad d21
> pad_matched d14
> pad_guided d18 
: I/O pad [tot_pad] [pad_matched] [pad_guided]
M GUIDE_ROUTE_SUMMARY
: Summary of Guided Routing[.br]
: -------------------------[.br]
M GUIDE_ROUTE_HDR
: The following signal counts represent only signals outside of CLBs and IOBs.[.br]
M GUIDE_ROUTE_MATCHED
> tot_matched d
:  [tot_matched] signals in input design file were matched in guide file[.br]
: ----------------------------------------------------------
M GUIDE_ROUTE_ALL_GUIDED
> tot_all_guided d
:  [tot_all_guided] signals routed using all routing information from guide file
M GUIDE_ROUTE_SOME_GUIDED
> tot_some_guided d
: [tot_some_guided] signals routed using some routing information from guide file (*)
M GUIDE_ROUTE_NOT_GUIDED
> tot_not_guided d
:  [tot_not_guided] signals routed using no routing information from guide file (*)
M GUIDE_ROUTE_UNMATCHED
> tot_unmatched d
: [.br][tot_unmatched] signals in input design were not found in guide file
M GUIDE_ROUTE_NOTE1
: [.br](*) These signals are listed in the "Unguided Signals" chapter below
: [.br]

# -------------------------------------------------------------------------
# These messages are used to write the unguided blocks chapter of the report
#
M UNGUIDED_BLOCKS_CHAPTER
: Unguided Blocks from Input Design [.br]
: --------------------------------- [.br] [.br]
M UNGUIDED_BLOCKS_NOTE1
: The following lists show which blocks in the input design were not
: matched to blocks in the guide file and therefore were NOT guided
: during the placement process.
: [.br]
M UNGUIDED_FF_HEADER
: CLB flip flops driving following Q output signals: [.br]
: -----------------------------------------------------------
M UNGUIDED_FF_ENTRY
> net s
: [net]
M UNGUIDED_FG3K_HEADER
: [.br]CLB function generators driving following output signals: [.br]
: ----------------------------------------------------------- [.br]
: Base   Output Signal Name [.br]
: -----  ---------------------------------------------------
M UNGUIDED_FG4K_HEADER
: [.br]CLB function generators driving following output signals: [.br]
: ------------------------------------------------------------
M UNGUIDED_FG3K_ENTRY1
> net s
: F      [net]
M UNGUIDED_FG3K_ENTRY2
> net s
: FG     [net]
M UNGUIDED_FG3K_ENTRY3
> net s
: MUX   [net]
M UNGUIDED_FG4K_ENTRY
> net s
: [net]
M UNGUIDED_CY_HEADER
: [.br]CLB carry logic with COUT0 and COUT connections as follows: [.br]
: ----------------------------------------------------------------
M UNGUIDED_CY_ENTRY1
> net s
: COUT0 signal=[net]
M UNGUIDED_CY_ENTRY2
> net s
: COUT  signal=[net]
M UNGUIDED_TBUF_HEADER
: [.br]3-state buffer with input and output signals as follows: [.br]
: -------------------------------------------------------------
M UNGUIDED_TBUF_ENTRY1
> net s
: I signal=[net] 
M UNGUIDED_TBUF_ENTRY2
> net s
: O signal=[net][.br]
M UNGUIDED_DEC_HEADER
: [.br]Edge decoder with input and output signals as follows: [.br]
: ------------------------------------------------------------
M UNGUIDED_DEC_ENTRY1
> net s
: [.br]I signal=[net]
M UNGUIDED_DEC_ENTRY2
> net s
: O signal=[net]
M UNGUIDED_PAD_HEADER
: [.br]Input/Output pads as follows: [.br]
: ------------------------------------------------------------
M UNGUIDED_PAD_ENTRY
> net s
: [net]
M UNGUIDED_OTHERS_HEADER
: [.br]Other LCA Elements: [.br]
: -----------------------------------------------------------
M UNGUIDED_BUFGP_ENTRY
> net s
: BUFGP driving output signal [net]
M UNGUIDED_BUFGS_ENTRY
> net s
: BUFGS driving output signal [net]
M UNGUIDED_GCLK_ENTRY
> net s
: GCLK driving output signal [net]
M UNGUIDED_ACLK_ENTRY
> net s
: ACLK driving output signal [net]
M UNGUIDED_OTHERS_ENTRY
> net s
: [net]
	
# -------------------------------------------------------------------------
# These messages are used to write the unguided signals chapter of the report
#
M UNGUIDED_SIGNALS_CHAPTER
: Unguided Signals from Input Design [.br]
: ---------------------------------- [.br] [.br]
M UNGUIDED_SIGNALS_NOTE1
: The following list shows which signals in the input design could not 
: use ALL of the routing information specified for them in the guide file.
:[.br][.br]
: Signals in the input design that do not exist in the guide file are not
: included in this list.
M UNGUIDED_SIGNALS_HEADER
: [.br] Signal Name [.br]
: --------------------------------------------------------------
M UNGUIDED_SIGNALS_ENTRY
> net s
: [net]
# -------------------------------------------------------------------------
# These messages are used to write the contents of other report files
#
M OTHER_REPORTS_CHAPTER
: Information in Other Reports[.br]
: ---------------------------- [.br] [.br]
M OTHER_REPORTS_NOTE1
: Since not all pertinent design information is listed in this PPR report
: file, this section describes where additional information can be found. [.br][.br]
M OTHER_REPORTS_HEADER
: Information                                  Report File  Created By[.br]
: -----------------------------------------    -----------  ----------[.br][.br]
M XNFMERGE_REPORT_1
: Connection of signals between levels of      design.mrg   XNFMERGE[.br]
:   design hierarchy[.br]
M XNFMERGE_REPORT_2
: Resolution of relative location (RLOC)       design.mrg   XNFMERGE[.br]
:   constraints through design hierarchy[.br]
M XNFPREP_REPORT_1
: X-BLOX designs: design rule check for        design.prx   XNFPREP[.br]
:   pre-expanded design[.br]
M XBLOX_REPORT
: X-BLOX designs: results of optimization      design.blx   XBLOX[.br]
:   and module expansion in X-BLOX[.br]
M XNFPREP_REPORT_2
: Design rule check for invalid and/or         design.prp   XNFPREP[.br]
:   inefficient use of LCA architecture[.br]
M XNFPREP_REPORT_3
: Unused or disabled logic removed from        design.prp   XNFPREP[.br]
:   design, due to sourceless or loadless[.br]
:   signals and VCC or ground connections[.br]
M XNFMAP_REPORT_1
: XC3000A/L designs: Mapping of design         design.crf   XNFMAP[.br]
:   logic into each CLB or IOB[.br]
M XNFMAP_REPORT_2
: XC3000A/L designs: Summary of guided         design.crf   XNFMAP[.br]
:   partitioning results[.br]

M PA_SUMMARY
> summary z
: [summary]

E PPRSUM

#
# ------------------ plc_4k.m ------------------ 
#
#@(#)plc_4k.m	6.7  3/16/94
 
 
B PLC_4K -start9401 -end9500 -current9403
: Simulated Annealing Placement Tool for 4K
 
# Tool description (for program help)
M DESCRIPTION
: <<put a detailed description of your tool here>>
M MCELL
: Input PIC Cell name

M MGUIDE_CELL
: Input guide PIC Cell name

M MPLACER_EFFORT
: Placement effort

M MSCHEDULE
: The annealing schedule being used: 0 - Extended or 1 - Deterministic

M MSEED
: Seed for random number generator

M Minfo
: Flag for just evaluating the cost function of the design

M Hinfo
: Flag for just evaluating the cost function of the design

M MPARTIAL
: Partial design flag

M MDEBUG
: Debug flag

M MUNMATCH
: Flag for print out the unmatch with guide

M MIGNORE_RLOCS
: Ignore the RLOC parameters from the design file.

M MTIMING
: Path timing flag
 
M MSTAND_ALONE
: Set to TRUE when run a stand alone tool, FAlSE otherwise.

# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M HCELL
: Input PIC Cell name

M HGUIDE_CELL
: Input guide PIC Cell name

M HPLACER_EFFORT
: Placement effort 

M HSCHEDULE
: The default schedule for the annealer is the non-deterministic
: schedule.

M HEXTENDED
: Extended or Huang/Romeo/Vincentelli annealing schedule.

M HDETERMINISTIC
: Deterministic or Sechen/Lam/Schwartz annealing schedule.

M HSEED
: Seed for random number generator

M HPARTIAL
: Partial design flag

M HDEBUG
: Debug flag

M HUNMATCH
: Flag for print out the unmatch with guide

M HIGNORE_RLOCS
: All the design file RLOC parameters will be ignored
: by the placer. This includes RLOC and RLOC_RANGE.

M HTIMING
: Using path timing during placer.

M HSTAND_ALONE
 
# Error and Warning Messages
M HYDRA_UNSUPPORT_M
: Sorry, this tool does not support Hydra parts at the moment.
 
# Informational and Other Messages
M SIMULATED_ANNEALING_M
: Do simulated annealing placement...

M DISPLAY_COSTS_PREAMBLE
: Name    Weight Value      Weighted_value

M DISPLAY_COST_TERM
> name s-7
> weight f-6.3
> value d-10
> weighted_value d-12
: [name] [weight] [value] [weighted_value]

M DISPLAY_TOTAL_COST
> value d
: The total cost function is [value].

M GENERAL_MSG
> message s
: [message]

M TOO_LARGE_COEF_MSG -w9401
> coefName s
> currValue f
> newValue  f
: Current setting of coeficience [coefName] is too large
: for this design--ie [coefName] = [currValue].  The
: coeficient will be reset automatically largest value = 
: [newValue]

M TOO_SMALL_COEF_MSG -w9402
> coefName s
> currValue f
> newValue  f
: Current setting of coeficience [coefName] is too small
: for this design--ie [coefName] = [currValue].  The
: coeficient will be reset automatically smallest value = 
: [newValue]

M INFO_MSG
> message s
: [message]

E PLC_4K
#
# ------------------ plc_3k.m ------------------ 
#
#@(#)plc_3k.m	6.10  3/15/94
 
 
B PLC_3K -start9301 -end9400 -current9304
: Simulated Annealing Placer for 3000A
 
# Tool description (for program help)
M DESCRIPTION
: <<put a detailed description of your tool here>>
 
M MCELL
: Input PIC Cell name

M MGUIDE_CELL
: Input guide PIC Cell name

M MPLACER_EFFORT
: Placement effort

M MPARTIAL
: Partial design flag

M MDEBUG
: Debug flag

M MUNMATCH
: Flag for print out the unmatch with guide

M Mschedule
: The annealing schedule being used: 0 - Extended or 1 - Deterministic

M Mseed
: The seed for random number generation.

M Minfo
: Flag for just evaluating the cost function of the design

M Mtiming
: Flag to control whether path timing is used.

# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M Hschedule
: The default schedule for the annealer is the non-deterministic
: schedule.

M HCELL
: There is no default PIC cell name 
# Error and Warning Messages

M HGUIDE_CELL
: Input guide PIC Cell name

M HPLACER_EFFORT
: Placement effort

M HPARTIAL
: Partial design flag

M HDEBUG
: Debug flag

M HUNMATCH
: Flag for print out the unmatch with guide

M Hseed
: The default seed for the annealer is 660511

M Hinfo
: Flag for just evaluating the cost function of the design

M Htiming
: Use path timing iff timing is set to TRUE.

M Hextended
: Extended or Huang/Romeo/Vincentelli annealing schedule.

M Hdeterministic
: Deterministic or Sechen/Lam/Schwartz annealing schedule.

M BAD_FILE_OPEN
> fname s
> type s
: Could not open file '[fname]' for [type]


# Informational and Other Messages

M DISPLAY_COSTS_PREAMBLE
: Name    Weight Value      Weighted_value

M DISPLAY_COST_TERM
> name s-7
> weight f-6.3
> value d-10
> weighted_value d-12
: [name] [weight] [value] [weighted_value]

M DISPLAY_TOTAL_COST
> value d
: The total cost function is [value].

M PAD_PACKING_PROBLEM -e9301
: Given the current placement constraints, PPR is unable to place all the
: PADs. The XC3000 architecture includes two clock  lines on each edge of
: the device. Therefore, the IOBs  on a given device  edge can be clocked
: by two different signals at most. For clock  signals which control both
: rising-edge and  falling-edge I/O flip-flops  (or both transparent High
: and transparent Low input latches) on the same edge of the device, both
: clock lines on that edge are needed; only the ACLK  buffer can route to
: both clock lines in this manner. 
: [.br][.br]
: If dual-phase  IOB clocks are being  used, ensure that they  are either
: (1) sourced by the  ACLK buffer, or  (2) constrained to different edges
: of the  device.  If the design  contains  more than  two different  IOB
: clocks  (with dual-phase clocks   counting as two),  constrain the I/Os
: such that there are no more than two per edge.[.br] 

M GCLK_IOB_DUAL_PHASE_CLK_PROBLEM -e9302
> netname s
: Both phases of the GCLK output signal [netname] are used to control I/O
: flip-flops and/or latches, but these IOBs have  been  constrained  such
: that both phases are required on the same device edge.
: [.br][.br]
: Since the GCLK output cannot connect to  both  I/O  clock  lines  on  a
: single  edge,  this  signal  can  be  routed only if the IOBs requiring
: different phases of the clock lie on different edges.  Correct  the I/O 
: location constraints so that each device edge contains  IOBs  from only 
: one of the following two groups:  (1) rising-edge  triggered flip-flops 
: and/or transparent-Low input  latches; or  (2)  falling-edge  triggered
: flip-flops and/or transparent-High input latches.
: [.br][.br]
: Alternatively, consider sourcing this clock signal from the ACLK buffer,
: which can drive both I/O clock lines on the same edge.[.br]

M INFEASIBLE_IOB_CLOCK -e9303
> netnames z
: Given the current placement constraints the IOB clock signals
: [netnames] are constrained to be routed along the same edge.
: [.br][.br]
: The XC3000 architecture includes two clock lines on each edge of the
: device. Therefore, the IOBs  on a given device  edge can be clocked
: by two different signals at most. Correct the I/O location constraints
: so that each device edge requires at most two IOB clock signals.[.br]


M INFO_MSG
> message s
: [message]

:
E PLC_3K
#
# ------------------ anneal.m ------------------ 
#
#@(#)anneal.m	6.7  5/2/94
 
 
B ANNEAL
: Annealer 
 
# Tool description (for program help)
M DESCRIPTION
: <<put a detailed description of your tool here>>
 
M Mschedule
: The annealing schedule being used: 0 - Extended or 1 - Deterministic

M Mseed
: The seed for random number generation.

M Mcell
: Input PIC Cell name

# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
M Hschedule
: The default schedule for the annealer is the non-deterministic
: schedule.

M Hseed
: The default seed for the annealer is 660511

M Hcell
: There is no default PIC cell name 
# Error and Warning Messages

M Hextended
: Extended or Huang/Romeo/Vincentelli annealing schedule.

M Hdeterministic
: Deterministic or Sechen/Lam/Schwartz annealing schedule.

# Informational and Other Messages

M PLACER_SUSP_ENABLE
: + Suspension enabled: cntl-C/cntl-Break to save current placement.

M PLACER_SUSP_DISABLE
: + Suspension disabled: cntl-C/cntl-Break will stop program.

M DISPLAY_INITIAL_TEMP
> temp f8.2
: [.br]Initial temp is [temp]

M DISPLAY_COSTS
> temp f8.2
> best d8
> avg f8.2
> stdev f8.2
> attempts d8
> accepts d8
> cputime f8.2
: [temp] [best] [avg] [stdev] [attempts] [accepts] [cputime]

M DISPLAY_HEADING
: [.br]    Temp     Best  Average Std_devn Attempts  Accepts CPU Time[.br]

M DISPLAY_TOP
: [.br]   Score   @   Time [.br]

M DISPLAY_SCORE
> score   d8
> cputime s8
: [score]  ...  [cputime]
E ANNEAL

#
# ------------------ realcut.m ------------------ 
#
#@(#)realcut.m	6.24  4/15/94
 
 
B REALCUT -start9601 -end9700 -current9613
: Resource-minded mincut
 
# Tool description (for program help)
M DESCRIPTION
: Legal placement by successive bipartitioning with resource accounting.
 
# External Parameter Names and Help Messages
# What is this parameter?  This is the...(a short & pithy 1-liner)
# and
# What does this parameter do?  This parameter...(verbose multi-liner)

M MCELL
: Input PIC Cell name

M HCELL
: Input PIC Cell name

M MMAX_STAGES
: Max number of cutting levels 

M HMAX_STAGES
: In each stage, all active clusters are partitioned into sub-clusters.
: Max_stages controls the number of stages.

M MMAX_VISITS
: Max times each cluster is visited, per stage

M HMAX_VISITS
: In each stage, the active clusters are partitioned.  Then the clusters can
: be re-visited, in the same order, to be partitioned again, using information
: developed by decisions in the previous round.  Max_visits controls the number
: of these rounds.

M MMAX_TRIES
: Max initial configurations to try for each cut

M HMAX_TRIES
: Realcut does recursive bipartitioning, i.e., successively partitions
: the elements in each region into two sub-regions.  Several attempts
: are made, constructing a good initial partition and improving it;
: the best result from these attempts is used.
: This parameter sets the maximum number of initial
: partitions constructed for each region.  (A value of zero means
: to use arbitrary balanced initial partitions.)

M MMAX_PASSES
: Max improvement passes

M HMAX_PASSES
: Improvement passes are performed, following the method of Kernighan
: and Lin.  In each pass all components change sides, and the best
: configuration is remembered.  Work stops after any pass during which
: no configuration better than the one at the start of the pass is reached,
: or when the number of passes done equals this parameter.

M MXMIN
: left coordinate

M HXMIN
: x coordinate of left of placement box

M MXMAX
: right coordinate

M HXMAX
: x coordinate of right of placement box

M MYMIN
: bottom coordinate

M HYMIN
: y coordinate of bottom of placement box

M MYMAX
: top coordinate

M HYMAX
: y coordinate of top of placement box

M MTIMING
: Use path analysis?

M HTIMING
: If True, mincut optimizes path delays as well as total net length.

M MDEBUG
: Debug flag

M HDEBUG
: Debug flag

# Error and Warning Messages
 
M UNPLACED_INST -e9601
> name s
: Instance [name] was not placed.

M INCORRECT_GROUPING -w9602
> arch1 s
> inst1 s
> arch2 s
> inst2 s
: [arch1] [inst1] and [arch2] [inst2] should not be grouped.

M FORCED_CHOICE_TROUBLE
> cti d
> where s
: Cell type [cti] had forced-choice trouble during [where].

M CONSTRUCTION_OVER_LIMIT
> class d
> side d
> actual d
> limit d
: On side [side], class [class] got [actual] commitments, but limit is [limit].

# Informational and Other Messages
 
M CELLS_MADE
> count d
: Made [count] cells.

M MULTI_TRIES
> max_tries d
> partitions s
: Will try at most [max_tries] [partitions] of each cluster.

M PARTITION
: partition
M PARTITIONS
: partitions

M CLUSTER_STATS
> xmin d
> ymin d
> xmax d
> ymax d
> total_insts d
> cells d
: Cluster: x [xmin]-[xmax], y [ymin]-[ymax]; [total_insts] instances
: ([cells] cells).

M CELL_INFO
> number d
> celltype d
> num_insts d
> status s
> side d
> gain d
: Cell [number], celltype [celltype]; [num_insts] insts; [status]
: (side [side], gain [gain])

M INST_NAME
> indent s
> arch s-10
> inst s
: [indent][arch] [inst]

M A_CELLTYPE
> number d4
> insts d3
> classes d3
: Type [number] .. instances: [insts],   classes: [classes].

M A_CLASS
> class d
> count d5
> classname s
> elements s
: [count] [elements] of class [class] ([classname]).

M PACK_PLACE
> name s
> arch s-9
> x d3
> y d3
: [x][y]  [arch] [name]

M PLACE_PROBLEM -w9603
> name s
: Problem placing instance [name]

M GROUP_PACK_PROBLEM
> number d
: Problem placing group [number]; try placing instances individually.

M CLASS_HEADING
> class d3
> classname s
> count d4
: Members of class [class] ([classname]) = [count].

M CLASS_RESOURCES
> resources z
: [resources]

M WAS_PLACED
> type s
> number d
> size d
: [size] instances in [type] [number] were placed as follows:

M DIRECTION
> dir s
: Considering [dir] cut lines.

M BLANK_LINE
: 

M RAW_TROUBLE
> dir s
> xmin d
> ymin d
> xmax d
> ymax d
> total_insts d
: Trouble with [dir] cut of x [xmin]-[xmax], y [ymin]-[ymax]
: ([total_insts] instances)

M STAGE_START
> stage d
> size d4
: BEGINNING STAGE [stage], with [size] active clusters to cut.

M NEW_FOURCUT
> index d
: New 4cut saved (retrieval index [index]), for cluster:

M FOURCUT_SUBREGIONS
> count d
: Cluster divided into [count] sub-clusters:

M CUT_COST
> cutnum d1
> cutcost d6
: Cut [cutnum]: cost = [cutcost].

M TOTAL_COST
> cost d7
: Total cost = [cost].

M FOURCUT_REJECT
> new_cost d6
> old_best d6
: Reject 4cut since new cost ([new_cost]) >= current best ([old_best]).

M UNGROUPED_SPECIAL_INST
> name s
: Special instance [name] was not grouped with any instances.

M GROUP_NUMBER
> number d
: Group [number]:

M A_GROUP_INSTANCE
> arch_name s-8
> inst_name s
: [arch_name] [inst_name]

M NUM_UNGROUPED
> num d
: A total of [num] tbufs or decoders were not put into groups with anything else.

M GROUP_LOCKED_AND_NOT -e9604
> num d
> locked_name s
> not_name s
: Instance ([locked_name]) of Group [num] has been locked while ([not_name]) has not.

M MIXED_GROUP_LOCKS
> screwups d
: (INTERNAL ERROR) [screwups] ill-formed groups.

M LEFTOVER_QUEUE_STUFF -w9605
: One or more cell queues had not been cleared.

M INST_NOT_LOCKED -e9606
> inst_name s
: Placement assigned no lock level to symbol [inst_name].

M SPECIAL_INST_NOT_STRUCTURED -e9607
> arch_name s
> inst_name s
: First placement did not structure-lock [arch_name] [inst_name].

M GROUP_KNOWS_INST_DOESNT -e9608
> inst s
> groupnum d
> inst_num d
: Group [groupnum] includes symbol [inst], whose group number is [inst_num].

M INST_KNOWS_GROUP_DOESNT -e9609
> inst s
> groupnum d
: Symbol [inst] has group number [groupnum], but group [groupnum] doesn't
: include it.

M GROUP_INCONSISTENCIES
> count d
: Number of group inconsistencies = [count].

M INST_NOT_PLACED -e9610
> inst_name s
: Placement assigned no position to symbol [inst_name].

M INACTIVES
> clusters d
> insts d
> area d
: [clusters] clusters, with [insts] symbols total, in [area] blocks, became "inactive".

M NEW_IMMOBILE
> class d
: Class [class] is newly recognized as immobile.

M SIDE
> celltype d
> side d
: Cell type [celltype], side [side]:

M A_CELL_NAME
> cell_netname s
> number d
: Cell netname [cell_netname], number [number].

M A_TRY
> try_number d3
> cost d8
: Try number [try_number]; cost = [cost]

M WINNING_TRY
> try_number d3
: Try number [try_number] was best.

M LEGAL_PCT
> legals d5
> moves d5
> pct f5.1
: [legals] of [moves] configurations appeared legal ( [pct] %)

M BACK_AND_FORTHS
> back_and_forths d5
> cells d5
> pct f5.1
: [back_and_forths] of [cells] returns were immediate ( [pct] %)

M AN_S_STRING
> string s
: [string]

M A_Z_STRING
> string z
: [string]

M SHOW_TOP_PARAMS
> xmin d
> xmax d
> ymin d
> ymax d
> max_stages d
> max_visits d
> max_tries d
> max_passes d
: Region used: x [xmin]-[xmax], y [ymin]-[ymax].
: [.br] max_passes = [max_passes].
: [.br] max_tries = [max_tries].
: [.br] max_visits = [max_visits].
: [.br] max_stages = [max_stages].

M ARCH_LOCK_STATS
> locked d5
> mobile d5
> total d5
> archname s12
: [archname]s: [total] total.  [locked] locked, [mobile] movable.

M LOOSE_CELL_PROBLEMS -w9611
> failed_pack_cells d
> visits d
> inactives d
: Trouble with [failed_pack_cells] adjustments of loose cells, out of [visits]
: passes through [inactives] cells.

M LOCKED_IN_STAGE
> insts_locked d
> cells_locked d
> stage d
: [insts_locked] instances in [cells_locked] cells were locked in stage [stage].

M INVALID_COST_TYPE
: [.br] CAUTION: Selected realcut cost type is not valid;
: will use default instead.[.br]

M TIMING_ISNT_ENOUGH
: [.br] CAUTION: Selected realcut cost type must be extended because path timing
: does not apply.[.br]

M PROTECTED_CUT_TRIES
> Lmin d
> Lmax d
> Rmin d
> Rmax d
> Lcount d
> Rcount d
: For split of x into [Lmin]-[Lmax] : [Rmin]-[Rmax],[.br]
: [Lcount] nets already hit the left and [Rcount] nets already hit the right.

M LEFT_AND_RIGHT_NET
> loads d4
> xmin d4
> xmax d4
> L s4
> R s4
> netname s
: [loads] loads in range [xmin] through [xmax], [L] [R]  hit by [netname].

M SPLITS_TO_TRY
> Ucount d
> num_feasible d
: There are [num_feasible] partitions to try of the following [Ucount]
: uncommitted nets:

E REALCUT
#
# ------------------ plutil.m ------------------ 
#
#@(#)plutil.m	6.74  4/29/94
 
 
B PLUTIL -start9001 -end9300 -current9084
: Placement utility functions
 
# Tool description (for program help)
M DESCRIPTION
: <<put a detailed description of your tool here>>
 
#---------------------------------------------------------------
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
#---------------------------------------------------------------
M MCELL
: Input PIC Cell name

M MGUIDE_CELL
: Input guide PIC Cell name

M MPARTIAL
: Partial design flag

M MDEBUG
: Debug flag

M MUNMATCH
: Flag for print out the unmatch with guide

M MIGNORE_RLOCS
: Ignore the RLOC parameters from the design file.

M MTIMING
: Use path timing.

M MOPEN_GUIDE_BLKS
: Allows extra logic into guided blocks.

M HOPEN_GUIDE_BLKS
: If TRUE, it allows new logic to be placed into guided blocks even if
: lock_routing=(whole_sigs || all).

#---------------------------------------------------------------
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
#---------------------------------------------------------------
M HCELL
: Input PIC Cell name

M HGUIDE_CELL
: Input guide PIC Cell name

M HPARTIAL
: Partial design flag

M HDEBUG
: Debug flag

M HUNMATCH
: Flag for print out the unmatch with guide

M HIGNORE_RLOCS
: All the design file RLOC parameters will be ignored
: by the placer. This includes RLOC and RLOC_RANGE.

M HTIMING
: Path timing will be used in ingroup and realcut iff timing is TRUE.


M MLOCK_ROUTING
: Lock the routing from the guide file.

M HLOCK_ROUTING
: Controls whether routing improvement will be able to
: change results taken from the guide file.

M MLOCK_ROUTING_ALL
: Lock routing for all guided signals.

M HLOCK_ROUTING_ALL
: Lock routing of all signals that have been selected for
: guiding by the 'guide_routing' parameter.

M MLOCK_ROUTING_WHOLE_SIGS
: Lock routing for completely guided nets

M HLOCK_ROUTING_WHOLE_SIGS
: Lock routing only for signals that have all pins matched in guide file.

M MLOCK_ROUTING_NONE
: Do not lock guided routing.

M HLOCK_ROUTING_NONE
: None allows guided routing to be discarded and re-routed to
: improve the timing.

#---------------------------------------------------------------
# GLOBAL BUFFER - Error and Warning Messages
#---------------------------------------------------------------
M GLOBAL_BUFFER_NOT_PLACED -e9001
> s1 s
: The [s1] can not be placed in the current configuration. Either 
: fix this individual constraint problem or constrain all global 
: buffers to specific locations or take off all constraints.[.br] 

M GLOBAL_BUFFER_DEDICATED_NOTE
: [.br]NOTE: The global buffers have dedicated pads that are used for directly driving
: the global buffer from an external source.[.br]
: If the dedicated pad is not used
: then an IBUF must be inserted between the pad and the buffer.[.br]

M PAD_PLACED_IN_DEDICATED_GLOBAL_BUFFER_SITE -e9002
> pad s
> gbuf s
> src s
> pin s
: The [pad] is placed in the dedicated pad location that is required for a
: [gbuf]. Because the global buffer is being driven indirectly by [src], the
: dedicated pad at '[pin]' must be left open.
# Something is occuping the dedicated pad location that needs to be used
# as a feed through.

M PAD_PLACED_IN_WRONG_DEDICATED_SITE -e9003
> pad s
> atype s
> btype s
> pin s
: The [pad] is placed in the wrong dedicated pad location '[pin]' for a '[atype]' 
: global buffer. This dedicated pad is directly sourcing a '[btype]' global
: buffer. Remove the constraint or change the constraint to one of the
: dedicated pads for a '[atype]' global buffer.
# This case the user used a dedicated pad but not the right one for the
# buffer type.

M PAD_MUST_GO_TO_DEDICATED_PAD -e9004
> pad s
> pin s
> gbuf s
: The [pad] located at [pin] must be placed in a dedicated pad location in order to
: drive the [gbuf]. A Pad directly 
: driving a global buffer must use a dedicated global buffer pad location.
# This case the pad is preplaced and the global buffer is not.

M GLOBAL_BUFFER_SOURCED_BY_NONDEDICATED_PAD -e9005
> s1 s
: The [s1] is being sourced from a pad other than the dedicated pad for this
: buffer. Either remove the constraint (or change it to the dedicated pad
: location) or add an IBUF.
# This case the global buffer is preplaced and (the pad is not or another
# pad is occuping the dedicated pad location.

M GCLK_MUST_USE_DEDICATED_OUTPUTS -e9006
: The GCLK buffer must use dedicated external pad outputs. 

M DRIVING_TOO_MANY_EXTERNAL_OUTPUTS -e9007
: Too many external outputs are being driven by the Global buffer. 

M OTHER_PADS_USING_DEDICATED_OUTPUTS -e9008
: There are not enough available dedicated output locations for the pads being
: driven by the global buffer. The following pads are located in dedicated external 
: output locations:

#
# --- Warning Messages ---
#
M DEVICE_PIN_ACTIVE -w9009
> s1 s
> s2 s
> s3 s
: Primary global buffers have a dedicated pad. Driving the global buffer from 
: other than the dedicated pad will automatically require the use of the dedicated pad 
: as a means of reaching the global buffer. The dedicated pad cannot be used
: for any other purposes and will be active due to the signal driving the
: global buffer.[.br]
: The use of [s1] instead of a pad to drive the [s2], requires that the device
: pin [s3] be active. 

M GBUF_WARNING1 -w9010
> clock_input s
> clock s
: The [clock_input] drives [clock].
: This signal cannot be routed through the dedicated input path
: and will incur an unpredictable routing delay. Since it must be routed
: through one of the dedicated BUFGP input pins, that pin will not be
: available for any other I/O signal.[.br]
: To use the dedicated input path, remove the IBUF symbol and connect
: the BUFGP symbol directly to the pad symbol. If the pad is already
: constrained to a pin that is not a dedicated BUFGP input, you might
: consider using a BUFGS instead, as it would not require an additional
: IOB to be used.

M GBUF_WARNING2 -w9011
> clock_input s
> clock s
: The [clock_input] drives [clock].
: This signal must be routed through one of the dedicated
: BUFGP input pins, and that pin will not be available for I/O signals.
: You might consider using a BUFGS instead, as it would not require an
:  additional IOB to be used.

M GBUF_WARNING3 -w9012
> clock_input s
> clock s
: The [clock_input] drives [clock].
: However, this I/O pad has been constrained to a pad other than the
: dedicated BUFGP input. This will require
: that the signal be routed through one of the dedicated BUFGP inputs,
: and that pin will not be available for any other I/O signal. The
: signal will also incur an unpredictable routing delay.[.br]
: To allow the dedicated input path to be used, remove the constraint
: or change it to one of the dedicated BUFGP inputs. If the constraint
: cannot be changed, you might consider using a BUFGS instead, as it
: would not require an additional IOB to be used.

M RLOCS_AND_CARRY_LOGIC_WHEN_IGNORE_RLOCS -w9075
: Although the ignore_rlocs=TRUE option was specified, RLOC parameters
: are required on carry logic symbols and will not be ignored from these
: symbols. The structure of individual carry chains -- and their relation
: to each other, if specified -- will be preserved.[.br][.br]
: Since the structure of the carry chain is preserved, you may wish to
: have the RLOCs on associated logic preserved as well. To selectively
: ignore RLOCs from your design, attach USE_RLOC=FALSE parameters as
: appropriate, instead of using the global ignore_rlocs=TRUE option.[.br][.br]
: If you have specified the placement of carry chains with respect to
: each other, these relationships will not be ignored by ignore_rlocs=TRUE.
: To do so, you must separate the carry chains into different RLOC sets.
  
#
# --- Informational Messages ---
#
M UNPLACE_GLOBAL_BUFFER_SECTION
: Unplaced global buffer(s):

M GLOBAL_BUFFER_SITES_SECTION
: Current global buffer placements:

M UNPLACE_BUFPG_INST
> instName s
: * [instName]

M EMPTY_GLOBAL_BUFFER_SITE
> type s
> slotName s
: [type] Global buffer slot '[slotName]' is empty.

M NONEMPTY_GLOBAL_BUFFER_SITE
> type s
> slotName s 
> instName s
: [type] Global buffer slot '[slotName]' contains [instName].

M EMPTY_DEDICATED_PAD_SITE
> pin s
: Dedicated '[pin]' is empty.

M NONEMPTY_DEDICATED_PAD_SITE
> pin s
> padName s
: Dedicated '[pin]' contains [padName].

#---------------------------------------------------------------
# General Error and Warning Messages
#---------------------------------------------------------------
M TOO_MANY_DEC_ON_1_EDGE -e9013
: Could not place decoders.  There are too many decoders on one edge.
: Please use constraints to aid placement.

M TOO_MANY_DEC_GROUP -e9014
> groupCount d
> slotCount d
: Too many decoder groups. There are [groupCount] in the design,
: but the part only has [slotCount].

M DEC_OUT_IMPOSSIBLE_PLACE -e9074
> net s
: Wands that source net [net] are impossible to place.  Please
: check your constraints.

M BAD_FILE_OPEN
> fname s
> type s
: Could not open file '[fname]' for [type]

M INTERNAL_ERROR -e9015
> message s
: INTERNAL_ERROR: Contact Xilinx Technical Support.[.br]
: [message]

M MORE_THAN_1_RLOC_BLOCK_HAS_SAME_BLKNM -e9017
> set s
> name s
: More than one RLOCed block for set [set] has the same BLKNM([name]).

M RLOC_HAS_2_BLKNMS -e9018
> set s
> name1 s
> name2 s
: An RLOC configured CLB(block) of set [set] has two block names.
: The BLKNM names are '[name1]' and '[name2]'.

M BAD_CARRY_LOGIC_RANGE -e9019
> s1 s
> topbottom s
: Range is incorrect for set '[s1]'. The set contains carry logic that is
: has been specified to locations from left to right. Carry logic that runs
: left to right must be located at the top or bottom of the chip. This set
: must be located at the '[topbottom]'. 

M RANGE_IS_TOO_SMALL_FOR_SET -e9020
: The specified range is too small for the set.

M INVALID_RANGE_VALUE -e9021
> chip_size d
: Invalid range specification. Valid ranges values are ( greater 
: than or equal to 0) and ( less than or equal to [chip_size]).

M INST_INCOMPATIBLE_IN_BLOCK -e9022
> inst s
: The [inst] is incompatible with other symbols at this location. Check the
: LOC constraint and the LOC constraints of other symbols at the same 
: location.
# this is checked for during the loading of single constraints, this most
# likely will not ever happen since this is checked for in cstmerge.

M CONFLICTING_BLKNM_AND_LOC_CONFIGURATION -e9023
: The BLKNM parameters on the following elements indicate that they should
: be placed into the same block, but no legal block configuration can 
: be found. Check the logic shown below against the requirements of 
: placement constraints, BLKNM parameters, and X and P signal parameters.

M CONFLICTING_IOB_AND_LOC_CONFIGURATION -e9024
: No legal block configuration can be found for the symbols that must
: be grouped into the a single IOB.
: Check the logic shown below against the requirements of 
: placement constraints, BLKNM parameters, and X and P signal parameters.

M BLOCK_NOT_CONFIGURED_CORRECTLY -e9025
: The symbols placed in this block do not represent a legal block configuration.
: Check the logic shown below against the requirements of 
: placement constraints, BLKNM parameters, and X and P signal parameters.

M INSTANCE_NOT_PLACEABLE -e9026
> instance s
: The [instance] is not placeable. All the specified locations are either already
: used or the individual locations are not allowed due competing routing 
: resource usage.

M BLOCKS_OF_SET_DO_NOT_FIT_IN_A_DEVICE_BLOCK -e9028
> set s
: The following block of the set [set] does not represent a legal 
: block configuration for this device.
: Check the logic shown below against the requirements of 
: RLOC constraints, BLKNM parameters, and X and P signal parameters.

M BLOCKS_OF_SET_USE_CONFLICTING_ROUTING_RESOURCES -e9029
> set s
: The following block of the set [set] does not represent a legal 
: block configuration for this device. 
: The block is using conflicting routing resources
: for the net inter-connections within the block. 
: Check the logic shown below against the requirements of 
: RLOC constraints, BLKNM parameters, and X and P signal parameters.

M TOO_MANY_SYMBOLS_FOR_BLOCK -e9073
> blknm s
> iob_or_clb s
> too_many_of s
: All of the symbols with the BLKNM parameter '[blknm]' cannot all fit into a
: single [iob_or_clb] block on this device. 
: The BLKNM parameter is used to both name a block in the LCA file and to 
: group symbols into a common block.[.br]
: Correct the following problem(s) for the symbols listed below.[.br][too_many_of]

M TOO_MANY_SYMBOLS_FOR_SET_BLOCK
> set s
> iob_or_clb s
> too_many_of s
: The following symbols of the set [set] cannot all fit into a single 
: [iob_or_clb] block for this device.
: Correct the following problem(s) for the symbols listed below.[.br][too_many_of]

M BAD_NET_IN_BLOCK -e9030
> net s
: The net '[net]' within the 
: block is the net that cannot be connected due to the connections of the 
: other nets in the block.

M NO_VALID_PLACEMENT_FOR_SET -e9016
: The set cannot be placed. The previously mentioned block(s) of the set should
: be closely examined.

M CANT_FIND_VALID_PLACEMENT -e9027
: Cannot generate a placement for this design.

M CANT_FIND_VALID_PLACEMENT_GUIDE -e9083
: PPR cannot generate a placement for this design. Examine the errors below
: to determine the exact cause of this problem.[.br][.br]
: Note that, since a guide design is being used, PPR will not place new or
: unmatched logic into CLBs which already contain guided logic. By isolating
: guided logic, the guided routing is less likely to prevent the routing of
: new signals.[.br][.br]
: However, it is possible to lift this placement restriction by specifying
: the following parameter on the PPR command line: open_guide_blks=TRUE. Be
: aware that, although this tactic may allow the logic to be placed, PPR may
: later encounter routing problems.

#---------------------------------------------------------------
# messages with the NOT_FIT prefix are used to indicate possible problems and
# their solutions. These error come during the final packing stage.
#---------------------------------------------------------------
M NOT_FIT_1 -e9033
: The following RLOC set(s) could not be placed on the device. This is 
: probably because all RLOC sets in the design could not be fit together 
: properly.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Use the ignore_rlocs=TRUE option on PPR to ignore all RLOC
: constraints in the design (except those on carry logic).[.br]
: (2) Use the RLOC_ORIGIN parameter to lock every RLOC set to an
: absolute location.

M NOT_FIT_1_XBLOX -e9076
: The following RLOC set(s) could not be placed on the device. This is 
: probably because all RLOC sets in the design could not be fit together 
: properly. Note that the design contains RLOC sets generated
: automatically by the XBLOX program.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Rerun the XBLOX program with the reg_rlocs=FALSE option to
: suppress the automatic generation of RLOC constraints for XBLOX
: modules that do not use carry logic.[.br]
: (2) Attach the USE_RLOC=FALSE parameter to individual XBLOX modules
: to selectively disable automatic RLOC generation. Check the XBLOX
: report file (design.blx) to determine how RLOCs were added to the
: design.[.br]
: (3) On each RLOC set, attach an RLOC_ORIGIN parameter to place
: the logic in an absolute location.[.br]
: (4) Use the ignore_rlocs=TRUE option on PPR to ignore all RLOC
: constraints in the design (except those on carry logic).

M NOT_FIT_2 -e9034
: The following RLOC set(s) could not be placed on the device. This is
: probably because (1) all RLOC sets in the design could not be fit
: together properly; and/or (2) symbols with absolute location constraints
: are creating an obstacle to the placement of RLOC sets.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Use the ignore_xnf_locs=INTERIOR option (or edit the CST file) to
: remove absolute location constraints from interior-type logic (function
: generator maps, flip-flops and TBUFs).[.br]
: (2) Use the RLOC_ORIGIN parameter to lock every RLOC set to an absolute
: location.

M NOT_FIT_2_XBLOX -e9077
: The following RLOC set(s) could not be placed on the device. This is
: probably because (1) all RLOC sets in the design could not be fit
: together properly; and/or (2) symbols with absolute location constraints
: are creating an obstacle to the placement of RLOC sets. Note that the
: design contains RLOC sets generated automatically by the XBLOX
: program.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Rerun the XBLOX program with the reg_rlocs=FALSE option to
: suppress the automatic generation of RLOC constraints for XBLOX
: modules that do not use carry logic.[.br]
: (2) Attach the USE_RLOC=FALSE parameter to individual XBLOX modules
: to selectively disable automatic RLOC generation. Check the XBLOX
: report file (design.blx) to determine how RLOCs were added to the
: design.[.br]
: (3) On each RLOC set, attach an RLOC_ORIGIN parameter to place
: the logic in an absolute location.[.br]
: (4) Use the ignore_xnf_locs=INTERIOR option (or edit the CST file) to
: remove absolute location constraints from interior-type logic (function
: generator maps, flip-flops and TBUFs).

M NOT_FIT_3 -e9035
: The following RLOC set(s) could not be placed on the device. This is 
: probably due to conflicts with guide-placed logic.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Use the ignore_rlocs=TRUE option on PPR to ignore all RLOC
: constraints in the design (except those on carry logic).[.br]
: (2) Using XDE, edit the guide design to free an area matching the
: shape of each RLOC set. To do so, use the DeleteBlk command on CLB
: or TBUF elements: this will prevent that logic from being guided
: and will make those resources available for RLOC set placement.[.br]
: (3) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

M NOT_FIT_3_XBLOX -e9078
: The following RLOC set(s) could not be placed on the device. This is 
: probably due to conflicts with guide-placed logic. Note that the
: design contains RLOC sets generated automatically by the XBLOX
: program.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Rerun the XBLOX program with the reg_rlocs=FALSE option to
: suppress the automatic generation of RLOC constraints for XBLOX
: modules that do not use carry logic.[.br]
: (2) Attach the USE_RLOC=FALSE parameter to individual XBLOX modules
: to selectively disable automatic RLOC generation. Check the XBLOX
: report file (design.blx) to determine how RLOCs were added to the
: design.[.br]
: (3) On each RLOC set, attach an RLOC_ORIGIN parameter to place
: the logic in an absolute location.[.br]
: (4) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

M NOT_FIT_4 -e9036
: The following RLOC set(s) could not be placed on the device. This is 
: probably due to conflicts with guide-placed logic.[.br]
: Possible resolutions to this problem are:[.br]
: (1) For sets that do not contain carry logic, ignore the RLOC
: constraints by attaching the USE_RLOC=FALSE parameter to the set.[.br]
: (2) Using XDE, edit the guide design to free an area matching the
: shape of each RLOC set. To do so, use the DeleteBlk command on CLB
: or TBUF elements: this will prevent that logic from being guided
: and will make those resources available for RLOC set placement.[.br]
: (3) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

M NOT_FIT_4_XBLOX -e9079
: The following RLOC set(s) could not be placed on the device. This is 
: probably due to conflicts with guide-placed logic. Note that the
: design contains RLOC sets generated automatically by the XBLOX
: program.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Rerun the XBLOX program with the reg_rlocs=FALSE option to
: suppress the automatic generation of RLOC constraints for XBLOX
: modules that do not use carry logic.[.br]
: (2) Attach the USE_RLOC=FALSE parameter to individual XBLOX modules
: to selectively disable automatic RLOC generation. Check the XBLOX
: report file (design.blx) to determine how RLOCs were added to the
: design.[.br]
: (3) On each RLOC set, attach an RLOC_ORIGIN parameter to place
: the logic in an absolute location.[.br]
: (4) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

M NOT_FIT_5 -e9037
: The following RLOC set(s) could not be placed on the device. This is 
: probably because (1) there are conflicts with guide-placed logic; and/or 
: (2) symbols with absolute location constraints are creating an obstacle 
: to the placement of RLOC sets.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Use the ignore_rlocs=TRUE option on PPR to ignore all RLOC
: constraints in the design (except those on carry logic).[.br]
: (2) Use the ignore_xnf_locs=INTERIOR option (or edit the CST file) to
: remove absolute location constraints from interior-type logic (function
: generator maps, flip-flops and TBUFs).[.br]
: (3) Use the RLOC_ORIGIN parameter to lock every RLOC set to an absolute
: location.[.br]
: (4) Using XDE, edit the guide design to free an area matching the
: shape of each RLOC set. To do so, use the DeleteBlk command on CLB
: or TBUF elements: this will prevent that logic from being guided
: and will make those resources available for RLOC set placement.[.br]
: (5) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

M NOT_FIT_5_XBLOX -e9080
: The following RLOC set(s) could not be placed on the device. This is 
: probably because (1) there are conflicts with guide-placed logic; and/or 
: (2) symbols with absolute location constraints are creating an obstacle 
: to the placement of RLOC sets. Note that the design contains RLOC sets
: generated automatically by the XBLOX program.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Rerun the XBLOX program with the reg_rlocs=FALSE option to
: suppress the automatic generation of RLOC constraints for XBLOX
: modules that do not use carry logic.[.br]
: (2) Attach the USE_RLOC=FALSE parameter to individual XBLOX modules
: to selectively disable automatic RLOC generation. Check the XBLOX
: report file (design.blx) to determine how RLOCs were added to the
: design.[.br]
: (3) Use the ignore_xnf_locs=INTERIOR option (or edit the CST file) to
: remove absolute location constraints from interior-type logic (function
: generator maps, flip-flops and TBUFs).[.br]
: (4) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

M NOT_FIT_6 -e9038
: The following RLOC set(s) could not be placed on the device. This is 
: probably because (1) there are conflicts with guide-placed logic; and/or 
: (2) symbols with absolute location constraints are creating an obstacle 
: to the placement of RLOC sets.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) For sets that do not contain carry logic, ignore the RLOC
: constraints by attaching the USE_RLOC=FALSE parameter to the set.[.br]
: (2) Use the ignore_xnf_locs=INTERIOR option (or edit the CST file) to
: remove absolute location constraints from interior-type logic (function
: generator maps, flip-flops and TBUFs).[.br]
: (3) Use the RLOC_ORIGIN parameter to lock every RLOC set to an absolute
: location.[.br]
: (4) Using XDE, edit the guide design to free an area matching the
: shape of each RLOC set. To do so, use the DeleteBlk command on CLB
: or TBUF elements: this will prevent that logic from being guided
: and will make those resources available for RLOC set placement.[.br]
: (5) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

M NOT_FIT_6_XBLOX -e9081
: The following RLOC set(s) could not be placed on the device. This is 
: probably because (1) there are conflicts with guide-placed logic; and/or 
: (2) symbols with absolute location constraints are creating an obstacle 
: to the placement of RLOC sets. Note that the design contains RLOC sets
: generated automatically by the XBLOX program.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) Rerun the XBLOX program with the reg_rlocs=FALSE option to
: suppress the automatic generation of RLOC constraints for XBLOX
: modules that do not use carry logic.[.br]
: (2) Attach the USE_RLOC=FALSE parameter to individual XBLOX modules
: to selectively disable automatic RLOC generation. Check the XBLOX
: report file (design.blx) to determine how RLOCs were added to the
: design.[.br]
: (3) Use the ignore_xnf_locs=INTERIOR option (or edit the CST file) to
: remove absolute location constraints from interior-type logic (function
: generator maps, flip-flops and TBUFs).[.br]
: (4) If a significant amount of design logic has changed, rerun PPR
: without the guide design so that it can find a better overall placement.

# > half_long_line = (NCLBCOLS/2)+1
M NOT_FIT_7_4K -e9039
> half_long_line d
: The following element(s) could not be placed on the device.[.br][.br]
: The addition of mapping and/or placement constraints to the design may 
: allow it to fit in the selected device, as explained below.[.br]
: To improve the utilization of CLB flip-flops, try pairing flip-flops with 
: common clock and control signals into common CLBs. This can be 
: accomplished via BLKNM or HBLKNM parameters, an RLOC set, or absolute 
: location constraints.[.br]
: To improve the utilization of function generators, try using FMAPs and/or 
: HMAPs to achieve better packing of gates into function generators.[.br]
: To improve the utilization of TBUF-driven longlines, if the number of 
: TBUFs driving a given signal is less than or equal to [half_long_line], try 
: constraining those TBUFs to the leftmost or rightmost half of the device. 
: This allows the two halves of a longline to be used for different 
: signals.

M NOT_FIT_7_3K -e9040
: The following element(s) could not be placed on the device.[.br][.br]
: The addition of mapping and/or placement constraints to the design may 
: allow it to fit in the selected device, as explained below.[.br]
: To improve the utilization of CLB flip-flops, try pairing flip-flops with 
: common clock and control signals into common CLBs. This can be 
: accomplished via BLKNM or HBLKNM parameters, CLBMAPs, or absolute 
: location constraints.[.br]
: To improve the utilization of function generators, try using CLBMAPs to 
: achieve better packing of gates into function generators.

M NOT_FIT_8_4K -e9041
> half_long_line d
: The following element(s) could not be placed on the device.[.br][.br]
: The addition of mapping and/or placement constraints to the design may 
: allow it to fit in the selected device, as explained below.[.br]
: To improve the utilization of CLB flip-flops, try pairing flip-flops with 
: common clock and control signals into common CLBs. This can be 
: accomplished via BLKNM or HBLKNM parameters, an RLOC set, or absolute 
: location constraints.[.br]
: To improve the utilization of function generators, try using FMAPs or 
: HMAPs to achieve better packing of gates into function generators. Also 
: make certain that gates which are driven by carry logic outputs (COUT0 
: and COUT) are mapped with FMAPs, and that each such FMAP is constrained 
: to the same CLB as its sourcing CY4 symbol.[.br]
: To improve the utilization of TBUF-driven longlines, if the number of 
: TBUFs driving a given signal is less than or equal to [half_long_line], try 
: constraining those TBUFs to the leftmost or rightmost half of the device. 
: This allows the two halves of a longline to be used for different 
: signals.

M NOT_FIT_9_4K -e9042
> half_long_line d
: The following element(s) could not be placed on the device. This is 
: probably due to the constraints of the guide-placed logic.[.br][.br]
: The addition of mapping and/or placement constraints to the design may 
: allow it to fit in the selected device, as explained below.[.br]
: To improve the utilization of CLB flip-flops, try pairing flip-flops with 
: common clock and control signals into common CLBs. This can be 
: accomplished via BLKNM or HBLKNM parameters, an RLOC set, or absolute 
: location constraints.[.br]
: To improve the utilization of function generators, try using FMAPs or 
: HMAPs to achieve better packing of gates into function generators.[.br]
: To improve the utilization of TBUF-driven longlines, if the number of 
: TBUFs driving a given signal is less than or equal to [half_long_line], try 
: constraining those TBUFs to the leftmost or rightmost half of the device. 
: This allows the two halves of a longline to be used for different 
: signals.[.br]
: Alternatively, you can rerun PPR without the guide design. Unless you 
: have floorplanned the guide design, it is unlikely that the overall 
: placement of guided logic and new logic will be optimal.

M NOT_FIT_9_3K -e9043
: The following element(s) could not be placed on the device. This is 
: probably due to the constraints of the guide-placed logic.[.br][.br]
: The addition of mapping and/or placement constraints to the design may 
: allow it to fit in the selected device, as explained below.[.br]
: To improve the utilization of CLB flip-flops, try pairing flip-flops with 
: common clock and control signals into common CLBs. This can be 
: accomplished via BLKNM or HBLKNM parameters, CLBMAPs, or absolute 
: location constraints.[.br]
: To improve the utilization of function generators, try using CLBMAPs to 
: achieve better packing of gates into function generators.[.br]
: Alternatively, you can rerun PPR without the guide design. Unless you 
: have floorplanned the guide design, it is unlikely that the overall 
: placement of guided logic and new logic will be optimal.

M NOT_FIT_10_4K -e9044
> half_long_line d
: The following element(s) could not be placed on the device. This is 
: probably due to the constraints of the guide-placed logic.[.br][.br]
: The addition of mapping and/or placement constraints to the design may 
: allow it to fit in the selected device, as explained below.[.br]
: To improve the utilization of CLB flip-flops, try pairing flip-flops with 
: common clock and control signals into common CLBs. This can be 
: accomplished via BLKNM or HBLKNM parameters, an RLOC set, or absolute 
: location constraints.[.br]
: To improve the utilization of function generators, try using FMAPs or 
: HMAPs to achieve better packing of gates into function generators. Also 
: make certain that gates which are driven by carry logic outputs (COUT0 
: and COUT) are mapped with FMAPs, and that each such FMAP is constrained 
: to the same CLB as its sourcing CY4 symbol.[.br]
: To improve the utilization of TBUF-driven longlines, if the number of 
: TBUFs driving a given signal is less than or equal to [half_long_line], try 
: constraining those TBUFs to the leftmost or rightmost half of the device. 
: This allows the two halves of a longline to be used for different 
: signals.[.br]
: Alternatively, you can rerun PPR without the guide design. Unless you 
: have floorplanned the guide design, it is unlikely that the overall 
: placement of guided logic and new logic will be optimal.

M LEAVE_FG_OPEN_FOR_COUT0 -e9049
> fg s
> cy4 s
: The [fg] cannot be placed as directed in the 'G' function generator 
: location.
: The 'G' function generator must be left unoccupied if either the COUT0
: signal of the [cy4] sources more than a single symbol or sources a 
: function generator not in the 'G' function generator of this CLB. The
: unoccupied function generator will be used as a feed-through for
: the COUT0 signal to reach the general inter-CLB routing resources.

M LEAVE_A_FG_OPEN_FOR_CIN -e9056
> f s
> g s
> cy4 s
: The function generators in this block cannot both be used. Currently
: occupied by [f] and [g].
: One of the function generators must be left unoccupied if the CIN
: signal of the [cy4]:[.br]
: (1) sources more than two symbols or[.br]
: (2) function generators sourced by the CIN signal are not in this block.[.br]
: The unoccupied function generator will be used as a feed-through for
: the CIN signal to reach the general inter-CLB routing resources.

M NEED_MORE_CY4_SHARED_INPUTS -e9050
> fg s
> cy4_pins s
> cy4 s
: The [fg] does not share enough common inputs with the [cy4_pins] pins
: of the [cy4].

#M SET_EXTENDS_BEYOND_DEVICE_EDGE -e
#> set s
#> top_bottom s
#> above_below s
#: The RLOC set '[set]' contains a carry chain that turns at the
#: '[top_bottom]' of the device. However, the same RLOC set contains other
#: logic which is RLOC'd [above_below] the '[top_bottom]' most CY4 symbols.
#: There is no legal placement for this set.

M HORIZONTAL_CARRY_NOT_ON_EDGE -e9082
> set s
: The RLOC set '[set]' contains a horizontal carry chain segment (carry out
: goes from left to right). The only possible placement for this type of
: structure is coincident with the top or bottom edge of the device. If
: there are other symbols of the set that are above or below the
: horizontal carry chain then the RLOCS must be such that the horizontal chain
: may be placed on a top or bottom edge.

#
# --- Warning Messages ---
#
M IOBS_OVERRIDDEN_BY_LOCS -w9045
: The following IOBs have been moved from their initial guided location 
: to a new location that has been specified using location constraints:

#---------------------------------------------------------------
# BUFT Error and Warning Messages
#---------------------------------------------------------------
M TBUF_OUT_IMPOSSIBLE_PLACE -e9046
> net s
: 3-state buffers that source net [net] are impossible to place.  Please
: check your constraints on these symbols.

M TBUF_OUTPUT_PACKING_PROBLEM -e9058
: Given the current placement constraints, PPR is unable to place all TBUFs
: so that common output signals are aligned on horizontal longlines.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) replace wildcard and/or area
: constraints with single-location constraints, in order to define a single
: valid placement of all TBUFs in the design; or[.br]
: (2) remove all constraints
: from TBUFs, giving PPR more freedom to find a valid placement.

M TBUF_CONTROL_PACKING_PROBLEM -e9059
: Given the current placement constraints, PPR is unable to place all TBUFs
: so that common output signals are aligned on horizontal longlines.[.br][.br]
: Possible resolutions to this problem are:[.br]
: (1) replace wildcard and/or area
: constraints with single-location constraints, in order to define a single
: valid placement of all TBUFs in the design; or[.br]
: (2) remove all constraints
: from TBUFs, giving PPR freedom to find a valid placement.

#: so that common control signals are aligned on vertical longlines.[.br][.br]

M TBUF_CONTROL_SPLIT_PROBLEM -e9066
> net s
: Given the current placement constraints on the TBUFs controlled by the
: enable signal `[net]', PPR cannot determine a placement for these TBUFs.[.br][.br]
: Modify the placement constraints on these TBUFs so that each is constrained
: to a specific column (rather than a range of columns or a wildcard).
: Alternatively, remove the TBUF constraints and allow PPR to determine its
: own placement.

M TBUF_INTERNAL_ERROR -e9048
> net s
: Internal error.  Bad placement of symbol(s) driving 3-state output net [net].

M TOO_MANY_TBUF_OUTPUT_LINES -e9053
: There are more tbuf output lines than number of slots.

M TBUF_BAD_CST -e9054
> net s
: Due to constraints and/or guide.  TBUFs on 3-state net [net] are
:  impossible to place.  Please check your constraints.

#---------------------------------------------------------------
# Informational and Other Messages
#---------------------------------------------------------------
M BOX_COST
> cost d
: Total of bounding box half-perimeters of non-multi-source nets
: not driven by global buffers = [cost]

M GROUP_STAT_INTRO
> when s
: Grouping statistics, [when]:

M NOT_GROUPED
> pin s
> arch s
> inst s
: No group through [pin] pin of [arch] [inst].

M GROUP_STATS
> grouped d4
> eligible d4
> total d4
> pinname s-3
> name s5
: [grouped] of [eligible] eligible [name]s ([total] total) grouped
: through [pinname] pin.

M INFO_MSG
> message s
: [message]

M INSTANCE
> inst s
: [inst]

M NOT_ENOUGH_BUS_SLOTS -e9055
: The design has more TBUF output lines than available slots.
: Use a larger part or modify your design.

M OSC_3K_PADS_ARE_USED -e9060
> pins s
> insts s
: Because the design uses the dedicated XTAL oscillator, no I/O
: signals can be placed in the IOBs at [pins]. The
: constraint on [insts] cannot be obeyed. Choose another location
: for the I/O signal or remove the constraint.

M TBUF3_INTERNAL_ERROR1 -e9061
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: Could not find buses with single constraint conflict.

M IBUF_DRIVING_BUFGP -e9062
> inst s
> ibuf s
: The [inst] is driven by [ibuf].
: The BUFGP input must be routed through a dedicated path
: that does NOT pass through the normal input buffer. Routing this
: signal through an IBUF would incur significant routing delay and would
: require an additional IOB.[.br]
: [.br]
: To allow this BUFGP to use the dedicated input, remove the IBUF and
: connect the BUFGP directly to the pad. (Previous versions of PPR would
: ignore this intermediate IBUF; however, PPR will no longer ignore this
: extra element.) An IBUF may be connected in parallel with the BUFGP if
: the signal sources logic other than the BUFGP.[.br]
: [.br]
: If this signal must be brought on-chip through a non-dedicated pad,
: use a LOC parameter or CST file constraint to lock it to the specific
: IOB. PPR will then route the signal to the BUFGP by going through a
: dedicated IOB. If a BUFGS is still available, you might consider using
: one of these instead, as they can be connected to a non-dedicated input
: without using an additional IOB.

M TBUF_GROUP_SLOT_CONTENTION -e9065
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: We have more than one single constrained group for the same tbuf
: output line slot. 

M NOT_FIT_IOB_OSC_3K
> pins s
: NOTE: Because the design uses the dedicated XTAL oscillator, no I/O
: signals can be placed in the IOBs at [pins].

M NOT_FIT_IOB_BUFG_FEED_THRUS
> pins s
: NOTE: The design uses global buffers that require the use of dedicated IOB
: locations at [pins].

M NOT_FIT_IOB1 -e9069
: No placement locations can be found for the IOB(s) below.

# Future: No time now.
# Note that I have identified the IOBs solely by the name of the signal
# attached to the pad (:EXTNM in MXN) rather than showing each individual
# symbol making up the IOB. This is consistent with how XNFPREP and other
# programs identify IOBs. Also, it gets around another problem, which is
# that some I/O symbols seen by PPR were not really put there by the user
# (i.e. the user put down OUTFFT but PPR sees OUTFF and OBUFT).

#If IOBs do not fit and guide is *NOT* being used:
M NOT_FIT_IOB2 -e9070
: Given the current I/O constraints, no placement could be found for the
: IOB(s) listed below. Check the following types of constraints for conflicting
: requirements:[.br]
: (1) whole-edge or half-edge constraints on pad or I/O symbols;
: and/or[.br]
: (2) prohibit-type constraints on specific package pins (specified
: with `notplace instance *' or `notplace block *' in the CST file).

#If IOBs do not fit and guide *IS* being used:
M NOT_FIT_IOB3 -e9071
: With the IOBs guided from the guide design and the current I/O constraints,
: no placement could be found for the IOB(s) listed below. Check the following
: types of constraints for conflicts with each other and with guided IOBs:[.br]
: (1) whole-edge or half-edge constraints on pad or I/O symbols; and/or[.br]
: (2) prohibit-type constraints on specific package pins (specified with `notplace
: instance *' or `notplace block *' in the CST file).

M TOOL_PLOG_ERROR -e9072
> message s
: [message]
# this is just a general purpose error that can be used to report errors until
# they are well enough defined and/or it is decided that it will actually be 
# an error

M XY_BBOX
> xtot d6
> ytot d6
: Single-source, non-global bounding boxes: X [xtot] , Y [ytot]

M MULTI_SOURCE_COSTS
> type s
> perp d4
> parallel d4
> xbox d4
> ybox d4
: [type]-sourced nets: perp [perp] , parallel [parallel] ;  xbox [xbox] , ybox [ybox]

E PLUTIL
#
# ------------------ artslib.m ------------------ 
#
#@(#)artslib.m	6.1  5/10/93
 
 
B ARTSLIB
: Architecture Specific Library Routines
 
# Tool description (for program help)
M DESCRIPTION
: Architecture Specific Library Routines
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

M CELL
: The input filename containing a design to be routed.

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M HCELL
: Expected is a filename to be a PIC MAP file with Mxn information.

M LAST_UPDATE
> date s
: [.br] Last update to artslib: [date]. [.br]

M TECHNOLOGY_INFO
> blocks d
> nodes  d
> arcs   d
: # of tifblocks: [blocks]. [.br]
: # of mazenodes: [nodes]. [.br]
: # of  mazearcs: [arcs]. [.br]

M E_BAD_TD
> funcname  s
> msg  s
: Unexpected TD ERROR detected by:"[funcname]"
: [.br]   "[msg]"[.br]

E ARTSLIB
#
# ------------------ matcher.m ------------------ 
#
#@(#)matcher.m	6.1  1/17/94
 
 
B MATCHER
: Performs Weighted Bipartite Matching
 
# Tool description (for program help)
M DESCRIPTION
: <<put a detailed description of your tool here>>
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
 
# Error and Warning Messages
 
# Informational and Other Messages
 
E MATCHER
#
# ------------------ guidext.m ------------------ 
#
#@(#)guidext.m	6.3  4/12/94
 
 
B GUIDEXT
: Guide extension tool
 
# Tool description (for program help)
M DESCRIPTION
: Provide bel usage information for guide placement
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

M GCELL
: Name of the guide cell.

M SUBTOOL
: it is TRUE if guidext is called by a higher-level tool.

M HGCELL
: It is opened for read only.

M HSUBTOOL
: If TRUE, guidext leaves behind a Bitset for the subtool to operate on.
: If FALSE, guidext produces a printout of the Bitset.
 
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
 
# Error and Warning Messages

M E_PREROUTED_SIGNAL_SHORT
> net1   s
> net2   s
> resource  s
: Pre-routed net:[net1] is shorted with net:[net2][.br]
: Both are trying to use resource:"[resource]"[.br]
: This is a catastrophic error...no routing is performed.[.br]

M ASSERT_FAIL
> msg  s
: [.br]INTERNAL ROUTER PROBLEM; ASSERTION FAILED:[.br]
: ASSERT([msg]).[.br]
 
# Informational and Other Messages

M LAST_UPDATE
> date s
: [.br] Last update to guidext: [date][.br]
 
E GUIDEXT
#
# ------------------ pa.m ------------------ 
#
#@(#)pa.m	6.55  5/5/94
 
 
B PA -start7000 -end7699 -current7042
: path analyzer
 
# Tool description (for program help)
M DESCRIPTION
:    Tool pa runs the path analyzer.
: [.br]INPUTS:
: [.br]<design>.*.  The design should
: have a file <design>.na, <design>.nb, <design>.p, <design>.pm, or <design>.pf.
: These are produced by running the
: ppr tools xnfupd if appropriate, xnf2mxn, mxnflat, mxnprep, fgmake, mincut,
: blkmake, picflat, mxmazer, or simply ppr.
: [.br]OUTPUTS:
: [.br]  pa.log.  General information about the slow paths in the design.
 
# External Parameter Names and Help Messages
# What is this parameter?  This is the...(a short & pithy 1-liner)
# What does this parameter do?  This parameter...(verbose multi-liner)

M MXNCELL
: Name of the design.

M HMXNCELL
: A .na extension is assumed.
 
M PARTTYPE
: Target LCA device and package.

M HPARTTYPE
: Speed data depend on the parttype.

M MSTOP_IF
: Should PA stop if a timespec is sure to be missed?

M HSTOP_IF
: Tests feature that PPR needs.

M MREPORT_PATHS
: When a spec is missed, should PA report details on paths?

M HREPORT_PATHS
: In 'trouble' situations, controls whether path details are displayed.

M MMAX_ENDPINS
: Maximum paths to report, on a miss.

M HMAX_ENDPINS
: Limits number of detailed paths displayed, under 'report_paths' control.

M NET_DELAY
: Value to use for estimated delay between external CLB pins.

M HNET_DELAY
: Without real data from a place+route tool, pa will normally assume that every
: connection consumes zero time.  This parameter allows something slightly more
: reasonable - a fixed delay for every CLB-to-CLB connection.  Further
: adjustments are made, e.g., known delay increments that must be incurred to
: get out of blocks; or reductions for load pins that are likely to be driven
: from within a block.

M NPINS_SHOW
: Number of pins with worst slacks to display.

M HNPINS_SHOW
: How many of the worst pins should be displayed?

M PICTYPE
: Flavor of pic to use.

M HPICTYPE
: The pic netlist changes depending on the stage of design processing.
: This parameter selects the stage to use.

M P_MSG
: PIC

M HP_MSG
: generic pic cells (.p)

M P_FGMAPS_MSG
: PIC_FGMAPS

M HP_FGMAPS_MSG
: after fgmap.  FMAPs and HMAPs replaced by function generators (.pp)

M P_FGS_MSG
: PIC_FGS

M HP_FGS_MSG
: after fgmake.  Primitives replaced by function generators (.pb)

M P_MAP_MSG
: PICMAP

M HP_MAP_MSG
: after mdmake - picmap cells (.pm)

M MIGNORE_TIMESPECS
: Ignore timespecs in MXN?

M HIGNORE_TIMESPECS
: When this parameter is True, timespecs in the mxn netlist are ignored.

M MUSE_FASTER_C2S
: Control paths between ffs with different specs?

M HUSE_FASTER_C2S
: When this parameter is False, a path between two flip-flops to which
: different specs have been attached is not controlled.  When True, such
: a path IS controlled, and is required to meet the faster of the two specs.

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)
 
# Error Messages
M NODE_REVISIT -e7000
> newlabel d4
> newname z
> label d4
> name z
: Tried to revisit [newname] ([newlabel]) from [name] ([label]).
 
# Warning Messages

# Informational and Other Messages
M GRAPH_SIZE
> nodes d
> arcs d
> clocked d
: Graph has [nodes] nodes ([clocked] clocked), [arcs] arcs.

M NUM_SLACK_STRUCTS
> allocated d
> total_pins d
: Allocated slack structures for [allocated] (load) pins, of [total_pins] pins.

M LOAD_TIF_MODEL
: Loading the tif model

M NO_ACTUAL_ARRIVAL -e7001
> pinname z
> direction s
: [direction] wave never reached pin [pinname] - something is bogus!

M MISSED_DEADLINES
> misses d
> total_over f7.1
: Deadline missed at [misses] pins.
: Total overflow = [total_over] nS.

M SLACK_TABLE_HEADING
> filler s
: [filler] (ns)  to pin on

M A_TARDY_PIN
> actual f5.1
> pin z
> archname s
> drives s
> driven_net z
: [actual](ns) to pin on [archname] [drives] net [driven_net]  ([pin])

M MISSING_SPEED_DATA -e7002
: No speed data are available.  This indicates either that your installation
: was not properly completed (e.g., a speeds.xct was left over from a previous
: install), or that a bad value of the datafile_search_path in some xactinit.dat
: file is being used.

M NEGATIVE_DELAYS -w7003
> count d
> pins z
: The following [count] pins were given negative delays (unrouted?),
: changed to 0: [.br]
: [pins]

M NO_DELAYS_SET
: None of the estimated connection delays that pa will use were set.

M COUNT_PINS_SET
> pins_reset d
> pins_changed d
: Delays set at [pins_reset]  load pins, [pins_changed] of which were changed.

M COUNT_ARCS_SET
> arcs_reset d
> arcs_changed d
> arcs_unchanged d
: This affected [arcs_reset] arcs in pa.  [arcs_changed] changed,
: [arcs_unchanged] didn't.

M REASONABLE_ZEROS
> count d5
> type s
: [count] [type] pins were given delay zero.

M STRANGE_ZEROS
> count d
> pins z
: [count] pins, not in listed cases, got zero delay: [.br]
: [pins]

M STRANGE_NONZEROS
> count d
: [count] pins got nonzero delay when zero was expected:

M PIN_LIST
> pins z
: [pins]

M MAX_WEIGHT_PATH
> weight d
: Total connection weight in maximum-weight path = [weight].

M BAD_STEP -e7004
> step d
> worst f6.1
> worst_pin z
: Problem during step [step]: [worst], at [worst_pin].

M STEP_REPORT
> step d2
> total f6.1
> ratio f6.3
> smallest f4.1
> biggest f4.1
: Step [step].  Total [total] = [ratio]*orig.  Min=
: [smallest].  Max=[biggest].

M STEPS
> small f5.1
> steps d2
: [steps] steps: [small].

M SLACK_STRUCT
> pin_name z
> delay d4
> lowBound d4
> actual d4
> required d4
> limit d4
> fc2s f5.2
> fp2s f5.2
> fc2p f5.2
> fp2p f5.2
> max_upper d4
: Pin [pin_name]: dly [delay], lowB [lowBound], act [actual], req [required],
: lim [limit], f [fc2s] [fp2s] [fc2p] [fp2p], upr [max_upper]

M A_STRING
> string z
: [string]

M FANOUT
: Use total source fanout.

M LENGTH
: Use path length.

M INITIAL_GOAL
> ratio f5.2
: If period is not specified, initial goal=[ratio] * smallest conceivable.

M DONE_PUSHING
: Have eliminated negative slacks.

M XY_LOWER_BOUNDS
: Lower bounds on delay as a function of (|dx|, |dy|):

M XY_ESTIMATES
: Estimated delay as a function of (|dx|, |dy|):

M GET_DELAY_TIMES
> time_opt d4
> time_real d4
: Got optimal delays in [time_opt] secs.,
: realistic delays in [time_real] secs.

M GLOBAL_ESTIMATE
> global_delay f4.1
: Delay to load of global buffer = [global_delay] ns.

M DLY_TAB
: Getting delays as a function of delta_x and delta_y

M UNSPECIFIED_PART -w7005
> default s
: No part was specified to the path analyzer by its caller or in the netlist:
: use default [default].

M PIN_WITH_INDEX
> pinname z
> index d
: Pin [pinname] has index [index].

M CORRUPTED_PIN_INDICES -e7006
> badpin d
: Internal pin index error; multiple pins with index [badpin].
: Path analysis cannot run!

M INVALID_CLOCK_RELATED_SPEC -e7007
> spec_label s
> spec_type s
: This design has no clocked elements.  The timing specification
: [spec_label] of type [spec_type] is therefore invalid.

M MULTI_SPECS_ARRIVE -w7008
> count d
> spec_type s
> type_desc s
: More than one [spec_type] unqualified spec arrived at [type_desc] of
: [count] clocked elements.  In each case, the unqualified spec with the
: tightest specification will be used.
: These clocked elements (identified by the nets they source), the unqualified spec,
: and the specification are listed below:[.br]
:  ELEMENT          NET WITH SPEC            SPECIFICATION

M A_MULTI_ARRIVAL
> net_driven z-24
> net_name s-24
> delay s
: [net_driven] [net_name] [delay]

M SPEC_REPORT_HEADER
> path_type_name s
: [.br]
: Summary of controlling spec for [path_type_name] specifications:

M A_SPEC_THAT_CONTROLS_SOME
> specname s
> count d
: Spec [specname] specification controls [count] clocked elements.

M SUB_HEADER
: These elements are identified below by nets that they drive.

M AN_INST
> inst_name z
: [inst_name]

M ARC_SIZE
> pa_arcs d
> g_arcs d4
> noncomb_loads d
:  Of [g_arcs] arcs,  PA will use [pa_arcs] ([noncomb_loads] into
: non-combinational nodes).

M NO_USER_SPECS
: No timing requirements have been specified.  Target values will be set
: automatically.

M CHECK_FEASIBILITY
: Check if timing can be met for specs with fixed path delay requirements
: (suppose connection delays equaled their lower bounds)
: and determine reasonable delay targets for other specs.[.br]

M BLANK_LINE
: 

M REPEATED_DEFAULT -w7011
> spec_type z
> value f5.1
: Encountered multiple specifications of [spec_type].  The tightest one
: will be used.  So far, that is [value] ns.

M SPEC_DOES_NOT_APPLY -w7013
> spec z
: Specification [spec]
: [.br]does not apply to any paths.

M CMDLINE_OVERRIDE
> spec_type s
> value z
: Default [spec_type] specification from command line ([value])
: is overriding value from the schematic.

M NO_PATHS_TO_ANALYZE -w7014
: There are no specified or default paths to analyze.  Path analysis
: will not be used.  Please check the setting of default specifications.
: A design without clock elements might benefit from a from:pads:to:pads
: or equivalently a dp2p specification.

M PATH_INTRO
> start_arch s
> start_driven_net s
> end_arch s
> drives s
> end_driven_net s
: [.br]Path from [start_arch] driving net [start_driven_net] to
: [end_arch] [drives] net [end_driven_net]

M WOULD_MISS_SO_PICK_NEW_TARGET -w7015
> info z
> new_target f5.1
> miss d
> total d
: For the specification '[info]', at least [miss] of [total] path endpoints will
: apparently not meet the specified delay.  The allowable delay for all paths
: covered by this specification will be increased to [new_target] ns.  Although
: PPR will miss your original specification, it is likely to produce a result
: significantly better than the new, relaxed specification.[.br][.br]
: If some paths in this specification need not run at the speed originally
: specified, you could exclude these from the above specification
: and add a new specification to control these slower paths.

M MISSED_TIMESPEC_INEVITABLE -e7016
> info z
> miss d
> total d
: For the specification '[info]', at least [miss] of [total] path endpoints would
: not meet the specified delay, even
: if every connection were routed with the mimimum delay consistent with the
: current implementation.  These endpoints are listed below, along with
: total path delays, estimated using the MINIMUM delays for every connection.  
: The connections have not yet been routed!  Because different connections
: may want the same wiring resources, it is unlikely that all will
: simultaneously achieve their minimum delay values in a finished routing.  
: The expected path delays are therefore greater than the values below.[.br]

M TIMESPEC_MISSED -w7017
> miss d
> total d
: [miss] of [total] path endpoints have apparently missed this timespec.
: These endpoints are listed below, along with estimated total path delays
: after routing.

M INTRO_PIN_DETAILS
> pins d
> paths d
: Slowest estimated paths: [pins] worst endpoints, [paths] with path details

M INTRO_TO_PATHS
> num_endpoints d
: Details on all slowest paths to the first [num_endpoints] endpoints above:

M WORST_INTRO
> blank_or_not s
> slack f5.1
> total f5.1
> path_length d
: There are [blank_or_not]rigid specs.  Slack=[slack] ns, total=[total] ns,
: [path_length] pins:

M A_PIN_IN_PATH
> net z-30
> cumu f5.1
: Through net [net]: [cumu] ns.

M MAX_NPATHS
> max_endpins d
: Maximum number of paths through any connection = [max_endpins].

M NPATH_STATS
> nonzero_npath_pins d
> total_pins d
> min_npaths d
> max_npaths d
> average f-10.1
: [nonzero_npath_pins] of [total_pins] pins are on some paths.
: [.br]Range is from [min_npaths] to [max_npaths]; average is [average]

M INVALID_CLOCK_RELATED_PARAMETER -e7018
> statement_type s
: This design has no clocked elements.  Hence all clock-related default
: specifications would be ignored.  The [statement_type] parameter
: is therefore invalid.  Non-clock related paths are not controlled by
: default.  These paths can be controlled by specifying a
: from:pads:to:pads or a dp2p specification.

M NO_MATCHING_PAD -e7019
> pattern s
> direction s
> spec_type s
: Qualifier "[pattern]" on [spec_type] spec
: doesn't match any [direction] pad.

M PATH_TIMING_CANNOT_RUN -e7020
: Earlier errors prevent path analysis from running.  Please
: review messages above, and correct problems that may have
: resulted from your input, e.g.,
: specifications that do not control any paths,
: or incorrectly entered pad or signal name patterns.  If you cannot resolve
: the problem, please contact Xilinx technical support.  In
: the meanwhile, you can implement your design by running
: PPR with the command line parameter "path_timing=False".

M TIMESPECS_BUT_NO_PATHS -e7021
: You provided one or more timing specifications, but none that apply
: to any paths in this design.

M SPEC_STATS
> info z
> starts d4
> stops d4
> conns d4
> actives d4
: Spec [info][.br]
: has [starts] starts, [stops] ends, [conns] connections;
: [actives] active nodes.[.br]

M INTRO_SUMMARY1
: -----------------------------------------------------------------[.br]
: Timing analysis summary[.br]
: -----------------------------------------------------------------[.br]

M INTRO_SUMMARY2
> blanks s
: [blanks]Deadline  Actual(*)  Specification

M INTRO_SUMMARY3
> blanks s
: [blanks]--------  ---------  -------------

M A_SUMMARY_LINE
> flag s4
> deadline s
> actual s
> qualifier z
: [flag] [deadline]  [actual]    [qualifier]

M NO_SPECS_NOTE
: [.br]
: (*) Note: please use the -FailedSpec and/or -TSMaxpaths options of the
: Xdelay-TimeSpec command, accessible through the XDE or XDelay program,
: to confirm the actual path delays computed by PPR.

M GOOD_NOTE
: [.br]
: (*) Note: the actual path delays computed by PPR indicate that ALL timing
: specifications you provided have been met.  Please use the -FailedSpec
: and/or -TSMaxpaths options of the Xdelay-TimeSpec command, accessible
: through the XDE or XDelay program,
: as a final confirmation of the performance of your design.

M MISS_NOTE
> missed d
> rigids d
> be_verb s
: [.br]
: (*) Note: the actual path delays computed by PPR indicate that
: [missed] of [rigids] timing specifications you provided
: [be_verb] not met.  To confirm this result, please use the -FailedSpec
: and/or -TSMaxpaths options of the Xdelay-TimeSpec command, accessible
: through the XDE or XDelay program.

M CMDLINE_SAYS_IGNORE_SPEC -w7022
> spectype s
: Because your ppr command included "[spectype]=ignore", the [spectype]
: specification in the netlist will be ignored.

M IGNORE_DEFAULT_PATHS
> dpath_type s
> path_type s
: The schematic specifies "[dpath_type]:ignore", so [path_type] paths 
: without explicit specifications will not be controlled.

M PATH_LINE_INTERNAL
> rpt_line z-55
> delay f5.1
> cumulative f5.1
: [rpt_line]:[delay] ([cumulative]ns)

M REDEFINITION_OF_TNM -e7023
> tnm s
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: Encountered redefinition of tnm [tnm].

M TNM_USED_NOT_DEFINED -e7024
> tnm s
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: Encountered use of tnm [tnm] that is not defined.

M SYNTAX_ERROR_IN_FROM_TO -e7025
> label s
: INTERNAL ERROR  Please contact Xilinx Technical Support.
: Encountered error while parsing [label] timespec.

M A_SLACK
> label d4
> slack f5.1
> pinname z
: Slack on node [label] = [slack] ns ([pinname]).

M SYNTAX_TYPES_MIX -w7026
> spec_type s
: Encountered [spec_type] specification(s) as well as From-To
: specification(s) of a similar kind.  Mixing the two kinds of
: specifications is not an error.  However, use of From-To syntax only
: gives you better control over path specifications.

M TS_GROUP_IS_EMPTY -e7027
> spec_label s
> group_label s
: The specification `[spec_label]' refers to the group `[group_label]',
: which does not contain any valid path endpoints.[.br] 
: If `[group_label]' is defined by a TNM parameter on a signal or load
: pin, it must eventually reach a flip-flop or input latch when traced
: forward. Check that the TNM does reach a flip-flop or latch, and check
: the XNFPREP report file to verify that the target symbols were not
: trimmed. (Note that TNM parameters on signals or pins will NOT be
: traced forward to tag I/O pads or RAMs. For these types of endpoints,
: attach a TNM parameter directly to the symbol. For an I/O pad, the TNM
: may also be connected to the signal DIRECTLY connected to the pad
: symbol.)[.br]
: If `[group_label]' is defined by a TIMEGRP statement, check that the
: newly-created group does actually contain one or more elements. 

M NO_TRACE_THRU_ASYNCHRONOUS_FF_INPUTS -w7028
: The design has flip-flops with asynchronous set/reset controls (PRE/SD or
: CLR/RD pins).  When PPR analyzes design timing, it does not trace paths
: through the asynchronous set/reset input and on through the Q output.[.br][.br]
: If you want PPR to control the delay on paths through asynchronous set/reset
: pins, you must split the delay requirement into two segments:
: one ending at the set/reset input, and the other beginning at the flip-flop
: output.[.br]
: If you want PPR not to analyze paths that lead to asynchronous set/reset pins,
: attach an IGNORE specification to the pin(s) or signal(s).[.br][.br]
: By default, XDelay reports all paths through asynchronous set/reset pins.
: To prevent XDelay from showing these paths, use FlagBlk CLB_Disable_SR_Q
: on the appropriate flip-flops.

M NO_TRACE_THRU_RAM_WE_OR_DATA_INPUTS -w7029
: The design has RAM elements.  When PPR analyzes design timing, it does
: not trace paths through the data or write-enable inputs and on through 
: the RAM output.  Such paths are normally of interest only when the RAM is
: being read during a write operation.[.br][.br]
: If you want PPR to control the delay on paths through the D or WE inputs,
: you must split the delay requirement into two segments: one ending
: at the RAM input pin, and the other beginning at the RAM output.[.br][.br]
: By default, XDelay does not report paths through D or WE pins either.
: To allow XDelay to show these paths, use FlagBlk CLB_Enable_WE and/or
: FlagBlk CLB_Enable_DIN on the appropriate RAMs.

M SPECD_PATHS_AND_CONTROL -w7030
> uncontrolled_specd_paths d
> multiply_controlled_specd_paths d
> design z
: In categories of paths with one or more timing specifications, the
: design has [uncontrolled_specd_paths] path end-point pairs that are
: not controlled by any timing specification and
: [multiply_controlled_specd_paths] that are controlled by more than one
: timing specification.  The end-point pairs are listed in file
: [design].tsi.  Note that there may be multiple paths between any
: listed pair of end-points.  To limit the number of paths reported in
: each category, set PPR parameter show_tsi_paths = <value>. 

M EXTRA_SLACK_STRUCTS
> num_extras d
: Extra structures allocated for "don't care" equivalent pins: [num_extras].

M LOW_LIMIT
> limit f4.1
> lowbound f4.1
> pinname z
: Recommend [limit] ns, < [lowbound] ns, for pin [pinname]

M A_CHARSTR
> charstr s
: [charstr]

M EQUIVALENCE_MISMATCHES
> count d
: In [count] pairs of pins that are "equivalent" to the router, path timing
: is irrelevant to one but not the other.

M BAD_SYNTAX -e6801
> spec_label s
> spec_type s
: Encountered bad syntax for timing specification [spec_label] of type
: [spec_type].
: [.br]

M UNSPECD_PATHS_AND_CONTROL -w7034
> uncontrolled_unspecd_paths d
: In categories of paths that have NO timing specifications, the design
: has [uncontrolled_unspecd_paths] path end-point pairs.  Note that
: there may be multiple paths between any listed pair of end-points.  To
: limit the number of paths reported in each category, set PPR parameter
: show_tsi_paths = <value>. 
: [.br]

M SUPPRESS_UNSPECD_UNCONTROLLED_PATHS
> design z
: The end-point pairs are listed in file [design].tsi.
: To suppress the listing of paths for categories with no timing
: specifications, set PPR parameter tsi_show_all=FALSE. 

M SEE_UNSPECD_UNCONTROLLED_PATHS
: To see the listing of paths for categories with no timing
: specifications, set PPR parameter tsi_show_all=TRUE.

M NA_NOTE
: [.br]
: (x) These specifications did not apply to any paths in the design.


M TSI_FILE_OPEN_ERROR -e7036
> design z
: The file "[design].tsi" could not be opened for writing.

M WARN_RISING_FALLING
: [.br]
: Note: The design contains flip-flops clocked by opposite edges of the same
: signal.  Default specs generated automatically by PPR will not properly
: control paths between opposite-edge flip-flops.  The delays on such paths
: will be properly controlled ONLY if:
: [.br]
: (1) the flip-flops are grouped by clock
: edge using RISING and FALLING TIMEGRP statements, and these subgroups
: are used in TIMESPEC statements with the appropriate High and Low clock
: times; or
: [.br]
: (2) a C2S-style TIMESPEC statement with the appropriate High
: clock time is attached to the clock signal.

M MULTIPLE_CLOCK_NETS
> clock_nets_list z
: [.br]
: Note: The design contains more than one clock signal
: ([clock_nets_list]). Default specs generated automatically by PPR will
: not control each clock at its own best possible frequency; clocks which
: could run faster may be controlled at a slower frequency. If you have
: specified no TIMESPEC requirements (or only a generic `FROM:FFS:TO:FFS'
: requirement), the design performance may not have been optimized by PPR.
: For best results, supply individual TIMESPECs for the flip-flops on
: each clock signal that you care about.

M CLOCKED_SPEC_BUT_NO_CLOCKED_INSTS -e7040
> spec_id s
> spec_type s
: Since there are no clocked instances in the design, the timing
: specification [spec_id] of type [spec_type] is invalid.

M TAGLESS_FF_NETS -w7041
: Some paths included in the Timing Analysis Summary above may not be
: included in the reports you generate with the XDelay-TimeSpec command
: (within the XDE or XDelay program).  The XACT-Performance Summary chapter
: of the PPR report file details which specifications may not be analyzed
: completely by XDelay-TimeSpec, and explains how the results of these
: specifications can be properly determined.

M BURIED_FF_DETAILS
: [.br]*** PPR: WARNING 7041:[.br][.br]
: For the specifications listed below, the reports you generate with the
: XDelay-TimeSpec command (within the XDE or XDelay program) may be
: incomplete.  The flip-flops shown below are path endpoints for these
: specifications, but will not be recognized as such by XDelay.  Although
: the XACT-Performance Summary shown above does include paths with these
: endpoints, the XDelay-TimeSpec report will not.[.br][.br]
: Each flip-flop listed below sources only the other flip-flop in the
: same CLB (and possibly its own D pin) using the dedicated feedback path.
: The specs that control paths ENDING at the flip-flop are shown; those
: that control paths starting at the flip-flop are not shown, since the
: internal feedback delay is fixed.  Where no specs are listed, the flip-flop
: is included in TIMESPECs only as a path starting point.[.br][.br]
: For each flip-flop listed below, use the specified CLB location in the
: -To option of the XDelay command.  This will produce a report of all paths
: that end at that CLB, including those ending at the flip-flop.  XDelay
: does not identify these flip-flops directly by their output name, but by
: the adjacent flip-flops they drive.  For example, `Target FFY drives D
: input to FFX driving net <name>.'[.br][.br]
: As always, timing simulation may be used to verify design performance.
: All paths associated with these flip-flops will be modeled correctly
: in simulation.[.br]

E PA
#
# ------------------ tspec.m ------------------ 
#
#@(#)tspec.m	6.13  4/7/94
 
 
B TSPEC -start6801 -end6999 -current6812
: Timing spec generator
 
# ============================================================
# Tool description (for program help)
# ============================================================

M DESCRIPTION
:    Tool tspec is the Xilinx timing spec generator.
: It analyzes a design and creates a list of all the timing constraints
: (primarily setup, clock-to-out, combinational, and transfer paths)
: that the designer should specify to ensure acceptable performance
: from the final layout.
: [.br]INPUTS:
: [.br] The design should
: have a file <design>.p, <design>.pp, <design>.pb, or <design>.pm, which are
: produced by running ppr.
: [.br]  <design>.tsi.  ("timing spec input").  This input file is optional -
: it will be read if it exists in the current directory.  It allows 
: the user to enter "pingroup" and "origin" statements.
: [.br]OUTPUTS:
: [.br]  tspec.log.  General information about the design, questionable design
: practices that may need correction or clarification, and summary of timing
: constraints identified.
: [.br]  <design>.tim.  This file serves both as a report to the user and an
: input to path analysis tools and ppr.
: It identifies the paths found, and inserts the placeholder 'x'
: wherever the designer should supply time constraints in nanoseconds.
: [.br] ========================================
: [.br]  For more information, see the files fsp.language and language,
: which describe the Xilinx user timing language.
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M MXNCELL
: Name of the design.

M HMXNCELL
: A .pm extension is assumed.
 
M PICTYPE
: Flavor of pic to use.

M HPICTYPE
: The pic netlist changes depending on the stage of design processing.
: This parameter selects the stage to use.

M P_MSG
: PIC

M HP_MSG
: generic pic cells (.p)

M P_FGMAPS_MSG
: PIC_FGMAPS

M HP_FGMAPS_MSG
: after fgmap.  FMAPs and HMAPs replaced by function generators (.pp)

M P_FGS_MSG
: PIC_FGS

M HP_FGS_MSG
: after fgmake.  Primitives replaced by function generators (.pb)

M P_MAP_MSG
: PICMAP

M HP_MAP_MSG
: after mdmake - picmap cells (.pm)

M SHOWGRAPH
: Display whole graph?

M HSHOWGRAPH
: When TRUE, exhaustive information on the netlist, as it appears in "graph"
: form, is printed to the terminal and log file.  The graph is displayed by
: node, with each outgoing arc of each node on its own line.

M MTEST
: Produce .tst file?

M HTEST
: Set this TRUE when running tests of the tspec package.  An extra log file,
: like tspec.log, is then produced, but without the material
: at the beginning (e.g., startup messages) and end (e.g., memory usage).
: That material can vary when the development system changes,
: even when the tspec functionality does not change.

# ============================================================
# "Alert" Messages (program stops).
# ============================================================

M UNKNOWN_PTYPE -e6803
> ptype d
> instance z
: Instance [instance] has unrecognized type ([ptype]).

M BAD_ARC_DIRECTION_TO_REPORT
> direction s
: Bad direction ([direction]) passed to function delete_bad_pad_arc.

M LABEL_NEQ_UNLABELED
> label d
> unlabeled d
: Count became inconsistent during labeling.  Final label = [label].
: Count of unlabeled nodes = [unlabeled].

M BAD_TOPOLOGICAL_SORT
: Topological sort failed; quit!

M BAD_PADS
: Bogus io pads; quit!

# ============================================================
# Error Messages
# ============================================================

M INPUT_WITH_TRISTATE
> name z
> net z
: Input pad [name] has its T pin driven, by net [net].
 
M NO_IO_PINS -e6804
> name z
: --- Neither I pin nor O pin was used on pad [name].

M ALREADY_VISITED
> instance z
: Instance [instance] has already been visited.  Will not run top_level topo.

M INCONSISTENT_ARRAY_INDEX -e6805
> index d
> type s
: Inconsistent array index (= [index]) for [type].

M BADLY_SORTED_ARC -e6806
> from_inst z
> from_label d
> to_inst z
> to_label d
: Bad arc direction: from [from_inst] (label [from_label]) to
: [to_inst] (label [to_label]).

M UNUSED_CLOCKPINS -w6807
: No net is attached to the clock pins of some clockable elements.  These elements
: are indicated below by the nets that they drive:

M UNUSED_CLOCKPIN
> driven_net z
: [driven_net]

# ============================================================
# Warning Messages
# ============================================================

M BOGUS_INTERNAL_REALLY_INPUT -w6808
> name z
: Pad [name]
: --- Though marked "internal", the pad is the only source for the net
: it is in.  Will treat it as INPUT. 

M IGNORING_NET_INTO_BOGUS_PAD
> net_name z
: Net [net_name] drives a badly configured pad.  Path analysis will ignore
: that connection.

M IGNORING_NET_FROM_BOGUS_PAD
> net_name z
: Net [net_name] is driven by a badly configured pad.  Path analysis will ignore
: that connection.

M UNVISITED_NODE
> instance z
: Instance [instance] was not reached from any input.

M COUNT_UNVISITED_NODES
> count d
> plural s
: Total of [count] node[plural] not reached.  Check design!

M PADPIN_NAME_COLLISION -w6810
> user_pinname z
> nonpad_arch z
: Pin name [user_pinname] matches both a pad and a pin on a [nonpad_arch]
: instance.  By default, using the pad.

# ============================================================
# Informational and Other Messages
# ============================================================
M COMPUTE_SECTION
: (computing)

M MXN_SIZE
> ninsts  d3
> nffs    d3
> npads   d3
> nbidis  d3
> npins   d5
: Design contains
: [.br]   [ninsts] instances
: [.br]   [npads] pads, including [nbidis] bidirectionals.
: [.br]   [nffs] flip-flops
: [.br]   [npins] total pins

M GRAPH_SIZE
> nodes d
> arcs d
> clocked d
: Graph has [nodes] nodes ([clocked] clocked), [arcs] arcs.

M AN_INTERNAL_PAD
> padname z
: Pad [padname] is INTERNAL.

M FOUND_LOOP
> num_arcs d
: A loop of [num_arcs] source-to-load connections:

M ONE_ARC
> from_arch z5
> gate_name z-20
> netname z
: [from_arch] [gate_name] (Net [netname]) to

M HOME_AGAIN
: first gate again.[.br]

M INS_AND_OUTS
> inputs d
> outputs d
: [inputs] input pads, [outputs] outputs.

M NODE_DATA_HEADER
: ============================================================
: [.br] label type  name

M PRINT_NODE
> label d4
> arch_name  z
> inst_name z
> drivers z
> id    d
: [.br]([label]) [arch_name] [inst_name] [drivers]     (id=[id])

M PRINT_NODE_OUTARC
> pin_and_net  z30
> to_inst_label d4
> to_inst_name  z
> pinname	z
: [pin_and_net]   ([to_inst_label])
: [to_inst_name].[pinname]

M POWER_DRIVEN_NODES
> power_type s
> count d
: Symbols reachable only from [power_type] (ignored by path analysis): [count].

M POWER_LOAD_PINS
> load_pins d
> power_type s
: Load pins driven by [power_type]: [load_pins].

M POWER_PIN
> power_type s
> pinname z
: Pin [pinname] is driven by [power_type].

M PULLUP_NODES
> count d
: [count] nodes are pullups.

M CLOCK_OUT_ARCS
> c_arcs d
: Graph has [c_arcs] arcs out from clockable nodes.

M IGNORE_ARCS
> ignored d
: [ignored] source-to-load connections are ignored since they are either
: in purely combinational loops, or because of a timespec request.

M COMBINATIONAL_LOOPS -w6811
> number d
> loop_word s
: This design has [number] purely combinational [loop_word].  Such loops should
: be avoided.  If at all possible, please modify the design to eliminate
: all unclocked feedback paths.
:[.br][.br]To permit path analysis during design implementation, all
: loops will be broken by cutting out the last source-to-load connection.
: A consequence is that the analyzer will not account for ANY paths through
: that connection.  This may cause the final performance of your design
: to be sub-optimal.
:[.br][.br]You can instruct the path analyzer to cut out connections
: of your choice, by using timespec "ignore" attributes.  For details,
: consult the PPR documentation.
: [.br]

M NOT_ALL_LOOP_DETAILS_SHOWN
> total_arcs d
> max_arcs d
: A full report on all combinational loops would include [total_arcs]
: connections.  Since this exceeds the default maximum ([max_arcs]),
: only the number of source-to-load connections and the final connection
: in each loop will be reported.[.br]
: If you want all the details reported, add a line[.br]
: loop_report_max = L[.br]
: (where L is a number greater than [total_arcs]) to your xactinit.dat file.[.br]
: If instead you don't want ANY details reported, add the line:[.br]
: suppress_loop_details = true[.br]

M LAST_ARC
> from_arch z5
> gate_name z-20
> netname z
: [from_arch] [gate_name] (Net [netname])

M SHORT_LOOP_INTRO
> num_arcs d
: [num_arcs] connections:

M LOOP_SUMMARY
> total_arcs d
: The total of all source-to-load connections involved in all
: combinational loops is [total_arcs].

M MULTI_SOURCE_LOOPS
> multi_source_loops d
: [multi_source_loops] of the loops include connections on nets with multiple
: sources.  Details on these loops will not be displayed or counted.  If you
: want information about these loops, add the following line to your
: xactinit.dat file:[.br]
: show_multi_source_loops = true

M LOOP_HEADER
: The combinatorial loops found in this design are listed below.
: [.br]


E TSPEC
#
# ------------------ dly_tab.m ------------------ 
#
#@(#)dly_tab.m	6.4  1/22/94
 
 
B DLY_TAB
: Create delay tables
 
# Tool description (for program help)
M DESCRIPTION
: Create delay tables to be used by path delay driven tools
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)
# and
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M PARTTYPE
: The parttype to be tested

M HPARTTYPE
: Specifies the die and the speed grade (for example, 4003pc84-5).

M DLY_TYPE
: Type of delay table to produce.

M HDLY_TYPE
: Specify 0 for optimistic delay table.(Default)[.br]
: Specify 1 for realistic delay table.

M SBLOCK
: The name of a clb block to use as net source.

M HSBLOCK
: E.g.: c3_7  specifies the name of a clb to be used as net source.

M SPIN
: List of clb source pin names.

M HSPIN
: The pin names are to be separated by comma.[.br]
: E.g.: X,Y    specify pin X and Y to be used as net source pins.

M LPIN1
: List of clb input pin names defining load pinset 1.

M HLPIN1
: The pin names are to be separated by comma.[.br]
: E.g.: F1,F2,F3,F4   specify pin F1,F2,F3,F4 as load pinset 1. 

M LPIN2
: List of clb input pin names defining load pinset 2.
 
M HLPIN2
: The pin names are to be separated by comma.[.br]
: E.g.: C1,C2,C3,C4   specify pin C1,C2,C3,C4 as load pinset 2. 
 
M OUT_STYLE
: In what format would you like the output presented?

M HOUT_STYLE
: The output can be presented in one or both of two forms - an (x,y) table
: of delays, in tenths of ns, displaying the arrival times at each block;
: a listing by belnode of the router's internal data at each block reached;
: or both.  The internal data are presented on the screen only - not
: in the log file.  This parameter is inactive (NO output is shown) when
: the "subtool" parameter is set to TRUE.

M TABLE
: tabular format

M HTABLE
: show (x,y) table of arrival delays.

M BELNODE
: belnode format

M HBELNODE
: show internal data.

M BOTH
: show both

M HBOTH
: both
: show both (x,y) table AND internal data. 

M WHICH_TABLES
: Print tables for which load pin sets?

M HWHICH_TABLES
: If out_style is not "belnode", a tabular output of delays is produced.
: Depending on the setting of which_tables, this will be done for the
: first load set, the second load set, or both.  Select 1 to show results
: for first set only, 2 for second set only, 3 for both.

M SUBTOOL
: Is dly_tab being called by a higher-level tool?

M HSUBTOOL
: If TRUE, dly_tab allocates two arrays for its delay results, and
: returns them to the calling tool.  If FALSE, it writes results
: to the screen instead.

# Error and Warning Messages

M E_BAD_TD
> funcname  s
> msg  s
: Unexpected TD ERROR detected by:"[funcname]"
: [.br]   "[msg]"[.br]
 
# Informational and Other Messages

M LAST_UPDATE
> date s
: [.br] Last update to dly_tab: [date]. [.br]
 
M A_Z_LINE
> message z
: [message]

M PIN_SET
> setnum d
: Delays, in tenths of ns, for load pin set [setnum]:

E DLY_TAB
#
# ------------------ lca.m ------------------ 
#
# @(#)lca.m	6.15  1/4/94


B LCA -start1576 -end1600 -current1586

: LCA Data Handler
# NOTE: If new messages are added to this file, MAX_ERROR (in lcap.h) must 
#       be changed to reflect the new number of messages.


# LCA file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown internal error number
M ILLEGAL_KEYWORD
: Illegal LCA keyword
M EARLY_EOF
: End of File reached prematurely
M POSITIVE_INT_REQD
: Positive integer required
M SIGNED_INT_REQD
: Signed integer required
M DATA_REQD
: Data required
M STRING_REQD
: String of characters required
M FLOAT_REQD
: Floating point number required
M NO_SPEED_LINE
: Speed statement not found
M PROGORDER_NOT_ON
: Programorder not ON
M VERSION_POSITION_ERROR
: Version statement must be the first non-comment statement of file
M INTNET_ERROR
: Block in Intnet statement is not previously defined, or the statement does not contain one of the following: {F, G, H, PAD, M, QY, QX}
M NPROGRAM_NET_ERROR
: Netname does not match previous ADDNET netname
M NPROG_NET_ERR2
: Netname is required in NProgram statement
M MISSING_HALF
: Second half of PIP or switch matrix pair required
M PIP_SYNTAX_ERROR
: Only the directionality is allowed after the pip pair
M NO_BASE_LINE
: Base statement missing from Editblk group
M NO_CONFIG_LINE
: Config statement missing from Editblk group
M NO_ENDBLK
: Endblk statement required
M NO_ENDPATH
: Endpath statement required
M NO_PATHNET_LINE
: Pathnet statement missing from Beginpath group
M MULT_PATHSPEC
: This net was used in multiple Beginpath statements
M ILLEGAL_TAG
: Illegal Config statement tag

M FILE_SYNTAX_ERROR -e1576 -w1577
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in LCA file:  [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]
: [.br]This is an internal error; please contact Xilinx support personnel.

# LCA memory error messages
M MEM_READER_ERR
: Error in reading LCA structure from memory
M MEM_WRITER_ERR
: Error in writing LCA structure to memory
M NETNAME_EXISTS
: Netname already exists in memory
M BLK_ERROR
: Block does not exist in memory
M UNKNOWN_BLOCK
: Unknown block type
M CONFIG_SYNTAX_ERROR
: Error in Config statement syntax
M PINNAME_EXISTS
: Pin already exists in memory
M NET_ERROR
: Net does not exist in memory
M PINNAME_ERROR
: Pin does not exist in memory
M ILLEGAL_RAMCFG
: Illegal Ramconfig statement data 
M ILLEGAL_NETNAME
: Illegal netname
M ILLEGAL_EQUATION
: Illegal Equation statement data
M CONFIG_MEM_WRITE_ERROR
: Error writing Config statement data 
M BASE_MEM_WRITE_ERROR
: Error writing Base statement data for this block 
M INTNET_BLK_ERROR
: Block specified in INTNET statement does not exist

M LCA_FILE_ERROR -e1578 -w1579
> errorname m
: [errorname] [.br]
: This statement must be present in LCA files older than version 2.  To
: eliminate this problem, open and save the file in XACT; this will
: update the file to version 2.

M NO_PROGORDER_LINE
: Programorder statement not found.

M MEM_ERROR -e1580 -w1581
> errorname m
: [errorname]
: [.br]This is an internal error; please contact Xilinx support personnel.

M MEM_WRITE_ERROR -e1582 -w1583
> errorname m
> name s
: Error in writing LCA data to memory: [.br]
: [errorname] [.br]
: Data: "[name]" 
: [.br]This is an internal error; please contact Xilinx support personnel.

M CANNOT_WRITE_TO_FILE -e1584 -w1585
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

E LCA
#
# ------------------ fgguide.m ------------------ 
#
# @(#)fgguide.m	6.5  1/25/94 


B FGGUIDE -start1601 -end1625 -current1603

: FGGUIDE Data Handler

# FGGUIDE file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M ILLEGAL_KEYWORD
: Illegal FGGUIDE keyword
M POSITIVE_INT_REQD
: Positive integer required
M STRING_REQD
: String of characters required
M NET_REQD
: Field specifying net name required
M OUTPUT_NET_REQD
: Field specifying output net name required
M PARENT_NET_REQD
: Field specifying parent net name required
M NO_DUPDATA_LINE
: Additional Dup data statement required
M NOT_DUP_LINE
: Only Dupdata or Dupend line is valid after Dup statement
M NOT_DCM_LINE
: Only Dcmdata or Dcmend line is valid after Dcm statement
M NO_DCMDATA_LINE
: Additional Dcm data statement required
M NO_DCM_END
: Dcm end statement required
M NO_DUP_END
: Dup end statement required
M SYNTAX_ERROR
: Illegal syntax
M BANG_REQD
: Bang (!) required to end statement
M TEXT_AFTER_BANG
: Text is not allowed after the Bang (!) end character
M DUP_OUT_OF_ORDER
: This statement must follow a Dup statement
M DCM_OUT_OF_ORDER
: This statement must follow a Dcm statement


M FILE_SYNTAX_ERROR
> errorname m
> linenumber d
> filename s
: Error -- [errorname][.br]
: on line [linenumber] of file [filename]

M LCA_FILE_SYNTAX_ERROR
> errorname m
> linenumber d
> filename s
: Error -- [errorname][.br]
: in System record FGG [linenumber] of file [filename]

M MEM_ERROR
> errorname m
: [errorname]


# FGGUIDE memory error messages
M MEM_READER_ERR
: Error in reading FGGUIDE structure from memory
M MEM_WRITER_ERR
: Error in writing FGGUIDE structure to memory
M DCM_ONET_EXISTS
: Dcm output netname already exists in memory
M DUP_ONET_EXISTS
: Dup output netname already exists in memory
M NO_DCMDATA_ACTIVE
: Dcmdata structure does not exist in memory
M NO_DCM_ACTIVE
: Dcm structure does not exist in memory
M NO_DUP_ACTIVE
: Dup structure does not exist in memory
M NO_DECODE_ACTIVE
: Decode structure does not exist in memory
M NO_IGNORE_ACTIVE
: Ignore structure does not exist in memory
M NO_DCM_INETS
: No Dcm input nets specified
M NO_DUP_INETS
: No Dup input nets specified
M NO_DCM_NUM
: No Dcm dcm_num specified
M NO_DUP_NUM
: No Dup dup_num specified
M INVALID_DECODE_SIDE
: Invalid Decode side number specified; must be 0-3
M PREV_DECODE_STILL_ACTIVE
: Previous Decode end statement never found; must finish previous Decode
M PREV_DUP_STILL_ACTIVE
: Previous Dup end statement never found; must finish previous Dup
M PREV_DCM_STILL_ACTIVE
: Previous Dcm end statement never found; must finish previous Dcm

M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ERROR_LIST -e1601 -w1602
> details z
: [details]

E FGGUIDE
#
# ------------------ mxtrans.m ------------------ 
#
# @(#)mxtrans.m	6.2  9/17/93
 
 
B MXTRANS -start1626 -end1635 -current1628

: MX translator data handler

# Error and Warning Messages
M BAD_OPEN_FILE -e1626
> fname s
: The file [fname] could not be opened.

M BAD_INIT_FILE -e1627
> fname s
: The mxtrans initialization file, [fname], is in the wrong format.

E MXTRANS
#
# ------------------ xnf.m ------------------ 
#
# @(#)xnf.m	6.13  1/14/94


B XNF -start1301 -end1350 -current1315
: Xnf Data Handler

#
# These are message phrases used for syntax errors
#
M SYNTAX_UNK
: Unknown error found 
M SYNTAX_PRN
: A program name is required
M SYNTAX_PAT
: A parttype is required
M SYNTAX_SYN
: A symbol name is required
M SYNTAX_STN
: A symbol type name is required
M SYNTAX_PIN
: A pin name is required
M SYNTAX_PID
: A pin direction character is required
M SYNTAX_SIN
: A signal name is required
M SYNTAX_IPN
: An input pin name is required
M SYNTAX_CPN
: A clock pin name is required
M SYNTAX_CLE
: A clock edge character is required
M SYNTAX_CLP
: A clock polarity character is required
M SYNTAX_PUW
: A pulse width value is required
M SYNTAX_BUN
: A bus name is required
M SYNTAX_PWP
: A power polarity character is required
M SYNTAX_ESD
: An external record signal direction character is required
M SYNTAX_PPN
: Package pin name is required
M SYNTAX_SET
: A setup up time value is required
M SYNTAX_HLD
: A hold time value is required
M SYNTAX_MLR
: The LCANET record is required
M SYNTAX_BRT
: Unrecognized record type found
M SYNTAX_V4R
: Lcanet version 4 is required (Run xnfupd to convert your design)
M SYNTAX_ILV
: Illegal LOC value found
M SYNTAX_LSV
: No value is specified for LOC parameter
M SYNTAX_INT
: An integer is required
M SYNTAX_CHR
: Character is required
M SYNTAX_STR
: A character string is required
M SYNTAX_FLT
: A floating point number is required
M SYNTAX_DLY
: Delay numbers are required
M SYNTAX_BDN
: Illegal delay number specification found
M SYNTAX_COM
: A comma is required
M SYNTAX_EOL
: End of line is required
M SYNTAX_EOF
: End of File is required
M SYNTAX_ERROR 
> errorname m
> linenumber d
> filename s
: [errorname]
: on line [linenumber] of file [filename]:

# 
# These are message phrases used for semantic errors
#
M BADPARTTYPE
> parttype s
: Unrecognized parttype '[parttype]'
M MULTIPLESYM
> symname s
: Multiple symbols exist with the name '[symname]'
M MULTIPLEPIN
> symname s
> pinname s
: The symbol '[symname]' contains multiple pins with the name '[pinname]'
M MULTIPLEBUS
> busname s
: Multiple busses exist with the name '[busname]'
M MULTIPLEEXT
> pinnum s
> signame s
: Multiple Ext-records exist with the same signal '[signame]' or package
: pin name '[pinnum]'
M MULTIPLEEXT2
> signame s
: Multiple Ext-records exist with the same signal '[signame]'
M MULTIPLEHIERG
> hier_id d
> sym_name s
: Multiple Hierg-records exist for hier_id '[hier_id]', sym_name '[sym_name]'
M INSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal between SYM and END records
M RECORD_OUT_OF_PLACE
> record s
: The '[record]' record is illegal outside of SYM and END records
M NOSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal outside of SYM and END records
M BADSETUPEDGE
> inname s
> clkname s
> edge s
: The 'SETUP, [inname], [clkname]' record has an illegal clock edge value '[edge]'
M MULTIPLEPOLARITY
> signame s
: The signal '[signame]' is both GND and VCC
M BADPOWERPOLARITY
> signame s
> polarity s
: The PWR record for signal '[signame]' has an illegal polarity value '[polarity]'
M BADPULSEPOLARITY
> symname s
> pinname s
> polarity s
: The 'PULSE,[pinname]' record in symbol [symname] has an illegal polarity
: value '[polarity]'
M BADEXTDIR
> signame s
> dir s
: The 'EXT, [signame]' record has an illegal direction value '[dir]'
M BADPINDIR
> symname s
> pinname s
> dir s
: The pin [pinname] in symbol '[symname]' has an illegal direction value '[dir]'
M NO_PARAM_VALUE
> rectype s
> recname s
> namevalue s
: The [rectype] '[recname]' contains a parameter '[namevalue]' with no value
: specified
M MULTIPLEPARAM
> rectype s
> recname s
> name s
: The [rectype] '[recname]' contains multiple '[name]' parameters 
M INVALID_SYMBOL_PIN
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' is not a legal pin for this type of
: symbol
M INVALID_PIN_INV
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' cannot be legally inverted
M INVALID_EXT_PARAM
> ext  s
> param s
: The PAD '[ext]' has an illegal parameter with the name '[param]'
M CONFLICT_EXT_PARAM
> ext  s
> param s
> conflict_param s
: PAD '[ext]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SIG_PARAM
> sig  s
> param s
: The signal '[sig]' has an illegal parameter with the name '[param]'
M CONFLICT_SYM_PARAM
> symbol  s
> param s
> conflict_param s
: Symbol '[symbol]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SYM_PARAM
> symbol  s
> param s
: The symbol '[symbol]' has an illegal parameter with the name '[param]'
M INVALID_PIN_PARAM
> pinname s
> symbol  s
> param s
: The '[pinname]' pin on symbol '[symbol]' has an illegal parameter with
: the name '[param]'
M MULTPARTTYPES
> part1 s
> part2 s
: The design network contains multiple parttypes - [part1] and [part2]
M UNKNOWNPIN
> rectype s
> pinname s
: The [rectype] record refers to an undefined pin '[pinname]'
M ILLEGAL_BOOLEAN
> sym s
> numpins d
> numarchpins d
: The symbol '[sym]' has [numpins] input pins specified; only
: [numarchpins] input pins are allowed on this type Boolean gate. 
M MODEL
> rectype s
: The [rectype] record is illegal record outside of MODEL and ENDMOD records
M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write to file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.
M MISSINGPARAM
> symname s
> symtype s
> paramname s
: The [symtype] symbol '[symname]' is missing the required [paramname] parameter

M INVALID_SIG_NAMES
> siglist s
: The following signals have illegal names:[.br]
: [siglist]
M INVALID_SYM_NAMES
> symlist s
: The following symbols have illegal names:[.br]
: [symlist]
M TOOMANY
> errlimit d
: The number of errors exceeds [errlimit], bailing out prematurely
M WOOPS
> namevalue s
> rectype s
: [namevalue] specified without an active [rectype]
M SEMANTIC_ERROR
> error z
: [error][.br]
M SEMANTIC_ERROR_LOCATION
> error z
> linenum d
> filename s
: [error][.br]
: near line [linenum] of file [filename].

M VALIDITY_NO_ARCH
: The Design Validity Check cannot be implemented because no archfile or
: parttype can be found.

M ERROR_LIST -e1303 -w1304
> filename s
> details z
: The following problem(s) were found in the [filename] file; 
: the file could not be processed successfully.[.br]
: [.br][details]

M VALIDITY_ERRORS -e1305 -w1306
> details z
: [details]

#
# These errors are used for loading xnf archtype data files
#
M CHECKS_PARTTYPE -e1307 -w1308
> designname s
: The parttype for the [designname] design is missing so we cannot perform
: the checks related to legal symbols, pins, parameters, etc.

M CHECKS_UNKNOWN_DATAFILE -e1309 -w1310
> designname s
> parttype s
: The [designname] design is for a parttype called "[parttype]".  We do not
: know which archtype data file we should read for that parttype.  We have
: to read an archtype data file so that we can perform the checks 
: related to legal symbols, pins, parameters, etc.  We are unable, therefore,
: to perform these types of checks.

M CHECKS_NO_DATAFILE -e1311 -w1312
> designname s
> datafilename s
: The [datafilename] data file (which we need to read so that we can perform the
: checks related to legal symbols, pins, parameters, etc. on the [designname]
: design) does not exist in the $XACT/data directory.  We therefore cannot
: perform these types of checks.

M CHECKS_DATAFILE_ERROR -e1313 -w1314
> designname s
> datafilename s
: We encountered problems while reading the [datafilename] data file.  We
: have to read this file so that we can perform the checks related to legal 
: symbols, pins, parameters, etc. in the [designname] design.  We therefore
: cannot perform these types of checks.

E XNF
#
# ------------------ pic.m ------------------ 
#
# @(#)pic.m	6.3  4/7/94


B PIC -start1501 -end1550 -current1523
: Physical Implementation and Control File

# These message texts are used in the FILE_SYNTAX_ERROR message
M OPTIONAL
: Optional
M REQUIRED
: Required
M KEYWORD_REQUIRED
: Keyword Required
M COMMAND_REQUIRED
: Command Required
M SEMICOLON_REQUIRED
: Semicolon Required
M MODELNAME_REQUIRED
: Tif Model Name Required
M MODELVERSION_REQUIRED
: Tif Model Version Required
M INSTNAME_REQUIRED
: Mxn Instance Name Required
M NETNUMBER_REQUIRED
: Mxn Net Number Required
M BLOCKNUMBER_REQUIRED
: Block Number Required
M BLOCKNAME_REQUIRED
: Block Name Required
M BELINDEX_REQUIRED
: Bel Index Required
M BELDEFNAME_REQUIRED
: Beldef Name Required
M ARCINDEX_REQUIRED
: Belarc Index Required
M BELNODENAME_REQUIRED
: Belnode Name Required
M PIPINDEX_REQUIRED
: Pip Index Required
M SEGNAME_REQUIRED
: Segment Name Required

M FILE_SYNTAX_ERROR -e1501 -w1502
> errorname z
> filename  s
> linenum   d
> fileline  s
> lineptr   z
: Error in PIC file: [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_MXN_NOT_DEFINED -e1503 -w1504
> cellname z
: The PIC cell "[cellname]" cannot be written to because the related
: MXN cell has not been defined.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_TIF_NOT_DEFINED -e1505 -w1506
> cellname z
: The PIC cell "[cellname]" cannot be written to because the related
: Tif model has not been defined.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_MXN_ALREADY_DEFINED -e1507 -w1508
> cellname z
: An attempt was made to define the MXN cell associated with the PIC 
: cell "[cellname]", but the PIC cell already has an associated MXN cell.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_TIF_ALREADY_DEFINED -e1509 -w1510
> cellname z
: An attempt was made to define the Tif model associated with the PIC 
: cell "[cellname]", but PIC cell already has an associated Tif model.
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_OBJECT_NOT_FOUND -e1511 -w1512
> cellname   z
> objecttype s
> objectname s
> objectid   s
: An attempt was made to reference a [objecttype] named "[objectname]"
: [objectid] which is not defined for the PIC cell "[cellname]".
: [.br]This is an internal error; please contact Xilinx support personnel.

M MWRITER_OBJECT_USED -e1513 -w1514
> cellname  z
> conttype  s
> contname  s
> newfiller s
> oldfiller s
: An attempt was made to add [newfiller] to the [conttype] named "[contname]"
: in the PIC cell "[cellname]".  This [conttype] already contains 
: "[oldfiller]".
: [.br]This is an internal error; please contact Xilinx support personnel.

M FWRITER_MXN_NOT_DEFINED -e1515 -w1516
> filename z
: The PIC part of the PIC file "[filename]" cannot be written to 
: because the related MXN cell has not been defined.
: [.br]This is an internal error; please contact Xilinx support personnel.

M FWRITER_MXN_ALREADY_DEFINED -e1517 -w1518
> filename z
: An attempt was made to define the MXN cell associated with the PIC 
: file "[filename]", but the MXN part of the file has already been written.
: [.br]This is an internal error; please contact Xilinx support personnel.

M FWRITER_TIF_TOO_LATE -e1519 -w1520
> filename z
: An attempt was made to define the TIF model in the PIC file "[filename]",
: but the portion of the PIC file that contains the TIF MODEL has already been 
: written.
: [.br]This is an internal error; please contact Xilinx support personnel.

M CANNOT_WRITE_TO_FILE -e1521 -w1522
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

E PIC
#
# ------------------ carry.m ------------------ 
#
# @(#)carry.m	6.4 9/17/93


B CARRY -start1451 -end1475 -current1453

: CARRY Data Reader

# Carry4k.xct file reader error messages
M CANT_OPEN_FILE
: Cannot open carry4k.xct file.[.br]

M EMPTY_FILE
: No data lines found in carry4k.xct file.[.br]

M NO_VERSION
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: Required Version line not found at beginning of carry4k.xct file.[.br]
: Instead found line: 
: [.br]   [line][.br]

M VERS_NOT_SUPPORTED
> version s
: The syntax version [version] is not supported by the Carry Reader.[.br]

M END_MISSING
> mode s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: The End statement was not found for carrymode '[mode]'[.br]

M NO_DRC_TAG
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file.[.br]
: Required drc_tag statement not found; instead found line:
: [.br]   [line][.br]

M SYNTAX_ERROR
> line s
> linenum d
: Syntax Error found on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]

M MULT_LINE
> line s
> linenum d
> keyword s
: Error on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]
: [keyword] statement already read in for this carrymode.[.br]

M CARRY_ERRORS -e1451 -w1452
> details z
: [details]

M DRC_TAG_ERROR
> line s
> linenum d
: Error on line [linenum] of carry4k.xct file:
: [.br]   [line][.br]
: This drc_flags statement has more responses than tag:settings (as defined
: in drc_tags statement).[.br]

M DRC_TABLE_OVERFLOW
: Internal error:  DRC table overflow; increase DRC_INDEX_SIZE constant.[.br]

E CARRY
#
# ------------------ tif.m ------------------ 
#
# @(#)tif.m	6.4 12/8/93
##############################################################################
# Message file for Technology Interface
##############################################################################
 
 
B TIF -start1401 -end1450 -current1410
: Technology Interface
 
M NO_SUCH_DEVICE -e1401
> basename s
> extension s
: Cannot find the technology description file '[basename].[extension]'.
M TD_FILE_TROUBLE
> filename s
: Encountered a problem opening file '[filename]'.
M SYNTAX_ERROR
> file s
> line d
> type s
> text s
: [file]([line]): [type] near '[text]'.
M SEMANTIC_ERROR -e1402
> location s
> text s
: [location]: [text]
M EXTRA_LOC -w1403
> location s
: Extra Location statement '[location]' ignored.
M BUILD_ERROR
> text s
: Model building failed: [text]
M CHECK_FAILED
> text s
: Consistency check failed: [text].
M TEXT
> text s
: [text]
M NO_SUCH_FILE -e1404 -w1405
> filename s
: Unable to find file '[filename]',[.br]
: no package bonding info in the TIF model.
M NO_PKG_INFO -e1406 -w1407
> modelname s
> filename s
: No info for package [modelname] in file '[filename]'.
: [.br]Package and bonding info are missing from technology description.
M SPEED_GRADE_ERROR -e1408
> modelname s
> spdgrade s 
: '[spdgrade]' is not a valid speed grade for part '[modelname]' [.br]
: Please check the data book for the correct speed grades.
M SPEED_FILE_TROUBLE -e1409
: Encountered a problem opening speed file .

E TIF
#
# ------------------ mxn.m ------------------ 
#
# @(#)mxn.m	6.2  9/17/93


B MXN -start1476 -end1500 -current1484

: MXN Data Handler

# MXN file reader error messages
# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown Internal Error Number
M ILLEGAL_KEYWORD
: Illegal MXN Keyword
M SEMICOLON_REQD
: Semicolon Required
M POSITIVE_INT_REQD
: Positive Integer Required
M INT_REQD
: Integer Required
M STRING_REQD
: String Of Characters Required
M QSTRING_REQD
: Quoted string of Characters Required
M ATTRIB_REQD
: Attribute String Of Characters Required
M ILLEGAL_MXN_NAME
: Illegal MXN name
M EQUAL_REQD
: Equal sign '=' required after this attribute
M ILLEGAL_GLOBAL
: Illegal global signal name must be VCC, GND, or RESET

M FILE_SYNTAX_ERROR -e1476 -w1477
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in MXN file: [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]

# MXN memory error messages
M MEM_READER_ERR
: Error in reading MXN structure from memory
M MEM_WRITER_ERR
: Error in writing MXN structure to memory

M MEM_ERROR -e1478 -w1479
> errorname m
: [errorname]

# MXN memory writer error message that deal with potential error in MXN file
M PRIM_DNE
: primitive cell library does not exist.
M NO_PRIM_ARCH
: primitive archetype is not in the primitive cell library.
M NETNAME_EXISTS
: net name has already been used, must use a unique net name.
M INST_EXISTS
: Instance has been previously defined.
M EXTPIN_EXISTS
: external pin reference has been previously defined.
M ARCH_EXISTS
: Archetype has been previously defined.
M TOOMANY_APINS
: Archetype has too many pins for its Cell library definition.
M TOOMANY_IPINS
: Instance has too many pins for its Archetype definition.

M MEM_FILE_CONFLICT -e1480 -w1481
> errorname m
> name s
: Error in writing MXN structure to memory: [.br]
: The "[name]" [errorname]

M CANNOT_WRITE_TO_FILE -e1482 -w1483
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

E MXN
#
# ------------------ prim.m ------------------ 
#
# @(#)prim.m	6.2  9/17/93


B PRIM -start1376 -end1400 -current1382

: Prim Data Handler

# These message texts are used in the FILE_SYNTAX_ERROR message
M UNKNOWN_ERRNUM
: Unknown Internal Error Number
M PUNC_REQD
: Punctuation Required
M INT_REQD
: Integer Required
M STRING_REQD
: String Of Characters Required
M BAD_COMBINATORIAL
: Combinatorial field must be either "Y" or "N".
M QSTRING_REQD
: Quoted String Of Characters Required
M BAD_PIN_DIRECTION
: The pin direction must be "I", "O", or "B".
M BAD_GATETYPE
: The gate type specified is illegal.

M FILE_SYNTAX_ERROR -e1376 -w1377
> errorname m
> filename  s
> linenum   d
> fileline  s
> lineptr   s
: Error in Prim file: [errorname][.br]
: on line [linenum] of file "[filename]"[.br]
: "[fileline]"[.br]
: -[lineptr]

M WRITE2FILE -e1378 -w1379
: Cannot write a PRIM cell to a file.  PRIM cells can only be read from a file 
: or memory.

M PRIMLIB_OPEN_FAILED -e1380 -w1381
: The `primlib.prm` data file could not be opened.  Check and make sure it
: has been installed in the proper directory.
E Cellib
#
# ------------------ noth.m ------------------ 
#
# @(#)noth.m	6.2  9/17/93


B NOTH -start1351 -end1375 -current1355
: Netlist Object Transformation History

M NAME_REQUIRED -e1351 -w1352
> filename s
> linenum  d
> line     s
> mark     s
: A Noth symbol name was expected, but something else was encountered[.br]
: on line [linenum] of the Noth file "[filename]"[.br]
: "[line]"[.br]
: "[mark]

M UNEXPECTED_EOF -e1353 -w1354
> filename s
> linenum  d
: Unexpected end of file was encountered[.br]
: on line [linenum] of the Noth file "[filename]"

E NOTH
#
# ------------------ mxcst.m ------------------ 
#
# @(#)mxcst.m	6.8  3/24/94
 
 
B MXCST -start1551 -end1575 -current1555
: constraint data handler
 
# Tool description (for program help)
M SYNTAX_ERROR -e1551
>token s
>lineno d
>filename s
>appendage m
: error on "[token]" at line [lineno] in file [filename]
: : [appendage]

M ADDITIONAL_MSG
>msg m
:   ----[msg]

M GIVE_UP
: Giving up - too many errors.
M BAD_LOC
: illegal location name
M BAD_MGC_NAME
: illegal magic box name
M NO_SEMICOLON
: possibly a missing ';'
M NO_COLON
: illegal name or possibly a missing ':'
M BAD_BEL_NAME
: illegal sub-location name  
M BEL_OPTIONS
: bel name must be one of : F G H ARITH FFX FFY 
M NO_WILD_CARD
: Improper use of wild card
M UNEXPECTED_SYM
: Unexpected symbol
M BAD_BOX_PAIR
: illegally specified magic box pair
M BAD_BLK_LIST
: illegally specified logic block list
M BAD_CONS
: unknown constraint type
M BAD_FILE
: illegal file name
M NO_I_OR_N
: expected "INSTANCE", "NET" or "BLOCK"
M NO_N
: expected "NET"
M BAD_FLAG_TYPE
: expected "CRITICAL" "UNCRITICAL" or "SKEW_CRITICAL"
M NO_NET_NAME
: expected net name
M NO_INS_NAME
: expected instance name
M NO_PIP
: expected pip name
M BAD_SIZE
: invalid instance size specification
M BAD_DIR
: invalid direction - expected "VERTICAL" or "HORIZONTAL"
M BAD_WEIGHT
: expected net weight : between 0 and 99
M UNEXP_END -e1552
: Unexpected end of file
M MISMATCH_LOC
: location pair must consist matching location types
M BAD_RANGE
: illegal location range specification
M NO_SUFFIX_ON_3K_BLOCK
: illegal suffix for clb block location
M SHOW_FILE_PATH
> file z
> ext s
: Reading constraints from file [file].[ext] [.br] [.br]
M EMPTY_WARNING -w1553
> file s
: file [file] does not contain any constraints
M MXCST_ERROR_LIST -e1554
> list z
: The following errors were detected in the constraints file:[.br][list]

E MXCST
#
# ------------------ mxtool.m ------------------ 
#
#@(#)mxtool.m	6.8  1/13/94


B MXTOOL -start1726 -end1800 -current1744
: Tool Interface

# These message texts are used in other messages
M TEXT_PARAMFILE
: parameter file
M TEXT_CMDLINE
: command line
M TEXT_ILLBOOLVAL
: Illegal boolean value must be {TRUE,FALSE}: 
M TEXT_ILLINTVAL
: Illegal integer value: 
M TEXT_ILLOPTVAL
: Illegal option name must be 
M TEXT_ILLFLTVAL
: Illegal floating point value: 
M TEXT_UNKPARAM
: Unknown parameter name: 
M TEXT_UNSETPARAM
: Parameter was not assigned a value: 
M TEXT_BADVALUE
: Parameter was assigned an illegal value: 
M TEXT_BADRANGE
: Parameter value is outside valid range: 
M TEXT_PARAMHEAP
: Param
M TEXT_RESULTHEAP
: Result
M TEXT_INTERNALHEAP
: Intern
M TEXT_OTHERHEAP
: Other
M TEXT_BLANK
:

# There messages are used to produce help text for the root tool
M LOGFILE
: The program log file name
M HLOGFILE
: You can use this parameter to specify an alternate name for the program
: log file.  The default value of the log file name is the program name 
: with a .log extension
M PARAMFILE
: The parameter file name
M HPARAMFILE
: You can use this parameter to specify a file name which contains
: program parameters.  Each program parameter should appear on a line
: by itself with its value separated by an equals sign,
: E.g., "logfile=foobar.log".  If a program parameter is specified
: on the command line as well as in the parameter file, the value from
: the command line will be used.  If you do not specify a parameter file, 
: all of the programs parameters are taken from the command line.
M HELPALL
: Show all help information
M HHELPALL
: You can type "-helpall" to this tool to get help for ALL its parameters.
: The default is not to show help for all parameters.  
M HELP_NOVICE
> programname s
: For help on how to use this program, type "[programname] -help"
M HELP_TITLE
> programname s
: [.br]HELP FOR [programname][.br]
M HELP_PARAMS
: [.br]PARAMETERS:[.br]
M HELP_PARAMNAME
> param_internal_name s
> param_external_name s
: [param_internal_name][param_external_name]
M HELP_PARAMHELP
> param_help_text s
: [param_help_text]
M HELP_BITS
> leftmargin s
: [leftmargin]This parameter may be assigned one or more of these bit values:
: [.br]
M HELP_VALUES
> leftmargin s
: [leftmargin]This parameter may be assigned one of these values:
: [.br]
M HELP_STRVALUE
> leftmargin s
: [leftmargin]This parameter takes a character string value.
M HELP_FLTVALUE
> leftmargin s
> lo g.6
> hi g.6
: [leftmargin]Takes a real value between [lo] and [hi], inclusive.
M HELP_BOOLVALUE
> leftmargin s
: [leftmargin]This parameter takes a boolean value {TRUE,FALSE}
M HELP_INTVALUE
> leftmargin s
> lo d
> hi d
: [leftmargin]Takes an integer value between [lo] and [hi], inclusive.
M HELP_PINTVALUE
> leftmargin s
: [leftmargin]Takes a positive integer value.
M HELP_NNINTVALUE
> leftmargin s
: [leftmargin]Takes a non-negative integer value.
M HELP_DEFVALUE
> leftmargin s
> default    z
: [leftmargin]The default value is [default].
M HELP_DEFNONE
> leftmargin s
: [leftmargin]You must specify a value; there is no default.

# ---------------------------------------------------------------------------
# These messages are written to the plog at program startup
M LOG_BANNER
> prog_name    s
> prog_version s
> prod_name    m
> year         s
: [prog_name] [[[prog_version]]  --  [prod_name][.br]
: Copyright (c) [year] Xilinx Inc.  All Rights Reserved.

M LOG_CONFIDENTIAL
: XILINX CONFIDENTIAL

M LOG_XACT
: Xilinx Automatic CAE Tools

M PROGRAM_ENV
: Program Envelope Parameters

M PROGRAM_ENVENTRY
> name  s-20
> value s
: [name] = [value]

# ---------------------------------------------------------------------------
# These messages are written to the plog at tool startup
M TOOL_NEW_SECTION
> toolname s
: [toolname]
M TOOL_PARAMETERS
: Parameters
M TOOL_USED_EXPERT_PARAMS
: Additional Specified or Non-Default Parameters 
M TOOL_PARAMVALUE
> paramname  s
> paramvalue s
: [paramname][paramvalue]
M TOOL_TRUE
: TRUE
M TOOL_FALSE
: FALSE
M TOOL_PARAMBAR
: -----------------------

# ---------------------------------------------------------------------------
# These messages are used by the debug routine mxtool_dump_tool_table
M TOOLDEF_TITLE
: Tool Definition Table
M TOOLDEF_HEADER
# ALIGN COLUMN HEADERS WITH OPEN BRACKET
# V         V            V    V        V
# [toolname][toolversion][off][partype][parametername]
: Toolname  Version      Off  Type     Parameter[.br]
: --------  -----------  ---  -------  ---------
M TOOLDEF_ENTRY
> toolname      s-10.10
> toolversion   s-13.10
> off           s3
> partype       s-9.9
> parametername s
# DONT MESS WITH THIS MESSAGE TEXT!
: [toolname][toolversion][off]  [partype][parametername]
M TOOLINST_TITLE
: Tool Instances Remaining
M TOOLINST_HEADER
# ALIGN HEADERS WITH OPEN BRACKETS
# V     V         V
# [in]  [toolname][toolcreator]
: ---------------------------[.br]
: Inst  Toolname  Toolcreator[.br]
: ----  --------  -----------
M TOOLINST_ENTRY
> in          d4
> toolname    s-10
> toolcreator s
: [in]  [toolname][toolcreator]
M TOOLINST_FOOTER
: ---------------------------

# ---------------------------------------------------------------------------
# These messages are used to create the memory usage table for debug purposes
M MEMUSAGE_TITLE1
> name s
: Memory Usage For Tool [name]
M MEMUSAGE_TITLE2
> name s
: Memory Usage For Program [name]
M MEMUSAGE_HEADER
# [heap]      [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
: --------------------------------------------------------------------------[.br]
: Heap         Total   Total  Static   Alloc   Guard  Unused    Free   Alloc[.br]
: Name       Nsegmts  Nbytes  Overhd  Overhd  Overhd  Nbytes  Nbytes  Nbytes[.br]
: ---------- ------- ------- ------- ------- ------- ------- ------- -------
M MEMUSAGE_ENTRY
> heap s-10.10
> nseg d4
> size d6
> sohd d6
> aohd d6
> gohd d6
> unnb d6
> frnb d6
> alnb d6
: [heap]    [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
M MEMUSAGE_FOOTER
: --------------------------------------------------------------------------
M MEMUSAGE_MAX
> pgmname s
> nkbytes f.3
: [pgmname] required [[[nkbytes]] Kbytes of dynamic/allocated memory

# ---------------------------------------------------------------------------
# These are WARNING messages of various sorts
M PARAM_OBSOLETE_NEXT_RELEASE -w1726
: The "param=" syntax you used on the command line will become obsolete
: next release.  You should replace it with "paramfile="

M PARAM_IGNORED -w1727
: The "param=" syntax on the command line is being ignored since you
: have also specified the parameter file name using the "paramfile=" syntax

M PLOG_OBSOLETE_NEXT_RELEASE -w1728
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" syntax from the [paramsource] will become obsolete
: next release.  You should replace it with "logfile="

M PLOG_IGNORED -w1729
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" specification from the [paramsource] is being ignored since
: you have also specified the log file name using the "logfile=" syntax

# ---------------------------------------------------------------------------
# These are ERROR messages of various sorts
M PARAM_DECL_OFFSET -e1730
> toolname  s
> paramname s
> offset    d
> paramsize d
: Tool parameter declaration offset is illegal[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, but the parameter structure size[.br]
: is only [paramsize] bytes.  Something must be very, very wrong.

M PARAM_DECL_OVERLAP -e1731
> toolname  s
> paramname s
> offset    d
> index     d
: Tool parameter declaration overlaps another[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, which overlaps another parameter[.br]
: at an offset of [index] bytes.  Check your calls to tool_decl_* in[.br]
: the husk module of [toolname].  You have probably have the same parameter[.br]
: name in more than one of the tool_decl_* routine.

M PARAM_ERROR -e1732
> paramsource s # the TEXT_CMDLINE or TEXT_PARAMFILE message text
> theErrors   s
: The [paramsource] contains parameter assignment errors:[theErrors]

M PARAM_ERROR_MAINTOOL -e1733
> theTool   s
> theErrors s
: The [theTool] program detected parameter value errors:[theErrors]

M PARAM_ERROR_SUBTOOL -e1734
> currenttool s
> parenttool  s
> theErrors   s
: The [currenttool] tool, invoked from [parenttool],
: detected parameter value errors:[theErrors]

M PARAM_TOOMANY -e1735
> nspecified d
> ndefined   d
: The command line contains [nspecified] positional parameters,[.br]
: but the program only needs [ndefined] parameters.

M BAD_DASH_PARAM -e1736
> param z
: The command line parameter, '[param]', is a non-boolean '-' parameter.  Only
: boolean parameter can be specified using the '-' feature, where 
: '-<parameter>' is the equivalent of TRUE and '-NO<parameter>' is the 
: equivalent of FALSE.

M INSTANCE_MISMATCH -e1737
> instancenumber d
> instancename   s
> tooldefname    s
: Tool instance - tool definition mismatch[.br]
: Tool instance #[instancenumber] is not an instance of "[tooldefname]"[.br]
: but rather an instance of "[instancename]"

M INSTANCE_ILLEGAL -e1738
> instancenumber d
: Illegal tool instance number[.br]
: Tool instance #[instancenumber] does not refer to a valid tool

M PFILE_OPEN_FAILED -e1739
> filename s
: The parameter file "[filename]" could not be opened for input

M MISSING_VALUE -e1740
> paramname s
: The command line parameter named "[paramname]"[.br]
: must be followed by an equals sign and a value

M ILLEGAL_PARAMNAME -e1741
> paramname s
: An illegal program parameter name "[paramname]"[.br]
: is used on the command line

M PLOG_OPEN_FAILED -e1742
> filename s
: The program log file "[filename]"[.br]
: could not be opened for output

M ILLEGAL_OPTIONNAME -e1743
> optionname s
: An illegal option parameter name "[optionname]"[.br]
: is used on the command line

E MXTOOL
#
# ------------------ dm.m ------------------ 
#
# @(#)dm.m	6.5  2/2/94


B DM -start1161 -end1200 -current1187
: Data Manager 

M CANNOT_WRITE_TO_FILE -e1161 -w1162
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ADDHISTORY_FAILED -e1163 -w1164
> cellname z
> celltype s
: A history description could not be appended to the [celltype] cell
: "[cellname]" because it is a READONLY cell

M CLRHISTORY_FAILED -e1165 -w1166
> cellname z
> celltype s
: The history descriptions of the [celltype] cell "[cellname]" could not be
: cleared because it is a READONLY cell

M CLEAR_FAILED_RDONLY -e1167 -w1168
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be cleared because it is a
: READONLY cell

#M CLEAR_FAILED -e -w
#> cellname z
#> celltype s
#: The [celltype] cell "[cellname]" could not be cleared because it is
#: locked in memory

M DELETE_FAILED -e1169 -w1170
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be deleted because it is
: locked in memory

M FILE_ACCESS -e1171 -w1172
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: exists, but could not be opened

M FILE_MISSING -e1173 -w1174
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be found.

M FILE_OPEN_FAILED -e1175 -w1176
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be opened

M HEADER_CELLTYPENAME -e1177 -w1178
> cellname z
> filename z
> celltype s
: The type of the cell "[cellname]" associated with the file "[filename]"
: does not correspond to the expected "[celltype]" type.

M HEADER_ERROR -e1179 -w1180
> cellname z
> filename z
> celltype s
: The file "[filename]" for the [celltype] cell "[cellname]" contains an
: illegal header

M NAME_FAILED -e1181 -w1182
> cellname z
> newname  s
> celltype s
: The [celltype] cell "[cellname]" could not be renamed to "[newname]"
: because a [celltype] cell named "[newname]" already exists

M TYPE_FAILED -e1183 -w1184
> typename s
> cellname z
: The type of cell "[cellname]" could not be changed to "[typename]"
: because a cell of that name/type already exists

M NEWCELL_FAILED -e1185 -w1186
> cellname s
> celltype s
: The [celltype] cell "[cellname]" could not be created because a cell of
: that type and name already exists

#
# Data Manager Messages
#
M SAVECELL_SECTION
: Data Manager Auto Save

M SAVECELL
> cellname z
> typename s
: Saving [typename] cell "[cellname]"

M LOCKCOUNT_SECTION
: Data Manager Cell Lock Counts

M LOCKCOUNT
> cellname z-10
> typename s-10
> lockcount d2
: [cellname] [typename] [lockcount]

E DM




#
# ------------------ mxpart.m ------------------ 
#
#@(#)mxpart.m	6.2 9/3/93

B MXPART -start1131 -end1160 -current1148
: File reader for partlist.xct file and <package>.pkg files

M CANT_OPEN_FILE -e1131 -w1132
> filename s
: Cannot open file '[filename]' for reading.

M NO_PKG -e1133 -w1134
> part s
> filename s
: The part '[part]' could not be found in the file '[filename]'.

M BAD_ATTRIB_VALUE -e1135 -w1136
> partname s
> filename s
: The attribute list (name=value entries) for the part '[partname]' in the
: file '[filename]' has the wrong format.

M ILLEGAL_PKG_KEYWORD -e1137 -w1138
> value s
: Illegal keyword '[value]' exists in the .pkg file.
 
M DUP_PAD_DEF_IN_PKG -e1139
> pad s
: Duplicate definition of PAD '[pad]'.

M DUP_PIN_DEF_IN_PKG -e1140
> pin s
: Duplicate definition of PIN '[pin]'.

M PAD_NUM_OUT_OF_RANGE -e1141
> pad s
: Pad number '[pad]' is out of range.

M BAD_PAD_NUM -e1142
> pad s
: Bad pad number '[pad]'. Should be in the form: PAD<number>.

M WRONG_ATTR_VALUE -e1143
> value s
> chk_value s
: Attribute value '[value]' does not match check value '[chk_value]'.

M ILLEGAL_FAMILY -e1144
> family d
: Not a legal family '[family]'.

M ILLEGAL_FAMILY_ATTR -e1145
> attrib s
> family d 
: Not a legal attribute '[attrib]' for this family '[family]'.

M BAD_ROWCOL -e1146
: Not and integer value for clb row|cols number.

M CLK_BUF -e1147
> pad s
> padn d
: Clock Buffer using '[pad]' should use 'PAD[padn]'.

E MXPART
#
# ------------------ speed.m ------------------ 
#
#@(#)speed.m	6.4  9/3/93

B SPEED -start 1101 -end1130 -current14
: File reader for speeds.xct file 

M CANT_OPEN_FILE -e0 -w1
> filename s
: Cannot open file '[filename]' for reading.

M FILE_CORRUPTED -e2 -w3
> filename s
: The speeds file '[filename]' has been corrupted and cannot be read.

M CANT_READ_FILE -e4 -w5
> filename s
: The unencrypted speeds file '[filename]' cannot be read.

M BAD_PARTLIST_FILE -e6 -w7
: The partlist.xct file does not contain the correct information.

M UNKNOWN_SPEED_AND_PART -e8 -w9
> speed s
> part s
: The speed '[speed]' is unavailable for part '[part]'.

M BAD_VERSION -e10 -w11
> filename s
> badversion s
> version s
: The '[filename]' file has a bad version, '[badversion]'.
: The version of file must be '[version]'.

M SYNTAX_ERROR -e12 -w13
> filename s
: There is a syntax error in the '[filename]' speeds file.

E SPEED
