# synthx.ml created 1994/05/08 08:37:11
# 
# DO NOT EDIT THIS FILE!  It is derived from other files.
#
# ------------------ alert.m ------------------ 
#
#@(#)alert.m	6.1  12/2/92


B ALERT
: Error condition alert system

#
# These messages are used as alert pre/postfixes
#
M CANNOT_CONTINUE
: Execution cannot continue until this error is fixed
M TERMINATE
> theProgram s
> theStatus s
: [theProgram] was terminated with a [theStatus] status

E ALERT
#
# ------------------ feature.m ------------------ 
#
# @(#)feature.m	6.3 9/3/93


B FEATURE -start1051 -end1100 -current1082
: Feature License Manager

#
# Nasty Low-Level Error Messages
#
M UNKNOWN_ERROR -e1051
> feature s
: License checkout for feature "[feature]" failed[.br]
: because of some, unknown error condition.  
: Please contact your system administrator for help.
M OS_ERROR -e1052
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level or operating system error ([errtext]).
: Please contact your system administrator for help.
M BAD_SERVER_DATA_ERROR -e1053
> feature s
: License checkout for feature "[feature]" failed[.br]
: because invalid data was returned from the license server .
: Please contact your system administrator for help.
M READ_SERVER_ERROR -e1054
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot read from the servers listed in the license data 
: file.  Please contact your system adminstrator for help.
M WRITE_SERVER_ERROR -e1055
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot write to the servers listed in the license data 
: file.  Please contact your system adminsitrator for help.
M SELECT_ROUTINE_ERROR -e1056
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] a call to an internal select routine failed.
: Please contact your system adminsitrator for help.
M BUSY_SERVER_ERROR -e1057
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] failed to connect to a majority of the servers listed in the
: license data file.  Please contact your system adminsitrator for help.
M CHECKIN_FEATURE_ERROR -e1058
> feature s
: License checkin for feature "[feature]" failed[.br]
: Don't worry, be happy.

#
# Possible User Errors
#
M NO_LICENSE_FILE_ERROR -e1059
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the license data file.
: The default location for this file is usually
: /usr/local/data/license.dat.  It may be placed elsewhere at your site, in 
: which case you must define the environmental variable LM_LICENSE_FILE to
: point to it.  Make sure you can access the file from the same shell you are
: trying to run the program.
M NO_FEATURE_ERROR -e1060
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the feature in the license data
: file.  If you have not yet called customer
: service to obtain the authorization codes for this feature please do so.  If
: you have obtained the codes, please make sure that you have added the codes
: to the license data file.
M LICENSES_EXHAUSTED_ERROR -e1061
> feature s
: License checkout for feature "[feature]" failed[.br]
: because all the valid licenses for the feature are currently in use.  
: Try again later.
M EXPIRED_AUTHCODE_ERROR -e1062
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the required license has expired.  
: Please call customer service to obtain a new license.
M UNSUPPORTED_VERSION_ERROR -e1063
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the license data file does not contain a feature of the required
: version number.  Please call custommer service to obtain a license for 
: the new version of the feature.
M NO_KEY_ERROR -e1064
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program could not find a valid Xilinx protection key
: on the parallel port of your computer.  
: Please make sure that the key is attached securely to the parallel port.
M TAMPERED_KEY_ERROR -e1065
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program detected an invalid Xilinx protection key
: on the parallel port of your computer.  
: The key's memory has been corrupted.  Please call customer service to
: obtain a new key.
M DEMO_EXPIRED_ERROR -e1066
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because your demo version of the [program] program has expired.
: Please contact customer service
: or your sales representative to purchase the software you have been
: using.
M TAMPERED_DATE_ERROR -e1067
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the current date on your computer is set to a time which is
: before the date when you last ran this program.   
: Please reset your computer's date to the current
: date and rerun the program.
M XACT_VARIABLE_ERROR -e1068
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the XACT environmental variable has not been defined.
: Use the SET XACT=value dos command 
: to define the location of the XACT software.
M INVALID_DATE_ERROR -e1069
> feature s
: License checkout for feature "[feature]" failed[.br]
: because line in the license data file line which describes the feature
: contains an invalid date.  See the file XACT\data\license.dat.  
: All dates must be of the form 
: DD-MMM-YYYY, where DD is an integer 0-31; MMM is the first three 
: letters of the (English) month name: JAN, FEB, MAR, APR, MAY, JUN, JUL,
: AUG, SEP, OCT, NOV, or DEC; and YYYY is an integer 1990-2118.
M LOLEVEL_ERROR -e1070
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level error ([errtext]).

#
# Possible Installation Errors
#
M MULT_FEATURE_ERROR -e1071
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected multiple occurences of FEATURE lines for the 
: feature in the license file.  A feature
: may appear only once in the license file for it to be valid.  Please remove
: one of the feature lines from the license file.
M LICENSE_FILE_SYNTAX_ERROR -e1072
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected a syntax error in the license date
: file.  Please make sure that you have 
: correctly entered the authorization codes which you obtained from customer 
: service.
M NO_SERVER_ERROR -e1073
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect to the network license server.  
: Please make sure that the lmgrd program is 
: currently running on the computers described as servers in the license data 
: file.
M NO_SERVICE_ERROR -e1074
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the program [program] could not find the TCP "license" service. 
: Make sure that the /etc/services file has
: the license service number defined in it, or add a socket number to the the
: SERVER line of the license data file.
M BAD_AUTHCODE_ERROR -e1075
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected an inconsistency in the authorization code on the
: feature line of the license data file.  
: Please make sure that you have correctly entered the authorization codes
: which you obtained from customer service.
M WRONG_HOST_ERROR -e1076
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the host listed in one of the
: server lines of the license data file.  
: Please make sure that the server information in the license data file is 
: correct.
M BAD_DATE_ERROR -e1077
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] found an invalid date in the license data file.  
: Please make sure that the date information in the
: license data file is correct.  The correct date format is DD-MMM-YY (for
: example 30-JUN-91).  In previous versions of the program, dates of the form
: DD-MMM-YYYY were acceptable, but they are no longer.  To make the correction,
: stop the license server, edit the license.dat file to remove the '19' from
: the year number of all features, restart the license server and rerun the 
: program.
M NO_SERVER_LINES_ERROR -e1078
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find and server lines in the license data file.  
: Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M BAD_SERVER_NAME_ERROR -e1079
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] encountered an illegal server name in the license 
: data file.  Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M CONNECT_SERVER_ERROR -e1080
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect over the network to the license server
: program.  Please make sure that the lmgrd 
: program is currently running on the computers described as servers in the
: license data file.

#
# Error due to PC key
#
M PC_KEY_ERROR -e1081
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: [errtext]

E FEATURE
#
# ------------------ msg.m ------------------ 
#
#@(#)msg.m	6.3 9/3/93


B MSG -start1011 -end1030 -current1016
: The Message System Messages

#
# Message fragments for the MSGFILE error
M MSGIO_EOLJUNK
: Extra characters at the end of a valid line
M MSGIO_UNKNOWN_LINE
: Unknown message file line type
M MSGIO_MSGSET_NAME
: Message set name is required
M MSGIO_MSGDEF_NAME
: Message definition name is required
M MSGIO_MSGARG_NAME
: Message definition argument name is required
M MSGIO_MSGARG_TYPE
: Message definition argument type is required
M MSGIO_UNKNOWN
: Unknown error number

#
# These messages are used by the message system when something goes
# wrong while reading a message file, or instantiating a message
#

M MSGFILE_ERROR -e1011
> theErrorName  m
> theLineNumber d
> theFileName   s
> theLine       s
> thePosition   z
: [theErrorName][.br]
: The error is on Line [theLineNumber] of "[theFileName]"[.br]
: The line is "[theLine]"[.br]
: -------------[thePosition]
M MSGSET_MISSING -e1012
> theCompName s
: The message set for "[theCompName]" does not exist [.br]
: in any of the standard message files.
M MSGSET_NULL
> theCompNumber d
> theCompName s
: The message set pointer for component [theCompNumber], "[theCompName]"[.br]
: does not point to a valid message set.
M MSGSET_NDEFS -e1013
> theMsgnum d
> theMsgname s
> theNumberOfDefs d
> theCompName s
: An attempt was made to invoke message "[theMsgname]",[.br]
: with a message number of [theMsgnum].  However, the message set for[.br]
: component "[theCompName]" has only [theNumberOfDefs] messages.
M MSGSET_MSGNAMES -e1014
> theMsgnum d
> theMsgname s
> theRealMsgname s
> theCompName s
: Message #[theMsgnum] of the message set for component "[theCompName]"[.br]
: was invoked with a name of "[theMsgname]".  Its name in the message[.br]
: file is "[theRealMsgname]".
M MSGSET_NPARAMS -e1015
> theMsgname s
> theNparams d
> theRealNum d
> theCompName s
: Message "[theMsgname]" of the message set for component "[theCompName]"[.br]
: was invoked with [theNparams] parameters.  It is defined with [theRealNum]
: in the message file.

#
# Message id severity names
# These are used in the creation of errors to describe how severe the
# error really is.  THE ORDER OF THESE NAMES IS VERY, VERY IMPORTANT.
# SEE MSGINST_SEVERITY IN MSGINST.C IF YOU DON'T BELIEVE ME.
#

M MSGSEV_INFO
: Information
M MSGSEV_WARNING
: WARNING
M MSGSEV_ERROR
: ERROR
M MSGSEV_FATAL
: Fatal Error
M MSGSEV_INTERNAL
: Internal Error

E MSG
#
# ------------------ mxcomm.m ------------------ 
#
# @(#)mxcomm.m	6.2  9/3/93


B MXCOMM -start1001 -end1010 -current1003
: Mx Program Communications

# Boolean values
M TRUE_VALUES
: Y YES T TRUE ON
M FALSE_VALUES
: N NO F FALSE OFF

# These two messages are used in rwdict error messages
M STARTUP_NAME
: startup file

# These error messages are used by mxaccs directly
M STARTUP_OPEN_FAILED -e1001
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: exists, but could not be opened for some reason

M NO_STARTUP_FILE -e1002
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: does not exist, so it could not be opened

E MXCOMM
#
# ------------------ report.m ------------------ 
#
#@(#)report.m	6.1  12/2/92
 
 
B REPORT
: Report Generator Messages
 
M PAGE
: Page
M CONTINUED
: (continued)
M XILINX
: Xilinx, Inc.
M COPYRIGHT
> year d
: (c) Copyright [year].  All Rights Reserved.
M TABLE_OF_CONTENTS
: Table of Contents[.br]
: -----------------[.br]
M TOC_ENTRY
> entry s
: [entry]
E REPORT
#
# ------------------ rwdict.m ------------------ 
#
#TMF 1.0
# @(#)rwdict.m	6.2  9/3/93


B RWDICT -start1031 -end1050 -current1035
: Dictionary File Reader/Writer

M MISSING_EQUALSIGN -e1031 -w1032
> linenumber d
> filename   s
> dicttype   s
> line       s
: Missing equal sign in the name-value assignment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[line]"

M ILLEGAL_NAME -e1033 -w1034
> linenumber d
> filename   s
> dicttype   s
> name       s
: Illegal name used in the name-value assigment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[name]"


E RWDICT
#
# ------------------ synthx.m ------------------ 
#
#@(#)synthx.m	6.29    2/7/94
 
 
B SYNTHX
: wrapper for StateX and ImproveX programs
 
# Tool description (for program help)
M DESCRIPTION
: SYNTHX implements s finite state machine design using logic synthesis
: techniques including state assignment, logic optimization and 
: technology mapping targeting the XILINX specific FPGA architecture.
: [.br]
 
# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

M MDESIGN
: This is the name of your design.

M MFAMILY
: The option for Xilinx Part Family.

M MPARTTYPE
: The option for Xilinx Specific Parttype.

M MENCODE
: The option for state encoding style.

M MUNSPECIFIED_STATE
: The option for incompletely specified state machines.

M MOPTIMIZE
: The option for the logic optimizer, ImproveX.

M MAREA
: The option for area optimization.
 
M MSPEED
: The option for speed optimization.
 
M MMAXCLBS
: The option for an upper limit on number of CLBs.
 
M MSM_SPEED_OPT
: The option for state machine speed optimization.
 
M MOLD_LIBRARY
: The option for using older (non-unified) libraries.
 
M MMEMMISER
: The option for the memory miser feature of ImproveX.
 
M MOUTPUT_XNF
: The option for the name of the output xnf file.

M MOUTPUT_DIRECTORY
: The option for XNF output directory.

M MERRLOG
: The option for the error log file name.

M MADDPINS
: The option for EXT records to the XNF file.

M MMAPPED_XNF
: The option for an XNF file with EQN records.

M MLIMITED_FANIN
: The option for limited fanin numbers of a gate.

M MMINIMIZE
: The option for state minimization.

M MOUTPUT
: The option for the type of output file.

M MXNFFILE
: This option specifies the XNF file format.

M MOUTFILE
: The output file from the optimizer.
: (Default is derived from input file name.)

M MAGGRESSIVE
: This option for ImproveX to run in aggressive mode.

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M HDESIGN
: The default extension is ".bl1" or ".bl0".
: [.br]

M HFAMILY
: This option specifies the Xilinx Part Family.[.br]
: This parameter takes an integer value among 2,3,4.[.br]

M HPARTTYPE
: This option specifies the Xilinx Specific Parttype.
: [.br]

M HENCODE
: Supported encoding styles are: standard, binary, one_hot.[.br]
: [.br]

M HUNSPECIFIED_STATE
: This option forces SYNTHX to generate some extra logic to
: complete a finite state machine design if it contains incompletely
: specified symbolic state machines.[.br]
: This parameter can be assigned one of the these values:[.br]
:	current_state:	state machine transitions into[.br]
:			the current state[.br]
:	initial_state:	state machine transitions into[.br]
:			the initial state[.br]
:	dont_care    :	the extra logic is not necessary[.br]
:			for the incompletely specified[.br]
:			state machines[.br]

M HOPTIMIZE
: This option may be set to FALSE to disable the logic optimizer, 
: ImproveX, if it fails for some reason.
: [.br]

M HAREA
: This option causes SYNTHX to synthesize for minimum number of CLBs.
: [.br]
 
M HSPEED
: This option causes SYNTHX to synthesize for minimum number of CLB levels.
: [.br]
 
M HMAXCLBS
: This parameter sets an upper limit on number of CLBs used by SYNTHX.
: This option should only be used in conjunction with the "speed" option.
: And a valid value should be a positive integer.
: [.br]
 
M HSM_SPEED_OPT
: This option implements symbolic state machine speed optimization at
: the expense of additional CLBs. With this option, SYNTHX uses the
: state splitting technique to split the states with high fanins,
: meanwhile without changing the function of a symbolic state machine
: so that the maximum number of CLB levels is minimized.
: [.br]
 
M HOLD_LIBRARY
: This option causes SYNTHX to generate an XNF file using older
: (non-unified) libraries.
: [.br]

M HMEMMISER
: This option causes ImproveX, the logic optimizer to be more
: miserly with memory in order to handle large designs. It may
: result in a higher CLB count.
: [.br]

M HAGGRESSIVE
: This option causes the logic optimizer, ImproveX, to run in 
: aggressive (slower) mode. The optimizer will loop for up to a 
: maximum of eight (8) iterations.
: [.br]

M HOUTPUT_XNF
: This option sets the name of the output xnf file.[.br]
: The default value is <module_name>.xnf.
: [.br]

M HOUTPUT_DIRECTORY
: This parameter specifies the output directory for the XNF file.
: [.br]

M HERRLOG
: This option specifies the name of the error log file.
: [.br]
 
M HADDPINS
: This option allows the user to "test out" a state machine as though it 
: were a whole design by adding EXT records to the XNF file for all 
: specified input and output signals.
: [.br]

M HMAPPED_XNF
: This option causes Synthx to generate FMAP/HMAP
: or EQN records in the XNF file.  If the output
: XNF file is to be simulated, then this parameter
: should be FALSE.
: [.br]

M HMINIMIZE
: When this option is TRUE, the compiler will attempt to remove
: redundant states in the state machine.
: [.br]

M HLIMITED_FANIN
: This parameter specifies whether to limit fanin numbers of a gate.
: [.br]

M HOUTPUT
: This parameter specifies the type of file that should be output
: by SYNTHX. This parameter may be currently assigned only one value: xnf.
: [.br]

M HOUTFILE
: The output file from the optimizer.
: The default is derived from input file name.
: [.br]

# The following parameters are only available during development

M HDP2S
: Specifies the max delays (in Ns)  on all input pin to flipflop paths. 

M HDC2S
: Specifies the max delays  (in Ns) for all F/F to F/F paths.

M HDP2P
: Specifies the max delays (in Ns)  on pure combinatorial logic paths in the module.

M HDC2P
: Specifies the max delays (in Ns)  on all flipflop to output pin paths.

# Error messages used: originally from the Feature License Manager

M BADOPTION
> name s
> option z
: An illegal option was specified: [name]=[option][.br]
: [.br]

M XNO_WRITE_TO_FILE
> filename s
: [.br]
: SynthX cannot write to the file '[filename]'.  Some possible causes of this
: problem are a full disk or problems with writing over a network.
: [.br]

# Error and Warning Messages

M NAME_NOT_DIRECTORY
> name s
: [.br]
: The output directory [name] is not a known directory.
: [.br]

M NO_PARTTYPE_PROPERTY
: [.br]
: The Xilinx Property parttype statement did not specify a part type.  The syntax of
: the Xilinx Property parttype statement is: [.br]
: [.br]
:	Xilinx Property 'PartType <part type>';
: where <part type> is any legal Xilinx LCA parttype.
: [.br]

M ERROR_TERMINATE
> name s
: SynthX is terminating abnormally due to errors encountered in subtool:
: [name]
: [.br]

M CANNOT_OPEN_INPUT_FILE
> name1 s
> name2 s
: [.br]
: SynthX is unable to open input file ([name1]) or ([name2]).[.br]
: Please run ahdl2x, blifoptx to obtain the files.
: [.br]

M CANNOT_OPEN_FILE
> name s
: [.br]
: SynthX is unable to open the file [name].
: [.br]

M FILE_CORRUPTED_AT_END
> name s
: The file [name] is corrupted at its end.[.br]
: Please run ahdl2x,  blifoptx to obtain the file.
: [.br]

M PICK_SPEED_OR_AREA
: [.br]
: You can select either one of AREA or SPEED optimization option,
: but not both.
: [.br]

M INVALID_MAXCLBS_WITH_AREA
> option s
: The option maxclbs=[option] is invalid since the Area option 
: is set to TRUE.
: [.br]

M IGNORE_MAXCLBS_WITH_SPEED
> option s
: SynthX is ignoring maxclbs=[option] since the Speed option 
: is set to FALSE.
: [.br]

M CANNOT_OPEN_XCT
: [.br]
: SynthX encountered a problem opening the file partlist.xct.
: [.br]

M ILLEGAL_PARTTYPE
> parttype z
: [.br]
: The part type [parttype] is not a legal Xilinx parttype.  Please see
: the help menu on part types in XABEL.
: [.br]

M FAMILY_NOT_MATCH_PARTTYPE
> family   s
> parttype s
: [.br]
: The specified family [family] does not match the part type [parttype].
: SynthX will use parttype to determine family.
: [.br]

# Informational and Other Messages

M STATEX
: StateX

M IMPROVEX
: ImproveX

M RUN_SUBTOOL
> name s
: [name]
: [.br]

E SYNTHX
#
# ------------------ xnf.m ------------------ 
#
# @(#)xnf.m	6.13  1/14/94


B XNF -start1301 -end1350 -current1315
: Xnf Data Handler

#
# These are message phrases used for syntax errors
#
M SYNTAX_UNK
: Unknown error found 
M SYNTAX_PRN
: A program name is required
M SYNTAX_PAT
: A parttype is required
M SYNTAX_SYN
: A symbol name is required
M SYNTAX_STN
: A symbol type name is required
M SYNTAX_PIN
: A pin name is required
M SYNTAX_PID
: A pin direction character is required
M SYNTAX_SIN
: A signal name is required
M SYNTAX_IPN
: An input pin name is required
M SYNTAX_CPN
: A clock pin name is required
M SYNTAX_CLE
: A clock edge character is required
M SYNTAX_CLP
: A clock polarity character is required
M SYNTAX_PUW
: A pulse width value is required
M SYNTAX_BUN
: A bus name is required
M SYNTAX_PWP
: A power polarity character is required
M SYNTAX_ESD
: An external record signal direction character is required
M SYNTAX_PPN
: Package pin name is required
M SYNTAX_SET
: A setup up time value is required
M SYNTAX_HLD
: A hold time value is required
M SYNTAX_MLR
: The LCANET record is required
M SYNTAX_BRT
: Unrecognized record type found
M SYNTAX_V4R
: Lcanet version 4 is required (Run xnfupd to convert your design)
M SYNTAX_ILV
: Illegal LOC value found
M SYNTAX_LSV
: No value is specified for LOC parameter
M SYNTAX_INT
: An integer is required
M SYNTAX_CHR
: Character is required
M SYNTAX_STR
: A character string is required
M SYNTAX_FLT
: A floating point number is required
M SYNTAX_DLY
: Delay numbers are required
M SYNTAX_BDN
: Illegal delay number specification found
M SYNTAX_COM
: A comma is required
M SYNTAX_EOL
: End of line is required
M SYNTAX_EOF
: End of File is required
M SYNTAX_ERROR 
> errorname m
> linenumber d
> filename s
: [errorname]
: on line [linenumber] of file [filename]:

# 
# These are message phrases used for semantic errors
#
M BADPARTTYPE
> parttype s
: Unrecognized parttype '[parttype]'
M MULTIPLESYM
> symname s
: Multiple symbols exist with the name '[symname]'
M MULTIPLEPIN
> symname s
> pinname s
: The symbol '[symname]' contains multiple pins with the name '[pinname]'
M MULTIPLEBUS
> busname s
: Multiple busses exist with the name '[busname]'
M MULTIPLEEXT
> pinnum s
> signame s
: Multiple Ext-records exist with the same signal '[signame]' or package
: pin name '[pinnum]'
M MULTIPLEEXT2
> signame s
: Multiple Ext-records exist with the same signal '[signame]'
M MULTIPLEHIERG
> hier_id d
> sym_name s
: Multiple Hierg-records exist for hier_id '[hier_id]', sym_name '[sym_name]'
M INSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal between SYM and END records
M RECORD_OUT_OF_PLACE
> record s
: The '[record]' record is illegal outside of SYM and END records
M NOSYMBOL
> rectype s
> recname s
: The '[rectype], [recname]' record is illegal outside of SYM and END records
M BADSETUPEDGE
> inname s
> clkname s
> edge s
: The 'SETUP, [inname], [clkname]' record has an illegal clock edge value '[edge]'
M MULTIPLEPOLARITY
> signame s
: The signal '[signame]' is both GND and VCC
M BADPOWERPOLARITY
> signame s
> polarity s
: The PWR record for signal '[signame]' has an illegal polarity value '[polarity]'
M BADPULSEPOLARITY
> symname s
> pinname s
> polarity s
: The 'PULSE,[pinname]' record in symbol [symname] has an illegal polarity
: value '[polarity]'
M BADEXTDIR
> signame s
> dir s
: The 'EXT, [signame]' record has an illegal direction value '[dir]'
M BADPINDIR
> symname s
> pinname s
> dir s
: The pin [pinname] in symbol '[symname]' has an illegal direction value '[dir]'
M NO_PARAM_VALUE
> rectype s
> recname s
> namevalue s
: The [rectype] '[recname]' contains a parameter '[namevalue]' with no value
: specified
M MULTIPLEPARAM
> rectype s
> recname s
> name s
: The [rectype] '[recname]' contains multiple '[name]' parameters 
M INVALID_SYMBOL_PIN
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' is not a legal pin for this type of
: symbol
M INVALID_PIN_INV
> symbol  s
> pinname s
: The '[symbol]' symbol pin '[pinname]' cannot be legally inverted
M INVALID_EXT_PARAM
> ext  s
> param s
: The PAD '[ext]' has an illegal parameter with the name '[param]'
M CONFLICT_EXT_PARAM
> ext  s
> param s
> conflict_param s
: PAD '[ext]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SIG_PARAM
> sig  s
> param s
: The signal '[sig]' has an illegal parameter with the name '[param]'
M CONFLICT_SYM_PARAM
> symbol  s
> param s
> conflict_param s
: Symbol '[symbol]' parameters '[param]' and '[conflict_param]' are
: mutually exclusive; they cannot be used together
M INVALID_SYM_PARAM
> symbol  s
> param s
: The symbol '[symbol]' has an illegal parameter with the name '[param]'
M INVALID_PIN_PARAM
> pinname s
> symbol  s
> param s
: The '[pinname]' pin on symbol '[symbol]' has an illegal parameter with
: the name '[param]'
M MULTPARTTYPES
> part1 s
> part2 s
: The design network contains multiple parttypes - [part1] and [part2]
M UNKNOWNPIN
> rectype s
> pinname s
: The [rectype] record refers to an undefined pin '[pinname]'
M ILLEGAL_BOOLEAN
> sym s
> numpins d
> numarchpins d
: The symbol '[sym]' has [numpins] input pins specified; only
: [numarchpins] input pins are allowed on this type Boolean gate. 
M MODEL
> rectype s
: The [rectype] record is illegal record outside of MODEL and ENDMOD records
M CANNOT_WRITE_TO_FILE
> filename s
: Cannot write to file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.
M MISSINGPARAM
> symname s
> symtype s
> paramname s
: The [symtype] symbol '[symname]' is missing the required [paramname] parameter

M INVALID_SIG_NAMES
> siglist s
: The following signals have illegal names:[.br]
: [siglist]
M INVALID_SYM_NAMES
> symlist s
: The following symbols have illegal names:[.br]
: [symlist]
M TOOMANY
> errlimit d
: The number of errors exceeds [errlimit], bailing out prematurely
M WOOPS
> namevalue s
> rectype s
: [namevalue] specified without an active [rectype]
M SEMANTIC_ERROR
> error z
: [error][.br]
M SEMANTIC_ERROR_LOCATION
> error z
> linenum d
> filename s
: [error][.br]
: near line [linenum] of file [filename].

M VALIDITY_NO_ARCH
: The Design Validity Check cannot be implemented because no archfile or
: parttype can be found.

M ERROR_LIST -e1303 -w1304
> filename s
> details z
: The following problem(s) were found in the [filename] file; 
: the file could not be processed successfully.[.br]
: [.br][details]

M VALIDITY_ERRORS -e1305 -w1306
> details z
: [details]

#
# These errors are used for loading xnf archtype data files
#
M CHECKS_PARTTYPE -e1307 -w1308
> designname s
: The parttype for the [designname] design is missing so we cannot perform
: the checks related to legal symbols, pins, parameters, etc.

M CHECKS_UNKNOWN_DATAFILE -e1309 -w1310
> designname s
> parttype s
: The [designname] design is for a parttype called "[parttype]".  We do not
: know which archtype data file we should read for that parttype.  We have
: to read an archtype data file so that we can perform the checks 
: related to legal symbols, pins, parameters, etc.  We are unable, therefore,
: to perform these types of checks.

M CHECKS_NO_DATAFILE -e1311 -w1312
> designname s
> datafilename s
: The [datafilename] data file (which we need to read so that we can perform the
: checks related to legal symbols, pins, parameters, etc. on the [designname]
: design) does not exist in the $XACT/data directory.  We therefore cannot
: perform these types of checks.

M CHECKS_DATAFILE_ERROR -e1313 -w1314
> designname s
> datafilename s
: We encountered problems while reading the [datafilename] data file.  We
: have to read this file so that we can perform the checks related to legal 
: symbols, pins, parameters, etc. in the [designname] design.  We therefore
: cannot perform these types of checks.

E XNF
#
# ------------------ statex.m ------------------ 
#
# CFILE_ID("@(#)statex.m	6.46  2/10/94")
 
 
B STATEX
: Xilinx state machine entry tool
 
# Tool description (for program help)
M DESCRIPTION
: STATEX implements s finite state machine design using logic synthesis
: techniques including state assignment, technology mapping targeting 
: the XILINX specific FPGA architecture.
: [.br]

# External Parameter Names
# What is this parameter?  This is the...(a short & pithy 1-liner)

M MDESIGN
: This is the file name of your design.

M MFAMILY
: The option for Xilinx Part Family.

M MPARTTYPE
: The option for Xilinx Specific Parttype.

M MENCODE
: The option for state encoding style.
 
M MUNSPECIFIED_STATE
: The option for incompletely specified state machines.
 
M MSM_SPEED_OPT                                    
: The option for state machine speed optimization.

M MOLD_LIBRARY                                     
: The option for using older (non-unified) libraries.

M MOUTPUT_XNF
: The option for the name of the output xnf file.
 
M MOUTPUT_DIRECTORY
: The option for XNF output directory.
 
M MERRLOG
: The option for the error log file name.
 
M MADDPINS
: The option for EXT records to the XNF file.
 
M MLIMITED_FANIN
: The option for limited fanin numbers of a gate.
 
M MMINIMIZE
: The option for state minimization.

M MOUTPUT
: The option for the type of output file.
 
M MSTANDALONE
: The option for running statex standalone

# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M HDESIGN
: The default extension is ".bl1" or ".bl0".
: [.br]
 
M HFAMILY
: This option specifies the Xilinx Part Family.[.br]
: This parameter takes an integer value among 2,3,4.
: [.br]
 
M HPARTTYPE
: This option specifies the Xilinx Specific Parttype.
: [.br]
 
M HENCODE
: Supported encoding styles are: standard, binary, one_hot.[.br]
: [.br]

M HUNSPECIFIED_STATE
: This option forces SYNTHX to generate some extra logic to
: complete a finite state machine design if it contains incompletely
: specified symbolic state machines.[.br]
: This parameter can be assigned one of the these values:[.br]
:	current_state:	state machine transitions into[.br]
:			the current state[.br]
:	initial_state:	state machine transitions into[.br]
:			the initial state[.br]
:	dont_care    :	the extra logic is not necessary[.br]
:			for the incompletely specified[.br]
:			state machines[.br]

M HSM_SPEED_OPT
: This option implements symbolic state machine speed optimization at
: the expense of additional CLBs. With this option, SYNTHX uses the
: state splitting technique to split the states with high fanins,
: meanwhile without changing the function of a symbolic state machine
: so that the maximum number of CLB levels is minimized.
: [.br]

M HOLD_LIBRARY
: This option causes SYNTHX to generate an XNF file using older
: (non-unified) libraries.
: [.br]
 
M HOUTPUT_DIRECTORY
: This parameter specifies the output directory for the XNF file.
: [.br]
 
M HOUTPUT_XNF
: This option sets the name of the output xnf file.[.br]
: The default value is <module_name>.xnf.
: [.br]
 
M HERRLOG
: This option specifies the name of the error log file.
: [.br]

M HADDPINS
: This option allows the user to "test out" a state machine as though it
: were a whole design by adding EXT records to the XNF file for all
: specified input and output signals.
: [.br]
 
M HMINIMIZE
: When this option is TRUE, the compiler will attempt to remove
: redundant states in the state machine.
: [.br]
 
M HANALYSIS
: This expert option causes the program to analyze the effectiveness of
: the illegal state reset code.  The results are output to the design
: report file.  The report will contain states that loop or remain stuck 
: in illegal states.

M HLIMITED_FANIN
: This parameter specifies whether to limit fanin numbers of a gate.
: [.br]
 
M HOUTPUT
: This parameter specifies the type of file that should be output
: by STATEX. This parameter may be currently assigned only one 
: value: xnf.
: [.br]
 
M HSTANDALONE
: This parameter specifies whether statex runs standalone or runs
: with the logic optimizer. The option limited_fanin will be 
: on if it is in stand alone mode.
: [.br]

# Error and Warning Messages

M BADOPTION
> option s
> setting z
: Illegal Option specified: [option]=[setting][.br]
: [.br]

M ILLEGAL_STATE
> fsmname s
> pstate  s
> nstate  s
: [.br]
: The '[pstate]' state is used the '[fsmname]' state machine, but it is not
: part of this state machine.  The illegal transition is from '[pstate]'
: to '[nstate]'.  Please check the state_diagram for '[fsmname]' for
: this transition.
: [.br]

M NO_PARTTYPE_PROPERTY
: [.br]
: The Xilinx Parttype property did not specify a part type.  The syntax of
: the Parttype Property is: [.br]
: [.br]
:    Xilinx Property 'PartType <part type>'; [.br]
: where <part type> is any legal Xilinx FPGA part type.
: [.br]

M NO_SUCH_STATEMACHINE
>name  s
: [.br]
: The [name] state machine identified in the Xilinx Property InitialState
: statement is not a declared state machine in your design. (The statement 
: is ignored if the state machine is not a symbolic state machine.)[.br]
: [.br]
: The syntax of the Xilinx Property InitialState statement is: [.br]
: [.br]
:      Xilinx Property 'InitialState <state_machine> <state_name>'; [.br]
: [.br]
: where <state_machine> is the name of the state machine. <state_name> 
: is the name of the initial or power-up state of the state machine.
: [.br]

M NO_STATEMACHINE_NAME
>filename s
>lineno d
: [.br]
: The Xilinx Property InitialState statement in the [filename] file at line 
: [lineno] does not specify a state machine name or a state name.  
: The syntax of the Xilinx Property InitialState is: [.br]
:      Xilinx Property 'InitialState <state_machine> <state_name>';
: where <state_machine> is the name of the state machine's state register
: and <state_name> is the name of the initial or power-up state of 
: this state machine.
: [.br]

M BAD_STATEMACHINE
> filename s
> lineno   d
: [.br]
: In the [filename] file at line [lineno], the STATEMACHINE record 
: is corrupted. Try re-compiling your design.
: [.br]

M ILLEGAL_MAP_INPUT
>output s
>inname s
: [.br]
: The [inname] input signal for [output] is a primary output in a Xilinx
: Property MAP statement.  Input signals in a Xilinx Property MAP statement
: must either be primary inputs or nodes.
: [.br]

M ILLEGAL_MAP_OUTPUT
>output s
: [.br]
: The [output] output signal is a primary input in a Xilinx Property MAP
: statement.  Output signals in a Xilinx Property MAP statementmust must 
: either be primary outputs or nodes.
: [.br]

M ILLEGALLY_DEFINED_ASYNC_RESET
: [.br]
: The asynchronous reset signal has not been assigned to a state.
: Use the following syntax to declare your asynchronous reset state:[.br]
: "    async_reset <state_name> : <async_reset>; "[.br]
: This statement should go into the State_diagram section of your state
: machine description.  Please see the Xilinx ABEL manual for more 
: information.
: [.br]

M ILLEGALLY_DEFINED_SYNC_RESET
: [.br]
: The synchronous reset signal has not been assigned to a state.  
: Use the following syntax to declare your synchronous reset state:[.br]
: "    sync_reset <state_name> : <sync_reset>; "[.br]
: This statement should go into the State_diagram section of your state
: machine description.  Please see the Xilinx ABEL manual for more 
: information.
: [.br]

M MAP_SIG_NOT_IO 
> signal s
: [.br]
: The "[signal]" signal specified in a Xilinx Property MAP statement is not
: a design pin or node.  Please declare "[signal]" with the ABEL 'pin' or 'node'
: command.
: Please see Xilinx ABEL manual for the syntax for pins and nodes.
: [.br]

M SAVE_SIG_NOT_IO
> signal s
: [.br]
: The "[signal]" signal in a Xilinx Property SAVE statement is not a
: design pin or node.  Please declare "[signal]" with the ABEL 'pin' or 'node'
: command.  Please see the Xilinx ABEL manual for syntax for pins and nodes.
: [.br]

M BAD_SAVE_PROP
: [.br]
: An illegal Xilinx Property SAVE statement was found.  Correct syntax is:[.br]
: "    Xilinx Propery 'Save out'; "[.br]
: [.br]

M BAD_MAP_PROP
: [.br]
: An illegal Xilinx Property MAP statement was found.  Correct syntax is:[.br]
: "    Xilinx Propery 'Map out, in1, in2, in3, in4, in5'; "[.br]
: [.br]

M MAP_NO_INPUTS
> output s
: [.br]
: The Xilinx Property MAP statement was found with output "[output]",
: which has no input signals assigned.  Correct syntax is:[.br]
: "    Xilinx Propery 'Map out, in1, in2, in3, in4, in5'; "[.br]
: [.br]

M MAP_TOO_MANY_INPUTS
> output s
> max_inputs d
: [.br]
: The Xilinx Property MAP output "[output]" has too many inputs assigned.  
: The maximum number of inputs is [max_inputs]. Correct syntax is:[.br]
: "    Xilinx Propery 'Map out, in1, in2, ... '; "[.br]
: [.br]

M SPEED_GRADE_WARNING
> parttype s
> speedgrade s
: [.br]    
: The timing data for '[parttype][speedgrade]' is missing from 
: the technology description. 
: [.br]    

M DEFAULT_SPEED_GRADE
> parttype s
> speedgrade s
: [.br]    
: StateX is using the default speedgrade,'[speedgrade]', for the part type: '[parttype]'.
: [.br]    
 
M SPEED_FILE_TROUBLE
> die s
> speedgrade s
: [.br]
: StateX encountered a problem opening speed file for [die] die and 
: [speedgrade] speedgrade.
: [.br]

M INCOMPLETE_TIMEPROPERTY
> timeprop z
> filename s
: [.br]
: StateX found an incomplete timing property: [timeprop]
: in [filename] file.
: [.br]

M IGNORE_TIMEPROPERTY 
> timeprop z 
> filename s 
: [.br] 
: StateX is ignoring timing property found: [timeprop] 
: in [filename] file.
: [.br]  
 
M VALID_TIMEPROPERTY
: [.br] 
: The valid timing properties in Xilinx ABEL are the following: [.br]
:	DLP2S -- Default maximum CLB Levels from input Pin to DFF Setup[.br]
:	DLC2S -- Default maximum CLB Levels from DFF clock to DFF Setup[.br]
:	DLC2P -- Default maximum CLB Levels from DFF clock to output Pin[.br]
:	DLP2P -- Default maximum CLB Levels from input Pin to output Pin
: [.br]

M REMOVING_SOURCELESS
> netname s
: [.br]
: StateX is removing sourceless net [netname] from design.
: [.br]

M INCOMPLETE_SM
> name s
: [.br]
: The state machine, [name], is incompletely specified.  Incompletely specified
: state machines run the risk of entering illegal/undefined states.
: [.br]

M ILLEGAL_XNF
> name s
> char   s
: [.br]
: An illegal XNF character, [char], was found in the signal [name].
: The legal XNF character set is all alphanumerics and the characters
: "$_-<>/" only.
: [.br]

M ILLEGAL_PARTTYPE
> parttype z
: [.br]
: The '[parttype]' part type is not a legal Xilinx part type.  Please see
: the help menu for more information on part types in Xilinx ABEL.
: [.br]

M NO_FSM_TO_SYNC_WITH
> name s
: [.br]
: There is no Finite State Machine with which to synchronize I/O [name].
: The SYNCINPUT and SYNCOUTPUT properties allow you to synchronize
: your inputs and outputs to your Symbolic State Machines, only.
: [.br]

M NO_SYNC_IN_2K
> name s
: [.br]
: The XIlinx Property Syncoutput is assigned to the signal [name].
: The Xilinx Property Syncoutput is not supported 
: in the XC2000 family.
: [.br]

M DOT_EXT_NOT_IN_2K
> dotext s
: [.br]
: The [dotext] dot extension is not supported in the XC2000 family.
: [.br]

M NO_Q_PIN_ON_REG
> regname s
: [.br]
: There is no signal assigned to the output pin of the register [regname].
: [.br]

M NO_D_PIN_ON_REG
> regname s
: [.br]
: There is no signal assigned to the input pin of the register [regname].
: [.br]

M NO_C_PIN_ON_REG
> regname s
: [.br]
: There is no clock signal assigned to the clock pin of the register
: [regname].
: [.br]

M NO_INPUTS
> filename s
> modulename s
: [.br]
: No inputs were declared for module [modulename] in file [filename].
: Please use the ABEL-HDL PIN keyword to declare your input signals to
: your design module.
: [.br]

M NO_OUTPUTS
> filename s
> modulename s
: [.br]
: No outputs were declared for module [modulename] in file [filename].
: Please use the ABEL-HDL PIN keyword to declare your output signals to
: your design module.
: [.br]

M NO_SD_RD_ALLOWED
> name s
: [.br]
: Both asynchronous set and asynchronous reset are used by
: the same register, [name], in your design.
: Use asynchronous set and asynchronous reset on the same register is
: not supported by the XC3000 and XC4000 families.
: [.br]

M NO_2K_TBUFS_ALLOWED
> name s
: [.br]
: An assignment to a 3-state buffer was identified on register
: [name].  Tri-state buffer was not available in the XC2000 family.
: [.br]

M FUSE_NOT_SUPPORTED
> name s
: [.br]
: A FUSE declaration is in your [name] design.
: FUSE declarations are not supported.
: [.br]

M GFF_NOT_SUPPORTED
> name s
: [.br]
: A G type register, [name], has been identified in your design.  
: G type registers are not supported.
: [.br]

M JKFF_NOT_SUPPORTED
> name s
: [.br]
: A JK type register, [name], has been identified in your design.  
: JK type registers are not supported.
: [.br]

M SRFF_NOT_SUPPORTED
> name s
: [.br]
: A SR type register, [name], has been identified in your design.  
: SR type registers are not supported.
: [.br]

M TFF_NOT_SUPPORTED
> name s
: [.br]
: A T type register, [name], has been identified in your design. 
: T type registers are not supported.
: [.br]

M PR_NOT_SUPPORTED
> name s
: [.br]
: The "PR" (preset) dot extension was found on register [name].
: This dot extension is PAL device dependent.  Please use the
: ".AP" dot extension for an asynchronous preset or the
: ".SP" dot extension for a synchronous preset for your registers.
: [.br]

M UNSUPPORTED_DOT_EXTENSION
> name s
> dotext s
: [.br]
: The dot extension, [dotext], is used in your design on register
: [name].
: This dot extension is not supported.[.br]
: [.br]

M CORRUPTED_FILE
> filename s
> lineno d
: [.br]
: The [filename] file appears to be corrupted at line [lineno].  
: Statex is unable to resolve the statements.  Part or all of expected 
: syntax is missing or illegal.
: [.br]

M NO_INPUT_TO_SYNC
> modname s
> filename s
> lineno d
: [.br]
: No input signal was specified to SYNCINPUT property for module [modname] in file
: [filename] at line [lineno].
: [.br]

M NO_OUTPUT_TO_SYNC
> modname s
> filename s
> lineno d
: [.br]
: No output signal given to SYNCOUTPUT property for module [modname] in file
: [filename] at line [lineno].
: [.br]

M INPUT_TO_SYNC_NOT_FOUND
> signal s
> filename s
: [.br]
: Unrecognized input signal [signal] given to synchronize in file [filename].
: [.br]

M OUTPUT_TO_SYNC_NOT_FOUND
> signal s
> filename s
: [.br]
: Unrecognized output signal [signal] given to synchronize in file [filename].
: [.br]

M SYNC_INTERNAL_FOUND
> modname s
> filename s
> lineno d
: [.br]
: SYNCINPUT or SYNCOUTPUT property encountered for internal signal to
: module [modname] in file [filename] at line [lineno].  Only external
: inputs or outputs of the module may be synchronized with the clock.
: [.br]

M DEFAULTING_POWERUP_STATE
> name s
> state s
: [.br]
: No state was identified as the initial or power-up State for the 
: [name] state machine. The initial or power-up State will be 
: defaulted to the asynchronous reset state: [state]. Please use the 
: following statement in your ABEL-HDL file to identify the initial
: state: [.br]
: [.br]
:     Xilinx Property 'INITIALSTATE [name] <state_name>' [.br]
: [.br]

M NO_POWERUP_STATE_SPECIFIED
> name s
: [.br]
: [.br]
: No state was identified as the initial or power-up state for 
: the state machine [name].  This will cause the state machine to
: power up in a randomly selected state.[.br]
: Please use the statement: [.br]
: [.br]
:     Xilinx Property 'INITIALSTATE [name] <state_name>' [.br]
: [.br]
: in your ABEL-HDL file to define an initial state.
: [.br]

M PROPERTY_IGNORED
> property z
> filename s
> lineno d
: [.br]
: StateX is ignoring Xilinx Property [property] statement found in file [filename] at
: line [lineno].
: [.br]

M ILLEGAL_SUBCKT_SYNTAX
> filename s
> lineno   d
: [.br]
: StateX found invalid SUBCKT record syntax in file [filename] at line [lineno].
: [.br]

M ILLEGAL_TT_SYNTAX
> filename s
> lineno   d
: [.br]
: StateX found invalid truth table syntax in file [filename] at line [lineno].
: [.br]

M INVALID_TBUF_SYNTAX
> filename s
> lineno d
: [.br]
: StateX found invalid TBUF record syntax found in file [filename] at line [lineno].
: [.br]

M IGNORING_NON_TOP_CLOCK
> filename s
> modelname s
: [.br]
: StateX found ".clock" statement in model [modelname] in the [filename] file,
: which is not in the first model.
: The only ".clock" constructs retained are the ones in the first model.
: [.br]

M NO_MODEL_SPECIFIED
> name s
: [.br]
: No model was specified in design [name].  The model missing.
: [.br]

M INVALID_LATCH_SYN
> filename s
> lineno   d
: [.br]
: StateX found invalid latch syntax in file [filename] at line [lineno].
: [.br]

M UNKNOWN_LATCH_PIN
> pinname s
> signalname s
> filename s
> lineno d
: [.br]
: The signal [signalname] attached to an unrecognized latch pin [pinname] in file
: [filename] at line [lineno].
: [.br]

M NO_MODEL_FOR_SUBCKT
> name s
: [.br]
: No model specified for SUBCKT [name].
: [.br]

M FAMILY_NOT_MATCH_PARTTYPE
> family   s
> parttype s
: [.br]
: The specified family [family] does not match part type [parttype].
: StateX will use the part type to determine the family.
: [.br]

M INVALID_XSM_FILE
> filename s
> lineno   d
: [.br]
: StateX found invalid intermediate design file [filename].  
: It found bad data found at line: [lineno].
: [.br]

M MISSING_STATE_DATA
> filename s
> lineno   d
: [.br]
: StateX found invalid intermediate design file [filename].  
: It found missing state information from #$ STATE 
: record found at line:  [lineno].
: [.br]

M BAD_INPUT_VALUES
> filename s
> lineno   d
: [.br]
: StateX found invalid intermediate design file [filename].  
: It found invalid input signal value(s) found at line:  [lineno].
: [.br]

M BAD_OUTPUT_VALUES
> filename s
> lineno   d
: [.br]
: StateX found invalid intermediate design file [filename].  
: It found invalid output signal value(s) found at line:  [lineno].
: [.br]

M TOO_MANY_INPUTS
> filename s
> lineno   d
: [.br]
: The number of inputs specified differs from the number of
: inputs defined in header of the file [filename] at line:  [lineno].
: [.br]

M NO_INPUT_COUNT
> filename s
: [.br]
: StateX did not find the .I or .ILB command in input file [filename]. 
: It is unable to determine number of input signals in design.
: [.br]

M NO_OUTPUT_COUNT
> filename s
: [.br]
: StateX did not find the .O or .OB command in input file [filename].
: It is unable to determine number of output signals in design.
: [.br]

M TOO_MANY_OUTPUTS
> filename s
> lineno   d
: [.br]
: The number of outputs specified differs from the number of outputs
: defined in header of the [filename] file at line:  [lineno].
: [.br]

M TOO_MANY_STATES
> design    s
> maxstates d
: [.br]
: There are more than [maxstates] states specified for the design [design].
: [.br]

M STATE_REG_DEFINED
> regname s
> lineno  d
: [.br]
: A state register was already defined as [regname].  StateX found 
: another definition at [lineno].
: [.br]

M INVALID_REG_TYPE
> design s
> regtype  s
: [.br]
: StateX found an invalid register type, [regtype], in design [design].
: [.br]

M ILLEGAL_ARESET_STATE
> name s
: [.br]
: You have specified that the design should asynchronously reset to
: state [name], which is not the initial state for the state machine.
: State machines can only reset to the initial state.
: [.br]

M ILLEGAL_INITIAL_STATE
> name s
: [.br]
: You have identified [name] to be the Initial State of your state machine.
: However, [name] is not a state in your state machine.
: [.br]

M ILLEGAL_FLIPFLOP_SYNTAX
> filename s
> lineno   d
: [.br]
: StateX found illegal "#$ FLIPFLOP" record syntax in 
: file [filename] at line [lineno].
: [.br]

M ILLEGAL_SREG_PIN
> outpin s
> insig  s
: [.br]
: An illegal state register pin, [outpin], assigned to input signal [insig].
: [.br]

M NO_STATE_REG_DEF
> name s
: [.br]
: StateX encountered a state register pin assignment record without a "#$ STATE" 
: record read in design [name].
: [.br]

M IGNORING_BITS
> name s
: [.br]
: A "#$ STATE" record specified bitwidth and bitnames.  StateX is using one-hot
: encoding of state machine only.  It is ignoring bit information in design 
: [name].
: [.br]

M IGNORING_PIN_LOCATIONS
> name s
: [.br]
: The pin number is not necessary in FPGA design using XABEL:[.br]
: StateX is ignoring pin numbers assigned in "PIN" statement in design [name].
: [.br]

M IGNORING_UNCONNECTED_PIN
> name s
: [.br]
: The external module signal [name] pin was defined but not used in your design.
: [.br]

M CANNOT_OPEN_INPUT_FILE
> filename1 s
> filename2 s
: [.br]
: StateX is unable to open input file ([filename1]) or ([filename2]). [.br]
: You may run ahdl2x, blifoptx to obtain the files.
: [.br]

M CANNOT_OPEN_FILE
> filename s
: [.br]
: StateX is unable to open file ([filename]). Please check that the file exists
: and file permision allow reading.
: [.br]

M CANNOT_WRITE_TO_FILE
> filename s
: [.br]
: StateX is unable to write to output file [filename].  Please check that you have
: write permisson in the output directory.
: [.br]
 
M CANNOT_FIND_RESET_STATE
> statename s
: [.br]
: The reset state [statename] not declared.
: [.br]

M UNABLE_TO_REDUCE_FANIN
> modelname s
: [.br]
: StateX is unable to reduce the maximum fan-in for finite state machine
: in model [modelname] by state splitting.
: [.br]

M GATED_CLOCK_ENCOUNTERED
> clock s
: [.br]
: StateX encountered gated clock signal, [clock].
: [.br]

M NO_CLOCK_ON_DESIGN
> name s
: [.br]
: The [name] design has no clock.
: [.br]

M UNKNOWN_REG_PIN
> name s
: [.br]
: StateX encountered an illegal state register pin assignment, [name].
: Legal state register pin assignments are: CLK, CE, ASYNC and SYNC.
: [.br]

M NO_OE_2K_FSM
> name s
: [.br]
: StateX encountered an output enable assignment to state register in model
: [name].  The output enable is not available in symbolic state machines
: for the XC2000 family.
: [.br]

M NO_CE_2K_FSM
> name s
: [.br]
: StateX encountered clock enable assignment to state register in model
: [name].  The clock enable is not supported in symbolic state machines
: for the XC2000 family.
: [.br]

M UNSUPPORTED_COMBINATORIAL_ASSGN
> name s
: [.br]
: StateX encountered an unsupported combinatorial assignment for 
: the output signal [name].
: [.br]

M NO_INPUT_FOR_PIN
> name s
: [.br]
: There is no input signal for state register pin [name].
: Please see Xilinx ABEL manual for syntax for assigning state register pins.
: [.br]

M NO_PIN_FOR_INPUT
> name s
: [.br]
: There is no state register pin for input signal [name].
: [.br]

M ILLEGAL_PRODUCT_SYNTAX
> input s
> pstate s
> nstate s
> output s
: [.br]
: Illegal product term syntax encountered while assigning state 
: register pins.
: [.br]\"[input] [pstate] [nstate] [output]\"
: [.br]

M CORRUPTED_FSM_FILE
> name s
: [.br]
: No .kiss section found in design [name].
: [.br]

M MODEL_NAME_NOT_FOUND
> filename s
> lineno d
: [.br]
: There is no name for model at line [lineno] in file [filename].
: [.br]

M STATEX_DAT_FILE_CORRUPTED
> lineno d
: [.br]
: The statex.dat file is corrupted.  Error occurred at [lineno].
: [.br]

M NO_WRITE_TO_FILE
> filename s
: [.br]
: StateX cannot write to the file '[filename]'.  Some possible causes of this
: problem are a full disk or problems with writing
: over a network.
: [.br]

# Informational and Other Messages
: [.br]

M CHECKING_PARAMETERS
: [.br]
: Checking input parameters.
: [.br]

M READING_XSMFILE
: [.br]
: Loading the intermediate design file.
: [.br]

M NEW_SUBCKT
> name s
: [.br]
: Processing BLIF subckt:  [name].
: [.br]

M SPLITTING_STATES
: [.br]
: Trying to split any states with high fan-in.
: [.br]

M NO_STATE_SPLITTING_HAPPENED
: [.br]
: No state registers can be splited for delay reduction since
: the critical paths are not associated with any state registers. 
: [.br]

M REDUCING_STATES
: [.br]
: Attempting to remove redundant states in FSM.
: [.br]

M GREEDY_REDUCE
: [.br]
: Using Greedy Heuristic to reduce incompletely specified FSM.
: [.br]

M CLUSTERED_ENCODING
: [.br]
: State assignment using standard (clustered binary) encoding.
: [.br]

M SEQUENTIAL_ENCODING
: [.br]
: State assignment using sequential binary encoding.
: [.br]

M ONE_HOT_ENCODING
: [.br]
: State assignment using one-hot encoding.
: [.br]

M ENCODING_FSM
: [.br]
: Encoding state machine with given state assignment.
: [.br]

M FINISH_UP
: [.br]
: Cleaning up redundantly generated logic.
: [.br]

M WRITING_OUTPUT
: [.br]
: Writing output net list.
: [.br]

M WRITING_REPORT
> designname s
: [.br]
: Writing design report to file:  [designname].rep.
: [.br]

M ENCODING_ONE_HOT
> name s
: [.br]
: Encoding state machine [name] with one-hot encoding style.
: [.br]

M ENCODING_TWO_HOT
> name s
: [.br]
: Encoding state machine [name] with two-hot encoding style.
: [.br]

M WRITING_KISS_FILE
> name s
: [.br]
: Writing out kiss format file [name] for regression testing purposes only.
: [.br]

E STATEX
#
# ------------------ mxtool.m ------------------ 
#
#@(#)mxtool.m	6.8  1/13/94


B MXTOOL -start1726 -end1800 -current1744
: Tool Interface

# These message texts are used in other messages
M TEXT_PARAMFILE
: parameter file
M TEXT_CMDLINE
: command line
M TEXT_ILLBOOLVAL
: Illegal boolean value must be {TRUE,FALSE}: 
M TEXT_ILLINTVAL
: Illegal integer value: 
M TEXT_ILLOPTVAL
: Illegal option name must be 
M TEXT_ILLFLTVAL
: Illegal floating point value: 
M TEXT_UNKPARAM
: Unknown parameter name: 
M TEXT_UNSETPARAM
: Parameter was not assigned a value: 
M TEXT_BADVALUE
: Parameter was assigned an illegal value: 
M TEXT_BADRANGE
: Parameter value is outside valid range: 
M TEXT_PARAMHEAP
: Param
M TEXT_RESULTHEAP
: Result
M TEXT_INTERNALHEAP
: Intern
M TEXT_OTHERHEAP
: Other
M TEXT_BLANK
:

# There messages are used to produce help text for the root tool
M LOGFILE
: The program log file name
M HLOGFILE
: You can use this parameter to specify an alternate name for the program
: log file.  The default value of the log file name is the program name 
: with a .log extension
M PARAMFILE
: The parameter file name
M HPARAMFILE
: You can use this parameter to specify a file name which contains
: program parameters.  Each program parameter should appear on a line
: by itself with its value separated by an equals sign,
: E.g., "logfile=foobar.log".  If a program parameter is specified
: on the command line as well as in the parameter file, the value from
: the command line will be used.  If you do not specify a parameter file, 
: all of the programs parameters are taken from the command line.
M HELPALL
: Show all help information
M HHELPALL
: You can type "-helpall" to this tool to get help for ALL its parameters.
: The default is not to show help for all parameters.  
M HELP_NOVICE
> programname s
: For help on how to use this program, type "[programname] -help"
M HELP_TITLE
> programname s
: [.br]HELP FOR [programname][.br]
M HELP_PARAMS
: [.br]PARAMETERS:[.br]
M HELP_PARAMNAME
> param_internal_name s
> param_external_name s
: [param_internal_name][param_external_name]
M HELP_PARAMHELP
> param_help_text s
: [param_help_text]
M HELP_BITS
> leftmargin s
: [leftmargin]This parameter may be assigned one or more of these bit values:
: [.br]
M HELP_VALUES
> leftmargin s
: [leftmargin]This parameter may be assigned one of these values:
: [.br]
M HELP_STRVALUE
> leftmargin s
: [leftmargin]This parameter takes a character string value.
M HELP_FLTVALUE
> leftmargin s
> lo g.6
> hi g.6
: [leftmargin]Takes a real value between [lo] and [hi], inclusive.
M HELP_BOOLVALUE
> leftmargin s
: [leftmargin]This parameter takes a boolean value {TRUE,FALSE}
M HELP_INTVALUE
> leftmargin s
> lo d
> hi d
: [leftmargin]Takes an integer value between [lo] and [hi], inclusive.
M HELP_PINTVALUE
> leftmargin s
: [leftmargin]Takes a positive integer value.
M HELP_NNINTVALUE
> leftmargin s
: [leftmargin]Takes a non-negative integer value.
M HELP_DEFVALUE
> leftmargin s
> default    z
: [leftmargin]The default value is [default].
M HELP_DEFNONE
> leftmargin s
: [leftmargin]You must specify a value; there is no default.

# ---------------------------------------------------------------------------
# These messages are written to the plog at program startup
M LOG_BANNER
> prog_name    s
> prog_version s
> prod_name    m
> year         s
: [prog_name] [[[prog_version]]  --  [prod_name][.br]
: Copyright (c) [year] Xilinx Inc.  All Rights Reserved.

M LOG_CONFIDENTIAL
: XILINX CONFIDENTIAL

M LOG_XACT
: Xilinx Automatic CAE Tools

M PROGRAM_ENV
: Program Envelope Parameters

M PROGRAM_ENVENTRY
> name  s-20
> value s
: [name] = [value]

# ---------------------------------------------------------------------------
# These messages are written to the plog at tool startup
M TOOL_NEW_SECTION
> toolname s
: [toolname]
M TOOL_PARAMETERS
: Parameters
M TOOL_USED_EXPERT_PARAMS
: Additional Specified or Non-Default Parameters 
M TOOL_PARAMVALUE
> paramname  s
> paramvalue s
: [paramname][paramvalue]
M TOOL_TRUE
: TRUE
M TOOL_FALSE
: FALSE
M TOOL_PARAMBAR
: -----------------------

# ---------------------------------------------------------------------------
# These messages are used by the debug routine mxtool_dump_tool_table
M TOOLDEF_TITLE
: Tool Definition Table
M TOOLDEF_HEADER
# ALIGN COLUMN HEADERS WITH OPEN BRACKET
# V         V            V    V        V
# [toolname][toolversion][off][partype][parametername]
: Toolname  Version      Off  Type     Parameter[.br]
: --------  -----------  ---  -------  ---------
M TOOLDEF_ENTRY
> toolname      s-10.10
> toolversion   s-13.10
> off           s3
> partype       s-9.9
> parametername s
# DONT MESS WITH THIS MESSAGE TEXT!
: [toolname][toolversion][off]  [partype][parametername]
M TOOLINST_TITLE
: Tool Instances Remaining
M TOOLINST_HEADER
# ALIGN HEADERS WITH OPEN BRACKETS
# V     V         V
# [in]  [toolname][toolcreator]
: ---------------------------[.br]
: Inst  Toolname  Toolcreator[.br]
: ----  --------  -----------
M TOOLINST_ENTRY
> in          d4
> toolname    s-10
> toolcreator s
: [in]  [toolname][toolcreator]
M TOOLINST_FOOTER
: ---------------------------

# ---------------------------------------------------------------------------
# These messages are used to create the memory usage table for debug purposes
M MEMUSAGE_TITLE1
> name s
: Memory Usage For Tool [name]
M MEMUSAGE_TITLE2
> name s
: Memory Usage For Program [name]
M MEMUSAGE_HEADER
# [heap]      [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
: --------------------------------------------------------------------------[.br]
: Heap         Total   Total  Static   Alloc   Guard  Unused    Free   Alloc[.br]
: Name       Nsegmts  Nbytes  Overhd  Overhd  Overhd  Nbytes  Nbytes  Nbytes[.br]
: ---------- ------- ------- ------- ------- ------- ------- ------- -------
M MEMUSAGE_ENTRY
> heap s-10.10
> nseg d4
> size d6
> sohd d6
> aohd d6
> gohd d6
> unnb d6
> frnb d6
> alnb d6
: [heap]    [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
M MEMUSAGE_FOOTER
: --------------------------------------------------------------------------
M MEMUSAGE_MAX
> pgmname s
> nkbytes f.3
: [pgmname] required [[[nkbytes]] Kbytes of dynamic/allocated memory

# ---------------------------------------------------------------------------
# These are WARNING messages of various sorts
M PARAM_OBSOLETE_NEXT_RELEASE -w1726
: The "param=" syntax you used on the command line will become obsolete
: next release.  You should replace it with "paramfile="

M PARAM_IGNORED -w1727
: The "param=" syntax on the command line is being ignored since you
: have also specified the parameter file name using the "paramfile=" syntax

M PLOG_OBSOLETE_NEXT_RELEASE -w1728
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" syntax from the [paramsource] will become obsolete
: next release.  You should replace it with "logfile="

M PLOG_IGNORED -w1729
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" specification from the [paramsource] is being ignored since
: you have also specified the log file name using the "logfile=" syntax

# ---------------------------------------------------------------------------
# These are ERROR messages of various sorts
M PARAM_DECL_OFFSET -e1730
> toolname  s
> paramname s
> offset    d
> paramsize d
: Tool parameter declaration offset is illegal[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, but the parameter structure size[.br]
: is only [paramsize] bytes.  Something must be very, very wrong.

M PARAM_DECL_OVERLAP -e1731
> toolname  s
> paramname s
> offset    d
> index     d
: Tool parameter declaration overlaps another[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, which overlaps another parameter[.br]
: at an offset of [index] bytes.  Check your calls to tool_decl_* in[.br]
: the husk module of [toolname].  You have probably have the same parameter[.br]
: name in more than one of the tool_decl_* routine.

M PARAM_ERROR -e1732
> paramsource s # the TEXT_CMDLINE or TEXT_PARAMFILE message text
> theErrors   s
: The [paramsource] contains parameter assignment errors:[theErrors]

M PARAM_ERROR_MAINTOOL -e1733
> theTool   s
> theErrors s
: The [theTool] program detected parameter value errors:[theErrors]

M PARAM_ERROR_SUBTOOL -e1734
> currenttool s
> parenttool  s
> theErrors   s
: The [currenttool] tool, invoked from [parenttool],
: detected parameter value errors:[theErrors]

M PARAM_TOOMANY -e1735
> nspecified d
> ndefined   d
: The command line contains [nspecified] positional parameters,[.br]
: but the program only needs [ndefined] parameters.

M BAD_DASH_PARAM -e1736
> param z
: The command line parameter, '[param]', is a non-boolean '-' parameter.  Only
: boolean parameter can be specified using the '-' feature, where 
: '-<parameter>' is the equivalent of TRUE and '-NO<parameter>' is the 
: equivalent of FALSE.

M INSTANCE_MISMATCH -e1737
> instancenumber d
> instancename   s
> tooldefname    s
: Tool instance - tool definition mismatch[.br]
: Tool instance #[instancenumber] is not an instance of "[tooldefname]"[.br]
: but rather an instance of "[instancename]"

M INSTANCE_ILLEGAL -e1738
> instancenumber d
: Illegal tool instance number[.br]
: Tool instance #[instancenumber] does not refer to a valid tool

M PFILE_OPEN_FAILED -e1739
> filename s
: The parameter file "[filename]" could not be opened for input

M MISSING_VALUE -e1740
> paramname s
: The command line parameter named "[paramname]"[.br]
: must be followed by an equals sign and a value

M ILLEGAL_PARAMNAME -e1741
> paramname s
: An illegal program parameter name "[paramname]"[.br]
: is used on the command line

M PLOG_OPEN_FAILED -e1742
> filename s
: The program log file "[filename]"[.br]
: could not be opened for output

M ILLEGAL_OPTIONNAME -e1743
> optionname s
: An illegal option parameter name "[optionname]"[.br]
: is used on the command line

E MXTOOL
#
# ------------------ dm.m ------------------ 
#
# @(#)dm.m	6.4  9/3/93


B DM -start1161 -end1200 -current1187
: Data Manager 

M CANNOT_WRITE_TO_FILE -e1161 -w1162
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ADDHISTORY_FAILED -e1163 -w1164
> cellname z
> celltype s
: A history description could not be appended to the [celltype] cell
: "[cellname]" because it is a READONLY cell

M CLRHISTORY_FAILED -e1165 -w1166
> cellname z
> celltype s
: The history descriptions of the [celltype] cell "[cellname]" could not be
: cleared because it is a READONLY cell

M CLEAR_FAILED_RDONLY -e1167 -w1168
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be cleared because it is a
: READONLY cell

#M CLEAR_FAILED -e -w
#> cellname z
#> celltype s
#: The [celltype] cell "[cellname]" could not be cleared because it is
#: locked in memory

M DELETE_FAILED -e1169 -w1170
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be deleted because it is
: locked in memory

M FILE_ACCESS -e1171 -w1172
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: exists, but could not be opened

M FILE_MISSING -e1173 -w1174
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be found.

M FILE_OPEN_FAILED -e1175 -w1176
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be opened

M HEADER_CELLTYPENAME -e1177 -w1178
> cellname z
> filename z
> celltype s
: The celltype/cellname in the header of "[filename]" does not correspond
: to the expected "[celltype]"/"[cellname]"

M HEADER_ERROR -e1179 -w1180
> cellname z
> filename z
> celltype s
: The file "[filename]" for the [celltype] cell "[cellname]" contains an
: illegal header

M NAME_FAILED -e1181 -w1182
> cellname z
> newname  s
> celltype s
: The [celltype] cell "[cellname]" could not be renamed to "[newname]"
: because a [celltype] cell named "[newname]" already exists

M TYPE_FAILED -e1183 -w1184
> typename s
> cellname z
: The type of cell "[cellname]" could not be changed to "[typename]"
: because a cell of that name/type already exists

M NEWCELL_FAILED -e1185 -w1186
> cellname s
> celltype s
: The [celltype] cell "[cellname]" could not be created because a cell of
: that type and name already exists

#
# Data Manager Messages
#
M SAVECELL_SECTION
: Data Manager Auto Save

M SAVECELL
> cellname z
> typename s
: Saving [typename] cell "[cellname]"

M LOCKCOUNT_SECTION
: Data Manager Cell Lock Counts

M LOCKCOUNT
> cellname z-10
> typename s-10
> lockcount d2
: [cellname] [typename] [lockcount]

E DM




#
# ------------------ mxpart.m ------------------ 
#
#@(#)mxpart.m	6.2 9/3/93

B MXPART -start1131 -end1160 -current1148
: File reader for partlist.xct file and <package>.pkg files

M CANT_OPEN_FILE -e1131 -w1132
> filename s
: Cannot open file '[filename]' for reading.

M NO_PKG -e1133 -w1134
> part s
> filename s
: The part '[part]' could not be found in the file '[filename]'.

M BAD_ATTRIB_VALUE -e1135 -w1136
> partname s
> filename s
: The attribute list (name=value entries) for the part '[partname]' in the
: file '[filename]' has the wrong format.

M ILLEGAL_PKG_KEYWORD -e1137 -w1138
> value s
: Illegal keyword '[value]' exists in the .pkg file.
 
M DUP_PAD_DEF_IN_PKG -e1139
> pad s
: Duplicate definition of PAD '[pad]'.

M DUP_PIN_DEF_IN_PKG -e1140
> pin s
: Duplicate definition of PIN '[pin]'.

M PAD_NUM_OUT_OF_RANGE -e1141
> pad s
: Pad number '[pad]' is out of range.

M BAD_PAD_NUM -e1142
> pad s
: Bad pad number '[pad]'. Should be in the form: PAD<number>.

M WRONG_ATTR_VALUE -e1143
> value s
> chk_value s
: Attribute value '[value]' does not match check value '[chk_value]'.

M ILLEGAL_FAMILY -e1144
> family d
: Not a legal family '[family]'.

M ILLEGAL_FAMILY_ATTR -e1145
> attrib s
> family d 
: Not a legal attribute '[attrib]' for this family '[family]'.

M BAD_ROWCOL -e1146
: Not and integer value for clb row|cols number.

M CLK_BUF -e1147
> pad s
> padn d
: Clock Buffer using '[pad]' should use 'PAD[padn]'.

E MXPART
#
# ------------------ speed.m ------------------ 
#
#@(#)speed.m	6.4  9/3/93

B SPEED -start 1101 -end1130 -current14
: File reader for speeds.xct file 

M CANT_OPEN_FILE -e0 -w1
> filename s
: Cannot open file '[filename]' for reading.

M FILE_CORRUPTED -e2 -w3
> filename s
: The speeds file '[filename]' has been corrupted and cannot be read.

M CANT_READ_FILE -e4 -w5
> filename s
: The unencrypted speeds file '[filename]' cannot be read.

M BAD_PARTLIST_FILE -e6 -w7
: The partlist.xct file does not contain the correct information.

M UNKNOWN_SPEED_AND_PART -e8 -w9
> speed s
> part s
: The speed '[speed]' is unavailable for part '[part]'.

M BAD_VERSION -e10 -w11
> filename s
> badversion s
> version s
: The '[filename]' file has a bad version, '[badversion]'.
: The version of file must be '[version]'.

M SYNTAX_ERROR -e12 -w13
> filename s
: There is a syntax error in the '[filename]' speeds file.

E SPEED
