# xblox.ml created 1994/05/13 19:30:09
# 
# DO NOT EDIT THIS FILE!  It is derived from other files.
#
# ------------------ alert.m ------------------ 
#
#@(#)alert.m	6.1  12/2/92


B ALERT
: Error condition alert system

#
# These messages are used as alert pre/postfixes
#
M CANNOT_CONTINUE
: Execution cannot continue until this error is fixed
M TERMINATE
> theProgram s
> theStatus s
: [theProgram] was terminated with a [theStatus] status

E ALERT
#
# ------------------ feature.m ------------------ 
#
# @(#)feature.m	6.3 9/3/93


B FEATURE -start1051 -end1100 -current1082
: Feature License Manager

#
# Nasty Low-Level Error Messages
#
M UNKNOWN_ERROR -e1051
> feature s
: License checkout for feature "[feature]" failed[.br]
: because of some, unknown error condition.  
: Please contact your system administrator for help.
M OS_ERROR -e1052
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level or operating system error ([errtext]).
: Please contact your system administrator for help.
M BAD_SERVER_DATA_ERROR -e1053
> feature s
: License checkout for feature "[feature]" failed[.br]
: because invalid data was returned from the license server .
: Please contact your system administrator for help.
M READ_SERVER_ERROR -e1054
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot read from the servers listed in the license data 
: file.  Please contact your system adminstrator for help.
M WRITE_SERVER_ERROR -e1055
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] cannot write to the servers listed in the license data 
: file.  Please contact your system adminsitrator for help.
M SELECT_ROUTINE_ERROR -e1056
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] a call to an internal select routine failed.
: Please contact your system adminsitrator for help.
M BUSY_SERVER_ERROR -e1057
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] failed to connect to a majority of the servers listed in the
: license data file.  Please contact your system adminsitrator for help.
M CHECKIN_FEATURE_ERROR -e1058
> feature s
: License checkin for feature "[feature]" failed[.br]
: Don't worry, be happy.

#
# Possible User Errors
#
M NO_LICENSE_FILE_ERROR -e1059
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the license data file.
: The default location for this file is usually
: /usr/local/data/license.dat.  It may be placed elsewhere at your site, in 
: which case you must define the environmental variable LM_LICENSE_FILE to
: point to it.  Make sure you can access the file from the same shell you are
: trying to run the program.
M NO_FEATURE_ERROR -e1060
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the feature in the license data
: file.  If you have not yet called customer
: service to obtain the authorization codes for this feature please do so.  If
: you have obtained the codes, please make sure that you have added the codes
: to the license data file.
M LICENSES_EXHAUSTED_ERROR -e1061
> feature s
: License checkout for feature "[feature]" failed[.br]
: because all the valid licenses for the feature are currently in use.  
: Try again later.
M EXPIRED_AUTHCODE_ERROR -e1062
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the required license has expired.  
: Please call customer service to obtain a new license.
M UNSUPPORTED_VERSION_ERROR -e1063
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the license data file does not contain a feature of the required
: version number.  Please call custommer service to obtain a license for 
: the new version of the feature.
M NO_KEY_ERROR -e1064
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program could not find a valid Xilinx protection key
: on the parallel port of your computer.  
: Please make sure that the key is attached securely to the parallel port.
M TAMPERED_KEY_ERROR -e1065
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the [program] program detected an invalid Xilinx protection key
: on the parallel port of your computer.  
: The key's memory has been corrupted.  Please call customer service to
: obtain a new key.
M DEMO_EXPIRED_ERROR -e1066
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because your demo version of the [program] program has expired.
: Please contact customer service
: or your sales representative to purchase the software you have been
: using.
M TAMPERED_DATE_ERROR -e1067
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the current date on your computer is set to a time which is
: before the date when you last ran this program.   
: Please reset your computer's date to the current
: date and rerun the program.
M XACT_VARIABLE_ERROR -e1068
> feature s
: License checkout for feature "[feature]" failed[.br]
: because the XACT environmental variable has not been defined.
: Use the SET XACT=value dos command 
: to define the location of the XACT software.
M INVALID_DATE_ERROR -e1069
> feature s
: License checkout for feature "[feature]" failed[.br]
: because line in the license data file line which describes the feature
: contains an invalid date.  See the file XACT\data\license.dat.  
: All dates must be of the form 
: DD-MMM-YYYY, where DD is an integer 0-31; MMM is the first three 
: letters of the (English) month name: JAN, FEB, MAR, APR, MAY, JUN, JUL,
: AUG, SEP, OCT, NOV, or DEC; and YYYY is an integer 1990-2118.
M LOLEVEL_ERROR -e1070
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: because of some low-level error ([errtext]).

#
# Possible Installation Errors
#
M MULT_FEATURE_ERROR -e1071
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected multiple occurences of FEATURE lines for the 
: feature in the license file.  A feature
: may appear only once in the license file for it to be valid.  Please remove
: one of the feature lines from the license file.
M LICENSE_FILE_SYNTAX_ERROR -e1072
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected a syntax error in the license date
: file.  Please make sure that you have 
: correctly entered the authorization codes which you obtained from customer 
: service.
M NO_SERVER_ERROR -e1073
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect to the network license server.  
: Please make sure that the lmgrd program is 
: currently running on the computers described as servers in the license data 
: file.
M NO_SERVICE_ERROR -e1074
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because the program [program] could not find the TCP "license" service. 
: Make sure that the /etc/services file has
: the license service number defined in it, or add a socket number to the the
: SERVER line of the license data file.
M BAD_AUTHCODE_ERROR -e1075
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] detected an inconsistency in the authorization code on the
: feature line of the license data file.  
: Please make sure that you have correctly entered the authorization codes
: which you obtained from customer service.
M WRONG_HOST_ERROR -e1076
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find the host listed in one of the
: server lines of the license data file.  
: Please make sure that the server information in the license data file is 
: correct.
M BAD_DATE_ERROR -e1077
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] found an invalid date in the license data file.  
: Please make sure that the date information in the
: license data file is correct.  The correct date format is DD-MMM-YY (for
: example 30-JUN-91).  In previous versions of the program, dates of the form
: DD-MMM-YYYY were acceptable, but they are no longer.  To make the correction,
: stop the license server, edit the license.dat file to remove the '19' from
: the year number of all features, restart the license server and rerun the 
: program.
M NO_SERVER_LINES_ERROR -e1078
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not find and server lines in the license data file.  
: Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M BAD_SERVER_NAME_ERROR -e1079
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] encountered an illegal server name in the license 
: data file.  Please make sure that you have correctly
: entered the all of authorization code information which you obtained from
: customer service.
M CONNECT_SERVER_ERROR -e1080
> feature s
> program s
: License checkout for feature "[feature]" failed[.br]
: because [program] could not connect over the network to the license server
: program.  Please make sure that the lmgrd 
: program is currently running on the computers described as servers in the
: license data file.

#
# Error due to PC key
#
M PC_KEY_ERROR -e1081
> feature s
> errtext s
: License checkout for feature "[feature]" failed[.br]
: [errtext]

E FEATURE
#
# ------------------ msg.m ------------------ 
#
#@(#)msg.m	6.3 9/3/93


B MSG -start1011 -end1030 -current1016
: The Message System Messages

#
# Message fragments for the MSGFILE error
M MSGIO_EOLJUNK
: Extra characters at the end of a valid line
M MSGIO_UNKNOWN_LINE
: Unknown message file line type
M MSGIO_MSGSET_NAME
: Message set name is required
M MSGIO_MSGDEF_NAME
: Message definition name is required
M MSGIO_MSGARG_NAME
: Message definition argument name is required
M MSGIO_MSGARG_TYPE
: Message definition argument type is required
M MSGIO_UNKNOWN
: Unknown error number

#
# These messages are used by the message system when something goes
# wrong while reading a message file, or instantiating a message
#

M MSGFILE_ERROR -e1011
> theErrorName  m
> theLineNumber d
> theFileName   s
> theLine       s
> thePosition   z
: [theErrorName][.br]
: The error is on Line [theLineNumber] of "[theFileName]"[.br]
: The line is "[theLine]"[.br]
: -------------[thePosition]
M MSGSET_MISSING -e1012
> theCompName s
: The message set for "[theCompName]" does not exist [.br]
: in any of the standard message files.
M MSGSET_NULL
> theCompNumber d
> theCompName s
: The message set pointer for component [theCompNumber], "[theCompName]"[.br]
: does not point to a valid message set.
M MSGSET_NDEFS -e1013
> theMsgnum d
> theMsgname s
> theNumberOfDefs d
> theCompName s
: An attempt was made to invoke message "[theMsgname]",[.br]
: with a message number of [theMsgnum].  However, the message set for[.br]
: component "[theCompName]" has only [theNumberOfDefs] messages.
M MSGSET_MSGNAMES -e1014
> theMsgnum d
> theMsgname s
> theRealMsgname s
> theCompName s
: Message #[theMsgnum] of the message set for component "[theCompName]"[.br]
: was invoked with a name of "[theMsgname]".  Its name in the message[.br]
: file is "[theRealMsgname]".
M MSGSET_NPARAMS -e1015
> theMsgname s
> theNparams d
> theRealNum d
> theCompName s
: Message "[theMsgname]" of the message set for component "[theCompName]"[.br]
: was invoked with [theNparams] parameters.  It is defined with [theRealNum]
: in the message file.

#
# Message id severity names
# These are used in the creation of errors to describe how severe the
# error really is.  THE ORDER OF THESE NAMES IS VERY, VERY IMPORTANT.
# SEE MSGINST_SEVERITY IN MSGINST.C IF YOU DON'T BELIEVE ME.
#

M MSGSEV_INFO
: Information
M MSGSEV_WARNING
: WARNING
M MSGSEV_ERROR
: ERROR
M MSGSEV_FATAL
: Fatal Error
M MSGSEV_INTERNAL
: Internal Error

E MSG
#
# ------------------ mxcomm.m ------------------ 
#
# @(#)mxcomm.m	6.2  9/3/93


B MXCOMM -start1001 -end1010 -current1003
: Mx Program Communications

# Boolean values
M TRUE_VALUES
: Y YES T TRUE ON
M FALSE_VALUES
: N NO F FALSE OFF

# These two messages are used in rwdict error messages
M STARTUP_NAME
: startup file

# These error messages are used by mxaccs directly
M STARTUP_OPEN_FAILED -e1001
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: exists, but could not be opened for some reason

M NO_STARTUP_FILE -e1002
> filename z
: The Xilinx Automatic CAE Tools initialization file "[filename]"[.br]
: does not exist, so it could not be opened

E MXCOMM
#
# ------------------ report.m ------------------ 
#
#@(#)report.m	6.1  12/2/92
 
 
B REPORT
: Report Generator Messages
 
M PAGE
: Page
M CONTINUED
: (continued)
M XILINX
: Xilinx, Inc.
M COPYRIGHT
> year d
: (c) Copyright [year].  All Rights Reserved.
M TABLE_OF_CONTENTS
: Table of Contents[.br]
: -----------------[.br]
M TOC_ENTRY
> entry s
: [entry]
E REPORT
#
# ------------------ rwdict.m ------------------ 
#
#TMF 1.0
# @(#)rwdict.m	6.2  9/3/93


B RWDICT -start1031 -end1050 -current1035
: Dictionary File Reader/Writer

M MISSING_EQUALSIGN -e1031 -w1032
> linenumber d
> filename   s
> dicttype   s
> line       s
: Missing equal sign in the name-value assignment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[line]"

M ILLEGAL_NAME -e1033 -w1034
> linenumber d
> filename   s
> dicttype   s
> name       s
: Illegal name used in the name-value assigment[.br]
: in the [dicttype] "[filename]" at line [linenumber][.br]
: "[name]"


E RWDICT
#
# ------------------ xblox.m ------------------ 
#
#@(#)xblox.m	6.219	5/5/94


B XBLOX -start20001 -end25000 -current20374
: C version of TOOL_NAME

# Tool description (for program help)
M DESCRIPTION
: This tool takes an XNF file that can include X-BLOX symbols and
: does architectural optimizations specific to Xilinx parts, then
: performs module generation, followed by a second round of
: architectural optimizations.  For more information, see the
: X-BLOX manual.[.br]
: USAGE: xblox <infile> [[<outfile>] [[<parameter>=<value> ...]

##################################
# External Parameter Names
M INFILE
: Input XNF file name

M OUTFILE
: Output XG file name

M SUBSCRIPTS
: Use brackets for bus subscripts.

M SIM
: If SIM=XNF, an XGS functional simulation file is produced.

M SIMDIR
: Directory to place functional simulation files.

M SIM_RERUN
: Recreate all functional simulation models.

M SIMDIR_NOSIM
: Command line parameter SIMDIR may be not used without the command-line
: parameter SIM=XNF.

M ARCHOPT
: archopt flag

M MERGEIO
: merge flip flops into IOBs flag

M MODGEN
: modgen flag

M REG_RLOC
: generate RPMs for modules without carry logic

M PARTTYPE
: Target LCA device

M LANGUAGE
: Language

M BLXFILE
: User-provided X-BLOX message file name

#########################
# Help Messages
# What does this parameter do?  This parameter...(verbose multi-liner)

M HINFILE
: This should either be `file.xtf', `file' with an implied `.xtf'
: extension, or the full filename of a non-xtf file.
: The contents of the file have to conform to XNF specifications.

M HOUTFILE
: This should either be `file.xg', `file' with an implied `.xg'
: extension, or the full filename of a non-xg file.  The default is
: the INFILE name with a `.xg' extension in place of the `.xtf'
: extension.  The contents are in the XNF syntax.

M HSUBSCRIPTS
: Enables generation of brackets around bus subscripts.
: If set to 0 or FALSE, X-BLOX will not use the subscripts when expanding
: an X-BLOX bus into its constituent nets.

M HSIM
: If used, it should be set to XNF.
: When set, X-BLOX will produce an XGS
: functional simulation file.  No architectural optimizations will
: be performed, and no XG file will be written.  By default, no XGS file is
: produced.

M HSIMDIR
: Used in combination with SIM=XNF only.  Many files are produced for
: functional simulation.  By default, these are placed into a subdirectory
: named <outfile>.bsm.  This can be changed by setting SIMDIR to another
: value.  For example `SIMDIR=.'  will place the functional simulation
: files in the current directory.

M HSIM_RERUN
: Used in combination with SIM=XNF only.  Many files are produced for
: functional simulation.  By default, X-BLOX will reuse these files on 
: subsequent executions. If SIM_RERUN=TRUE then these files will be recreated
: instead. Use this option when the files have become corrupted do to 
: system failure. The default is SIM_RERUN=FALSE. 

M HBLXFILE
: This parameter allows the user to specify the name of the file into
: which X-BLOX writes a report.  If provided, no file extension is
: added.  By default, this file is called <infile>.blx.

M HARCHOPT
: This allows the architectural optimizations to occur.
: If set to 0 or FALSE X-BLOX will not do any architectural optimizations.

M HMERGEIO
: This allows the flip flops to be merged, if possible, into the IOBs.
: If set to 0 or FALSE, this parameter prevents the flip flops from
: being merged into any IOBs.  This option does not affect DATA_REG modules
: whose STYLE has been set.

M HMODGEN
: This allows the module generation to occur.
: If set to 0 or FALSE this will prevent any modules from being expanded
: or special symbols from being evaluated.  This should be used only if
: there are no X-BLOX symbols in the design.

M HREG_RLOC
: Allows X-BLOX to generate RPMs for modules that don't contain carry logic. 
: These modules are DATA_REG, SHIFT, CLK_DIV, and COUNTER for STYLEs other
: than BINARY. The default is TRUE. RPMs for these modules result in higher
: performance. Set this parameter to FALSE if PPR is 
: unable to place all RPMs in the design. An alternative is to place the 
: attribute USE_RLOC=FALSE on some modules in your design. 

M HPARTTYPE
: If specified, this part type will take precedence over the part
: specified in the input XNF file.  The default part type is "4005pg156".
# The default part is assigned by the prolog part of X-BLOX.

M HLANGUAGE
: This specifies the language that will be used for all of the
: messages to the user.  Currently, only english is supported.
# M HSPEED
# : The appropriate speed grade of part.  The default is "-7".
# M HCONSTRAINTS
# : The name of the file that contains the constraints for the current
# : execution of this program.  The format for this file is still to be
# : determined.

###################
# Informational and Other Messages

M BLOG_FILE
> basename s
: Refer to the X-BLOX output in `[basename]'.

# Error and Warning Messages
M ERRORLOG -e20099
: X-BLOX could not process the design.

M SUCCESSLOG
: X-BLOX processed the design successfully.

# These are used by the Prolog message system to pass things to mx
M XBLOX_ERROR -e20100
> error_string s
: [error_string]

# Used when Quintus Prolog produced the error
M XBLOX_Q_ERROR -e20101
> error_string s
: [error_string]

# Used when Quintus Prolog produced the error
M XBLOX_Q_WARNING -w20102
> error_string s
: [error_string]

# Used for other types of quintus messages
M XBLOX_Q
> msg_string s
: [msg_string]

####################
# Generic messages

M bad_msg_inst -e20263
> MsgName s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [MsgName]

M XBLOX_INTERNAL -e20241
> error_string s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [error_string]

M XBLOX_UNKNOWN -e20370
> class s
> text s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [class][.br]
: 2. [text]

M no_xblox_license -e20103
: There are X-BLOX symbols in the design.  However, there
: is no valid license to process these symbols.

M nl
:

M no_modgen -e20366
: There are X-BLOX symbols in the design.  However, the modgen parameter
: has been set to FALSE.  Modgen may be set to FALSE only if there
: are no X-BLOX symbols in the design.

M unknown_predicate -e20337
>Predicate s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Predicate]


##############################
# progress reports

M system_header
> prog s
> version s
: [prog](tm) -- Blocks of Logic Optimized for Xilinx (Version: [version])[.br]
: X-BLOX (c) 1990-1994 by Xilinx, Inc.  All Rights Reserved.
: U.S. and Foreign Patents Pending.[.br]

M header_banner
: =============================================

M xif_header
> prog s
: CREATING THE [prog] internal database ...

M prop_data_types
: DEDUCING THE BUS WIDTHS ...

M archopt_header
: IMPROVING YOUR DESIGN by using the special features on the
: XILINX device.

M archopt_checking_for_resource
> Resource s
: CHECKING IF [Resource] can be used ...

M archopt_regs
: MOVING FLIP-FLOPS into the input/output blocks (IOBs) where possible...

M expanding_modules
> PROGNM s
: EXPANDING THE [PROGNM] modules into optimized logic functions

M module_expansion_failed -e20104
> Symbol s
> Type s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol][.br]
: 2. [Type].

M simulation_expansion_failed -e20105
> Symbol s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol].

M merging_modules
: MODULE EXPANSION IS COMPLETE, merging modules into a single design.
: This process can take a few minutes on a large design ...[.br]

M synthesis_errors -e20204
: The expansion and optimization phase has finished.  However design errors
: were detected.  X-BLOX cannot proceed until
: the errors are corrected.[.br]
: Cleaning up internals...[.br]
: This process can take a few minutes on a large design ...

M expanding_simulation_models
> PROGNM s
: EXPANDING THE [PROGNM] symbols into functional simulation models ...

M write_xnf
: WRITING THE IMPROVED AND EXPANDED DESIGN to a Xilinx Netlist Format file.

M synthesis_done
> prog s
: [prog] EXPANSION AND OPTIMIZATION IS COMPLETE.

M system_halted
> prog s
: [prog] System Halted ----

M system_halted_errors -e20106
> PROGNM s
> LogFileName s
: [PROGNM] WAS HALTED DUE TO ERRORS.
: Please check the log file [LogFileName] and correct the errors
: before running [PROGNM] again.

M system_halted_errors_log -e20198
> PROGNM s
: [PROGNM] WAS HALTED DUE TO ERRORS.
: Please check the error messages in this log file and correct the errors
: before running [PROGNM] again.

M internal_quintus_exception -e20224
> ErrorString s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [ErrorString]

M internal_call_mx_failed -e20245
> Class s
> ErrorString s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Class][.br]
: 2. [ErrorString]

M unsupported_qp_term_type -e20246
> Type s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Type]

M xblox_msg_inst_failed -e20247
> Type s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Type]

M xblox_print_msg_inst_failed -e20248
> Type s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Type]

M out_of_memory -e20244
: Out of memory


##########################
# report messages

M TITLE
> designname s
> version s
: X-BLOX for Design [designname][.br]
: From X-BLOX Version [version]

M err_chapter
: Errors[.br]
: ------[.br]

M warn_chapter
: Warnings[.br]
: --------[.br]

M trim_chapter
: Signal Trimming[.br]
: ---------------[.br]

M datatype_chapter
: Data Type Propagation and Signal Aliases[.br]
: ----------------------------------------[.br]

M archopt_chapter
: Architectural Optimizations and Merging of Flip Flops into IOB[.br]
: --------------------------------------------------------------[.br]

M modgen_chapter
: Module Synthesis and Module Generation[.br]
: --------------------------------------[.br]

M modgen_resources
> Symbol s
> Type s
: The following resources were generated for symbol [Symbol] (type=[Type]):

M no_modules_synthesized
: No modules were synthesized.

M resource_primitives_count
> TypeText s
> Count s
: [Count] [TypeText] primitives

M resource_primitive_count
> TypeText s
> Count s
: [Count] [TypeText] primitive

M defaults_chapter
: Defaults[.br]
: --------[.br]

M inferred_chapter
: Data Type Inferences[.br]
: --------------------[.br]

M SECTION
> sectionname s
: Section [sectionname][.br]
: ---------------------[.br]

M unknown_chapter -e20289
> Chapter s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Chapter]


###########################
# symbol errors

M error_on_symbol -e20013
> Symbol s
> Type s
: The [Type] symbol named [Symbol] has the following errors:

M warning_on_symbol -w20148
> Symbol s
> Type s
: The [Type] symbol named [Symbol] has the following warnings:

M symbol_information
> Symbol s
> Type s
> Message s
: The [Type] symbol named [Symbol] is [Message]

M disable_by_no_connections -e20261
: The symbol is disabled because it is not connected to any signals.

M disable_by_two_no_connects -e20369
> Pin1 s
> Pin2 s
: The symbol is disabled because the [Pin1] and [Pin2] pins are not
: connected to any signals.

M disable_by_no_connect -e20014
> pin s
: The symbol is disabled because the [pin] pin is unconnected.

M disable_by_no_outputs -e20187
> Pins s
: The symbol is disabled because none of the output pins ([Pins])
: are connected.

M disable_by_high -e20015
> pin s
: The symbol is disabled because the [pin] pin is tied to a logic High.

M disable_by_low -e20016
> pin s
: The symbol is disabled because the [pin] pin is tied to a logic Low.

M no_in_or_out_on_bidirio -e20361
> pin1 s
> pin2 s
> oe s
: The symbol has neither the [pin1] nor the [pin2] pins connected but the
: [oe] pin is connected.  One of either the [pin1] or [pin2] pins must be
: connected.  Check the Logic Trimming chapter of the log file to see if one
: of these signals were trimmed.

M warn_low -w20222
> Symbol s
> Pin s
> Signal s
: The [Pin] pin on symbol [Symbol] will be ignored because the signal
: connected to it ([Signal]) is tied Low.

M connection_ignored_for_merging -w20149
> Value s
> Pin s
> Signal s
> Symbol s
: The [Pin] pin on the flip-flop symbol [Symbol], connected to [Signal]
: is tied to [Value].
: This connection is being ignored and the flip-flop will be merged
: into an IOB.

M attribute_ignored_for_style
> Symbol s
> SymbolType s
> Style s
> Attribute s
> Value s
: Symbol `[Symbol]' (type=[SymbolType]) has the attribute `STYLE=[Style]'.
: For that style, the
: assigned Value of [Value] for the attribute [Attribute] is being
: ignored.

M not_proper_for_style
> Symbol s
> MultiSignals s
: Symbol `[Symbol]' has both [MultiSignals], which cannot be connected at
: the same time.

M not_valid_for_style
> Symbol s
> Style s
> MultiSignals s
: Symbol `[Symbol]' is of style [Style].  For this style, [MultiSignals]
: cannot be connected at the same time.

M invalid_style
> Style s
> Arch s
: STYLE=[Style] is invalid on a [Arch].

M compare_style_ignored_two_comp -w20001
> Symbol s
> Style s
> Ain s
> Bin s
: The STYLE attribute (value=[Style]) on symbol `[Symbol]' (type=COMPARE,
: input signals [Ain] and [Bin]) is being ignored because that style is not
: supported for TWO_COMP comparison.  The inputs have ENCODING=TWO_COMP,
: therefore STYLE=ARITH has been automatically chosen because it is the only
: style that supports two's complement numbers.

M compare_bad_style -w20002
> Symbol s
> Style s
> Ain s
> Bin s
> Styles s
: The STYLE attribute (value = [Style]) on symbol `[Symbol]' (type=COMPARE,
: input signals [Ain] and [Bin]) is invalid.  The possible values
: are [Styles].

M compare_bad_arch_style -w20146
> Symbol s
> Style s
> Ain s
> Bin s
> Arch s
> Styles s
: The STYLE attribute (value = [Style]) on  symbol `[Symbol]' (type=COMPARE,
: input signals [Ain] and [Bin]) is invalid for [Arch] family parts.
: The possible values are [Styles].

M compare_arithwired_obsolete -w20003
> Symbol s
> Ain s
> Bin s
: Symbol `[Symbol]', (type=COMPARE) (input signals [Ain] and [Bin]) has
: the attribute STYLE=ARITHWIRED.  This style is obsolete.  STYLE=ARITH
: will be used instead.

M connection_not_allowed -e20252
> Symbol s
> Style s
> Signal s
: Symbol `[Symbol]' is of style [Style].  For this style, The connection to
: [Signal] is not allowed.

M not_valid_param -e20017
> Symbol s
> SymbolType s
> Attr s
> Value s
: Symbol `[Symbol]' (type=[SymbolType]) has an attribute [Attr]=[Value].
: This is not a valid attribute value for the [Attr] attribute.

M not_valid_attribute -e20276
> Symbol s
> SymbolType s
> Attr1 s
> Value s
> Relation s
> Attr2 s
: Symbol `[Symbol]' (type=[SymbolType]) has an attribute [Attr1]=[Value].
: This is not a valid [Attr1] attribute value.  The [Attr1] attribute value
: must be [Relation] the [Attr2] attribute value.

M no_parameter -e20253
> Symbol s
> SymbolType s
> Attr s
: Symbol `[Symbol]' (type=[SymbolType]) has an undefined [Attr] attribute.
: This attribute must be defined.

M values_truncated -w20249
: The following symbol(s) has(have) attribute values that are too wide for the
: symbols.  The values have been truncated, leaving their least-significant
: bit(s).

M value_truncated_hdr
: Symbol                Type     Attribute    Width    Value[.br]
: -------------------- -------- ------------ -------- --------------------

M value_truncated
> Symbol s-20
> Type s-8
> Attr s-12
> Value s
> Width s-8
: [Symbol] [Type] [Attr] [Width] [Value]

M bad_divide_by_value -e20254
> Symbol s
> SymbolType s
> Attr s
> Value s
: The attribute [Attr] on the [SymbolType] symbol [Symbol] has been assigned
: the value [Value].  The value of the [Attr] attribute should be a
: positive integer greater than one.

M bad_lfsr_param_value -e20018
> Symbol s
> Type s
> Style s
> Attr s
> Value s
: The [Type] symbol named [Symbol] which is being expanded in the [Style]
: style has a value for the [Attr] attribute of [Value]. No value is allowed
: for this attribute with this style.

M inform_sync_value -w20232
> Symbol s
> Type s
> Style s
> Attr s
> Value s
> Pin s
: The [Type] symbol named [Symbol] that is being expanded in the [Style]
: style has a value for the [Attr] attribute of [Value], however the [Pin]
: is not connected. This value will be ignored.

M not_valid_pin -w20262
> Symbol s
> SymbolType s
> Style s
> PinName s
: Symbol `[Symbol]' (type=[SymbolType]) has the attribute STYLE=[Style],
: which is not allowed with the usage of pin [PinName].

M not_allowed -w20020
> Symbol s
> SymbolType s
> ItemType s
> Item s
: Symbol `[Symbol]' of type [SymbolType] has the [ItemType] [Item], which
: is not allowed. It is being ignored.

M invalid_LFSR_width -e20021
> Symbol s
> Width s
: Symbol `[Symbol]' (type=COUNTER) has style LFSR.  The current width of
: [Width] bits is not supported.  The valid widths are between 1 bit
: and 30 bits.  Please refer to the X-BLOX documentation to design LFSR
: counters bigger than 30 bits.

M style_not_supported -e20022
> Style s
> Arch s
> Symbol s
: The STYLE [Style] is not supported for [Arch] modules.  This attribute
: was found on symbol [Symbol].

M incorrect_usage_of_compare -e20023
> Symbol s
> Type s
> Style s
> ProperList s
> ConnList s
: Symbol `[Symbol]' (type=[Type]) has STYLE=[Style].  For the [Style] style,
: only the following connections are valid.  [ProperList][.br]
: The current connections to the [Type] symbol include: [ConnList].

M one_hot_compare_equality_only -e20250
> Symbol s
: Symbol `[Symbol]' (type=COMPARE) has input signals with ENCODING=ONE_HOT.
: For this data type connections to only the A_EQ_B and A_NE_B outputs are
: valid.

M one_input_but_not_other -e20024
> Pin1 s
> Pin2 s
: A signal is connected to the [Pin1] pin, but there is no active or saved
: signal connected to the [Pin2] pin.

M no_data_input -e20025
> Pin s
: The symbol is missing its [Pin] data input.

M no_data_output -e20026
> Pin s
: The symbol is missing its [Pin] data output.

M enabled_but_no_data_output -e20275
> Pin s
> Pin2 s
: The symbol's [Pin] output pin is disconnected, but the [Pin2] pin is
: connected.  If you are not using the [Pin] pin, you should also not use
: the [Pin2] pin.

M no_data_outputs_at_least_one -e20150
> Signal s
: The symbol has no connection to the [Signal] data outputs.  It requires
: that at least one be connected.

M missing_control_input -e20027
> Signal s
: The symbol is missing its [Signal] control input.

M find_width_error -e20362
> Symbol s
> Type s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol][.br]
: 2. [Type]

M width_inconsistent_with_modulus -e20004
> Symbol s
> Style s
> Pin s
> Width s
> Modulus s
: Symbol `[Symbol]' (type=COUNTER, STYLE=[Style]) has width=[Width], which
: is inconsistent with the COUNT_TO attribute value of [Modulus].  The width
: is defined by the size of the bus connected to the [Pin] pin, or if that
: pin is unconnected the size is determined by the BOUNDS attribute on the
: symbol.  If this attribute is unset and the Q_OUT pin is unconnected then
: X-BLOX will determine the correct width from the COUNT_TO attribute.

M johnson_width_modulus_dependency -e20005
: For STYLE=JOHNSON the width of a signal connected to the D_IN or Q_OUT pins
: must be the greatest integer less than or equal to (COUNT_TO + 1) / 2.

M illegal_johnson_reset_value_main -e20229
: The following COUNTER symbols are being implemented as STYLE=JOHNSON and
: have an
: ASYNC_VAL or SYNC_VAL attribute that is not a legal sequence value for a
: JOHNSON counter.  Legal values have a binary representation in the given
: data type that is either[.br]
: All 0's or[.br]
: All 1's or [.br]
: 0's followed by only 1's or[.br]
: 1's followed by only 0's[.br]
:[.br]
: If the symbol has STYLE=JOHNSON, then you must change the ASYNC_VAL or
: SYNC_VAL. If the 
: STYLE attribute was unassigned then you may either change the ASYNC_VAL or
: SYNC_VAL values, or assign STYLE=BINARY.[.br]

M illegal_johnson_reset_value_hdr
: Symbol               Attribute Attribute Value  Data Type[.br]
: -------------------- --------- ---------------- --------------------

M illegal_johnson_reset_value
> Symbol s-20
> SyncOrAsync s-9
> Value s-16
> DataType s
: [Symbol] [SyncOrAsync] [Value] [DataType]

M invalid_1hot_counter_val -e20347
> Symbol s
> SyncOrAsync s
> Value s
> OtherText s
: Symbol `[Symbol]' (type=COUNTER, STYLE=ONE_HOT) has the attribute
: [SyncOrAsync]=[Value].  This is not a legal sequence value for a ONE_HOT
: counter.  If you want to set [SyncOrAsync] to [Value], set STYLE=BINARY
: [OtherText]

M count_to_ignored -w20237
> Symbol s
> Style s
: Symbol `[Symbol]' (type=COUNTER) has a COUNT_TO attribute that will be
: ignored because it is being expanded with STYLE=[Style].

M one_hot_too_small -w20238
> Symbol s
: Symbol `[Symbol]' (type=COUNTER) has `STYLE=ONE_HOT', but is only one bit
: wide.  The output signal(s) will be tied High.

M must_have_one_hot_style -w20234
> Symbol s
> Style s
: Symbol `[Symbol]' (type=COUNTER) has `STYLE=[Style]', but is connected to
: a bus with encoding ONE_HOT.  This counter will be built with
: `STYLE=ONE_HOT' because a binary counter would drive this bus with illegal
: ONE_HOT values.  If you really want a BINARY counter then use a CAST
: symbol.

M binary_width_modulo_dependency -e20117
> Symbol s
> Width s
> CountTo s
: Symbol `[Symbol]' (type=COUNTER, STYLE=BINARY) has a width=[Width], which
: is too small for the COUNT_TO value [CountTo].  The width of a signal
: connected to D_IN or Q_OUT must be greater than or equal to log base 2 of
: the COUNT_TO attribute.

M lfsr_width_modulus_dependency -e20006
> Symbol s
> Style s
> Modulus s
> Min_Width s
> Width s
: Symbol `[Symbol]' (type=COUNTER) has the attributes STYLE=[Style] and
: COUNT_TO=[Modulus] and a width of [Width] bits.  The width of a signal
: connected to D_IN or Q_OUT must be at least [Min_Width] bits wide for this
: style of COUNTER.

M multiple_io_pin_indices -e20151
> Arch s
> Symbol s
> Index s
> Loc1 s
> Loc2 s
: Symbol `[Symbol]' (type=[Arch]) has multiple package pin locations for the
: same index: LOC[[[Index]]=[Loc1] and LOC[[[Index]]=[Loc2].

M io_pin_already_allocated -e20371
> Pin s
> Arch1 s
> Symbol1 s
> Index1 s
> Arch2 s
> Symbol2 s
> Index2 s
: Package pin [Pin] is allocated to symbol `[Symbol1]' (type=[Arch1]) (index
: [Index1]) and to symbol `[Symbol2]' (type=[Arch2]) (index [Index2]).

M io_pin_index_invalid -e20372
> Arch s
> Symbol s
> Index s
: Symbol `[Symbol]' (type=[Arch]) has an indexed parameter [Index] which is
: out of its bounds.

M function_not_hard_macro -e20029
> Symbol s
> Type s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol][.br]
: 2. [Type]

M duplicate_sig_xif -e20153
> Name s
> Type1 s
> Parameters1 s
> Type2 s
> Parameters2 s
> Source1 s
> Source2 s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Name], [Type1], [Parameters1], [Source1][.br]
: 2. [Name], [Type2], [Parameters2], [Source2]

M symbol_already_exists -e20338
> Name s
> Type s
> Sources s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Name][.br]
: 2. [Type][.br]
: 3. [Sources]


M no_width_for_register -e20007
> Symbol s
> Type s
> InPin s
> OutPin s
: Symbol `[Symbol]' (type=[Type]) has neither its [InPin] pin nor its
: [OutPin] pin connected.  Because of this, the width of this symbol cannot
: be determined.  If these connections are not needed attach a BUS_DEF
: module to either so that the BOUNDS and ENCODING are defined for this
: symbol.

M no_width_for_counter -e20010
> Symbol s
> Type s
> Clock s
: Symbol `[Symbol]' (type=[Type] clock=[Clock]) has neither the D_IN pin nor
: the Q_OUT pin connected and does not have the COUNT_TO parameter.  Either
: supply a COUNT_TO value, define BOUNDS and ENCODING on the COUNTER module,
: or attach a bus to the D_IN or Q_OUT pin so that the BOUNDS and ENCODING
: are defined for this symbol.

############################
# Module Generation messages

M create_dt_bus_var -e20290
> Bus_Name s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: detail to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Bus_Name]

M padname_conflicts -e20273
: Multiple I/O padnames have been defined with the same name.
: The conflicts are listed below.  Please correct the cases listed by
: changing the PADNAME parameter on the listed INPUTS, OUTPUTS, BIDIR_IO or
: external pads in your design.[.br]

M pad_symbol_type_hdr
: Pad Name             Type     Symbol[.br]
: ---------------- -------- --------------------

M pad_symbol_type
> Pad_Name s-16
> Symbol s
> Type s-8
: [Pad_Name] [Type] [Symbol]

M pad_conflicts_with_sig_main -e20274
: The following padnames are the same as signals that are internal to your
: design.  Internal nets can interface to an I/O pad only through the
: appropriate buffer: INPUTS, OUTPUTS, BIDIR_IO, IBUF, OBUF, OBUFT, ...[.br]
: This error may also be caused by a PADNAME attribute on an INPUTS,
: OUTPUTS, or BIDIR_IO having the same name as an internal net or bus.
: Rename the value of the PADNAME attribute or change the net/bus name.

M decode_out_not_one_hot -e20256
> Symbol s
> Arch s
> Pin s
> Signal s
> Data_Type s
: Symbol `[Symbol]' (type=[Arch]) has its [Pin] pin connected to Signal
: [Signal], which has data type [Data_Type].  The ENCODING of this data type
: must be ONE_HOT.

M internal_make_xnf_gate -e20240
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M indexed_parm_conflict_hdr -w20239
> Symbol s
> Arch s
> Output s
: Symbol `[Symbol]' (type=[Arch], output=[Output]) has conflicting LOC
: attributes on its input signals:

M index_parm_conflict
> Signal s-16
: Signal [Signal][.br]    Indices Parameter Values

M index_parm_conflict1
> Indices s5
> Parms s
:    [Indices]   [Parms]

M bad_style_for_xnf_arch -e20236
> Symbol s
> Style s
> Arch s
> Output s
: Symbol `[Symbol]' (type=[Arch], output connected to signal [Output]) has
: the attribute STYLE=[Style], which is invalid for this part family.  This
: implementation style is available on only the XC4000/XC4000A families.

M invmask_and_decodemask -e20277
> Symbol s
> Arch s
> Out_Signal s
> Inv_Mask s
> Decode_Mask s
: Symbol `[Symbol]' (type=[Arch], output O connected to signal [Out_Signal])
: has conflicting INVMASK ([Inv_Mask]) and DECODEMASK ([Decode_Mask])
: attributes.  Only one of these attributes is allowed on this type of
: symbol.  Please remove the incorrect attribute and re-process your
: design.

############################
# Simulation messages

M bad_sub_xnf_sym_xif -e20295
> Symbol s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol]

M bad_BIBUF_pins -e20296
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.[.br]

M bad_pin_direction -e20297
> Pin s
> Sig s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Pin][.br]
: 2. [Sig]

M xgs_failed -e20302
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M xgs_reusing_model
> Symbol1 s
> Type s
> Symbol2 s
: Reusing simulation model of symbol [Symbol1] (type=[Type]) for
: symbol [Symbol2].[.br]

M unable_to_open_simulation_file -e20032
> File s
: Could not open simulation file `[File]' for output.  A protected file of
: the same name already exists or you do not have write permission in
: the directory.

M unable_to_open_simulation_directory -e20033
> File s
: Could not open simulation directory `[File]' for output.  A protected file
: of the same name already exists or you do not have write permission
: in the directory.

########################
# XNF parser errors

M non_var_sym_type -e20161
> Symbol s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol]

M not_valid_ext -e20034
> Ext s
> FileOne s
> TypeOne s
> FileTwo s
> TypeTwo s
: The extension [Ext] of the [TypeOne] file [FileOne] conflicts with the
: extension of the [TypeTwo] file [FileTwo].  Please override one of these
: extensions and re-run.

M not_valid_extension -e20251
> Ext s
> File s
> Type s
: The extension [Ext] of the [Type] file [File] is reserved.
: Please change the [Type] file extension and re-run.

M sym_missing_end -e20035
> Symbol s
: Symbol `[Symbol]' is missing its END record in the input XNF file.  This
: is an indication that the XNF file has been corrupted.  Please re-run
: XNFMERGE and XNFPREP before re-running X-BLOX.

M illegal_xnf_record -e20107
> Record_Type s
> Record s
> Line_Num s
> File_Name s
: Illegal XNF record type ([Record_Type]) on line [Line_Num] of file
: [File_Name][.br][Record]

M illegal_sym_xnf_record -e20108
> Symbol s
> Record_Type s
> Record s
> Line_Num s
: Illegal XNF record type ([Record_Type]) as part of the SYM record
: [Symbol] encountered on line [Line_Num] : [Record_Type], [Record]

M illegal_xnf_sym -e20036
> Symbol s
> Arch s
: Symbol [Symbol] is an invalid XNF symbol for the [Arch] Family.

M cannot_read_XNF_file -e20162
> File_Name s
: Could not read [File_Name] as the specified input file.  The path may be
: specified incorrectly, or the file name may be spelled incorrectly.  Be
: sure that the file exists in the current (or specified) directory.

M xnfdb_not_found -e20037
> File s
> Ext s
: Could not find the XNF data base file "[File].[Ext]".  The path may be
: specified incorrectly, or the file name may be spelled incorrectly.  Be
: sure that the file exists in the current (or specified) directory.

M xnfdb_not_loaded -e20163
> File s
: Failed to load the XNF data base file [File]

M xnfdb_loaded
> File s
: Loaded the XNF data base file [File]

M file_does_not_exist -e20164
> PROGNM s
> File s
: [PROGNM] could not find the XNF file [File].  The path may be specified
: incorrectly, or the file name may be spelled incorrectly.[.br]
: [PROGNM] is halting.

M pin_name_mismatch_main -e20165
: The following symbol(s) has (have) pins whose name or I/O direction does
: not match the definition of the given symbol(s).  Please report this to
: your synthesis or schematic capture vendor.  In the mean time, you may
: edit your schematic symbols or XNF file to work around the problem.

M pin_name_mismatch_hdr
: Symbol               Type     I/O Dir Pin Name(s)[.br]
: -------------------- -------- ------- --------------------

M pin_name_mismatch
> Arch_Type s-8
> Symbol s-20
> Direction s-7
> Pin_Names s
: [Symbol] [Arch_Type] [Direction] [Pin_Names]

M null_chars_read -w20039
> Num_Nulls s
: [Num_Nulls] null characters ignored in input file.

#####################
# Data type propagation messages

M bus_bits_implicit_con -w20312
: The following signal(s) have the same name(s) as nets inside X-BLOX buses.
: This implicit connection to an X-BLOX bus is not recommended.  An ELEMENT
: symbol should be used between the signal and the X-BLOX bus.  If the
: connection is accidental, then rename the signal or X-BLOX bus so that the
: names do not conflict.

M bus_bits_implicit_alt_con -w20334
: The following signal(s) will have the same name(s) as nets inside X-BLOX
: buses during simulation.  This implicit connection to an X-BLOX bus is not
: recommended because conflicts will occur during simulation, even if the
: connection is unintentional.  An ELEMENT symbol should be used between the
: signal and the X-BLOX bus.  If the connection is accidental, then rename
: the signal or X-BLOX bus so that the names do not conflict.

M bus_bits_implicit_con_hdr
: Bus                  Element Signal[.br]
: -------------------- ------- --------------------

M bus_elem_signal
> Bus s-20
> Elem s7
> Signal s-20
: [Bus] [Elem] [Signal]

M grounding_bus_bits -w20310
: The following bus bits were not driven by any active circuitry, and so
: they have been grounded.

M sign_extending_msbs -w20311
: The following most-significant bus bits were not driven by any active
: circuitry, and so they have been connected to the most-significant
: bit in the bus that has an active driver or is connected to power or ground.

M bus_data_type_bits_hdr
: Bus                  Data_Type       Bits[.br]
: -------------------- --------------- --------------------

M bus_data_type_bits
> Bus s-20
> Data_Type s-15
> Bits s
: [Bus] [Data_Type] [Bits]

M inferred_hdr
: The following data types were not specified by you and have been
: inferred by X-BLOX.  If these are not what you expected, assign an
: ENCODING and/or BOUNDS to the data path.  Refer to the section on
: Representing X-BLOX Buses in Chapter 2 of the X-BLOX manual for more
: information.

M inferred_hdr1
: Symbol                Type         Signal            Pin     Data Type[.br]
:-------------------- -------- -------------------- -------- ---------------

M no_inferred_hdr
: No signal data types had to be inferred by X-BLOX.[.br][.br]

M sym_arch_sig_pin_dt
> Symbol s-20
> Arch s-8
> Signal s-20
> Pin s-8
> Data_Type s
: [Symbol] [Arch] [Signal] [Pin] [Data_Type]

M bad_encoding_attribute -e20215
> Symbol s
> Arch s
> Encoding s
: Symbol `[Symbol]' (type=[Arch]) has a ENCODING parameter `[Encoding]'.
: The valid ENCODINGs are UBIN, BIT, TWO_COMP, and ONE_HOT.  If the
: ENCODING=BIT, the BOUNDS are not necessary for a single-bit net.

M no_encoding -e20214
> Symbol s
> Arch s
: Symbol `[Symbol]' (type=[Arch]) has a BOUNDS parameter, but is missing the
: ENCODING parameter.  If the BOUNDS parameter is used, the ENCODING is
: mandatory.  If the ENCODING=BIT, the BOUNDS are not necessary for a
: single-bit net.

M internal_sig_not_defined -e20216
> Signal s
> In_Syms s
> Out_Syms s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Signal][.br]
: 2. [In_Syms][.br]
: 3. [Out_Syms]

M internal_bad_sym_xif -e20213
> Symbol s
> Arch s
> In_DT s
> Out_DT s
> Parms s
> Src s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol][.br]
: 2. T: [Arch][.br]
: 3. IT: [In_DT][.br]
: 4. OT: [Out_DT][.br]
: 5. P: [Parms][.br]
: 6. [Src]

M internal_bad_sym_xif_sigs -e20223
> Symbol s
> Arch s
> In_DT s
> Out_DT s
> Parms s
> Src s
> In_Sigs s
> Out_Sigs s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Symbol][.br]
: 2. T: [Arch][.br]
: 3. IT: [In_DT][.br]
: 4. OT: [Out_DT][.br]
: 5. P: [Parms][.br]
: 6. [Src][.br]
: 7. IS: [In_Sigs][.br]
: 8. OS: [Out_Sigs]

M dtype_port_instance_err -e20186
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M sanity_dtype_port_instance_err -e20278
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M bus_signal_data_type_mismatch -e20155
> Bus_Name s
> Data_Type s
> Sig_Data_Type s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Bus_Name], [Data_Type][.br]
: 2. [Bus_Name], [Sig_Data_Type]

M dtype_prop_def_type_err -e20156
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M dtype_sig_instance_err -e20157
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M sanity_dtype_sig_instance_err -e20279
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M dtype_pin_instance_err -e20158
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M dtype_assoc_comp_inst_types -e20159
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M sanity_dtype_assoc_comp_inst_types -e20280
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.

M prop_data_types2
: Signal: its data type[.br]
: ---------------------[.br]

M no_data_types -w20340
: No data types could be determined.  This is either because there are no
: signals in your design, or errors were found when reading the design.

M signal_on_type_pin
> Sig s
> PinType s
> Pin s
> Sink s
: The signal [Sig] is on a [PinType] called [Pin] on the symbol [Sink].

M sel_data_type -e20160
> Module s
> Symbol s
> Mapping s
> Pin s
: Symbol `[Symbol]` (type=`[Module]' has the illegal Data Type [Mapping] on
: pin [Pin].

M moving_1_bit_arrays -w20182
: The following components have scalar pins that were connected to 1-bit
: arrays.  They have been moved to the wire inside that array.

M moving_1_bit_arrays_hdr
: Pin      on Symbol   was on Signal    moved to Signal[.br]
: -------- ----------- ---------------- ---------------

M creating_1_bit_array -w20200
: The following components have 1-bit array pins that were connected to
: a scalar signal.  They have been moved to the bus containing that
: signal.[.br]

M creating_1_bit_array_hdr
: Pin      on Symbol            was on Signal        moved to Signal[.br]
: -------- -------------------- -------------------- --------------------

M pin_change_signal
> Pin s-8
> Symbol s-20
> Array_Signal s-20
> Scalar_Signal s-20
: [Pin] [Symbol] [Array_Signal] [Scalar_Signal]

M sig_not_elem_in_bus_hdr -w20180
: The following signals are connected to a bus without using the ELEMENT or
: BUS_IF symbols.  This will be an ERROR in the next release of X-BLOX.[.br]
: Signal               Index  Bus[.br]
: -------------------- ------ --------------------

M sig_not_elem_in_bus
> Signal s-20
> Sel s-6
> Bus s
: [Signal] [Sel]  [Bus]

M sig_not_elem_in_bus_bad_type_hdr -e20181
: The following signals are connected to a bus without using the ELEMENT or
: BUS_IF symbols and have a datatype that is incompatible with the bus.[.br]
: Signal               Index   Signal_Type  Bus             Bus Sub-Type[.br]
: -------------------- ------- ------------ --------------- ------------

M sig_not_elem_in_bus_bad_type
> Signal s-20
> Sel s-8
> Bus s-15
> Sig_Type s-12
> Sub_Type s-8
: [Signal] [Sel] [Sig_Type] [Bus] [Sub_Type][.br]

M conflicting_types -e20264
> Signal s
> Data_Types s
: Conflicting data types found for signal [Signal]: [Data_Types].

M incompatible_sig_types -e20177
> Signal_Name s
> Sig_Data_Type s
> Other_Data_Type s
: Signal [Signal_Name] has conflicting Data Type definitions.  It is defined
: with Data Type [Sig_Data_Type] which is incompatible with the other
: Data Type definition [Other_Data_Type].
: If you need to change the data type of a bus or slice from a bus, use a
: CAST symbol between the two differently encoded buses.

M incompatible_sig_sub_types -e20199
> Signal_Name s
> Sig_Data_Type s
> Sub_Data_Type s
: Signal [Signal_Name] has conflicting Data Type definitions.  It is defined
: with Data Type [Sig_Data_Type] which is incompatible with the other
: Data Type definition [Sub_Data_Type].
: If you need to change the data type of a bus or slice from a bus, use a
: CAST symbol between the two differently encoded buses.

M incompatible_port_sig_types -e20166
> Pin_Name s
> Symbol s
> Arch s
> Signal s
> Pin_Data_Type s
> Sig_Data_Type s
: Pin `[Pin_Name]' of [Arch] symbol `[Symbol]' has Data Type
: [Pin_Data_Type] and is incompatible with the attached signal `[Signal]',
: which has Data Type [Sig_Data_Type].

M incompatible_port_data_types -e20184
> Signal s
: The signal [Signal], is connected to pins with conflicting data types.
: If you need to change the data type of a bus or slice from a bus, use a
: CAST symbol between the two differently encoded buses.

M incompatible_port_data_type_hdr
: Dir    Pin      Type     Symbol               Data Type[.br]
: ------ -------- -------- -------------------- ---------------

M incompatible_port_data_type
> Dir s-6
> Pin s-8
> Arch s-8
> Symbol s-20
> Data_Type s
: [Dir] [Pin] [Arch] [Symbol] [Data_Type]

M unknown_ports_types -e20167
: X-BLOX was unable to deduce the Data Types for the following pins on
: symbols.  This is either due to no data types being defined on the data
: path containing this pin, or because there were conflicting data types on
: the data path.  Check for other error messages about conflicting data
: types and resolve the conflict according to the instructions with those
: messages.  If there are no data type conflicts, then define the data type
: on an INPUTS, OUTPUTS, BIDIR_IO, DATA_REG, COUNTER, or SHIFT module on the
: data path; or add a BUS_DEF symbol to the data path.

M unknown_ports_types_hdr
: Type     Symbol    Pin       I/O Signal     Data Type[.br]
: ------- ---------- --------- --- ---------- ---------

M illegal_element -e20040
> Symbol s
> ELEM s
: ELEMENT symbol `[Symbol]' has an improper ELEM attribute: [ELEM].
: This attribute should be an integer.

M elem_not_specified -e20041
> Symbol s
> Xblox_Bus s
> Elem_Sig s
: The ELEM attribute is missing from the ELEMENT symbol `[Symbol]'.
: This ELEMENT symbol is connected between bus [Xblox_Bus] and signal
: [Elem_Sig].

M element_out_of_bounds -e20042
> Symbol s
> Elem s
> Xblox_Left s
> Xblox_Right s
: ELEMENT symbol `[Symbol]' has ELEM=[Elem] which is not within the bounds
: ([Xblox_Left]:[Xblox_Right]) of the bus to which it is connected.

M slice_out_of_bounds -e20133
> Symbol s
> Left s
> Right s
> Xblox_Left s
> Xblox_Right s
: SLICE symbol `[Symbol]' has SLICE=[Left]:[Right], which is not within the
: bounds ([Xblox_Left]:[Xblox_Right]) of the bus to which it is connected.

M bad_slice_attribute -e20043
> Symbol s
> Slice_Parm s
> Slice_Atom s
: SLICE symbol [Symbol] has an invalid parameter
: [Slice_Parm]=[Slice_Atom].  The [Slice_Parm] parameter must be a
: range (MSB:LSB).

M bad_sub_starts_at -e20188
> Symbol s
> Slice_Parm s
> Sub_Atom s
: SLICE symbol [Symbol] has an invalid parameter
: [Slice_Parm]=[Sub_Atom].  The [Slice_Parm] parameter must be an integer.

M bad_bounds_attribute -e20134
> Symbol s
> Arch s
> Bounds_Atom s
: Symbol `[Symbol]' (type-[Arch]) has an invalid attribute
: BOUNDS=[Bounds_Atom].  The BOUNDS parameter must be a range (MSB:LSB).

M changed_sig_type -e20139
> Signal s
> Old_Data_Type s
> New_Data_Type s
: Signal [Signal] has two Data Type definitions ([Old_Data_Type]) and
: ([New_Data_Type]).  These are incompatible because the one-bit array
: contains a sub-signal with a different name from the array name.
: The sub-signal is used in array contexts and the scalar (non-arrayed) signal
: is used in scalar contexts.  If this signal is supposed to be a scalar,
: remove the BOUNDS attribute.  If this signal is supposed to be an array,
: the proper interface between an array and a scalar signal is an ELEMENT
: module.

M scalar_array_sig_type_main -e20140
: Each of the following signals have two conflicting data types.  These are
: incompatible because the one-bit array
: contains a sub-signal with a different name from the array name.
: The sub-signal is used in array contexts and the scalar (non-arrayed) signal
: is used in scalar contexts.  If this signal is supposed to be a scalar,
: remove the BOUNDS attribute.  If this signal is supposed to be an array,
: the proper interface between an array and a scalar signal is an ELEMENT
: module.

M scalar_array_sig_type_hdr
:     Signal                  Data Type 1                  Data Type 2[.br]
: -------------------------- -------------------------- ------------------------

M scalar_array_sig_type
> Signal s-27
> Old_Data_Type s-27
> New_Data_Type s
: [Signal] [Old_Data_Type] [New_Data_Type]

M incompatible_sig_port_types -e20141
> Pin_Name s
> Symbol s
> Arch s
> Signal s
> Pin_Data_Type s
> Sig_Data_Type s
: Symbol  `[Symbol]' (type=[Arch]) has Pin `[Pin_Name]' with Data Type
: [Pin_Data_Type].  This is incompatible with the attached signal [Signal]
: which has Data Type [Sig_Data_Type].
: If you need to change the data type of a bus or slice from a bus, use a
: CAST symbol between the two differently encoded buses.

M incompatible_pin_data_types -e20142
> Symbol s
> Arch s
> Pin_Dir s
> Pin_Name s
> Pin_Data_Type1 s
> Pin_Data_Type2 s
: Symbol `[Symbol]' (type=[Arch]) has pin [Pin_Name] with incompatible data
: types!
: ([Pin_Dir] pin [Pin_Name] has data type [Pin_Data_Type1], and
: connected to a signal with data type [Pin_Data_Type2].
: If you need to change the data type of a bus or slice from a bus, use a
: CAST symbol between the two differently encoded buses.

M incompatible_slices_main -e20336
> Bus s
: The bus [Bus] does not have its data type defined, and has sub-buses with
: incompatible ENCODINGs.  All slices of a bus must have the same ENCODING.
: If you need to change the data type of a bus and the slice from that bus,
: use a CAST symbol between the two differently encoded buses.

M incompatible_slice_hdr
: Symbol               Type     Data_Type            Slice Parameter[.br]
: -------------------- -------- -------------------- ------------------

M incompatible_slice
> Symbol s-20
> Type s-8
> Left s
> Right s
> Data_Type s-20
: [Symbol] [Type] [Data_Type] [Left]:[Right]

M cast_types_incompatible -e20212
> Symbol s
> Signal_A s
> Signal_B s
> Data_Types s
: Symbol `[Symbol]' (type=CAST, connected to signals [Signal_A] and
: [Signal_B]) has conflicting data types ([Data_Types]) on its two pins.
: This can be due to a conflict between the A_BOUNDS and B_BOUNDS attributes
: on this symbol or between the BOUNDS of the buses connected to this CAST
: symbol.  The number of bits in these two buses must be same, but the
: BOUNDS do not have to be identical.

M unknown_symbol -e20044
> Symbol s
> Arch s
: Symbol [Symbol] is of an unknown symbol type [Arch].

M file_not_flattened -e20045
: The input design file is not a flat design.  Please run XNFMERGE or modify
: this design before re-running X-BLOX on this design.

M symbol_has_file_equals -e20046
> Symbol s
> File s
: Symbol [Symbol] has a FILE=[File] parameter.  XNFMERGE must be run prior
: to X-BLOX to flatten the netlist.

M hm_illegal -e20047
> Symbol s
: Symbol [Symbol] is a hard macro symbol.  These are no longer supported.
: Refer to the HM2RPM documentation for information on how to translate
: your design to the
: improved, and accepted format.

M hm_obsolete -e20360
> Symbol s
> Type s
: Symbol `[Symbol]' (type=[Type]) has the parameter STYLE=HM.  This style is
: no longer supported. The valid styles for XC4000 family 
: parts are ALIGNED, UNALIGNED, and RIPPLE. X-BLOX will choose an appropriate
: style if the STYLE attribute is not assigned a value. ALIGNED is the 
: preferred style if carry logic is used.


M cannot_propagate_data_types -e20048
> File_Name s
: Could not deduce all the data types for design `[File_Name]'.
: Consult the Data Type Propagation and Signal Aliases Section of the report
: file for the signal data types that X-BLOX was able to infer.

M data_type_needs_bounds -e20143
> Symbol s
> Arch s
> Encoding s
: Symbol `[Symbol]' (type=[Arch]) has an ENCODING=[Encoding] without any
: BOUNDS specified.  This ENCODING requires the BOUNDS also be specified.

M data_type_ignored -w20281
: The following symbol(s) has (have) BOUNDS or ENCODING attributes.
: These attributes are not valid on these symbols and will be ignored.

M data_type_ignored_hdr
: Type     Symbol               Attributes[.br]
: -------- -------------------- --------------------

M data_type_ignored1
> Type s-8
> Symbol s-20
> Attr s
: [Type] [Symbol] [Attr]

M line
> String s
: [String]

M only_tristate_driving_signal
> Signal s
> Symbol s
> Pin_Name s
: Signal [Signal] is driven by only the 3-state pin [Pin_Name] on symbol
: [Symbol].  A pullup is also required on tristated signals.

M pin_not_connected
> Pin s
: Pin [Pin] is not connected.

M select_not_connected -e20049
> Arch s
> Symbol s
: [Arch] module [Symbol] is not connected.

M selector_too_big -e20298
> Symbol s
> Arch s
> Port_Name s
> Sel s
> Data_Type s
> Limit s
: Symbol `[Symbol]' (type=[Arch], pin [Port_Name] connected to [Sel]) has a
: data type of [Data_Type] on the [Port_Name] pin.  This is too large.  The
: limit for the size of this pin is [Limit].

M selector_upb_too_big -e20299
> Symbol s
> Arch s
> Port_Name s
> Sel s
> Data_Type s
> Limit s
: Symbol `[Symbol]' (type=[Arch], pin [Port_Name] connected to [Sel]) has a
: data type of [Data_Type] on the [Port_Name] pin.  The upper bound of this
: data type is too large.  The limit for the upper bound on this data type
: (when used as a selector) is [Limit].

M right_bound_negative -e20050
> Pin s
> Arch s
> Symbol s
> Bound s
: Pin [Pin] on [Arch] module [Symbol] has a negative right bound ([Bound]).
: The right bound is the lower bound and must be non-negative.

M not_big_endian -e20051
> Signal s
> Pin s
> Arch s
> Symbol s
> Left s
> Right s
: Signal [Signal] is a little-endian bus (BOUNDS=[Left]:[Right]). Such a
: bus cannot be
: connected to pin `[Pin]' on [Arch] module [Symbol].  Please change the
: BOUNDS to big endian (BOUNDS=[Right]:[Left]). Use a CAST symbol if
: necessary.

M bad_ram_data_type -e20052
> Address s
> Symbol s
> Arch s
> Pin s
> Encoding s
: Signal `[Address]' connected to pin `[Pin]' on symbol `[Symbol]'
: (type=[Arch]) has an invalid ENCODING `[Encoding]'.  The valid ENCODINGs
: for buses connected to this pin are BIT, UBIN, and TWO_COMP.

M unable_to_open_output_file -e20054
> File s
: Could not open `[File]' as an output file.  A protected file of the same
: name exists or you do not have write permission in the
: directory.

M unable_to_open_input_file -e20055
> File s
: Could not open `[File]' as an input file.  The file does not exist.

M data_path_mismatch -e20056
> Arch s
> Symbol s
> Pin_1_Name s
> Pin_1_Width s
> Pin_2_Name s
> Pin_2_Width s
: [Arch] symbol `[Symbol]' connects to two buses with different widths.
: The bus connecting to the `[Pin_1_Name]' pin is [Pin_1_Width] bits wide,
: while the bus connecting to the `[Pin_2_Name]' pin is [Pin_2_Width] bits
: wide.

M too_many_TBUFs -e20057
> Symbol s
> Actual s
> Allowable s
> Part s
: The function in symbol `[Symbol]' requires [Actual] 3-state buffers
: (TBUFs).  You specified the [Part] as your part type which has only
: [Allowable] 3-state buffers (TBUFs) in a column.

M bad_depth_parm -e20120
> Symbol s
> Arch s
> Depth s
: Symbol `[Symbol]' (type=[Arch], output) has a bad DEPTH parameter
: ([Depth]).  The DEPTH parameter should either be a single integer or a
: pair of integers separated by a colon.  A single integer represents
: the number of words in the memory.  A pair of integers represents the
: highest and lowest addresses in the memory.

M memory_depth_too_big -e20058
> Symbol s
> Arch s
> Address s
> Addr_Upper s
> Addr_Lower s
> Depth_Upper s
> Depth_Lower s
: Symbol `[Symbol]' (type=[Arch]) is addressed by signal [Address] which
: can address locations [Addr_Upper] through [Addr_Lower].  However, this
: [Arch] has defined locations [Depth_Upper] through [Depth_Lower], all of
: which cannot be addressed.

M memory_depth_too_little -e20059
> Symbol s
> Arch s
> Address s
> Addr_Upper s
> Addr_Lower s
> Depth_Upper s
> Depth_Lower s
: Symbol `[Symbol]' (type=[Arch]) is addressed by signal [Address] which
: can address locations [Addr_Upper] through [Addr_Lower].  However, this
: [Arch] has defined only locations [Depth_Upper] through [Depth_Lower].

M signal_type_mismatch -w20060
> Bus_Name s
: There is a Data Type mismatch for the signal [Bus_Name] and one of the
: pins associated with that signal.

M illegal_char -e20118
> Char s
> File s
> Symbol s
> Line_Num s
: Illegal character `[Char]' found on line [Line_Num] of the mem file [File]
: for symbol [Symbol].

M duplicate_bus_indices -e20168
> Elem_Symbol s
> Bus s
> Index s
> Signal s
> Signal2 s
: Symbol `[Elem_Symbol]' (type=ELEMENT) has parameters that specify that
: signal [Signal] is at INDEX=[Index] of bus [Bus].  However, signal
: [Signal2] is already at that index.

M slice_attribute_missing -w20061
> Symbol s
: Symbol `[Symbol]' (type=SLICE) is missing the SLICE attribute.

M static_data_register -w20220
> Symbol s
: Symbol `[Symbol]' (type= DATA_REG) doesn't have its D_IN, ASYNC_CTRL, or
: SYNC_CTRL pins connected, therefore the value in this register will be
: constant.  This DATA_REG symbol can be replaced by a FORCE symbol, which
: would require fewer resources.

M static_shift_register -w20221
> Symbol s
: Symbol `[Symbol]' (type=SHIFT) has none of its data input pins connected,
: and an ASYNC_VAL that evaluates to 0, therefore the value in this register
: will be constant.  This SHIFT symbol can be replaced by a FORCE symbol
: would require fewer resources.

M no_load_warning -w20343
> Symbol s
> Type s
> Pin s
> Sig s
: Symbol `[Symbol]' (type=[Type]), has signal `[Sig]' connected to it's [Pin] 
: pin,
: but no signal is connected to the LOAD pin. This will be an error when
: not producing a simulation unless `[Sig]' is sourceless, such as if it is 
: connected only to a BUS_DEF symbol.

M slice_sub_starts_at_wrong -e20144
> Sub_Left s
> Sub_Right s
> Sub_Starts_At s
> Slice_Symbol s
: The SLICE symbol [Slice_Symbol] has attributes SUB=[Sub_Left]:
: [Sub_Right] and SUB_STARTS_AT=[Sub_Starts_At].  The SUB_STARTS_AT
: attribute must be equal to the lower bound specified in the SUB attribute.

M slice_widths_inconsistent -e20145
> Sub_Left s
> Sub_Right s
> Slice_Width s
> Sub_Width s
> Slice_Left s
> Slice_Right s
> Slice_Symbol s
: The SLICE symbol [Slice_Symbol] has inconsistent width specifications.
: The SLICE [Slice_Left]:[Slice_Right] has width [Slice_Width],  while
: the SUB [Sub_Left]:[Sub_Right] has width [Sub_Width].

M sel_range_outside_input_range6 -w20178 -e20335
> Arch s
> Symbol s
> Sel_Pin s
> Sel_Sig s
> Pin s
> Pin_Sig s
: Symbol `[Symbol]' (type=[Arch], [Sel_Pin] attached to Signal `[Sel_Sig]')
: indexes none of the pins on Pin [Pin] (attached to Signal [Pin_Sig]).

M sel_range_outside_input_range4 -w20179
> Arch s
> Symbol s
> Sel_Pin s
> Sel_Sig s
: Symbol `[Symbol]' (type=[Arch], [Sel_Pin] attached to Signal [Sel_Sig])
: indexes none of the selectable pins."

M in_range_greater_than_sel -w20170
: The following module(s) have selector(s) that cannot index all of their
: input pins.  This is because the addressable range for the selector(s) is
: smaller than the range of indices on the other input to the module(s).
: The addressable range for the selectors and the inputs are given below.

M sel_range_greater_than_input -w20169
: The following module(s) have selector(s) that can address outside
: its other input pin's range.  The addressable range for the selector(s)
: and the other input(s) are given below.

M sel_range_tbl_hdr
: [.br]                                         Selector      Input
: [.br]Type     Symbol                 Pin    Upper Lower  Upper Lower
: [.br]-------- -------------------- -------- ----- -----  ----- -----

M sel_range_tbl_entry
> Arch s-8
> Symbol s-20
> Sel_Upper s-5
> Sel_Lower s-6
> In_Upper s-5
> In_Lower s-5
> In_Pin s-8
: [Arch] [Symbol] [In_Pin] [Sel_Upper] [Sel_Lower] [In_Upper] [In_Lower]

M sel_has_fraction_bits -e20255
> Arch s
> Symbol s
> In_Left s
> In_Right s
> Signal s
> Sel_Pin s
> Value s
: Symbol `[Symbol]' (type=[Arch], [Sel_Pin] connected to [Signal]) has a
: selector that is big-endian with negative BOUNDS ([In_Left]:[In_Right]).  A
: negative bound is not allowed in selectors.  The bounds in big-endian
: buses (left bound >= right bound) indicate the place value for the
: corresponding bits.  With UBIN and TWO_COMP encodings, bit position i has
: the value 2^i.  When a bit position is negative, the bit position has a
: fractional value, e.g., 2^([In_Right])=[Value], and cannot be used to select
: a bit with that value because bits have integer indices.

M memory_depth_value
> Symbol s
> Type s
> Depth s
: The [Type] symbol `[Symbol]' is assumed to have a depth equal to [Depth]
: which is the maximum address represented by the ADDRESS bus.

M partial_memory_used -w20171
> Symbol s
> Type s
> Depth s
: The [Type] symbol `[Symbol]' is assigned a depth equal to [Depth].
: This memory will be implemented as a multiple of 16 and the unused
: memory locations will be handled as an error.

M no_PROM_file_defined -e20121
> Symbol s
> Output s
: Symbol `[Symbol]' (type=PROM, D_OUT output signal=[Output]) is missing its
: MEMFILE attribute.
: The MEMFILE attribute is used to specify the name of the file defining the
: contents of the PROM.
: Alternately, you could define the contents of a 1-bit wide PROM using an INIT
: attribute.

M invalid_memfile_value -e20207
> Memfile s
> Symbol s
> Keyword s
> Value s
> Line s
: Near line [Line] in .mem file [Memfile] for symbol [Symbol],
: Invalid value "[Value]" for keyword "[Keyword]".
: This value must be a legal X-BLOX integer. See the documentation.

M unknown_memfile_keyword -w20305
> Memfile s
> Symbol s
> Keyword s
> Line s
: Near line [Line] in .mem file [Memfile] for symbol [Symbol], unknown
: keyword "[Keyword]" is being ignored.  See the documentation for the PROM
: module for information on keywords allowed in .mem files.

M wrong_mem_type -e20208
> Memfile s
> Symbol s
> Type s
> Line s
: Near line [Line] in .mem file [Memfile] for symbol [Symbol],
: Invalid memory type "[Type]".  This value must be "PROM" or "ROM" if
: present.

M memtype_missing -e20209
> Memfile s
> Symbol s
> Line s
: Near line [Line] in .mem file [Memfile] for symbol [Symbol],
: no MEM type was given after the "TYPE" keyword.

M bad_default_value -e20210
> Memfile s
> Symbol s
> Line s
> Value s
> Width s
: Near line [Line] in .mem file [Memfile] for symbol [Symbol],
: the DEFAULT value "[Value]" is bad.[.br]This could be due to:
: [.br]1) It is not a valid X-BLOX value (see the documentation)
: [.br]2) The binary representation is too wide for the given data width of [Width]

M no_parameter_value -w20286
> Memfile s
> Symbol s
> Line s
> Param s
> Default s
: The value after the memfile keyword [Param] is missing
: near line [Line] in .mem file [Memfile] for symbol [Symbol].
: A default value of [Default] will be used.

M data_error -e20211
> Memfile s
> Symbol s
> Value s
> Line s
: Near line [Line] in the .mem file [Memfile] [Symbol],
: the value "[Value]" is not a valid value.[.br]Two possible reasons are:
: [.br]1) It is not a valid X-BLOX value (see the documentation)
: [.br]2) The binary representation is too wide for the width of the PROM

M init_on_wide_PROM -e20122
> Symbol s
> D_Out s
> Init s
> Width s
: Symbol `[Symbol]' (type=PROM, D_OUT output signal=[D_Out], INIT=[Init]) is
: [Width] bits wide and has an INIT attribute.  You can use this attribute
: only on PROMs that are 1-bit wide.

M bad_memory_file -e20063
> Symbol s
> Name s
: The name of the memory definition file---`[Name]' for the PROM
: symbol [Symbol] is not a valid name.  Only a .mem extension is currently
: supported.  You must change the extension or specify a file with
: no extension.

M no_data_in_prom -w20272
> Symbol s
> D_Out s
> Mem_File s
: The memory definition file `[Mem_File]' For PROM Symbol `[Symbol]'
: (D_OUT=[D_Out]) contains no data.

M prom_address_conflicts -e20109
> Symbol s
> D_Out s
> Mem_File s
: The memory definition file `[Mem_File]' for PROM symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following address conflicts.[.br]
: Address  Data               Line Number[.br]
: -------  ------------       -----------

M prom_address_conflict -e20110
> Address s-10
> Data s-20
> Line_Num s-5
: [Address] [Data] [Line_Num]

M prom_address_errors -e20282
> Symbol s
> D_Out s
> Mem_File s
: The memory definition file `[Mem_File]' for PROM symbol `[Symbol]'
: (D_OUT=[D_Out]) includes the following errors.[.br]

M prom_address_error -e20111
> Addr s
> Data s
> Line s
: Illegal syntax at line [Line]:[.br]
:    Address = [Addr], Data = [Data]

M mem_file_bad_addresses -e20283
> Symbol s
> D_Out s
> Mem_File s
: The memory definition file `[Mem_File]' for PROM symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following syntactically incorrect address
: fields.  The address field must be a number in the specified radix.
: The default radix is 16.

M mem_file_bad_addresses_header
: Field              Line Number[.br]
: -----              -----------

M mem_file_bad_address
> Field s-20
> Line_Num s-5
: [Field] [Line_Num]

M prom_syntax_errors -e20284
> Symbol s
> D_Out s
> Mem_File s
: The memory definition file `[Mem_File]' for PROM symbol `[Symbol]'
: (D_OUT=[D_Out]) had syntax errors on the following lines.

M prom_syntax_errors_header
: Field              Line Number[.br]
: -----              -----------

M prom_syntax_error
> Field s-20
> Line_Num s-5
: [Field] [Line_Num]

M prom_bad_xbloxvals -e20285
> Symbol s
> D_Out s
> Mem_File s
: The memory definition file `[Mem_File]' for PROM symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following syntactically incorrect xblox
: values.  The value may be (1) a number in the specified radix,
: or (2) a number of the form <base>#value#, where
: <base> is a number between 2 and 36 inclusive.

M prom_bad_xbloxvals_header
: Line Number  Value[.br]
: -----------  -----------

M prom_bad_xbloxval
> Line_Num s-11
> Field s-20
: [.br][Line_Num]  [Field]

M prom_lost_msbs -w20294 -e20303
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that were too large for
: the specified datatype.  The most significant bits of the value were
: truncated.[.br]

M prom_lost_msbs_header
: [.br]                                                    Smallest  Largest
: [.br]                                                    Possible  Possible
: [.br]Line                                                Number    Number
: [.br]Number  Value                 Radix  Data Type      (Decimal) (Decimal)
: [.br]------  --------------------  -----  -------------  --------  --------

M prom_lost_msb
> Line_Num s-6
> Number s-20
> Radix s-5
> Type s-13
> Upper s-8
> Lower s-8
: [.br][Line_Num]  [Number]  [Radix]  [Type]  [Lower]  [Upper]

M prom_lost_lsbs -w20301
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that could not fit in
: the specified datatype.  The least significant bits of the value were
: truncated.[.br]

M prom_lost_lsbs_header
: Line Number  Value                 Radix  Data Type[.br]
: -----------  --------------------  -----  -------------[.br]

M prom_lost_lsb
> Line_Num s-11
> Number s-20
> Radix s-5
> Type s-13
: [Line_Num]  [Number]  [Radix]  [Type][.br]

M prom_negative_unsigneds -e20300
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that were negative.
: The specified datatype requires that the data value be
: unsigned.  If you need to
: set a bit pattern, use BITS(Number).[.br]

M prom_negative_unsigneds_header
: Line Number  Value                 Radix  Data Type[.br]
: -----------  --------------------  -----  -------------[.br]

M prom_negative_unsigned
> Line_Num s-11
> Number s-20
> Radix s-5
> Type s-13
: [Line_Num]  [Number]  [Radix]  [Type][.br]

M prom_fraction_in_one_hots -w20306 -e20307
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following non-integer data values.
: Fractional numbers may not be used as a one-hot data value because
: this number indicates the bit of the connected bus that must be set
: high.[.br]

M prom_fraction_in_one_hots_header
: [.br]Line
: [.br]Number  Value                 Radix  Data Type
: [.br]------  --------------------  -----  -------------

M prom_fraction_in_one_hot
> Line_Num s-6
> Number s-20
> Radix s-5
> Type s-13
: [.br][Line_Num]  [Number]  [Radix]  [Type]

M prom_dc_in_one_hots -w20308 -e20309
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that contain don't care
: (?) characters.
: Don't care characters may not be used in a one-hot data value because
: this number indicates the bit of the connected bus that must be set
: high.[.br]

M prom_dc_in_one_hots_header
: [.br]Line
: [.br]Number  Value                 Radix  Data Type
: [.br]------  --------------------  -----  -------------

M prom_dc_in_one_hot
> Line_Num s-6
> Number s-20
> Radix s-5
> Type s-13
: [.br][Line_Num]  [Number]  [Radix]  [Type]

M prom_no_oness -e20348 -w20349
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that are not legal 
: ONE_HOT values.  Legal values have a binary representation that
: contains one and only
: one `1' digit.  The binary representation of the following values
: contains no `1' digits.

M prom_no_oness_header
: [.br]Line
: [.br]Number  Value                 Radix
: [.br]------  --------------------  -----

M prom_no_ones
> Line_Num s-6
> Number s-20
> Radix s-5
: [.br][Line_Num]  [Number]  [Radix]

M prom_too_many_oness -e20350 -w20351
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that are not legal 
: ONE_HOT values.  Legal values have a binary representation that
: contains one and only
: one `1' digit.  The binary representation of the following values
: have more than one `1' digit.

M prom_too_many_oness_header
: [.br]Line
: [.br]Number  Value                 Radix
: [.br]------  --------------------  -----

M prom_too_many_ones
> Line_Num s-6
> Number s-20
> Radix s-5
: [.br][Line_Num]  [Number]  [Radix]

M prom_float_overflows -e20356 -w20357
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that cause the 
: floating-point arithmetic on this machine to overflow.  These numbers
: cannot be represented on this machine.

M prom_float_overflows_header
: [.br]Line
: [.br]Number  Value                 Radix
: [.br]------  --------------------  -----

M prom_float_overflow
> Line_Num s-6
> Number s-20
> Radix s-5
: [.br][Line_Num]  [Number]  [Radix]

M prom_out_of_boundss -w20367 -e20368
> Symbol s
> Type s
> D_Out s
> Memfile s
: The memory definition file `[Memfile]' for [Type] symbol `[Symbol]'
: (D_OUT=[D_Out]) has the following data values that are outside of the
: range of possible values for the specified datatype.  The range of numbers
: that can be represented in this datatype are given below.  

M prom_out_of_boundss_header
: [.br]Line
: [.br]Number Number   Radix Data Type        Max      Min
: [.br]------ -------- ----- ---------------- -------- --------

M prom_out_of_bounds
> Line_Num s-6
> Number s-8
> Radix s-5
> Data_Type s-16
> Upper s-8
> Lower s
: [Line_Num] [Number] [Radix] [Data_Type] [Upper] [Lower]

M bad_xbloxval_main -e20341 -w20342
: The following symbols have syntactically incorrect values for the
: given attributes.
: The value may be (1) a number in the default radix,
: or (2) a number of the form <base>#value#, where
: <base> is a number between 2 and 36 inclusive.  Don't care
: characters (?) may be used only with base 2,4,8,16 or 32.

M bad_xbloxval_hdr
: [.br]Symbol               Type     Attribute    Value          Radix
: [.br]-------------------- -------- ------------ -------------- -----

M bad_xbloxval
> Symbol s-20
> Symbol_Type s-8
> Attribute s-12
> Number s-14
> Radix s-5
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix]

M lost_msb_main -w20315 -e20316
: The following symbols have attributes with values that are too large for
: the specified datatype.  The most-significant bits of the value have been
: truncated.  The range of representable numbers for each datatype is given
: below.

M lost_msb_hdr
: [.br]Symbol               Type     Attr     Number   Radix Data Type        Max      Min
: [.br]-------------------- -------- -------- -------- ----- ---------------- --------
: --------

M lost_msb
> Symbol s-20
> Symbol_Type s-8
> Attribute s-8
> Number s-8
> Radix s-5
> Data_Type s-16
> Upper s-8
> Lower s
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix] [Data_Type] [Upper] [Lower]

M out_of_bounds_main -w20327 -e20328
: The following symbols have attributes with values that are outside of the
: range of possible values for the specified datatype.  The range of numbers
: that can be represented in this datatype are given below.  

M out_of_bounds_hdr
: [.br]Symbol               Type     Attr     Number   Radix Data Type        Max      Min
: [.br]-------------------- -------- -------- -------- ----- ---------------- --------
: --------

M out_of_bounds
> Symbol s-20
> Symbol_Type s-8
> Attribute s-8
> Number s-8
> Radix s-5
> Data_Type s-16
> Upper s-8
> Lower s
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix] [Data_Type] [Upper] [Lower]

M lost_lsb_main -w20317 -e20318
: The following symbols have attributes with values that do not fit in the
: specified datatypes.
: The least significant bits of the value have been truncated.

M lost_lsb_hdr
: [.br]Symbol               Type     Attr     Number   Radix Data Type
: [.br]-------------------- -------- -------- -------- ----- ----------------

M lost_lsb
> Symbol s-20
> Symbol_Type s-8
> Attribute s-8
> Number s-8
> Radix s-5
> Data_Type s-16
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix] [Data_Type]

M negative_unsigned_main -e20319 -w20320
: The following symbols have attributes that are negative, but the specified
: datatype requires that the attribute value be unsigned.  If you need to
: set a bit pattern, use Attribute=BITS(Number) or Attribute=ALL_1 or
: Attribute=ALL_0, as appropriate.

M negative_unsigned_hdr
: [.br]Symbol               Type     Attr     Number   Radix Data Type
: [.br]-------------------- -------- -------- -------- ----- ----------------

M negative_unsigned
> Symbol s-20
> Symbol_Type s-8
> Attribute s-8
> Number s-8
> Radix s-5
> Data_Type s-16
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix] [Data_Type]

M fraction_in_one_hot_main -w20321 -e20322
: The following symbols have attributes with values that are non-integer
: values.
: A fractional number may not be used as a one-hot data value because
: this number indicates the bit of the connected bus that must be set
: high.

M fraction_in_one_hot_hdr
: [.br]Symbol               Type     Attr     Number   Radix Data Type
: [.br]-------------------- -------- -------- -------- ----- ----------------

M fraction_in_one_hot
> Symbol s-20
> Symbol_Type s-8
> Attribute s-8
> Number s-8
> Radix s-5
> Data_Type s-16
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix] [Data_Type]

M dc_in_one_hot_main -w20323 -e20324
: The following symbols have attributes that
: contain don't care characters (?).
: Don't care characters may not be used in a one-hot data value because
: this number indicates the bit of the connected bus that must be set
: high.

M dc_in_one_hot_hdr
: [.br]Symbol               Type     Attr     Number   Radix Data Type
: [.br]-------------------- -------- -------- -------- ----- ----------------

M dc_in_one_hot
> Symbol s-20
> Symbol_Type s-8
> Attribute s-8
> Number s-8
> Radix s-5
> Data_Type s-16
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix] [Data_Type]

M no_ones_main -w20352 -e20353
: The following symbols have attribute values that are not legal 
: ONE_HOT values.  Legal values have a binary representation that
: contains one and only
: one `1' digit.  The binary representation of the following values
: contains no `1' digits.

M no_ones_hdr
: [.br]Symbol               Type     Attribute    Number       Radix
: [.br]-------------------- -------- ------------ ------------ -----

M no_ones
> Symbol s-20
> Symbol_Type s-8
> Attribute s-12
> Number s-12
> Radix s-5
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix]

M too_many_ones_main -e20354 -w20355
: The following symbols have attribute values that are not legal 
: ONE_HOT values.  Legal values have a binary representation that
: contains one and only
: one `1' digit.  The binary representation of the following values
: have more than one `1' digit.

M too_many_ones_hdr
: [.br]Symbol               Type     Attribute    Number       Radix
: [.br]-------------------- -------- ------------ ------------ -----

M too_many_ones
> Symbol s-20
> Symbol_Type s-8
> Attribute s-12
> Number s-12
> Radix s-5
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix]

M float_overflow_main -e20358 -w20359
: The following symbols have attribute values that cause the 
: floating-point arithmetic on this machine to overflow.
: These numbers cannot be represented on this machine.

M float_overflow_hdr
: [.br]Symbol               Type     Attribute    Number       Radix
: [.br]-------------------- -------- ------------ ------------ -----

M float_overflow
> Symbol s-20
> Symbol_Type s-8
> Attribute s-12
> Number s-12
> Radix s-5
: [Symbol] [Symbol_Type] [Attribute] [Number] [Radix]

M selector_lsb_must_be_zero -e20127
> Symbol s
> Addr s
> Type s
> Addr_DT_Left s
> Addr_DT_Right s
: The address line [Addr] connected to [Type] symbol [Symbol] has
: BOUNDS=[Addr_DT_Left]:[Addr_DT_Right], but must have a right bound of 0.

M trimmed_rom_banks -w20218
> Symbol s
> Count s
> Size s
: While expanding symbol [Symbol], [Count] [Size]-bit ROM primitive(s) were
: replaced by power or ground because all stored values in the bank were
: the same. This
: symbol may require more or less area if different data values are provide
: in the mem file.

M trimmed_16_and_32_rom_banks -w20219
> Symbol s
> Num16 s
> Num32 s
: While expanding symbol [Symbol], [Num16] 16-bit and [Num32] 32-bit ROM
: primitives were
: replaced by power or ground because all stored values in the bank were
: the same. This
: symbol may require more or less area if different data values are provide
: in the mem file.

M no_trimming
: No signals were trimmed.[.br][.br]

M trim_signal_err -e20197
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the error number
: above to the support personnel.  This information will be needed by the
: software developers.[.br]

M trimmed_signal_src -w20190
> Signal s
: Signal [Signal] is sourceless and has been trimmed.  It was connected to
: the following symbols.

M trim_sig_info_hdr -w20196
: The following signals were trimmed from the circuit because they were
: electrically loadless or sourceless.  If you are designing incrementally
: and want to save some of these signals, attach an S attribute to the
: signal.

M trim_sig_info_hdr1
: Signal               Type     Symbol               Pin      Pin Type[.br]
: -------------------- -------- -------------------- -------- --------

M sig_trim_info
> Signal s-20
> Symbol s-20
> Arch s-8
> Pin s-8
> IO s
: [Signal] [Arch] [Symbol] [Pin] [IO]

M remove_sig_from_port
> Signal s
> Symbol s
> Arch s
> Port s
: trim_sig: sig=[Signal] sym=[Symbol] type=[Arch] pin=[Port]

M symbol_name_and_pin_hdr
: Symbol               Pin[.br]
: -------------------- --------

M symbol_name_pin_and_sig_hdr
: Symbol               Pin      Signal[.br]
: -------------------- -------- --------------------

M symbol_name_type_pin_and_sig_hdr
: Symbol               Type     Pin      Signal[.br]
: -------------------- -------- -------- --------------------

M sig_sym_name_type_pin_bus_hdr
: Signal               Symbol               Type     Pin      Bus[.br]
: -------------------- -------------------- -------- -------- --------------------

M symbol_name_and_pin
> Symbol s-20
> Pin s-8
: [Symbol] [Pin]

M symbol_name_pin_and_sig
> Symbol s-20
> Pin s-8
> Signal s
: [Symbol] [Pin] [Signal]

M symbol_name_type_pin_and_sig
> Symbol s-20
> Type s-8
> Pin s-8
> Signal s
: [Symbol] [Type] [Pin] [Signal]

M sig_sym_name_type_pin_bus
> Signal s-20
> Symbol s-20
> Type s-8
> Pin s-8
> Bus s
: [Signal] [Symbol] [Type] [Pin] [Bus]

M undriven_signals_kept -w20363
: The following bus bits were not driven by any active circuitry and did not
: have a Save Signal attribute.  Because functional simulation models are
: being generated, these signals will not be deleted.  These bits must be
: driven by an active driver, have a Save Signal attribute, or be connected
: to power or ground before the X-BLOX synthesis or X-BLOX timing flows can
: be run.

M undriven_signals_found -e20365
: The following bus bits were not driven by any active circuitry and did not
: have a Save Signal attribute.  These bits must be driven by an active
: driver, have a Save Signal attribute, or be connected to power or ground
: before the X-BLOX synthesis or X-BLOX timing flows can be run.

M multiple_drivers -e20192
> Signal s
: Signal [Signal] is sourced by more than one symbol!  This signal may be an
: alias of other signals.[.br]Refer to the Signal Alias section of the .blx
: file to see if this signal was inadvertently shorted to another signal.

M multiple_drivers2 -e20326
: The following signal(s) is(are) sourced by more than one symbol.  This
: signal may be an alias of other signals.[.br]
: Refer to the Signal Alias section of the .blx file to see if this signal
: was inadvertently shorted to another signal.

M trimmed_signal -w20132
> Signal s
> Symbol s
> Driving s
> Loading s
: The signal [Signal] that [Driving] symbol [Symbol] is [Loading] and
: so it has been deleted.

M trim_symbol_main -w20282
: The following symbols have been trimmed because none of their inputs or
: outputs are connected to actively sinked signals.  (This is normal for
: BUS_DEF symbols that define the width of a COUNTER or serial SHIFT
: register.)

M trim_symbol_hdr
: Type      Symbol[.br]
: -------- --------------------

M trim_symbol
> Symbol s
> Arch s-8
: [Arch] [Symbol]

####################
# Signal Aliasing

M signal_alias_hdr_1
: COMPUTING SIGNAL ALIASES...

M signal_alias_hdr_2
: Signal: its aliases

M signal_alias
> Signal s
> Signals s
: [Signal]: [Signals]

M signal_aliases
> Signal s
> Signals_String s
: [Signal] : [Signals_String]

M conflicting_pwr_types -e20205
> Signals s
> Powers s
: The following signals are power signals ([Powers]), and are shorted
: together in your design.
: [Signals].
: Please correct this and re-submit the design.

M multiple_power_aliases -e20373
> Signal_Class s
> Power_Sigs s
: The following signals are equivalent: [Signal_Class]. However they
:  contain more than
: one power signal: [Power_Sigs].

M conflicting_keep_names -w20201
> Signal s
> Signals s
: The following signals are equivalent, but all have the KN or KEEPNAME
: attribute ([Signals]).  Only one of these attributes is allowed on any one
: set of equivalent signals.  The signal [Signal] has been chosen as the
: alias for the other signals.  If this is not the signal you want to keep,
: remove the KN attribute from the signals you do not want to keep.

M trim_kn_main -w20329
: The following signals have the KN attribute, and have been trimmed because
: they are loadless or sourceless.  The KN attribute controls the choice of
: name for signal aliasing, but does not prevent signal trimming.  If you do
: not want this signal trimmed, you can add the X attribute to the signal.
: However, if you add the X attribute, the signal will always be present, even
: if the signal could be optimized away or absorbed into a function
: generator.

M trim_kn_hdr
: Signal
: [.br]--------------------

M trim_kn
> Signal s-20
: [Signal]

M sym_sym_collision_main -e20330
: The following symbol(s) has (have) a hierarchical name (or a portion of a
: hierarchical name) that is the same as an existing symbol.  Please rename
: the offending symbol(s) so that real, non-overlapping, hierarchy is used.

M sym_sym_collision_hdr
: Symbol                Type     Symbol               Type
: [.br]-------------------- -------- -------------------- --------

M sym_sym_collision
> Symbol1 s-20
> Arch1 s-8
> Symbol2 s-20
> Arch2 s-8
: [Symbol1] [Arch1] [Symbol2] [Arch2]

M sym_sig_collision_main -e20331
: The following symbol(s) has (have) a hierarchical name (or a portion of a
: hierarchical name) that is the same as an existing signal.  Please rename
: the offending symbol(s) so that real, non-overlapping, hierarchy is used.

M sym_sig_collision_hdr
: Symbol                Type     Signal
: [.br]-------------------- -------- --------------------

M sym_sig_collision
> Symbol s-20
> Arch s-8
> Signal s-20
: [Symbol] [Arch] [Signal]

M sig_sym_collision_main -e20332
: The following signal(s) has (have) a hierarchical name (or a portion of a
: hierarchical name) that is the same as an existing symbol.  Please rename
: the offending signal(s) so that real, non-overlapping, hierarchy is used.

M sig_sym_collision_hdr
: Signal                Symbol               Type
: [.br]-------------------- -------------------- --------

M sig_sym_collision
> Signal s-20
> Symbol s-20
> Arch s-8
: [Signal] [Symbol] [Arch]

M sig_sig_collision_main -e20333
: The following signal(s) has (have) a hierarchical name (or a portion of a
: hierarchical name) that is the same as an existing signal.  Please rename
: the offending signal(s) so that real, non-overlapping, hierarchy is used.

M sig_sig_collision_hdr
: Signal                Signal
: [.br]-------------------- --------------------

M sig_sig_collision
> Signal1 s-20
> Signal2 s-20
: [Signal1] [Signal2]

####################
# XNF writer

M failed_to_write_XNF -e20064
> PROGNM s
: Failed to write a valid [PROGNM] Netlist File (xg) for the design.

M unable_to_write_pins -e20172
> Module_Type s
> Inputs s
> Outputs s
: Unable to write symbol pins ([Inputs], [Outputs]) for module type
: [Module_Type].

######################
# Part information

M default_part_used -w20065
> Part s
: No Parttype was specified for this design.  Default Parttype used is
: [Part].

M incorrect_part_type -e20066
> Part s
: The specified Part type [Part] is unknown.

M invalid_part_array -e20067
> Part s
: Could not get the array size for the part [Part].

M unsupported_part_type -e20068
> Part s
: The specified Part type [Part] is not supported in this release.~

M multiple_part_type -e20069
> Part s
> Line_Numb s
: The Part type [Part] has been multiply specified in the input XNF file
: at line number [Line_Numb].

M driver_and_tristates -e20193
> Signal s
> Driver s
> Arch s
> Pin s
: Signal [Signal] is driven by [Arch] symbol [Driver] (pin [Pin]) and
: 3-state components.  These cannot be mixed.

M tristate_disabled_main -e20070 -w20112
: The enable pin on each of the following symbols has been hard-wired so
: that the output is always disabled.

M tristate_disabled_hdr
: Symbol               Enable   Constant Output[.br]
: -------------------- -------- -------- --------------------

M tristate_disabled
> Symbol s-20
> Enable s-8
> Constant s-8
> Output s-20
: [Symbol] [Enable] [Constant] [Output]

M driving_power -e20194
> Signal s
> Power_Type s
: Signal `[Signal]' is a `[Power_Type]' signal, and is being driven by the
: following symbols.

M float_val_warning_on_symbol -w20257
: The following symbol(s) has (have) FLOAT_VAL attributes that create
: pullup and/or pulldown resistors on their output buffers.  Because this
: design does not use the Global Tristate pin (GTS) of a STARTUP symbol,
: these resistors will draw current in addition to that used by the output
: buffer, whose output is always active.  If you do not want your chip to
: use this extra current, you should remove the FLOAT_VAL attribute from
: these symbol(s).

M float_val_warning_on_symbol_hdr
: Type     Symbol               FLOAT_VAL   Signal[.br]
: -------- -------------------- ---------- --------------------

M float_val_warning_on_symbol_entry
> Symbol s-20
> Arch s-8
> Signal s
> Float_Val s-10
: [Arch] [Symbol] [Float_Val] [Signal]

M float_val_contains_pulldowns -w20288
> Part s
: Each of the following symbols has a FLOAT_VAL attribute that specifies
: pulldown resistors.  Pulldown resistors are not available on the current
: part type ([Part]), and so the pulldown resistor attribute has been
: ignored.  If you need pulldown resistors, then you should use one of the
: parts from the XC4000 family.

M type_symbol_float_val_signal_hdr
: Type      Symbol               FLOAT_VAL  Signal[.br]
: -------- -------------------- ---------- --------------------

M type_symbol_float_val_signal
> Symbol s-20
> Type s-8
> Signal s-20
> Float_Val s-10
: [Type] [Symbol] [Float_Val] [Signal]

M tristate_has_no_floatvals -e20195
> Signal s
: Signal `[Signal]' is driven by the following TRISTATE symbols, and none of
: them have a FLOAT_VAL=PULLUP or FLOAT_VAL=PULLUP_D attribute.

M misspelled_attribute_main -w20203
: The following symbols have misspelled attributes.  The most probable
: correct spellings are given below.  Please correct the spellings
: and re-submit the design.

M misspelled_attribute_hdr
: Symbol               Misspelling     Probable Correct Spelling
: [.br]-------------------- --------------- ---------------------------

M misspelled_attribute
> Symbol s-20
> Misspelling s-15
> Correct s-15
: [Symbol] [Misspelling] [Correct]

M tristate_has_pullups
> Symbol s
> Pullup_Name s
: Symbol `[Symbol]' (type=TRISTATE) has a [Pullup_Name] attached to it.

M invalid_tristate_parm -w20173
> Symbol s
> Parameter s
> Value s
: TRISTATE symbol [Symbol] contains an unknown or unsupported value
: [Value] for parameter [Parameter].  This value will be ignored.

M tristate_always_enabled_conflict -e20113
> Symbol s
> OEsig s
> Output s
> Drivers s
: The signal [OEsig] connected to the OE pin of TRISTATE symbol [Symbol]
: is tied Low, thus the symbol is always enabled.
: This is an error because the following symbols are also driving signal
: [Output] :[.br][Drivers]

M tristate_always_enabled -w20114
> Symbol s
> OEsig s
> Output s
: The signal [OEsig] connected to the OE pin of TRISTATE symbol [Symbol]
: is tied Low, thus the symbol is always driving signal [Output].


M tristate_never_enabled_conflict -e20115
> Symbol s
> OEsig s
> Output s
: The signal [OEsig] connected to the OE pin of TRISTATE symbol [Symbol]
: is tied High, thus the symbol is never enabled.
: This is an error because no other symbols are driving signal [Output].

M tristate_never_enabled -w20116
> Symbol s
> OEsig s
: The signal [OEsig] connected to the OE pin of TRISTATE symbol [Symbol]
: is tied High, thus the symbol is never enabled.  It will be
: deleted from the design.

M selector_error_ignored -w20071
> Symbol s
> Arch s
> Pin s
> Signal s
: Symbol `[Symbol]' (type=[Arch] [Pin] signal=[Signal]) has a selector
: which can address outside the range of indices on the addressable bus.
: All selection errors will be ignored because the SEL_ERROR pin is not
: being used.

M selector_error_ignored_not_driven -w20292
> Symbol s
> Arch s
> Pin s
> Signal s
: Symbol `[Symbol]' (type=[Arch] [Pin] signal=[Signal]) has a bus input
: with not all of its signals driven.  All selection errors will be ignored
: because the SEL_ERROR pin is not being used.

M selector_error_ignored_not_sinked -w20339
> Symbol s
> Arch s
> Pin s
> Signal s
: Symbol `[Symbol]' (type=[Arch] [Pin] signal=[Signal]) has a bus output
: with not all of its signals sinked.  All selection errors will be ignored
: because the SEL_ERROR pin is not being used.

M mem_and_init -w20123
> Symbol s
> D_Out s
> Memfile s
: Symbol `[Symbol]' (type=PROM, D_Out output signal=[D_Out]) has both a
: MEMFILE-[Memfile] attribute and an INIT attribute.  The INIT attribute
: will be ignored.

M no_prom_mem_file -e20124
> Symbol s
> D_Out s
> Memfile s
: Symbol `[Symbol]' (type=PROM, D_OUT output signal=[D_Out]) specifies a
: non-existent MEMFILE=[Memfile].  This file has been created with a
: template for the memory file. You must edit this file
: before re-running X-BLOX. See the documentation for the PROM symbol for
: the memory file format.

M prom_width_conflict -w20217
> Symbol s
> SymbolWidth s
> MemfileWidth s
> Memfile s
: Symbol `[Symbol]' (type=PROM) has its D_IN pin connected to a bus of width
: [SymbolWidth], however the memory file [Memfile] has declared "WIDTH
: [MemfileWidth]".  The parameter in the file will be ignored.

M prom_depth_conflict -w20147
> Symbol s
> SymbolDepth s
> MemfileDepth s
: Symbol `[Symbol]' (type=PROM) has parameter DEPTH=[SymbolDepth], however
: the memory file has declared "DEPTH [MemfileDepth]".  The parameter on the
: symbol will be ignored.

M mem_output_inaccessible -w20125
> Symbol s
> Type s
> Addr s
> Loc_Upper s
> Loc_Lower s
> Addr_Upper_Range s
> Addr_Lower_Range s
: Symbol `[Symbol]' (type=[Type], ADDR signal=[Addr]) can address locations
: [Addr_Upper_Range]:[Addr_Lower_Range], but it has defined only locations
: [Loc_Upper]:[Loc_Lower].

M mem_output_ignored -w20126
> Symbol s
> Type s
> Addr s
> Loc_Upper s
> Loc_Lower s
: Symbol `[Symbol]' (type=[Type], ADDR signal=[Addr]) has defined
: locations [Loc_Upper]:[Loc_Lower], but the D_OUT pin is not connected.
: Only the ADDR_ERROR logic will be synthesized.

M memfile_different_part -w20325
> Symbol s
> Memfile s
> Line s
> Real_Part s
> Mem_Part s
: The memory file [Memfile] for Symbol [Symbol] (type=PROM) has defined
: the parttype [Mem_Part] on line [Line], but the parttype given in the
: design or on the command line was [Real_Part].  The parameter in the
: file will be
: ignored.

M output_not_connected -w20072
> Symbol s
> Arch s
> Pin s
: Symbol `[Symbol]' (type=[Arch]) has an unconnected [Pin] pin.  The logic
: function associated with this pin will not be built.

M write_xnf_file
> PROGNM s
> File_Name s
: WRITING NEW [PROGNM] Netlist File to `[File_Name]'.

M reading_XNF_file
> File_Name s
: READING `[File_Name]' as the design file.

M bad_bus_name -e20073
> Bus_Name s
: The bus named [Bus_Name] does not meet the XNF naming conventions.
: Please rename this bus.

M bad_pin_name -e20074
> Pin_Name s
: The signal named [Pin_Name] does not meet the XNF naming conventions.
: Please rename this signal.

M bad_symbol_name -e20075
> Symbol s
> Arch s
: Symbol `[Symbol]' (type=[Arch]) does not meet the XNF naming conventions.
: Please rename this symbol. Names must contain only the following
: characters:[.br]
: A-Z a-z 0-9 $ _ - < > /[.br]
: Not all interface programs allow all of these characters.[.br]
: Names must conatin at least one non-digit character. They may start with
: any legal character.

M bad_ext_sig_name -e20076
> Ext_Sig_Name s
: The EXT Signal named [Ext_Sig_Name] does not meet the XNF naming
: conventions.  Please rename the EXT Signal.
:  Names must contain only the following
: characters:[.br]
: A-Z a-z 0-9 $ _ - < > /[.br]
: Not all interface programs allow all of these characters.[.br]
: Names must conatin at least one non-digit character. They may start with
: any legal character.


M bad_pwr_sig_name -e20077
> Pwr_Sig_Name s
: The PWR Signal named [Pwr_Sig_Name] does not meet the XNF naming
: conventions.  Please rename this power signal.
:  Names must contain only the following
: characters:[.br]
: A-Z a-z 0-9 $ _ - < > /[.br]
: Not all interface programs allow all of these characters.[.br]
: Names must conatin at least one non-digit character. They may start with
: any legal character.

M sig_type
> Signal s
> Data_Type_String s
: [Signal] : [Data_Type_String]

M alias_of
> Anonymouses s
: 	alias of: [Anonymouses]

M aliased_by
> Alias s
: 	aliased by: [Alias]

M power_signal
> Power s
: 	power: [Power]

M bus_signals
> Signals s
:	bus: [Signals]

M duplicate_sym_xnf_type -e20078
> Symbol s
> Type s
: Two symbols exist with the same name `[Symbol]' (type=[Type]).  Remove
: the duplicate symbol and re-run.

M duplicate_sym_xnf -e20079
> Symbol s
> Type1 s
> Type2 s
: Two symbols exist with the same name `[Symbol]' (types=[Type1] and
: [Type2]).  Remove the duplicate symbol and re-run.

M duplicate_ext -e20080
> Signal s
: There are multiple EXT records for the signal [Signal] in the input file.
: Only one EXT record is allowed per signal.

M internal_name_conflict -e20081
> CandidateType s
> CandidateName s
> Symbol s
> Type s
: The instance name of the [Type] symbol [Symbol] conflicts with the internal
: name generated for the [CandidateType] [CandidateName].  Please change the
: instance name on [Type] symbol [Symbol] and re-run.

M moved_into_ARITH
> Symbol s
> NewSymbol s
: Symbol `[Symbol]' has been mapped into an RPM and has been renamed
: [NewSymbol] to utilize the fast-carry logic.

M includes_register
> Symbol s
> Register s
: Symbol `[Register]' (type=DATA_REG) is also mapped into the RPM called
: `[Symbol]'.

M includes_TBUF
> Symbol s
> TBUF s
: The 3-state buffer called `[TBUF]' is also mapped into the
: RPM called `[Symbol]'.

M symbol_merged
> Symbol s
> Type s
: Symbol `[Symbol]' has been merged into an IOB as an `[Type]' Symbol.

M symbols_merged
> Symbol_List_String s
> Type s
: Symbols `[Symbol_List_String]' have been merged into an IOB as an `[Type]'
: Symbol.

M ff_merged_count
> Count s
: [.br]A total of [Count] flip flops have been merged into io blocks.[.br]

M promoted_signal_from_BUFGS
> Signal s
: Temporarily removing `[Signal]' from a GLOBAL SECONDARY BUFFER so that
: it can be evaluated along with other candidate signals for a position
: on one of the GLOBAL PRIMARY BUFFERS (BUFGP).

M signal_now_on
> Signal s
> Type s
: Signal `[Signal]' now connected to a `[Type]' symbol.

M removed_signal_from_n_symbols
> Signal s
> Number_of_Symbols s
: [Number_of_Symbols] unnecessary connections removed from signal
: `[Signal]'.

M module_expanded
> Module_Type s
> Symbol s
> Driving_Net s
> Number_of_Times s
> Expanded_Into_What s
: [Module_Type] `[Symbol]' driving net `[Driving_Net]' expanded
: into [Number_of_Times] groups of [Expanded_Into_What] symbols.

M outputs_expanded
> Module_Type s
> Symbol s
> Driving_Net s
> Number_of_Times s
> Expanded_Into_What s
: [Module_Type] `[Symbol]' driven by net `[Driving_Net]'
: expanded into [Number_of_Times] [Expanded_Into_What] symbols.

M output_constant
> Pin s
> Arch s
> Symbol s
> Constant s
: Pin [Pin] of [Arch] module [Symbol] has been set to [Constant].

M memory_expanded
> Symbol s
> Outputs s
> Type s
> File s
: [Type] `[Symbol]' driving net `[Outputs]' is integrated into the design.
: * NOTE:  The memory definition file for `[Symbol]' is saved as `[File]'.
: You must run 'memgen [File]' to create the XNF netlist file for
: the memory before running Partition, Place, and Route (PPR).

M bus_gate_expanded
> Module_Type s
> Symbol s
> Driving_Net s
> Number_of_Times s
> Expanded_Into_What s
: [Module_Type] `[Symbol]' driving net `[Driving_Net]' was expanded
: into a [Number_of_Times]-wide [Expanded_Into_What] symbol.

M parameter_set_to_default -e20082
> Symbol s
> Type s
> Parameter s
> Default s
: The `[Parameter]' parameter on the `[Type]' symbol called `[Symbol]' was
: undefined.  It has been set to the default value ([Default]).

M bad_base -e20083
> BaseString s
> ValueString s
> Symbol s
: Symbol `[Symbol]' has an invalid base [BaseString] specified for the value
: [ValueString].

M base_no_dont_care -e20084
> BaseString s
> ValueString s
> Symbol s
: Symbol `[Symbol]' has a value [ValueString].  The base of this number
: ([BaseString]) contains don't-care digits.  Don't-care digits are not
: allowed in the base of a number.

M not_valid_digit -e20085
> Digit s
> Base s
> Symbol s
> Value s
: The digit [Digit] in the Value [Value] on the Symbol [Symbol] is not a
: valid digit in base [Base].

M xbloxval_syntax_error -e20175
> Symbol s
> Value s
: The value [Value] on the Symbol [Symbol] has syntax errors.

M type_representation_syntax_error -e20281
> Symbol s
> Type s
> Value s
: The value [Value] on the symbol [Symbol] of type [Type] is
: syntactically incorrect.  The value may be (1) a decimal
: number, or (2) a number of the form <base>#value#, where
: <base> is a number between 2 and 36 inclusive.  The value
: may include don't care digits (?) if the base is one of
: 2, 4, 8, 16, or 32.

M value_too_large -e20086
> Value s
> Symbol s
> Representation s
: The Value [Value] on Symbol [Symbol] is too large to be represented as a
: [Representation].

M representation_error -e20291
> Value s
: The value [Value] cannot be represented on this machine.

M run_prog -e20206
> ProgName s
> Version s
: Please run [ProgName], Version [Version] or later, before re-running X-BLOX.

M run_later_prog -e20258
> ProgName s
> Found_Version s
> Need_Version s
: Please run [ProgName], Version [Need_Version] or later before running
: X-BLOX.  The current file was run through Version [Found_Version].

M bad_version_syntax -e20265
> Program s
> Version s
: Your input file contains a bad PROG record for [Program].  The Version
: field contains a syntactically bad version:[.br]
: [Version][.br]
: indicating that this file was run through an old version of [Program] or
: the input file has been corrupted.  Please re-run [Program].

M bad_internal_version_syntax -e20260
> Program s
> Version s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Program][.br]
: 2. [Version]

#######################
# Timespec messages

M tnm_bad_qualifier -e20136
> Symbol s
> Type s
> Name s
> Qualifier s
> SymbolQualifier s
: The parameter "TNM=[Qualifier]:[Name]" is illegal on symbol
: [Symbol] (of type [Type]).  TNMs on this type and style of symbol may have
: the qualifier "[SymbolQualifier]", such as, "[SymbolQualifier]:[Name]".

M tnm_not_valid_ignored -w20137
> Symbol s
> Type s
> Pin s
: The TNM parameter on pin [Pin] of symbol
: [Symbol] (of type [Type]) will not be propagated through the symbol.
: [.br][.br]
: If this TNM is intended to identify logic on the opposite side of
: the [Type], then there are two ways to preserve it: (1) attach the TNM to
: the logic symbols themselves; or (2) attach the TNM to a signal which
: connects directly to that logic.

M tsid_not_valid_ignored -w20287
> Symbol s
> Type s
> Pin s
: The TS  parameter on pin [Pin] of symbol
: [Symbol] (of type [Type]) will not be propagated through the symbol.
: [.br][.br]
: If this is intended to identify logic on the opposite side of
: the [Type], then attach the
: parameter to a signal which
: connects directly to that logic.

M tnm_not_valid_on_type -e20138
> Symbol s
> Type s
> Value s
: The parameter "TNM=[Value]" is invalid on symbol [Symbol] (of type [Type]).
: TNM parameters can appear only on symbols that contain flip-flops, latches,
: RAMs, or pads.

######################
# RPM/RLOC errors/warnings

M not_valid_3k_style -w20128
> Symbol s
> Type s
> Style s
:The parameter `STYLE=[Style]' on symbol [Symbol] of type [Type] is not
:valid for XC3000A family parts.  X-BLOX will choose an appropriate style
:for you.  The valid styles for this symbol type
:on XC3000A parts are RIPPLE and FAST3KA.  See the documentation for
:restrictions on the use of the FAST3KA style.

M not_valid_4k_style -w20183
> Symbol s
> Type s
> Style s
:The parameter `STYLE=[Style]' on symbol [Symbol] of type [Type] is not
:valid for XC4000 family parts.  X-BLOX will choose an appropriate style
:for you.  The valid styles for this symbol type
:on XC4000A parts are `ALIGNED', `UNALIGNED', `BINARY', and `RIPPLE'.

M no_fast_addsub -w20129
> Symbol s
> Type s
> Pin s
:`STYLE=FAST3KA' cannot be used on on symbol [Symbol] of type [Type] because
:the [Pin] pin is connected.  Having this pin connected results in too many
:inputs per CLB for X-BLOX to properly map the symbol using this style.  Using
:`STYLE=RIPPLE' instead.

M no_fast_on_4k -w20130
> Symbol s
> Type s
> Style s
:The parameter `STYLE=FAST3KA' on symbol [Symbol] of type [Type] is not
:valid for XC4000 family parts.  This style is valid on only XC3000A family
:parts.  X-BLOX will generate an RPM for this symbol using `STYLE=[Style]'.

M co_and_ovfl_unsigned -w20119
> Symbol s
> Type s
> CoSig s
> OvflSig s
:On symbol [Symbol], of type [Type], the C_OUT pin (connected to signal
:[CoSig]) and OVFL pin (connected to signal [OvflSig]) are both used, but
:the data being operated on is unsigned.  C_OUT and OVFL are equivalent
:for unsigned numbers.

M one_hot_as_ubin -e20131
> Symbol s
> Type s
:The buses connected to symbol `[Symbol]' (type=[Type]) have
:ENCODING=ONE_HOT.  This encoding is not supported for arithmetic
:operations.

M one_bit_two_comp -e20344
> Symbol s
> Type s
:The buses connected to symbol `[Symbol]' (type=[Type]) have
:ENCODING=TWO_COMP but are only one bit wide.  One bit wide TWO_COMP buses
:are not supported for arithmetic operations in this release.

M illegal_rloc_origin -e20088
> Value s
> Symbol s
> Arch s
> Part s
: The RLOC_ORIGIN parameter `[Value]' on symbol [Symbol] of type
: [Arch] is not a valid LCA location for part [Part].

M rloc_origin_not_wrappable -e20226
> Symbol s
> Type s
: The symbol [Symbol] of type [Type] requires an RPM that is taller than the
: die size, so the RLOC_ORIGIN must be placed at row 1 so that the carry
: chain may wrap.

M rloc_origin_too_wide -e20227
> Symbol s
> Type s
> Origin s
> ChainCols s
> Part s
> PartCols s
: The symbol [Symbol] of type [Type] requires an RPM that is more than
:  [ChainCols] column(s) wide.
: Therefore it will not fit on a [Part] ([PartCols] columns wide) given
: the RLOC_ORIGIN parameter of [Origin].

M rloc_origin_too_tall -e20228
> Symbol s
> Type s
> Origin s
> ChainRows s
> Part s
> PartRows s
: The symbol [Symbol] of type [Type] requires an RPM that is
: [ChainRows] rows tall.
: Therefore it will not fit on a [Part] ([PartRows] rows tall) given
: the RLOC_ORIGIN parameter of [Origin] without needing to wrap the carry
: chain. The row coordinate of the RLOC_ORIGIN must leave enough room for
: the RPM to fit below, or else it must be 1 which will allow the chain to
: wrap.

M rloc_origin_fit_error -e20089
> Symbol s
> Type s
> Length s
> Cols s
> CLBS s
> Origin s
> Part s
:The symbol [Symbol] of type [Type], which was mapped to an RPM ([Length]
:rows long and [Cols] column(s) wide, requiring [CLBS] CLB(s)), will not
:fit on a [Part] with the given RLOC_ORIGIN parameter of `[Origin]'.  The
:origin or part must be changed so that the number of CLBs required is
:available with the RPM going up and to the right from the origin.

M rloc_range_fit_error -e20090
> Symbol s
> Type s
> Length s
> Cols s
> CLBS s
> Range s
:The symbol [Symbol] of type [Type], which was mapped to an RPM ([Length]
:rows long and [Cols] column(s) wide, requiring [CLBS] CLB(s)), will not
:fit within the given RLOC_RANGE of `[Range]'.  The range must be changed
:so that the number of CLBs required is available with the RPM going up
:and to the right from the lower left corner of the range.

M rloc_fit_error -e20176
> Symbol s
> Type s
> Length s
> Cols s
> CLBS s
> Part s
:The symbol [Symbol] of type [Type], which was mapped to an RPM ([Length]
:rows long and [Cols] column(s) wide, requiring [CLBS] CLB(s)), will not
:fit on the given part, a [Part].

M use_rloc_overrides_style -w20345
> Symbol s
> Type s
> Param s
> OldStyle s
> NewStyle s
:Symbol `[Symbol]' (type=[Type]) has the parameter USE_RLOC=[Param] which
:has changed the implementation style from the given [OldStyle] to [NewStyle].

M use_rloc_loci_conflict -w20346
> Symbol s
> Type s
> Index s
> Loc s
: Symbol `[Symbol]' (type=[Type]) has the parameters USE_RLOC=TRUE and 
: LOC[[[Index]]=[Loc]. These parameters conflict. USE_RLOC=TRUE will be
: ignored. 
: To set the absolute position of an RPM use RLOC_ORIGIN instead of 
: LOC[[i].

M rpm_size_hdr
: * RPM SUMMARY[.br]
:[.br]
: The following symbols were expanded as RPMs. The table summarizes the size
: and shape of each. Note that not all CLB resources may be required in each
: CLB and that PPR will use free resources inside of RPMs when possible.[.br]
: [.br]
: The table columns are:[.br]
:    Symbol   -- Symbol Name[.br]
:    Type     -- Symbol Type[.br]
:    CLBs     -- Number of CLBs occupied by this RPM[.br]
:    Rows     -- Vertical size of RPM[.br]
:    Cols     -- Horizontal size of RPM[.br]
:    Min Cols -- Minimum number of columns required to place the RPM[.br]
:                on the given part. This is different than horizontal[.br]
:                size only when the vertical size is bigger than the[.br]
:                number of rows on the given part. The last column of
:                the RPM may not be completely filled. See the X-BLOX
:                documentation for more information.[.br]
:[.br]
: Symbol               Type     CLBs  Rows  Cols  Min Cols[.br]
: -------------------- -------- ----  ----  ----  --------

M rpm_size_entry
> Symbol s-20.20
> Type s-8
> CLBs s4
> Rows s4
> Cols s4
> MinCols s
: [Symbol] [Type] [CLBs]  [Rows]  [Cols]  [MinCols]

M unbound_in_build_logic -e20092
> Parent s
> Signal s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Parent][.br]
: 2. [Signal]

M unconnected_in_build_logic -e20093
> Parent s
> Signal s
: INTERNAL ERROR[.br]
: Please contact Xilinx Technical Support.  Please provide the following
: details to the support personnel.  This information will be needed by the
: software developers.[.br]
: 1. [Parent][.br]
: 2. [Signal]

M bad_part_for_inlat -e20094
> Symbol s
> Part s
: The part [Part] does not have the required hardware resources to
: implement the latches in the IOB for the DATA_REG symbol [Symbol].

M not_allowed_for_inlat -e20095
> Symbol s
> Type s
> Pin s
: The current connection on the pin [Pin] of the [Type] symbol [Symbol]
: is not allowed for STYLE=ILD.

M bad_sigparam_for_inlat -e20096
> Symbol s
> Signal s
> Parameter s
: The parameter [Parameter] on the signal [Signal] connected to the symbol
: [Symbol] is not allowed for STYLE=ILD.

M bad_value_for_inlat -e20097
> Symbol s
> Parameter s
> Value s
: The parameter [Parameter] on the DATA_REG symbol [Symbol] has a value [Value]
: for STYLE=ILD.  This value cannot be supported due to hardware limitations.

M bad_src_for_inlat -e20098
> Latch s
> Source s
> SrcType s
: The flip flop symbol [Latch] is sourced by [SrcType] symbol [Source].
: This prevents the flip flop from merging it as a latch.

M bad_fanout_for_latch -e20189
> Signal s
> Fanout s
> Latch s
: The signal [Signal] that is connected to the data input of the flip flop symbol
: [Latch] has a fanout of [Fanout].  This prevents the flip flop from merging it
: as a latch.  This fanout can not be more than 2.

M bad_style_for_ff -e20266
> Style s
> OrigSymbol s
: The following flip flop symbols generated from symbol [OrigSymbol] 
: (type=DATA_REG) with STYLE=[Style] could not be merged as requested.  Please
: check the connectivity, and the attributes of the symbols and the signals
: around symbol [OrigSymbol].

M bad_style_for_ff_hdr
: Flip Flop[.br]
: ---------------------------------------

M bad_style_for_ff_line
> DFlop s
:[DFlop]


M bad_sink_for_mergeio -e20267
> Sink s
> SinkType s
> DFlop s
: The flip flop symbol [DFlop] can not be merged as specified because one
: of the sinks of signals connected to this flip flop is [Sink].  This
: symbol [Sink] is of special type [SinkType] and it prevents.

M bad_sym_attr_for_mergeio -e20268
> Symbol s
> SymType s
> Attr s
> DFlop s
: The flip flop symbol [DFlop] can not be merged as specified because
: of the attribute [Attr] on the symbol [Symbol] of type [SymType].

M bad_sig_attr_for_mergeio -e20269
> Signal s
> Attr s
> DFlop s
: The flip flop symbol [DFlop] can not be merged as specified because
: of the attribute [Attr] on the signal [Signal].

M bad_connection_for_merging -e20270
> Connection s
> Signal s
> DFlop s
: The flip flop symbol [DFlop] can not be merged as specified because
: the signal [Signal] is connected to the [Connection] pin.

M cannot_merge_in_part -e20271
> Part s
> Flops s
: The target part [Part] does not have any flip flops in its IO block.  The
: following flip flops that should be merged into io can not be merged:[.br]
: [Flops]

M trace_message_g
> Message s
> Num_Garbage s
> Garbage_Freed s
: [Message]: [Num_Garbage] garbage collections, freeing [Garbage_Freed]
: bytes.[.br]

M trace_message_gs
> Message s
> Num_Garbage s
> Garbage_Freed s
> Global s
> Trail s
> Local s
> Delta_Global s
> Delta_Trail s
> Delta_Local s
: [Message]: Stack (g/t/l): [Global]/[Trail]/[Local]; stack change:
: [Delta_Global]/[Delta_Trail]/[Delta_Local][.br]
: [Num_Garbage] garbage collections, freeing [Garbage_Freed] bytes.[.br]

M trace_message_gt
> Message s
> Num_Garbage s
> Garbage_Freed s
> Delta_Time s
: [Message]: [Delta_Time] cpu seconds[.br]
: [Num_Garbage] garbage collections, freeing [Garbage_Freed] bytes.[.br]

M trace_message_gst
> Message s
> Num_Garbage s
> Garbage_Freed s
> Global s
> Trail s
> Local s
> Delta_Global s
> Delta_Trail s
> Delta_Local s
> Delta_Time s
: [Message]: [Delta_Time] cpu seconds[.br]
: Stack (g/t/l): [Global]/[Trail]/[Local]; stack change:
: [Delta_Global]/[Delta_Trail]/[Delta_Local][.br]
: [Num_Garbage] garbage collections, freeing [Garbage_Freed] bytes.[.br]

M trace_message_s
> Message s
> Global s
> Trail s
> Local s
> Delta_Global s
> Delta_Trail s
> Delta_Local s
: [Message]: Stack (g/t/l): [Global]/[Trail]/[Local]; stack change:
: [Delta_Global]/[Delta_Trail]/[Delta_Local][.br]

M trace_message_st
> Message s
> Global s
> Trail s
> Local s
> Delta_Global s
> Delta_Trail s
> Delta_Local s
> Delta_Time s
: [Message]: [Delta_Time] cpu seconds[.br]
: Stack (g/t/l): [Global]/[Trail]/[Local]; stack change:
: [Delta_Global]/[Delta_Trail]/[Delta_Local][.br]

M trace_message_t
> Message s
> Delta_Time s
: [Message]: [Delta_Time] cpu seconds[.br]

E XBLOX
#
# ------------------ mxtool.m ------------------ 
#
#@(#)mxtool.m	6.8  1/13/94


B MXTOOL -start1726 -end1800 -current1744
: Tool Interface

# These message texts are used in other messages
M TEXT_PARAMFILE
: parameter file
M TEXT_CMDLINE
: command line
M TEXT_ILLBOOLVAL
: Illegal boolean value must be {TRUE,FALSE}: 
M TEXT_ILLINTVAL
: Illegal integer value: 
M TEXT_ILLOPTVAL
: Illegal option name must be 
M TEXT_ILLFLTVAL
: Illegal floating point value: 
M TEXT_UNKPARAM
: Unknown parameter name: 
M TEXT_UNSETPARAM
: Parameter was not assigned a value: 
M TEXT_BADVALUE
: Parameter was assigned an illegal value: 
M TEXT_BADRANGE
: Parameter value is outside valid range: 
M TEXT_PARAMHEAP
: Param
M TEXT_RESULTHEAP
: Result
M TEXT_INTERNALHEAP
: Intern
M TEXT_OTHERHEAP
: Other
M TEXT_BLANK
:

# There messages are used to produce help text for the root tool
M LOGFILE
: The program log file name
M HLOGFILE
: You can use this parameter to specify an alternate name for the program
: log file.  The default value of the log file name is the program name 
: with a .log extension
M PARAMFILE
: The parameter file name
M HPARAMFILE
: You can use this parameter to specify a file name which contains
: program parameters.  Each program parameter should appear on a line
: by itself with its value separated by an equals sign,
: E.g., "logfile=foobar.log".  If a program parameter is specified
: on the command line as well as in the parameter file, the value from
: the command line will be used.  If you do not specify a parameter file, 
: all of the programs parameters are taken from the command line.
M HELPALL
: Show all help information
M HHELPALL
: You can type "-helpall" to this tool to get help for ALL its parameters.
: The default is not to show help for all parameters.  
M HELP_NOVICE
> programname s
: For help on how to use this program, type "[programname] -help"
M HELP_TITLE
> programname s
: [.br]HELP FOR [programname][.br]
M HELP_PARAMS
: [.br]PARAMETERS:[.br]
M HELP_PARAMNAME
> param_internal_name s
> param_external_name s
: [param_internal_name][param_external_name]
M HELP_PARAMHELP
> param_help_text s
: [param_help_text]
M HELP_BITS
> leftmargin s
: [leftmargin]This parameter may be assigned one or more of these bit values:
: [.br]
M HELP_VALUES
> leftmargin s
: [leftmargin]This parameter may be assigned one of these values:
: [.br]
M HELP_STRVALUE
> leftmargin s
: [leftmargin]This parameter takes a character string value.
M HELP_FLTVALUE
> leftmargin s
> lo g.6
> hi g.6
: [leftmargin]Takes a real value between [lo] and [hi], inclusive.
M HELP_BOOLVALUE
> leftmargin s
: [leftmargin]This parameter takes a boolean value {TRUE,FALSE}
M HELP_INTVALUE
> leftmargin s
> lo d
> hi d
: [leftmargin]Takes an integer value between [lo] and [hi], inclusive.
M HELP_PINTVALUE
> leftmargin s
: [leftmargin]Takes a positive integer value.
M HELP_NNINTVALUE
> leftmargin s
: [leftmargin]Takes a non-negative integer value.
M HELP_DEFVALUE
> leftmargin s
> default    z
: [leftmargin]The default value is [default].
M HELP_DEFNONE
> leftmargin s
: [leftmargin]You must specify a value; there is no default.

# ---------------------------------------------------------------------------
# These messages are written to the plog at program startup
M LOG_BANNER
> prog_name    s
> prog_version s
> prod_name    m
> year         s
: [prog_name] [[[prog_version]]  --  [prod_name][.br]
: Copyright (c) [year] Xilinx Inc.  All Rights Reserved.

M LOG_CONFIDENTIAL
: XILINX CONFIDENTIAL

M LOG_XACT
: Xilinx Automatic CAE Tools

M PROGRAM_ENV
: Program Envelope Parameters

M PROGRAM_ENVENTRY
> name  s-20
> value s
: [name] = [value]

# ---------------------------------------------------------------------------
# These messages are written to the plog at tool startup
M TOOL_NEW_SECTION
> toolname s
: [toolname]
M TOOL_PARAMETERS
: Parameters
M TOOL_USED_EXPERT_PARAMS
: Additional Specified or Non-Default Parameters 
M TOOL_PARAMVALUE
> paramname  s
> paramvalue s
: [paramname][paramvalue]
M TOOL_TRUE
: TRUE
M TOOL_FALSE
: FALSE
M TOOL_PARAMBAR
: -----------------------

# ---------------------------------------------------------------------------
# These messages are used by the debug routine mxtool_dump_tool_table
M TOOLDEF_TITLE
: Tool Definition Table
M TOOLDEF_HEADER
# ALIGN COLUMN HEADERS WITH OPEN BRACKET
# V         V            V    V        V
# [toolname][toolversion][off][partype][parametername]
: Toolname  Version      Off  Type     Parameter[.br]
: --------  -----------  ---  -------  ---------
M TOOLDEF_ENTRY
> toolname      s-10.10
> toolversion   s-13.10
> off           s3
> partype       s-9.9
> parametername s
# DONT MESS WITH THIS MESSAGE TEXT!
: [toolname][toolversion][off]  [partype][parametername]
M TOOLINST_TITLE
: Tool Instances Remaining
M TOOLINST_HEADER
# ALIGN HEADERS WITH OPEN BRACKETS
# V     V         V
# [in]  [toolname][toolcreator]
: ---------------------------[.br]
: Inst  Toolname  Toolcreator[.br]
: ----  --------  -----------
M TOOLINST_ENTRY
> in          d4
> toolname    s-10
> toolcreator s
: [in]  [toolname][toolcreator]
M TOOLINST_FOOTER
: ---------------------------

# ---------------------------------------------------------------------------
# These messages are used to create the memory usage table for debug purposes
M MEMUSAGE_TITLE1
> name s
: Memory Usage For Tool [name]
M MEMUSAGE_TITLE2
> name s
: Memory Usage For Program [name]
M MEMUSAGE_HEADER
# [heap]      [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
: --------------------------------------------------------------------------[.br]
: Heap         Total   Total  Static   Alloc   Guard  Unused    Free   Alloc[.br]
: Name       Nsegmts  Nbytes  Overhd  Overhd  Overhd  Nbytes  Nbytes  Nbytes[.br]
: ---------- ------- ------- ------- ------- ------- ------- ------- -------
M MEMUSAGE_ENTRY
> heap s-10.10
> nseg d4
> size d6
> sohd d6
> aohd d6
> gohd d6
> unnb d6
> frnb d6
> alnb d6
: [heap]    [nseg]  [size]  [sohd]  [aohd]  [gohd]  [unnb]  [frnb]  [alnb]
M MEMUSAGE_FOOTER
: --------------------------------------------------------------------------
M MEMUSAGE_MAX
> pgmname s
> nkbytes f.3
: [pgmname] required [[[nkbytes]] Kbytes of dynamic/allocated memory

# ---------------------------------------------------------------------------
# These are WARNING messages of various sorts
M PARAM_OBSOLETE_NEXT_RELEASE -w1726
: The "param=" syntax you used on the command line will become obsolete
: next release.  You should replace it with "paramfile="

M PARAM_IGNORED -w1727
: The "param=" syntax on the command line is being ignored since you
: have also specified the parameter file name using the "paramfile=" syntax

M PLOG_OBSOLETE_NEXT_RELEASE -w1728
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" syntax from the [paramsource] will become obsolete
: next release.  You should replace it with "logfile="

M PLOG_IGNORED -w1729
> paramsource m # the TEXT_CMDLINE or TEXT_PARAMFILE message text
: The "plog=" specification from the [paramsource] is being ignored since
: you have also specified the log file name using the "logfile=" syntax

# ---------------------------------------------------------------------------
# These are ERROR messages of various sorts
M PARAM_DECL_OFFSET -e1730
> toolname  s
> paramname s
> offset    d
> paramsize d
: Tool parameter declaration offset is illegal[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, but the parameter structure size[.br]
: is only [paramsize] bytes.  Something must be very, very wrong.

M PARAM_DECL_OVERLAP -e1731
> toolname  s
> paramname s
> offset    d
> index     d
: Tool parameter declaration overlaps another[.br]
: The parameter "[paramname]" declared in the husk of tool "[toolname]"[.br]
: has an offset value of [offset] bytes, which overlaps another parameter[.br]
: at an offset of [index] bytes.  Check your calls to tool_decl_* in[.br]
: the husk module of [toolname].  You have probably have the same parameter[.br]
: name in more than one of the tool_decl_* routine.

M PARAM_ERROR -e1732
> paramsource s # the TEXT_CMDLINE or TEXT_PARAMFILE message text
> theErrors   s
: The [paramsource] contains parameter assignment errors:[theErrors]

M PARAM_ERROR_MAINTOOL -e1733
> theTool   s
> theErrors s
: The [theTool] program detected parameter value errors:[theErrors]

M PARAM_ERROR_SUBTOOL -e1734
> currenttool s
> parenttool  s
> theErrors   s
: The [currenttool] tool, invoked from [parenttool],
: detected parameter value errors:[theErrors]

M PARAM_TOOMANY -e1735
> nspecified d
> ndefined   d
: The command line contains [nspecified] positional parameters,[.br]
: but the program only needs [ndefined] parameters.

M BAD_DASH_PARAM -e1736
> param z
: The command line parameter, '[param]', is a non-boolean '-' parameter.  Only
: boolean parameter can be specified using the '-' feature, where 
: '-<parameter>' is the equivalent of TRUE and '-NO<parameter>' is the 
: equivalent of FALSE.

M INSTANCE_MISMATCH -e1737
> instancenumber d
> instancename   s
> tooldefname    s
: Tool instance - tool definition mismatch[.br]
: Tool instance #[instancenumber] is not an instance of "[tooldefname]"[.br]
: but rather an instance of "[instancename]"

M INSTANCE_ILLEGAL -e1738
> instancenumber d
: Illegal tool instance number[.br]
: Tool instance #[instancenumber] does not refer to a valid tool

M PFILE_OPEN_FAILED -e1739
> filename s
: The parameter file "[filename]" could not be opened for input

M MISSING_VALUE -e1740
> paramname s
: The command line parameter named "[paramname]"[.br]
: must be followed by an equals sign and a value

M ILLEGAL_PARAMNAME -e1741
> paramname s
: An illegal program parameter name "[paramname]"[.br]
: is used on the command line

M PLOG_OPEN_FAILED -e1742
> filename s
: The program log file "[filename]"[.br]
: could not be opened for output

M ILLEGAL_OPTIONNAME -e1743
> optionname s
: An illegal option parameter name "[optionname]"[.br]
: is used on the command line

E MXTOOL
#
# ------------------ dm.m ------------------ 
#
# @(#)dm.m	6.5  2/2/94


B DM -start1161 -end1200 -current1187
: Data Manager 

M CANNOT_WRITE_TO_FILE -e1161 -w1162
> filename s
: Cannot write file '[filename]'.  Some possible causes of this problem are
: the disk being full or problems with writing over a network.

M ADDHISTORY_FAILED -e1163 -w1164
> cellname z
> celltype s
: A history description could not be appended to the [celltype] cell
: "[cellname]" because it is a READONLY cell

M CLRHISTORY_FAILED -e1165 -w1166
> cellname z
> celltype s
: The history descriptions of the [celltype] cell "[cellname]" could not be
: cleared because it is a READONLY cell

M CLEAR_FAILED_RDONLY -e1167 -w1168
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be cleared because it is a
: READONLY cell

#M CLEAR_FAILED -e -w
#> cellname z
#> celltype s
#: The [celltype] cell "[cellname]" could not be cleared because it is
#: locked in memory

M DELETE_FAILED -e1169 -w1170
> cellname z
> celltype s
: The [celltype] cell "[cellname]" could not be deleted because it is
: locked in memory

M FILE_ACCESS -e1171 -w1172
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: exists, but could not be opened

M FILE_MISSING -e1173 -w1174
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be found.

M FILE_OPEN_FAILED -e1175 -w1176
> cellname z
> filename z
> celltype s
: The file "[filename]" associated with the [celltype] cell "[cellname]"
: could not be opened

M HEADER_CELLTYPENAME -e1177 -w1178
> cellname z
> filename z
> celltype s
: The type of the cell "[cellname]" associated with the file "[filename]"
: does not correspond to the expected "[celltype]" type.

M HEADER_ERROR -e1179 -w1180
> cellname z
> filename z
> celltype s
: The file "[filename]" for the [celltype] cell "[cellname]" contains an
: illegal header

M NAME_FAILED -e1181 -w1182
> cellname z
> newname  s
> celltype s
: The [celltype] cell "[cellname]" could not be renamed to "[newname]"
: because a [celltype] cell named "[newname]" already exists

M TYPE_FAILED -e1183 -w1184
> typename s
> cellname z
: The type of cell "[cellname]" could not be changed to "[typename]"
: because a cell of that name/type already exists

M NEWCELL_FAILED -e1185 -w1186
> cellname s
> celltype s
: The [celltype] cell "[cellname]" could not be created because a cell of
: that type and name already exists

#
# Data Manager Messages
#
M SAVECELL_SECTION
: Data Manager Auto Save

M SAVECELL
> cellname z
> typename s
: Saving [typename] cell "[cellname]"

M LOCKCOUNT_SECTION
: Data Manager Cell Lock Counts

M LOCKCOUNT
> cellname z-10
> typename s-10
> lockcount d2
: [cellname] [typename] [lockcount]

E DM




#
# ------------------ mxpart.m ------------------ 
#
#@(#)mxpart.m	6.2 9/3/93

B MXPART -start1131 -end1160 -current1148
: File reader for partlist.xct file and <package>.pkg files

M CANT_OPEN_FILE -e1131 -w1132
> filename s
: Cannot open file '[filename]' for reading.

M NO_PKG -e1133 -w1134
> part s
> filename s
: The part '[part]' could not be found in the file '[filename]'.

M BAD_ATTRIB_VALUE -e1135 -w1136
> partname s
> filename s
: The attribute list (name=value entries) for the part '[partname]' in the
: file '[filename]' has the wrong format.

M ILLEGAL_PKG_KEYWORD -e1137 -w1138
> value s
: Illegal keyword '[value]' exists in the .pkg file.
 
M DUP_PAD_DEF_IN_PKG -e1139
> pad s
: Duplicate definition of PAD '[pad]'.

M DUP_PIN_DEF_IN_PKG -e1140
> pin s
: Duplicate definition of PIN '[pin]'.

M PAD_NUM_OUT_OF_RANGE -e1141
> pad s
: Pad number '[pad]' is out of range.

M BAD_PAD_NUM -e1142
> pad s
: Bad pad number '[pad]'. Should be in the form: PAD<number>.

M WRONG_ATTR_VALUE -e1143
> value s
> chk_value s
: Attribute value '[value]' does not match check value '[chk_value]'.

M ILLEGAL_FAMILY -e1144
> family d
: Not a legal family '[family]'.

M ILLEGAL_FAMILY_ATTR -e1145
> attrib s
> family d 
: Not a legal attribute '[attrib]' for this family '[family]'.

M BAD_ROWCOL -e1146
: Not and integer value for clb row|cols number.

M CLK_BUF -e1147
> pad s
> padn d
: Clock Buffer using '[pad]' should use 'PAD[padn]'.

E MXPART
#
# ------------------ speed.m ------------------ 
#
#@(#)speed.m	6.4  9/3/93

B SPEED -start 1101 -end1130 -current14
: File reader for speeds.xct file 

M CANT_OPEN_FILE -e0 -w1
> filename s
: Cannot open file '[filename]' for reading.

M FILE_CORRUPTED -e2 -w3
> filename s
: The speeds file '[filename]' has been corrupted and cannot be read.

M CANT_READ_FILE -e4 -w5
> filename s
: The unencrypted speeds file '[filename]' cannot be read.

M BAD_PARTLIST_FILE -e6 -w7
: The partlist.xct file does not contain the correct information.

M UNKNOWN_SPEED_AND_PART -e8 -w9
> speed s
> part s
: The speed '[speed]' is unavailable for part '[part]'.

M BAD_VERSION -e10 -w11
> filename s
> badversion s
> version s
: The '[filename]' file has a bad version, '[badversion]'.
: The version of file must be '[version]'.

M SYNTAX_ERROR -e12 -w13
> filename s
: There is a syntax error in the '[filename]' speeds file.

E SPEED
