   14521
"	VERSION 5.02			Copyright(C) 1993 Data I/O Corp.
"==============================================================================
" constant.inc
"
Z,C,K,X,U,D,P,H,L = .Z., .C., .K., .X., .U., .D., .P., 1, 0;
TRUE, FALSE = !0, 0;


" E0320.INC

	MISER macro (a) { fuses [2912,2913] = [?a,?a]; };

	TURBO macro (a) { fuses [2914,2915] = [?a,?a]; };


" E0600.INC

	TURBO macro (a) { fuses [6480,6481] = [?a,?a]; };


" E0900.INC

	TURBO macro (a) { fuses [17400,17401] = [?a,?a]; };


" E1800.INC

	MISER_CLK_C macro (a) { fuses 42480 = ?a; };
	MISER_CLK_B macro (a) { fuses 42481 = ?a; };
	MISER_CLK_A macro (a) { fuses 42482 = ?a; };
	MISER_CLK_D macro (a) { fuses 42483 = ?a; };
	MISER_IN_C  macro (a) { fuses 42484 = ?a; };
	MISER_IN_B  macro (a) { fuses 42485 = ?a; };
	MISER_IN_A  macro (a) { fuses 42486 = ?a; };
	MISER_IN_D  macro (a) { fuses 42487 = ?a; };

	TURBO macro (a) { fuses [42488,42489] = [?a,?a]; };

" F6001.INC
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 8222;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 9) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
" P16V8 Electronic Signature Word
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 2056;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 8) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
" P16Z8 Electronic Signature Word
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 2056;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 8) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
" P20V8 Electronic Signature Word
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 2568;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 8) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
" P22V10G Electronic Signature Word
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 5828;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 8) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
" P26CV12 Electronic Signature Word
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 6368;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 8) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
" P18V10G Electronic Signature Word
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 3476;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 8) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
" P330.INC
"The following enables clock 2 (pin 3)
CLK2    macro () {FUSES[17070] = 1;}

"The following program the C3 bit in the Output Macrocell
"and selects feedback from the lower pin.
FEEDPIN_27 macro () {FUSES[17031] = 1;}
FEEDPIN_25 macro () {FUSES[17038] = 1;}
FEEDPIN_23 macro () {FUSES[17045] = 1;}
FEEDPIN_19 macro () {FUSES[17052] = 1;}
FEEDPIN_17 macro () {FUSES[17059] = 1;}
FEEDPIN_15 macro () {FUSES[17066] = 1;}


" P331.INC
	"The following program the C2 bit in the Output Macrocell
	"and selects feedback from the lower pin.
	FEEDPIN_27 macro () {FUSES[11906] = 1;}
	FEEDPIN_25 macro () {FUSES[11911] = 1;}
	FEEDPIN_23 macro () {FUSES[11916] = 1;}
	FEEDPIN_19 macro () {FUSES[11921] = 1;}
	FEEDPIN_17 macro () {FUSES[11926] = 1;}
	FEEDPIN_15 macro () {FUSES[11931] = 1;}


" P5000.INC
 
IO4_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 4 is not used as pin feedback nor input pin'
  FUSES [162624,162627,162630] = [1,0,0];
DECLARATIONS
}
IO5_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 5 is not used as pin feedback nor input pin'
  FUSES [162633,162636,162639] = [1,0,0];
DECLARATIONS
}
IO6_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 6 is not used as pin feedback nor input pin'
  FUSES [162642,162645,162648] = [1,0,0];
DECLARATIONS
}
IO7_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 7 is not used as pin feedback nor input pin'
  FUSES [162651,162654,162657] = [1,0,0];
DECLARATIONS
}
IO8_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 8 is not used as pin feedback nor input pin'
  FUSES [162660,162663,162666] = [1,0,0];
DECLARATIONS
}
IO9_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 9 is not used as pin feedback nor input pin'
  FUSES [162669,162672,162675] = [1,0,0];
DECLARATIONS
}
IO10_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 10 is not used as pin feedback nor input pin'
  FUSES [162678,162681,162684] = [1,0,0];
DECLARATIONS
}
IO11_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 11 is not used as pin feedback nor input pin'
  FUSES [162687,162690,162693] = [1,0,0];
DECLARATIONS
}
IO12_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 12 is not used as pin feedback nor input pin'
  FUSES [162696,162699,162702] = [1,0,0];
DECLARATIONS
}
IO13_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 13 is not used as pin feedback nor input pin'
  FUSES [162705,162708,162711] = [1,0,0];
DECLARATIONS
}
IO14_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 14 is not used as pin feedback nor input pin'
  FUSES [162714,162717,162720] = [1,0,0];
DECLARATIONS
}
IO15_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 15 is not used as pin feedback nor input pin'
  FUSES [162723,162726,162729] = [1,0,0];
DECLARATIONS
}
IO17_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 17 is not used as pin feedback nor input pin'
  FUSES [162732,162735,162738] = [1,0,0];
DECLARATIONS
}
IO18_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 18 is not used as pin feedback nor input pin'
  FUSES [162741,162744,162747] = [1,0,0];
DECLARATIONS
}
IO19_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 19 is not used as pin feedback nor input pin'
  FUSES [162750,162753,162756] = [1,0,0];
DECLARATIONS
}
IO21_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 21 is not used as pin feedback nor input pin'
  FUSES [162759,162762,162765] = [1,0,0];
DECLARATIONS
}
IO22_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 22 is not used as pin feedback nor input pin'
  FUSES [162768,162771,162774] = [1,0,0];
DECLARATIONS
}
IO23_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 23 is not used as pin feedback nor input pin'
  FUSES [162777,162780,162783] = [1,0,0];
DECLARATIONS
}
IO24_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 24 is not used as pin feedback nor input pin'
  FUSES [162786,162789,162792] = [1,0,0];
DECLARATIONS
}
IO25_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 25 is not used as pin feedback nor input pin'
  FUSES [162795,162798,162801] = [1,0,0];
DECLARATIONS
}
IO26_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 26 is not used as pin feedback nor input pin'
  FUSES [162804,162807,162810] = [1,0,0];
DECLARATIONS
}
IO27_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 27 is not used as pin feedback nor input pin'
  FUSES [162813,162816,162819] = [1,0,0];
DECLARATIONS
}
IO28_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 28 is not used as pin feedback nor input pin'
  FUSES [162822,162825,162828] = [1,0,0];
DECLARATIONS
}
IO29_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 29 is not used as pin feedback nor input pin'
  FUSES [162831,162834,162837] = [1,0,0];
DECLARATIONS
}
IO30_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 30 is not used as pin feedback nor input pin'
  FUSES [162840,162843,162846] = [1,0,0];
DECLARATIONS
}
IO31_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 31 is not used as pin feedback nor input pin'
  FUSES [162849,162852,162855] = [1,0,0];
DECLARATIONS
}
IO38_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 38 is not used as pin feedback nor input pin'
  FUSES [162858,162861,162864] = [1,0,0];
DECLARATIONS
}
IO39_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 39 is not used as pin feedback nor input pin'
  FUSES [162867,162870,162873] = [1,0,0];
DECLARATIONS
}
IO40_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 40 is not used as pin feedback nor input pin'
  FUSES [162876,162879,162882] = [1,0,0];
DECLARATIONS
}
IO41_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 41 is not used as pin feedback nor input pin'
  FUSES [162885,162888,162891] = [1,0,0];
DECLARATIONS
}
IO42_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 42 is not used as pin feedback nor input pin'
  FUSES [162894,162897,162900] = [1,0,0];
DECLARATIONS
}
IO43_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 43 is not used as pin feedback nor input pin'
  FUSES [162903,162906,162909] = [1,0,0];
DECLARATIONS
}
IO44_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 44 is not used as pin feedback nor input pin'
  FUSES [162912,162915,162918] = [1,0,0];
DECLARATIONS
}
IO45_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 45 is not used as pin feedback nor input pin'
  FUSES [162921,162924,162927] = [1,0,0];
DECLARATIONS
}
IO46_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 46 is not used as pin feedback nor input pin'
  FUSES [162930,162933,162936] = [1,0,0];
DECLARATIONS
}
IO47_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 47 is not used as pin feedback nor input pin'
  FUSES [162939,162942,162945] = [1,0,0];
DECLARATIONS
}
IO48_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 48 is not used as pin feedback nor input pin'
  FUSES [162948,162951,162954] = [1,0,0];
DECLARATIONS
}
IO49_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 49 is not used as pin feedback nor input pin'
  FUSES [162957,162960,162963] = [1,0,0];
DECLARATIONS
}
IO51_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 51 is not used as pin feedback nor input pin'
  FUSES [162966,162969,162972] = [1,0,0];
DECLARATIONS
}
IO52_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 52 is not used as pin feedback nor input pin'
  FUSES [162975,162978,162981] = [1,0,0];
DECLARATIONS
}
IO53_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 53 is not used as pin feedback nor input pin'
  FUSES [162984,162987,162990] = [1,0,0];
DECLARATIONS
}
IO55_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 55 is not used as pin feedback nor input pin'
  FUSES [162993,162996,162999] = [1,0,0];
DECLARATIONS
}
IO56_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 56 is not used as pin feedback nor input pin'
  FUSES [163002,163005,163008] = [1,0,0];
DECLARATIONS
}
IO57_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 57 is not used as pin feedback nor input pin'
  FUSES [163011,163014,163017] = [1,0,0];
DECLARATIONS
}
IO58_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 58 is not used as pin feedback nor input pin'
  FUSES [163020,163023,163026] = [1,0,0];
DECLARATIONS
}
IO59_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 59 is not used as pin feedback nor input pin'
  FUSES [163029,163032,163035] = [1,0,0];
DECLARATIONS
}
IO60_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 60 is not used as pin feedback nor input pin'
  FUSES [163038,163041,163044] = [1,0,0];
DECLARATIONS
}
IO61_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 61 is not used as pin feedback nor input pin'
  FUSES [163047,163050,163053] = [1,0,0];
DECLARATIONS
}
IO62_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 62 is not used as pin feedback nor input pin'
  FUSES [163056,163059,163062] = [1,0,0];
DECLARATIONS
}
IO63_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 63 is not used as pin feedback nor input pin'
  FUSES [163065,163068,163071] = [1,0,0];
DECLARATIONS
}
IO64_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 64 is not used as pin feedback nor input pin'
  FUSES [163074,163077,163080] = [1,0,0];
DECLARATIONS
}
IO65_B_FB MACRO()
{
  @MESSAGE 'Make sure pin 65 is not used as pin feedback nor input pin'
  FUSES [163083,163086,163089] = [1,0,0];
DECLARATIONS
}
 


"Include file - 4bcomp.inc
"4 bit comparator
"Inputs:  q3, q2, q1, q0, d3, d2, d1, d0     
"Output:  compare        

    compare = ([q3..q0] == [d3..d0]);



"Include file - 4bcount.inc
"4 bit counter 
"Inputs: clock, hold, reset
"Outputs: q3, q2, q1, q0

    q3,q2,q1,q0 pin istype 'reg,buffer';
    count = [q3..q0];

equations

    count.clk = clock;  "clock input
    count.ar = reset;   "asynchronous reset

       when (hold)  then count := count.fb;
  else when (!hold) then count := count.fb + 1;




"Include file - 4binreg.inc
"4 input registers in a group. 
"Inputs: load, in3, in2, in1, in0
"Outputs:  d3, d2, d1, d0 

    d3,d2,d1,d0 node istype 'reg,buffer';
    inputs = [in3..in0];
    inreg = [d3..d0];


equations

    inreg.clk = load;
    inreg := inputs;


"ispGDS MACROs

GDS_DEVICE_INIT MACRO
{
	FUSES
	[ 0..10] = ^b11111111111;
	[11..21] = ^b11111111111;
	[22..32] = ^b11111111111;
	[33..43] = ^b11111111111;
	[44..54] = ^b11111111111;
	[55..65] = ^b11111111111;
	[66..76] = ^b11111111111;
	[77..87] = ^b11111111111;
	[88..98] = ^b11111111111;
	[99..109] = ^b11111111111;
	[110..120] = ^b11111111111;
}

GDS_IO MACRO (Group, MCnum, Type)
{
@ifniden(?Group,A)
 {@ifniden(?Group,B)
    {@message 'Invalid Group, must be A or B'; @exit}}

@if((?MCnum<0)#(?MCnum>10))  
    {@message 'Invalid Macrocell_Number, must be between 0 and 10'; @exit}

@ifiden(?Group,A){
    @const c0 = 174 - ?MCnum;
    @const c1 = 196 - ?MCnum;
    @const c2 = 218 - ?MCnum;}

@ifiden(?Group,B){
    @const c0 = 153 + ?MCnum;
    @const c1 = 175 + ?MCnum;
    @const c2 = 197 + ?MCnum;}

@const Bits = ^B110; "set illegal value
@ifiden(?Type,INPUT)	{@const Bits = ^B101;}
@ifiden(?Type,OUT_NOINV){@const Bits = ^B011;}
@ifiden(?Type,OUT_INV)	{@const Bits = ^B001;}
@ifiden(?Type,TTL_1)	{@const Bits = ^B010;}
@ifiden(?Type,TTL_0)	{@const Bits = ^B000;}
@ifiden(?Type,OUT_TRI)	{@const Bits = ^B111;}
" if illegal value never changed, then Type was not valid
@if (Bits == ^B110)
  {@message 'Invalid Macrocell Type'; @exit}

[@expr c0;,@expr c1;,@expr c2;] = Bits;
} 

 
GDS_CONNECT MACRO (Group, MCout, MCin)
{

@ifniden(?Group,A)
 {@ifniden(?Group,B)
    {@message 'Invalid Group, must be A or B'; @exit}}

@if((?MCout<0)#(?MCout>10))
    {@message 'Invalid Output macrocell number'; @exit}
@if((?MCin<0)#(?MCin>10))  
    {@message 'Invalid Input macrocell number'; @exit}

@ifiden(?Group,A){
    @const Fuse = (10 + (?MCout * 11)) - ?MCin;
    @expr Fuse; = 0;}

@ifiden(?Group,B){
    @const Fuse = (10 - ?MCout) + (?MCin * 11);
    @expr Fuse; = 0;}

}
" F6001.INC
SIGNATURE MACRO (string)
{
   @CONST cnt = 1;
   @CONST r1 = 8222;	" First address of signature word
   @IRPC A (?string)
   {
	@IF (cnt > 9) { @MESSAGE 'WORD TOO LONG'; @EXIT;}
   	FUSES [@EXPR r1;..@EXPR (r1+7);] = @EXPR '?A';;
	@CONST  r1 = r1 + 8;
	@CONST	cnt = cnt + 1;
   }
}
21 
4bcomp.inc 11665 160 ""
4bcount.inc 11825 351 ""
4binreg.inc 12176 271 ""
constant.inc 139 100 ""
e0320.inc 239 118 ""
e0600.inc 357 66 ""
e0900.inc 423 68 ""
e1800.inc 491 437 ""
f39v18.inc 14227 294 ""
f6001.inc 928 294 ""
gds.inc 12447 1780 ""
p16v8.inc 1222 316 ""
p16z8.inc 1538 316 ""
p18v10g.inc 2806 318 ""
p20v8.inc 1854 316 ""
p22v10g.inc 2170 318 ""
p26cv12.inc 2488 318 ""
p330.inc 3124 429 ""
p331.inc 3553 361 ""
p5000.inc 3914 7751 ""
version.inc 9 130 ""
