;
; Entries :
;		saveda - save drawing accelerator registers.
;		rstrda - undo a saveda.
;		savech - save current font parameters etc.
;		rstrch - undo a savech.
;		setclt - update color lookup dacs.
;		erase  - erase screen.
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Save drawing accelerator state.  Does	;
; not save color table registers.	;
; Enter with a pointer to a save area in;
; the acc.  If acc = 0, saveda gets	;
; heap space for this purpose.  Pointer	;
; to the saved stuff is returned in acc.;
; If the returned pointer is 0, no heap	;
; was available and no save was done.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

saveda:

$nbytes	equ	56		; # bytes heap needed to save state.

	php
	rep	#0x30
	pha
	phx
	phy
	phd
	phb

	pea	##0
	plb
	plb

	cmp	##0		; caller got a buffer already ?
	bne	$1		; br if yes.
	pea	##$nbytes	; no, get amount needed from heap.
	jsl	>0,GetHeap
	pla			; pull pointer to buffer (maybe).
	bcc	$ok		; br if got a buffer.
	brl	$error		; br if no heap avail.
$ok:	sta	8,s		; save pointer in callers acc.
$1:	
	tay			; point y to buffer
	lda	##0xfe00
	tcd			; point d to drawing accelerator.
	ldx	##0x2e		; index of last param register in d.
$wait:
	bit	Dpdone-1
	bvc	$wait
;
; save parameter registers
; (in backwards order).
;

$loop:
	lda	<0,x		; get next param reg.
	sta	0,y		; save it in callers buffer.
	iny			; point to next buffer slot.
	iny
	dex			; and to next param.
	dex
	bpl	$loop		; br if haven't done pr0 yet.
;
; save the 8 bit registers.
; 0,y is addr next space in buffer.
;
	sep	#0x20
	lda	<0x40		; read mask.
	sta	0,y
	lda	<0x42		; overlay color.
	sta	1,y
	lda	<0x4c		; write mask.
	sta	2,y
	lda	<0x4e		; control reg.
	sta	3,y
	lda	<0x50		; stipple reg.
	sta	4,y
	lda	<0x52		; flags reg.
	sta	5,y
	lda	<0x54		; fg color.
	sta	6,y
	lda	<0x56		; bg color.
	sta	7,y

$error:
	rep	#0x30
	plb
	pld
	ply
	plx
	pla
	plp
	rtl


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Restore drawing accelerator.	;
; Enter with pointer from saveda;
; in acc.  Does NOT return save	;
; area to heap - keep the pointer
; and use it again if needed.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

rstrda:

$nbytes	equ	56		; # bytes heap needed to save state.

	php
	rep	#0x30
	pha
	phx
	phy
	phd
	phb

	pea	##0
	plb
	plb

	tay			; point y to buffer
	lda	##0xfe00
	tcd			; point d to drawing accelerator.
	ldx	##0x2e		; index of last param register in d.
$wait:
	bit	Dpdone-1
	bvc	$wait
;
; restore parameter registers
; (were saved in backwards order).
; Note that the xorg,yorg registers are
; restored before the virtual cap registers,
; 
;

$loop:
	lda	0,y		; get next saved param reg.
	sta	<0,x		; put it where it belongs.
	iny			; point to next buffer slot.
	iny
	dex			; and to next param.
	dex
	bpl	$loop		; br if haven't done pr0 yet.
;
; save the 8 bit registers.
; 0,y is addr next space in buffer.
;
	sep	#0x20
	lda	0,y
	sta	<0x40		; read mask.
	lda	1,y
	sta	<0x42		; overlay color.
	lda	2,y
	sta	<0x4c		; write mask.
	lda	3,y
	sta	<0x4e		; control reg.
	lda	4,y
	sta	<0x50		; stipple reg.
	lda	5,y
	sta	<0x52		; flags reg.
	lda	6,y
	sta	<0x54		; fg color.
	lda	7,y
	sta	<0x56		; bg color.

	rep	#0x30
;
; Turns out the xwtop, ywtop registers
; have to be written after the
; xwbot, ywbot registers, so do it again.
;
	lda	8,s		; get original buffer pointer
	tay
	lda	0,y		; restore ywtop again.
	sta	Ywtop
	lda	2,y		; and xwtop.
	sta	Xwtop	
	
	plb
	pld
	ply
	plx
	pla
	plp
	rtl
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Copy color table image to actual clt.	;
; Enter with number of colors to set in	;
; x, first color number in y.		;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setclt:
	php
	rep	#0x30
	pha
	phx
	phy
	sep	#0x30

;	lda	Blink
;	pha
;	stz	Blink
	
$1:	bit	Dpdone		; wait for dpu not busy.
	bvc	$1	

	lda	#vbmask
$wv:	bit	Vbflag
	bne	$wv

$loop:	lda	#vbmask
$loop1:	bit	Vbflag
	beq	$loop1

	nop
	nop

	lda	Redclt,y
	sty	Rbcltn
	sta	0xfe46
	lda	Grnclt,y
	sta	0xfe48
	lda	Bluclt,y
	sta	0xfe4a
	iny
	dex
	bne	$loop

$done:
;	pla
;	sta	Blink

	rep	#0x30
	ply
	plx
	pla
	plp
	rtl

;;;;;;;;;;;;;;;;;
; Erase screen.	;
;;;;;;;;;;;;;;;;;

erase:
	php
	rep	#0x20
	pha

$1:	bit	Dpdone-1		; wait dpu not busy.
	bvc	$1
	lda	##0			; first line to erase.
	sta	0xfe00
	lda	##255			; # (lines/4)-1
	sta	0xfe02

	sta	DaErs			; do the erase.

	pla
	plp
	rtl
gfxend:
	end
