
;
;	Enter with opcode in acc.  Returns instruction length
;	in acc.  
;
inslen:
	php
	rep	#0x30
	phx
	phy

	and	##0xff
	asl	a		; convert to word offset
	tay			; put offset in y
	per	opctyp		; put base adr of tbl on stack
	lda	(1,s),y		; get entry for this opcode
	plx			; pop base off stack
;
;	the accumulator has the index to the opcode name
;	and the operand type
;
	and	##0xff		; mask off opname index
	tay			; offset into instruction length tbl
	per	opclen		; base of opcode length table
	lda	(1,s),y		; get the length of the instruction
	and	##0xff
	plx			; pop base off stack

	sep	#0x30		; 8 bit m/x
	bit	#0xc0		; check for IMM instructions
	beq	$3		; done if not IMM

;
;	calculate the length of an immediate instruction
;	based on the state of the M (or X) bits in the PSW
;

	and	#0xc0		; imm x (0x40) or imm m (0x80) ?
	tax
	ldy	#2		; assume 8 bit imm (length = 2)
	lda	#0x20		; psw bit to test (assume imm mem)
	cpx	#0x80		; imm mem ?
	beq	$1		; branch if yes

	lda	#0x10		; no, get mask for psw X bit
$1:
	bit	<sps		; M/X bit set in psw ?
	bne	$2		; yes, y has correct length.
	iny			; no, 16 bit imm
$2:
	tya			; return length in acc.
$3:
	rep	#0x30
	and	##0x7		; mask off non-length bits.

	ply
	plx
	plp
	rts

;
;	Enter with opcode in acc.
;	Return with carry set if opcode is branch, jump, 
;	call or return.
;	All registers preserved.
;

tstgoto:
	clc			; assume not a goto.
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x30
	per	$gotoes-1	; gotoes opcode table.
	ldy	#$lstgo-$gotoes	; number of goto opcodes and
				; index of last one in table.
$loop:
	cmp	(1,s),y
	beq	$found
	dey
	bne	$loop
	bra	$done

$found:
	lda	9,s		; get callers psw.
	ora	#1		; set his carry.
	sta	9,s

$done:	rep	#0x30
	pla			; clean up stack

	ply			; restore callers registers
	plx
	pla
	plp
	rts

$gotoes:	
	dcb	0x02	;cop
	dcb	0xdc	;jml(abs)
	dcb	0xfc	;jsr(abs,x)
	dcb	0x7c	;jmp(abs,x)
	dcb	0x6c	;jmp(abs)
	dcb	0x22	;jsr >pbr,abs
	dcb	0x5c	;jmp >pbr,abs
	dcb	0x20	;jsr abs
	dcb	0x4c	;jmp abs
	dcb	0x40	;rti
	dcb	0x6b	;rtl
	dcb	0x70	;bvs
	dcb	0x50	;bvc
	dcb	0x10	;bpl
	dcb	0x30	;bmi
	dcb	0xb0	;bcs
	dcb	0x90	;bcc
	dcb	0x60	;rts
	dcb	0x80	;bra
	dcb	0xf0	;beq
	dcb	0xd0	;bne
	dcb	0x82	;brl
$lstgo:
;
;	Enter with opcode in acc.  Returns with carry set if
;	opcode is a branch.  If the carry is set, the overflow
;	flag is set if the branch will be taken.
;	All registers preserved.
;

tstbra:
	clc			; assume not a branch - clear c,v
	clv
	php
	rep	#0x30
	pha
	phx
	phy

	sep	#0x30
	cmp	#0x80		; bra ?
	beq	$1
	cmp	#0x82		; brl ?
	bne	$2
$1:	brl	$taken
$2:

;
;	This section of code is based on the format of the
;	conditional branch opcodes.  They all look (in binary)
;	like ccs10000, where cc identifies the psw bit to
;	be tested, and s is 1 if the branch is on bit set.
;
	tax			; save opcode in x.

	and	#0x1f		; see if opcode is 
	cmp	#0x10		; a conditional branch.
	bne	$nobr		; branch if not a branch instr.	

	lda	7,s		; its a branch, indicate in
	ora	#1		; callers psw by setting carry.
	sta	7,s

;
;	now move s bit to carry flag and cc bits to y
;

	txa			; recover opcode.

	lsr	a		; get rid of the 10000 part.
	lsr	a
	lsr	a
	lsr	a
	lsr	a		; now acc = 00000ccs

	lsr	a		; move s bit to carry flag.
	tay			; save cc bits for indexing.

	lda	<sps		; get user psw.
	bcs	$3		; branch if branch is on set psw bit.
	eor	#0xff		; invert the psw bit to be tested.
$3:
	per	$psbits		; push psw bit table addr.
	and	(1,s),y		; test the condition.
	ply			; clean up stack.
	ply
	cmp	#0		; branch condition true ?
	beq	$nobr		; branch if no.

$taken:	lda	#0x41		; branch is taken, indicate by
	ora	7,s		; setting v in callers psw (also
	sta	7,s		; set carry in case we jumped here
				; with a bra/brl).

$nobr:	rep	#0x30
	ply
	plx
	pla
	plp
	rts
	
$psbits:	dcb	0x80	; cc = 0, test minus flag.
		dcb	0x40	; cc = 1, test overflow.
		dcb	0x1	; cc = 2, test carry.
		dcb	0x2	; cc = 3, test zero.

;
;	Enter with current instruction addr,pbr in <nextin.
;	Return value in <nextin is address of next
;	instruction to be executed.  Bank switching
;	is indicated by the MSB of <nextin - ff for bank
;	change, else 0.
;	All registers preserved.
;

nxtexe:
	php
	rep	#0x30
	pha
	phx
	phy

	lda	[<nextin]	; get opcode.
	and	##0xff	
	sep	#0x20
	stz	<nextin+3	; assume next in same bank.	

;
;	see if opcode is some kind of goto
;

	bsl	tstgoto
	bcs	$dogoto	

;
;	opcode wasn't branch or jump, so next executed
;	is next sequential.
;

	bsl	inslen		; get instruction length
	rep	#0x30
	clc
	adc	<nextin		; add length to current pc
	sta	<nextin		; save addr next exec instr
	brl	done		; clean stack and return

$dogoto:

;
;	check for the branches, determine
;	whether it will be taken, and what the
;	offset is (YUK)
;

	bsl	tstbra		; set carry if branch and v if taken.
	bcc	chkjmp		; not a branch, check jumps etc.
	bvs	$br		; branch taken.

$nobr:				; branch not taken.
	rep	#0x20		; 16 bit memory
	lda	##2
	bra	brdone

;
;	branch taken, calculate a sign-extended offset
;	brl is special-cased because its a 2 byte 
;	signed displacement.
;

$br:
	rep	#0x20
	ldy	##1
	cmp	##0x82		; brl?
	bne	$1		; nope
	lda	[<nextin],y	; get the offset for brl
	inc	a		; add brl instr length
	bra	$br1
$1:
	lda	[<nextin],y	; get the offset
	and	##0xff		; mask high byte
	bit	##0x80		; sign extend?
	beq	$br1		; nope
	ora	##0xff00
$br1:
	inc	a		; add size of branch to offset
	inc	a
brdone:
	clc			; add offset to pc
	adc	<nextin
	sta	<nextin
	brl	done		; clean up stack and return

;
;	opcode wasn't a branch, check the jumps
;

chkjmp:
	rep	#0x30		; for convenience prefetch
	ldy	##1		; the word following opcode
	tax			; and save it in y
	lda	[<nextin],y
	tay
	txa

	cmp	##0x4c		; jmp abs ?
	beq	$1		; 
	cmp	##0x20		; jsr abs ?
	bne	$2		; 
$1:
	sty	<nextin
	brl	done
$2:
	cmp	##0x5c		; jmp >pbr,abs ?
	beq	$21
	cmp	##0x22		; jsl >pbr,abs ?
	bne	$3
$21:
	tyx			; save new pc
	ldy	##3		; get new bank
	lda	[<nextin],y
	brl	bswitch		; go handle poss bank change
$3:
	cmp	##0x6c		; jmp (abs) ?
	bne	$4
	tyx			; get abs in y
	lda	>0,0,x		; fetch new pc (always from >0)
	sta	<nextin		; save it
	brl	done
$4:
	cmp	##0xdc		; jml (abs) ?
	bne	$5
	tyx			; get abs in x
	lda	>0,0,x		; fetch new pc (from >0 always)
	pha			; save new pc
	lda	>0,2,x		; get new bank
	plx			; get new pc
	brl	bswitch		; go do possible bank switch
$5:
	cmp	##0x7c		; jmp (abs,x) ?
	beq	$51
	cmp	##0xfc		; jsr (abs,x) ?
	bne	$6
$51:
	sty	<nextin		; point to jump table (in pbr)
	ldy	<six		; get index into table
	lda	[<nextin],y	; fetch new pc
	sta	<nextin		; store new pc
	brl	done

;
;	not a jump, check rts rtl rti
;

$6:	cmp	##0x60		; rts ?
	bne	$7
	ldx	<ssp		; get user sp in x
	lda	>0,5,x		; fetch stacked addr
	inc	a		; inc like rts would
	sta	<nextin		; save it
	brl	done
$7:
	cmp	##0x6b		; rtl ?
	bne	$8
	ldx	<ssp
	lda	>0,5,x		; get ret addr (minus 1)
	inc	a
	pha
	lda	>0,7,x		; get pbr
	plx
	brl	bswitch
$8:
	cmp	##0x40		; rti ?
	bne	$9

	ldx	<ssp		; get user sp
	lda	>0,6,x		; fetch stacked addr
	pha
	lda	>0,8,x		; and pbr
	plx
	brl	bswitch
$9:
	cmp	##0x02		; cop ?
	bne	$hosed
	lda	>0,0xffe4	; get cop vector
	tax
	lda	##0		; and new pbr
	bra	bswitch		; handle poss pbr change
;
;	here on internal error
;
$hosed:
	pha			; push bad opcode
	pea	##2
	per	$ermsg
	bsl 	printf
	bra 	done
$ermsg:	dcs	"hosure in nxtexe, op = %b\r\n\0"

;
;	Here to handle possible bank change from
;	long jumps.  Enter with new pc in x and
;	new bank in acc. (16 bit m/x assumed).
;

bswitch:
	and	##0xff
	cmp	<nextin+2	; same bank ?
	beq	$1		; branch if yes
	ora	##0xff00	; no, set bank switch flag
$1:
	stx	<nextin		; store new pc
	sta	<nextin+2	; and pbr
	brl	done		; clean stack and return

done:
	rep	#0x30

	ply
	plx
	pla
	plp
	rts
	end
