#include "tcp.h"

#define printable(c) ( (c >= ' ') && (c <= '~') )

/* tapint MUST be called before any other TAP function */

tapint()

{
	esc();
	rst();
	esc();
}

/* conversion of x,y coord. to xy20 format */ 

encode(add, x, y)
register char *add;
int x,y;
{
	*add++ = (x.hibyte << 4) | (y.hibyte & 15);
	*add++ = x;
	*add = y;
}


alf()	/*  ALF - Enter alphanumeric mode.  */
{
	aedbf[0] = ALF;
	ordcmd(aedbf, 1);
}

txt(buf, dir)	/* Print text string, exit interpreter ON. */
register char *buf;/* Pointer to text aedbfer. Ignore '\n', stop on 0. */
int dir;	/* if(dir == 0) print left; else print down; */
{
	static char iobuf[] = {' ', ESC, MVR, 0, 0, ALF};
	register char	*blast; /* pointer to end of printable text */

	alf();			/* switch to alpha.	*/
	switch(dir){

		case 0 : /* print left */

			for(;;){

			/* advance buf to next printable
			 char or end of text (null byte) */

			while( (*buf) && !(printable(*buf)) )			
				buf++;

			if(*buf == 0) /* end of text */
				break;

			blast = buf;

			/* advance blast to next unprintable
			  char or end of text */

			while( (*blast) && (printable(*blast)) )
				blast++;

			obyte(buf, blast - buf);
			buf = blast;
			}			

		default : /* print down */

				    /* xspace, yspace ( set in sap()) are */
			iobuf[3] = -xspace; /* args to MVR, called after */
			iobuf[4] = -yspace; /* each char output.	*/

			while(*buf){
				if( printable(*buf) ){
					iobuf[0] = *buf;
					obyte(iobuf,sizeof(iobuf));
				}
				buf++;
			}
			break;

	} /* end of switch */
	esc();
	return;
}

