
;
; Draw filled polygon.	Phase 1	produces a vertex list
; clipped to the current window, if clipping is enabled.
; The clipping method is based on the Barsky/Liang
; algorithm described in their paper ...
; The clipping pass isn't really necessary, since the fill
; is done with draw vector, which the drawing accelerator clips.
; It's done here in the hope that the clipped polygon will
; processed faster by the filling routine.  However, the occasional
; increase in speed may not be worth 1k byte of code that does the
; clipping.  It would probably be just as good, and much simpler,
; to check for invisible polygons.
; Phase	2 performs the fill, using an edge list	algorithm.
; 



dfp:
	php
	rep	#0x30
	jsl	>0,Getb		; working color	- not used.
	jsl	>0,Getw		; get vertex count.
	sta	<ivcnt		; save it.
	cmp	##3
	bcs	$ok
	tax
	beq	$quit
$hosed:	jsl	>0,Gcoor
	dec	<ivcnt
	bne	$hosed
$quit:	plp
	rtl

;
; get heap for some number of coords, say
; 2*(ivcnt+1), to store	output vertices	in.
; in real life,	this depends on	the amount
; of storage needed by the edge	list algorithm
; when we get around to	filling	the polygon.
;
$ok:
	lda	<ivcnt
	inc	a
	asl	a
	asl	a
	asl	a
	sta	<ibsize		; save buffer size.
	pha
	jsl	>0,GetHeap
	pla
	bcs	$hosed
	sta	<ovx		; save pointer to buffer.
	lda	<ibsize
	lsr	a
	clc
	adc	<ovx
	sta	<ovy
	stz	<ibidx		; save index into buffer.

	jsl	>0,Gcoor	; get and preserve first vertex.
	stx	<frstx
	sty	<frsty
	dec	<ivcnt		; dec #	vertices to get.
	stz	<ovcnt		; init # vertices in clipped pgon.

	lda	DaFlag
	bit	##4
	bne	$clpon

	lda	<frstx
	ldx	<frsty
	bsl	outv
$nloop:
	jsl	>0,Gcoor
	txa
	tyx
	bsl	outv
	dec	<ivcnt
	bne	$nloop
	brl	$fil1
$clpon:
;
; Get window coords.  Because of the bogus turning vertices
; we actually clip the polygon to a window 1 unit larger in
; each direction than the real window.
;
	sec			; sec to add 1 more.
	lda	<worgx
	adc	<windx
	sta	<xright

	sec
	lda	<worgy
	adc	<windy
	sta	<ytop

	dec	<worgx
	dec	<worgy

	stx	<xpos		; save beginpoint this edge.
	sty	<ypos
	bsl	outcod		; compute outcode of point.
	sta	<oc1		; save it.
$loop:
	jsl	>0,Gcoor	; get endpoint this edge.
$loop1:	stx	<xnew		; save it (here	on wrap	to firstx,y).
	sty	<ynew
	bsl	outcod		; compute outcode for endpoint.
	sta	<oc2		; save it.
	cmp	<oc1		; same outcodes	?
	bne	$diff		; br if	no.
	ora	<oc1		; yes, if both 0 accept, else reject.
	beq	$accpt		; trivial accept, add to output	list.
	brl	$nxtedg		; trivial reject, go do	next edge.
;
; add endpoint newx, newy to output list.
;
$accpt:
	lda	<xnew
	ldx	<ynew
	bsl	outv
	brl	$nxtedg
;
; Oh sigh, not a trivial edge.	It may intersect the
; window, but in any case adds a vertex	to the
; output list (referred	to as a	turning	vertex by
; Barsky/Liang).
;

$diff:

;
; If beginpoint	is outside in a	corner region
; output the window corner.
;
	lda	<oc1
	cmp	##5
	bne	$c6
	lda	<worgx
	ldx	<worgy
	bra	$tv1
$c6:	cmp	##6
	bne	$c9
	lda	<xright
	ldx	<worgy
	bra	$tv1
$c9:	cmp	##9
	bne	$c10
	lda	<worgx
	ldx	<ytop
	bra	$tv1
$c10:	cmp	##10
	bne	$oc1in
	lda	<xright
	ldx	<ytop
$tv1:	bsl	outv
$oc1in:
;
; done unless potential	intersection.
;
	lda	<oc1
	and	<oc2
	beq	$clip
	brl	$nxtedg
$clip:
	lda	<xnew		; setup	for clip routine.
	sta	<x2
	lda	<ynew
	sta	<y2

	lda	<oc1		; exiting window ?
	bne	$all		; br if	no.
	ldx	<xpos		; yes, just calc intersection
	ldy	<ypos		; output it and	do next	edge.
	bsl	clipl
	lda	<x2
	ldx	<y2
	bsl	outv
	brl	$nxtedg
$all:
	ldx	<xpos
	ldy	<ypos
	bsl	clipl		; clip line (x,y)(x2,y2)
	bcs	$nox		; br if	no intersection.
	txa			; output both clipped vertices
	tyx			; since	we entered or passed through.
	bsl	outv
	lda	<x2
	ldx	<y2
	bsl	outv
	brl	$nxtedg
;
; No intersection, have	to output a turning vertex.
; Easy to figure which one unless edges	are in opposite
; corners.  The	turning	vertex is the window corner
; at the corner	region crossed by the edge.
;
; corner outcode	endpoint outcodes
;	5		(1,4),(1,6),(4,9)
;	6		(2,4),(2,5),(4,10)
;	9		(1,8),(1,10),(5,8)
;	10		(2,8),(2,9),(6,8)
;

$nox:
	lda	<oc1		; are ends in opposite corners ?
	ora	<oc2
	cmp	##15
	beq	$hard		; br if	yes, worst case	for us.
;
; Set acc = 256*min(oc1,oc2)+max(oc1,oc2)
; to expedite finding out which	pair of
; outcodes we're dealing with.	If neither is
; a corner, we can find	out right now (the
; result of the	or is unique).
;
	cmp	##5
	beq	$crn5
	cmp	##6
	beq	$crn6
	cmp	##9
	beq	$crn9
	cmp	##10
	beq	$crn10
;
; Oh well, do the acc trick.
;
	sep	#0x20
	lda	<oc1
	xba			; assume oc1 < oc2.
	lda	<oc2
	rep	#0x20
	ldx	<oc1
	cpx	<oc2
	bcc	$nox1		; br if	oc1 < oc2.
	xba			; oc2 <	oc1, swap.
$nox1:
	cmp	##256*1+6
	beq	$crn5
	cmp	##256*4+9
	beq	$crn5

	cmp	##256*2+5
	beq	$crn6
	cmp	##256*4+10
	beq	$crn6

	cmp	##256*5+8
	beq	$crn9
	cmp	##256*1+10
	beq	$crn9

	cmp	##256*2+9
	beq	$crn10
	cmp	##256*6+8
	beq	$crn10

	brl	$nxtedg		; edge doesn't 'surround' a
				; window corner, done.
$crn10:
	lda	<xright
	ldx	<ytop
	bra	$tvout
$crn5:
	lda	<worgx
	ldx	<worgy
	bra	$tvout
$crn6:
	lda	<xright
	ldx	<worgy
	bra	$tvout
$crn9:
	lda	<worgx
	ldx	<ytop
$tvout:
	bsl	outv		; output the window corner.
	brl	$nxtedg		; go do	next edge.
;
; The endpoints	are in opposite	corners, no
; intersection with window.  Output the	window corner
; nearest to the edge (not one of the corner regions
; the endpoints	are in).
;

$hard:
	ldx	<worgx
	ldy	<xright

	lda	##1
	bit	<oc1
	bne	$h1

	txa
	tyx
	tay
$h1:
	stx	<xin
	sty	<xout

	ldx	<worgy
	ldy	<ytop

	lda	##4
	bit	<oc1
	bne	$h2

	txa
	tyx
	tay
$h2:
	stx	<yin
	sty	<yout

;
; Need to compare (xin-x)/dx and (yin-y)/dy, but
; problem is integer divide aint precise.
; Therefore we multiply	both sides by dy.  However
; if dy	is < 0,	this reverses the relative magnitudes
; of the expressions, so be careful.
; if dy*(xin-x)/dx > (yin-y)
;	output(xin,yout), else (xout,yin)
;
	sec
	lda	<xnew
	sbc	<xpos
	tay			; dx

	sec
	lda	<ynew
	sbc	<ypos
	sta	<y2		; save for sign	check later.
	tax			; dy

	sec
	lda	<xin		; xin -	x.
	sbc	<xpos
;
; dy*(xin-x)/dx
;
	bsl	xay		; xreg*acc/yreg
	sta	<temp		; save result.

	sec
	lda	<yin
	sbc	<ypos		; yin -	y.

	cmp	<temp
	ror	a		; carry	to acc sign bit.
	eor	<y2		; xor with dy sign bit.
	bmi	$h4		; br if	carry and dy > 0
				; or no	carry and dy < 0.
	lda	<xin
	ldx	<yout
	bsl	outv
	brl	$nxtedg
$h4:
	lda	<xout
	ldx	<yin
	bsl	outv

;
; set up for next edge.
;

$nxtedg:
	lda	<oc2
	sta	<oc1
	lda	<xnew
	sta	<xpos
	lda	<ynew
	sta	<ypos
	dec	<ivcnt
	bmi	$fill
	bne	$nxt1
	ldx	<frstx
	ldy	<frsty
	brl	$loop1
$nxt1:	brl	$loop

$fill:
	inc	<worgx
	inc	<worgy

	lda	<ovcnt		; done if < 3 vertices.
	cmp	##3
	bcc	$done
$fil1:
	lda	(<ovx)
$f1:	bit	Dpdone-1	; draw closing edge.
	bvc	$f1
	sta	0xfe00
	lda	(<ovy)
	sta	0xfe02
	sta	DaDva

	bsl	dfpfil		; go fill.
$done:
	pei	<ovx
	jsl	>0,FreHeap
	plp
	rtl

;
; Return outcode of point x,y in acc.
; bit 0	- set if point is left of window,
; bit 1	- right,
; bit 2	- below (y < worgy).
; bit 3	- above (y-1 >= ytop)
;

outcod:
	stz	<temp

	tya			; get y coord.
	dec	a		; dec so N flag set if y <= ytop
	sec
	sbc	<ytop		;   (toggle on exit).
	asl	a		; sign bit to carry.
	rol	<temp		; carry to temp.

	tya			; get y coord.
	sec
	sbc	<worgy		; N flag set if y < worgy.
	asl	a
	rol	<temp

	txa			; get x coord.
	dec	a		; dec so N flag set if x <= xright
	sec
	sbc	<xright		;   (toggle on exit).
	asl	a		; sign bit to carry.
	rol	<temp		; carry to temp.

	txa			; get x coord.
	sec
	sbc	<worgx		; N flag set if x < worgx.
	asl	a
	rol	<temp

	lda	<temp
	eor	##8+2		; correction.
	rts

;	clc			; to subtract ytop+1.
;	tya
;	sbc	<ytop		; carry	set if y >= ytop+1 > ytop.
;	rol	<temp
;
;	sec
;	tya
;	sbc	<worgy		; carry	set if y >= ybottom, fix on exit.
;	rol	<temp
;
;	clc			; to subtract xright+1.
;	txa
;	sbc	<xright		; carry	set if x >= xright+1 > xright.
;	rol	<temp
;
;	sec
;	txa
;	sbc	<worgx		; carry	set if x >= xleft, fix on exit.
;	rol	<temp
;
;	lda	<temp
;	eor	##4+1		; the fix, toggle bits 0,2.
;
;	rts


;
; Clip edge, return carry set if no intersect.
; x,y hold beginpoint, x2,y2 endpoint.
; Note - in real life, this will be done by
; the drawing accelerator (?).
;

clipl:
	clc		; assume intersection.
	php
	phx
	phy
$loop
	lda	1,s
	tay
	lda	3,s
	tax
	bsl	outcod		; compute outcode.
	sta	<cc1		; save it.

	ldx	<x2		; ditto	endpoint.
	ldy	<y2
	bsl	outcod
	sta	<cc2

	ora	<cc1		; trivial accept ?
	bne	$1		; br if	no.
	ply			; get clipped beginpoint.
	plx
	plp			; return carry clear - success.
	rts
$1:
	lda	<cc1		; test trivial reject.
	and	<cc2
	beq	$2
	ply
	plx
	plp
	sec
	rts
$2:
	sec
	lda	<x2
	sbc	3,s
	tax

	sec
	lda	<y2
	sbc	1,s
	tay

	sep	#0x20
	lda	<cc1
	bne	$c1
	brl	$c2
$c1:
	lda	#1

	bit	<cc1
	beq	$10
;
; find y intersection with wxorg
; = y +	dy*(xorg-x)/dx).
;
	rep	#0x20
	txa
	tyx
	tay			; set x	= dy, y	= dx
	sec
	lda	<worgx
	sbc	3,s		; xorg-x
	bsl	xay
	clc
	adc	1,s
	sta	1,s
	lda	<worgx
	sta	3,s
	brl	$loop
$10:
	asl	a
	bit	<cc1
	beq	$20
	rep	#0x20
	txa
	tyx
	tay
	sec
	lda	<xright
	sbc	3,s
	bsl	xay
	clc
	adc	1,s
	sta	1,s
	lda	<xright
	sta	3,s
	brl	$loop

$20
	asl	a
	bit	<cc1
	beq	$30
	rep	#0x20
	sec
	lda	<worgy
	sbc	1,s
	bsl	xay
	clc
	adc	3,s
	sta	3,s
	lda	<worgy
	sta	1,s
	brl	$loop
$30
	asl	a
	bit	<cc1
	beq	$40
	rep	#0x20
	sec
	lda	<ytop
	sbc	1,s
	bsl	xay
	clc
	adc	3,s
	sta	3,s
	lda	<ytop
	sta	1,s
$40:	brl	$loop
$c2:
	lda	#1

	bit	<cc2
	beq	$11
	rep	#0x20
	txa
	tyx
	tay
	sec
	lda	<worgx
	sbc	<x2
	bsl	xay
	clc
	adc	<y2
	sta	<y2
	lda	<worgx
	sta	<x2
	brl	$loop
$11:
	asl	a
	bit	<cc2
	beq	$21
	rep	#0x20
	txa
	tyx
	tay
	sec
	lda	<xright
	sbc	<x2
	bsl	xay
	clc
	adc	<y2
	sta	<y2
	lda	<xright
	sta	<x2
	brl	$loop

$21
	asl	a
	bit	<cc2
	beq	$31
	rep	#0x20
	sec
	lda	<worgy
	sbc	<y2
	bsl	xay
	clc
	adc	<x2
	sta	<x2
	lda	<worgy
	sta	<y2
	brl	$loop
$31
	asl	a
	bit	<cc2
	rep	#0x20
	beq	$41
	sec
	lda	<ytop
	sbc	<y2
	bsl	xay
	clc
	adc	<x2
	sta	<x2
	lda	<ytop
	sta	<y2
$41	brl	$loop


;
; acc *	x / y, result in acc.
; x,y registers	trashed.
;

xay:
	pha

	stz	<sign		; bit 0	= sign of result.

	txa
	bpl	$1
	eor	##-1
	inc	a
	tax
	inc	<sign
$1:
	tya
	bpl	$2
	eor	##-1
	inc	a
	tay
	inc	<sign
$2
	pla
	bpl	$10
	eor	##-1
	inc	a
	inc	<sign

$10:	bit	Dpdone-1
	bvc	$10

	sta	0xfe00
	stx	0xfe04
	sta	DaMul

$20	bit	Dpdone-1
	bvc	$20

	sty	0xfe04
	sta	DaDiv
$30:	bit	Dpdone-1
	bvc	$30
	lda	0xfe00

	lsr	<sign
	bcc	$done
	eor	##-1
	inc	a
$done:	rts

;
; Add vertex to	output list.
; X coord in a,	y coord	in x.
;

outv:
$1:	bit	Dpdone-1
	bvc	$1

	ldy	<ibidx
	bne	$2
	sta	Xcap
	stx	Ycap
	bra	$3
$2:
	sta	0xfe00
	stx	0xfe02
	sta	DaDva
$3:
	sta	(<ovx),y
	txa
	sta	(<ovy),y
	iny
	iny
	sty	<ibidx
	inc	<ovcnt
	rts

	end

