
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Wait for byte from host or	;
; keyboard if in local mode.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

get:
	php
	sep	#0x20
$loop:
	bit	<locsw		; in local mode ?
	bmi	$local		; br if yes.
	lda	<cdmflg		; doing command dma ?	
	bne	$getcdm		; br if yes.
	bit	PolDev		; command out ?
	bpl	$serial		; br if no, check serial input.
;
; get byte from parallel interface.
;
	plp
	jmp	>0,Getpar

;
; get command dma byte.
;
$getcdm:
;	lda	Cdmsw
;	ora	PolDev+1
;	bpl	$getcdm
;	plp
;	jmp	Getcdm

	bit	<cdmsw		; time to get read word from host?
	bpl	$read		; branch if yes
	stz	<cdmsw		; reset 'next word flag'
	lda	#0		; clear acc high byte.
	xba
	lda	<cdmbuf+1	; get the (buffered) data byte.
	plp
	rtl
$read:
	lda	PolDev+1	; command dma word avail (bit 7) ?
	bpl	$read		; branch if no, wait some more.
	sta	<cdmsw		; set the 'read high byte next' flag.
	rep	#0x20
	lda	CdmPrt		; get data word from host.
	sta	<cdmbuf		; save high byte for next caller.
	sta	DmaEna		; turn on data flag.
	and	##0xff		; return low byte to caller.
$done:	plp			; restore callers m/x mode
	rtl			; and return.
;
; get host serial data if any in queue.
;
$serial:
	bit	Iqcnt2+1	; anything in serial input q ?
	bpl	$loop		; go wait some more if no.
	plp			; yes, jump to dequeuing routine.
	jmp	>0,GetHst

;
; Here in local mode, get
; next non-special key.
;
$local:
	phk
	bsl	chkkbd		; go get key (if ASCII).
	bcs	$loop		; br if key was not ASCII.
	rep	#0x20
	and	##0xff
	plp
	rtl


send:
	php
	sep	#0x20
	bit	<sifval
	bmi	$111
	bvs	$11
	plp
	jmp	>0,SndHst
$11:
	plp
	jmp	>0,Dchar
$111:
	plp
	jmp	>0,Putpar

sndend:


	end



