
;
; Define programmable key.
; dpk(keycode,nbytes,bytes)
;

dpk:
	rtl

;
; Define soft key.
; dsk(keycode,bytes,0)
;

dsk:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sks command.  		;
; Chkkbd puts keys to be sent 	;
; via sks in a queue (sksbuf).	;
; sks keeps calling chkkbd until;
; ksr & ParStat <> 0, then sends;
; the next key from sksbuf.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sks:

$ksr	equ	32
$sksiz	equ	64

	php
	sep	#0x30
;
; Wait for ksr.
;
	bra	$2
$1:
	jsl	>0,ChkKbd	; go service keyboard.
$2:	lda	#$ksr
	bit	ParStat		; ksr get turned on ?
	beq	$1		; loop until it does.
;
; Get key from sksbuf and
; send it.  If last key in
; buffer, turn off ksr.
;
	ldy	<sksout		; get pointer to key.
	lda	(<sksbuf),y	; get key from q.

	jsl	>0,Putpar	; send it.

	iny			; point to next key.
	cpy	#$sksize	; past end of q buffer ?
	bcc	$3		; br if no.
	ldy	#0		; yes, wrap to beginning.
$3:	sty	<sksout		; save pointer to next key.
	cpy	<sksin		; q empty ?
	bne	$done		; br if no.
	lda	#255-$ksr	; yes, turn off ksr
	and	ParStat		; in image of par status byte.
	sta	ParStat		
	sta	ParOut+1	; send new status.
$done:
	plp
	rtl

	end
