

;
; Command dma routines.
;

;scd:	php
;	sep	#0x20
;	lda	#0xff
;	bra	xcd1
;xcd:	php
;	sep	#0x20
;	lda	#0
;xcd1:	sta	<cdmflg
;	plp
;	jmp	Cdmctl

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This routine sets up for command dma	;
; transfer on command from host.  Also	;
; it terminates this mode on command	;
; from host.  Actual enabling and 	;
; disabling of dma is done on a word by ;
; word basis in wcdma.			;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
scd:
	php
	sep	#0x20
	stz	<cdmsw		; indicate next byte from
	stz	<cdmsw+1	; LSB of cdma port.
	lda	#8
	sta	DmaCtl		; enable data flag.
	sta	<cdmflg
	sta	DmaEna		; request dma cycle.
	plp
	rtl
xcd:
	php
	rep	#0x20
	stz	DmaCtl		; disable data flag.
	stz	<cdmsw
	stz	<cdmflg
	plp
	rtl
;
; do command dma to drawing accelerator.
; commands are SEC,DVA,MOV and exit.
; commands (in hex) are all 2 words long, as follows :
; DVA - 0xxx 0yyy.
; MOV - 0xxx, 8yyy.
; SEC - 80cc,0ccc.
; XIT - 8000,8000
;

dadma:
	php
	rep	#0x10		; 16 bit idx
	sep	#0x20		; 8 bit mem.

	ldx	<xpos
	ldy	<ypos

	phd			; point direct at io page.
	pea	##0xff00
	pld

$1000:
	bit	<Dpdone-0xff00
	bvc	$1000
	stx	Xcap
	sty	Ycap
;
; get next command/xcoord
;
	
$cmd:
	bit	<0x1c		; data flag off ?
	bmi	$abort		; quit if command out happens.
	bvc	$cmd		; br if yes.

	ldx	<CdmPrt-0xff00	; get cdma word.
	sta	<DmaEna-0xff00	; turn on data flag.
	bmi	$sec		; br if not mov or dva.

;
; get y coord of mov/draw
;
$1:	bit	<0x1c		; data flag off ?
	bmi	$abort		; quit if command out happens.
	bvc	$1		; br if yes.

	ldy	<CdmPrt-0xff00	; get cdma word.
	sta	<DmaEna-0xff00	; turn on data flag.
	bmi	$mov		; br if mov command.

$dva:
	bit	<Dpdone-0xff00
 	bvc	$dva
	stx	0xfe00
	sty	0xfe02
	sta	DaDva
	bra	$cmd

$mov:
	bit	<Dpdone-0xff00
	bvc	$mov
	stx	Xcap
	sty	Ycap
	bra	$cmd
;
; here for sec or exit.
; exit if next word is minus.

$sec:
	bit	<0x1c		; data flag off ?
	bmi	$abort		; quit if command out happens.
	bvc	$sec		; br if yes.

	ldy	<CdmPrt-0xff00
	sta	<DmaEna-0xff00
	bmi	$done

$11:
	bit	<Dpdone-0xff00
	bvc	$11
	stx	DaColr
	bra	$cmd

$abort:
	stz	<DmaCtl-0xff00
	stz	Intdrp+cdmsw
	stz	Intdrp+cdmflg

$done:
	bit	<Dpdone-0xff00
	bvc	$done

	pld
	stz	<cdmsw

	ldx	Xcap
	stx	<xpos
	ldy	Ycap
	sty	<ypos
	lda	DaColr
	sta	<color

	plp
	rtl

	end
