;
; define special font.
; dsf code hsize vsize (mask(bytes)) this version assumes
; that there are at most hsize*vsize bytes.  Unfortunately
; the number of bytes isn't known until they are all sent.
; Special font definitions are stored in a linked list.
; <spfptr points to the first, and new element are added
; to the beginning of the list.  Each element looks like this:
;	$name,$hsize,$vsize,$next,(mask(bytes))
;

dsf:

$first	equ	0
$last	equ	3
$size	equ	1

$name	equ	temp
$hsize	equ	temp+1
$vsize	equ	temp+2
$count	equ	temp+3		; bit counter
;		temp+4		; # bytes to get
;		temp+6		; possible new stack
$stack	equ	temp+12		; temp for stack pointer
$savdx	equ	temp+14		; dx for placement of next font
$savdy	equ	temp+16		; dy for placement of next font
$next	equ	temp+18		; pointer to next font in list
$curent	equ	temp+20

	php
	sep	#0x30
	jsl	>0,Getb
	sta	<$name		; get font name.
;
; See if already defined.  If so
; unlink it from list and return to heap.
;

	jsl	>0,Getb
	sta	<$hsize		; # pixels/row.
	tax

	jsl	>0,Getb	
	sta	<$vsize		; # rows.
	tay

	rep	#0x30
	txa
	bit	##7
	beq	$3
	clc
	adc	##8		; round off 
$3:	lsr	a
	lsr	a
	lsr	a

$2:	bit	Dpdone-1
	bvc	$2
	sta	0xfe00
	sty	0xfe04
	sta	DaMul		; hsize*vsize.
	lda	0xfe02
	and	##0xfff
	asl	a
	asl	a
	asl	a
	clc
	adc	##8+2+2+1	; allow for 8 masks, hsize,vsize,
				; name and pointer to next font.
	sta	<temp+4		; save max number bytes to get.
	tsc
	sta	<$stack
	sec
	sbc	<temp+4	
	sta	<temp+6		; save possible new stack pointer.
	lda	HeapTop
	clc
	adc	StkMin		; calc least legal sp.
	cmp	<temp+6		; ok ?
	bcc	$ok
	brl	$gobble		; not ok.
$ok:
	lda	<temp+6
	tcs
	inc	a
	sta	<temp+6		; point to beginning of stack frame.

	ldy	##0
	lda	<$name
	sta	(<temp+6),y
	iny
	lda	<$hsize		; and vsize.
	sta	(<temp+6),y
	iny
	iny
	lda	<spfptr		; make this node point to the first
	sta	(<temp+6),y	; node in the list
	iny
	iny
	
	stx	<temp+8		; # pixel/row
	ldx	<temp+4		; max # bytes to get.
	sep	#0x20
$mloop:
	jsl	>0,Getb		; get mask.
	sta	(<temp+6),y	; store.
	iny
	cmp	#0
	beq	$got
	dex

	lda	<$vsize		; # rows.
	sta	<temp+10
	lda	<temp+8		; # bytes/row
	sta	<temp+9
$m3
	jsl	>0,Getb		; get font byte
	sta	(<temp+6),y
	iny
	dex			; total byte counter
	beq	$got		; br if done

	lda	#8		; bit/byte control
	sta	<$count
$m4
	dec	<temp+9		; count down hsize first(if not after
	bne	$m6		; counting down 8bit counter)
	dec	<temp+10	; count down row counter
	beq	$mloop		; br to get next mask
	lda	<temp+8		; no, reload hsize counter
	sta	<temp+9
$m6
	dec	<$count		; this sync hsize into bytes
	bne	$m4
	beq	$m3

;
; y reg = number bytes (0 if too many).
; get y bytes from heap, +1 for name,
; 2 for hsize, vsize, 2 for ptr to next
; in list.

$got:	rep	#0x20
	cpy	##0
	bne	$g1
	brl	$done
$g1:	iny
	sty	<temp+4
	phy
	jsl	>0,GetHeap
	pla
	bcc	$save
	brl	$done
$save:
	sta	<spfptr		; save new spf list head.
	tay			; heap addr, target.
	ldx	<temp+6		; stack frame, source.
	lda	<temp+4
	dec	a
	mvn	>0,>0	
$done
	lda	<$stack
	tcs
	plp
	rtl

$gobble:
	ldx	<temp+4
$g2
	jsl	>0,Getb
	dex
	bne	$g1
	bra	$done

;
; write special font.
; wsf (font dx dy) 0
;

wsf:

$first	equ	0		; zero = name of font
$last	equ	3		; 3rd = pointer to next	
$size	equ	1		; 1st = hsize of font

$name	equ	temp
$hsize	equ	temp+1
$vsize	equ	temp+2
$count	equ	temp+3
$dum	equ	temp+4
$stack	equ	temp+12
$savdx	equ	temp+14
$savdy	equ	temp+16
$next	equ	temp+18
$curent	equ	temp+20
$npix	equ	temp+22
$nrows	equ	temp+23

	php
	sep	#0x20
$1:
	bit	Dpdone
	bvc	$1
	lda	#7
	trb	Capctl
$loop:
	rep	#0x10
	sep	#0x20

	jsl	>0,Getb
	sta	<$name
	cmp	#0
	bne	$2
	brl	$done
$2:
	jsl	>0,Gdxdy
	stx	<$savdx
	sty	<$savdy

	ldy	<spfptr		; start from the header
$s1
	tyx
	beq	$nxtspf		; br if reached the end of list
	
	cmp	$first,x
	beq	$found
	ldy	$last,x
	bra	$s1
$found:
	stx	<$curent	; save found addr
	lda	$size,x		; get hsize, vsize.
	sta	<$hsize
	inx
	lda	$size,x
	sta	<$vsize
	ldy	##5		; mask is the fifth element in node
	sty	<$next
$mloop:
	rep	#0x10
	sep	#0x20
	ldy	<$next
	lda	(<$curent),y	; get mask.
	beq	$done		; done if 0.
	iny
	sta	Rbwmsk		; set write mask
	
	ldx	<xpos
	stx	Xcap
	ldx	<ypos
	stx	Ycap

	lda	<$hsize
	sta	<$npix		; horizontal font size counter
	lda	<$vsize
	sta	<$nrows		; vertical font size counter

	ldx	##0xff
$lop:
	lda	(<$curent),y	; get font byte
	iny
	sty	<$next		; temp storage

	sep	#0x30
	ldy	#8		; write 8 bits at a time
$l1:	asl	a
	bcs	$l3
	bit	Vmimaj		; move cap even though bit not set
	bra	$l4
$l3
	stx	Clpmaj		; bit set, write it with clipping	
$l4
	dec	<$npix
	bne	$l2
	bit 	Vmimin		; move vertically
	sta	<$dum		; temp
	rep	#0x20
	lda	<xpos
	sta	Xcap
	sep	#0x20
	dec	<$nrows
	beq	$nxtspf		; br if done with this mask
	lda	<$hsize		; reload horizontal counter
	sta	<$npix
	lda	<$dum
$l2
	dey
	bne	$l1
	ldy	<$next		; here if done with 8 bits, get next
	bra	$lop		; byte

$nxtspf:
	rep	#0x20
	clc
	lda	<xpos		; update cap
	adc	<$savdx
	sta	<xpos
	clc
	lda	<ypos
	adc	<$savdy
	sta	<ypos
	brl	$loop


$done:
	sep	#0x20
	lda	<wmask
	sta	Rbwmsk
	plp
	rtl

	end
