;
; Interrupts aren't used since
; we only need a report when it's time to 
; update the cursor, and that isn't more
; than 60 times/second max.  At 19200K baud
; requesting a report and getting it only 
; takes about 3ms.
;
;		tabxy	- returns raw tab coords in x,y
;			  and tablet status in acc.
;		maptab	- maps raw tab coords to current
;			  window if possible, using info
;			  from DTM.  Returns carry set if
;			  out of window.
;		tabin	- get byte from tablet.
;
; Direct page vars :
;
;	windx, windy	- size of current window.
;	dtmx, dtmy	- physical tablet coords bottom corner
;			  of tablet area to be mapped to window.
;			  (DTM, default 0,0).
;	dtmsx,dtmsy	- size (in tablet coords) of tablet area
;			  to be mapped to window.
;			  (DTM, default tbsizx, tbsizy).
;	tbsizx, tbsizy	- absolute coordinate range of tablet.
;			  (2200x1700 for Kurta 11x8.5 tablet).
;			  permanent.
;



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Map raw tablet coordinates to the screen.		;
; Enter with raw coords in x,y.  If mapping not 	;
; possible, (raw x or y outside defined tablet area)	;
; return carry set and x,y unchanged, else return	;
; mapped coords in x,y.  The mapping is			;
; (x-tabletxorigin)*(screenxsize)/(tabletxsize),	;
; and analogously for y.				;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

maptab:
	sec			; assume coords OUTSIDE.
	php
	rep	#0x30
	phx			; save raw x, y
	phy
;
; compute (x - tablet x origin), outside if > tablet x size.
;
	sec
	txa			; get raw x coord.
	sbc	<dtmx		; sub tablet origin.
	cmp	<dtmsx		; outside of tablet area ?
	bcs	$outsid		; br if yes, just return.

$1:	bit	Dpdone-1	; wait for dpu done.
	bvc	$1
;
; multiply (x - origin) * screenxsize.
;
	sta	0xfe00		; store multiplicand.

	lda	##1280
	sta	0xfe04		; store multiplier.
	sta	DaMul		; multiply.

$2:	bit	Dpdone-1
	bvc	$2
;
; divide product from above by tablet area x size.
;		
	lda	<dtmsx		; get divisor.
	sta	0xfe04		; store it.
	sta	DaDiv		; divide.

$3:	bit	Dpdone-1
	bvc	$3

	ldx	0xfe00		; get quotient = mapped x coord.

;
; as above for y.
;
	sec
	tya
	sbc	<dtmy
	cmp	<dtmsy
	bcs	$outsid

	sta	0xfe00

	lda	##1024
	sta	0xfe04
	sta	DaMul

$4:	bit	Dpdone-1
	bvc	$4
		
	lda	<dtmsy
	sta	0xfe04
	sta	DaDiv

$5:	bit	Dpdone-1
	bvc	$5

	ldy	0xfe00

	pla
	pla
	plp
	clc
	rts

$outsid:
	ply
	plx
	plp
	rts
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This routine gets tablet status and 	;
; coordinates.  It returns status in 	;
; acc and coordinates in x, y.  If no	;
; data is available from the tablet the	;
; carry is set and a, x, y are junk.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tabxy:
	clc			; assume data available.
	php
	rep	#0x10
	sep	#0x20
	lda	>ACE,10		; see if data available.
	bit	#16+8+4		; error (besides overrun) ?
	bne	$error		; br if yes.
	bit	#1		; data available ?
	bne	$0		; br if yes.
	bra	$error
$err1:	sep	#0x20
	pla
$error	plp			; no data or bad data, return.
	sec
	rts

$0:	lda	<cudfmt		; get tablet data format
	cmp	#'1'		; packed binary?
	beq	$1
	brl	$gtco		; no, must be GTCO decimal.
$1:
	ldx	##5
$2:	bsl	tabin		; get byte from tablet.
	bcs	$error
	bit	#64		; is it a status byte ?
	bne	$stat		; should be, but loop in case...
	dex
	bne	$2
	bra	$error
$stat:
	pha			; save pen status.

	bsl	tabin		; x bits 5..0
	bcs	$err1
	asl	a		; left adjust
	asl	a
	sta	<temp

	bsl	tabin		; x bits 11..6
	bcs	$err1
	and	#63
	sta	<temp+1

	rep	#0x20
	lsr	<temp
	lsr	<temp
	ldx	<temp
	
	sep	#0x20
	bsl	tabin		; y bits 5..0
	bcs	$err1
	asl	a		; left adjust
	asl	a
	sta	<temp

	bsl	tabin		; y bits 11..6
	bcs	$err1
	and	#63
	sta	<temp+1
	rep	#0x20
	lsr	<temp
	lsr	<temp
	ldy	<temp

	sep	#0x20
	pla			; get pen status (bits 1..4).
	lsr	a
	lsr	a
	and	#15

	sta	<tbstat
	stx	<tbrawx
	sty	<tbrawy

	plp
	rts

$gtco:
	ldx	##15
$gt1:	bsl	tabin
	bcs	$gerror
	cmp	#32
	bcc	$gt2		; br if control char.
	dex
	bne	$gt1
	bra	$gerror
$gt2:
	bsr	$decin		; get x coord.
	bcs	$gerror
	ldx	<temp		; save in x.
	bsr	$decin		; get y coord.
	bcs	$gerror
	ldy	<temp		; save in y.
	sep	#0x20		; get status.
	bsl	tabin
	bcs	$gerror
	and	#0xf
	sta	<tbstat
	stx	<tbrawx
	sty	<tbrawy
	plp
	rts
$gerror:
	plp
	sec
	rts
$decin:
	clc
	php
	rep	#0x20
$d1:	bsl	tabin		; wait for decimal input.
	bcs	$derr
	and	##0xff
	sec
	sbc	##'0'
	cmp	##10
	bcs	$d1
	sta	<temp
$loop:	bsl	tabin
	bcs	$derr
	and	##0xff
	sec
	sbc	##'0'
	cmp	##10
	bcs	$ret
	sta	<temp1
	asl	<temp
	lda	<temp
	asl	a
	asl	a
	adc	<temp
	adc	<temp1
	sta	<temp
	bra	$loop
$ret:	plp
	rts
$derr:	plp
	sec
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Local routine to get byte from tablet;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tabin:
	clc
	php
	rep	#0x10
	phx
	phy
	sep	#0x30
	ldx	Vcount
	inx
	inx

$1:	lda	>ACE,10
	bit	#1
	bne	$2
	cpx	Vcount
	bne	$1
	bra	$error
$2:
	bit	#16+8+4+2
	bne	$error
	lda	>ACE,0
	rep	#0x10
	ply
	plx
	plp
	rts
$error
	rep	#0x10
	ply
	plx
	plp
	sec
	rts

	end
