/* 	This program uses packed binary format auxiliary devices
	such as Kurta bit pad or Summa Mouse.  It will read tablet
	position and draw circles(radius=10) if tablet positions
	are within the mapped window (tablet -> screen), else console
	will halt and print out message until stylus is moved inside
	the window, and a key is struck on terminal keyborad.
*/

#include <stdio.h>

main(argc,argv)
int argc;
char **argv;
{
	int jx,jy,oldjx,oldjy;
	int c,stat,id;
	tapint();
	sif('M');
	dca(0,0);		/* unlink cap & cursor */
	stp(2);			/* set packed binary data format */
	etp(1);			/* enable cursor */
	sec(c=1);
	ods(1);			/* overlay plane, model 1280 only */
	for(;;){
		rtp(&id,&stat,&jx,&jy);
		if(argc>1){	/* print coords on console screen */
			printf("%d %d %d\n",stat,jx,jy);

		if(stat & 16){
			printf("outside\n");
			getchar();
			continue;
		}

		/* depressed stylus or pushed buttons will cause color
		   of circles to change */

		if(stat&15)
			sec((++c)&7);
		if((jx == oldjx) && (jy == oldjy))
			continue;

		mov(jx,jy);
		dcl(10);
		oldjx = jx;oldjy=jy;

	}
}
