;
; VT100 Erase commands.
;

;
; ESC [ Pn K	Erase in line.
;
erslin:
	lda	<nchr
	beq	$done		; just exit if line length 0.
	bsl	getpn
	cmp	#2		; erase entire line ?
	beq	erline		; yes, go do entire line.
	cmp	#1		; from 1 to curx ?
	beq	ertocx		; yes, go do it.
	cmp	#0		; from cursor to end ?
	beq	ercxto		; br if yes, go do it.
$done:	rts

;
; Erase entire line, set length to 0.
;
erline:
	lda	#1		; first col to erase.
	ldy	<nchr		; last col to erase.
	beq	$done		; easy if line is empty already.
	bsl	undisp		; go erase the screen.
	lda	#1		; first col to erase.
	ldy	<nchr		; last col to erase.
	bsl	erase		; go erase buffer.
	stz	<nchr		; set line length to 0.
$done:	rts			; done.

;
; Erase from beginning of line to cursor
; (actually to min(curx,nchr) since
; cursor could be to the right of the
; rightmost char in the line).
;

ertocx:
	lda	#1		; first col to erase.
	ldy	<curx		; assume curx is last ( < nchr).
	cpy	<nchr		; cursor left of eol ?
	bcs	erline		; erase line if yes.
	bsl	undisp		; erase the screen.
	lda	#1		; as above, for buffer.
	ldy	<curx
	bsl	erase
	rts
;
; Erase from cursor to eol.
;
	
ercxto:
	lda	<curx		; get first col to erase.
	cmp	#1		; cursor at col 1 ?
	beq	erline		; br if yes, erase entire line.
	ldy	<nchr		; ditto last.
	cpy	<curx		; nchr >= curx ?
	bcs	$20		; br if yes, something to erase.
	rts			; cursor past eol, nothing to erase.
$20:	bsl	undisp		; erase chars on screen.
	lda	<curx
	ldy	<nchr
	bsl	erase		; erase in buffer.
	lda	<curx		; record new line length.
	dec	a		; cursor position was erased too.
	sta	<nchr
	rts

;
; ESC [ Pn J	Erase in page.
; 
erscrn:
	bsl	getpn
	cmp	#2
	beq	$ersall
	cmp	#1
	beq	$tocurs
	cmp	#0
	bne	$done
	brl	$toend
$done:	rts

;
; Erase from cursor to end of screen.
; 

$toend:
	bsl	ercxto		; erase from curx to eol
;
; erase lines cury+1 to rowmax.
;
	lda	<cury		; get cursor row.
	cmp	<rowmax		; at end of screen already ?
	bne	$toe1
	brl	$done		; done if yes.
$toe1:	inc	a		; bump to next row = first to erase.
	ldy	<rowmax		; bottom of screen = last row to erase.
	brl	$ers		; go erase.

;
; erase from 1,1 to cursor position.
;

$tocurs:
	bsl	ertocx		; erase from 1 to curx.
	lda	#1
	ldy	<cury
	cpy	#1
	bne	$toc1
	brl	$done
$toc1:	brl	$ers

$ersall:
	lda	#1
	ldy	<rowmax
	brl	$ers

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Do the actual screen erase and	;
; buffer update for lines acc .. y.	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

$ers:
	php
	rep	#0x30
	pha
	phx
	phy
	pei	<curx		; erase cmds don't move cursor, save it.
	sep	#0x30
$loop:
	lda	7,s		; get current line to erase.
	sta	<cury		; 
	inc	a		; bump to next.
	sta	7,s		; save for next time through.
	
	bsl	chngln
	bsl	erline		; go erase screen and buffer.
;
; lines erased get set back to single 
; high and wide, clear special attributes.
;
	lda	<colmax		; get line length for single wide.
	sta	<ncol		; set line to length for single wide.
	stz	<chrsiz		; set char size to single.

	lda	3,s		; get last line to do.
	cmp	7,s		; next after last ?
	bcs	$loop		; loop if no.

	pla
	sta	<curx		; restore original cursor position.
	pla
	sta	<cury
	bsl	chngln
	stz	<daflag	
$l4	bit	Dpdone
	bvc	$l4
	lda	DaCtl
	and	#255-128-64
	sta	DaCtl

	rep	#0x30
	ply
	plx
	pla
	plp
	rts


	end
