;
; 1280 Drawing Processor uCode
; A Kossow
; Feb 85
;
 .TITLE	Drawing Processor uCode Rev 1.0
 .DEF	.BCN.,40.
 .XOR	(RD+QREG+DPIDLE)
;
ZERO	EQU	0
;
; ALU A Path Reg Adrs
; Same as B Path Adrs, but shifted
; four more bits to the left
; Use:
;  R0 in A Data Path = (R0^A)
;
A	EQU	4
;
; ALU B Path Reg Adrs
;
R0 	EQU	ZERO
R1	EQU	(01^32.)
R2	EQU	(02^32.)
R3	EQU	(03^32.)
R4	EQU	(04^32.)
R5	EQU	(05^32.)
R6	EQU	(06^32.)
R7	EQU	(07^32.)
R8	EQU	(08^32.)
R9	EQU	(09^32.)
R10	EQU	(0A^32.)
R11	EQU	(0B^32.)
R12	EQU	(0C^32.)
R13	EQU	(0D^32.)
R14	EQU	(0E^32.)
R15	EQU	(0F^32.)
;
; Special names for the ALU registers
;
TMP	EQU	R0	; scratch reg
COLOR	EQU	R3	; color to write with
;
; ALU register names during vector draws..
;
ACC	EQU	R4	; Vect Accum
INC2	EQU	R5	; Breshenham incr 2
X	EQU	R6	; X (or dX) inputs
Y	EQU	R7	; Y (or dY) inputs
ABSX	EQU	R8	; abs val of x
PCNT	EQU	R8	; pixel counter
ABSY	EQU	R9	; abs val of y
;
; ALU register names during rectangle fills
;

;
; Clipping window boundaries
;
XWBOT	EQU	R10	; X window bottom
YWBOT	EQU	R11	; Y window bottom
XWTOP	EQU	R12	; X window top
YWTOP	EQU	R13	; Y window top
;
; Virtual -> Physical CAP offsets
;
XOFS	EQU	R14	; X offset
YOFS	EQU	R15	; Y offset
;
; Register Rd or Wrt bit
; Note: Field inverted by .XOR
;
WR	EQU	 ZERO
RD	EQU	(40^25.)
;
; Parameter Registers
;
PR0	EQU	 ZERO
PR1	EQU	(01^25.)
PR2	EQU	(02^25.)
PR3	EQU	(03^25.)
PR4	EQU	(04^25.)
PR5	EQU	(05^25.)
PR6	EQU	(06^25.)
PR7	EQU	(07^25.)
PR8	EQU	(08^25.)
PR9	EQU	(09^25.)
PRA	EQU	(0A^25.)
PRB	EQU	(0B^25.)
PRC	EQU	(0C^25.)
PRD	EQU	(0D^25.)
PRE	EQU	(0E^25.)
PRF	EQU	(0F^25.)
;
; Refresh Buffer Registers
;
XCAP	EQU	(10^25.)	; Physical X Cap
YCAP	EQU	(11^25.)	; Physical Y Cap
;
; Start of 2901-specific register addresses.
; These locations are not decoded during direct
; register accesses by the host, and are used for
; data paths availible only to the 2901.
;
CONST	EQU	(12^25.)	; 12 Bit Constant
DIO	EQU	(13^25.)	; Data to/from host
;	EQU	(14^25.)
;	EQU	(15^25.)
;	EQU	(16^25.)
;	EQU	(17^25.)
;	EQU	(18^25.)
;	EQU	(19^25.)
;	EQU	(1A^25.)
;	EQU	(1B^25.)
;	EQU	(1C^25.)
;	EQU	(1D^25.)
;	EQU	(1E^25.)
;	EQU	(1F^25.)
;
; End of 2901-specific registers
;
RDMSK	EQU	(20^25.)	; Read Mask
OVCLR	EQU	(21^25.)	; Overlay Color Register
LUADR	EQU	(22^25.)	; LUT Adr Register
LURED	EQU	(23^25.)	; LUT Red Data Register
LUGRN	EQU	(24^25.)	; LUT Grn Data Register
LUBLU	EQU	(25^25.)	; LUT Blu Data Register
WRMSK	EQU	(26^25.)	; Write Mask
CTL	EQU	(27^25.)	; Control Register
;
; Control Register Function Bits
;
MINDN	EQU	1		; Decr Minor Axis
MINUP	EQU	ZERO		; Incr Minor Axis
MAJDN	EQU	2		; Decr Major Axis
MAJUP	EQU	ZERO		; Incr Major Axis
XMAJ	EQU	ZERO		; X Is Major Axis
YMAJ	EQU	4		; Y Is Major Axis
V960	EQU	8		; Blank At line 959
DSPOVL	EQU	10		; Display 9th Plane
WRTOVL	EQU	20		; Write 9th Plane
BSYFLG	EQU	80		; Reset DONE to host
;
STPREG	EQU	(28^25.)	; Stipple Register
BR9	EQU	(29^25.)	; Byte reg 9
BR10	EQU	(2A^25.)	; Byte reg 10
BR11	EQU	(2B^25.)	; Byte reg 11
BR12	EQU	(2C^25.)	; Byte reg 12
BR13	EQU	(2D^25.)	; Byte reg 13
BR14	EQU	(2E^25.)	; Byte reg 14
BR15	EQU	(2F^25.)	; Byte reg 15
;
FLAGS	EQU	BR9		; DPU primitive options
;
; Flag byte bit definitions
;
DWC	EQU	80		; Double wide chr
DHC	EQU	40		; Double high chr
ESRC	EQU	20		; Erase src rect after copy
DMA	EQU	10		; Special DMA processing
;	EQU	8
CLP	EQU	4		; Enable clipping
MWE	EQU	2		; Enable 10 pixel wrts
STP	EQU	1		; Enable stippling
;
FGCLR	EQU	BR10		; Color to draw  with
BGCLR	EQU	BR11		; Color to erase with
;
; Registers specific to CHR instruction
;
CHRX	EQU	BR12		; Character width
CHRY	EQU	BR13		; Character height
CHRDX	EQU	BR14		; Inter-chr spacing (X)
;
; Registers specific to WCT instruction
;
CLTADR	EQU	BR12		; clr tbl entry to upd
CLTRED	EQU	BR13		; red  val to clr tbl
CLTGRN	EQU	BR14		; grn  val to clr tbl
CLTBLU	EQU	BR15		; blue val to clr tbl
;
; VRAM Access locations
;
VIDNOI	EQU	(30^25.)	; Access w/o adv caps
VIDMAJ	EQU	(31^25.)	; adv major axis
VIDMIN	EQU	(32^25.)	; adv minor axis
VIDBOTH	EQU	(33^25.)	; adv both
;
STPNOI	EQU	(34^25.)	; enable stippler
STPMAJ	EQU	(35^25.)
STPMIN	EQU	(36^25.)
STPBOTH	EQU	(37^25.)
;
MWENOI	EQU	(38^25.)	; enable 10 pixel wrts
MWEMAJ	EQU	(39^25.)
MWEMIN	EQU	(3A^25.)
MWEBOTH	EQU	(3B^25.)

;
; ALU Sources
;
AQ	EQU	ZERO
AB	EQU	(01^22.)
ZQ	EQU	(02^22.)
ZB	EQU	(03^22.)
ZA	EQU	(04^22.)
DA	EQU	(05^22.)
DQ	EQU	(06^22.)
DZ	EQU	(07^22.)
;
; ALU Operations
;
ADD	EQU	ZERO
SUBR	EQU	(01^16.)
SUBS	EQU	(02^16.)
OR	EQU	(03^16.)
AND	EQU	(04^16.)
NOTRS	EQU	(05^16.)
EOR	EQU	(06^16.)
EXNOR	EQU	(07^16.)
;
; ALU Carry Input Bit
;
SETC	EQU	(01^15.)
;
; ALU Destinations
; Note: LS Bit of field inv
; by .XOR
;
; Dest->     RAMB    Q    Y
;            ----    -    -
; QREG  (0)  -       F    F
; NOP   (1)  -       -    F
; RAMA  (2)  F       -    RAMA
; RAMF  (3)  F       -    F
; RAMQD (4)  F/2     Q/2  F
; RAMD  (5)  F/2          F
; RAMQU (6)  2F      2F   F
; RAMU  (7)  2F      -    F
;
QREG	EQU	(01^19.)
RAMF	EQU	(02^19.)
RAMA	EQU	(03^19.)
RAMD	EQU	(04^19.)
RAMQD	EQU	(05^19.)
RAMU	EQU	(06^19.)
RAMQU	EQU	(07^19.)
;
; Misc Control Bits
;
DPIDLE  EQU	(1^14.)	; DPU Busy bit
RMW	EQU	(1^13.)	; RM/W to vram sequencer
;
; Jump Conditions
;
JZ	EQU	(01^9.)	; jmp if zero
JNEG	EQU	(02^9.)	; jmp if negative
JCY	EQU	(03^9.)	; jmp if carry set
JLT	EQU	(04^9.)	; jmp if less than
;	EQU	(05^9.)
JNHBL	EQU	(06^9.)	; jmp if not h blank
JNVBL	EQU	(07^9.)	; jmp if not v blank
JNZ	EQU	(08^9.)	; jmp if not zero
JPOS	EQU	(09^9.)	; jmp if positive
JNCY	EQU	(0A^9.)	; jmp if carry clear
JGE	EQU	(0B^9.)	; jmp if gt or eq
;	EQU	(0C^9.)	
;	EQU	(0D^9.)	
;	EQU	(0E^9.)	
JMP	EQU	(0F^9.)	; jmp always

;
;	Macros for ALU operations
;
ANDAQ	EQU	(AND+AQ)	; F = A&Q
ANDAB	EQU	(AND+AB)	; F = A&B
ANDDA	EQU	(AND+DA)	; F = D&A
ANDDQ	EQU	(AND+DQ)	; F = D&Q
ORAQ	EQU	(OR+AQ)		; F = A|Q
ORAB	EQU	(OR+AB)		; F = A|B
ORDA	EQU	(OR+DA)		; F = D|A
ORDQ	EQU	(OR+DQ)		; F = D|Q
EORAQ	EQU	(EOR+AQ)	; F = A^Q
EORAB	EQU	(EOR+AB)	; F = A^B
EORDA	EQU	(EOR+DA)	; F = D^A
EORDQ	EQU	(EOR+DQ)	; F = D^Q
INVQ	EQU	(EXNOR+ZQ)	; F = !Q
INVB	EQU	(EXNOR+ZB)	; F = !B
INVA	EQU	(EXNOR+ZA)	; F = !A
INVD	EQU	(EXNOR+DZ)	; F = !D
ADDAQ	EQU	(ADD+AQ)	; F = A + Q
ADDAB	EQU	(ADD+AB)	; F = A + B
ADDDA	EQU	(ADD+DA)	; F = D + A
ADDDQ	EQU	(ADD+DQ)	; F = D + Q
SUBQA	EQU	(SETC+SUBR+AQ)	; F = Q - A
SUBBA	EQU	(SETC+SUBR+AB)	; F = B - A
SUBAD	EQU	(SETC+SUBR+DA)	; F = A - D
SUBQD	EQU	(SETC+SUBR+DQ)	; F = Q - D
SUBAQ	EQU	(SETC+SUBS+AQ)	; F = A - Q
SUBAB	EQU	(SETC+SUBS+AB)	; F = A - B
SUBDA	EQU	(SETC+SUBS+DA)	; F = D - A
SUBDQ	EQU	(SETC+SUBS+DQ)	; F = D - Q
INCQ	EQU	(SETC+ADD+ZQ)	; F = Q + 1
INCB	EQU	(SETC+ADD+ZB)	; F = B + 1
INCA	EQU	(SETC+ADD+ZA)	; F = A + 1
INCD	EQU	(SETC+ADD+DZ)	; F = D + 1
DECQ	EQU	(SUBR+ZQ)	; F = Q - 1
DECB	EQU	(SUBR+ZB)	; F = B - 1
DECA	EQU	(SUBR+ZA)	; F = A - 1
DECD	EQU	(SUBS+DZ)	; F = D - 1
NEGQ	EQU	(SETC+SUBS+ZQ)	; ~Q
NEGB	EQU	(SETC+SUBS+ZB)	; ~B
NEGA	EQU	(SETC+SUBS+ZA)	; ~A
NEGD	EQU	(SETC+SUBR+DZ)	; ~D
ALUZ	EQU	(AND+ZQ)	; F = 0
ALUD	EQU	(OR+DZ)		; F = D
ALUQ	EQU	(OR+ZQ)		; F = Q
ALUA	EQU	(OR+ZA)		; F = A
ALUB	EQU	(OR+ZB)		; F = B
ALUCONS EQU	(CONST+ALUD)	; F = CONSTANT

;+++++++++++++++++++++++++++++++++++++++++++++++++
; uCode jmp vectors:
; Unused entries should jmp to IDLE:
;+++++++++++++++++++++++++++++++++++++++++++++++++
; RST   - Reset the DPU
;         XCAP <- 0      YCAP <- 0
;         XBOT <- 0      YBOT <- 0
;         XTOP <- 1279   YTOP <- 1023
;         XOFS <- 0      YOFS <- 0
;         WRMSK<- ff     STP  <- ff
;         CTLRG<- 0
;-------------------------------------------------
	ALUZ			; aluopr = 0
+	XWBOT 			; aludst = XWBOT
+	WR XCAP			; aludst = XCAP
+	JMP RST
;-------------------------------------------------
; RWP   - Read Window Parameters
;         PR0 <- Bottom of window (X)
;         PR1 <- Bottom of window (Y)
;         PR2 <- Top    of window (X)
;         PR3 <- Top    of window (Y)
;         PR4 <- X Offset
;         PR5 <- Y Offset
;-------------------------------------------------
	XWBOT ALUB		; aluopr = XWBOT
+	WR PR0			; aludst = PR0
+	JMP RWP
;-------------------------------------------------
; WWP   - Write Window Parameters
;         Bottom of window (X) <- PR0
;         Bottom of window (Y) <- PR1
;         Top    of window (X) <- PR2
;         Top    of window (Y) <- PR3
;         X Offset             <- PR4
;         Y Offset             <- PR5
;-------------------------------------------------
	RD PR0 ALUD		; aluopr = PR0
+	RAMF XWBOT		; aludst = XWBOT
+	JMP WWP
;-------------------------------------------------
; DVA   - Draw Vector Absolute
;
;         FLAGS->clip = 4
;                mwe  = 2
;                stip = 1
;         XCAP-> start x
;         YCAP-> start y
;         PR0 -> end   x
;         PR1 -> end   y
;-------------------------------------------------
	RD PR0 ALUD		; aluopr = PR0
+	ALUD RAMF X		; aludst = X
+	JMP DVA 

;-------------------------------------------------
; DVR   - Draw Vector Relative
;
;         FLAGS->clip = 4
;                mwe  = 2
;                stip = 1
;         XCAP-> start x
;         YCAP-> start y
;         PR0 -> end x displ
;         PR1 -> end y displ
;-------------------------------------------------
	RD PR0 ALUD		; aluopr = PR0
+	RAMF X			; aludst = X
+	JMP DVR
;-------------------------------------------------
; DFR   - Draw Filled Rectangle
;
;         FLAGS->clip = 4
;                stip = 1
;         XCAP-> start x
;         YCAP-> start y
;         PR0 -> end x
;         PR1 -> end y
;         PR2 ->
;          .
;          .
;         PR9 -> Stipple pattern(s) 1-8
;-------------------------------------------------
	RD PR0 ALUD		; aluopr= PR0
+	RAMF X			; aludst = X
+	JMP DFR
;-------------------------------------------------
; FRR   - Filled Rectangle Relative
;
;         FLAGS->clip = 4
;                stip = 1
;         XCAP-> start x
;         YCAP-> start y
;         PR0 -> end x displ
;         PR1 -> end y displ
;         PR2 ->
;          .
;          .
;         PR9 -> Stipple pattern (1-8)
;-------------------------------------------------
	RD PR0 ALUD		; aluopr = PR0
+	RAMF X			; aludst = X
+	JMP FRR

;-------------------------------------------------
; CRA   - Copy Rectangle (absolute)
;
;         FLAGS->era src = 32.
;                clip    = 4
;
;         PR0 -> dstxtop (abs)
;         PR1 -> dstytop (abs)
;
;         PRC -> srcxbot (AOI...)
;         PRD -> srcybot
;         PRE -> srcxtop
;         PRF -> srcytop
;-------------------------------------------------
	RD PR0 ALUD
+	RAMF X
+	JMP CRA
;-------------------------------------------------
; CRR   - Copy Rectangle (relative)
;
;         FLAGS->era src = 32.
;                clip    = 4.
;
;         PR0 -> dstxtop (rel)
;         PR1 -> dstytop (rel)
;
;         PRC -> srcxbot (AOI...)
;         PRD -> srcybot
;         PRE -> srcxtop
;         PRF -> srcytop
;-------------------------------------------------
	RD PR0 ALUD
+	RAMF X
+	JMP CRR

;-------------------------------------------------
; CHR   - 12 * 12 special filled rect
;
;         FLAGS -> double width  = 128.
;                  double height = 64.
;         CHRX  -> number of pixels in x
;         CHRY  -> number of pixels in y
;         CHRDX -> x displacement to nxt chr
;         PR0
;          .
;          .
;         PR12 -> 12 bit stipple pattern(s)
;-------------------------------------------------
	JMP CHR
;-------------------------------------------------
;
; WPX - Write Pixel at current virtual position
;
;-------------------------------------------------
	JMP WPX
;-------------------------------------------------
;
; WMP - Write Multiple Pixels
;
;       FLAGS-> clip if flag != 0
;	XCAP -> starting x
;       YCAP -> starting y
;       PR0  -> number of pixels to wrt
;
;-------------------------------------------------
	RD CTL FLAGS		; aluopr = FLAGS
+	QREG			; aludst = Q
+	JMP WMP
;-------------------------------------------------
;
; RPX - Read Pixel at current virtual position
;
;-------------------------------------------------
	JMP RPX
;-------------------------------------------------
;
; WCT - Synchronized color table update
;       Update is performed at the begining
;       of the horz blanking interval.
;
;       CLTADR -> color table address
;       CLTRED -> red value
;       CLTGRN -> grn value
;       CLTBLU -> blu value
;
;       Returns CLTADR + 1
;-------------------------------------------------
	JMP WCT
;-------------------------------------------------
;
; ERW - Erase Window
;
;       BGCLR -> Color to erase with
;
;       XWBOT
;       YWBOT
;       XWTOP
;       YWTOP -> Rectangle to erase
;                (the currently defined window)
;
;       Note:
;             Wrt Mask is NOT changed
;-------------------------------------------------
;
; Set BG color as working color
;
	RD BGCLR ALUD		; aluopr = BGCLR
+	RAMF COLOR		; aludst = COLOR
+	JMP ERW

;-------------------------------------------------
;
; EFS - Edge Flag Search
;
;-------------------------------------------------
	JMP EFS
;-------------------------------------------------
;
; EFF - Edge Flag Fill
;
;-------------------------------------------------
	JMP EFF
;-------------------------------------------------
;
; IFS - Interior Fill Search
;
;-------------------------------------------------
	JMP IFS
;-------------------------------------------------
;
; IFF - Interior Fill Fill
;
;-------------------------------------------------
	JMP IFF
;-------------------------------------------------
;
; OFS - Overlay Fill Search
;
;-------------------------------------------------
	JMP OFS
;-------------------------------------------------
;
; OFF - Overlay Fill Fill
;
;-------------------------------------------------
	JMP OFF
;-------------------------------------------------
;
; GFS - General Fill Search
;
;-------------------------------------------------
	JMP GFS
;-------------------------------------------------
;
; GFF - General Fill Fill
;
;-------------------------------------------------
	JMP GFF

	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE #DPIDLE
	JMP IDLE  #DPIDLE

;
; DONE - Sets Done Flag to Host
;        Drops into RESCAP
;
DONE:
	RD CTL ALUD		; aluopr = CTL
+	QREG			; aludst = Q

	(ALUCONS+ANDDQ) #7F	; aluopr = Q & 7f
+	#QREG			; aludst = Q

	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
;
; RESCAP - Restore virtual CAP addr by subtracting
;          XOFS from XCAP and YOFS from YCAP
;          Drops into IDLE
;
RESCAP:
	#((RD+XCAP)+(XOFS^A)+SUBAD) ; aluopr = XCAP - XOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+XCAP)		    ; aludst = XCAP
	#((RD+YCAP)+(YOFS^A)+SUBAD) ; aluopr = YCAP - YOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+YCAP)		    ; aludst = YCAP
;
; DPU idle loop
; Control transfers here when there's
; nothing to do
;
; Note: Din read into the Q register
;
IDLE:
	#(RD+DIO+ALUD)		; aluopr = DIN
+	#QREG			; aludst = Q
+	#(JMP+IDLE) #DPIDLE
;
; RESET
;
RST:
	#ALUZ			; aluopr = 0
+	#(RAMF+YWBOT)		; aludst = YWBOT
+	#(WR+YCAP)		; aludst = YCAP
	#ALUCONS	#1279.	; aluopr = 1279.
+	#(RAMF+XWTOP)		; aludst = XWTOP
	#ALUCONS	#1023.	; aluopr = 1023.
+	#(RAMF+YWTOP)		; aludst = YWTOP
	#ALUZ			; aluopr = 0
+	#(RAMF+XOFS)		; aludst = XOFS
	#ALUZ			; aluopr = 0
+	#(RAMF+YOFS)		; aludst = YOFS
	#ALUZ			; aluopr = 0.
+	#(WR+CTL)		; aludst = CTL
	#ALUCONS	#0FF	; aluopr = ff
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+WRMSK)		; aludst = WRMSK
	#ALUQ			; aluopr = Q
+	#(WR+STP)		; aludst = STP
+	#(JMP+IDLE)		; back to sleep.
;
; RWP - Read Window Parameters
;
RWP:
	#(YWBOT+ALUB)		; aluopr = YWBOT
+	#(WR+PR1)		; aludst = PR1
	#(XWTOP+ALUB)		; aluopr = XWTOP
+	#(WR+PR2)		; aludst = PR2
	#(YWTOP+ALUB)		; aluopr = YWTOP
+	#(WR+PR3)		; aludst = PR3
	#(XOFS+ALUB)		; aluopr = XOFS
+	#(WR+PR4)		; aludst = PR4
	#(YOFS+ALUB)		; aluopr = YOFS
+	#(WR+PR5)		; aludst = PR5
+	#(JMP+IDLE)
;
; WWP - Write Window Parameters
;
WWP:
	#(RD+PR1+ALUD)		; aluopr = PR1
+	#(RAMF+YWBOT)		; aludst = YWBOT
	#(RD+PR2+ALUD)		; aluopr = PR2
+	#(RAMF+XWTOP)		; aludst = XWTOP
	#(RD+PR3+ALUD)		; aluopr = PR3
+	#(RAMF+YWTOP)		; aludst = YWTOP
	#(RD+PR4+ALUD)		; aluopr = PR4
+	#(RAMF+XOFS)		; aludst = XOFS
	#(RD+PR5+ALUD)		; aluopr = PR5
+	#(RAMF+YOFS)		; aludst = YOFS
+	#(JMP+IDLE)
;
; DVA - Draw Vector Absolute
; Convert X,Y to Dx,Dy and
; process with DVR
;
DVA:
	#(RD+PR1+ALUD)		; aluopr = PR1
+	#(RAMF+Y)		; aludst = Y
	#((X^A)+RD+XCAP+SUBAD)	; aluopr = X - XCAP
+	#(RAMF+X)		; aludst = X
	#((Y^A)+RD+YCAP+SUBAD)	; aluopr = Y - YCAP
+	#(RAMF+Y)		; aludst = Y
+	#(JMP+DVR1)
;
; DVR - Draw Vector Relative
;
DVR:
	#(RD+PR1+ALUD)		; aluopr = PR1
+	#(RAMF+Y)		; aludst = Y
;
; draw relative vector from x,y cap to r0,r1 (rel)
;
DVR1:
;
; Add X and Y displacements to CAPS and X,Y
;
	#((RD+XCAP)+(XOFS^A)+ADDDA) ; aluopr = XCAP + XOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+XCAP)		    ; aludst = XCAP
	#((RD+YCAP)+(YOFS^A)+ADDDA) ; aluopr = YCAP + YOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+YCAP)		    ; aludst = YCAP
	#((XOFS^A)+X+ADDAB)	    ; aluopr = XOFS + X
+	#(RAMF)			    ; aludst = X
	#((YOFS^A)+Y+ADDAB)	    ; aluopr = YOFS + Y
+	#(RAMF)			    ; aludst = Y
;
; Do Vector Initialization
;
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(ALUQ+ORDQ)	#BSYFLG	; aluopr = Q | BSYFLG
+	#QREG			; aludst = Q
	#(CONST+ANDDQ)	#0F8	; aluopr = Q & f8
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
	#(ABSX+ALUB)		; aluopr = ABSX
	#(ABSY+ALUB)		; aluopr = ABSY
+	#(JPOS+DVR2)		; jmp if ABSX pos

	#(ABSX+NEGB)		; aluopr = ABSX
+	#RAMF			; aludst = ~ABSX

	#(ABSY+ALUB)		; aluopr = ABSY
DVR2:
	#(JPOS+DVR3)		; jmp if ABSY pos

	#(ABSY+NEGB)		; aluopr = ABSY
+ 	#(RAMF)			; aludst = ~ABSY
DVR3:
	#((ABSY^A)+ABSX+SUBAB)	; aluopr = ABSY - ABSX
	#(X+ALUB)		; aluopr = X
+	#(JPOS+YMAJAXIS)	; jmp if ABSY-ABSX pos
	#(Y+ALUB)		; aluopr = Y
+	#(JNEG+XMAJDN)		; jmp if X negative
DVR4:
	#(ABSX+ALUB)		; aluopr = ABSX
+	#(RAMD+TMP)		; aludst = TMP
+	#(JNEG+YMINDN)		; jmp if Y negative
DVR5:
	#((TMP^A)+ABSY+SUBBA)	; aluopr = ABSY - TMP
+	#(RAMF+ACC)		; aludst = ACC
	#((ABSX^A)+ABSY+SUBAB)	; aluopr = ABSY - ABSX
+	#(RAMF+INC2)		; alout  = INC2
;
; Determine what type of vector to do
; norm, stippled, or mult-wrt
;
	#(RD+FLAGS+ALUD)	; aluopr = FLAGS
+	#QREG			; aludst = Q
	#(CONST+ANDDQ+STP+MWE)	; aluopr = Q &(STP|MWE)
	#(CONST+ANDDQ+STP)	; aluopr = Q&(STP)
+	#(JZ+NORMDVR)		; jmp if   Q&(STP|MWE) == 0
	#(JNZ+STIPDVR)		; jmp if   Q&(STP) != 0

;-----------------------------------------------
;
; Vector Draw Inner Loops
;
;-----------------------------------------------
;
; MWE Inner Loop
;
;-------------------->

	#(JMP+DONE)	; all done.. restore caps
;
; Stipple Inner Loop
;
;-------------------->
STIPDVR:
	#(JMP+DONE)	; all done.. restore caps
;
; Normal Inner Loop
NORMDVR:
;-------------------->
	#(JMP+DONE)	; all done.. restore caps

;
; Set Cap direction for y = major axis
;
YMAJAXIS:
;
; Set Y as major axis
;
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#YMAJ	; aluopr = Q | YMAJ
	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
;
; Check if X or Y counters must be set
; to decr
;
	#(Y+ALUB)		; aluopr = Y
	#(X+ALUB)		; aluopr = X
+	#(JNEG+YMAJDN)		; jmp if Y neg
YMAJ1:
	#(JNEG+XMINDN)		; jmp if X neg
;
; Swap ABSX and ABSY
;
YMAJ2:
	#(ABSX+ALUB)		; aluopr = ABSX
+	#QREG			; aludst = Q
	#((ABSY^A)+ALUA)	; aluopr = ABSY
+	#(RAMF+ABSX)		; aludst = ABSX
	#ALUQ			; aluopr = QREG
+	#(RAMF+ABSY)		; aludst = ABSY
	#(ABSX+ALUB)		; aluopr = ABSX/2
+	#(RAMD+TMP)		; aludst = TMP
+	#(JMP+DVR5)
;
; Set Y cap direction down (major axis)
;
YMAJDN:
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#MAJDN  ; aluopr = Q | MAJDN
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
	#(X+ALUB)		; aluopr = X
+	#(JMP+YMAJ1)
;
; Set X cap dir down (minor axis)
;
XMINDN:
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#MINDN	; aluopr = Q | MINDN
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
+	#(JMP+DVR5)
;
; Set X cap dir down (major axis)
;
XMAJDN:
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#MAJDN	; aluopr = Q | MAJDN
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
	#(Y+ALUB)		; aluopr = Y
+	#(JMP+DVR4)
;
; Set Y cap dir down (minor axis)
;
YMINDN:
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#MINDN	; aluopr = Q | MINDN
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
	#(ABSX+ALUB)		; aluopr = ABSX/2
+	#(RAMD+TMP)		; aludst = TMP
+	#(JMP+DVR5)

;
; DFR - Draw Filled Rectangle
;
; Convert Absoute X,Y to relative and
; process using FRR
;
DFR:
	#(RD+PR1+ALUD)		; aluopr = PR1
+	#(RAMF+Y)		; aludst = Y
	#((X^A)+RD+XCAP+SUBAD)	; aluopr = X - XCAP
+	#(RAMF+X)		; aludst = X
	#((Y^A)+RD+YCAP+SUBAD)	; aluopr = Y - YCAP
+	#(RAMF+Y)		; aludst = Y
+	#(JMP+FRR1)
;
; FRR - Filled Rectangle Relative
;
FRR:
	#(RD+PR1)		; aluopr = PR1
+	#(RAMF+Y)		; aludst = Y
;
; Draw filled rectangle from ... to DX,DY
;
FRR1:
;
; Get color to write in
;
	#(RD+FGCLR+ALUD)	; aluopr = FGCLR
+	#(RAMF+COLOR)		; aludst = COLOR
FRR2:
;
; Add X and Y displacements to CAPS and X,Y
;
	#((RD+XCAP)+(XOFS^A)+ADDDA) ; aluopr = XCAP + XOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+XCAP)		    ; aludst = XCAP
	#((RD+YCAP)+(YOFS^A)+ADDDA) ; aluopr = YCAP + YOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+YCAP)		    ; aludst = YCAP
	#((XOFS^A)+X+ADDAB)	    ; aluopr = XOFS + X
+	#(RAMF)			    ; aludst = X
	#((YOFS^A)+Y+ADDAB)	    ; aluopr = YOFS + Y
+	#(RAMF)			    ; aludst = Y
;
 	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#BSYFLG	; aluopr = Q | BSYFLG
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL

	#(JMP+DONE)		; reset CAPS to virt loc

;
; CRA - Copy Rectangle Absolute
;
; Convert Absoute X,Y to relative and
; process using CRR
;
CRA:
	#(RD+PR1+ALUD)		; aluopr = PR1
+	#(RAMF+Y)		; aludst = Y
	#((X^A)+RD+XCAP+SUBAD)	; aluopr = X - XCAP
+	#(RAMF+X)		; aludst = X
	#((Y^A)+RD+YCAP+SUBAD)	; aluopr = Y - YCAP
+	#(RAMF+Y)		; aludst = Y
+	#(JMP+FRR1)
;
; CRR - Copy Rectangle Relative
;
CRR:
	#(RD+PR1)		; aluopr = PR1
+	#(RAMF+Y)		; aludst = Y
;
; Add X and Y displacements to CAPS and X,Y
;
CRR1:
	#((RD+XCAP)+(XOFS^A)+ADDDA) ; aluopr = XCAP + XOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+XCAP)		    ; aludst = XCAP
	#((RD+YCAP)+(YOFS^A)+ADDDA) ; aluopr = YCAP + YOFS
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+YCAP)		    ; aludst = YCAP
	#((XOFS^A)+X+ADDAB)	    ; aluopr = XOFS + X
+	#(RAMF)			    ; aludst = X
	#((YOFS^A)+Y+ADDAB)	    ; aluopr = YOFS + Y
+	#(RAMF)			    ; aludst = Y
;
; Go busy..
;
 	#(RD+CTL+ALUD)		    ; aluopr = CTL
+	#QREG			    ; aludst = Q
	#(CONST+ORDQ)	#BSYFLG	    ; aluopr = Q | BSYFLG
+	#QREG			    ; aludst = Q
	#ALUQ			    ; aluopr = Q
+	#(WR+CTL)		    ; aludst = CTL

;
; Check if rectangles overlap, and determine correct
; copy order
;
;       +---+               +---+                +---+
; dx<0  |DDD|          dx=0 |DDD|        dx>0    |DDD|
; dy>0  |DDD|-+        dy>0 |DDD|        dy>0  +-|DDD|
;       +---+S|             +---+              |S+---+
;         |SSS|             |SSS|              |SSS|
;         +---+             +---+              +---+
;
;       +---+-+             +---+              +-+---+
; dx<0  |DDD|S|        dx=0 |DDD|        dx>0  |S|DDD|
; dy=0  |DDD|S|        dy=0 |DDD|        dy=0  |S|DDD|
;       +---+-+             +---+              +-+---+
;
;         +---+             +---+              +---+
; dx<0    |SSS|        dx=0 |SSS|        dx>0  |SSS|
; dy<0  +---+S|        dy<0 +---+        dy<0  |S+---+
;       |DDD|-+             |DDD|              +-|DDD|
;       |DDD|               |DDD|                |DDD|
;       +---+               +---+                +---+
;

;
; Loop for rectangle copy
; w/o src rectangle erase
;

;
; Loop for rectangle copy
; with src rectangle erase
;

	#(JMP+DONE)		; reset CAPS to virt loc


;
; CHR - Draw Character
;
CHR:
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#BSYFLG	; aluopr = Q | BSYFLG
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL

	#(JMP+DONE)

;
; WPX - Write Pixel
;
WPX:
;
; Check if this is the last pixel in an
; AOI operation. Set DONE if it was.
;
CHKAOI:
;
; Wasn't last pixel... Don't set DONE
;
	#(JMP+RESCAP)
;
; Was the last pixel.. Set DONE
;
	#(JMP+DONE)
;
; WMP - Write Multiple Pixels
;
WMP:
	#(RD+PR0+ALUD)	; aluopr = PR0
+	#(RAMF+PCNT)	; aludst = PCNT
+	#(JZ+WMP1)	; flag byte not set
;
; clip pixel run to window
;

;
; Set BUSY
;
WMP1:
	#(RD+CTL+ALUD)		; aluopr = CTL
+	#QREG			; aludst = Q
	#(CONST+ORDQ)	#BSYFLG	; aluopr = Q | BSYFLG
+	#QREG			; aludst = Q
	#ALUQ			; aluopr = Q
+	#(WR+CTL)		; aludst = CTL
;
; start of write loop
;
WMPLP:	#(PCNT+DECB)		; aluopr = PCNT-1
+	#((COLOR^A)+RAMA)	; aludst = PCNT
+	#(WR+VIDMAJ)		; COLOR -> Vram
	#(JNZ+WMPLP)		; tst done in 2nd half
	#(JMP+DONE)		; pop out when done
;
; RPX - Read Pixel
;
RPX:

;
; Check to see if this is the end of AOI
; operation
;
	#(JMP+CHKAOI)

;
; WCT - Synchronized Color Table Access
;
WCT:
	#(JMP+DONE)
;
; ERW - Erase Window
;
ERW:
;
; x and y rectangle size is the size of the window
;
	#ALUZ			 ; aluopr = 0
+	#(WR+XCAP)		 ; aludst = XCAP
	#ALUZ			 ; aluopr = 0
+	#(WR+YCAP)		 ; aludst = YCAP
	#((XWTOP^A)+XWBOT+SUBAB) ; aluopr = XWTOP-XWBOT
+	#(RAMF+X)		 ; aludst = X (dx)
	#((YWTOP^A)+YWBOT+SUBAB) ; aluopr = YWTOP-YWBOT
+	#(RAMF+Y)		 ; aludst = Y (dy)
+	#(JMP+FRR2)		 ; 'draw' rectangle

;
; EFS - Edge Flag Search
;
EFS:
	#(JMP+DONE)
;
; EFF - Edge Flag Fill
;
EFF:
	#(JMP+DONE)
;
; IFS - Interior Fill Search
;
IFS:
	#(JMP+DONE)
;
; IFF - Interior Fill Fill
;
IFF:
	#(JMP+DONE)
;
; OFS - Overlay Fill Search
;
OFS:
	#(JMP+DONE)
;
; OFF - Overlay Fill Fill
;
OFF:
	#(JMP+DONE)
;
; GFS - General Fill Search
;
GFS:
	#(JMP+DONE)
;
; GFF - General Fill Fill
;
GFF:
	#(JMP+DONE)

	.END	ZERO		; fini...
