
#include	"mac.h"
#include	"mac.x"

/*
 * get input line from source
 *
 * continue until all source lines are processed
 */

getlin()
{
	register int nchar;
	register int cc;

	p = srcbuf;
	nchar =	0;

	while ((cc = getc(srcfil)) >= 0){
	  if (nchar > MAXBUF-1)  {
	    synerr("src line longer than %d chrs\n", MAXBUF);  /* {ch} */
	    exit(1);
	  }
	  if(cc == '\n'){
	   srcbuf[nchar++] = '\n';
	   srcbuf[nchar] = '\0';
	   return(nchar);
	  }
	  else{
	   srcbuf[nchar++] = cc;
	  }
	}

	if(nchar){
	  srcbuf[nchar++] = '\n';
	  srcbuf[nchar] = '\0';
	  return(nchar);
	}

	srcbuf[0] = 0;
	eof = TRUE;
	return(0);
}

/*
 * get a character
 * do switch conversions for special characters
 */

getch()
{
	register cc1;
	register cc2;

	cc1 = *p++;
	if (cc1	!= '\\')
	  return(cc1);

	cc2 = *p++;
	switch (cc2)  {

	  case 'r':
	    return('\r');

	  case 'f':
	    return('\f');

	  case 't':
	    return('\t');

	  case '\\':
	    return('\\');

	  case '0':
	    return('\0');

	  case 'n':
	    return('\n');

	  case 'b':
	    return('\b');

	  default:
	    p--;
	    return(cc1);

	}
}
