
/*
 *	Download an object file to the terminal
 *
 *	A Kossow
 *	May 1984
 *
 *	Modified Oct 85 for 8 bit m.out files (aek)
 *	Modified Jan 86 for dl -a2000 xgxxxx bug
 */

#include	<stdio.h>
#include	"mac.h"

#define	TERMNAME	"/dev/aedbytes","w"

/*
 * default usable ram 
 */

#define RAMBOT		0x0e00
#define RAMTOP		0x27ff

FILE	*fp;
FILE	*tp;

unsigned int hiused = RAMBOT;	/* current psect position */
unsigned int startadr = 0xffff;	/* address for load and go */

int	segorg;

struct	outhdr	header;		/* object file header buffer     */
struct	out	out[8];		/* buffer for segment descriptors */	
/*
 * tables for character conversion
 */
char	hextab[] = "0123456789abcdef";
char	octtab[] = "01234567";
char	dectab[] = "0123456789";

main(argc,argv)
char *argv[];
{
	register int i;
	register int j;
	register int byte;
	register int idx;

	if(argc < 2){
	 printf("Usage: dl -a<ld adr> -g<st adr> obj obj ...\n");
	 exit(1);
	}
	if((tp = fopen(TERMNAME)) == NULL){
	 printf("Couldn't open the parallel link to the terminal \n");
	 exit(1);
	}
	/*
	 *	Initialize the 1024 for downloading
	 *	(set the stack end below where we're going to load )
	 */

	fprintf(tp,"\033\033SEN1888N\033}");
	outw(RAMBOT);		/* set stack end */
	fflush(tp);
	if(ferror(tp)){
		printf("terminal I/O error \n");
		exit(1);
	}

	for(i=1; i<argc; i++){

	  if(argv[i][0] == '-'){

	    if(argv[i][1] == 'a'){
	      hiused = argnum(&argv[i][2]);	/* change adr to use */
	      i++;
	    }

	    if((argv[i][0] == '-')&&(argv[i][1] == 'g')){
	     startadr = argnum(&argv[i][2]);
	     i++;
	    }

	  }

	  if(i == argc){
	   if(startadr != 0xffff){
	     fprintf(tp,";");		/* jus cmd */
	     outw(startadr);
	     exit(1);
	   }
	  }
	  if((fp = fopen(argv[i],"r")) == NULL){
	    printf("Couldn't open %s\n",argv[i]);
	    exit(1);
	  }
	  fread(&header, AOUT, 1, fp);
	  if((header.ao_mword != MWORD)&&(header.ao_mword != 011223)){
	    printf("Invalid object format %s (%o)\n",argv[i],header.ao_mword);
	    exit(1);
	  }
	  /*
	   *	Read in segment descriptors
	   */

	  fread(&out, OUT, 8, fp);

	  /*
	   *	Set up LMR instruction for each segment
	   *	then send the data down the parallel link
	   */
	  for(idx=0; idx<8; idx++){
	    if(out[idx].ou_length){
	      if(out[idx].ou_attrib & ABS){
	        fprintf(stderr,"Asect %d: ",idx);
	        segorg = out[idx].ou_start;
	      }
	      else{
	        segorg = hiused;
		hiused += out[idx].ou_length;
	        fprintf(stderr,"Psect %d: ",idx);
	      }
	      fprintf(stderr,"Adr: %04x Len: %d (0x%x)\n",
	             segorg, out[idx].ou_length, out[idx].ou_length);

	      fprintf(tp,":");		/* lmr instruction */
	      outw(segorg);
	      outw(out[idx].ou_length);	   
	      for(j=0; j<out[idx].ou_length; j++){
	        if(header.ao_mword == MWORD)
		  byte = getc(fp);
		 else
		  byte = getw(fp);
	        putc(byte,tp);
	      }
	    }
	  }
	}

/*
 * execute a jus (maybe) if -s specifed
 */
	if(startadr != 0xffff){
	 printf("Starting at %04x\n",startadr);
	 fprintf(tp,";");
	 outw(startadr);
	}
/*
 * ring the terminal keyboard bell when we're done loading
 * if we aren't going to start up the code
 */
	else{
	  fprintf(tp,":");
	  outw(0x2801);
	  outw(1);
	  putc(2,tp);
	}
}

outw(w){
	putc(w>>8,tp);
	putc(w&0xff,tp);
}

argnum(p)
char *p;
{
	register int n, j;
	n = 0;
	if (*p == '0') {
	  p++;
	  if(*p == 'x'){
	    p++;
	    while((j=any(*p,hextab)) >= 0){
	      n = (n<<4) | j;
	      p++;
	    }
	  return(n);
	  }

	  while ((j = any(*p, octtab)) >=0){
	    n = (n<<3) | j;
	    p++;
	  }
	  return(n);
	}

/*
 * default radix is 16 instead of 10
 */
	while((j=any(*p,hextab)) >= 0){
	  n = (n<<4) | j;
	  p++;
	}
	return(n);
}

/*
 * search string 'str' for character 'c' and return 
 * its ordinal position
 */
any(c,str)
register char c;
char *str;
{
	register i;
	i = 0;
	while(str[i]){
	  if(c == str[i])
	    return(i);
	  i++;
	}
	return(-1);
}

