	title	"wings test program"
;
; define some program sections
;

.text	equ	0
.data	equ	1
.bss	equ	2
.stack	equ	3

	export	three
	extern	foobar

;
; and some constants
;

four	equ	0x4
two	equ	0x2
three	equ	0x3
negone	equ	-1

	psect	.bss
	ds	100
	align	0x10
	dcb	043

	align	2

	dcb	0x10
	dcb	255
	dcb	0x3
	dcw	0x2000
	dcw	0x10000

	dcl	>0x0,0xffff
	dcl	>0x1,0x0000
	dcl	>0x10,0x0000
	dcl	>0x10,0x000d
	dcq	>0xfff,0xeee

	asect	.data
	org	0x200
one	dcs	"Hello!\0"
too	dcs	"134567890"
tree	dcs	"3333333333333333333333"

	psect	.text
start

;
; all the immediates..
;
	adc	#1		; add with carry
	adc	##13
	and	#1		; and with accumulator
	and	##14
	bit	#1		; bit test
	bit	##15
	cmp	#'A'		; compare
	cmp	##'AB'
	cpx	#1		; compare x
	cpx	##1
	cpy	#1		; compare y
	cpy	##1
	eor	#1		; exclusive or
	eor	##1
	lda	#1		; load accumulator
	lda	##1
	ldx	#1		; load x
	ldx	##1
	ldy	#1		; load y
	ldy	##1
	ora	#1		; or with accumulator
	ora	##1
	sbc	#1		; subtract with carry
	sbc	##1

	rep	#1		; reset status bits
	sep	#1		; set   status bits
;
; all the directs...
;
	adc	<1		; add, etc...
	and	<1
	asl	<1
	bit	<1
	cmp	<1
	cpx	<1
	cpy	<1
	dec	<1
	eor	<1
	inc	<1
	lda	<1
	ldx	<1
	ldy	<1
	lsr	<1
	ora	<1
	rol	<1
	ror	<1
	sbc	<1
	sta	<1
	stx	<1
	sty	<1
	stz	<1
	trb	<1
	tsb	<1
;
; all the absolutes
;
	adc	1024
	and	1024
	asl	1024
	bit	1024
	cmp	1024
	cpx	1024
	cpy	1024
	dec	1024
	eor	1024
	inc	1024
	jmp	1024
	jsr	1024
	lda	1024
	ldx	1024
	ldy	1024
	lsr	1024
	ora	1024
	rol	1024
	ror	1024
	sbc	1024
	sta	1024
	stx	1024
	sty	1024
	stz	1024
	trb	1024
	tsb	1024
;
; abs longs
;
	adc	>0x10,0x0000
	and	>0x10,0x0000
	cmp	>0x10,0x0000
	eor	>0x10,0x0000
	jmp	>0x10,0xffff
	jsl	>0x10,0x0000
	lda	>0x10,0x0000
	ora	>0x10,0x0000
	sbc	>0x10,0x0000
	sta	>0x10,0x0000

;
; stack relative
;
	adc	10,s		; val(sp)
	and	10,s
	cmp	10,s
	eor	10,s
	lda	10,s
	ora	10,s
	sbc	10,s
	sta	10,s

;
; accumulator
;
	asl	a		; arithmetic shift left
	dec	a		; decrement
	inc	a		; increment
	lsr	a		; logical shift right
	rol	a		; rotate left
	ror	a		; rotate right

;
; direct page indexed x, indirect
;
	adc	(<1,x)
	and	(<1,x)
	cmp	(<1,x)
	eor	(<1,x)
	lda	(<1,x)
	ora	(<1,x)
	sbc	(<1,x)
	sta	(<1,x)
;
; long absolute,x
;

	adc	>0x10,0x0000,x
	and	>0x10,0x0000,x
	cmp	>0x10,0x0000,x
	eor	>0x10,0x0000,x
	lda	>0x10,0x0000,x
	ora	>0x10,0x0000,x
	sbc	>0x10,0x0000,x
	sta	>0x10,0x0000,x

;
; absolute indexed x
;
	adc	1024,x
	and	1024,x
	asl	1024,x
	bit	1024,x
	cmp	1024,x
	dec	1024,x
	eor	1024,x
	inc	1024,x
	lda	1024,x
	ldy	1024,x
	lsr	1024,x
	ora	1024,x
	rol	1024,x
	ror	1024,x
	sbc	1024,x
	sta	1024,x
	stz	1024,x
;
; absolute indexed y
;
	adc	1024,y
	and	1024,y
	cmp	1024,y
	eor	1024,y
	lda	1024,y
	ldx	1024,y
	ora	1024,y
	sbc	1024,y
	sta	1024,y
;
; direct page indexed x
;
	adc	<1,x
	and	<1,x
	asl	<1,x
	bit	<1,x
	cmp	<1,x
	dec	<1,x
	eor	<1,x
	inc	<1,x
	lda	<1,x
	ldy	<1,x
	lsr	<1,x
	ora	<1,x
	rol	<1,x
	ror	<1,x
	sbc	<1,x
	sta	<1,x
	sty	<1,x
	stz	<1,x
;
; direct page indexed y
;
	ldx	<1,y
	stx	<1,y
;
; direct page indirect
;
	adc	(<1)
	and	(<1)
	cmp	(<1)
	eor	(<1)
	lda	(<1)
	ora	(<1)
	sbc	(<1)
	sta	(<1)
;
; direct page indirect long
;
	adc	[<1]
	and	[<1]
	cmp	[<1]
	eor	[<1]
	lda	[<1]
	ora	[<1]
	sbc	[<1]
	sta	[<1]
;
; direct page indirect indexed y
;
	adc	(<1),y
	and	(<1),y
	cmp	(<1),y
	eor	(<1),y
	lda	(<1),y
	ora	(<1),y
	sbc	(<1),y
	sta	(<1),y
;
; direct page indirect long, indexed y
;
	adc	[<1],y
	and	[<1],y
	cmp	[<1],y
	eor	[<1],y
	lda	[<1],y
	ora	[<1],y
	sbc	[<1],y
	sta	[<1],y
;
; stack relative indexed y
;
	adc	(10,s),y
	and	(10,s),y
	cmp	(10,s),y
	eor	(10,s),y
	lda	(10,s),y
	ora	(10,s),y
	sbc	(10,s),y
	sta	(10,s),y
;
; branches
;
foo
	bcc	foo		; branch carry clear
	bcs	foo		; branch carry set
	beq	foo		; branch equal
	bge	foo		; branch greater than/ equal
	blt	foo		; branch less than
	bmi	foo		; branch minus
	bne	foo		; branch not equal
	bpl	foo		; branch plus
	bra	foo		; branch always
	bvc	foo		; branch overflow clear
	bvs	foo		; branch overflow set
;
; 16 bit branch
;
	brl	foo		; 16 bit branch always
;
; implied
;
	clc			; clear carry
	cld			; clear decimal mode
	cli			; clear interrupt disable
	clv			; clear overflow
	dex			; decrement x
	dey			; decrement y
	inx			; increment x
	iny			; increment y
	nop			; no operation
	sec			; set carry
	sed			; set decimal mode
	sei			; set interrupt disable
	stp			; stop
	tax			; transfer accumulator -> x
	tay			; transfer accumulator -> y
	tcd			; transfer accumulator -> direct page reg
	tcs			; transfer accumulator -> stack pointer
	tdc			; transfer direct register -> accumulator
	tsc			; transfer stack pointer -> accumulator
	tsx			; transfer stack pointer -> x
	txa			; transfer x -> accumulator
	txs			; transfer x -> stack pointer
	txy			; transfer x -> y
	tya			; transfer y -> accumulator
	tyx			; transfer y -> x
	wai			; wait for interrupt
	xba			; byte swap accumulator
	xce			; exchange c and e bits in psw
	wdm			; reserved...
;
; stack
;

	brk
	brk	#3

	cop
	cop	#4		; coprocessor

	pea	foo		; push 16 bit address
	pea	##0x1000	; push 16 bit absolute value

	pei	<10		; push direct page value onto stack

	per	foo		; push pc rel address

	pha			; push accumulator
	phb			; push data bank reg
	phd			; push direct page reg
	phk			; push pgm bank reg
	php			; push pgm status word
	phx			; push x
	phy			; push y
	pla			; pull accumulator
	plb			; pull data bank reg
	pld			; pull direct page reg
	plp			; pull processor status word
	plx			; pull x reg
	ply			; pull y reg
	rti			; return from interrupt
	rtl			; return from subroutine ( 3 byte adr )
	rts			; return from subroutine ( 2 byte adr )
;
; absolute indirect
;
	jmp	(1024)		; jump indirect ( 2 byte address )
	jml	(1024)		; jump indirect ( 3 byte address )

;
; absolute indexed x, indirect
;

	jmp	(1024,x)
	jsr	(1024,x)
;
; block move
;
	mvn	>1,>2		; block move negative 
	mvp	>3,>4		; block move positive

;
;	pseudo instructions
;	
	bsr	foo		; branch to subrn
	bsl	foo		; branch to subrn long

	psect	.stack
stack	ds	20		; 20 bytes for the stack
	end

