
#include	"mac.h"
#include	"mac.x"

/*
 *   Evaluate the expression pointed to	by 'p'.
 *
 *   Set the relocatability of the expression
 *   into global variable 'reloc'.  Lvalue()
 *   returns the relocatability	of each	lvalue
 *   in	global variable	'mreloc'. REL has precedence
 *   over ABS.
 */

expr()
{
	register char op;
	register int l, r;		/* left	& right	of expr	*/

	reloc  = 0;
	mreloc = 0;

	/*
	 *   Get left side of expression.
	 *	if null:  error
	 *	else process right side	(remainder)
	 */

	if(!*p){
	  synerr("missing argument");

#ifdef DEBUG
	  if(*option('Y'))printf("expr: returns 0\n");
#endif
	  return(0);
	}

#ifdef DEBUG
	if(*option('Y'))printf("expr: opn = %s\n",p);
#endif

	l = lvalue();

	if(mreloc & REL)
	  reloc = REL;
	else
	  reloc |= mreloc;
	/*
	 *   Process remainder of expression
	 *
	 *   If end-of-expr instead of operator
	 *   terminate legally.
	 *
	 */
	 for(;;){
	   /*
	    * get operator
	    */
	    op = *p;

	    if (op == ',' || op == '\0'){
	     return(l);
	    }

	    p++;			/* bump past operator */

	    /*
	     * get right hand side of expr
	     */
	    r = lvalue();

	    /*
	     * check for any references to two external symbols
	     * in an expression 
	     */
	
	     if ((reloc & EXT) && (mreloc & EXT))  {
	       synerr("expression rel to 2 externals");
	       return(0);
	     }

	     /*
	      *	Process	  <left> := <left> <op>	<right>.
	      */
	     switch (op)  {

	       case '+':
	         l += r;
	         break;

	       case '-':
	         l -= r;
	         break;

	       case '*':
	         l *= r;
	         break;

	       case '/':
	         if (!r) {
	           synerr("div by zero");
		   return(l);
	         }
	         l /= r;
	         break;

	       case '%':
	         if (!r) {
	           synerr("mod by zero");
	           return(l);
	         }
	         l %= r;
	         break;

	       case '>':
	         l >>= r;
	         break;

	       case '<':
	         l >>= r;
	         break;

	       case '~':
	         l ^= r;
	         break;

	       case '&':
	         l &= r;
	         break;

	       case '|':
	         l |= r;
	         break;

	  }

		/*
		 *   Consider next op/field
		 */
	}

	return;
}


/*
 *   Lvalue:  decode a term and	return it's value.
 */
lvalue()
{
	register struct	st *q;
	register int v;

	switch (*p++){

	  /*
	   * #   Evaluate constant
	   */
	  case '#':

	    v = argnum();

#ifdef DEBUG
	    if(*option('Y'))printf("lvalue: constant = %d\n",v);
#endif

	    mreloc = LITR;
	    break;

	  /*
	   * $   Evaluate label
	   */
	  case '$':
	    v = argnum();
	    q = &symtab[v];

#ifdef DEBUG
	    if(*option('Y')){
	      printf("lvalue: label    = %d\n",v);
	      printf("        symtab[%3d] mode = %4x value = %4x\n",
	              v,q->s_mode,q->s_value);
	    }
#endif
	    if (!(q->s_mode & DEFN)){
	      if(!(q->s_mode & EXT)){
	        if(!*option('e')){
	         fprintf(stderr,"%s %4d: %s undefined\n",
			 srcnam,nline,&q->s_name);
	        }
	        return(0);
	      }
	    }
	    v = q->s_value;
	    if (q->s_mode & REL)
	      mreloc = REL;
	    else
	      mreloc = ABS;

	    if (q->s_mode & EXPO  &&  !(q->s_mode & DEFN))
	      reloc |= (EXPO | gblidx);

	    if (q->s_mode & EXT)
	      reloc |= (EXT | gblidx);

	    break;

	  /*
	   * !   Return current pc for this location counter
	   */
	  case '!':
	    v = locn[lcntr].l_value;
	    mreloc = REL;
	    break;

	  /*
	   * +   Return argument (positive value)
	   */
	  case '+':
	    v = lvalue();
	    break;

	  /*
	   * -   Return argument (negative value)
	   */
	  case '-':
	    v = -lvalue();
	    break;

	  /*
	   * ~   Return argument (1's complement)
	   */
	  case '~':
	    v = ~lvalue();
	    break;

	  /*
	   *
	   */
	  case ',':
	    synerr("delimiter unexpected");
	    v = 0;
	    mreloc = NUL;
	    break;

	  default:
	    synerr("bad argument");
	    v = 0;
	    mreloc = NUL;
	    break;

	}
	return(v);
}

/*
 *   Convert ascii number to binary pointed to by 'p'.
 */
argnum()
{
	register int n, j;

	n = 0;

	if (*p == '0')	{
	  p++;
	  if (*p == 'x') {
	    p++;
	    while ((j = any(*p, hextab)) >= 0)  {
	      n = (n<<4) | j;
	      p++;
	    }
	  return(n);
	  }

	  if (*p == 'b'){
	    p++;
	    while (*p == '0' || *p == '1')
	      n = (n<<1) | (*p++ - '0');
	    return(n);
	  }

	  while ((j = any(*p, octtab)) >= 0)  {
	    n = (n<<3) | j;
	    p++;
	  }
	  return(n);
	}

	while ((j = any(*p, dectab)) >= 0)  {
	  n = n * 10 + j;
	  p++;
	}

	return(n);
}

/*
 *   Comparison	for searching.
 *
 *	return	1:  *r > *s,
 *		0:  *r = *s,
 *	       -1:  *r < *s.
 */
cmp(r, s)
register char *r;
register char *s;
{
	register int i;


	/*
	 *   fast compare
	 */
	if (*r < *s)
	  return(-1);
	if (*s < *r)
	  return(1);

	i = 0;
	while (i < 8)  {
	  r++;
	  s++;

	  if (*r < *s)
	    return(-1);
	  if (*s < *r)
	    return(1);
	  if (!*r)
	    return(0);		/* equal on nul	*/
	  i++;
	}
	return(0);
}


/*
 *   printl:  like prf1	but with leading zero's.
 */
printl(width, data)
register int width;
register int data;
{
	register char *r;
	register int i;
	register int fmt;
	register int mask;

	if (!data)  {
	  for (i=0; i<width; i++)
	    putchar('0');
	  return;
	}

	r = srcbuf;
	if (*option('h'))  {
	  fmt = 'h';		/* hex */
	  mask = BITMASK(WORDSIZ - 4);
	}
	if (*option('o'))  {
	  fmt = 'o';		/* oct */
	  mask = BITMASK(WORDSIZ - 3);
	}
	if (*option('b'))  {
	  fmt = 'b';		/* bin */
	  mask = BITMASK(WORDSIZ - 1);
	}

	i = width;
	while (i--)  switch (fmt)  {

	  case 'd':
	  case 'h':
	    *r++ = hextab[data & 0x0f];
	    data = (data >> 4) & mask;
	    break;

	  case 'o':
	    *r++ = (data & 07) + '0';
	    data = (data >> 3) & mask;
	    break;

	  case 'b':
	    *r++ = (data & 01) + '0';
	    data = (data >> 1) & mask;
	    break;

	}

	r = &srcbuf[width-1];
	for (i=0; i<width; i++)
	  putchar(*r--);

	return;
}

/*
 *	compar:	Compare two strings - return
 *		TRUE if equal, FALSE if not
 */
compar(r, s)
register char *r;
register char *s;
{
	while (*r == *s){
	  if ((*r == '\0')&&(*s == '\0'))
	    return(1);
	  r++;
	  s++;
	}
	return(0);
}

/*
 *	Convert an integer to ascii characters and
 *	push characters to core pointed to by 'r'.
 */
char *
num(n, r)
register int n;
register char *r;
{
	register int neg, mask, i;
	char ch[16];

	i = 0;
	neg = n;
	mask = BITMASK((WORDSIZ -1));

	if(!n){
	 *r++ = '0';
	 return(r);
	}

	if(neg < 0){
	  *r++ = '0';
	  *r++ = 'x';
	}

	while(n){
	  if(neg < 0) {
	    ch[i] = hextab[n&0xf];
	    n = (n >> 4) & mask;
	  }
	  else{
	    ch[i] = (n % 10) + '0';
	    n /= 10;
	  }
	  i++;
	}

	while ( --i >= 0){
	 *r++ = ch[i];
	}

	return(r);
}

/*
 *	Search string 'str' for character 'c' and return its
 *	index in 'str' if found. Return ERR otherwise.
 */
any(c, str)
register char c;
char str[];
{
	register i;
	i= 0;
	while (str[i]){
	  if(c == str[i])
	    return(i);
	  i++;
	}
	return(ERR);
}

