		save
	if DontListIncls
		listing off
	endif

;********************************************************************
;
; This file contains definitions for 3.99 R/W firmware
;
; 2002-11-24 PS
; last changes 2014-02-04 PS
;
;********************************************************************


Stack_Top 	EQU 080h		; Register 07Fh +1



;********************************************************************
; Hardware
;********************************************************************
;
;	I/O Port	Use
;	--------	---
;	   0		Bit 0: Adr8
;	{Output}	Bit 1: Adr9
;			Bit 2: Adr10 
;			Bit 3: PreComp  (precomp / reduce write current)
;			Bit 4: PHIB2  (step motor phases)
;			Bit 5: PHIB1
;			Bit 6: PHIA2
;			Bit 7: PHIA1
;
;	   1 		Bit 0: Adr0 
;    {Input/Output}	Bit 1: Adr1 
;			Bit 2: Adr2 
;			Bit 3: Adr3
;			Bit 4: Adr4 
;			Bit 5: Adr5 
;			Bit 6: Adr6 
;			Bit 7: Adr7
;
;	   2 		Bit 0: WRTSMI  (write sector mark input)
;    {Input/Output}	Bit 1: Trk0  (track 0 input)
;			Bit 2: CMD  (command input)
;			Bit 3: BSY  (busy output)
;			Bit 4: Msel0
;			Bit 5: Msel1  (1=disk, 0=host)
;			Bit 6: DSTART
;			Bit 7: DRW  (disk read=1 / write=0)
;
;	   3		Bit 0: FastSeek  (=1 for fast seek)
;    {Input/Output}	Bit 1: SectorMark (sector pulse input)
;			Bit 2: Index (index pulse input)
;			Bit 3: CRCERR (=0 if error detected)
;			Bit 4: HS0
;			Bit 5: HS1
;			Bit 6: WRTSM  (write sector mark output)
;			Bit 7: RDHDR/TX
;

; Port 0 Defs:
PreComp	 	EQU 008h	; set 1 to reduce write current (above cylinder 255)
PHIB2	 	EQU 010h
PHIB1	 	EQU 020h	; step motor phases
PHIA2 		EQU 040h
PHIA1	 	EQU 080h

; Port 2 Defs:
SECTDN	 	EQU 001h	; =0 when state machine finished
Trk0 		EQU 002h	; =0 when heads on track 0
CMD 		EQU 004h	; Apple CMD input
BSY 		EQU 008h	; Apple BUSY output. Set 0 when busy.
Msel0 		EQU 010h	; Memory Select bit 0
Msel1 		EQU 020h	; Memory Select bit 1
				;   00: Apple --> Mem
				;   01: Z8 --> Timer
				;   10: State Machine (Disk) --> Mem
				;   11: Z8 --> Mem
DSTART 		EQU 040h	; set 1 to reset state machine, set 0 to start
DRW_Read 	EQU 080h	; Apple/Disk direction: 1 = Read, 0 = Write

; Port 3 Defs:
FastSeek	EQU 001h	; =1 for fast, =0 for slow seek
SectorMark 	EQU 002h	; sector mark from analog board
Index	 	EQU 004h	; index pulse input from analog board
CRCERR		EQU 008h	; =0 if CRC error detected
HS0 		EQU 010h	; Head select 
HS1 		EQU 020h	;
WRTSM		EQU 040h	; set 0 to write sector mark
RDHDR 		EQU 080h	; set 0 to read next header into RAM



;********************************************************************
; Registers
;********************************************************************

OnTrackFlg	EQU 004h	; <>0 when heads have been moved
P3Mask1		EQU 005h	; WRTSM + RDHDR + Heads
P3Mask2		EQU 006h	; WRTSM + Heads
SpareTblDirty	EQU 007h	; <>0 when spare table needs to be updated
SkipSpared	EQU 008h	; <>0 if spared blocks should be skipped
BlockIsSpared	EQU 009h	; <>0 if we seeked to spare instead of block
Status1   	EQU 00Ah	; these are the status bytes for the host
Status2   	EQU 00Bh
Status3   	EQU 00Ch
Status4         EQU 00Dh
CurStep   	EQU 00Eh	; step motor angle (0..7)
HostCommand	EQU 010h	; these are the command bytes from host
LBAhi	  	EQU 011h	;   logical block number hi
LBAmi	  	EQU 012h	;			 mid
LBAlo	  	EQU 013h	;			 low
LBA	  	EQU LBAmi	;   this is an word alias for LBAmi.LBAlo
RetryCnt  	EQU 014h	;   retry count (default=100)
SparingTh 	EQU 015h	;   sparing threshold
MaskChkHdr	EQU 016h	; don't check headers after seek when <>0
SpareMap_RW	EQU 017h	; <>0 when spare map accessed after ReadCHS, WriteCHS
DSM_FastTo	EQU 018h	; <>0 for fast disk state machine timeout
HeaderImage	EQU 019h	; sector header bytes: this byte always = 000h
ActCylH  	EQU 01Ah	;   actual cylinder
ActCylL  	EQU 01Bh
ActHead   	EQU 01Ch	;          head
ActSector 	EQU 01Dh	;          sector
ComCylH	  	EQU 01Eh	;   complemented actual cylinder
ComCylL		EQU 01Fh
ComHead   	EQU 020h	; 	  	        head
ComSector 	EQU 021h	; 		        sector
LastSublist	EQU 022h	; last spare table sublist used (=last LBAmi value)
StpMotOff 	EQU 023h	; <>0 if step motor off
DiskSM_Timeout	EQU 024h	; <>0 if disk state machine timeout
RWstat		EQU 025h	; this goes into Status1 
CylinderH  	EQU 026h	; cylinder from LBA translation
CylinderL	EQU 027h
Head	  	EQU 028h	; head from LBA translation
; 029h read spare table
RetriesLeft	EQU 02Ah	; number of retries left for read operation (starts at RetryCount)
GoCHSRetry	EQU 02Ch	; retry counter for GoCHS routine
OnTrackCtr	EQU 02Dh	; counter for Seek_ChkHdr function
SprTblRetry	EQU 02Eh	; retry counter for spare table R/W
RAM_MSB		EQU 02Fh	; RAM MSB (010h or 013h)
HeaderBufLSB 	EQU 030h	; RAM LSB for state machine operation
StatusBufLSB	EQU 031h	; RAM LSB of status buffer address (set but not used)
ReReadGood	EQU 033h	; <>0 if ReRead did at least one successful read
SpMap_Highest	EQU 034h	; highest LBAlo in current subtable
SpMap_Lowest	EQU 035h	; lowest LBAlo in current subtable
SpMap_Read	EQU 036h	; <>0 when called from R/W or seek, =0 when called after sparing
DelayMotorStep	EQU 037h	; =0 if no delay before step motor update
PwrFlg0		EQU 038h	; =0FFh for warm start
PwrFlg1		EQU 039h	; =001h for warm start
SpareBlocks	EQU 03Ah	; number of spares allocated
BadBlocks 	EQU 03Bh        ; number of bad blocks
CHSinvalid	EQU 03Ch	; <>0 if LBAtoCHS did not update Cylinder/Head/ActiveSector
BlockStat	EQU 03Dh 	; block to be entered into spare table is 040h = bad or 080h = spared
SpareTblInvalid	EQU 03Eh	; <>0 if spare table could not be read
SettlingReqd	EQU 040h	; <>0 when we just moved the heads
ReReadMode	EQU 041h	; =0 to continue re-reading after first good read
BlockIsBad	EQU 042h 	; <>0 if the current block is a bad block
; 043h read spare table
; 044h
ReadWithHdr   	EQU 045h 	; <>0 if header checking is to be done by SW, not state machine
; 046h seek magnitude
; 047h
; 048h
; 049h pointer into AccelTab
; 04Ah	; seek direction
; 04Bh delay
ScrubCtr1	EQU 04Ch	; pointer into sublist while scrubbing bad blocks
ScanCtr1	EQU 04Dh	; sector counter while interleaving
ScanCtr2	EQU 04Eh	; sector counter while interleaving
WorkingRegs	EQU 050h	; 040..04Fh are our working registers R0..R15


;********************************************************************
; External Ram Stuff
;********************************************************************

RAM		EQU 01000h
ReadBuffer	EQU 01014h
RdHdrBuffer	EQU 01020h
WriteBuffer	EQU 01028h
SpareMapFence	EQU 0123Dh	; should be 055h, 099h, 0AAh
;
; local spare map
;
SpareMap	EQU 01240h	; 026h two-byte byte pointers to the sublists
	; The spare map is a list with 026h two-byte entries, one for each 
	; LBAmi value. Each entry either contains FFFF (NIL) or points to
	; a sublist in memory. 
SpareMapEnd	EQU 012DAh	; first free RAM address after the spare table
SpareSublists	EQU 012DEh	; one sublist for each LBAmi value
	; The first byte of this sublist holds the number of two-byte entries
	; in this list. Each entry consists of the LBAlo value of the questionable
	; block, followed by a type byte. Bit 7 =1 indicates a spared block, bit 6 =1
	; indicates a bad block, and bit 4..0 indicate which spare track block is used.
;
SeekHeaderBuf	EQU 013E0h
HostCmdBuffer	EQU 013F0h	; host DMAs his commands here

FMTEN		EQU 00800h	; open write gate (needs jumper P7 to be closed)


;********************************************************************
; Constants
;********************************************************************

; *** System Status Definitions
;     Status1
Bad_55 		EQU 080h	; Status: Other than 55 response from host
WrBuf_OR 	EQU 040h	; Status: Write Buffer Overflow
Stat_SpTblUpd	EQU 020h	; Status: host data lost because spare table updated
Stat_Seek_Err	EQU 010h	; Status: Seek Error
Stat_Rd_Err	EQU 008h	; Status: Read Error
Stat_No_Hdr 	EQU 004h	; Status: No Header Found
Stat_nc1 	EQU 002h
Op_Failed 	EQU 001h	; Status: Operation Failed
;     Status2
Stat_Seek_Flt	EQU 080h	; Status: seek needed retry
SprTbl_Full 	EQU 040h	; Status: no room left in spare table
BadBkTbl_Full 	EQU 010h	; Status: bad block table overflow
Stat_SprTbl_Err	EQU 008h	; Status: unable to read status sector
Stat_Spare 	EQU 004h	; Status: Sparing has occured
Stat_Seek 	EQU 002h	; Status: Seek to wrong track
;     Status3
Power_Reset 	EQU 080h	; Profile was power reset
Illegal_Block 	EQU 040h	; Status: Block number out of bounds
;     Status4 holds the number of retries needed


; Spare Table offsets (relative to start of buffer)
ST_DeviceName	EQU 0		; "PROFILE      "
ST_DeviceType	EQU 13		; 000h, 000h, 000h
ST_FwRev	EQU 16		; 003h, 098h
ST_Capacity	EQU 18		; 000h, 026h, 000h
ST_BlockSize	EQU 21		; 002h, 014h
ST_SparesAvail	EQU 23		; 020h
ST_SparesAlloc	EQU 24	
ST_BadPending	EQU 25
ST_SpareMap	EQU 26		; length 154 bytes
ST_SpareMapEnd	EQU 180
ST_Sublists	EQU 182


	restore


