|
|	VOID cpybuf( dest, src, count )
|		char *dest;
|		char *src;
|		int count;
|
|	in:
|		Parameters on stack
|
|	out:
|		none
|
|	destroyed:
|		d0, d1, a0, a1
|

	.text
	.even
	.globl	_cpybuf

_cpybuf:
	movl	d2,sp@-					| save sacred C reg
	movl	d3,sp@-
	movl	sp@(12),d1				| dest
	movl	d1,a1
	movl	sp@(16),d0				| src
	movl	d0,a0
	movl	sp@(20),d2				| count
	bles	6f						| if <= 0

	movb	d0,d3					| check for even/odd address
	eorb	d1,d3
	btst	#0,d3
	bnes	4f						| if one even, other odd

	btst	#0,d0					| same parity, both odd?
	beqs	1f						| if not

	movb	a0@+,a1@+				| align to even boundary
	subql	#1,d2

1:
	movl	d2,d0					| use long moves, if possible
	lsrl	#2,d0					| # longs to move
	beqs	3f						| if none

	subql	#1,d0					| for dbra
	movl	d0,d1
	swap	d1

2:
	movl	a0@+,a1@+
	dbra	d0,2b
	dbra	d1,2b

3:
	moveq	#3,d0					| move remaining bytes
	andl	d0,d2
	beqs	6f						| if none

4:
	subql	#1,d2					| for dbra
	movl	d2,d0
	swap	d0

5:
	movb	a0@+,a1@+
	dbra	d2,5b
	dbra	d0,5b

6:
	movl	sp@+,d3
	movl	sp@+,d2
	rts
