/*
 *	generic escape functions
 *
 *	Revision History:
 *
 *		29 aug 86	wrf		sw# 49
 *			added read/write DLM escape
 */

#define ESCTRACE	1		/* enable GKS tracing for selected */
							/*  group of functions */
#define ESCPSEL		2 		/* plane select */
#define ESCVSW		3		/* video switch */
#define ESCZOOMPAN	4		/* manipulate pan and zoom hardware */
#define ESCDRAG		5		/* drag set of segments */
#define ESCRDRW		6		/* extended redraw */
#define ESCLDEF		7		/* define linestyle */
#define ESCLDCLU	8		/* load multiple clu entries */
#define ESCCLIP		9		/* change segment clip rectangles */
#define ESCSGDRW	10		/* draw selected segments */
#define ESCPICK		11		/* extended pick */
#define ESCERASE	12		/* erase screen */
#define ESCBRATE	13		/* set blink rate */
#define ESCBTYPE	14		/* set blink type */
#define ESCBCTBL	15		/* set blink color table */
#define ESCBLINK	16		/* blink on/off */


/*
 *	"plane select" escape function
 *
 *	ps_data is a bit mask with bit zero corresponding
 *	to the lowest plane of a system.
 *
 *	those planes with a 0 in the corresponding mask position will
 *	not be modified by subsequent writes
 */
struct escpsel
	{
	WKID ps_wkid;				/* id of relevant workstation */
	unsigned long ps_data;		/* plane mask */
	};


/*
 *	"video switch" escape function
 *
 *	vs_data is a bit mask with bit zero corresponding
 *	to the lowest plane of a system.
 *
 *	those planes with a 0 in the corresponding mask position will
 *	appear as zero to the video system.
 */
struct escvsw
	{
	WKID vs_wkid;				/* id of relevant workstation */
	unsigned long vs_data;		/* plane mask */
	};


/*
 *	"zoompan" escape function
 *
 *	pan registers are set so that the given DC point "zp_origin" is
 *	shifted to the lower left corner of the screen. The x and y
 *	zoom factors are set as specified (zoom >= 1)
 *
 *	if zp_xwrap is true, the picture will wrap in the x direction
 *	(hardware permitting.)
 *	otherwise, the picture will be filled with pixels of color "zp_xfill"
 *	(hardware permitting.)
 *
 *	if zp_ywrap is true, the picture will wrap in the y direction
 *	(hardware permitting.)
 *	otherwise, the picture will be filled with pixels of color "zp_yfill"
 *	(hardware permitting.)
 */
struct esczoompan
	{
	WKID zp_wkid;			/* id of relevant workstation */
	DCPT zp_origin;			/* point to be anchored at lower left corner */
	unsigned char zp_xzoom;	/* x zoom factor */
	unsigned char zp_yzoom;	/* y zoom factor */
	BOOL zp_xwrap;			/* true if picture should wrap in x */
	BOOL zp_ywrap;			/* true if picture should wrap in y */
	COLOR zp_xfill;			/* color to fill if zp_xwrap is FALSE */
	COLOR zp_yfill;			/* color to fill if zp_ywrap is FALSE */
	};


/*
 *	"drag" escape function
 *
 *	the specified locator device is used to "drag" (i.e. translate in
 *	x and y) the list of segments. Upon the completion of the
 *	interaction, all workstations containing the given segments
 *	will be updated to reflect the new translation.
 */
struct escdrag
	{
	WKID dr_wkid;				/* id of OUTIN workstation */
	int dr_devno;				/* which locator device on workstation*/
	unsigned short dr_nsegs;	/* number of segments to be affected */
	SEGNAME dr_segs[1];			/* variable length list of segnames */
	};

struct escrpdrag				/* reply to "drag" escape */
	{
	NDC dr_delx;
	NDC dr_dely;
	};


/*
 *	extended redraw
 */
struct escrdrw
	{
	WKID rd_wkid;					/* id of relevant workstation */
	SEGNAME rd_sgid;				/* what to redraw */
	DCPT rd_ll;						/* lower left corner of redraw area */
	DCPT rd_ur;						/* upper right corner of redraw area */
	BOOL rd_front;					/* draw in front image */
	BOOL rd_flip;					/* flip buffer after redraw */
	COLOR rd_erase;					/* background color */
	int rd_repeat;					/* # times to redraw */
	int rd_delay;					/* wait "delay" vert syncs */
	};


/*
 *	define linestyles
 */
struct escldef
	{
	WKID ld_wkid;					/* id of relevant workstation */
	int ld_cnt;						/* # of linestyles to define */
	struct ld_tbl
		{
		unsigned short ld_no;		/* linestyle number */
		unsigned long ld_pat;		/* linestyle pattern */
		} ld_tbl[1];				/* one or more linestyles */
	};


/*
 *	load multiple CLU entries
 */
struct escldclu
	{
	WKID clu_wkid;					/* id of relevant workstation */
	BOOL clu_hwld;					/* load hardware table along  */
									/*   with software copy       */
	int clu_cnt;					/* # of entries to load */
	struct clu_tbl
		{
		unsigned short clu_no;		/* table entry */
		unsigned char clu_r;
		unsigned char clu_g;
		unsigned char clu_b;
		unsigned char clu_pad;		/* force to even boundary */
		} clu_tbl[1];
	};


/*
 *	change segment clip rectangles
 */
struct escclip
	{
	WKID clip_wkid;					/* relevant workstation */
	int clip_cnt;					/* # of rectangles to change */
	struct setclip
		{
		SEGNAME id;
		NDCPT clip_ll;
		NDCPT clip_ur;
		} cliplst[1];
	};


/*
 *	draw selected segments
 */
struct escsgdrw
	{
	WKID sg_wkid;				/* id of relevant workstation */
	int sg_cnt;					/* # of segments to draw */
	SEGNAME sg_list[1];			/* variable length in reality */
	};


/*
 *	extended pick
 */
struct escpick
	{
	WKID pk_wkid;				/* id of relevant workstation */
	int pk_max;					/* max # of items to pick */
	NDCPT pk_ll;				/* pick rectangle */
	NDCPT pk_ur;
	struct pk_res
		{
		PICKID pk_id;
		SEGNAME pk_name;
		} pk_res[1];
	};


/*
 *	erase screen, w/o side effects of clear workstation
 */
struct escerase
	{
	WKID erase_id;
	};


/*
 *	set blink rate
 */
struct escbrate
	{
	WKID bl_wkid;					/* id of relevant workstation */
	int bl_on;						/* blink on duration */
	int bl_off;						/* blink off duration */
	};


/*
 *	set blink type
 */
#define PLANEBLINK	0
#define COLORBLINK	1

struct escbtype
	{
	WKID bl_wkid;					/* id of relevant workstation */
	unsigned short bl_type;			/* blink type */
	unsigned long bl_mask;			/* plane mask */
	};


/*
 *	set blink color table
 */
struct escbctbl
	{
	WKID bl_wkid;					/* id of relevant workstation */
	int bl_cnt;						/* # entries */
	struct bctbl
		{
		unsigned short ct_ndx;		/* color index */
		unsigned long ct_rgb;		/* blink color */
		} bl_ct[1];
	};


/*
 *	blink
 */
struct escblink
	{
	WKID bl_wkid;					/* id of relevant workstation */
	BOOL bl_blink;
	};


/*
 *	cx-1500 escape functions
 */
#define ESCCXPSEG	100
#define ESCCXGSEG	101
#define ESCCXAUXV	102
#define ESCCXHW		103
#define ESCCXDLPOP	104
#define ESCCXMLOAD	105
#define ESCCXFNTLD	106
#define ESCCXMDEF	107		/* define polymarker */
#define ESCCXHDEF	108		/* define hatch pattern */
#define ESCCXRIO	109		/* remote I/O */
#define ESCCXINFG	110		/* initialize frame grabber */
#define ESCCXLDCLD	111		/* load color lookdown table */
#define ESCCXHCM	112		/* set highlight color mask */
#define ESCCXMEM	113		/* reserve display list memory */
#define ESCCXRDLM	114		/* read from DLM */
#define ESCCXWDLM	115		/* write to DLM */


/*
 *	putseg escape function
 */
struct esccxpseg 
	{
	SEGNAME cxps_id;				/* name of segment to be created */
	char cxps_pname[MAXPATH + 1]; 	/* file containing segment image */
	};


/*
 *	getseg escape function
 */
struct esccxgseg
	{
	WKID cxgs_wkid;					/* workstation on which segment resides */
	SEGNAME cxgs_id;				/* name of segment */
	char cxgs_pname[MAXPATH + 1]; 	/* file to receive segment image */
	};


/*
 *	auxiliary video on/off
 */
struct esccxauxv
	{
	WKID cxaux_wkid;				/* id of relevant workstation */
	BOOL cxaux_flg;					/* switch */
	};


/*
 *	get hardware description
 */
struct esccxhw
	{
	WKID cxhw_wkid;					/* id of relevant workstation */
	unsigned long cxhw_im0pl;		/* main bitmap image 0 planes */
	unsigned long cxhw_im1pl;		/* main bitmap image 1 planes */
	unsigned long cxhw_ov0pl;		/* graphics ovly image 0 planes */
	unsigned long cxhw_ov1pl;		/* graphics ovly image 1 planes */
	BOOL cxhw_cc0;					/* char cell ovly 0 present */
	BOOL cxhw_cc1;					/* char cell ovly 1 present */
	unsigned long cxhw_dlm;			/* # bytes of DLM */
	unsigned long cxhw_ram;			/* iop RAM */
	short cxhw_idisp;				/* image being displayed (0, 1) */
	short cxhw_iproc;				/* image being processed (0, 1) */
	};


/*
 *	use DLP opcodes as output primitives
 */
struct esccxdlpop
	{
	int cxdlp_n;					/* # of DLP opcodes */
	unsigned long cxdlp_op[1];		/* variable length array of opcodes */
	};


/*
 *	load microcode
 */
struct esccxmload
	{
	WKID cxmld_wkid;				/* id of relevant workstation */
	unsigned short cxmld_n;			/* # of 80 bit microinstructions */
	unsigned short cxmld_a;			/* load address */
	unsigned short cxmld_i[1][5];	/* array of microwords */
	};


/*
 *	download font function
 */
struct esccxfntld 
	{
	WKID cxfl_wkid;					/* target workstation */
	int cxfl_fntno;					/* font number */
	char cxfl_fname[MAXPATH + 1]; 	/* file containing font */
	};


/*
 *	define polymarkers
 */
struct escmdef
	{
	WKID md_wkid;					/* id of relevant workstation */
	int md_cnt;						/* # of markers to define */
	int md_size;					/* total # of longs in all md_data */
	struct md_tbl
		{
		unsigned short md_no;		/* marker number */
		unsigned short md_len;		/* # elements in md_data[] */
		unsigned long md_data[1];	/* variable length in reality */
		} md_tbl[1];				/* one or more markers */
	};


/*
 *	define hatch patterns
 */
struct eschdef
	{
	WKID hd_wkid;				/* id of relevant workstation */
	int hd_cnt;					/* # of hatch patterns */
	struct hd_tbl
		{
		unsigned short hd_no;		/* hatch number */
		unsigned long hd_def[32];	/* hatch pattern */
		} hd_tbl[1];				/* one or more hatch patterns */
	};


/*
 *	remote device i/o
 */
#define RIO_READ	0
#define RIO_POLL	1
#define RIO_WRITE	2
#define RIO_SWRITE	3

#define RIO_NAME	8			/* max chars in device name */

struct escrio
	{
	WKID rio_wkid;				/* id of relevant workstation */
	char rio_dev[RIO_NAME+1];	/* device name */
	short rio_cmnd;				/* in: i/o command, out: status */
	unsigned short rio_len;		/* buffer size */
	char rio_buf[1];			/* variable length in reality */
	};


/*
 *	set frame grabber parameters
 */
#define FG_MENU		-1					/* use menu item					*/

#define FG_NTSC		0
#define FG_RGB		1

#define FG_COLOR	0
#define FG_MONOC	1

#define FG_V754		0
#define FG_V640		1

#define	FG_NZOOM	0
#define FG_ZOOM		1
#define FG_SUBZM	2

#define FG_CXLSP	16					/* CX computes linespacing			*/


struct escsetfg
	{
	WKID fg_wkid;
	int fg_input;						/* FG_NTSC/FG_RGB */
	int fg_source;						/* 0..3 */
	int fg_color;						/* FG_COLOR/FG_MONOC */
	int fg_vbkp;						/* 0..24 */
	int fg_veclen;						/* FG_V754/FG_V640 */
	int fg_xzoom;						/* FG_NZOOM, FG_ZOOM, FG_SUBZM */
	int fg_yzoom;						/* 0..FG_CXLSP */
	int fg_linesp;
	};


/*
 *	load color lookdown table
 */
struct escldcld
	{
	WKID cld_id;
	unsigned char cld[4096];
	};


/*
 *	set highlight color mask
 */
struct esccxhcm
	{
	WKID hc_wkid;					/* id of relevant workstation */
	unsigned long hc_hcm;			/* color mask */
	};


/*
 *	allocate/free display list memory
 */
struct esccxmem
	{
	WKID mem_wkid;					/* id of relevant workstation */
	char *mem_addr;					/* set by alloc, used by free */
	BOOL mem_alloc;					/* TRUE if alloc, FALSE if free */
	unsigned long mem_size;			/* # bytes to alloc */
	};


/*
 *	read/write DLM
 */
struct esccxdlmrw
	{
	WKID dlm_wkid;					/* id of relevant workstation */
	char *dlm_host;					/* address of user data */
	char *dlm_cx;					/* DLM address */
	int dlm_cnt;					/* # bytes to write */
	};
