/*
 *	GDP
 */
#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/gdp.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate;

GKSERR gdp( npts, pts, gdpid, gdpdata )
	int npts;
	WCPT pts[];
	GDP_ID gdpid;
	char *gdpdata;
	{
	int msgsize;

	struct msgdp *msg;
	struct rpgdp *reply;
	WSINFO ws;
	BOOL onebad = FALSE;
	static char *fname = "gdp";

#ifdef TRACE
	if(Gksdebug & DB_OUTPUT)
		Gksout("gdp(%d, %d)\n", npts, gdpid);
#endif

	if(!Gksckstate(GS_WSAC | GS_SGOP))
		return(err_hand(5, fname));

	if(npts < 0)
		return(err_hand(100, fname));


/*
 * deliver gdp message to all ACTIVE workstations
 *
 * note variable size message here
 * the gdp message allocates room for one point - 
 * (npts-1)*sizeof(NDCPT) more is needed.
 */

	msgsize = sizeof(struct msgdp) + (npts-1)*sizeof(NDCPT);
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		{
		if(!WsActive(ws))
			continue;
		msg = (struct msgdp *)_allocmsg(msgsize);
		if(msg == NULL)
			return(err_hand(904, fname));
		gdpmsg(msg, WsGetpid(ws), npts, pts, gdpid, gdpdata, msgsize);
		if (WsGetcat(ws) == WSC_WISS)
			wissmsg((char *)msg);
		else
			_sendmsg((char *)msg);
		}
/*
 * if not WISS, wait for reply
 */
	onebad = FALSE;
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		{
		if(!WsActive(ws))
			continue;
		if (WsGetcat(ws) == WSC_WISS)
			continue;
		reply = (struct rpgdp *)_recvmsg(WsGetpid(ws));
		if(reply == NULL)
			return (err_hand(WsNomsg(), fname));
		if(reply->mhdr.msg_reply != 0)
			onebad = TRUE;
		_freemsg(reply);
		}

	if(onebad)
		return(err_hand(104, fname));
	else
		return(0);
	}


static gdpmsg( msg, pid, npts, pts, gdpid, gdpdata, msgsize )
	register struct msgdp *msg;
	PID pid;
	int npts;
	WCPT pts[];
	GDP_ID gdpid;
	char *gdpdata;
	int msgsize;
	{
	register int i;
	NDCPT ndcpt;
	WCPT wcpt;					/* used to convert height to NDC */
	NDCPT ndcvec;				/* used to convert height to NDC */


	msg->mhdr.msg_id = MSGDP;
	msg->mhdr.msg_to = pid;
	msg->mhdr.msg_length = msgsize - sizeof(MSGHDR);
	msg->mhdr.msg_ack = TRUE;
	msg->mhdr.msg_reply = 0;

	msg->gdp_id = gdpid;
	msg->gdp_pick = Gksstate.gs_pick;

	msg->gdp_pllbnd = Gksstate.gs_plbund;
	cpybuf(&(msg->gdp_plrep), &Gksstate.gs_plrep, sizeof(struct plrep));

	msg->gdp_pmbnd = Gksstate.gs_pmbund;
	cpybuf(&(msg->gdp_pmrep), &Gksstate.gs_pmrep, sizeof(struct pmrep));

	msg->gdp_txbnd = Gksstate.gs_txbund;
	cpybuf(&(msg->gdp_txrep), &Gksstate.gs_txrep, sizeof(struct txrep));
	wcpt.wc_x = wcpt.wc_y = Gksstate.gs_txhght;
	_wc2ndc(&wcpt, &ndcvec);
	msg->gdp_txhgt = ndcvec.ndc_x;
	msg->gdp_txup.ndc_x = Gksstate.gs_txupvec.wc_x;
	msg->gdp_txup.ndc_y = Gksstate.gs_txupvec.wc_y;
	msg->gdp_txpth = Gksstate.gs_txpath;
	msg->gdp_txaln.txt_horiz = Gksstate.gs_txalin.txt_horiz;
	msg->gdp_txaln.txt_vert = Gksstate.gs_txalin.txt_vert;

	msg->gdp_fabnd = Gksstate.gs_fabund;
	cpybuf(&(msg->gdp_farep), &Gksstate.gs_farep, sizeof(struct farep));
	wcpt.wc_x = Gksstate.gs_fapwv.wc_x;
	wcpt.wc_y = Gksstate.gs_faphv.wc_y;
	_wc2ndc(&wcpt, &ndcpt);
	msg->gdp_fapsz.ndc_x = ndcpt.ndc_x;
	msg->gdp_fapsz.ndc_y = ndcpt.ndc_y;
	_wc2ndc(&Gksstate.gs_fapref, &ndcpt);
	msg->gdp_faref.ndc_x = ndcpt.ndc_x;
	msg->gdp_faref.ndc_y = ndcpt.ndc_y;

	msg->gdp_asf = Gksstate.gs_asf;

	if (gdpdata != NULL)
		cpybuf(msg->gdp_data, gdpdata, MAXGDPDATA);

	msg->gdp_npts = npts;

	for(i = 0; i < npts; ++i)
		{
		_wc2ndc(&pts[i], &ndcpt);
		msg->gdp_pts[i].ndc_x = ndcpt.ndc_x;
		msg->gdp_pts[i].ndc_y = ndcpt.ndc_y;
		}
	}
