/*
 * structures returned by GKS inquiry functions.
 */

/*
 *	bundle table structures
 */

/* polyline representation */
struct plrep
{
	PLTYPE   pl_type;
	REAL  pl_wdth;
	COLOR pl_col;
};

/* polymarker representation */
struct pmrep
{
	PMTYPE   pm_type;
	REAL  pm_size;
	COLOR pm_col;
};

/* text representation */
struct txrep
{
	int   tx_font;
	TPREC tx_prec;
	REAL  tx_chexp;
	REAL  tx_space;
	COLOR tx_col;
};

/* fill area representation */
struct farep
{
	FILINTER   fa_istyle;
	int   fa_style;
	COLOR fa_col;
};

/* pattern representation */
struct ptrep
{
	int pt_dx;
	int pt_dy;
	COLOR *pt_array;
};

/* color representation */
struct colrep
{
	REAL cor_red;
	REAL cor_green;
	REAL cor_blue;
};

/*
 * structures used in workstation description inquiry
 */

struct dmrep 		/* dynamic modification of representations */
{
	DYNMOD dmr_plrep;
	DYNMOD dmr_pmrep;
	DYNMOD dmr_txrep;
	DYNMOD dmr_farep;
	DYNMOD dmr_ptrep;
	DYNMOD dmr_corep;
	DYNMOD dmr_wktr;
};

struct dmseg		/* dynamic modification of segment attributes */
{
	DYNMOD dms_segtr;
	DYNMOD dms_vis;
	DYNMOD dms_invis;
	DYNMOD dms_high;
	DYNMOD dms_pri;
	DYNMOD dms_add;
	DYNMOD dms_del;
};

struct plfacil		/* polyline facilities */
{
	unsigned short plf_ntypes;
	unsigned short plf_nwdth;
	REAL plf_nomwdth;
	REAL plf_minwdth;
	REAL plf_maxwdth;
	unsigned short plf_nbund;
};

struct pmfacil		/* polymarker facilities */
{
	unsigned short pmf_ntypes;
	unsigned short pmf_nsize;
	REAL pmf_nomsize;
	REAL pmf_minsize;
	REAL pmf_maxsize;
	unsigned short pmf_nbund;
};

struct txfacil		/* text facilities */
{
	unsigned short txf_nfp;	/* number font/prec pairs */
	struct txfp
	{
		unsigned short txfp_fnt;
		TPREC txfp_prec;
	} txf_pairs[MAXTXFP];
	unsigned short txf_nhght;
	REAL txf_minhght;
	REAL txf_maxhght;
	unsigned short txf_nexp;
	REAL txf_minexp;
	REAL txf_maxexp;
	unsigned short txf_nbund;
};

struct fafacil		/* fill area facilities */
{
	unsigned short faf_nint;	/* number of interior styles */
	FILINTER faf_int[4];
	unsigned short faf_nhatch;
	unsigned short faf_nbund;
};

struct ptfacil		/* pattern facilities */
{
	unsigned short ptf_nbund;
};

struct cofacil		/* color facilities */
{
	unsigned short cof_ncol;	/* number of colors */
	BOOL cof_iscol;
	unsigned short cof_nbund;
};

/*
 * gks state list
 */

struct gksstate
{
	GKSSTATE gs_opstate;
	unsigned short gs_nopw;
	unsigned short gs_nacw;

	int gs_plbund;				/* current polyline index */
	struct plrep gs_plrep;		/* current polyline representation */

	int gs_pmbund;				/* current polymarker index */
	struct pmrep gs_pmrep;		/* current polymarker repr. */

	int gs_txbund;
	struct txrep gs_txrep;
	WC gs_txhght;
	WC gs_txwdth;
	WCPT gs_txupvec;
	WCPT gs_txbsvec;
	TXPATH gs_txpath;
	TXALIN gs_txalin;

	int gs_fabund;
	struct farep gs_farep;
	WCPT gs_fapref;
	WCPT gs_fapwv;
	WCPT gs_faphv;

	int gs_norm;
	BOOL gs_clip;
	ASF gs_asf; /* aspect source flags */

	PICKID gs_pick;
	SEGNAME gs_curseg;

	BOOL gs_wissop;
};

/*
 * workstation description info.
 */
struct wdinfo
{
	WSTYPE wd_type;
	WSCATEG wd_categ;
	SCRTYPE wd_class;
	WSDEVCOORD wd_coord;
	DC		wd_xmax;
	DC		wd_ymax;
	struct dmrep wd_dmrep;
	DEFMODE wd_defmode;
	IRGMODE wd_irgmode;

	struct plfacil wd_plfacil;
	struct pmfacil wd_pmfacil;
	struct txfacil wd_txfacil;
	struct fafacil wd_fafacil;
	struct ptfacil wd_ptfacil;
	struct cofacil wd_cofacil;

	unsigned short wd_ngdp;
	GDP_ID wd_gdp[MAXGDP];

	struct dmseg wd_dmseg;

	unsigned short wd_nloc;
	unsigned short wd_nstk;
	unsigned short wd_nval;
	unsigned short wd_nchc;
	unsigned short wd_npck;
	unsigned short wd_nstr;
};

/*
 *	structure used in workstation state inquiry
 */

struct wstate
{
	WSTYPE ws_type;		/* workstation type */
	BOOL ws_active;		/* workstation state */
	DEFMODE ws_def; 		/* deferral mode */
	IRGMODE ws_irg;		/* implicit regeneration mode */
	BOOL ws_empty;			/* display surface empty */
	BOOL ws_newframe;		/* new frame necessary at update */
	BOOL ws_trpend;		/* wktrans pending */
	unsigned short ws_nplb;	/* number of polyline bundles */
	unsigned short ws_npmb;	/* number of polymarker bundles */
	unsigned short ws_ntxb;	/* number of text bundles */
	unsigned short ws_nfab;	/* number of fill area bundles */
	unsigned short ws_npat;	/* number of patterns */
	unsigned short ws_ncoi;	/* number of colors */
	NDCPT ws_rwll;			/* requested window lower left point */
	NDCPT ws_rwur;			/* requested window upper right point */
	NDCPT ws_cwll;			/* current window lower left point */
	NDCPT ws_cwur;			/* current window upper right point */
	DCPT ws_rvll;			/* requested viewport lower left point */
	DCPT ws_rvur;			/* requested viewport upper right point */
	DCPT ws_cvll;			/* current viewport lower left point */
	DCPT ws_cvur;			/* current viewport upper right point */
};

/*
 *	input device structures
 */

/*
 *	describing "polyline" cursors
 */
struct pl_echo
{
	short curnum;
	NDCPT curpos;
	ASF pl_asf;
	int pl_bnd;
	struct plrep pl_rep;
};


/*
 *	locator device data record
 */
struct i_locdata
{
	BOOL il5_poly;			/* prompt == 5 => use polyline attr if true */

	union
	{
		struct
		{
			BOOL il4_curr;	/* use current polyline attr if true */
			ASF il4_asf;
			int il4_bnd;
			struct plrep il4_plr;
		} iloc_pl;

		struct
		{
			BOOL il5_curr;	/* use current fill area attr if true */
			ASF il5_asf;
			int il5_bnd;
			struct farep il5_far;
		} iloc_fa;

	} iloc_un;
};


/*
 *	stroke device data record
 */
struct i_stkdata
{
	unsigned short istk_bsize;	/* stroke buffer size */
	unsigned short istk_edpos;	/* editing position */
	WCPT istk_intv;	/* x, y interval */
	REAL istk_time;	/* time interval (seconds) */
	union
	{
		struct
		{
			BOOL stk3_curr;	/* true if use current polymarker attr */
			ASF stk3_asf;
			int stk3_bnd;
			struct pmrep stk3_pmr;
		} istk_p3;

		struct
		{
			BOOL stk4_curr;
			ASF stk4_asf;
			int stk4_bnd;
			struct plrep stk4_plr;
		} istk_p4;
	} istk_un;
	struct pl_echo istk_echo;
};


/*
 *	valuator device data record
 */
struct i_valdata
{
	REAL ival_low;
	REAL ival_high;
	int ival_step;
	ASF ival_asf;
	int ival_fabnd;
	struct farep ival_fa;
	int ival_txbnd;
	struct txrep ival_tx;
	TXPATH ival_path;
};


/*
 *	choice device data record
 */
struct i_chcdata
{
	union
	{
		struct
		{
			unsigned short ichc_nalt;
			unsigned long ichc_prmpt;
		} ichc_p2;

		struct
		{
			unsigned short ichc_nstr;
			char ichc_str[32][PROMPTSZ];
		} ichc_p34;

		SEGNAME ichc_p5;
	} ichc_un;

};


/*
 *	pick device data record
 */
struct i_pckdata
{
	struct pl_echo ipck_echo;
	DC ipck_xwin, ipck_ywin;
	REAL ipck_time;
};


/*
 *	string device data record
 */
struct i_strdata
{
	int istr_bsize;					/* buffer size */
	int istr_cpos;						/* initial cursor position */
	ASF istr_tasf;						/* text asf */
	int istr_tbnd;						/* text bundle */
	struct txrep istr_trep;				/* text representation */
	REAL istr_hght;						/* text height */
	REAL istr_ils;						/* inter-line spacing */
	COLOR istr_tbgcol;					/* text background color */
	COLOR istr_pfgcol;					/* prompt foreground color */
	COLOR istr_cursor;					/* cursor color */
};


/*
 *	workstation description input device structures
 */

struct wd_locinfo
{
	unsigned short loc_nprmpt;
	unsigned short loc_prmpt[MAXPRMPT];
	DC  loc_xmin;		/* echo area */
	DC  loc_xmax;
	DC  loc_ymin;
	DC  loc_ymax;
	NDCPT loc_ival;
	struct i_locdata loc_drec;
};

struct wd_stkinfo
{
	unsigned short stk_nprmpt;
	unsigned short stk_prmpt[MAXPRMPT];
	unsigned short stk_bsize;	/* max stroke buffer size */
	DC  stk_xmin;		/* echo area */
	DC  stk_xmax;
	DC  stk_ymin;
	DC  stk_ymax;
	struct i_stkdata stk_drec;
};

struct wd_chcinfo
{
	unsigned short chc_nprmpt;
	unsigned short chc_prmpt[MAXPRMPT];
	DC  chc_xmin;		/* echo area */
	DC  chc_xmax;
	DC  chc_ymin;
	DC  chc_ymax;
	unsigned short chc_nalt;
	struct i_chcdata chc_drec;
};

struct wd_valinfo
{
	unsigned short val_nprmpt;
	unsigned short val_prmpt[MAXPRMPT];
	DC  val_xmin;		/* echo area */
	DC  val_xmax;
	DC  val_ymin;
	DC  val_ymax;
	REAL val_ival;
	struct i_valdata val_drec;
};

struct wd_pckinfo
{
	unsigned short pck_nprmpt;
	unsigned short pck_prmpt[MAXPRMPT];
	DC  pck_xmin;		/* echo area */
	DC  pck_xmax;
	DC  pck_ymin;
	DC  pck_ymax;
	struct i_pckdata pck_drec;
};

struct wd_strinfo
{
	unsigned short str_nprmpt;
	unsigned short str_prmpt[MAXPRMPT];
	unsigned short str_bsize;	/* max string buffer size */
	DC  str_xmin;		/* echo area */
	DC  str_xmax;
	DC  str_ymin;
	DC  str_ymax;
	struct i_strdata str_drec;
};

/*
 *	workstation state input device structures
 */

union inptdata
{
	NDCPT inpt_loc;
	struct
	{
		int stk_npts;
		NDCPT stk_pts[MAXSTROKE];
	} inpt_stk;
	REAL inpt_val;
	struct
	{
		CHOICEVAL chc_val;
		CHOICESTAT chc_stat;
	} inpt_chc;
	struct
	{
		PICKSTAT pck_stat;
		SEGNAME pck_seg;
		PICKID pck_id;
	} inpt_pck;
	char inpt_str[MAXINPSTR];
};

struct ws_inpdev
{
	INPUTMODE wsi_mode;
	BOOL wsi_echo;
	union inptdata wsi_un;
	int wsi_prmpt;
	DC  wsi_xmin;		/* echo area */
	DC  wsi_xmax;
	DC  wsi_ymin;
	DC  wsi_ymax;
	int wsi_data[1];	/* actually variable length */
};
