/*
 * All inquiry functions for GKS state list and description
 */

#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/gkstrans.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire operating state
 */
VOID
q_g_opstate(opstate)
GKSSTATE *opstate ;
{
	*opstate = Gksstate.gs_opstate ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_opstate(0x%lx)\n", *opstate) ;
#endif
}

/*
 * inquire level of GKS
 */
VOID
q_g_lev(errno, level)
GKSERR *errno ;
int *level ;
{
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	*level = GKS_LEV2c ;	/* = level 2c */

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_lev(%d, %d)\n", *errno, *level) ;
#endif
}

/*
 * inquire list of available workstation types
 */
VOID
q_g_wtypes(errno, n, list)
GKSERR *errno ;
int *n ;
WSTYPE list[] ;
{
	int arrysz ;
	int m ;
	int i ;
	extern struct wsdata *wsdata ;

	arrysz = *n ;	/* size of user's buffer */

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
#ifdef LIB1500
	if (*n > 0)
	{
		if (*n == 1)
			list[0] = WST_CX1500 ;
		else
		{
			*n = 2 ;
			list[0] = WST_CX1500 ;
			list[1] = WST_WISS ;
		}
	}
#else
	m = Wsnumws() ;
	for(*n=0, i=0; i<m && *n<arrysz; i++)
		if( wsdata[i].wsd_name != NULL)
		{
			list[*n] = i ;
			*n += 1 ;
		}
#endif
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_wtypes(%d, %d)\n", *errno, *n) ;
#endif
}

/*
 * inquire maximum values
 */
VOID
q_g_wmax(errno, maxop, maxac, maxseg)
GKSERR *errno ;
int *maxop ;	/* max number of open workstations */
int *maxac ;	/* max number of active workstations */
int *maxseg ;	/* max number of workstations associated with segment */
{
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	*maxop = MAXOPWORK ;	/* function of # of file descriptors per process */
	*maxac = MAXACWORK ;
	*maxseg = MAXSEGWORK ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_wmax(%d, %d, %d, %d)\n", *errno, *maxop, *maxac, *maxseg) ;
#endif
}

VOID
q_g_maxnorm(errno, maxnorm)
GKSERR *errno ;
int *maxnorm ;
{
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	*maxnorm = MAXTRANS ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_maxnorm(%d, %d)\n", *errno, *maxnorm) ;
#endif
}

VOID
q_g_opwork(errno, n, opwork)
GKSERR *errno ;
int *n ;
WKID opwork[] ;
{
	WSINFO ws ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	for(ws = WsFirst(), *n = 0; ws != NULL && *n < MAXOPWORK; ws = WsNext())
		{
			opwork[*n] = WsWkid(ws) ;
			*n += 1 ;
		}
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_opwork(%d, %d)\n", *errno, *n) ;
#endif
}

VOID
q_g_acwork(errno, n, acwork)
GKSERR *errno ;
int *n ;
WKID acwork[] ;
{
	WSINFO ws ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	for(ws = WsFirst(), *n = 0; ws != NULL && *n < MAXACWORK; ws = WsNext())
		if(WsActive(ws))
		{
			acwork[*n] = WsWkid(ws) ;
			*n += 1 ;
		}
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_acwork(%d, %d)\n", *errno, *n) ;
#endif
}

/*
 * combination of primitive and individual attribute inquiries
 */
VOID
q_g_attr(errno, state)
GKSERR *errno ;
struct gksstate *state ;
{
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	cpybuf(state, &Gksstate, sizeof(struct gksstate)) ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_attr(%d)\n", *errno) ;
#endif
}

VOID
q_g_curnorm(errno, curnorm)
GKSERR *errno ;
int *curnorm ;
{
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	*curnorm = Gksstate.gs_norm ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_curnorm(%d, %d)\n", *errno, *curnorm) ;
#endif
}

/*
 * inquire list of norm transformations
 */
VOID
q_g_ntrs(errno, list)
GKSERR *errno ;
int list[] ;
{
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	TransSort(list) ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_ntrs(%d)\n", *errno) ;
#endif
}

VOID
q_g_ninf(normtr, errno, winll, winur, viewll, viewur)
int normtr ;
GKSERR *errno ;
WCPT *winll ;
WCPT *winur ;
NDCPT *viewll ;
NDCPT *viewur ;
{
	extern struct normtr Normtr[] ;
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}

	if(normtr < 0 || normtr >= MAXTRANS)
	{
		*errno = 50 ;
		return ;
	}
	*errno = 0 ;

	winll -> wc_x = Normtr[normtr].nt_window.wcbx_ll.wc_x ;
	winll -> wc_y = Normtr[normtr].nt_window.wcbx_ll.wc_y ;
	winur -> wc_x = Normtr[normtr].nt_window.wcbx_ur.wc_x ;
	winur -> wc_y = Normtr[normtr].nt_window.wcbx_ur.wc_y ;
	viewll -> ndc_x = Normtr[normtr].nt_viewprt.ndcbx_ll.ndc_x ;
	viewll -> ndc_y = Normtr[normtr].nt_viewprt.ndcbx_ll.ndc_y ;
	viewur -> ndc_x = Normtr[normtr].nt_viewprt.ndcbx_ur.ndc_x ;
	viewur -> ndc_y = Normtr[normtr].nt_viewprt.ndcbx_ur.ndc_y ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_ninf(%d %d)\n", normtr, *errno) ;
#endif
}

VOID
q_g_clip( errno, clip, xmin, xmax, ymin, ymax )
GKSERR *errno ;
BOOL *clip ;
NDC *xmin, *xmax, *ymin, *ymax;
{
	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
	*errno = 0 ;
	*clip = Gksstate.gs_clip ;
	_getclip(xmin, xmax, ymin, ymax);

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_clip(%d, %d)\n", *errno, *clip) ;
#endif
}

VOID
q_g_curseg(errno, curseg)
GKSERR *errno ;
SEGNAME *curseg ;
{
	if(!Gksckstate(GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}

	*errno = 0 ;
	*curseg = Gksstate.gs_curseg ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_curseg(%d, %d)\n", *errno, *curseg) ;
#endif
}

VOID
q_g_segs(errno, n, seglist)
GKSERR *errno ;
int *n ;
SEGNAME seglist[] ;
{

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}

	SegGetlist(n, seglist) ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("q_g_segs(%d, %d, ...)\n", *errno, *n) ;
#endif
}

static char *SccsId = "@(#)q_gks.c	1.5\t3/14/85" ;
