#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qptrep.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

#define min(x,y) (((x) < (y)) ? (x) : (y))


/*
 * inquire pattern representation
 */
VOID
q_ws_ptr(wkid, index, as_set, errno, ptx, pty, ptarray)
WKID wkid ;
int index ;
BOOL as_set ;
GKSERR *errno ;
int *ptx, *pty ;
COLOR *ptarray ;
{
	static char *fname = "q_ws_ptr" ;
	WSINFO ws ;
	struct msqptr *msg ;
	struct rpqptr *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqptr *)_allocmsg(sizeof(struct msqptr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	ptrmsg(msg, WsGetpid(ws), index, as_set, TRUE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqptr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 2:
			*errno = 79 ;
			_freemsg(reply) ;
			return ;

		case 3:
			*errno = 83 ;
			_freemsg(reply) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*ptx = min( *ptx, reply -> qpt_x) ;
	*pty = min( *pty, reply -> qpt_y) ;
	cpybuf( ptarray, reply -> qpt_color, *ptx * *pty * sizeof(COLOR)) ;
	*errno = 0 ;
	_freemsg(reply) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %f, %d)\n", fname, wkid, index, as_set,
					*errno, *ptx, *pty, *ptarray) ;
#endif
}

/*
 * inquire default pattern representation
 */
VOID
q_wd_ptr(wktype, index, errno, ptx, pty, ptarray)
WSTYPE wktype ;
int index ;
GKSERR *errno ;
int *ptx, *pty ;
COLOR *ptarray ;
{
	static char *fname = "q_wd_ptr" ;
	WSINFO ws ;
	struct msqptr *msg ;
	struct rpqptr *reply ;
	BOOL must_close = FALSE ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
/*
 * see if workstation of specified type is already open.
 */
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return;
		}
/************************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/************************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
************************************************************************/
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		if(must_close)
			close_ws(0xffff) ;
		return ;
	}

	msg = (struct msqptr *)_allocmsg(sizeof(struct msqptr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	ptrmsg(msg, WsGetpid(ws), index, TRUE, FALSE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqptr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 2:
			*errno = 79 ;
			_freemsg(reply) ;
			if(must_close)
				close_ws(0xffff) ;
			return ;

		case 3:
			*errno = 83 ;
			_freemsg(reply) ;
			if(must_close)
				close_ws(0xffff) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*ptx = min( *ptx, reply -> qpt_x) ;
	*pty = min( *pty, reply -> qpt_y) ;
	cpybuf( ptarray, reply -> qpt_color, *ptx * *pty * sizeof(COLOR)) ;
	_freemsg(reply) ;
	if(must_close)
		close_ws(0xffff) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %f, %d)\n", fname, wktype, index,
					*errno, *ptx, *pty, *ptarray) ;
#endif
}

static
ptrmsg(msg, pid, index, as_set, fromstate)
struct msqptr *msg ;
PID pid ;
int index ;
BOOL as_set ;
BOOL fromstate ;
{
	msg -> mhdr.msg_id = MSQPTR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqptr) - sizeof(MSGHDR);
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> qpt_indx = index ;
	msg -> qpt_set = as_set ;
	msg -> qpt_state = fromstate ;
}

static char *SccsId = "@(#)q_ptrep.c	1.8\t3/12/85" ;
