/*
 *
 *	Revision History:
 *
 *		11 sep 86	wrf		sw# 102
 *			will now return category of metafile workstations
 */
#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate;

/*
 * inquire workstation category
 */
VOID q_wd_cat( wktype, errno, categ )
	WSTYPE wktype;
	GKSERR *errno;
	WSCATEG *categ;
	{
	extern short Wscnt;
	extern struct wsdata *wsdata;
	static char *fname = "q_wd_cat";

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
		*errno = 8;
	else if (wktype < 0)
		*errno = 22;
	else if (wktype >= Wscnt)
		*errno = 23;
	else
		{
		*errno = 0;
		*categ = wsdata[wktype].wsd_categ;
		}
	
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d)\n", fname, wktype, *errno, *categ);
#endif

	}
