/*
 *
 *	Revision History:
 *
 *		18 sep 86	wrf		sw# 86
 *			original implementation
 */
#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate;

/*
 *	inquire number of segment priorities supported
 *
 *	this routine is a kludge - it assumes that all workstations
 *	of type OUTPUT or OUTIN support an "infinite" number of
 *	segment priorities.  The correct way to do this would to
 *	be to add a field to one of the structs in one of the
 *	inquiry messages which is sent to a workstation, so that
 *	the workstation could report this information.
 */
VOID q_wd_sgpri( wktype, errno, sgpri )
	WSTYPE wktype;
	GKSERR *errno;
	int *sgpri;
	{
	extern short Wscnt;
	extern struct wsdata *wsdata;
	static char *fname = "q_wd_sgpri";
	WSCATEG categ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
		*errno = 8;
	else if (wktype < 0)
		*errno = 22;
	else if (wktype >= Wscnt)
		*errno = 23;
	else if ((categ = wsdata[wktype].wsd_categ) != WSC_OUTPUT
		&& categ != WSC_OUTIN)
		*errno = 39;
	else
		{
		*errno = 0;
		*sgpri = 0;
		}
	
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d)\n", fname, wktype, *errno, *sgpri);
#endif

	}
