#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwsseg.h>

#include <gks/trace.h>

#include "wsinfo.h"

#define min(x,y) ((x) < (y) ? (x) : (y))
extern struct gksstate Gksstate ;

/*
 * inquire segments associated with workstation
 */
VOID
q_ws_segs(wkid, errno, n, segs)
WKID wkid ;
GKSERR *errno ;
int *n ;
SEGNAME segs[] ;
{
	int i ;
	WSINFO ws ;
	struct msqwsseg * msg ;
	struct rpqwsseg *reply ;

	*errno = 0 ;
	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}

	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		WissGetsegs( n, segs) ;
		return ;
	}
	msg = (struct msqwsseg *)_allocmsg(sizeof(struct msqwsseg)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	wssegmsg(msg, WsGetpid(ws)) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqwsseg *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}

	*n = min(*n, reply -> qseg_nsegs) ;
	for(i=0; i<*n; i++)
		segs[i] = reply -> qseg_segs[i] ;
}

static
wssegmsg(msg, pid)
struct msqwsseg *msg ;
PID pid ;
{
	msg -> mhdr.msg_id = MSQWSSEG ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqwsseg) - sizeof(MSGHDR);
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
}

static char *SccsId = "@(#)q_ws_segs.c	1.7\t3/12/85" ;
