/*
 *	WISS operations
 *
 *	WissSegIs:	check WISS segment existence
 *	WissGetsegs:	return number and list of WISS segments
 *	WissFmsg:	address of first message in segment
 *	WissNmsg:	address of next message in segment
 *	wissmsg:	send a message to WISS
 *
 */

#include <gks/gks_types.h>
#include <gks/gkstrans.h>
#include <gks/message.h>

#include "seg.h"



/*	check WISS segment existence
 *	returns
 *		0 if successful
 *		1 if id not found
 *		3 if invalid id
 *		4 if id not in WISS
 */
int WissSegIs(id)
SEGNAME id;
{
	SEGMENT *s, *findseg();

	if (bad_id(id))
		return (3);
	if ((s = findseg(id)) == NULL)
		return (1);
	if (!s->sh.in_wiss)
		return (4);
	return (0);
}

WissGetsegs( n, segs)
int *n;
SEGNAME segs[];
{
	int m = *n;
	SEGMENT *s;
	SEGMENT *prilist;
	SEGMENT *getprilst();

	prilist = getprilst();

	for(s = prilist, *n = 0; s != NULL && m > 0; s = s->sh.nextpri)
		if (s->sh.in_wiss)
		{
			segs[(*n)++] = s->sh.seg_name;
			m--;
		}
}

static struct msglink *curmsg = NULL;

MSGHDR *
WissFmsg( id)
SEGNAME id;
/*
 *	return the first message in the WISS segment.
 */
{
	SEGMENT *s, *findseg();

	s = findseg(id);
	if (s == NULL)
		return( NULL);
	curmsg = s->sh.firstprim;
	if (curmsg == NULL)
		return( NULL);
	else
		return( curmsg->primitive);
}

MSGHDR *
WissNmsg()
/*
 *	return the next message in the WISS segment.
 *	note that Firstprim should be called prior to this so
 *	that curmsg gets initialized.
 */
{
	curmsg = curmsg->next;
	if (curmsg == NULL)
		return( NULL);
	else
		return( curmsg->primitive);
}

BOOL
wissmsg( msg)
MSGHDR *msg;
{
	return (addlink( msg));
}

/*
 *	Low Level Segment Operations:
 *
 *		addlink:	add a message to a WISS message list
 *		addwseg:	add a WISS message list
 *		delwseg:	delete a WISS message list
 *		clswseg:	terminate a WISS message list
 */

static SEGMENT *opwseg = NULL;	/* currently open WISS segment */

addlink( msg)
MSGHDR *msg;
{
	if (opwseg == NULL)
		return( FALSE);

	opwseg->sh.lastprim->primitive = msg;
	if ((opwseg->sh.lastprim->next =
		(struct msglink *)malloc( sizeof( struct msglink))) == NULL)
	{
		Gksout( "addlink: can't allocate next message link.\n");
		return (FALSE);
	}
	opwseg->sh.lastprim = opwseg->sh.lastprim->next;
	opwseg->sh.lastprim->primitive = NULL;
	opwseg->sh.lastprim->next = NULL;

	return (TRUE);
}

addwseg( s)
SEGMENT *s;
{
	if ((s->sh.lastprim =
		(struct msglink *)malloc( sizeof( struct msglink))) == NULL)
	{
		Gksout( "addwseg: can't allocate first message link.\n");
		return (FALSE);
	}
	s->sh.lastprim->primitive = NULL;
	s->sh.lastprim->next = NULL;
	s->sh.firstprim = s->sh.lastprim;
	s->sh.in_wiss = TRUE;
	opwseg = s;
	return (TRUE);
}

delwseg( s)
register SEGMENT *s;
{
	register struct msglink *flink, *tlink;

	for (flink = s->sh.firstprim; flink != s->sh.lastprim; flink = tlink)
	{
		tlink = flink->next;
		_freemsg( flink->primitive);
		free( flink);
	}
	free( flink);

	s->sh.firstprim = s->sh.lastprim = NULL;
	s->sh.in_wiss = FALSE;
}

clswseg( s)
register SEGMENT *s;
{
	opwseg = NULL;
}

static char *SccsId = "@(#)wiss.c	1.1\t3/4/85";
