~& {~_*}
~& { ~'	~& }
~& { Program name		  : SEMA4~#I~& }
~& { ~'	~& }
~& { Author~#I  : DVH ~#I~& }
~& { ~'	~& }
~& { Date of creation	  : October 12, 1983		~& }
~& { ~#I  : adapted for MSDOS 2-28-84 (BRK)~ }
~& { ~#I  :  for IBM/MICROSOFT PASCAL	~& }
 ~% { ~'	~& }
~& { Library used		  : DRIVEC2.OBJ 		~& }
~& { ~'	~& }
~& { Description		  : This program is designed to~' }
~& { ~#I~$ illustrate the use of the	~& }
~& { ~#I~$ "semaphores" on the CORVUS drive  }
~& { ~#I~$ This program can :		~& }
~& { ~#I~' 1. Lock (set) and report the~ }
~& { ~$	  previous state of a	~& }
~& { ~$	  specific semaphore.	~& }
~& { ~#I~' 2. Unlock (clear) and report~ }
~& { ~$	  the previous state of a~% }
~& { ~$	  specific semaphore.	~& }
~& { ~#I~' 3. Clear the semaphore table~ }
~& { ~$	  of all semaphores set.~& }
~& { ~#I~$ The major use of this program is  }
~& { ~#I~$ as an example of the protocol~% }
~& { ~#I~$ of the commands needed to send to }
~& { ~#I~$ the firmware to control the~' }
~& { 			~$ semaphores. 		~& }
~& { ~#I~$ Because this program gets the~% }
~& { ~#I~$ semaphore key from the keyboard,  }
~& { ~#I~$ it can only lock or unlock	~& }
~& { ~#I~$ semaphores with alpha-numeric~% }
~& { ~#I~$ names.  However, the eight byte~ }
~& { ~#I~$ semaphore name can consist of any }
~& { ~#I~$ combination of eight bit chars.~ }
~& { ~'	~& }
~& { Version 		  : 1.0 Original version	~& }
~& { ~#I~$ 1.1 9-5-84 Norman O. Doyle	  ~$ }
~& { ~$	changed to use assembly~' }
~& { ~$	language functions - SemLock, }
~& { ~$	SemUnLock, and SemStatus~& }
~& { ~'	~& }
~& {~_*}

~& program SEMA4 (INPUT,OUTPUT);

~& const

	 version = '[1.1]';

	 beep = 7;
	 esc  = 27;

	 longstrmax = 536;

	 SemNotSet = 0;~' { the prior state was unlocked  }
	 SemWasSet = 128;~% { the prior state of this semaphore was locked }
	 SemFull   = 253;~% { semaphore table is full~.(32 active sema4's) }
	 DiskErr~ = 254;
	 { *Note : negative function return values indicate error conditions }

	 normal = 0;

~& type

	 semkeys = packed array [0..7] of char;
	 semkeylist = packed array [0..31] of semkeys;

~& var

	 rc  : integer; 	{ return code }
	 CRTinfile:~$ FILE OF CHAR;
	 sema4s:  semkeylist;

	 { DRIVEC2.OBJ }
	 function INITIO : integer; extern;

~& function SEMLOCK (var key : lstring) : integer; extern;
  ~$ function SEMUNLOCK (var key : lstring) : integer; extern;
~& function SEMSTATUS (var keys: semkeylist):integer;extern;
~& {~a-}
~& { routinename		:CRTIOinit~$	}
~& { ~'		}
~& { description		:Initializes the console input device.	}
~& {~V-~+-}

~& procedure CRTIOinit;

~& begin~ { CRTIOinit }

~& assign(CRTinfile,'USER');
~& reset(CRTinfile);

~& end;~$ { CRTIOinit }


~& {~_-}
~& { function name		  : INKEY~#I~& }
~& { Author~#I  : DO~$	~& }
~& { Input~#I  : keyboard char.		~& }
~& { Output			  : keyboard char. in upper case~& }
~& { Description		  : gets char. without echo	~& }
~& {~5-~J-}

~& function	INKEY: char;

~& var
	Key:  char;

~& begin~ { INKEY }

~& Key := ' ';
~& repeat
	GET(CRTinfile);
~& until (CRTinfile^ = CHR(0));	{ wait for "no char." condition }

 ~% repeat
	GET(CRTinfile);
~& until (CRTinfile^ <> CHR(0));

~& Key := CRTinfile^;

~& if (Key = chr(13)) then		{	 CR => SP		}
	Key := ' '
~& else
	if (Key = CHR(27)) then 	{	ESC => '!'~. }
	  Key := '!'
	else
	  if (Key IN ['a'..'z']) then~ { lowercase => uppercase~( }
	~$ Key := CHR(ORD(Key) - 32);
~& INKEY := Key;

~& end;~  { INKEY }

~& {~_-}
~& { Routine name		  : PRINT_MENU~#I  ~$ }
~& { Author~#I  : DVH ~#I~& }
~& { Input~#I  : none~#I~& }
~& { Output~#I  : none~#I~& }
~& { Description		  : Prints the main menu	~& }
~& {~_-}

~& procedure PRINT_MENU;

~& begin { PRINT_MENU }

~& WRITELN (output);
~& WRITELN (output,'Corvus Semaphore Utility Version ',version);
~& WRITELN (output,'Main Menu');
~& WRITELN (output,'~L-');
 ~% WRITELN (output);
~& WRITELN (output,'~ ? - Print this menu');
~& WRITELN (output);
~& WRITELN (output,'~ L - Lock');
~& WRITELN (output);
~& WRITELN (output,'~ U - Unlock');
~& WRITELN (output);
~& WRITELN (output,'~ S - Status');
~& WRITELN (output);
~& WRITELN (output,'~ H - Help');
~& WRITELN (output);
~& WRITELN (output,'   E - Exit');
~& WRITELN (output);
~& WRITELN (output,'~L-');

~& end; { PRINT_MENU }

~& {~_-}
~& { Routine name		  : DISPATCH~#I~$   }
~& { Author~#I  : DVH ~#I~& }
~& { Input~#I  : none~#I~& }
~& { Output~#I  : none~#I~& }
~& { Description		  : Dispatches to appropriate routines}
~& {~_-}

~$   procedure DISPATCH;

~& var
	 action : char;
	 xit	: boolean;
	 name	: lstring(80);
	 res	: integer;

~& {~&-~Y-}
~& { Routine name		  : LOCK~#I~& }
~& { Author~#I  : DVH 			~& }
~& { Input~#I  : none~#I~& }
~& { Output~#I  : none~#I~& }
~& { Description		  : Gets the semaphore key to be~& }
~& { ~#I~$ locked and call SEMLOCK.	~& }
~& {~V-~)-}

~& procedure LOCK;

~& begin { LOCK }

~& WRITELN (output);
~& WRITE (output,'Lock which semaphore (1-8 ASCII chars.) ? ');
~& READLN (name);
~& WRITELN (output);
~& if (name[1] <> CHR(esc)) then begin
	 res := SEMLOCK (name);
	 case res of
	~ SemNotSet : WRITELN (output,'Semaphore ', name:8,
~#I ' was previously UNLOCKED, and is now   LOCKED');
	~ SemWasSet : WRITELN (output,'Semaphore ', name:8,
~#I ' was previously~ LOCKED, and is now~ LOCKED');
	~ SemFull~ : WRITELN (output,' ERROR table full~!', CHR(beep));
	~ DiskErr~ : WRITELN (output,' Fatal DISK ERROR~!', CHR(beep));
	~ otherwise WRITELN (output,' Unknown ERROR~!', CHR(beep));
	~ end;
	 end;
~& end; { LOCK }

~& {~+-~T-}
~& { Routine name		  : STATUS~#I~& }
~& { Author~#I  : N. Doyle~#I~& }
~& { Input~#I  : none~#I~& }
~& { Output~#I  : none~#I~& }
~& { Description		  : Gets the status of all	~& }
~& { ~#I~$ semaphors.~#I~& }
~& {~_-}

  ~$ procedure STATUS;

~& var i,j	: INTEGER;

~& begin { STATUS }

~& WRITELN (output);
~& WRITELN (output,'Getting Semaphore status');
~& res := SEMSTATUS (sema4s);
~& if res = 0 THEN BEGIN
	 FOR i := 1 TO 16 DO BEGIN
	~% write  ( output, i, '.  ');
	~% FOR j:=0 to 7 DO write(output, sema4s[i-1,j]);
	~% writeln(output);
	~% END;
	 WRITELN (output);
	 WRITE (output,'Press RETURN to continue ');
	 READLN (name);
	 WRITELN (output);
	 FOR i := 17 TO 32 DO BEGIN
	 ~$ write  ( output, i, '.  ');
	~% FOR j:=0 to 7 DO write(output, sema4s[i-1,j]);
	~% writeln(output);
	~% END;
	 END
~' ELSE BEGIN
	 WRITELN(output, ' Error reading semaphore table: ', res );
	 END;
~& end; { STATUS }

~& {~%-~Z-}
~& { Routine name		  : UNLOCK~#I~& }
~& { Author~#I  : DVH ~#I~& }
~& { Input~#I  : none~#I~& }
~& { Output~#I  : none~#I~& }
~& { Description		  : Gets the key to be unlocked and~ }
~& { ~#I~$ calls SEMUNLOCK.		~& }
~& {~Z-~%-}

~& procedure UNLOCK;

~& begin { UNLOCK }

~& WRITELN (output);
~& WRITE (output,'Unlock which semaphore (1-8 ASCII chars.) ? ');
~& READLN (name);
~& WRITELN (output);
~& if (name[1] <> CHR(esc)) then begin
	 res := SEMUNLOCK (name);
	 case res of
	~$ SemNotSet : WRITELN (output,'Semaphore ', name:8,
~#I  ' was previously UNLOCKED, and is now UNLOCKED');
	~$ SemWasSet : WRITELN (output,'Semaphore ', name:8,
~#I  ' was previously~ LOCKED, and is now UNLOCKED');
	~$ SemFull~ : WRITELN (output,' ERROR table full~!', CHR(beep));
	~$ DiskErr~ : WRITELN (output,' Fatal DISK ERROR~!', CHR(beep));
	~$ otherwise WRITELN (output,' Unknown ERROR~!', CHR(beep));
	~$ end; { case }
	 end;
~& end; { UNLOCK }

~& {~_-}
~& { Routine name		  : HELP~#I~& }
~& { Author~#I  : DVH ~#I~& }
~& { Input~#I  : none~#I~& }
~& { Output~#I  : none~#I~& }
~& { Description		  : Prints the help message	~& }
~& {~_-}

~& procedure HELP;

~& begin { HELP }

~& WRITELN (output);
~& WRITELN (output,' This program is designed to serve as an');
~& WRITELN (output,' example of how to access the semaphores');
~& WRITELN (output,' supported by the CORVUS drive.  These');
 ~% WRITELN (output,' semaphores (software switches) are');
~& WRITELN (output,' maintained by the CORVUS controller and');
~& WRITELN (output,' saved on a hidden area of the disc.  The CORVUS');
~& WRITELN (output,' drive firmware supports 32 binary semaphores');
~& WRITELN (output,' - each associated with a user selected');
~& WRITELN (output,' 8 byte name (key).  This feature was');
~& WRITELN (output,' implemented to provide a way for application');
~& WRITELN (output,' programs to "safely" control simultaneous');
~& WRITELN (output,' file access by two or more users on the');
~& WRITELN (output,' CORVUS CONSTELLATION.  However, you may');
~& WRITELN (output,' find other uses for them.  For instance,');
~& WRITELN (output,' they could also be used for password');
~& WRITELN (output,' access control of various user programs.');
~ ~ WRITELN (output);
~& WRITELN (output,' Press any key to continue. ');
~& action := INKEY;
~& WRITELN (output);
 ~% WRITELN (output,' ~.- WARNING ~.-');
~& WRITELN (output,' Use this program with caution on a system');
~& WRITELN (output,' that is already using semaphores.  If used');
~& WRITELN (output,' indiscriminately, you may set or clear');
~& WRITELN (output,' semaphores in use by currently running');
~& WRITELN (output,' programs.  This would confuse their file');
~& WRITELN (output,' or record protection scheme and could');
~& WRITELN (output,' lead to either loss of data or system');
~& WRITELN (output,' lockup (or both).');
~& WRITELN (output);
~& WRITELN (output);
~ ~ end; { HELP }

~& begin { DISPATCH }

~& FILLC (ADR name, 8, ' ');

~& repeat

	WRITELN (output);
	WRITE	(output,'Please select an option (?,L,U,S,H,E) : ');

	xit := false;
	repeat
	  action := INKEY;
	  if (action in ['L','U','S','H','E','?']) then
	~$ xit := true
	  else
	~$ WRITE (output,CHR(beep));
	until xit or
	~& (action in ['L','U','S','H','E','?']);
	WRITELN (output,action);

	case action of
	  'L': LOCK;
	  'U': UNLOCK;
	  'S': STATUS;
	  'H': HELP;
	  '?': PRINT_MENU;
	  'E': {exit};
	end; {case}

~& until (action = 'E');

~& end; { DISPATCH }

~& {~,-~S-}
~& { ~'	~& }
~& { MAIN BODY~&	~& }
~& { ~'	~ ~ }
~& {~_-}

~& begin { MAIN BODY }

~& rc := INITIO{*};
~& if (rc = 0 ) then begin
	WRITELN (output);
	WRITELN (output,'(C)Copyright 1983, 1984  Corvus Systems, Inc.');
	WRITELN (output,'All Rights Reserved ');
	CRTIOinit{*};
	PRINT_MENU{*};
	DISPATCH{*};
	end
~& else
	WRITELN (output,CHR(beep), 'Driver not found');

~& end. { MAIN BODY }
