;
;
IF1
	%OUT	<Including SINIT2.INC>
ENDIF
;
;
;************************************************************************
;*									*
;* Subroutine:	FND_PIPE_VOL						*
;*									*
;* Function:	See if a PIPE volume exists.  If it does return with	*
;*		the carry flag set and the starting and ending sectors	*
;*		of the volume.						*
;*									*
;* Input:	NODE1 = Node (or drive) to look for pipe volume on.	*
;*									*
;* Output:	Carry flag - set means volume not found, clear=found	*
;*		BX - Starting sector of volume (high word)		*
;*		AX - Starting sector of volume (low word)		*
;*		DX - Ending sector of volume (high word)		*
;*		CX - Ending sector of volume (low word) 		*
;*									*
;* Updates:								*
;*									*
;* Destroys:								*
;*									*
;************************************************************************

FND_PIPE_VOL	PROC	NEAR
	MOV	AL,BYTE PTR NODE1	;Get node number to save block 8 from
	CALL	SAVBLK8 		;Save block 8
	MOV	SI,OFFSET D1DATA	;Point to saved block 8
	MOV	CX,WORD PTR [SI+DVblks] ;Size of the VOLUME TABLE
	XCHG	CH,CL			;Switch the bytes
	MOV	DRVVOLTBL_SIZ,CX
	MOV	DX,WORD PTR [SI+DVaddr] ;Point to the VOLUME TABLE
	MOV	CL,4
	ROL	DL,CL
	INC	DL
	MOV	CX,WORD PTR [SI+DVaddr+2] ;Point to the VOLUME TABLE
	XCHG	CH,CL			;Switch the bytes
;					;Load the sector number (d, lsb, msb)
	MOV	d2,DL			;Save d
	MOV	msb_lsb2,CX		;Save lsb, msb
	MOV	FRSTBLK,1		;Skip the 1st entry in the first block
FP_RD_BLK:
	MOV	BX,OFFSET RSECTOR	;Load the sector number (d, lsb, msb)
	MOV	BYTE PTR [BX],DL	;Load d
	MOV	WORD PTR [BX+1],CX	;Load lsb, msb
;
	MOV	DX,512			;number of bytes to receive
	MOV	SI,OFFSET READCMD	;address of data to send to the drive
	MOV	DI,OFFSET D2DATA	;address of buffer for data from drive1
	MOV	AH,1			;cmd = Xmit/Recv data to network srvr
	MOV	AL,BYTE PTR NODE1	;get the node number
	MOV	CX,4			;number of bytes to transmit
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	PUSH	CS			;fake a "FAR" call
	CALL	CRVIO			;execute the command
	OR	AL,AL			;see if command executed properly
	JZ	FP_GOT_VOLTBL
	JMP	FP_ERROR
FP_GOT_VOLTBL:
	XOR	BX,BX
	MOV	SI,OFFSET D2DATA
	CMP	FRSTBLK,0		;Is this the 1st entry of the 1st block
	JZ	FP_NO_SKIP		;No, so don't skip it
	PUSH	BX
FP_NXT_ENTRY:
	POP	BX
	ADD	BX,32			;1st 32 bytes of 1st block are reserved
FP_NO_SKIP:
	CMP	BX,511			;Have we examined all 16 entries in this
	JLE	FP_CHK_FOR_END		;...block.  If have then get next block
	INC	msb_lsb2
	JNZ	FP_NO_CARRY
	INC	d2
FP_NO_CARRY:
	MOV	DL,d2
	MOV	CX,msb_lsb2
	MOV	FRSTBLK,0
	DEC	DRVVOLTBL_SIZ		;See if any blocks left to check
	JZ	NOT_FND
	JMP	FP_RD_BLK
;
;  See if the entry is unused or if it is the end of the table.  If it
;  is the end of the table the entry will contain 32 bytes of 0FFH.  An
;  unused entry contains 32 bytes of 00H.
;
FP_CHK_FOR_END:
	MOV	CX,16			;32 byte per entry
	PUSH	BX
FP_CHKWRD:
	CMP	WORD PTR [SI+BX],0FFFFH
	JNZ	FP_TRY00
	ADD	BX,2			;Point to the next word
	LOOP	FP_CHKWRD
	JMP	FP_ENDTBL
FP_TRY00:
	POP	BX
	PUSH	BX
FP_LOOK00:
	MOV	CX,16
	CMP	WORD PTR [SI+BX],0
	JNZ	CHK_NAME		;See if the server name = "PIPES"
	ADD	BX,2			;Point to the next word
	LOOP	FP_LOOK00
	JMP	FP_NXT_ENTRY
FP_ENDTBL:
	POP	BX
	JMP	NOT_FND
CHK_NAME:
	MOV	DI,OFFSET D1DATA
	PUSH	SI			;Save start of VOL table for this block
	ADD	SI,BX			;Subroutine NAMDECRYPT needs to have SI
	CALL	NAMDECRYPT		; point to the encrypted name.
	MOV	CX,10
	MOV	SI,OFFSET D1DATA
	MOV	DI,OFFSET PIPENAM
	CLD
	REPZ	CMPSB
	POP	SI			;Restore SI
	JNZ	FP_NXT_ENTRY
	POP	BX			;Clean up the stack
	ADD	SI,BX			;Point to VOL table entry
	MOV	BX,WORD PTR [SI+Strtblk]
	MOV	AX,WORD PTR [SI+Strtblk+2]
	XCHG	BH,BL			   ;Convert from DWORD format to 2 WORDS
	XCHG	AH,AL
	MOV	CL,4
	ROL	BL,CL
	INC	BL
	XOR	BH,BH
	MOV	DX,WORD PTR [SI+Endblk]
	MOV	CX,WORD PTR [SI+Endblk+2]
	XCHG	DH,DL			   ;Convert from DWORD format to 2 WORDS
	XCHG	CH,CL
	PUSH	CX
	MOV	CL,4
	ROL	DL,CL
	POP	CX
	INC	DL
	XOR	DH,DH
;
;  NOTE - the SAHF instruction will save the AH register to flags where
;	  (SF) = bit 7
;	  (ZF) = bit 6
;	  (AF) = bit 4
;	  (PF) = bit 2
;	  (CF) = bit 0
;	  Bits 1,3, and 5 have no meaning.
;
	PUSH	AX
	MOV	AH,00000000B			;Clear the sign flag and the
	SAHF					; carry flag.
	POP	AX
	JMP	PIPE_END
NOT_FND:
	MOV	AH,00000001B			;Clear the sign flag and set
	SAHF					; set the carry flag
PIPE_END:
	RET
;
;  An error occured
;
FP_ERROR:
	MOV	AH,10000000B			;Set the sign flag to indicate
	SAHF					; an error occured, also clear
	JMP	PIPE_END			; the carry flag
;
;
;************************************************************************
;*									*
;* Subroutines: DSABL_PrtSc						*
;*		ENABL_PrtSc						*
;*									*
;* Function:	These routines will enable and disable the print	*
;*		screen function.					*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	The print screen status byte located in the BIOS	*
;*		data segment @ 50:0.  On = 0, off = 1			*
;*									*
;* Destroys:	Nothing 						*
;*									*
;************************************************************************

DSABL_PrtSc	PROC	NEAR
	MOV	Prt_Sc,1
	JMP	Prt_Screen
ENABL_PrtSc:
	MOV	Prt_Sc,0
Prt_Screen:
	PUSH	AX
	PUSH	ES
	MOV	AX,ROMDATA			;Set ES = ROM BIOS data segment
	MOV	ES,AX
	MOV	AL,Prt_Sc			;Get the desired function
	MOV	BYTE PTR ES:[PrtStat],AL	;Enable or disable as requested
	POP	ES				;Restore the original ES
	POP	AX
	RET
DSABL_PrtSc	ENDP
;
PAGE
;**************************************************************************
;
; ENCRYPTION ROUTINES
;
;**************************************************************************
;**************************************************************************
;
;  NAMDECRYPT, PSWENCRYPT
;
;**************************************************************************

%MASK	DB	0				;
MASKMOD DB	9				;

NAMBASE DB	31,146,135,26,99,0,7,78,125,98	;
NAMEINC DB	 2,  1,  1, 1, 1,1,2, 1,  1, 1	;

PSWBASE DB	25,36,122,150,43,18,96,112	;
PSWINC	DB	 2, 1, -1,  1, 2, 1,-1,  1	;

;**************************************************************************
;**************************************************************************

NAMDECRYPT PROC NEAR

	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;

	XOR	BX,BX			;
	MOV	CX,10			;
	MOV	BYTE PTR %MASK,0	;

NAMDEC1:MOV	AL,BYTE PTR [SI+BX]	;get characater to decrypt,
	SUB	AL,BYTE PTR %MASK	;.subtract off mask and base
	SUB	AL,BYTE PTR NAMBASE[BX] ;

	CBW				;
	IDIV	BYTE PTR NAMEINC[BX]	;divide by increment
	MOV	DL,AL			;

	ADD	DL,20H			;add in ASCII offset and store
	MOV	BYTE PTR [DI+BX],DL	;

	CMP	BX,0			;
	JNE	SHORT NAMDEC2		;

	CBW				;
	IDIV	BYTE PTR MASKMOD	;make a new mask value if first
	MOV	BYTE PTR %MASK,AH	;.time through

NAMDEC2:INC	BX			;
	LOOP	SHORT NAMDEC1		;do all characters

	POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	AX			;
	RET				;

NAMDECRYPT ENDP

;**************************************************************************

PSWENCRYPT PROC NEAR

	PUSH	CX			;
	PUSH	BX			;
	PUSH	AX			;

	XOR	BX,BX			;
	MOV	CX,8			;
	MOV	BYTE PTR %MASK,0	;
					;
PSWENC1:MOV	AL,BYTE PTR [SI+BX]	;get character and subtract ASCII
	SUB	AL,20H			;.offset
					;
	IMUL	BYTE PTR PSWINC[BX]	;multiply by increment
					;
	ADD	AL,BYTE PTR PSWBASE[BX] ;add in base and mask value
	ADD	AL,BYTE PTR %MASK	;
					;
	MOV	BYTE PTR [DI+BX],AL	;store
					;
	CMP	BX,0			;
	JNE	SHORT PSWENC2		;
					;
	MOV	AL,BYTE PTR [SI+BX]	;calculate new mask value if first
	SUB	AL,20H			;.time through
	CBW				;
	IDIV	BYTE PTR MASKMOD	;
	MOV	BYTE PTR %MASK,AH	;
					;
PSWENC2:INC	BX			;
	LOOP	SHORT PSWENC1		;do all characters

	POP	AX			;
	POP	BX			;
	POP	CX			;
	RET				;

PSWENCRYPT ENDP
;
;
;
;
;************************************************************************
;*									*
;* procedure:	CMPSIZ							*
;*									*
;* input:								*
;*									*
;* output:								*
;*									*
;* updates:								*
;*									*
;* destroys:	Nothing 						*
;*									*
;************************************************************************
;
CMPSIZ	PROC	NEAR
;
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
;
	MOV	CX,WORD PTR %NUMOD
	MOV	BX,OFFSET %SRVTBL	;first get the size of node1
	MOV	AL,BYTE PTR NODE1
ND1AGN: CMP	AL,BYTE PTR [BX+NODENUM]
	JZ	FNDND2
	ADD	BX,ENTRYSZ
	LOOP	ND1AGN
	JMP	CNTFND
;
FNDND2: MOV	DL,BYTE PTR [BX+SRVRSIZ]
	MOV	CX,WORD PTR [BX+SRVRSIZ+1]
	PUSH	CX
;
	MOV	CX,WORD PTR %NUMOD
	MOV	SI,OFFSET %SRVTBL	;first get the size of node1
	MOV	AL,BYTE PTR NODE2
ND2AGN: CMP	AL,BYTE PTR [SI+NODENUM]
	JZ	FDBOTH
	ADD	SI,ENTRYSZ
	LOOP	ND2AGN
	POP	CX			;clean up the stack
	JMP	CNTFND			;couldn't find the node so return
;
FDBOTH: POP	CX
	MOV	BL,BYTE PTR[SI+SRVRSIZ]
	MOV	AX,WORD PTR[SI+SRVRSIZ+1]
	CMP	DL,BL			;if the sizes are not the
	JNZ	SHORT CMPSIZ_ERR	;... same then the SHADOW
	CMP	CX,AX			;... setup cannot be done.
	JZ	SHORT CMPSIZ_END	;zero flag set if sizes are equal
CMPSIZ_ERR:
	MOV	DX,ERRLINE
	CALL	POSCUR
	MOV	DX,OFFSET SIZERR	;display a message to the user
	CALL	PRNTCLR 		;... indicating that the drives
;					;... are of different sizes
	MOV	DX,OFFSET CONT
	CALL	PRNTCLR 		;
	CALL	GETKYBW 		;wait for keyboard input to continue
CNTFND: STC				;couldn't find the node so return
	JMP	CLNUP			;error return
CMPSIZ_END:
	CLC
CLNUP:	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
CMPSIZ	ENDP

;**************************************************************************

SHOW_OD_STATUS	PROC	NEAR

	MOV	DX,ODLPOS
	MOV	CX,1			;initialize counter
	MOV	SI,OFFSET %SRVTBL
GETNXT: CALL	POSCUR
	PUSH	DX			;save the cursor positioning
	PUSH	CX			;save the counter
	MOV	CX,%ODLLEN
	DEC	CX			;Skip the color byte
	MOV	DI,OFFSET ODLINE
	INC	DI			;Skip the color byte
	MOV	AL,BLANK
	CLD
	REP	STOSB			;init the line to blanks
;
	XOR	AH,AH
	MOV	AL,BYTE PTR [SI+NODENUM];get the node number
	MOV	DX,AX			;save the node number
	CALL	CNVRT_SRVR		;convert decimal to ascii (0-64)
	MOV	DI,OFFSET ODLINE
	ADD	DI,2
	MOV	[DI],AH 		;get tens digit
	INC	DI
	MOV	[DI],AL 		;get ones digit
	ADD	DI,3
	MOV	CX,SRVRSIZ - SRVRNAM
	PUSH	SI			;save the pointer to %SRVTBL
	ADD	SI,SRVRNAM		;now point to the name in the table
	CLD
	REP	MOVSB			;get the name into the output string
	INC	DI			;point to next field on the screen
	CALL	GET_STATUS		;now get the actual status
	CMP	DL,DT_NORMAL		;is the drive a "NORMAL" drive
	JNE	TRY_MSTR		;no -- then try "MASTER"
	MOV	SI,OFFSET NORML 	;yes -- so load normal message
	MOV	CX,6
	JMP	LOADIT
TRY_MSTR:
	CMP	DL,DT_MASTER		;is the drive a "MASTER" drive
	JNE	TRY_SLAVE		;no -- then try "SLAVE"
	MOV	AL,DH			;copy mate number for conversion
	XOR	AH,AH			;zero the high byte
	CALL	CNVRT_SRVR		;convert mate number to ASCII
	MOV	SI,OFFSET MSTR		;yes -- so load master message
	MOV	BYTE PTR [SI+15],AH	;put the mate number in the string
	MOV	BYTE PTR [SI+16],AL
	MOV	CX,17
	JMP	LOADIT
TRY_SLAVE:
	CMP	DL,DT_SLAVE		;is the drive a "SLAVE" drive
	JNE	TRY_SHPROM		;no -- see if drive has the shadow prom
	MOV	AL,DH			;copy mate number for conversion
	XOR	AH,AH			;zero the high byte
	CALL	CNVRT_SRVR		;convert mate number to ASCII
	MOV	SI,OFFSET SLV		;yes -- so load slave message
	MOV	BYTE PTR [SI+15],AH	;put the mate number in the string
	MOV	BYTE PTR [SI+16],AL
	MOV	CX,17
	JMP	LOADIT
TRY_SHPROM:
	CMP	DL,NO_SHADOW_PROM	;Does the drive have the shadow prom?
	JNZ	TRY_OFFLINE		;Yes -- must be "OFFLINE"
	MOV	SI,OFFSET NOPROM	;Load no shadow prom message
	MOV	CX,14
	JMP	LOADIT
TRY_OFFLINE:
	MOV	SI,OFFSET OFFLN 	;load offline message
	MOV	CX,7
;
LOADIT: CLD
	REP	MOVSB
;
;  Now get the drive size
;
	POP	SI			;restore index to %SRVTBL
	XOR	DX,DX
	MOV	DL,BYTE PTR [SI+SRVRSIZ]     ;get d
	MOV	AX,WORD PTR [SI+SRVRSIZ+1]   ;get lsb and msb
	MOV	CL,4
	SHR	DX,CL			;convert d to normal number
	MOV	BX,TWOK
	DIV	BX
	MOV	CX,DT_TBLSZ		;number of entries in the %DRVTBL
	MOV	DI,OFFSET %DRVTBL
DS0100: CMP	AL,BYTE PTR [DI]
	JE	DS0140
	ADD	DI,DT_ENTSIZ		;get the next entry in the table
	LOOP	DS0100
	MOV	DI,OFFSET %DRVTBL	;drive not found, default to "??MB"
DS0140: ADD	DI,DT_OUTPUT		;point to the output string in the tbl
	MOV	BX,OFFSET ODLINE	;point to the output line again
	MOV	AL,[DI]
	MOV	BYTE PTR [BX+35],AL
	MOV	AL,[DI+1]
	MOV	BYTE PTR [BX+36],AL
	MOV	AL,[DI+2]
	MOV	BYTE PTR [BX+37],AL
	MOV	AL,[DI+3]
	MOV	BYTE PTR [BX+38],AL
;
;  Output the status line to the screen now
;
	MOV	DX,OFFSET ODLINE	;point to the output line again
	CALL	PRNTCLR 		;output the status line
;
	ADD	SI,ENTRYSZ		;point to next entry in %SRVTBL
	POP	CX
	INC	CX
	POP	DX
	INC	DH			;inc cursor row position
	CMP	CX,6			;
	JNZ	DONEYT
	MOV	DX,ODLPOS
	ADD	DL,41			;write on the right half of the screen
DONEYT: CMP	CX,WORD PTR %NUMOD	;have we done them all yet?
	JG	ADDLIN			;yes -- so lets get out of here
	JMP	GETNXT			;no -- so do it again
ADDLIN: MOV	DX,OFFSET CRLF		;add a blank line
	CALL	PRNTSTR 		;
	RET
SHOW_OD_STATUS	ENDP
;
;
;
;************************************************************************
;*									*
;* procedure:	GET_STATUS						*
;*									*
;* input:	DX = node number					*
;*									*
;* output:	DH = Mate number					*
;*		DL = Drive type 					*
;*									*
;* updates:								*
;*									*
;* destroys:	BX, DL, SI						*
;*									*
;************************************************************************
;
GET_STATUS	PROC	NEAR

	PUSH	DS
	LDS	BX,DWORD PTR CORPTR	;get pointer to CORTAb
	MOV	SI,WORD PTR [BX+SHDO_OFST]  ;point to SHADOW_TBL ptr in CORDRV
	ROL	DX,1			;convert node number to table offset
	ADD	SI,DX			;
	MOV	DX,[SI] 		;get the drive type and mate number
	POP	DS
	RET

GET_STATUS	ENDP
;
;
;
;************************************************************************
;*									*
;* procedure:	CNVRT_SRVR						*
;*									*
;* input:	AX = Server number to convert to ASCII			*
;*									*
;* output:	AX = ASCII representation of server number.		*
;*		     AH = tens digit, AL = ones digit			*
;*									*
;* updates:								*
;*									*
;* destroys:	AX, CL							*
;*									*
;************************************************************************
;
CNVRT_SRVR	PROC	NEAR
;
	PUSH	BX
;
;  Convert the server number in AX to ASCII with AH holding the tens
;  digit and AL holding the ones digit.
;
	MOV	BX,3030H			; set up default to "00"
	CMP	AX,0				; do range testing on the srvr
	JLE	CS_END				; ... number to make sure it
	CMP	AX,63				; ... falls between 0-63.
	JG	CS_END
;
	MOV	CL,10				; divide the number by 10
	DIV	CL				; AL = quotient, AH = remainder
	XCHG	AH,AL				; put tens in AH, ones in AL
	XCHG	BX,AX				; put value in BX to work with
	ADD	BX,3030H			; convert tens and ones to ASCII
;
CS_END: MOV	AX,BX				; set up return value
	POP	BX
	RET
;
CNVRT_SRVR	ENDP
;
;
;
;************************************************************************
;*									*
;* procedure:	TEMPLT							*
;*									*
;* input:	Put up the template for displaying the current		*
;*		sector being read/written and the total number		*
;*		of sectors to do.					*
;*									*
;* output:								*
;*									*
;* updates:								*
;*									*
;* destroys:	AX, DX							*
;*									*
;************************************************************************
;
TEMPLT	PROC	NEAR

	MOV	DX,TEMPOS1			;position the cursor for line 1
	CALL	POSCUR
	MOV	DX,OFFSET TEMSTR5		;draw line 1 of the template
	CALL	PRNTCLR 			;
	MOV	DX,TEMPOS2			;position the cursor for line 2
	CALL	POSCUR
	MOV	DX,OFFSET TEMSTR2		;draw line 2 of the template
	CALL	PRNTCLR 			;
	MOV	DX,TEMPOS3			;position the cursor for line 3
	CALL	POSCUR
	MOV	DX,OFFSET TEMSTR3		;draw line 3 of the template
	CALL	PRNTCLR 			;
	MOV	DX,TEMPOS3			;position the cursor for line 3
	ADD	DL,21
	CALL	POSCUR
	MOV	DX,OFFSET TEMSTR3		;draw line 3 of the template
	CALL	PRNTCLR 			;
	MOV	DX,TEMPOS3			;position the cursor for line 3
	ADD	DL,41
	CALL	POSCUR
	MOV	DX,OFFSET TEMSTR3		;draw line 3 of the template
	CALL	PRNTCLR 			;
	MOV	DX,TEMPOS4			;position the cursor for line 4
	CALL	POSCUR
	MOV	DX,OFFSET TEMSTR4		;draw line 4 of the template
	CALL	PRNTCLR 			;
	RET
TEMPLT	ENDP

FND_PIPE_VOL	ENDP
