.LIST
; File: CDMOVASM.TEXT
; Date: 08-Feb-84

;-----------------------------------------------------------------------
;
; CDMOVE Routine for Transfer Utility
;
;	1.0  11-08-83  MCH  First release to LEF
;	1.1  11-20-83  MCH  Added flush of buffer on read error
;	1.2  12-13-83  LEF  Accept positive disk status codes as OK
;	1.3  02-08-84  LEF  Replace OPwho with OPinit
;	1.4  01-MAR-85 NOD  converted for IBM Macro Assembler use
;
;-----------------------------------------------------------------------
;
; Suggested Use:
;
; Subroutine CDMOVASM	 AX = opcode
;			 BX = ram address
;			 CX = debug buffer address
;			 DX = address of cspec;
;			      cspec = record
;				      shost, sdrive, saddh, saddl, scnth, scntl,
;				      dhost, ddrive, daddh, daddl, dcnth, dcntl
;
;				      shost  -- source host node number
;				      sdrive -- source drive number
;				      saddh  -- source address (high word)
;				      saddl  -- source address (low word)
;				      scnth  -- source count (high word)
;				      scntl  -- source count (low word)
;				      dhost  -- destination host node number
;				      ddrive -- dest. drive number
;				      daddh  -- dest. address (high word)
;				      daddl  -- dest. address (low word)
;				      dcnth  -- dest. count (high word)
;				      dcntl  -- dest. count (low word)
;
; common op-code values:	      values not supported now:  (maybe in future)
;
;    1 old   -> new			  3 new -> new
;    2 new   -> old			  7 new -> new1k
;    5 old   -> new1k  (backup) 	 11 new1k -> new
;   10 new1k -> old    (restore)	 15 new1k -> new1k
;   26 new1k -> ram    (read)
;   37 ram   -> new1k  (write)
;   74 new1k -> null   (verify)
;

IF1
	%OUT	<Including XFRIB.INC>
ENDIF

	JMP	CDMOVASM

;******************************************************************************
;
tm1com		EQU	120		; timeout constant (status)
tm2com		EQU	15		; timeout constant (read/write)
;
snull		EQU	128		; boolean flags in op-code param
dnull		EQU	64
sram		EQU	32
dram		EQU	16
s1k		EQU	8
d1k		EQU	4
snew		EQU	2
dnew		EQU	1

	PAGE
;
; error return codes (in errcode high byte)
;
omnierr 	EQU	1 * 256 	; omninet err (low byte has code)
readerr 	EQU	2 * 256 	; drive error (low byte has code)
writerr 	EQU	3 * 256 	; drive error (low byte has code)
strobTO 	EQU	4 * 256 	; strobe timeout
whoami		EQU	5 * 256 	; whoami cmd timeout
timeout 	EQU	6 * 256 	; general timeout
hostadd 	EQU	7 * 256 	; packet from wrong host
sofflin 	EQU	8 * 256 	; src dev offline (low byte has code)
dofflin 	EQU	9 * 256 	; dst dev offline (low byte has code)
;
; I/O port constants
;
rs		EQU	0248H
rr		EQU	0249H
rri		EQU	024BH
wc		EQU	0249H
wch		EQU	0248H
wcl		EQU	024AH
wri		EQU	024BH
;
; Omninet command codes
;
opsend		EQU	040H
opsetup 	EQU	0F0H
opendr		EQU	010H
opinit		EQU	020H
opwho		EQU	001H
opecho		EQU	002H
;
; omninet cmd structure
;
cmdcode 	EQU	0
cmdradd 	EQU	1
cmdsock 	EQU	4
cmddadd 	EQU	5
cmddlen 	EQU	8
cmdclen 	EQU	10
cmdhost 	EQU	11
clen		EQU	12
;
; omninet result structure
;
rescode 	EQU	0
reshost 	EQU	1
resdlen 	EQU	2
;
; result header (new protocol)
;
respid		EQU	4
restyp		EQU	6
resid		EQU	8
resnact 	EQU	10
reserr		EQU	13
rlen		EQU	16

	PAGE
;
; disk request data structure (new protocol)
;
reqpid		EQU	0
reqtyp		EQU	2
reqid		EQU	4
reqmed		EQU	6
reqhost 	EQU	8
reqsock 	EQU	9
reqm		EQU	10
reqn		EQU	12
reqdata 	EQU	14
reqlen		EQU	18
;
; go data structure (new protocol)
;
rgopid		EQU	0
rgotyp		EQU	2
rgoid		EQU	4
rgosock 	EQU	7
;
; cancel data structure (new protocol)
;
canpid		EQU	0
cantyp		EQU	2
canid		EQU	4
canrsn		EQU	6
canmed		EQU	8
;
; vector assignments in buffer ram
;
RDreqC		EQU	0
RDreqR		EQU	RDreqC + clen
RDresC		EQU	RDreqR + rlen
RDresR		EQU	RDresC + clen
WRreqC		EQU	RDresR + rlen
WRreqR		EQU	WRreqC + clen
WRresC		EQU	WRreqR + rlen
WRresR		EQU	WRresC + clen
WRrgoC		EQU	WRresR + rlen
WRrgoR		EQU	WRrgoC + clen
WRlasC		EQU	WRrgoR + rlen
WRlasR		EQU	WRlasC + clen
;
; data area assignments in buffer
;
RDreqD		EQU	WRlasR+rlen
WRreqD		EQU	RDreqD+reqlen
godata		EQU	WRreqD+reqlen
golen		EQU	8

memlen		EQU    godata+golen   ; length of data structure excluding fifo

rmedl		EQU	0		; new protocol cancel reason
rmedh		EQU	4		; (media wrong)
stmedia 	EQU	116		; data offset of media in status cmd

	page
;-----------------------------------------------------------------------
; variables
;-----------------------------------------------------------------------
cspecadr	DW	0
myhost		DB	0		; my omni addr
opcode		DW	0		; action to be performed
flush		DW	0		;					1.1
errcode 	LABEL	WORD		; return value (if error)
errcode_lo	DB	0
		DB	0

shost		DB	0		; copyspec record
sdrive		DB	0
saddh		DW	0
saddl		DW	0
scnth		DW	0
scntl		DW	0

dhost		DB	0
ddrive		DB	0
daddh		DW	0
daddl		DW	0
dcnth		DW	0
dcntl		DW	0

ramadd		DW	0
dbufadd 	DW	0

inptr		DB	0		; fifo state variables
outptr		DB	0
bufcnt		DW	0

timerl		DW	0		; timeout cntrs
timerh		DW	0

smedia		LABEL	WORD
sm_lo		DB	0		; media id's
sm_hi		DB	0

dmedia		LABEL	WORD
dm_lo		DB	0
dm_hi		DB	0

save		DB	4096 DUP(0)	; image of transporter buffer
;**********************************************************************

	PAGE
;	.SALL

slowdown MACRO			; The IBM AT is to fast for the Corvus
	push	ax		; ...transporter.  Slow things down.
	pop	ax
	ENDM
;
set	MACRO	arg1,arg2	; sets (arg1) <- arg2
	mov	al, arg1	; arg1 is addr in buffer (0..255)
	mov	dx,wcl		; arg2 is byte value
	slowdown
	out	dx,al
	mov	al,arg2
	mov	dx,wri
	slowdown
	out	dx,al
	ENDM

nxt	MACRO	arg1		; put next sequential byte
	mov	al,arg1 	; valid only after set
	slowdown
	slowdown
	out	dx,al
	ENDM

tin	MACRO	arg1,arg2
	mov	dx,arg2
	slowdown
	slowdown
	in	al,dx
	mov	arg1,al
	ENDM

tout	MACRO	arg1,arg2
	mov	dx,arg1
	mov	al,arg2
	slowdown
	out	dx,al
	ENDM

chk	MACRO	arg1		; chk  al <- (arg1)
;	mov	al,<arg1>	; (v1.4 nod)
	mov	al, arg1	; (v1.4 nod)
	mov	dx,wcl
	slowdown
	out	dx,al
	mov	dx,rr
	slowdown
	slowdown
	in	al,dx
	ENDM

strob	MACRO	arg1,arg2	; strobe addr to transporter
;	mov	ax,<arg1>	; (v1.4 nod)
	mov	ax, arg1	; (v1.4 nod)
;	mov	bx,<arg2>	; (v1.4 nod)
	mov	bx, arg2	; (v1.4 nod)
	call	StrobIt
	ENDM

iferr	MACRO	arg1		; jump if error status
	or	al,al
	js	arg1
	ENDM

	PAGE
		  ; do we need another read?
readok	MACRO
	LOCAL	$1A,$9A,$2A
	cmp	scntl,0
	jne	$1A
	cmp	scnth,0
	je	$9A
$1A:	cmp	bufcnt,5
	jg	$9A
	jl	$2A
	test	opcode,s1k
	jz	$2A
$9A:	jmp	chkdst
$2A:	nop
	ENDM

writeok MACRO			; do we need another write?
	LOCAL	$1B,$9B,$2B
	cmp	dcntl,0
	jne	$1B
	cmp	dcnth,0
	je	$9B
$1B:	cmp	bufcnt,1
	jl	$9B
	jg	$2B
	test	opcode,d1k
	jz	$2B
$9B:	jmp	chkdone
$2B:	nop
	ENDM

	PAGE
;-----------------------------------------------------------------------
; start of initialization
;-----------------------------------------------------------------------
CDMOVASM   PROC    NEAR
;
params:

	mov	opcode,ax	; save opcode
	mov	ramadd,bx	; save ram address
	mov	dbufadd,cx	; save debug buffer address
	mov	cspecadr,dx	; save cspec buffer address
				;
	mov	bx,dx		; save record (12 words)
	lea	di,shost	;
	mov	cx,20		;
$1:	mov	al,byte ptr [bx];
	mov	byte ptr [di],al;
	inc	bx		;
	inc	di		;
	loop	$1		;
				;
chks1k: test	opcode,s1k	; source device using 1k blocks?
	jz	chkd1k		; no, go on
				;
	mov	ax,saddl	; divide address by 2
	ror	ax,1		;
	and	ax,3FFFH	;
	mov	bx,saddh	;
	ror	bx,1		;
	jnc	$10		;
	and	bx,3FFFH	;
	or	ax,4000H	;
$10:	mov	saddl,ax	;
	mov	saddh,bx	;
				;
chkd1k: test	opcode,d1k	; destination device using 1k blocks?
	jz	savetb		; no, go on
				;
	mov	ax,daddl	; divide address by 2
	ror	ax,1		;
	and	ax,3FFFH	;
	mov	bx,daddh	;
	ror	bx,1		;
	jnc	$20		;
	and	bx,7FFFH	;
	or	ax,4000H	;
$20:	mov	daddl,ax	;
	mov	daddh,bx	;

	PAGE
savetb: tout	wch,0		; save transporter buffer (4k)
	mov	dx,wcl		; in ram
	slowdown
	out	dx,al		;
	mov	dx,rri		;
	lea	bx,save 	;
	mov	cx,4096 	;
$30:	in	al,dx		;
	mov	byte ptr [bx],al	 ;
	inc	bx		;
	loop	$30		;
	tout	wch,0		;
				;
; ----- set	0,opwho 	; who am i command (at 0)		1.3
	set	0,opinit	; init command (at 0)			1.3
	nxt	  0		; *
	nxt	  0		; *
	nxt	  4		; *
	mov	ax,0		; cmd addr
	mov	bx,4		; res addr
	mov	lastbx,0	; sync strobe
	call	StrobIt 	; *
	mov	lastbx,0	; sync strobe
				;
	mov	errcode,whoami	; mesg - whoami timeout
	mov	cx,0		; cx is timeout cntr
	chk	4		;
	slowdown
	slowdown
$40:	in	al,dx		;
	slowdown
	cmp	al,0FFH 	;
	jne	$50		;
	loop	$40		;
	jmp	error		; timeout, report error
$50:	in	al,dx		;
	mov	myhost,al	; save our transporter number
	tout	wch,0		; clear buffer [0..1023] to all zeros
	mov	dx,wcl		;
	slowdown
	out	dx,al		;
	mov	dx,wri		;
	lea	bx,save 	;
	mov	cx,1024 	;
$60:	out	dx,al		;
	inc	bx		;
	slowdown
	loop	$60		;
	tout	wch,0		;

	PAGE
newinit:
	set	RDreqC+cmdcode,opsend	; omninet cmd vector - read request
	set	RDreqC+cmdradd+2,RDreqR ; *
	set	RDreqC+cmdsock,080H	; *
	set	RDreqC+cmddadd+2,RDreqD ; *
	set	RDreqC+cmddlen+1,reqlen ; *
					;
	set	RDresC+cmdcode,opsetup	; omninet cmd vector - read result
	set	RDresC+cmdradd+2,RDresR ; *
	set	RDresC+cmdsock,0A0H	; *
	set	RDresC+cmdclen,rlen-4	; *
					;
	set	WRreqC+cmdcode,opsend	; omninet cmd vector - write request
	set	WRreqC+cmdradd+2,WRreqR ; *
	set	WRreqC+cmdsock,080H	; *
	set	WRreqC+cmddadd+2,WRreqD ; *
	set	WRreqC+cmddlen+1,reqlen ; *
	set	WRreqC+cmdhost,dhost	; *
					;
	set	WRresC+cmdcode,opsetup	; omninet cmd vector - write result
	set	WRresC+cmdradd+2,WRresR ; *
	set	WRresC+cmdsock,0A0H	; *
	set	WRresC+cmdclen,rlen-4	; *
					;
	set	WRrgoC+cmdcode,opsetup	; omninet cmd vector - go recieve
	set	WRrgoC+cmdradd+2,WRrgoR ; *
	set	WRrgoC+cmdsock,080H	; *
	set	WRrgoC+cmddadd+2,godata ; *
	set	WRrgoC+cmddlen+1,golen	; *
					;
	set	WRlasC+cmdcode,opsend	; omninet cmd vector - last send
	set	WRlasC+cmdradd+2,WRlasR ; *
	set	WRlasC+cmdclen,rlen-4	; *
	set	WRlasC+cmdhost,dhost	; *
					;
	set	RDreqD+reqpid,001H	; request data for read
	nxt		      0FFH	; *
	nxt		      000H	; *
	nxt		      001H	; *
	set	RDreqD+reqhost,myhost	; *
	set	RDreqD+reqsock,0A0H	; *
					;
	set	WRreqD+reqpid,001H	; request data for write
	nxt		      0FFH	; *
	nxt		      000H	; *
	nxt		      001H	; *
	set	WRreqD+reqhost,myhost	; *
	set	WRreqD+reqsock,0A0H	; *
					;
	set	WRlasR+respid,001H	; request data for last
	nxt		      0FFH	; *
	nxt		      000H	; *
	nxt		      002H	; *

	PAGE
;-----------------------------------------------------------------------
; get source device status
;-----------------------------------------------------------------------
chksdev:
	test	opcode,snew		; new protocol?
	jnz	$70			; yes, go on
	jmp	chkddev 		; bypass if old protocol
					;
$70:	set	RDreqC+cmdhost,shost	; set host number
	set	RDreqD+reqm+1,2 	; set request length
	set	RDreqD+reqn+1,128	; set result length
	set	RDreqD+reqdata,010H	; set status command
	nxt		       001H	; set drive 1
					;
	set	RDresC+cmddlen+1,128	; put 128 bytes at 200H
	set	RDresC+cmddadd+1,1	; *
				;
	strob	RDresC,RDresR	; status results expected on A0 (strobe rdres)
rstat:	strob	RDreqC,RDreqR	; send status request (strobe rdreq)
				;
	mov	errcode,sofflin ; error - source device offline
	mov	bx,tm1com	; set timeout counter			1.2
$80:	chk	RDresR		; status come in?
	or	al,al		; *
	je	$100		; yes, check status
	loop	$80		; wait some more if not timeout
	dec	bx		; *
	jne	$80		; *
$90:	jmp	error		; timeout, report error
				;
$100:	chk	RDresR+reserr	;
	mov	errcode_lo,al	; save possible error status		1.2
	iferr	$90		; status cmd error			1.2
				; retrieve correct media from status
	tout	wch,((100H+stmedia)/256)
;	tout	wcl,((100H+stmedia) mod 256)	;v1.4
	mov	al,(100h+stmedia) mod 256	;v1.4
	tout	wcl,al				;v1.4
;	tin	smedia,rri	;
	tin	ah,rri		;v1.4
	slowdown
	slowdown
	in	al,dx		;
;	mov	smedia+1,al	;v1.4
	xchg	ah,al		;v1.4
	mov	smedia,ax	;v1.4
	tout	wch,0		;

	PAGE
;-----------------------------------------------------------------------
; get destination device status
;-----------------------------------------------------------------------
chkddev:
	test	opcode,dnew		; new protocol?
	jnz	$110			; yes, go on
	jmp	oldinit 		; bypass if old protocol
					;
$110:	set	RDreqC+cmdhost,dhost	; set host number
	set	RDreqD+reqm+1,2 	; set request length
	set	RDreqD+reqn+1,128	; set result length
	set	RDreqD+reqdata,010H	; set status command
	nxt		       001H	; set drive 1
					;
	set	RDresC+cmddlen+1,128	; put 128 bytes at 200H
	set	RDresC+cmddadd+1,2	; *
				;
	strob	RDresC,RDresR	; status results expected on A0 (strobe rdres)
wstat:	strob	RDreqC,RDreqR	; send status request (strobe rdreq)
				;
	mov	errcode,dofflin ; error - destination device offline
	mov	bx,tm1com	; set timeout counter			1.2
$120:	chk	RDresR		; status come in?
	or	al,al		; *
	je	$160		; yes, check status
	loop	$120		; wait some more if not timeout
	dec	bx		; *
	jne	$120		; *
$140:	jmp	error		; timeout, report error
				;
$160:	chk	RDresR+reserr	;
	mov	errcode_lo,al	; save possible error status		1.2
	iferr	$140		; status cmd error			1.2
				; retrieve correct media from status
	tout	wch,((200H+stmedia)/256)
;	tout	wcl,((200H+stmedia) mod 256)	;v1.4
	mov	al,(200h+stmedia) mod 256	;v1.4
	tout	wcl,al				;v1.4
;	tin	dmedia,rri	; v1.4
	tin	ah,rri		; v1.4
	slowdown
	slowdown
	in	al,dx		;
;	mov	dmedia+1,al	;
	xchg	ah,al		; v1.4
	mov	dmedia,ax	; v1.4
	tout	wch,0		;

	PAGE
oldinit:
	set	RDreqD+reqm,0		; default reads to new1k
	nxt		    4		;
	set	RDreqD+reqn,4		;
	nxt		    0		;
	set	RDreqD+reqdata,042H	; 1k read op-code
	set	RDresC+cmddlen,4	; 1k
	nxt		       0	;
	set	RDreqC+cmdhost,shost	;
					;
	set	WRreqD+reqm,4		; default writes to new1k
	nxt		    4		;
	set	WRreqD+reqdata,043H	; 1k write op-code
	set	WRlasC+cmddlen,4	; 1k
					;
	set	RDreqD+reqmed,sm_hi	; install media #s
	nxt		      sm_lo	;
	set	WRreqD+reqmed,dm_hi	; install media #s
	nxt		      dm_lo	;
					;
patch:	test	opcode,snew		; source device using new protocol?
	jz	$170			; no, then continue
	jmp	$180			; yes, bypass old protocol patches
					;
$170:	set	RDreqC+cmdsock,0B0H	; old protocol patches
	set	RDreqC+cmddlen,0	;
	nxt		       4	;
	set	RDreqC+cmdclen,4	;
	set	RDreqR+4,0		;
	nxt		 4		;
	nxt		 2		;
	nxt		 0		;
	set	RDreqD,32H		;
					;
	set	RDresC+cmdsock,0B0H	;
	set	RDresC+cmddlen,2	;
	set	RDresC+cmdclen,3	;
	jmp	$190			;
					;
$180:	test	opcode,s1k		; source device using 1k blocks?
	jnz	$190			; yes, go on
	set	RDresC+cmddlen,2	; patch for 512 with new
	set	RDreqD+reqn,2		;
	set	RDreqD+reqdata,032H	;

	PAGE
$190:	test	opcode,dnew		; destination device using new protocol?
	jz	$200			; *
	jmp	$210			; yes, bypass old protocol patches
					;
$200:	set	WRreqC+cmdsock,0B0H	; old protocol patches
	set	WRreqC+cmddlen,0	;
	nxt		       4	;
	set	WRreqC+cmdclen,4	;
	set	WRreqR+4,2		; old is always 512
	nxt		 4		;
	nxt		 0		;
	nxt		 0		;
	set	WRreqD,33H		;
					;
	set	WRresC+cmdsock,0B0H	;
	set	WRresC+cmddlen,0	;
	set	WRresC+cmdclen,3	;
					;
	set	WRlasC+cmdsock,0A0H	; last sends 512 to A0 (no hdr)
	set	WRlasC+cmddlen,2	;
	set	WRlasC+cmdclen,0	;
	set	WRrgoC+cmdsock,0B0H	;
	jmp	$220			;
					;
$210:	test	opcode,d1k		; destination device using 1k blocks?
	jnz	$220			; yes, go on
	set	WRlasC+cmddlen,2	; patch for 512 with new
	set	WRreqD+reqm,2		;
	set	WRreqD+reqdata,033H	;
					;
$220:	mov	bufcnt,0		; initialize state variables
	mov	inptr,4 		;
	mov	outptr,4		;
	set	RDresR,0FDH		;
	set	WRresR,0FDH		;
	set	WRrgoR,0FDH		;
					;
	mov	timerh,tm2com		; initialize timer
					;
	mov	flush,0 		;				1.1
;-----------------------------------------------------------------------
; end of initialization
;-----------------------------------------------------------------------

	PAGE
;-----------------------------------------------------------------------
; check source device activity
;-----------------------------------------------------------------------
chksrc: dec	timerl		; check for general timeout
	jnz	$240		;					1.1
	dec	timerh		;
	jne	$240		;					1.1
	mov	errcode,timeout ;
	jmp	error		;
				;
$240:	test	flush,0FFH	;					1.1
	jz	$260		;					1.1
	jmp	chkdst		; check destination device activity	1.1
				;
$260:	test	opcode,snull	; if snull then do nothing
	jz	$280		;
	mov	bufcnt,6	;
	mov	scntl,0 	;
	mov	scnth,0 	;
	jmp	chkdst		; check destination device activity
				;
$280:	test	opcode,sram	; if sram then copy from ram
	jnz	$290
	jmp	chkrd		;
				;
$290:	readok			;
	mov	cx,128		; copy one block to ram
	tout	wch,inptr	;
	tout	wcl,0		;
	mov	dx,wri		;
	mov	bx,ramadd	;
$300:	mov	al,byte ptr [bx];
	slowdown
	out	dx,al		;
	inc	bx		;
	mov	al,byte ptr [bx];
	slowdown
	out	dx,al		;
	inc	bx		;
	mov	al,byte ptr [bx];
	slowdown
	out	dx,al		;
	inc	bx		;
	mov	al,byte ptr [bx];
	slowdown
	out	dx,al		;
	inc	bx		;
	loop	$300		;
	tout	wch,0		;
	mov	ramadd,bx	; update ram addr
				;
	dec	scntl		; decrement read count
	jns	$320		; *
	dec	scnth		; *
	mov	scntl,7FFFH	; *
$320:	inc	bufcnt		; increment buffer index
	mov	al,inptr	; update fifo pointer
	add	al,2		; inptr + 2 (512)
	cmp	al,16		; ((inptr-4) mod 12) + 4
	jne	$340		;
	mov	al,4		;
$340:	mov	inptr,al	;
	jmp	chkdst		; check destination device activity

	PAGE
chkrd:	chk	RDresR		; read request complete?
	or	al,al		; *
	jz	gotrd		; yes, process returned read request
	cmp	al,0FDH 	; is read idle?
	jne	$360		; yes, check destination
	jmp	setupr		; setup next read request if possible
$360:	jmp	chkdst		; check destination device activity

;-----------------------------------------------------------------------
; process returned read request
;-----------------------------------------------------------------------
gotrd:	mov	timerh,tm2com	; initialize timer
	set	RDresR,0FDH	; just got read result - process it
	test	opcode,snew	; source device using new protocol?
	jnz	$380		;
				;---------------------------------------
				; packet from old protocol
				;---------------------------------------
	chk	RDresR+reshost	; did packet come from src server?
	cmp	shost,al	; *
	jne	$420		; no, report error
	chk	RDresR+6	; is drive status code ok?
	iferr	$400		; no, flush output buffer/report error	1.2
	jmp	$440		; go on 				1.2
				;---------------------------------------
				; packet from new protocol
				;---------------------------------------
$380:	chk	RDresR+reshost	; did packet come from src server?
	cmp	shost,al	; *
	jne	$420		; no, report error
	chk	RDresR+reserr	; is drive status code ok?
	iferr	$400		; no, flush output buffer/report error	1.2
	jmp	$440		; go on 				1.2
				;
$400:	mov	flush,ax	; src server error, flush output buffer 1.1
	jmp	chkdst		; *					1.1
				;
$420:	mov	errcode,hostadd ; mesg - packet from wrong host
	mov	errcode_lo,al	; mesg - save wrong host number 	1.2
	jmp	error		; report error
				;---------------------------------------
				; read successful
				;---------------------------------------
$440:	dec	scntl		; decrement read count
	jge	$460		; *
	dec	scnth		; *
	mov	scntl,7FFFH	; *
$460:	inc	bufcnt		; increment buffer index
	inc	saddl		; increment source address
	jns	$480		; *
	mov	saddl,0 	; *
	inc	saddh		; *

	PAGE
$480:	mov	al,inptr	;
	add	al,2		; inptr + 4 (1k)
	cmp	al,16		; ((inptr-4) mod 12) + 4
	jne	$500		;
	mov	al,4		;
$500:	mov	inptr,al	;
				;
	test	opcode,s1k	; source device using 1k blocks?
	jz	$540		; no, go on
				;
	dec	scntl		; decrement read count
	jge	$520		; *
	dec	scnth		; *
	mov	scntl,7FFFH	; *
$520:	inc	bufcnt		; increment buffer index
	mov	al,inptr	;
	add	al,2		; inptr + 4 (1k)
	cmp	al,16		; ((inptr-4) mod 12) + 4
	jne	$540		;
	mov	al,4		;
$540:	mov	inptr,al	;

;-----------------------------------------------------------------------
; setup next read request if possible
;	jmp	chkdst		; if we can't start another read
;-----------------------------------------------------------------------
setupr: readok			; can we read another chunk?
	set	RDresC+cmddadd+1,inptr
	mov	ax,saddl	;
	mov	bx,saddh	; note that pascal must divide addr by two if 1k
	ror	bx,1		;
	jnc	$560		;
	or	ax,8000H	;
$560:	mov	cl,4		;
	ror	bl,cl		;
	mov	cx,ax		;
	or	bl,sdrive	; now bl,cl,ch are the three magic bytes
	test	opcode,snew	; source device using new protocol?
	jnz	$580		; yes
				;
	set	RDreqD+1,bl	; old protocol
	nxt		 cl	; *
	nxt		 ch	; *
	jmp	$600		; ready to strobe
				;
$580:	set	RDreqD+reqdata+1,bl ; new protocol
	nxt			 cl ; *
	nxt			 ch ; *
				;
$600:	strob	RDresC,RDresR	; strobe rdres
	strob	RDreqC,RDreqR	; strobe rdreq

	PAGE
;-----------------------------------------------------------------------
; check destination device activity
;-----------------------------------------------------------------------
chkdst: test	opcode,dnull	; if dnull then do nothing
	jz	$620		;
	mov	bufcnt,0	;
	mov	dcntl,0 	;
	mov	dcnth,0 	;
	jmp	chkdone 	;
				;
$620:	test	opcode,dram	; if dram then copy to ram
	jnz	$630
	jmp	chkwr		;
				;
;-----------------------------------------------------------------------
; setup next write request if possible
;	jmp	chkdone 	; if we can't start another write
;-----------------------------------------------------------------------
$630:	writeok 		;
				;
	mov	cx,128		; copy one block to ram
	tout	wch,outptr	;
	tout	wcl,0		;
	mov	dx,rri		;
	mov	bx,ramadd	;
$640:	in	al,dx		;
	mov	byte ptr [bx],al;
	inc	bx		;
	slowdown
	in	al,dx		;
	mov	byte ptr [bx],al;
	inc	bx		;
	slowdown
	in	al,dx		;
	mov	byte ptr [bx],al;
	inc	bx		;
	slowdown
	in	al,dx		;
	mov	byte ptr [bx],al;
	inc	bx		;
	loop	$640		;
	tout	wch,0		;
	mov	ramadd,bx	; update ram addr
				;
	dec	dcntl		; decrement write count
	jns	$660		; *
	dec	dcnth		; *
	mov	dcntl,7FFFH	; *
$660:	dec	bufcnt		; decrement buffer index
	mov	al,outptr	; update fifo pointer
	add	al,2		; inptr + 2 (512)
	cmp	al,16		; ((inptr-4) mod 12) + 4
	jne	$680		;
	mov	al,4		;
$680:	mov	outptr,al	;
	jmp	chksrc		; check source device activity

	PAGE
chkwr:	chk	WRresR		; write status?
	or	al,al		;
	jz	gotwr		;
	mov	ah,al		;
	chk	WRrgoR		; go status?
	or	al,al		;
	jnz	$700		;
	jmp	gotgo		;
				;
$700:	cmp	ax,0FDFDH	; is write active?
	jne	$720		; no, check source device activity
	jmp	setupw		; setup next write request if possible
$720:	jmp	chksrc		; check source device activity

;-----------------------------------------------------------------------
; process returned write request
;-----------------------------------------------------------------------
gotwr:	mov	timerh,tm2com	; initialize timer
	set	WRresR,0FDH	; set write inactive flag
	test	opcode,dnew	; destination device using new protocol?
	jnz	$740		;
				;---------------------------------------
				; packet from old protocol
				;---------------------------------------
	chk	WRresR+reshost	; did packet come from dst server?
	cmp	dhost,al	;
	jne	$780		;
	chk	WRresR+6	; is drive status code ok?
	iferr	$760		; no, report error			1.2
	jmp	$800		; go on 				1.2
				;---------------------------------------
				; packet from new protocol
				;---------------------------------------
$740:	chk	WRresR+reshost	; did packet come from dst server?
	cmp	dhost,al	; *
	jne	$780		; no, report error
	chk	WRresR+reserr	; is drive status code ok?
	iferr	$760		; no, report error			1.2
	jmp	$800		; go on 				1.2
				;
$760:	mov	errcode,writerr ; mesg - write error
	mov	errcode_lo,al	; mesg - error code
	jmp	error		; report error
				;
$780:	mov	errcode,hostadd ; mesg - packet from wrong host
	mov	errcode_lo,al	; mesg - save wrong host number
	jmp	error		; report error
				;---------------------------------------
				; write successful
				;---------------------------------------
$800:	dec	dcntl		; decrement write count
	jge	$820		; *
	dec	dcnth		; *
	mov	dcntl,7FFFH	; *
$820:	dec	bufcnt		; decrement buffer index
	inc	daddl		; increment destination address
	jns	$840		; *
	mov	daddl,0 	; *
	inc	daddh		; *

	PAGE
$840:	mov	al,outptr	;
	add	al,2		; inptr + 4 (1k)
	cmp	al,16		; ((inptr-4) mod 12) + 4
	jne	$860		;
	mov	al,4		;
$860:	mov	outptr,al	;
				;
	test	opcode,d1k	; destination device using 1k blocks?
	jz	$900		; no, go on
				;
	dec	dcntl		; decrement write count
	jge	$880		; *
	dec	dcnth		; *
	mov	dcntl,7FFFH	; *
$880:	dec	bufcnt		; decrement buffer index
	mov	al,outptr	;
	add	al,2		; inptr + 4 (1k)
	cmp	al,16		; ((inptr-4) mod 12) + 4
	jne	$900		;
	mov	al,4		;
$900:	mov	outptr,al	;

;-----------------------------------------------------------------------
; setup next write request if possible
;	jmp	chkdone 	; if we can't start another write
;-----------------------------------------------------------------------
setupw: writeok 		; can we write another?
	set	WRlasC+cmddadd+1,outptr
	mov	ax,daddl	;
	mov	bx,daddh	; note that pascal must divide addr by two if 1k
	ror	bx,1		;
	jnc	$920		;
	or	ax,8000H	;
$920:	mov	cl,4		;
	ror	bl,cl		;
	mov	cx,ax		;
	or	bl,ddrive	; now bl,cl,ch are the three magic bytes
	test	opcode,dnew	; destination device using new protocol?
	jnz	$940		; yes
				;
	set	WRreqD+1,bl	; old protocol
	nxt		 cl	; *
	nxt		 ch	; *
	jmp	$960		; ready to strobe
				;
$940:	set	WRreqD+reqdata+1,bl ; new protocol
	nxt			 cl ; *
	nxt			 ch ; *
				;
$960:	strob	WRrgoC,WRrgoR	; strobe wrrgo
	strob	WRreqC,WRreqR	; strobe wrreq
	jmp	chksrc		; check source device activity

	PAGE
;-----------------------------------------------------------------------
; process returned read request
;-----------------------------------------------------------------------
gotgo:	set	WRrgoR,0FDH	; set write inactive flag
				;
	chk	WRrgoR+reshost	;
	cmp	dhost,al	;
	jne	$1000		;
				;
	test	opcode,dnew	; destination device using new protocol?
	jz	$980		; no
				;---------------------------------------
				; packet from new protocol
				;---------------------------------------
	tout	wcl,godata	;
	mov	dx,rri		;
	slowdown
	in	al,dx		;
	cmp	al,001H 	; go pid
	jne	$1000		;
	slowdown
	in	al,dx		;
	cmp	al,0FFH 	;
	jne	$1000		;
	slowdown
	in	al,dx		;
	cmp	al,001H 	; go msg type
	jne	$1000		;
	slowdown
	in	al,dx		;
	cmp	al,000H 	;
	jne	$1000		;
				;
	chk	godata+rgosock	; where to send last!
	mov	ah,al		;
	set	WRlasC+cmdsock,ah
				;
$980:	strob	WRresC,WRresR	; strobe wrres
	strob	WRlasC,WRlasR	; strobe wrlas
	jmp	chksrc		; check source device activity
				;
$1000:	strob	WRrgoC,WRrgoR	; strobe wrrgo again (wrong packet came in)
	jmp	chksrc		; check source device activity

	PAGE
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
chkdone:test	scntl,0FFFFH	; is move complete?
	jne	$1020		; no
	test	scnth,0FFFFH	; *
	jne	$1020		; no
	test	dcntl,0FFFFH	; *
	jne	$1020		; no
	test	dcnth,0FFFFH	; *
	jne	$1020		; no
	jmp	doneok		; finished, get ready to exit
				;
$1020:	test	flush,0FFH	; flushing write buffer?		1.1
	jne	$1060		; yes, check if finished		1.1
				;					1.1
$1040:	jmp	chksrc		; check source device activity		1.1
				;					1.1
$1060:	test	bufcnt,0FFH	; finished writing to destination?	1.1
	jne	$1040		; no, check source device activity	1.1
	mov	errcode,readerr ; mesg - read error			1.1
	mov	ax,flush	; mesg - error code			1.1
	mov	errcode_lo,al	; *					1.1
	jmp	error		; report error				1.1

	PAGE
error:
	jmp	retrn		;
				;
doneok: mov	errcode,0	;
				;
retrn:
				;
cks1k:	test	opcode,s1k	; source device using 1k blocks?
	jz	ckd1k		; no, go on
				;
	mov	ax,saddh	; multiply address by 2
	rol	ax,1		;
	and	ax,0FFFEH	;
	mov	bx,saddl	;
	rol	bx,1		;
	jns	$1080		;
	and	bx,7FFEH	;
	or	ax,1		;
$1080:	mov	saddh,ax	;
	mov	saddl,bx	;

ckd1k:	test	opcode,d1k	; destination device using 1k blocks?
	jz	retrcd		; no, go on
				;
	mov	ax,daddh	; multiply address by 2
	rol	ax,1		;
	and	ax,0FFFEH	;
	mov	bx,daddl	;
	rol	bx,1		;
	jns	$1100		;
	and	bx,7FFEH	;
	or	ax,1		;
$1100:	mov	daddh,ax	;
	mov	daddl,bx	;
				;
retrcd: mov	bx,cspecadr	; return record (12 words)
	lea	di,shost	;
	mov	cx,20		;
$1120:	mov	al,byte ptr [di];
	mov	byte ptr [bx],al;
	inc	bx		;
	inc	di		;
	loop	$1120		;

	page
debug:	mov	bx,dbufadd	;
	mov	ax,[bx] 	;
	or	ax,ax		;
	jz	$1160		;
				;
	tout	wch,0		; copy transporter buffer (4k)
	mov	dx,wcl		; to dbuf (for debugging only)
	out	dx,al		; first byte=0 means dont
	mov	dx,rri		;
	mov	cx,4096 	;
	mov	ah,0		;
$1140:	in	al,dx		;
	mov	[bx],ax 	;
	inc	bx		;
	inc	bx		;
	slowdown
	loop	$1140		;
				;
$1160:	tout	wch,0		; restore buffer in transporter
	mov	dx,wcl		;
	out	dx,al		;
	mov	dx,wri		;
	lea	bx,save 	;
	mov	cx,4096 	;
$1180:	mov	al,byte ptr [bx]	 ;
	slowdown
	out	dx,al		;
	inc	bx		;
	loop	$1180		;
				;
	mov	ax,errcode
	ret

	page
;-----------------------------------------------------------------------
; strobe requires cmd vec addr in ax and result vec addr in bx
;-----------------------------------------------------------------------
saveax	DW	   0		   ;
lastbx	DW	   0		   ;
;
StrobIt LABEL NEAR
	mov	saveax,ax	;
				;
	mov	cx,0		; cx is timeout for all strobe
				;
	mov	errcode,strobTO ;
	mov	ax,lastbx	;
	or	ax,ax		;
	je	$1220		;
				;
	mov	dx,wcl		; check (lastsend)
	out	dx,al		;
	mov	dx,rr		;
	slowdown		;
$1200:	in	al,dx		; wait till last strobe loaded
	cmp	al,0FFH 	;     (or send finished)
	jne	$1220		;
	slowdown
	loop	$1200		;
	jmp	error		;
				;
$1220:	mov	lastbx,bx	; save res addr for next call
	tout	wcl,bl		;
	tout	wri,0FFH	; set result code to FF
				;
	mov	dx,rs		;
	slowdown
$1240:	in	al,dx		;
	test	al,080H 	;
	js	$1260		;
	slowdown
	loop	$1240		;
	jmp	error		;
$1260:	mov	dx,wc		;
	slowdown
	out	dx,al		; first byte is garbage
				;
	mov	dx,rs		;
	slowdown
$1280:	in	al,dx		;
	test	al,080H 	;
	js	$1300		;
	slowdown
	loop	$1280		;
	jmp	error		;
$1300:	mov	ax,saveax
;	tout	wc,saveax+1	; second is ah	v1.4
	tout	wc,ah		; second is ah	v1.4
				;
	mov	dx,rs		;
	slowdown
$1320:	in	al,dx		;
	test	al,080H 	;
	js	$1340		;
	slowdown
	loop	$1320		;
	jmp	error		;
$1340:	mov	ax,saveax	; v1.4
;	tout	wc,saveax	; third byte is al v1.4
	tout	wc,al		; third byte is al v1.4
				;
	ret			; return
;
;**********************************************************************
;
CDMOVASM   ENDP
.xlist
