
#define PLAT 1
#define INT 2
#define BUS 3
#define DEV 4

//PLATFORM
#define UNKNOWN 0
#define SHARK 1
#define NAUTILUS 2
#define SWORDFISH 3
#define SWORDFISH_PLUS 4

//BUS
#define CCHIP 1
#define ALI15X3 2

//BUS stat
#define BIT 4
#define PCF 8

//DEVICE
#define ADM9240 1
#define LM75 2

//STAT
#define OK 1
#define BROKEN 2 

#define __u8 unsigned char 
#define __u16 unsigned short 
#define __u32 unsigned int 
#define __s32 signed int 

struct sensor_config {
	int type, bus, addr, dev, stat;
	char *desc;
};

extern __s32 i2c_bus_write_quick(struct sensor_config *sensor, __u8 value);
extern __s32 i2c_bus_read_byte(struct sensor_config *sensor);
extern __s32 i2c_bus_write_byte(struct sensor_config *sensor, __u8 value);
extern __s32 i2c_bus_read_byte_data(struct sensor_config *sensor, __u8 command);
extern __s32 i2c_bus_write_byte_data(struct sensor_config *sensor, __u8 command, __u8 value);
extern __s32 i2c_bus_read_word_data(struct sensor_config *sensor, __u8 command);
extern __s32 i2c_bus_write_word_data(struct sensor_config *sensor, __u8 command, __u16 value);
extern __s32 i2c_bus_process_call(struct sensor_config *sensor, __u8 command, __u16 value);
extern __s32 i2c_bus_read_block_data(struct sensor_config *sensor, __u8 command, __u8 *values);
extern __s32 i2c_bus_write_block_data(struct sensor_config *sensor, __u8 command, __u8 length, __u8 *values);

extern int bus_init(struct sensor_config*);
extern int dev_init(struct sensor_config*);
