/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

#include "lib.h"
#include "uilib.h"
#include "northbridge.h"
#include "lpt.h"


static int dev2base( io_dev D )
{
    switch( D ) {
	case DEV_LPT1:	return 0x378;
	case DEV_LPT2:	return 0x278;
	default:
    } return -1;
}


/*
 * lowest-level access mechanisms
 */

void lptwb( io_dev D, enum lptReg r, unsigned char v )
{
    int lpt = dev2base( D );
    if ( lpt == -1 )            return;

    outportb( lpt + r, v );
}

unsigned char lptrb( io_dev D, enum lptReg r )
{
    int lpt = dev2base( D );
    if ( lpt == -1 )            return 0xFF;

    return inportb( lpt + r );
}

static BOOLEAN is_device_present( io_dev D )
{
    unsigned char status;
    int count = 0;
    const int char_timeout = 10000;

    for (;;) {                  /* timeout loop */

        /* probably no reason to do this, but hey */
        lptwb( D, LPT_CTRL, LPCR_SELECT | LPCR_FEED | LPCR_INIT );

        status = lptrb( D, LPT_STAT );
        if ( LP_NO_ERROR(status) && LP_READY(status) )   break;

        if (++count == char_timeout)		return FALSE;

        usleep(1);                              /* timeout delay */
    }
    return TRUE;
}



/* To initialise the parallel port, send initialise signal for 0.5us min */

DBM_STATUS initLpt( io_dev D )
{
    lptwb( D, LPT_CTRL, LPCR_SELECT | LPCR_FEED );	/* de-assert init */
    usleep( 100000 );					/* plenty of time */
    lptwb( D, LPT_CTRL, LPCR_SELECT | LPCR_FEED | LPCR_INIT );
							/* re-set init */
    usleep( 100000 );


    if ( is_device_present( D ) != TRUE ) {
        mobo_logf( LOG_WARN "LPT1: no connected device detected\n");
        return STATUS_FAILURE;
    }

    return STATUS_SUCCESS;
}


/* send a character, using the algorithm as described in the Undocumented PC,
 * chapter 14 */

static void lptoutchar( io_dev D, int c ) 
{
    int timeout = 5000000;
    int i;


    if ( is_device_present( D ) != TRUE ) {
	mobo_alertf("Printer error", "Printer is not responding");
	return;
    }

    /* output the char to the data port, wait > 0.5uS */
    lptwb( D, LPT_DATA, c );

    usleep(1);				/* says 0.5, but this is safe... */

    /* active STROBE, sleep > 0.5uS, set STROBE high again */
    lptwb( D, LPT_CTRL, LPCR_INIT | LPCR_SELECT | LPCR_FEED | LPCR_STROBE );

    usleep(1);

    /* DEBUG - make sure the printer is acknowledging */
    i = 0;
    while ( (lptrb( D, LPT_STAT ) & LPST_BUSY) != 0 )
    {
        if ( i++ == timeout )   {
                mobo_alertf("Printer error","LPT: not responding to strobe\r");
                return;
        }
        usleep(1);
    }


    /* de-assert strobe */
    lptwb( D, LPT_CTRL, LPCR_INIT | LPCR_SELECT | LPCR_FEED );


    /* When parport has ACK'ed, it will raise BUSY */
    i = 0;
    while ( (lptrb( D, LPT_STAT ) & LPST_BUSY) == 0 )
    {
        if ( i++ == timeout )   {
                mobo_alertf("Printer error", "LPT: not acknowledging...\r");
                return;
        }
        usleep(1);
    }

}

void putcLpt( io_dev D, int c )
{
    if ( c == '\n' || c == '\r' )
    {
	lptoutchar( D, '\n' );
	lptoutchar( D, '\r' );
    }
    else lptoutchar( D, c );
}

